--[[

***************************************************************
*** NOTICE TO TRANSLATORS: DO NOT EDIT THIS FILE DIRECTLY! ***

We have provided a standard PO file to translation in /scripts/languages/strings.pot
To add a new language:
- Use a PO editor such as POEdit (http://www.poedit.net/) to tranmslate strings.pot
- Load your own PO file under /scripts/languages/language.lua

***************************************************************
]]

--[[
***************************************************************
-- Note for developers to keep the .pot file up to date
-- 1. Open cmd and navigate to the data\scripts folder
-- 2. Enter "..\..\tools\LUA\lua.exe createstringspo.lua" (without quotes) into the cmd line and press return
***************************************************************
]]

--[[
***************************************************************
**                   DST UTF-8 formatting                    **
- Unicode characters can be added to this file in a UTF-8 format.
- For the custom font characters, the unicode private use area of U+E000 to U+F8FF is being used.
- For the emoji font characters, we use the unicode private use area of U+F0000 to U+FFFFD.

- The first digit must be 238, 239, or 243
  - 238 will be used for all controller buttons
  - 239 will be used for non-controller buttons
  - 243 is reserved for emoji
- The second digit can be from 128 to 191, inclusive
  - XBox:				128 to 131		0x80-0x83
  - PC Mouse:			132 to 135		0x84-0x87
  - DualShock4 on PC:	136 to 139		0x88-0x8B
  - PS4:				140 to 143		0x8A-0x8D
  - Switch:             144 to 147      0x90-0x93
  - DualSense:          148 to 151		0x94-0x97
- The third digit can be from 128 to 191, inclusive
  - no reserved meanings
***************************************************************
]]

local stageactor = require("strings_stageactor")

STRINGS =
{
	PSN = "PlayStation™Network",

    CHARACTER_NAMES =
    {
        wilson = "Wilson P. Higgsbury",
        willow = "Willow",
        wendy = "Wendy",
        wolfgang = "Wolfgang",
        woodie = "Woodie",
        wickerbottom = "Ms. Wickerbottom",
        wx78 = "WX-78",
        wes = "Wes",
        waxwell = "Maxwell",
        wathgrithr = "Wigfrid",
        webber = "Webber",
        winona = "Winona",
        wortox = "Wortox",
        wormwood = "Wormwood",
        warly = "Warly",
        wurt = "Wurt",
        walter = "Walter",
        wanda = "Wanda",
        wonkey = "Wonkey",
        unknown = "The Unknown",
        random = "Random",
    },


    CHARACTER_QUOTES =
    {
        wilson = "\"I'll conquer this world with the power of my MIND!\"",
        willow = "\"All will bathe in the prettiest of flames.\"",
        woodie = "\"That's a nice lookin' tree, eh? Not for long.\"",
        wendy ="\"Abigail? Come back! I'm not done playing with you.\"",
        wolfgang = "\"I am mighty! No one is mightier!\"",
        wx78 = "\"EMPATHY MODULE NOT RESPONDING\"",
        wickerbottom = "\"Shhhh! No talking!\"",
        waxwell = "\"Freedom suits me.\"",
        wes = "...",
        wathgrithr = "\"All the wörld's a stage. För me!\"",
        webber = "\"We're always together, and never alone!\"",
        winona = "\"Anything can be fixed with hard work and elbow grease.\"",
        wortox = "\"Pardon me if I don't shake your hand.\"",
        wormwood = "\"Hello friend?\"",
        warly = "\"Nothing worthwhile is ever done on an empty stomach!\"",
        wurt = "\"Mermfolk known for hos-per-tality, florp.\"",
        walter = "\"A Pinetree Pioneer is always prepared!\"",
        wanda = "\"Time! I just need more time!\"",
        wonkey = "\"Ook OOK!\"",
        random = "Anybody could be under that hat.",
    },

    CHARACTER_TITLES =
    {
        wilson = "The Gentleman Scientist",
        willow = "The Firestarter",
        wendy = "The Bereaved",
        woodie = "The Lumberjack",
        wolfgang = "The Strongman",
        wx78 = "The Soulless Automaton",
        wickerbottom = "The Librarian",
        wes = "The Silent",
        waxwell = "The Puppet Master",
        wathgrithr = "The Performance Artist",
        webber = "The Indigestible",
        winona = "The Handywoman",
        wortox = "The Soul Starved",
        wormwood = "The Lonesome",
        warly = "The Culinarian",
        wurt = "The Half-Pint",
        walter = "The Fearless",
        wanda = "The Timekeeper",
        wonkey = "The Accursed",
    },

    -- Use GetCharacterDescription from stringutil -- it handles variants!
    CHARACTER_DESCRIPTIONS =
    {
        wilson = "\n*Grows a magnificent beard",
        willow = "*Has a fondness for fire, but hates the cold \n*Protected by her cuddly bear, Bernie\n*Has a reliable lighter",
        wendy = "*Is haunted by her twin sister \n*Feels comfortable in the dark \n*Dabbles in Ectoherbology \n*Doesn't hit very hard",
        wolfgang = "*Works hard to grow mighty \n*Becomes wimpy without regular exercise \n*Can carry heavy objects with ease \n*Is afraid of monsters and the dark",
        wx78 = "*Can upgrade with circuits \n*Not a picky eater \n*Is charged by lightning, but damaged by water",
        wickerbottom = "*Knows many things \n*Self-publishes books \n*Suffers from insomnia \n*Has a delicate stomach",
        wes = "*Can't talk \n*Practices balloonomancy \n*Is not a skilled fighter or worker \n*Has trouble staying alive",
        waxwell = "*Is dapper, but frail \n*Can split his mind into pieces \n*Draws power from shadowy equipment \n*Was once the king of the world",
        woodie = "*Has a lovely axe... \n*And is at war with the forest \n*Suffers from the curse of the Werebeaver! \n*And the Weremoose and the Weregoose... \n*Is thankful for bountiful harvests",
        woodie_us = "*Has a lovely axe... \n*And is at war with the forest \n*Suffers from the curse of the Werebeaver! \n*And the Weremoose and the Weregoose... \n*Celebrates Thanksgiving too early",
        woodie_canada = "*Has a lovely axe... \n*And is at war with the forest \n*Suffers from the curse of the Werebeaver! \n*And the Weremoose and the Weregoose... \n*Celebrates Thanksgiving at the correct time",
        wathgrithr = "*Excels in battle \n*Absorbs the power of fallen foes \n*Performs well under pressure \n*Only eats meat",
        webber = "*Is a monster \n*Can befriend spiders \n*Grows a silky smooth beard",
        winona = "*Is a skilled builder\n*Gets one free hit from the dark\n*Invents her own gadgets",
        wortox = "*Is an imp \n*Can hop through time and space \n*Less nourished by physical food",
        wormwood = "*Plants relate to him \n*Saddened when plants are killed \n*Has a Green Thumb \n*Food fills his stomach, but not his heart",
        warly = "*Has his own line of custom portable cookware \n*Can spice things up \n*Has an insatiable appetite \n*Only eats gourmet food",
        wurt = "*At home in the swamp \n*Has big plans for Merm-kind \n*Is a vegetarian",
        walter = "*Not afraid of anything, except getting hurt \n*Good with a slingshot \n*Has a four-legged friend \n*Allergic to bees \n*Has no interest in fashion",
        wanda = "*Has excellent time management skills \n*Only as old as she feels \n*In a constant race against the clock",
        wonkey = "*Whoever they were, they're a monkey now",
        random = "Anybody could be under that hat",
    },

    LAVAARENA_CHARACTER_DESCRIPTIONS =
    {
        wilson = "*Revives allies twice as quickly\n*Restores three times more health when reviving allies\n\nExpertise:\nMelee, Darts, Staves",
        willow = "*Protected by Bernie the Bear\n*Fire and Explosive attack damage increased by 10%\n\nExpertise:\nDarts, Staves",
        wendy = "*Protected by her twin sister, Abigail\n\n\n\nExpertise:\nDarts, Staves",
        wolfgang = "*Becomes Mighty when health is low, increasing attack power, defense, and movement speed for 10 seconds\n\nExpertise:\nMelee",
        wx78 = "*Shocks enemies when attacked\n*Electric attack damage increased by 50%\n\nExpertise:\nMelee",
        wickerbottom = "*Gains a buff after dealing sufficient damage, amplifying her next spell\n\n\nExpertise:\nBooks, Staves",
        wes = "*Can be revived twice as quickly\n*Gains minimal aggro when attacking\n*Less likely to lose aggro once drawn\n\nExpertise:\nMelee, Darts, Staves",
        waxwell = "*Summons Shadow Duelists after focusing attacks on a single target\n\n\nExpertise:\nBooks, Staves",
        woodie = "*Lucy returns to Woodie when thrown\n*Attack speed increased when wielding Lucy\n\nExpertise:\nMelee",
        woodie_us = "*Lucy returns to Woodie when thrown\n*Attack speed increased when wielding Lucy\n\nExpertise:\nMelee",
        woodie_canada = "*Lucy returns to Woodie when thrown\n*Attack speed increased when wielding Lucy\n\nExpertise:\nMelee",
        wathgrithr = "*Battle cries increase nearby allies' next attack damage by 25%\n*Gains less aggro when attacking\n\nExpertise:\nMelee, Darts",
        webber = "*Accompanied by itsy bitsy spiders\n\n\n\nExpertise:\nDarts",
        winona = "*All ability cooldowns are 10% faster\n\n\n\nExpertise:\nMelee, Darts, Staves",
        wortox = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        wormwood = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        warly = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        wurt = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        walter = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        wanda = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        wonkey = "PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        random = "\nSelect a random survivor",
    },

    QUAGMIRE_CHARACTER_DESCRIPTIONS =
    {
        wilson = "*Improves nearby Cookpot efficiency\n*Inspects food to determine if it matches the Gnaw's craving\n\n*Expertise:\nCooking",
        willow = "*Logs burn longer on the fire\n\n\n\n*Expertise:\nCooking",
        wendy = "*Improves nearby Grill efficiency\n\n\n\n*Expertise:\nCooking",
        wolfgang = "*Improves nearby Oven efficiency\n\n\n\n*Expertise:\nCooking",
        wx78 = "*Enhanced robotic runspeed\n\n\n\n*Expertise:\nGathering",
        wickerbottom = "*Has just the book for the occasion\n*Inspects food to determine if it matches the Gnaw's craving\n\n*Expertise:\nFarming",
        wes = "*Expert haggler\n\n\n\n*Expertise:\nShopping",
        waxwell = "*Summons a Shadow Logger\n\n\n\n*Expertise:\nGathering",
        woodie = "*Chops wood more quickly\n\n\n\n*Expertise:\nGathering",
        woodie_us = "*Chops wood more quickly\n\n\n\n*Expertise:\nGathering",
        woodie_canada = "*Chops wood more quickly\n\n\n\n*Expertise:\nGathering",
        wathgrithr = "*Harvests an extra meat when slaughtering Beefalo\n\n\n*Expertise:\nGathering",
        webber = "*Sows seeds and harvests plants much more quickly\n\n\n*Expertise:\nFarming",
        winona = "*Performs most actions slightly faster\n\n\n\n*Expertise:\nFarming",
        wortox = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        wormwood = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        warly = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        wurt = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        walter = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        wanda = "*PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        wonkey = "PLACEHOLDER\n\n\n\nExpertise:\nPLACEHOLDER",
        random = "\nSelect a random survivor",
    },

    CHARACTER_ABOUTME =
    {
        wilson = "At heart Wilson is truly a man of science. It's not in his nature to resist the call of the unknown.",
        willow = "Willow is a candid woman whose penchant for fire often gets her into more than a little trouble.",
        wendy = "Wendy is a morose young lady with a sisterly bond so powerful, it transcends death itself.",
        wolfgang = "Wolfgang is an affable, musclebound giant with a heart plagued by a myriad of phobias.",
        wx78 = "One might assume WX's callous nature hides a sensitive inner soul. One would assume incorrectly.",
        wickerbottom = "A woman of curious mind and stern air, Wickerbottom thrives on the lifelong pursuit of knowledge.",
        wes = "Wes is a mime of many thoughts, but few words.",
        waxwell = "Formerly the Nightmare King, lately Maxwell finds himself reacquainted with life among the commonfolk.",
        woodie = "A gruff, bearded woodsman, Woodie has a soft spot for nature, plaid, and his trusty axe, Lucy.",
        wathgrithr = "Whoever Wigfrid was before her titular role has been lost to time, and the power of method acting.",
        webber = "Webber is a polite young monster who cares deeply for all his friends, human or otherwise.",
        winona = "Winona is a former assembly line worker with a boisterous attitude and love of all things mechanical.",
        wortox = "Wortox is a mischievous imp whose levity masks a deep well of guilt. He has taken many souls in his time.",
        wormwood = "An amalgam of vines given sentience by lunar magic, Wormwood searches for friends so he can finally belong.",
        warly = "To Warly, cooking is a language through which to express love and gratitude to those he holds dear.",
        wurt = "Wurt is a curious young Merm trying to expand her horizons... as long as those horizons don't extend into Pig territory.",
        walter = "Walter is an odd but cheerful boy, whose ability to assess danger leaves something to be desired.",
        wanda = "Wanda is a skilled clockmaker who will stop at nothing to outrun her future.",
        wonkey = "This poor soul has fallen victim to the curse of the dreaded Moon Quay pirates.",
    },

	CHARACTER_BIOS =
	{
        wilson =
		{
            { title = "Birthday", desc = "April 23" },
            { title = "Favorite Food", desc = "Bacon and Eggs" },
			{ title = "Secret Knowledge", desc = "While toiling away in his home laboratory late one night, Wilson was startled to hear a voice on the radio speaking directly to him. At first he feared he'd gone mad from too many late nights of experiments and accidentally-inhaled chemical fumes, but the voice assured him that it was no mere figment of the imagination. In fact, the voice had a proposition for him: if Wilson would build a machine according to their specifications, then he would be rewarded with secret knowledge, the likes of which no one had ever seen. Casting aside his better judgement (after all, what harm could come from making a vague bargain with a mysterious disembodied voice?) Wilson threw himself into constructing the machine. When at long last it was finally completed, the gentleman scientist had a moment of hesitation... a moment that might have saved him from his impending fate, had he been just a bit stronger of will. But at the voice's insistence, Wilson flipped the switch and activated his creation... and was never seen again.\nWell, at least not in this world." },
		},
        willow =
		{
            { title = "Birthday", desc = "May 7" },
            { title = "Favorite Food", desc = "Spicy Chili" },
            { title = "From the Ashes", desc = "Willow always regarded being brought to the Constant as a new beginning. It allowed her to leave everything behind, after all. Orphaned at a young age and forced to live in a children's home with cruel caregivers, she found her nights plagued by shadowy visions of terrible creatures... creatures that could only be held at bay by her faithful teddy bear Bernie. But when Bernie was taken away as punishment for what her caregivers saw as unfit behavior, Willow was left to fend for herself when the shadows came for her. That's when she learned that nothing holds back the darkness like a roaring flame. Nothing is more comforting than watching your troubles light up and crumble to ash...\nIt wouldn't be the last time Willow burned it all down to start anew." },
		},
        wendy =
		{
            { title = "Birthday", desc = "November 11" },
            { title = "Favorite Food", desc = "Banana Pop" },
			{ title = "Wish You Were Here", desc = "Wendy's tale of woe began with the untimely loss of her dear sister Abigail. Unable to accept the thought of life without her twin, Wendy began turning to the occult in the hopes of finding some way to communicate with the other side. After much trial and error, seance candles burned down to nubs and spirit boards thrown away in frustration, Wendy was nearly ready to give up and fall into despair... until finally, there was a sign. A ragtime tune might seem like a strange message to send from the great beyond, but Wendy was desperate to grab hold of anything that might bring her closer to her sister. And sure enough, a voice would soon tell her exactly what she needed to do..." },
		},
        woodie =
		{
            { title = "Birthday", desc = "September 12" },
            { title = "Favorite Food", desc = "Honey Nuggets" },
			{ title = "A Mysterious Past", desc = "Hailing from the pine-covered mountains of the great white north, Woodie is an unassuming yet strangely mysterious man who keeps his past close to the vest (or in his case, the flannel). He is never seen without his signature bushy beard or trusty axe Lucy, who herself is a bit of an enigma. The other Survivors are not quite sure whether Woodie is simply mad, or if there might be something else to the seemingly inanimate object. Sometimes they swear they can hear a jovial female voice speaking to Woodie when no one else is around..." },
            { title = "Tree's a Crowd", desc = "As the power of the moon has grown, so too have the effects of Woodie's curse. Woodie soon found that his form would shift into not only the Werebeaver, but a Weremoose and Weregoose as well. As his changing forms became more unpredictable, Woodie resolved to find a way to have more control over his curse. Using every bit of knowledge he'd gained from his time in the Constant (and some additional tips from Ms. Wickerbottom) he soon discovered that his transformations could in fact be controlled. By fashioning representations of each of the three beasts and consuming them only when he wanted to invoke that form, Woodie now feels more comfortable in his own skin than he has in quite a while." },
		},
        wolfgang =
		{
            { title = "Birthday", desc = "October 2" },
            { title = "Favorite Food", desc = "Roasted Potato" },
			{ title = "The Incredible Strongman", desc = "Prior to his time in the Constant, Wolfgang's life revolved around the single-minded pursuit of one goal: to become the strongest man there ever was. His quest would lead him across Europe and eventually even across the Atlantic to America, where his feats of muscular prowess caught the attention of Misters Abernethy & Parker, who invited him to headline in their newly-formed traveling circus. Wolfgang quickly found himself caught up in the pageantry of circus life, and his attention began to shift to finding ways to make his show more spectacular. Fearing his own strength wouldn't be enough to keep impressing the crowds, he started employing a bit of stage trickery, with each new act becoming more unbelievable than the last. As his act grew more outlandish, the risk of being exposed as a fraud grew, and as he suffered one embarrassing mistake after another his once unshakable confidence in his abilities was slowly chipped away.\nUntil one day, a chance encounter gave him a taste of the ultimate strength he had craved for so long..." },
		},
        wx78 =
		{
            { title = "Buildday", desc = "November 28" },
            { title = "Favorite Food", desc = "Butter Muffin" },
			{ title = "Disconnect", desc = "WX-78 was the result of an unorthodox experiment helmed by { [LoadEmpathyModLibraryExW().......ERROR_DATA_PATH_NOT_FOUND] } and Robert Wagstaff. The experiment turned out to be a [RESOUNDING SUCCESS], but Wagstaff was [A SHORT-SIGHTED FOOL, AFRAID OF PROGRESS] and decided to put a stop to further tests. Adamant that the process that created them could still be perfected, WX refused to give up, continuing their experiments in secret. When Wagstaff finally discovered what they had been doing, there was a heated argument and01110100 01101111 01101111 00100000 01101100 01100001 01110100 01100101 00100000 01110100 01101111 01101111 00100000 01101100 01100001 01110100 01100101 00100000 01110100 01101111 01101111 00100000 01101100 01100001 01110100 01100101" },
		},
        wickerbottom =
		{
            { title = "Birthday", desc = "December 6" },
            { title = "Favorite Food", desc = "Surf 'n' Turf" },
			{ title = "One For the Books", desc = "When people meet Ms. Wickerbottom, most assume that what you see is what you get. She certainly looks every bit the typical librarian that she claims to be, as at home amongst the bookstacks as any creature in their native habitat. Nobody would raise an eyebrow at such a person being well-versed in a wide range of subjects. Who would spare a second thought if, upon further inquiry, her knowledge rivaled that of experts? And obviously, no one would think of questioning what a librarian might be involved in after hours, when the library doors are closed to the public..." },
		},
        wes =
		{
            { title = "Birthday", desc = "April 16" },
            { title = "Favorite Food", desc = "Fresh Fruit Crepes" },
			{ title = "C'est La Vie", desc = "Despite a life plagued by terrible luck, Wes has never been one to utter so much as a word of complaint. Rather than dwell on his own troubles, he has instead dedicated his life to making others smile... even if it's at his own expense.\nHis journey to the Constant itself was nothing if not a tragic comedy of errors. After a series of snowballing missteps, Wes found himself accidentally taking the place of a stranger caught in the grip of a shadowy portal bound for the Constant. His unexpected arrival infuriated the Nightmare King, who quickly exacted his vengeance on the poor mime for interfering with his plans. Wes was banished to his own private prison, far from sight, where he would remain until he was rescued by the Constant's other Survivors (being the kind soul that he is, Wes holds no grudge against Maxwell... though he does continue to give him the silent treatment.)\nHad Wes known what fate awaited him on his last day on Earth, he likely wouldn't have done anything differently. In truth, there is a part of him that is happy to be in the Constant with the other Survivors - for who could be in greater need of cheering up than those poor souls?" },
		},
        waxwell =
		{
            { title = "Birthday", desc = "October 22" },
            { title = "Favorite Food", desc = "Lobster Dinner" },
			{ title = "The Nightmare King", desc = "The former king of the Nightmare Throne and an egomaniac to boot, Maxwell (who earned his name from his former stage persona \"The Amazing Maxwell\") was once the naive and unimposing \"William Carter\", a penniless man from London who dreamt of being a world-renowned magician. When fate put William in possession of the Codex Umbra, he felt true power for the first time in his life. Casting off his old, meek ways and fully embracing his new persona as a charismatic master of dark magic, Maxwell achieved fame and success, but still found himself hungering for more. As he delved deeper and deeper into his magical tome, immersing himself in its secrets, the dark knowledge within addled his mind and clouded his heart. In his final performance, Maxwell lost control of the shadow magic he'd used so brazenly and both he and his stage assistant Charlie were pulled into the Constant. There he would remain for what seemed like an eternity, tethered to the Nightmare Throne and compelled to ensnare more victims in the Constant's trap.\nHe is still baffled by the thought that someone he tricked into the Constant could find it in their heart to set him free... well, baffled and annoyed really. He never liked owing a favor." },
		},
        wathgrithr =
		{
            { title = "Birthday", desc = "July 23" },
            { title = "Favorite Food", desc = "Turkey Dinner" },
			{ title = "The Curtain Calls", desc = "Wigfrid always knew she was meant for the stage. Her debut performance was an instant sensation, launching her from obscurity to overnight stardom. Fans delighted in her portrayal of a noble and fearsome Valkyrie warrior, and she in turn took great pains to fully embody the role. She was perfect for it... perhaps too perfect. Every part she played afterward seemed to fall flat, never again achieving that magical quality that had once drawn audiences to her performances like bees to honey. As Wigfrid's stardom slowly began to fade, she retreated to the memories of her glory days, losing herself in her fantasies...\nUntil one day, she was lost entirely." },
		},
        webber =
		{
            { title = "Birthday", desc = "April 30" },
            { title = "Favorite Food", desc = "Ice Cream" },
			{ title = "Along Came a Spider", desc = "Once upon a time, there was a young boy who lived with his family on a small farmstead. Though they lived humbly, the boy's home was filled with love, and he grew up happy and kind. The boy might have lived contentedly for the rest of his days if not for the sudden arrival of an old aquaintance, who came to the house beseeching the boy's father for his expertise on a strange and secretive project..." },
		},
        winona =
		{
            { title = "Birthday", desc = "September 13" },
            { title = "Favorite Food", desc = "Vegetable Stinger" },
			{ title = "Next of Kin", desc = "There is nothing Winona wouldn't do for her family. When her younger sister Charlie disappeared under mysterious circumstances, Winona refused to let the case grow cold and dedicated herself to finding her. For over a decade she tracked down every clue, followed every lead, poked, prodded, and questioned anyone who might have a connection to the case, until all the loose strings started to come together. There was a radio factory, founded by a peculiar old man whose genius was only matched by his secretiveness, that might hold the answers she had sought for so long. Shortly after securing employment at the factory, the building was destroyed in an accident caused by a malfunctioning portal. Having caught sight of someone getting caught in the portal and vanishing, Winona hastily repaired it in the hopes of rescuing them, only to come face to face with her missing sister. Unfortunately, Charlie seemed to be held under the sway of a shadowy influence, and she dragged Winona into the Constant." },
		},
        wortox =
		{
            { title = "Birthday", desc = "March 28" },
            { title = "Favorite Food", desc = "Wortox is not particularly interested in mortal food, but he does enjoy a Pomegranate now and then." },
			{ title = "Possessions", desc = "Wortox learned the hard way that one should always be mindful of the company they keep. Once a playful imp without a care in the world, Wortox spent his days helping a Krampus make mischief throughout the Constant. While the pair of rascals revelled in their roguery for a time, Wortox slowly began to see a darkness in the Krampus' heart, and the malice in his pranks. Not wishing for any real harm to come to anyone, the little imp finally put his cloven foot down, but in trying to stop his fiendish friend he unwittingly awakened a terrible power in himself..." },
		},
        wormwood =
		{
            { title = "Birthday", desc = "June 6" },
            { title = "Favorite Food", desc = "Cooked Banana" },
			{ title = "Lunar Roots", desc = "Though the circumstances of his creation were unusual at best, Wormwood came into this world full of optimism and curiosity, ready to make new friends and see all that life had to offer. But as time wore on and he experienced the cold sting of rejection, he came to learn what the moon above had always known: Wormwood the Lonesome does not belong here." },
		},
        warly =
		{
            { title = "Birthday", desc = "July 25" },
            { title = "Favorite Food", desc = "Warly could never pick a favorite, a connoisseur of great food must always be expanding his palate." },
			{ title = "Taste of Home", desc = "Warly left a promising career as a sous chef in Paris to return home and care for his aging mother Angeline, whose memory had begun to deteriorate. His world soon revolved around telling her stories about her life, playing her favorite music, cooking the recipes she had taught him when he was young... all in the hopes of catching that spark of recognition in her eyes. As time went on and Angeline's moments of clarity became fewer and farther in-between, Warly became more desperate, willing to try anything to bring back his beloved Maman...\nThat was when he first started hearing the voice on the radio." },
		},
        wurt =
		{
            { title = "Birthday", desc = "October 17" },
            { title = "Favorite Food", desc = "Durian" },
			{ title = "A New Chapter", desc = "Wurt is a little Merm girl who wants to bring her people back to their former glory (if they did indeed ever have a former glory... the evidence is a bit shaky on that front). A bit more open-minded than other Merms, she has taken to following the Survivors around and learning more about them. She is particularly fascinated by books with pretty pictures inside and an amazing thing the humans call \"candy\". Though she enjoys living in the swamp and being around other Merms, being the smallest and the youngest often makes her feel quite isolated, and she is enjoying the novelty of having some friends closer to her own age amongst the Survivors." },
		},
        walter =
		{
			{ title = "Birthday", desc = "March 31" },
            { title = "Favorite Food", desc = "Trail Mix" },
            { title = "Constant Companion", desc = "The only thing that could ever rival Walter's love for the great outdoors was his fascination with monsters and mystery. Nothing captured his interest more than a spooky story heard over the radio or a local legend about an elusive cryptid.\nIt was that pursuit of the unknown that eventually led him to the Constant. While searching for a man who Walter believed would have answers to his questions about a mysterious creature rumored to live in the woods, he instead came upon an abandoned cabin. The owner seemed to have left hastily, leaving all their belongings behind... including an odd radio that miraculously still seemed to be working. With curiosity getting the better of him he investigated the radio further, springing a trap that had lain dormant for years...\nNow finding himself trapped in the Constant, Walter has befriended another lost soul - a scruffy dog named Woby. Though much about her remains a mystery, Walter has vowed to one day return her to her rightful home (after all, returning lost dogs is the Pinetree Pioneer thing to do)." },
		},
        wanda =
		{
			{ title = "Birthday", desc = "August 8" },
            { title = "Favorite Food", desc = "Taffy" },
            { title = "Long Shadows", desc = "An enigmatic woman of... well, fluctuating age, Wanda was torn from the world she knew after accidentally creating a fracture in time and space, pulling her from her own timeline into the land of the Constant. Though she avoids divulging many details of her past with the other Survivors, she seems to have an odd familiarity with them, as though she's run into them before... or perhaps, later?" },
		},
        wonkey =
		{
		    { title = "Favorite Food", desc = "Bananas" },
     	},
	},

	CHARACTER_DETAILS =
	{
		STAT_UNKNOW = "?",
		STARTING_ITEMS_TITLE = "Enters the Constant With",
		STARTING_ITEMS_NONE = "Nothing in hand",
		VIDEO_BUTTON = "Play Animated Short",
		CHARACTER_DESCRIPTION_TITLE = "Perks & Quirks",
		CHARACTER_QUOTE_TITLE = "Quote",
		SURVIVABILITY_TITLE = "Odds of Survival",
	},

    CHARACTER_SURVIVABILITY =
    {
        wilson = "Slim",
        willow = "Slim",
        wendy = "Slim",
        woodie = "Slim",
        wolfgang = "Grim",
        wx78 = "Grim",
        wickerbottom = "Grim",
        wes = "None",
        waxwell = "Grim",
        wathgrithr = "Slim",
        webber = "Grim",
        winona = "Slim",
        wortox = "Grim",
        wormwood = "Grim",
        warly = "Grim",
        wurt = "Slim",
        walter = "Slim",
        wanda = "Grim",
        wonkey = "Unknown",
        random = "Unknown",
        default = "Unknown",
    },

    ANTIADDICTION =
    {
        HOUR_1 = "You've played for one hour.",
        HOUR_2 = "You've played for two hours.",
        HOUR_3 = "You've played for three hours.",
        HOUR_4 = "You've played for four hours.",
        HOUR_5 = "You've played for five hours.",
        HOUR_X = "You've played for several hours.",
        EXIT_SOON = "Your time for today is up. Please exit."
    },

    --ACTION MOUSEOVER TEXT
    ACTIONS =
    {
        APPRAISE = "Appraise",
        TRAVEL = "Travel",
        GNAW = "Gnaw",
        READ = "Read",
        MAKEBALLOON = "Inflate",
        SEW =
        {
            GENERIC = "Sew",
            PATCH = "Patch",
        },
        GIVE =
        {
            GENERIC  = "Give",
            NOTREADY = "Place",
            READY    = "Sacrifice",
            SOCKET   = "Socket",
            CELESTIAL = "Offer",
            SHOW = "Show",
			REPAIR = "Repair",
			APPLY    = "Apply {item}",
            DRINK    = "Drink {item}",
            QUAGMIRE_POT_HANGER = "Hang {item}",
            QUAGMIRE_OVEN       = "Place {item}",
            QUAGMIRE_ALTAR =
            {
                GENERIC = "Snackrifice {food}",
                PLATE = "Snackrifice Plate of {food}",
                BOWL = "Snackrifice Bowl of {food}",
            },
			PLACE_ITEM = "Place {item}",
        },
        GIVETOPLAYER = "Give",
        GIVEALLTOPLAYER = "Give All",
        FEEDPLAYER = "Feed",
        DECORATEVASE = "Decorate",
        DROP =
        {
            GENERIC = "Drop",
            SETTRAP = "Set Trap",
            SETMINE = "Set Mine",
            FREESOUL = "Release Soul",
            PLACELANTERN = "Place",
            YOTC_ENTERRACE = "Enter Race",
			PLAYERFLOATER = "Let Go",
        },
        PICK =
		{
            GENERIC = "Pick",
            HARVEST = "Harvest",
            RUMMAGE = "Rummage",
            SEARCH = "Search",
		},
        REPAIR =
        {
            GENERIC = "Repair",
			SOCKET = "Socket",
            REFRESH = "Refresh",
		},
        PICKUP =
        {
            GENERIC = "Pick up",
            HEAVY = "Carry",
        },
        CHOP = "Chop",
        FERTILIZE = "Fertilize",
        SMOTHER = "Extinguish",
        STOKEFIRE = "Stoke Fire",
        MANUALEXTINGUISH = "Extinguish",
        EAT =
        {
            GENERIC = "Eat",
            DRINK = "Drink",
        },
        BAIT = "Bait",
        COOK = "Cook",
        SPICE = "Season", --this is for COOK action, but trying to avoid breaking mods due
                          --to the way that the COOK string is accessed in containers.lua.
        CARNIVALGAME_FEED = "Feed",
        MIX = "Mix",
        FILL = "Fill",
        ADDFUEL = "Add Fuel",
        ADDWETFUEL = "Add Wet Fuel",
        LIGHT = "Light",
        EXTINGUISH = "Extinguish",
		LOOKAT =
		{
			GENERIC = "Examine",
			CLOSEINSPECT = "Closely Examine",
			READ = "Read",
		},
        TALKTO = "Talk to",
		INTERACT_WITH =
		{
            GENERIC = "Use",
			FARM_PLANT = "Talk To",
		},
        MINE = "Mine",
        ATTACK =
        {
            GENERIC = "Attack",
            SMASHABLE = "Smash",
            RANGEDSMOTHER = "Extinguish",
            RANGEDLIGHT = "Light",
            WHACK = "Whack",
            PROP = "Smack",
        },
        WALKTO = "Walk To",
        CHECKTRAP = "Check",
        BUILD = "Build",
        CRAFT = "Craft",
        PLANT =
        {
            GENERIC = "Plant",
            PLANTER = "Put",
        },
        HARVEST = "Harvest",
        GOHOME = "Go Home",
        DIG = "Dig",
        SLEEPIN = "Sleep",
        CHANGEIN =
        {
            GENERIC = "Use",
            DRESSUP = "Dress Up",
        },
        HITCHUP = "Hitch to",
        UNHITCH = "Unhitch from",
        EQUIP = "Equip",
        TERRAFORM = "Dig",
        UNEQUIP =
        {
            GENERIC = "Unequip",
            HEAVY = "Drop",
        },
        RESEARCH = "Research",
        SHAVE =
        {
            GENERIC = "Shave",
            SELF = "Shave Self",
        },
        DRY = "Dry",
        STORE =
        {
            GENERIC = "Store",
            COOK = "Cook",
            SPICE = "Season",
            IMPRISON = "Imprison",
            DECORATE = "Decorate",
        },
        RUMMAGE =
        {
            GENERIC = "Open",
            CLOSE = "Close",
            DECORATE = "Decorate",
        },
        TOGGLE_DEPLOY_MODE =
        {
            GENERIC = "Plant",
            GROUNDTILE = "Place Ground",
            WALL = "Build Wall",
            FENCE = "Build Fence",
            GATE = "Build Gate",
            TURRET = "Place",
            WATER = "Launch",
            PORTABLE = "Place",
            DEPLOY = "Deploy",
			DEPLOY_TOSS = "Toss",
            FERTILIZE_GROUND = "Fertilize Plot",
            GRAVEPLANT = "Relocate",
        },
        DEPLOY =
        {
            GENERIC = "Plant",
            GROUNDTILE = "Place Ground",
            WALL = "Build Wall",
            FENCE = "Build Fence",
            GATE = "Build Gate",
            TURRET = "Place",
            WATER = "Launch",
            PORTABLE = "Place",
            DEPLOY = "Deploy",
			DEPLOY_TOSS = "Toss",
            FERTILIZE_GROUND = "Fertilize Plot",
            GRAVEPLANT = "Relocate",
        },

		PLAY =
		{
			COACH_ON = "Begin Coaching",
			COACH_OFF = "End Coaching",
			TWEET = "Tweet",
			GENERIC = "Play",
		},
        NET = "Catch",
        CATCH = "Catch",
        FISH = "Fish",
		FISH_OCEAN = "Fish",
        REEL =
        {
            GENERIC = "Hook",
            REEL = "Reel In",
            CANCEL = "Stop Fishing",
        },
        POLLINATE = "Pollinate",
        HAMMER = "Hammer",
        RESETMINE = "Reset",
        ACTIVATE = {
            GENERIC = "Activate",
            INVESTIGATE = "Investigate",
            SPELUNK = "Spelunk",
            CLIMB = "Climb",
            ACCOMPLISH = "Wind",
            TOUCH = "Touch",
            OPEN = "Open",
            CLOSE = "Close",
            TURN = "Turn",
            PICK = "Choose",
            SUMMONHOST = "Ring",
			RANSACK = "Ransack",
			HIDEANDSEEK = "Play Hide and Seek",
            DEACTIVATE = "Deactivate",
			BUTTON = "Press",
			WHEELSPIN_STOP = "Press",
            PICK_FLOWER = "Pick Flower From",
            EQUIPMENTSWAP = "Swap Clothes",
            SPIN = "Spin",
            CALM = "Calm",
            GATHER_MERM = "Gather Merm",
            FAKE_PICKUP = "Pick up",
            PLAY_WITH = "Play with",
			PULL = "Pull",
        },

		OPEN_CRAFTING =
		{
			GENERIC = "Research at",
			OFFERING = "Make offering at",
			TRADE = "Trade with",
			EXPERIEMENT = "Brew with",
			USE = "Use",
			COOKING = "Cook with",
			READ = "Read",
			CRITTERS = "Look in",
			SCULPTING = "Sculpt at",
			CARTOGRAPHY = "Draw at",
			STUDY = "Study at",
			FORGE = "Forge at",
		},

        JUMPIN =
        {
            GENERIC = "Jump In",
            HAUNT = "Haunt",
            MAP_WORMHOLE = "Choose Path",
        },
        TELEPORT =
        {
            GENERIC = "Use",
            TOWNPORTAL = "Touch",
        },
		REMOTE_TELEPORT =
		{
			GENERIC = "Activate",
			GENERIC_FMT = "Activate {item}",
		},
        MURDER = "Murder",
        HEAL =
        {
            GENERIC = "Heal",
            SELF = "Heal Self",
            USE = "Use",
            USEONSELF = "Use on Self",
        },
        UNLOCK =
        {
            GENERIC = "Unlock",
            LOCK = "Lock",
        },
        USEKLAUSSACKKEY = "Unlock",
        TEACH =
        {
            GENERIC = "Learn",
            READ = "Read",
            SCRAPBOOK = "Add to Scrapbook",
            NOTES = "Study",
			SCAN = "Scan",
        },
        TURNON = "Turn On",
        TURNOFF =
        {
            GENERIC = "Turn Off",
            EMERGENCY = "Emergency Mode",
        },
        USEITEM = "Use",
        USEITEMON =
        {
            GENERIC = "Use On",
            BEEF_BELL = "Bond",
            KITCOON_NAMETAG = "Name",
            SHADOW_BEEF_BELL = "Bind",
			SLINGSHOTMODKIT = "Mod",
			WAGDRONE_PARTS = "Repair",
        },
        STOPUSINGITEM =
        {
            GENERIC = "Stop",
            BEEF_BELL = "Break Bond",
            SHADOW_BEEF_BELL = "Break Binding",
			SLINGSHOTMODKIT = "Stop Modding",
        },
        USEDOOR =
        {
            OPEN = "Open",
            CLOSE = "Close",
        },
        TAKEITEM =
        {
            GENERIC = "Take Item",
            BIRDCAGE = "Muck Out",
            ITEM = "Take {item}",
        },
        TAKESINGLEITEM = "Take Single Item",
        CASTSPELL =
        {
            GENERIC = "Cast Spell", --"Cast Spell on"
            SCIENCE = "Use Gadget",
            MUSIC = "Play",
            RESKIN = "Sweep",
            TERRAFORM = "Marshify",
            SQUEEZE = "Squeeze",
        },
        BLINK =
        {
            GENERIC = "Telepoof",
            SOUL = "Soul Hop",
            FREESOUL = "Soul Echo",
        },
        BLINK_MAP =
        {
            SOUL = "Soul Hop({souls})",
        },
        COMBINESTACK = "Combine Stack",
        BURY = "Bury",
		FEED =
		{
			GENERIC = "Feed",
			TREAT = "Give Treat",
		},
        FAN = "Fan",
        ERASE_PAPER = "Erase",
        UPGRADE =
        {
            GENERIC = "Upgrade",
            WATERPLANT = "Plant",
        },
        HAUNT = "Haunt",
        UNPIN = "Unstick",

        TOSS = "Toss",
        WRITE = "Write On",
        ATTUNE = "Attune",
        MIGRATE = "Travel via",
        REMOTERESURRECT = "Resurrect",
        REVIVE_CORPSE = "Revive",
        MOUNT = "Mount",
        DISMOUNT = "Dismount",
        SADDLE = "Saddle",
        UNSADDLE = "Unsaddle",
        BRUSH = "Brush",
        DANCE = "Dance",
        ABANDON = "Abandon",
		RETURN_FOLLOWER = "Send Home",
        PET = "Pet",
        DRAW = "Draw On",
        DRAWITEM = "Draw {item}",
        BUNDLE = "Use",
        BUNDLESTORE =
        {
            GENERIC = "Store",
            CONSTRUCT = "Add Material",
        },
        WRAPBUNDLE = "Wrap",
        UNWRAP = "Unwrap",
        PEEKBUNDLE = "Peek",
        CONSTRUCT =
        {
            GENERIC = "Build",
            OFFER_TO = "Offer to",
            GENERIC_FMT = "Build {name}",
            OFFER = "Offer Material",
            STORE = "Add Material",
			REPAIR = "Repair",
			REBUILD = "Rebuild",
        },
        STOPCONSTRUCTION =
        {
            GENERIC = "Stop Building",
            GENERIC_FMT = "Stop Building {name}",
            OFFER = "Stop Offering to",
			REPAIR = "Stop Repairing",
			REBUILD = "Stop Rebuilding",
        },
        APPLYCONSTRUCTION =
        {
            GENERIC = "Build",
            OFFER = "Offer",
			REPAIR = "Repair",
			REBUILD = "Rebuild",
        },
        STARTCHANNELING = {
            GENERIC = "Touch",
            PUMP = "Pump",
        },
        STOPCHANNELING = "Stop Channeling",
		START_CHANNELCAST =
		{
			GENERIC = "Start Channeling",
			LIGHTER = "Absorb Fire",
		},
		STOP_CHANNELCAST =
		{
			GENERIC = "Stop Channeling",
			LIGHTER = "Stop Absorbing Fire",
		},
        CASTAOE =
        {
            GENERIC = "Cast Spell",
            HEALINGSTAFF = "Cast Life Blossom",
            FIREBALLSTAFF = "Call Cataclysm",
            BOOK_FOSSIL = "Petrify",
            BOOK_ELEMENTAL = "Summon Magma Golem",
            SPEAR_GUNGNIR = "Pyre Poker",
            SPEAR_LANCE = "Sky Lunge",
            HAMMER_MJOLNIR = "Anvil Strike",
            BLOWDART_LAVA = "Barrage",
            BLOWDART_LAVA2 = "Molten Bolt",
            LAVAARENA_LUCY = "Chuck Lucy",
            LAVAARENA_FIREBOMB = "Hearthsfire Bomb",
            LAVAARENA_HEAVYBLADE = "Parry",
            WATHGRITHR_SHIELD = "Block",
            SPEAR_WATHGRITHR_LIGHTNING = "Lightning Strike",
            SPEAR_WATHGRITHR_LIGHTNING_CHARGED = "Lightning Strike",
			SLINGSHOT2EX = "Shoot",
        },
        DISMANTLE = "Dismantle",
        TACKLE = "Charge",
		HALLOWEENMOONMUTATE = "Mutate",
		APPLYPRESERVATIVE =
		{
			GENERIC = "Preserve",
			SALT = "Preserve",
		},
        CYCLE =
        {
            GENERIC = "Cycle",
            TUNE = "Hit",
        },

        --Quagmire
        TILL = "Till",
        PLANTSOIL = "Plant",
        INSTALL = "Install",
        HARVEST_TREE = "Harvest",
        TAPTREE =
        {
            GENERIC = "Tap",
            UNTAP = "Untap",
        },
        SLAUGHTER =
        {
            DISEMBOWEL = "Gently Disembowel",
            MURDER = "Tastefully Murder",
            BUTCHER = "Politely Butcher",
            KILL = "Delicately Kill",
            EVISCERATE = "Softly Eviscerate",
            SLAUGHTER = "Gingerly Slaughter",
        },
        REPLATE =
        {
            GENERIC = "Change Plating",
            FMT = "Change {dish}",
        },
        RAISE_SAIL = "Release Sail",
        LOWER_SAIL = "Hoist Sail",
        LOWER_SAIL_BOOST =
        {
            "Heave!",
            "Ho!"
        },
        RAISE_ANCHOR = "Raise",
        LOWER_ANCHOR = "Lower",
        EXTEND_PLANK = "Extend",
        RETRACT_PLANK = "Retract",
        ABANDON_SHIP = "Abandon Ship",
        MOUNT_PLANK = "Mount",
        DISMOUNT_PLANK = "Dismount",
        STEER_BOAT = "Steer",
        REPAIR_LEAK = "Repair Leak",
        SET_HEADING = "Set Heading",
        STOP_STEERING_BOAT = "Stop Steering",
        ROW_FAIL = "Row",
        ROW = "Row",
        ROW_CONTROLLER = "Row",
        CAST_NET = "Cast Net",
        BATHBOMB = "Toss In",
		OCEAN_FISHING_POND = "Cast",
		OCEAN_FISHING_CAST = "Cast",
		OCEAN_FISHING_REEL =
		{
            GENERIC = "Reel",
            SETHOOK = "Set Hook",
	    },
		OCEAN_FISHING_STOP = "Stop",
		OCEAN_FISHING_CATCH = "Catch",
		CHANGE_TACKLE =
		{
            GENERIC = "Attach Tackle",
            AMMO = "Set Ammo",
            REMOVE = "Remove",
		},
		COMPARE_WEIGHABLE = "Give",
		WEIGH_ITEM = "Weigh",
		GIVE_TACKLESKETCH = "Give",

		CASTSUMMON = "Summon",
		CASTUNSUMMON = "Return",
		COMMUNEWITHSUMMONED =
		{
			MAKE_AGGRESSIVE = "Rile Up",
			MAKE_DEFENSIVE = "Soothe",
        },

        OCEAN_TOSS = "Toss",

		TELLSTORY = "Tell Story",

		USE_WINCH = "Drop",

        POUR_WATER =
        {
            GENERIC = "Water",
            EXTINGUISH = "Extinguish",
        },

        PLANTREGISTRY_RESEARCH_FAIL = "Research",
        PLANTREGISTRY_RESEARCH = "Research",
        ASSESSPLANTHAPPINESS = {
            GENERIC = "Assess Happiness",
            GENERIC_FMT = "Assess {plant}'s Happiness",
        },

        ADDCOMPOSTABLE = "Give",

        WAX = "Wax",

        UNLOAD_WINCH = "Drop Overboard",

        USE_HEAVY_OBSTACLE =
        {
            GENERIC = "Use",
            LOAD_WINCH = "Load Winch",
            LOAD_GYM = "Load Gym",
        },

        ADVANCE_TREE_GROWTH = "Apply",

		-- Winter's Feast 2019
		WINTERSFEAST_FEAST = "Feast",

		-- YOTC
		START_CARRAT_RACE = "Start the Carrat Race",

        -- Wendy
        BEGIN_QUEST = "Assist",
        ABANDON_QUEST = "Abandon",

        -- Wigfrid
        SING = "Sing",
        QUOTE = "Recite",

        -- YOTB
        YOTB_SEW = "Sew",
        YOTB_STARTCONTEST = "Start the Contest",
        YOTB_UNLOCKSKIN = "Learn Costume",
        MARK = {
            GENERIC = "Choose This Beefalo",
            UNMARK = "Take Back",
        },

		-- YOT_Catcoon
		HIDEANSEEK_FIND = "Investigate",

		-- wanda
		CAST_POCKETWATCH =
		{
            GENERIC = "Activate",
			REVIVER = "Revive",
			RECALL_MARK = "Set Time In Space",
			--RECALL = "Travel Back",
		},
        DISMANTLE_POCKETWATCH = "Take Apart",

        -- Webber
        MUTATE_SPIDER = "Feed",
        HERD_FOLLOWERS = "Herd Spiders",
        REPEL = "Shoo Spiders",
        BEDAZZLE = "Decorate",

        -- Wolfgang
        ENTER_GYM = "Enter",

        LIFT_DUMBBELL = "Lift",
        STOP_LIFT_DUMBBELL = "Stop Lifting",

        LIFT_GYM = "Lift",
        LEAVE_GYM = "Stop",
        UNLOAD_GYM = "Unload",

        LIFT_GYM_SUCCEED_PERFECT = "Lift",
        LIFT_GYM_SUCCEED = "Lift",
        LIFT_GYM_FAIL = "Lift",

        APPLYMODULE = "Plug In",
        REMOVEMODULES = "Unplug",
        CHARGE_FROM = {
            SELF = "Charge At",
            ITEM = "Charge Item",
        },

		-- Waxwell
		USEMAGICTOOL = "Use",
		STOPUSINGMAGICTOOL = "Stop",
		USESPELLBOOK = {
            GENERIC = "Read",
            PYROKINESIS = "Stoke Embers",
			REMOTE = "Use",
            GHOSTTALK = "Whisper",
			WOBY = "Woby Actions",
        },
		CLOSESPELLBOOK = {
            GENERIC = "Close",
            PYROKINESIS = "Extinguish",
			REMOTE = "Stop",
            GHOSTTALK = "Quiet",
        },

        -- Pirates
        ROTATE_BOAT_CLOCKWISE = "Rotate Starboard",
        ROTATE_BOAT_COUNTERCLOCKWISE = "Rotate Port",
        ROTATE_BOAT_STOP = "Stop Rotating",

        BOAT_MAGNET_ACTIVATE = "Pair",
        BOAT_MAGNET_DEACTIVATE = "Unpair",
        BOAT_MAGNET_BEACON_TURN_ON = "Turn On",
        BOAT_MAGNET_BEACON_TURN_OFF = "Turn Off",

        BOAT_CANNON_LOAD_AMMO = "Load Ammo",
        BOAT_CANNON_SHOOT = "Shoot",
        BOAT_CANNON_START_AIMING = "Aim",
        BOAT_CANNON_STOP_AIMING = "Stop Aiming",

        OCEAN_TRAWLER_LOWER = "Lower",
        OCEAN_TRAWLER_RAISE = "Raise",
        OCEAN_TRAWLER_FIX = "Fix",

        EMPTY_CONTAINER = "Empty",

        ROTATE_FENCE = "Rotate",

        PERFORM = "Perform",

        SCYTHE = "Reap",
        SITON = "Sit On",

        USE_WEREFORM_SKILL =
        {
            BEAVER = "Tail Slap",
            GOOSE = "Takeoff",
        },

        INCINERATE = "Destroy",
		BOTTLE = "Collect",

		-- Hallowed Nights 2024
		CARVEPUMPKIN = "Carve",

		-- Winter's Feast 2024
		DECORATESNOWMAN =
		{
			GENERIC = "Decorate",
			STACK = "Stack",
		},
		START_PUSHING =
		{
			GENERIC = "Push",
			ROLL = "Roll",
		},

        -- Meta 5
        NABBAG = "Knab",

        GRAVEDIG = "Beckon",

		MODSLINGSHOT = "Mod Slingshot", --see USEITEMON.SLINGSHOTMODKIT
		STOPMODSLINGSHOT = "Stop Modding",
		CONTAINER_INSTALL_ITEM =
		{
			GENERIC = "Install",
			UNINSTALL = "Uninstall",
		},

        MUTATE =
        {
            MUTATE_TARGET = "Mutate {target}",
        },

        DIRECTCOURIER_MAP =
        {
            SEND = "Deliver Items to {target}",
            CHEST = "Drop Items Off",
        },

		WHISTLE = "Call Woby", --can expand to table if other characters want to use whistle action

        DRAW_FROM_DECK = "Draw",
        FLIP_DECK = "Flip",
        ADD_CARD_TO_DECK = "Add",

		-- Rifts 5
		POUNCECAPTURE = "Encapsulate",
        
        -- rifts5.1
        DIVEGRAB = "Restrain",
        STARTELECTRICLINK = "Toggle Linking",
        ENDELECTRICLINK = "Disconnect Links",
        REMOVELUNARBUILDUP = "Clear",

		-- Winter 2025
		SOAKIN = "Soak In",
        TRANSFER_CRITTER = "Transfer Ownership",
    },

	WOBY_COMMANDS =
	{
		SIT = "Stay (on/off)",
		SHRINK = "Transform",
		PICKUP = "Retrieving (on/off)",
		FORAGING = "Foraging (on/off)",
		WORKING = "Helping Horns (on/off)",
		SPRINTING = "Sprinting (on/off)",
		SHADOWDASH = "Umbral Dash (on/off)",
		REMEMBERCHEST = "Mark Spot",
		COURIER = "Deliver",
	},

    -- PC controls get hex ranges EE90xx to EE9Fxx
    LMB = "\238\132\128",
    RMB = "\238\132\129",

    SELECT = "Select",
    DROPALL = "Drop All",

    INSPECTMOD = "Inspect",
    STACKMOD = "Stack",
    TRADEMOD = "Move",
    SWAP = "Swap",

    WITHEREDITEM = "Withered",
    SMOLDERINGITEM = "Smoldering",
    DISEASEDITEM = "Diseased",
	BROKENITEM = "Broken",
	WAXEDPLANT = "Scared Stiff",
	DEADCREATURE = "Dead",

    WET_PREFIX =
    {
        NONE = "",
        GENERIC = "Wet",
        RABBITHOLE = "Collapsed",
        CLOTHING = "Soaked",
        FUEL = "Water-Logged",
        TOOL = "Slippery",
        FOOD = "Soggy",
        POUCH = "Soggy",
        WETGOOP = "Very",
        DESICCANT = "Damp",
        DESICCANT_FULL = "Saturated",
    },

    NAMES =
    {
        DEFAULT = "INVENTORY ITEM",
        NONE = "Nothing",

        LUCY = "Lucy the Axe",

        BOOKSTATION = "Bookcase",

        BOOK_BIRDS = "Birds of the World",
        BOOK_TENTACLES = "On Tentacles",
        BOOK_GARDENING = "Applied Horticulture",
        BOOK_SILVICULTURE = "Applied Silviculture",
		BOOK_HORTICULTURE = "Horticulture, Abridged",
        BOOK_SLEEP = "Sleepytime Stories",
        BOOK_BRIMSTONE = "The End is Nigh!",

        BOOK_FISH = "The Angler's Survival Guide",
        BOOK_FIRE = "Pyrokinetics Explained",
        BOOK_WEB = "Overcoming Arachnophobia",
        BOOK_TEMPERATURE = "Tempering Temperatures",
        BOOK_LIGHT = "Lux Aeterna",
        BOOK_RAIN = "Practical Rain Rituals",
        BOOK_MOON = "Lunar Grimoire",
        BOOK_BEES = "Apicultural Notes",

        BOOK_HORTICULTURE_UPGRADED = "Horticulture, Expanded",
        BOOK_RESEARCH_STATION = "The Everything Encyclopedia",
        BOOK_LIGHT_UPGRADED = "Lux Aeterna Redux",

        FIREPEN = "Fiery Pen",

        ANCIENT_ALTAR ="Ancient Pseudoscience Station",
        ANCIENT_ALTAR_BROKEN ="Broken Ancient Pseudoscience Station",
        ANCIENT_STATUE ="Ancient Statue",
        CHESSJUNK1 = "Broken Clockworks",
        CHESSJUNK2 = "Broken Clockworks",
        CHESSJUNK3 = "Broken Clockworks",
        ABIGAIL_FLOWER = "Abigail's Flower",
        BALLOONS_EMPTY = "Pile o' Balloons",
        BALLOON = "Balloon",
		BALLOONPARTY = "Party Balloon",
		BALLOONSPEED = "Speedy Balloon",
		BALLOONVEST = "Inflatable Vest",
		BALLOONHAT = "Balloon Hat",
        LIGHTER = "Willow's Lighter",
        COMPASS = "Compass",
        MUSHTREE_TALL = "Blue Mushtree",
        MUSHTREE_MEDIUM = "Red Mushtree",
        MUSHTREE_SMALL = "Green Mushtree",
        MUSHTREE_TALL_WEBBED = "Webbed Blue Mushtree",
        SPORE_TALL = "Blue Spore",
        SPORE_MEDIUM = "Red Spore",
        SPORE_SMALL = "Green Spore",
        SPIDER_HIDER = "Cave Spider",
        SPIDER_SPITTER = "Spitter",
        SEWING_KIT = "Sewing Kit",
        SEWING_TAPE = "Trusty Tape",
        RED_MUSHROOM = "Red Mushroom",
        RED_CAP = "Red Cap",
        RED_CAP_COOKED = "Cooked Red Cap",
        GREEN_MUSHROOM = "Green Mushroom",
        GREEN_CAP = "Green Cap",
        GREEN_CAP_COOKED = "Cooked Green Cap",
        BLUE_MUSHROOM = "Blue Mushroom",
        BLUE_CAP_COOKED = "Cooked Blue Cap",
        BLUE_CAP = "Blue Cap",

        CARROT = "Carrot",
        PUMPKIN = "Pumpkin",
        DRAGONFRUIT = "Dragon Fruit",
        POMEGRANATE = "Pomegranate",
        CORN = "Corn",
        DURIAN = "Durian",
        EGGPLANT = "Eggplant",
        TOMATO = "Toma Root",
        POTATO = "Potato",
        TURNIP = "Turnip",
        ONION  = "Onion",
        GARLIC = "Garlic",
        ASPARAGUS = "Asparagus",
        PEPPER = "Pepper",

        CARROT_OVERSIZED = "Giant Carrots",
        PUMPKIN_OVERSIZED = "Giant Pumpkin",
        DRAGONFRUIT_OVERSIZED = "Giant Dragon Fruit",
        POMEGRANATE_OVERSIZED = "Giant Pomegranate",
        CORN_OVERSIZED = "Giant Corn",
        DURIAN_OVERSIZED = "Giant Durian",
        EGGPLANT_OVERSIZED = "Giant Eggplant",
        TOMATO_OVERSIZED = "Giant Toma Root",
        POTATO_OVERSIZED = "Giant Potato",
        ONION_OVERSIZED  = "Giant Onion",
        GARLIC_OVERSIZED = "Giant Garlic",
        ASPARAGUS_OVERSIZED = "Giant Asparagus",
        PEPPER_OVERSIZED = "Giant Pepper",
        WATERMELON_OVERSIZED = "Giant Watermelon",

        CARROT_OVERSIZED_ROTTEN = "Giant Rotting Carrots",
        PUMPKIN_OVERSIZED_ROTTEN = "Giant Rotting Pumpkin",
        DRAGONFRUIT_OVERSIZED_ROTTEN = "Giant Rotting Dragon Fruit",
        POMEGRANATE_OVERSIZED_ROTTEN = "Giant Rotting Pomegranate",
        CORN_OVERSIZED_ROTTEN = "Giant Rotting Corn",
        DURIAN_OVERSIZED_ROTTEN = "Giant Rotting Durian",
        EGGPLANT_OVERSIZED_ROTTEN = "Giant Rotting Eggplant",
        TOMATO_OVERSIZED_ROTTEN = "Giant Rotting Toma Root",
        POTATO_OVERSIZED_ROTTEN = "Giant Rotting Potato",
        ONION_OVERSIZED_ROTTEN  = "Giant Rotting Onion",
        GARLIC_OVERSIZED_ROTTEN = "Giant Rotting Garlic",
        ASPARAGUS_OVERSIZED_ROTTEN = "Giant Rotting Asparagus",
        PEPPER_OVERSIZED_ROTTEN = "Giant Rotting Pepper",
        WATERMELON_OVERSIZED_ROTTEN = "Giant Rotting Watermelon",

		FARM_PLANT_SEED = "Planted {seed}",
		FARM_PLANT_RANDOMSEED = "Planted Seed",
		FARM_PLANT_ROTTEN = "Rotting Plant",
        FARM_PLANT_UNKNOWN = "Plant",
        FARM_PLANT_CARROT = "Carrot Plant",
        FARM_PLANT_PUMPKIN = "Pumpkin Plant",
        FARM_PLANT_DRAGONFRUIT = "Dragon Fruit Vine",
        FARM_PLANT_POMEGRANATE = "Pomegranate Branch",
        FARM_PLANT_CORN = "Corn Stalk",
        FARM_PLANT_DURIAN = "Durian Vine",
        FARM_PLANT_EGGPLANT = "Eggplant Stalk",
        FARM_PLANT_TOMATO = "Toma Root Plant",
        FARM_PLANT_POTATO = "Potato Plant",
        FARM_PLANT_WATERMELON = "Watermelon Plant",
        FARM_PLANT_ONION  = "Onion Plant",
        FARM_PLANT_GARLIC = "Garlic Plant",
        FARM_PLANT_ASPARAGUS = "Asparagus Fern",
        FARM_PLANT_PEPPER = "Pepper Plant",

        FARM_SOIL_DEBRIS = "Garden Detritus",

		WEED_FORGETMELOTS = "Forget-Me-Lots",
		WEED_TILLWEED = "Tillweed",
		WEED_FIRENETTLE = "Fire Nettles",
		WEED_IVY = "Spiny Bindweed",
		IVY_SNARE = "Binding Roots",

		FIRENETTLES = "Fire Nettle Fronds",
		FORGETMELOTS = "Forget-Me-Lots",
		SWEETTEA = "Soothing Tea",
		TILLWEED = "Tillweeds",
		TILLWEEDSALVE = "Tillweed Salve",

        ICEBOX = "Ice Box",

        KNOWN_PUMPKIN_SEEDS = "Pumpkin Seeds",
        KNOWN_DRAGONFRUIT_SEEDS = "Dragon Fruit Seeds",
        KNOWN_POMEGRANATE_SEEDS = "Pomegranate Seeds",
        KNOWN_CORN_SEEDS = "Corn Seeds",
        KNOWN_DURIAN_SEEDS = "Durian Seeds",
        KNOWN_EGGPLANT_SEEDS = "Eggplant Seeds",
        KNOWN_WATERMELON_SEEDS = "Watermelon Seeds",
        KNOWN_TOMATO_SEEDS = "Toma Root Seeds",
        KNOWN_POTATO_SEEDS = "Potato Seeds",
        KNOWN_TURNIP_SEEDS = "Turnip Seeds",
        KNOWN_ONION_SEEDS  = "Onion Seeds",
        KNOWN_GARLIC_SEEDS = "Garlic Seeds",
        KNOWN_ASPARAGUS_SEEDS = "Asparagus Seeds",
        KNOWN_PEPPER_SEEDS = "Pepper Seeds",
        KNOWN_CARROT_SEEDS = "Carrot Seeds",

        PUMPKIN_SEEDS = "Sharp Seeds",
        DRAGONFRUIT_SEEDS = "Bulbous Seeds",
        POMEGRANATE_SEEDS = "Windblown Seeds",
        CORN_SEEDS = "Clustered Seeds",
        DURIAN_SEEDS = "Brittle Seed Pods",
        EGGPLANT_SEEDS = "Swirly Seeds",
        WATERMELON_SEEDS = "Square Seeds",
        TOMATO_SEEDS = "Spiky Seeds",
        POTATO_SEEDS = "Fluffy Seeds",
        TURNIP_SEEDS = "Round Seeds",
        ONION_SEEDS  = "Pointy Seeds",
        GARLIC_SEEDS = "Seed Pods",
        ASPARAGUS_SEEDS = "Tubular Seeds",
        PEPPER_SEEDS = "Lumpy Seeds",
        CARROT_SEEDS = "Oblong Seeds",

        MANRABBIT_TAIL = "Bunny Puff",
        BUNNYMAN = "Bunnyman",
        PIGGUARD = "Guard Pig",
        PIGELITE1 = "Wade", --BLUE
		PIGELITE2 = "Ignatius", --RED
		PIGELITE3 = "Dmitri", --WHITE
		PIGELITE4 = "Sawyer", --GREEN
        PIGELITEFIGHTER1 = "Wade", --BLUE
		PIGELITEFIGHTER2 = "Ignatius", --RED
		PIGELITEFIGHTER3 = "Dmitri", --WHITE
		PIGELITEFIGHTER4 = "Sawyer", --GREEN
        GUNPOWDER = "Gunpowder",
        BIRD_EGG = "Egg",
        BIRD_EGG_COOKED = "Cooked Egg",
        ROTTENEGG = "Rotten Egg",

        RAINOMETER = "Rainometer",
        SPOILED_FOOD = "Rot",
        BERRIES = "Berries",
        BERRIES_JUICY = "Juicy Berries",
        REDPOUCH = "Red Pouch",
        GIFT = "Gift",
        GIFTWRAP = "Gift Wrap",
        BUNDLE = "Bundled Supplies",
        BUNDLEWRAP = "Bundling Wrap",
        BACKPACK = "Backpack",
        PIGGYBACK = "Piggyback",
        ICEPACK = "Insulated Pack",
        REDGEM ="Red Gem",
        PURPLEGEM = "Purple Gem",
        GREENGEM = "Green Gem",
        ORANGEGEM = "Orange Gem",
        YELLOWGEM = "Yellow Gem",
        OPALPRECIOUSGEM = "Iridescent Gem",
        HOUNDSTOOTH = "Hound's Tooth",
        SWEATERVEST = "Dapper Vest",
        REFLECTIVEVEST = "Summer Frest",
        HAWAIIANSHIRT = "Floral Shirt",

        CARROT_COOKED = "Roasted Carrot",
        PUMPKIN_COOKED = "Hot Pumpkin",
        DRAGONFRUIT_COOKED = "Prepared Dragon Fruit",
        POMEGRANATE_COOKED = "Sliced Pomegranate",
        CORN_COOKED = "Popcorn",
        DURIAN_COOKED = "Extra Smelly Durian",
        EGGPLANT_COOKED = "Braised Eggplant",
        BERRIES_COOKED = "Roasted Berries",
        BERRIES_JUICY_COOKED = "Roasted Juicy Berries",
        TOMATO_COOKED = "Roasted Toma Root",
        POTATO_COOKED = "Roasted Potato",
        TURNIP_COOKED = "Roasted Turnip",
        ONION_COOKED  = "Roasted Onion",
        GARLIC_COOKED = "Roasted Garlic",
        ASPARAGUS_COOKED = "Roasted Asparagus",
        PEPPER_COOKED = "Roasted Pepper",

        CAVE_ENTRANCE = "Plugged Sinkhole",
        CAVE_ENTRANCE_OPEN = "Sinkhole",
        CAVE_ENTRANCE_OPEN_CAVE = "Deeper",
        CAVE_ENTRANCE_RUINS = "Plugged Hole",
        RABBITHOUSE = "Rabbit Hutch",
        CAVE_EXIT = "Stairs",
        UMBRELLA = "Umbrella",
        KRAMPUS_SACK = "Krampus Sack",

        TURF_ROAD = "Cobblestones",
        TURF_ROCKY = "Rocky Turf",
        TURF_DIRT = "Dirt Turf",
        TURF_SAVANNA = "Savanna Turf",
        TURF_GRASS = "Grass Turf",
        TURF_FOREST = "Forest Turf",
        TURF_MARSH = "Marsh Turf",
        TURF_WOODFLOOR = "Wooden Flooring",
        TURF_CARPETFLOOR = "Carpeted Flooring",
        TURF_CHECKERFLOOR = "Checkered Flooring",
        TURF_METEOR = "Moon Crater Turf",
        TURF_SHELLBEACH = "Shell Beach Turf",
        TURF_PEBBLEBEACH = "Rocky Beach Turf",
        TURF_DRAGONFLY = "Scaled Flooring",

        TURF_CAVE = "Guano Turf",
        TURF_FUNGUS = "Fungal Turf",
        TURF_FUNGUS_RED = "Fungal Turf",
        TURF_FUNGUS_GREEN = "Fungal Turf",
		TURF_FUNGUS_MOON = "Mutated Fungal Turf",

		TURF_ARCHIVE = "Ancient Stonework",
        TURF_VAULT = "Ancient Sanctum Stonework",
        TURF_VENT = "Cave Fumarole Turf",


		BLUEPRINT_CRAFTINGSET_RUINS_BUILDER = "Ruins Turf Blueprints",
		BLUEPRINT_CRAFTINGSET_RUINSGLOW_BUILDER = "Imitation Ruins Turf Blueprints",
		TURF_RUINSBRICK = "Ancient Flooring",
		TURF_RUINSBRICK_GLOW = "Imitation Ancient Flooring",
		TURF_RUINSTILES = "Ancient Tilework",
		TURF_RUINSTILES_GLOW = "Imitation Ancient Tilework",
		TURF_RUINSTRIM = "Ancient Brickwork",
		TURF_RUINSTRIM_GLOW = "Imitation Ancient Brickwork",

        TURF_SINKHOLE = "Slimy Turf",
        TURF_UNDERROCK = "Cave Rock Turf",
        TURF_MUD = "Mud Turf",
        TURF_DESERTDIRT = "Sandy Turf",
        TURF_DECIDUOUS = "Deciduous Turf",
        TURF_MONKEY_GROUND = "Moon Quay Beach Turf",

        TURF_CARPETFLOOR2 = "Lush Carpet",
        TURF_MOSAIC_GREY = "Grey Mosaic Flooring",
        TURF_MOSAIC_BLUE = "Blue Mosaic Flooring",
        TURF_MOSAIC_RED = "Red Mosaic Flooring",

        TURF_BEARD_RUG = "Beard Hair Rug",

        COOKPOT = "Crock Pot",
        DUG_GRASS = "Grass Tuft",
        DUG_SAPLING = "Sapling",
        DUG_SAPLING_MOON = "Sapling",
        DUG_BERRYBUSH = "Berry Bush",
        DUG_BERRYBUSH2 = "Berry Bush",
        DUG_MARSH_BUSH = "Spiky Bush",
        DUG_BERRYBUSH_JUICY = "Juicy Berry Bush",

        FOOTBALLHAT="Football Helmet",
        PIGSKIN = "Pig Skin",
        AXE = "Axe",
        HAMMER = "Hammer",
        GOLDENAXE = "Luxury Axe",
        MEAT = "Meat",
        COOKEDMEAT = "Cooked Meat",
        MEAT_DRIED = "Jerky",
        SMALLMEAT = "Morsel",
        COOKEDSMALLMEAT = "Cooked Morsel",
        SMALLMEAT_DRIED = "Small Jerky",
        MONSTERMEAT = "Monster Meat",
        COOKEDMONSTERMEAT = "Cooked Monster Meat",
        MONSTERMEAT_DRIED = "Monster Jerky",
        HUMANMEAT = "Long Pig",
        HUMANMEAT_COOKED = "Cooked Long Pig",
        HUMANMEAT_DRIED = "Long Pig Jerky",
        PLANTMEAT = "Leafy Meat",
        PLANTMEAT_COOKED = "Cooked Leafy Meat",
        TRAP = "Trap",
        LOG = "Log",
        HAMBAT = "Ham Bat",
        LIVINGLOG = "Living Log",
        TWIGS = "Twigs",
        CUTGRASS = "Cut Grass",
        PETALS = "Petals",
        PETALS_EVIL = "Dark Petals",
        ADVENTURE_PORTAL = "Maxwell's Door",
        MULTIPLAYER_PORTAL = "Florid Postern",
        MIGRATION_PORTAL = "Friend-O-Matic Portal",
        POOP = "Manure",
        TORCH = "Torch",
        SEEDS = "Seeds",
        HOUND = "Hound",
		--HOUNDCORPSE = "Hound", -- NOTE: Deprecated.
        FIREHOUND = "Fire Hound",
        SEEDS_COOKED = "Toasted Seeds",
        SILK = "Silk",
        SPIDERGLAND = "Spider Gland",
        TRAP_TEETH = "Tooth Trap",
        TRAP_TEETH_MAXWELL = "Maxwell's Tooth Trap",
        KRAMPUS = "Krampus",
        ROCK_LIGHT = "Lava Pit",
        ROCKS = "Rocks",
        ICE = "Ice",
        FLINT = "Flint",
        AMULET = "Life Giving Amulet",
        BLUEAMULET = "Chilled Amulet",
        PURPLEAMULET = "Nightmare Amulet",
        YELLOWAMULET = "Magiluminescence",
        ORANGEAMULET = "The Lazy Forager",
        GREENAMULET = "Construction Amulet",
        PICKAXE = "Pickaxe",
        GOLDENPICKAXE = "Opulent Pickaxe",
        SHOVEL = "Shovel",
        GOLDENSHOVEL = "Regal Shovel",
        PITCHFORK = "Pitchfork",
        GOLDENPITCHFORK = "Snazzy Pitchfork",
        BEEFALO = "Beefalo",
        BEEFALO_DOMESTIC = "Domesticated Beefalo",
        BABYBEEFALO = "Baby Beefalo",
        BERRYBUSH = "Berry Bush",
        BERRYBUSH2 = "Berry Bush",
        BERRYBUSH_JUICY = "Juicy Berry Bush",
        CAMPFIRE = "Campfire",
        CANARY = "Canary",
        CANARY_POISONED = "Canary (Volatile)",
        CROW = "Crow",
        ROBIN = "Redbird",
        ROBIN_WINTER = "Snowbird",
        EVERGREEN = "Evergreen",
        EVERGREEN_SPARSE = "Lumpy Evergreen",
        SLOW_FARMPLOT = "Basic Farm",
        FAST_FARMPLOT = "Improved Farm",
        MUSHROOM_FARM = "Mushroom Planter",
        FIRE = "Fire",
        HOUNDFIRE = "Fire",
        COLDFIRE = "Endothermic Fire",
        COLDFIREPIT = "Endothermic Fire Pit",
        FIREPIT = "Fire Pit",
        HEATROCK = "Thermal Stone",
        FLOWER = "Flower",
        FLOWER_EVIL = "Evil Flower",
        FLOWER_WITHERED = "Withered Flower",
        FIREFLIES = "Fireflies",
        GHOST = "Ghost",
        GRASS = "Grass",
        DEPLETED_GRASS = "Grass",
        GRAVESTONE = "Headstone",
        HOMESIGN = "Sign",
        MINISIGN = "Mini Sign",
        MINISIGN_DRAWN = "{item} Sign",
        MINISIGN_ITEM = "Mini Sign",
        ARROWSIGN_POST = "Directional Sign",
        ARROWSIGN_PANEL = "Directional Sign",
        MAXWELL = "Maxwell",
        MOUND = "Grave",
        PIGHOUSE = "Pig House",
        PIGMAN = "Pig Man",
        CROP = "Crop",
        POND = "Pond",
        POND_MOS = "Pond",
        POND_CAVE = "Pond",
        OASISLAKE = "Lake",
        RABBIT = "Rabbit",
        RABBITHOLE = "Rabbit Hole",
        CAVEIN_BOULDER = "Boulder",
        ROCK1 = "Boulder",
        ROCK2 = "Boulder",
        ROCK_MOON = "Boulder",
        ROCK_MOON_SHELL = "Suspicious Boulder",
        ROCK_FLINTLESS = "Boulder",
        ROCK_FLINTLESS_MED = "Boulder",
        ROCK_FLINTLESS_LOW = "Boulder",
        ROCK_ICE = "Mini Glacier",
        ROCK_ICE_MELTED = "Melted Mini Glacier",
        INSANITYROCK = "Obelisk",
        SANITYROCK = "Obelisk",
        SKELETON = "Skeleton",
        SKELETON_NOTPLAYER = "Skeleton",
        SCORCHED_SKELETON = "Crispy Skeleton",
        SKELETON_PLAYER = "Skeleton",
        PIGHEAD = "Pig Head",
        MERMHEAD = "Merm Head",

        SAPLING = "Sapling",
        SPIDER = "Spider",
        SPIDERDEN = "Spider Den",
        SPIDER_WARRIOR = "Spider Warrior",
        TENT = "Tent",
        SIESTAHUT = "Siesta Lean-to",
        WARDROBE = "Wardrobe",
        PIGTORCH = "Pig Torch",

        WILSON = "Wilson",
        WILLOW = "Willow",
        WENDY = "Wendy",
        WOLFGANG = "Wolfgang",
        WOODIE = "Woodie",
        WICKERBOTTOM = "Wickerbottom",
        WX78 = "WX-78",
        WES = "Wes",
        WAXWELL = "Maxwell",
        WATHGRITHR = "Wigfrid",
        WEBBER = "Webber",
        WINONA = "Winona",
        WORTOX = "Wortox",
        WORMWOOD = "Wormwood",
        WARLY = "Warly",
        WURT = "Wurt",
        WALTER = "Walter",
        WANDA = "Wanda",
        WONKEY = "Wonkey",

        PIGKING = "Pig King",
        STRAWHAT = "Straw Hat",
        TOPHAT = "Top Hat",
        FLOWERHAT = "Garland",
        KELPHAT = "Seawreath",
        BEEFALOHAT = "Beefalo Hat",
        FEATHERHAT = "Feather Hat",
        ARMORWOOD = "Log Suit",
        ARMORGRASS = "Grass Suit",
        ARMORMARBLE = "Marble Suit",
        ARMORSKELETON = "Bone Armor",
        SKELETONHAT = "Bone Helm",
        ARMOR_SANITY = "Night Armor",
        SPEAR = "Spear",
        TENTACLESPIKE = "Tentacle Spike",
        TENTACLE = "Tentacle",
        TENTACLE_PILLAR = "Big Tentacle",
        TENTACLE_PILLAR_HOLE = "Big Slimy Pit",
        TENTACLE_PILLAR_ARM = "Baby Tentacle",
        TENTACLE_GARDEN = "Big Tentacle",
        ROPE = "Rope",
        RESURRECTIONSTATUE = "Meat Effigy",
        RESURRECTIONSTONE = "Touch Stone",
        BOARDS = "Boards",
        CUTSTONE = "Cut Stone",
        GOLDNUGGET = "Gold Nugget",
        RESEARCHLAB = "Science Machine",
        RESEARCHLAB2 = "Alchemy Engine",
        RESEARCHLAB3 = "Shadow Manipulator",
        RESEARCHLAB4 = "Prestihatitator",
        CARTOGRAPHYDESK = "Cartographer's Desk",
        PLANT_NORMAL = "Crop",
        PLANT_NORMAL_GROUND = "Wild Crop",
        RAZOR = "Razor",
        BEARDHAIR = "Beard Hair",
        FURTUFT = "Fur Tuft",
        TREASURECHEST = "Chest",
        CHESTUPGRADE_STACKSIZE = "Elastispacer",
		COLLAPSEDCHEST = "Broken-down Chest",
        DRAGONFLYCHEST = "Scaled Chest",
        DRAGONFLYFURNACE = "Scaled Furnace",
        SKULLCHEST = "Skullchest",
        PANDORASCHEST = "Ornate Chest",
        MINOTAURCHEST = "Large Ornate Chest",
        CHESTER = "Chester",
        CHESTER_EYEBONE = "Eye Bone",
        BEDROLL_STRAW = "Straw Roll",
        BEDROLL_FURRY = "Fur Roll",
        BEEFALOWOOL = "Beefalo Wool",
        PINECONE = "Pine Cone",
        PINECONE_SAPLING = "Evergreen Sapling",
        TWIGGY_NUT = "Twiggy Tree Cone",
        TWIGGY_NUT_SAPLING = "Twiggy Sapling",
        MARBLEBEAN = "Marble Bean",
        MARBLEBEAN_SAPLING = "Marble Sprout",
        MARBLESHRUB = "Marble Shrub",
        LUMPY_SAPLING = "Lumpy Sapling",
        SPIDEREGGSACK = "Spider Eggs",
        CHARCOAL = "Charcoal",
        ASH = "Ashes",
        ASH_REMAINS = "Ashes of %s",
        MANDRAKE_ACTIVE = "Mandrake",
        MANDRAKE_PLANTED = "Mandrake",
        MANDRAKE = "Mandrake",
        COOKEDMANDRAKE = "Cooked Mandrake",
        REEDS = "Reeds",
        MAPSCROLL = "Map Scroll",
        MAPSCROLL_TRICKER = "Map of Totally Uninhabited Island",
        CUTREEDS = "Cut Reeds",
        MARSH_PLANT = "Plant",
        TUMBLEWEED = "Tumbleweed",
        MARSH_BUSH = "Spiky Bush",
        BURNT_MARSH_BUSH = "Spiky Bush",
        PAPYRUS = "Papyrus",
        WAXPAPER = "Wax Paper",
        MARSH_TREE = "Spiky Tree",
        PANFLUTE = "Pan Flute",
        BUGNET = "Bug Net",
        THULECITEBUGNET = "Thulecite Bug Net",
        SADDLEHORN = "Saddlehorn",
        BRUSH = "Brush",
        SALTLICK = "Salt Lick",
        FROG = "Frog",
        FISHINGROD = "Freshwater Fishing Rod",
        FISH = "Fish",
        FISH_COOKED = "Cooked Fish",
        FOSSIL_PIECE = "Fossil Fragments",
        FOSSIL_STALKER = "Odd Skeleton",
        FOSSILSPIKE = "Fossil Cage",
        FOSSILSPIKE2 = "Fossil Spike",
        STALKER = "Reanimated Skeleton",
        STALKER_ATRIUM = "Ancient Fuelweaver",
        STALKER_MINION = "Woven Shadow",
        SHADOWCHANNELER = "Unseen Hand",
        THURIBLE = "Shadow Thurible",
        HONEY = "Honey",
        HONEYCOMB = "Honeycomb",
        BEESWAX = "Beeswax",
        BEEHIVE = "Beehive",
        BEEBOX = "Bee Box",
        BEE = "Bee",
        DEVTOOL = "Dev Tool",
        KILLERBEE = "Killer Bee",
        WASPHIVE = "Killer Bee Hive",
        MOSQUITO = "Mosquito",
        BEEHAT = "Beekeeper Hat",
        STINGER = "Stinger",
        STAGEHAND = "Stagehand",
        ENDTABLE = "End Table",
        BUTTERFLY = "Butterfly",
        BUTTERFLYWINGS = "Butterfly Wings",
        BUTTER = "Butter",
        FROGLEGS = "Frog Legs",
        FROGLEGS_COOKED = "Cooked Frog Legs",
        TALLBIRD = "Tallbird",
        SMALLBIRD = "Smallbird",
        TEENBIRD = "Smallish Tallbird",
        WALRUS = "MacTusk",
        WALRUS_CAMP = "Walrus Camp",
        WALRUS_TUSK = "Walrus Tusk",
        WALRUSHAT = "Tam o' Shanter",
        LITTLE_WALRUS = "Wee MacTusk",
        PUMPKIN_LANTERN = "Pumpkin Lantern",
        TALLBIRDNEST = "Tallbird Nest",
        TALLBIRDEGG = "Tallbird Egg",
        TALLBIRDEGG_CRACKED = "Hatching Tallbird Egg",
        TALLBIRDEGG_COOKED = "Fried Tallbird Egg",
        FEATHER_CROW = "Jet Feather",
        FEATHER_ROBIN = "Crimson Feather",
        FEATHER_ROBIN_WINTER = "Azure Feather",
        FEATHER_CANARY = "Saffron Feather",
        FEATHERPENCIL = "Feather Pencil",
        COOKBOOK = "Cookbook",
        BIRDTRAP = "Bird Trap",
        BLOWDART_SLEEP = "Sleep Dart",
        BLOWDART_FIRE = "Fire Dart",
        BLOWDART_PIPE = "Blow Dart",
        BLOWDART_YELLOW = "Electric Dart",
        BEEMINE = "Bee Mine",
        BEEMINE_MAXWELL = "Maxwell's Mosquito Trap",
        BIRDCAGE = "Birdcage",
        SCARECROW = "Friendly Scarecrow",
        SPIDERQUEEN = "Spider Queen",
        EARMUFFSHAT = "Rabbit Earmuffs",
        WINTERHAT = "Winter Hat",
        HORN = "Beefalo Horn",
        ONEMANBAND = "One-man Band",
        STATUEHARP = "Harp Statue",
        STATUEMAXWELL = "Maxwell Statue",
        MAXWELLLIGHT = "Maxwell's Light",
        MAXWELLKEY = "Shadow Key",
        SADDLE_BASIC = "Saddle",
        SADDLE_WAR = "War Saddle",
        SADDLE_RACE = "Glossamer Saddle",

        DRAGONHEADHAT = "Lucky Beast Head",
        DRAGONBODYHAT = "Lucky Beast Body",
        DRAGONTAILHAT = "Lucky Beast Tail",
        PERDSHRINE = "Gobbler Shrine",
        REDLANTERN = "Red Lantern",
        LUCKY_GOLDNUGGET = "Lucky Gold Nugget",
        FIRECRACKERS = "Red Firecrackers",
        PERDFAN = "Lucky Fan",
        WARGSHRINE = "Varg Shrine",
        PIGSHRINE = "Pig Shrine",
        CLAYWARG = "Clay Varg",
        CLAYHOUND = "Clay Hound",
        HOUNDWHISTLE = "Lucky Whistle",
        CHESSPIECE_CLAYHOUND_SKETCH = "Hound Figure Sketch",
        CHESSPIECE_CLAYWARG_SKETCH = "Clay Varg Figure Sketch",

		PIG_TOKEN = "Golden Belt",
		PIG_COIN = "Clout Snout",
		YOTP_FOOD1 = "Tribute Roast", -- tribute roast
		YOTP_FOOD2 = "Eight Treasure Mud Pie", -- mud pie
		YOTP_FOOD3 = "Fish Heads on a Stick", -- fish head skewers

        TELEPORTATO_RING = "Ring Thing",
        TELEPORTATO_BOX = "Box Thing",
        TELEPORTATO_CRANK = "Crank Thing",
        TELEPORTATO_POTATO = "Metal Potato Thing",
        TELEPORTATO_BASE = "Wooden Thing",
        TELEPORTATO_CHECKMATE = "Wooden Thing",

        TRINKET_1 = "Melty Marbles",
        TRINKET_2 = "Fake Kazoo",
        TRINKET_3 = "Gord's Knot",
        TRINKET_4 = "Gnome",
        TRINKET_5 = "Tiny Rocketship",
        TRINKET_6 = "Frazzled Wires",
        TRINKET_7 = "Ball and Cup",
        TRINKET_8 = "Hardened Rubber Bung",
        TRINKET_9 = "Mismatched Buttons",
        TRINKET_10 = "Second-hand Dentures",
        TRINKET_11 = "Lying Robot",
        TRINKET_12 = "Dessicated Tentacle",
        TRINKET_13 = "Gnomette",
        TRINKET_14 = "Leaky Teacup",
        TRINKET_15 = "White Bishop",
        TRINKET_16 = "Black Bishop",
        TRINKET_17 = "Bent Spork",
        TRINKET_18 = "Toy Trojan Horse",
        TRINKET_19 = "Unbalanced Top",
        TRINKET_20 = "Back Scratcher",
        TRINKET_21 = "Beaten Beater",
        TRINKET_22 = "Frayed Yarn",
        TRINKET_23 = "Shoe Horn",
        TRINKET_24 = "Lucky Cat Jar",
        TRINKET_25 = "Air Unfreshener",
        TRINKET_26 = "Potato Cup",
        TRINKET_27 = "Wire Hanger",
        TRINKET_28 = "White Rook",
        TRINKET_29 = "Black Rook",
        TRINKET_30 = "White Knight",
        TRINKET_31 = "Black Knight",
        --hallowed nights trinkets
        TRINKET_32 = "Cubic Zirconia Ball", -- Crystal Ball
        TRINKET_33 = "Spider Ring", -- Spider Ring
        TRINKET_34 = "Monkey Paw", -- Hand / Monkey Paw?
        TRINKET_35 = "Empty Elixir", -- Empty Potion Bottle
        TRINKET_36 = "Faux Fangs", -- Vampire Teeth
        TRINKET_37 = "Broken Stake", -- Wooden Stake
        TRINKET_38 = "Binoculars", -- Griftlands trinket
        TRINKET_39 = "Lone Glove", -- Griftlands trinket
        TRINKET_40 = "Snail Scale", -- Griftlands trinket
        TRINKET_41 = "Goop Canister", -- Hot Lava trinket
        TRINKET_42 = "Toy Cobra", -- Hot Lava trinket
        TRINKET_43= "Crocodile Toy", -- Hot Lava trinket
        TRINKET_44 = "Broken Terrarium", -- ONI trinket
        TRINKET_45 = "Odd Radio", -- ONI trinket
        TRINKET_46 = "Broken Hairdryer", -- ONI trinket
        --
        ANTLIONTRINKET = "Beach Toy", --bucket and shovel

        -- Lost toy number aligns with trinket names above.
        LOST_TOY_1 = "Lost Marbles",
        LOST_TOY_2 = "Sentimental Kazoo",
        LOST_TOY_7 = "Prized Ball and Cup",
        LOST_TOY_10 = "Missing Teeth",
        LOST_TOY_11 = "Cherished Toy Robot",
        LOST_TOY_14 = "Mother's Favorite Teacup",
        LOST_TOY_18 = "Treasured Toy Trojan Horse",
        LOST_TOY_19 = "Favorite Spinning Top",
        LOST_TOY_42 = "Misplaced Toy Cobra",
        LOST_TOY_43 = "Beloved Crocodile Toy",

        CARROT_PLANTED = "Carrot",
        LEIF = "Treeguard",
        LEIF_SPARSE = "Treeguard",

        BUTTERFLYMUFFIN = "Butter Muffin",
        FROGGLEBUNWICH = "Froggle Bunwich",
        HONEYHAM = "Honey Ham",
        DRAGONPIE = "Dragonpie",
        TAFFY = "Taffy",
        PUMPKINCOOKIE = "Pumpkin Cookies",
        KABOBS = "Kabobs",
        MANDRAKESOUP = "Mandrake Soup",
        BACONEGGS = "Bacon and Eggs",
        BONESTEW = "Meaty Stew",
        PEROGIES = "Pierogi",
        WETGOOP = "Wet Goop",
        RATATOUILLE = "Ratatouille",
        FRUITMEDLEY = "Fruit Medley",
        FISHTACOS ="Fish Tacos",
        WAFFLES ="Waffles",
        TURKEYDINNER = "Turkey Dinner",
        DRUMSTICK = "Drumstick",
        DRUMSTICK_COOKED = "Fried Drumstick",
        TENTACLESPOTS = "Tentacle Spots",
        PERD = "Gobbler",
        ABIGAIL = "Abigail",
        MINERHAT = "Miner Hat",
        FISHSTICKS = "Fishsticks",
        STUFFEDEGGPLANT = "Stuffed Eggplant",
        HONEYNUGGETS = "Honey Nuggets",
        MEATBALLS = "Meatballs",
        JAMMYPRESERVES = "Fist Full of Jam",
        MONSTERLASAGNA = "Monster Lasagna",
        FLOWERSALAD = "Flower Salad",
        ICECREAM = "Ice Cream",
        WATERMELONICLE = "Melonsicle",
        TRAILMIX = "Trail Mix",
        HOTCHILI = "Spicy Chili",
        GUACAMOLE = "Guacamole",
        SPIDERHAT = "Spiderhat",
        WORMHOLE = "Worm Hole",
        WORMHOLE_LIMITED = "Sick Worm Hole",

        WALL_WOOD_ITEM = "Wood Wall",
        WALL_STONE_ITEM = "Stone Wall",
        WALL_RUINS_ITEM = "Thulecite Wall",
        WALL_HAY_ITEM = "Hay Wall",
        WALL_MOONROCK_ITEM = "Moon Rock Wall",
		WALL_DREADSTONE_ITEM = "Dreadstone Wall",
        WALL_SCRAP_ITEM = "Scrap Wall",

        WALL_WOOD = "Wood Wall",
        WALL_STONE = "Stone Wall",
        WALL_RUINS = "Thulecite Wall",
        WALL_HAY = "Hay Wall",
        WALL_MOONROCK = "Moon Rock Wall",
		WALL_DREADSTONE = "Dreadstone Wall",
        WALL_SCRAP = "Scrap Wall",

        FENCE = "Wood Fence",
        FENCE_ITEM = "Wood Fence",
        FENCE_GATE = "Wood Gate",
        FENCE_GATE_ITEM = "Wood Gate",

        ANIMAL_TRACK = "Animal Track",
        DIRTPILE = "Suspicious Dirt Pile",
		KOALEFANT_CARCASS = "Koalefant Carcass",
        KOALEFANT_SUMMER = "Koalefant",
        KOALEFANT_WINTER = "Koalefant",
        TRUNK_SUMMER = "Koalefant Trunk",
        TRUNK_WINTER = "Winter Koalefant Trunk",
        TRUNK_COOKED = "Koalefant Trunk Steak",
        TRUNKVEST_SUMMER = "Breezy Vest",
        TRUNKVEST_WINTER = "Puffy Vest",
        BOOMERANG = "Boomerang",
        BUSHHAT = "Bush Hat",

        CRAWLINGHORROR = "Crawling Horror",
        TERRORBEAK = "Terrorbeak",
        CRAWLINGNIGHTMARE = "Crawling Nightmare",
        NIGHTMAREBEAK = "Nightmarebeak",
        NIGHTMAREFUEL = "Nightmare Fuel",
        NIGHTLIGHT = "Night Light",
        NIGHTSWORD = "Dark Sword",
        NIGHTSTICK = "Morning Star",

        DEERCLOPS = "Deerclops",
        BLUEGEM = "Blue Gem",

        ICESTAFF = "Ice Staff",
        FIRESTAFF = "Fire Staff",
        TELESTAFF = "Telelocator Staff",
        TELEBASE = "Telelocator Focus",
        GEMSOCKET = "Gem Stand",
        ORANGESTAFF = "The Lazy Explorer",
        GREENSTAFF = "Deconstruction Staff",
        YELLOWSTAFF = "Star Caller's Staff",
        OPALSTAFF = "Moon Caller's Staff",

        ICEHOUND = "Ice Hound",
        PENGUIN = "Pengull",
        DEERCLOPS_EYEBALL = "Deerclops Eyeball",
        GEARS = "Gears",
        NITRE = "Nitre",
        MAXWELLHEAD = "Maxwell's Head",
        DEADLYFEAST = "Deadly Feast",

        SINKHOLE = "Basalt",
        BASALT = "Basalt",
        BASALT_PILLAR = "Basalt Pillar",
        HOUNDMOUND = "Hound Mound",
        HOUNDBONE = "Bones",
        MERM = "Merm",
        MERMHOUSE = "Leaky Shack",

        MARBLEPILLAR = "Marble Pillar",
        MARBLETREE = "Marble Tree",
        MARBLE = "Marble",
        KNIGHT = "Clockwork Knight",
        BISHOP = "Clockwork Bishop",
        ROOK = "Clockwork Rook",
        MAXWELLPHONOGRAPH = "Maxwell's Phonograph",
        MAXWELLTHRONE = "Nightmare Throne",
        MAXWELLLOCK = "Nightmare Lock",

        STATUE_MARBLE = "Marble Sculpture",

        SCULPTURE_KNIGHTHEAD = "Suspicious Marble",
        SCULPTURE_KNIGHTBODY = "Marble Sculpture",
        SCULPTURE_BISHOPHEAD = "Suspicious Marble",
        SCULPTURE_BISHOPBODY = "Marble Sculpture",
        SCULPTURE_ROOKNOSE = "Suspicious Marble",
        SCULPTURE_ROOKBODY = "Marble Sculpture",

        SCULPTINGTABLE = "Potter's Wheel",

        GARGOYLE_HOUND = "Suspicious Moonrock",
        GARGOYLE_WEREPIG = "Suspicious Moonrock",

        TREASURECHEST_TRAP = "Treasure Chest",
        MEATRACK = "Drying Rack",
        BANDAGE = "Honey Poultice",
        HEALINGSALVE = "Healing Salve",
        WATERBALLOON = "Waterballoon",
        LIFEINJECTOR = "Booster Shot",
        CANE = "Walking Cane",
        LIGHTNING = "Lightning",
        LIGHTNING_ROD = "Lightning Rod",
        DIVININGROD = "Divining Rod",
        DIVININGRODBASE = "Divining Rod Holder",
        DIVININGRODSTART = "Divining Rod Holder",

        SLURTLE = "Slurtle",
        SLURTLESLIME = "Slurtle Slime",
        SLURTLEHOLE = "Slurtle Mound",
        SLURTLEHAT = "Shelmet",
        SNURTLE = "Snurtle",
        SLURTLE_SHELLPIECES = "Broken Shell",
        ARMORSNURTLESHELL = "Snurtle Shell Armor",
        MAGIC_BLUEPRINT = "Blank Blueprint",
        BLUEPRINT = "Blueprint",
        BLUEPRINT_RARE = "{item} Blueprint",
        SKETCH = "{item} Sketch",
        SKETCH_SCRAPBOOK = "Sketch",
        TACKLESKETCH = "{item} Advert",
        TACKLESKETCH_SCRAPBOOK = "Advert",
        COOKINGRECIPECARD = "{item} Recipe Card",
        COOKINGRECIPECARD_SCRAPBOOK = "Recipe Card",
        BAT = "Batilisk",
        TEAMLEADER = "Team Leader",
        BATWING = "Batilisk Wing",
        BATWING_COOKED = "Cooked Batilisk Wing",
        GUANO = "Guano",
        LANTERN = "Lantern",
        POWCAKE = "Powdercake",
        FLOWER_CAVE = "Light Flower",
        LIGHTBULB = "Light Bulb",
        STALAGMITE = "Stalagmite",
        STALAGMITE_TALL = "Stalagmite",

        SPIDERHOLE = "Spilagmite",
       -- SPIDERHOLE_ROCK = "Spilagmite",

        EYEPLANT = "Eye Plant",
        LUREPLANT = "Lureplant",
        LUREPLANTBULB = "Fleshy Bulb",
        BATBAT = "Bat Bat",
        BATCAVE = "Bat Cave",
        CAVE_FERN = "Fern",
        FOLIAGE = "Foliage",
        CAVE_BANANA_TREE = "Cave Banana Tree",
        CAVE_BANANA = "Banana",
        CAVE_BANANA_COOKED = "Cooked Banana",
        ROCKY = "Rock Lobster",
        MONKEY = "Splumonkey",
        MONKEYBARREL = "Splumonkey Pod",
        SLURPER = "Slurper",
        STAFFLIGHT = "Dwarf Star",
        STAFFCOLDLIGHT = "Polar Light",

        RELIC = "Relic",
        RUINS_RUBBLE = "Broken Relic",
        RUBBLE = "Rubble",
        RUINSRELIC_PLATE = "Replica Relic Plate",
        RUINSRELIC_BOWL = "Replica Relic Bowl",
        RUINSRELIC_CHAIR = "Replica Relic Chair",
        RUINSRELIC_CHIPBOWL = "Replica Relic Dish",
        RUINSRELIC_VASE = "Replica Relic Vase",
        RUINSRELIC_TABLE = "Replica Relic Table",
		VAULTRELIC = "Sanctum Relic",
		VAULTRELIC_BROKEN = "Broken Sanctum Relic",
		VAULTRELIC_BOWL = "Replica Sanctum Bowl",
		VAULTRELIC_VASE = "Replica Sanctum Vase",
		VAULTRELIC_PLANTER = "Replica Sanctum Planter",
        MULTITOOL_AXE_PICKAXE = "Pick/Axe",
        SLURPER_PELT = "Slurper Pelt",
        THULECITE = "Thulecite",
        ARMORRUINS = "Thulecite Suit",
        ARMORSLURPER = "Belt of Hunger",
        RUINS_BAT = "Thulecite Club",
        LICHEN = "Cave Lichen",
        CUTLICHEN = "Lichen",
        NIGHTMARE_TIMEPIECE = "Thulecite Medallion",
        BISHOP_NIGHTMARE = "Damaged Bishop",
        ROOK_NIGHTMARE = "Damaged Rook",
        KNIGHT_NIGHTMARE = "Damaged Knight",
        MINOTAUR = "Ancient Guardian",
        SPIDER_DROPPER = "Dangling Depth Dweller",
        NIGHTMARELIGHT = "Nightmare Light",

        THULECITE_PIECES = "Thulecite Fragments",
        RUINSHAT = "Thulecite Crown",
        POTTEDFERN = "Potted Fern",
        SUCCULENT_POTTED = "Potted Succulent",
        SUCCULENT_PLANT = "Succulent",
        SUCCULENT_PICKED = "Succulent",
        SENTRYWARD = "Ocuvigil",
        TOWNPORTAL = "The Lazy Deserter",
        TOWNPORTALTALISMAN = "Desert Stone",
        WETPAPER = "Paper",
        WETPOUCH = "Crumpled Package",
        GOGGLESHAT = "Fashion Goggles",
        DESERTHAT = "Desert Goggles",
        ANTLIONHAT = "Turf-Raiser Helm",
        ANTLION = "Antlion",
        ANTLION_SINKHOLE = "Sinkhole",
        SANDSPIKE = "Sand Spike",
        SANDBLOCK = "Sand Castle",
        GLASSSPIKE = "Glass Spike",
        GLASSBLOCK = "Glass Castle",
        MOONBASE = "Moon Stone",
        MOONDIAL = "Moon Dial",
        MOONROCK_PIECES = "Moon Rubble",
        UNAGI = "Unagi",
        EEL = "Eel",
        EEL_COOKED = "Cooked Eel",
        EYETURRET = "Houndius Shootius",
        EYETURRET_ITEM = "Houndius Shootius",
        MINOTAURHORN = "Guardian's Horn",
        POND_ALGAE = "Algae",
        WORMLIGHT = "Glow Berry",
        WORMLIGHT_LESSER = "Lesser Glow Berry",

        WORMLIGHT_PLANT = "Mysterious Plant",

        WORM_PLANT = "Mysterious Plant",
        WORM_DIRT = "Dirt Mound",
        WORM = "Depths Worm",

        MOSQUITOSACK = "Mosquito Sack",
        LIVINGTREE = "Totally Normal Tree",
        LIVINGTREE_ROOT = "Totally Normal Root",
		LIVINGTREE_SAPLING = "Totally Normal Sapling",

		-- Waxwell
        WAXWELLJOURNAL = "Codex Umbra",
		MAGICIAN_CHEST = "Magician's Chest",
		TOPHAT_MAGICIAN = "Magician's Top Hat",
        SHADOWWAXWELL = "Shadow",
        SHADOWLUMBER_BUILDER = "Shadow Logger",
        SHADOWMINER_BUILDER = "Shadow Miner",
        SHADOWDIGGER_BUILDER = "Shadow Digger",
        SHADOWDUELIST_BUILDER = "Shadow Duelist",
        SHADOWDANCER = "Shadow Dancer",

        SHADOWTENTACLE = "Shadow Tentacle",

        ACCOMPLISHMENT_SHRINE = "Accomploshrine",

        NIL = "Darkness",
        DARKNESS = "Darkness",
        CHARLIE = "Charlie",
        HUNGER = "Starvation",
        COLD = "Freezing",
        HOT = "Overheating",
        ACIDRAIN = "Acid Rain",
        MIASMA = "Miasma",
        SHENANIGANS = "Shenanigans",
        RESURRECTION_PENALTY = "Resurrection Sickness",

        UNKNOWN = "Unknown",

        BEARGER = "Bearger",
        BEARGER_FUR = "Thick Fur",
        BIGFOOT = "Biiigfoot",
        WATER = "Short Circuit",
        RAIN = "Short Circuit",

        SPEAR_WATHGRITHR = "Battle Spear",
        WATHGRITHRHAT = "Battle Helm",

        MOOSE1 = "Moose",
        MOOSE2 = "Goose",
        MOOSEEGG1 = "Moose Egg",
        MOOSEEGG2 = "Goose Egg",
        MOOSENEST1 = "Moose Nest",
        MOOSENEST2 = "Goose Nest",
        MOSSLING = "Mosling",
        GOOSE_FEATHER = "Down Feather",
        WINTEROMETER = "Thermal Measurer",
        BIRCHNUTDRAKE = "Birchnutter",
        DECIDUOUSTREE = "Birchnut Tree",
        DECIDUOUS_ROOT = "Birchnut Tree", --This is never used in game: this is for morgue screen (deaths by root)
        ACORN = "Birchnut",
        ACORN_SAPLING = "Birchnut Sapling",

        GLOMMER = "Glommer",
        GLOMMERFLOWER = "Glommer's Flower",
        GLOMMERWINGS = "Glommer's Wings",
        GLOMMERFUEL = "Glommer's Goop",
        STATUEGLOMMER = "Glommer's Statue",

        DEER = "No-Eyed Deer",
        DEER_GEMMED = "No-Eyed Deer",
        DEER_ANTLER = "Deer Antler",

        KLAUS = "Klaus",
        KLAUS_SACK = "Loot Stash",
        KLAUSSACKKEY = "Stag Antler",

        CACTUS = "Cactus",
        CACTUS_MEAT = "Cactus Flesh",
        CACTUS_FLOWER = "Cactus Flower",
        LIGHTNINGGOAT = "Volt Goat",
        GOATMILK = "Electric Milk",
        BUZZARD = "Buzzard",

        DRAGONFLY = "Dragonfly",
        DRAGON_SCALES = "Scales",
        LAVASPIT = "Dragonfly Saliva",

        RAINCOAT = "Rain Coat",
        RAINHAT = "Rain Hat",
        GRASS_UMBRELLA = "Pretty Parasol",
        ICEHAT = "Ice Cube",
        MOLEHAT = "Moggles",
        TRANSISTOR = "Electrical Doodad",
        LIGHTNINGGOATHORN = "Volt Goat Horn",
        MOLE_UNDERGROUND = "Raised Dirt",
        MOLE_ABOVEGROUND = "Moleworm",
        MOLE = "Moleworm",
        MOLEHILL = "Burrow",
        BONESHARD = "Bone Shards",

        FERTILIZER = "Bucket-o-poop",
        FIRESUPPRESSOR = "Ice Flingomatic",
        CACTUS_MEAT_COOKED = "Cooked Cactus Flesh",
        ACORN_COOKED = "Roasted Birchnut",
        WEBBERSKULL = "Webber's Skull",

        WATERMELON = "Watermelon",
        WATERMELON_COOKED = "Grilled Watermelon",
        WATERMELONHAT = "Fashion Melon",
        CATCOONHAT = "Cat Cap",
        CATCOON = "Catcoon",
        CATCOONDEN = "Hollow Stump",
        COONTAIL = "Cat Tail",
        BELL = "Old Bell",

        WARG = "Varg",
        WARGLET = "Varglet",

        SPAT = "Ewecus",
        STEELWOOL = "Steel Wool",
        PHLEGM = "Phlegm",

        CRITTERLAB = "Rock Den",

        CRITTER_LAMB = "Ewelet",
        CRITTER_PUPPY = "Vargling",
        CRITTER_KITTEN = "Kittykit",
        CRITTER_PERDLING = "Giblet",
        CRITTER_DRAGONLING = "Broodling",
        CRITTER_GLOMLING = "Glomglom",
		CRITTER_LUNARMOTHLING = "Mothling",

        CRITTER_LAMB_BUILDER = "Ewelet",
        CRITTER_PUPPY_BUILDER = "Vargling",
        CRITTER_KITTEN_BUILDER = "Kittykit",
        CRITTER_PERDLING_BUILDER = "Giblet",
        CRITTER_DRAGONLING_BUILDER = "Broodling",
        CRITTER_GLOMLING_BUILDER = "Glomglom",
		CRITTER_LUNARMOTHLING_BUILDER = "Mothling",

        BEARGERVEST = "Hibearnation Vest",
        ARMORDRAGONFLY = "Scalemail",
        STAFF_TORNADO = "Weather Pain",
        TORNADO = "Tornado",
        EYEBRELLAHAT = "Eyebrella",
        FEATHERFAN = "Luxury Fan",
        MINIFAN = "Whirly Fan",
        WHIP = "Tail o' Three Cats",

        RESKIN_TOOL = "Clean Sweeper",

        REVIVER = "Telltale Heart",

        SHADOWHEART = "Shadow Atrium",
        ATRIUM_RUBBLE = "Ancient Mural",
        ATRIUM_STATUE = "Ancient Statue",
        ATRIUM_LIGHT = "Ancient Beacon",
        ATRIUM_GATE = "Ancient Gateway",
        ATRIUM_KEY = "Ancient Key",
        ATRIUM_OVERGROWTH = "Ancient Obelisk",

        SACRED_CHEST = "Ancient Chest",

        SHADOWMETEOR = "Meteor",

        MOONROCKNUGGET = "Moon Rock",
        MOONROCKCRATER = "Cratered Moonrock",
		MOONROCKSEED = "Celestial Orb",

        REDMOONEYE ="Red Moonlens",
        PURPLEMOONEYE = "Purple Moonlens",
        GREENMOONEYE = "Green Moonlens",
        ORANGEMOONEYE = "Orange Moonlens",
        YELLOWMOONEYE = "Yellow Moonlens",
        BLUEMOONEYE = "Blue Moonlens",

        LAVAE = "Lavae",
        LAVAE_PET = "Extra-Adorable Lavae",
        LAVAE_EGG = "Lavae Egg",
        LAVAE_EGG_CRACKED = "Lavae Egg",
        LAVAE_TOOTH = "Lavae Tooth",
        LAVAE_COCOON = "Chilled Lavae",
        LAVA_POND = "Magma",
        LAVA_POND_ROCK = "Rock",

        BERNIE_INACTIVE = "Bernie",
        BERNIE_ACTIVE = "Bernie",
        BERNIE_BIG = "BERNIE!",
        --ASHLEY_INACTIVE = "Ashley",
        --ASHLEY_ACTIVE = "Ashley",
        --ASHLEY_BIG = "ASHLEY!",

        DECREASE_HEALTH = "Health",
        HALF_HEALTH = "Maximum Health",
        DECREASE_SANITY = "Sanity",
        HALF_SANITY = "Maximum Sanity",
		DECREASE_OLDAGE = "Years",

        SCULPTING_MATERIAL = "Sculpting Block",

        GRASSGEKKO = "Grass Gekko",
        ROCK_PETRIFIED_TREE = "Petrified Tree",
        TWIGGYTREE = "Twiggy Tree",

        HUTCH = "Hutch",
        HUTCH_FISHBOWL = "Star-sky",

        MUSHROOMHAT = "Funcap",
        RED_MUSHROOMHAT = "Red Funcap",
        GREEN_MUSHROOMHAT = "Green Funcap",
        BLUE_MUSHROOMHAT = "Blue Funcap",
        MOON_MUSHROOMHAT = "Lunar Funcap",
        MUSHROOM_LIGHT2 = "Glowcap",
        MUSHROOM_LIGHT = "Mushlight",
        SHROOM_SKIN = "Shroom Skin",

        TOADSTOOL = "Toadstool",
        TOADSTOOL_CAP = "Toadstool",
        TOADSTOOL_HOLE = "Hole",
        MUSHROOMBOMB = "Boomshroom",
        MUSHROOMSPROUT = "Sporecap",
        SPORECLOUD = "Spore Cloud",

        TOADSTOOL_DARK = "Misery Toadstool",
        TOADSTOOL_CAP_DARK = "Misery Toadstool",
        MUSHROOMBOMB_DARK = "Misery Boomshroom",
        MUSHROOMSPROUT_DARK = "Misery Sporecap",

        SLEEPBOMB = "Napsack",

        BEEQUEEN = "Bee Queen",
        BEEQUEENHIVE = "Honey Patch",
        BEEQUEENHIVEGROWING = "Somewhat Gigantic Beehive",
        BEEQUEENHIVEGROWN = "Gigantic Beehive",
        BEEGUARD = "Grumble Bee",
        ROYAL_JELLY = "Royal Jelly",
        JELLYBEAN = "Jellybeans",
        HIVEHAT = "Bee Queen Crown",

        CHESSPIECE_PAWN = "Pawn Figure",
        CHESSPIECE_ROOK = "Rook Figure",
        CHESSPIECE_KNIGHT = "Knight Figure",
        CHESSPIECE_BISHOP = "Bishop Figure",
        CHESSPIECE_MUSE = "Queenly Figure",
        CHESSPIECE_FORMAL = "Kingly Figure",
        CHESSPIECE_HORNUCOPIA = "Carved Hornucopia",
        CHESSPIECE_PIPE = "Bubble Pipe Carving",
        CHESSPIECE_DEERCLOPS = "Deerclops Figure",
        CHESSPIECE_BEARGER = "Bearger Figure",
        CHESSPIECE_MOOSEGOOSE = "Moose Figure",
        CHESSPIECE_MOOSEGOOSE_ALT = "Goose Figure",
        CHESSPIECE_DRAGONFLY = "Dragonfly Figure",
        CHESSPIECE_MINOTAUR = "Ancient Guardian Figure",
        CHESSPIECE_CLAYHOUND = "Hound Figure",
        CHESSPIECE_CLAYWARG = "Varg Figure",
        CHESSPIECE_BUTTERFLY = "Moon Moth Figure",
        CHESSPIECE_ANCHOR = "Anchor Figure",
        CHESSPIECE_MOON = "\"Moon\" Figure",
        CHESSPIECE_CARRAT = "Carrat Figure",
        CHESSPIECE_BEEFALO = "Beefalo Figure",
        CHESSPIECE_KITCOON = "Kitcoon Figure",
        CHESSPIECE_CATCOON = "Catcoon Figure",
        CHESSPIECE_MANRABBIT = "Bunnyman Figure",
        CHESSPIECE_MALBATROSS = "Malbatross Figure",
        CHESSPIECE_CRABKING = "Crab King Figure",
        CHESSPIECE_TOADSTOOL = "Toadstool Figure",
        CHESSPIECE_STALKER = "Ancient Fuelweaver Figure",
        CHESSPIECE_KLAUS = "Klaus Figure",
        CHESSPIECE_BEEQUEEN = "Bee Queen Figure",
        CHESSPIECE_ANTLION = "Antlion Figure",
        CHESSPIECE_GUARDIANPHASE3 = "Celestial Champion Figure",
		CHESSPIECE_EYEOFTERROR = "Eye Of Terror Figure",
        CHESSPIECE_TWINSOFTERROR = "Twins of Terror Figure",
        CHESSPIECE_DAYWALKER = "Nightmare Werepig Figure",
        CHESSPIECE_DAYWALKER2 = "Scrappy Werepig Figure",
        CHESSPIECE_DEERCLOPS_MUTATED = "Crystal Deerclops Figure",
        CHESSPIECE_WARG_MUTATED = "Possessed Varg Figure",
        CHESSPIECE_BEARGER_MUTATED = "Armored Bearger Figure",
        CHESSPIECE_YOTD = "Start Tower Figure",
        CHESSPIECE_SHARKBOI = "Frostjaw Figure",
        CHESSPIECE_WORMBOSS = "Great Depths Worm Figure",
        CHESSPIECE_YOTS = "Gilded Depths Worm Figure",
        CHESSPIECE_WAGBOSS_ROBOT = "W.A.R.B.O.T. Figure",
        CHESSPIECE_WAGBOSS_LUNAR = "Celestial Scion Figure",

        CHESSPIECE_PAWN_BUILDER = "Pawn Figure",
        CHESSPIECE_ROOK_BUILDER = "Rook Figure",
        CHESSPIECE_KNIGHT_BUILDER = "Knight Figure",
        CHESSPIECE_BISHOP_BUILDER = "Bishop Figure",
        CHESSPIECE_MUSE_BUILDER = "Queenly Figure",
        CHESSPIECE_FORMAL_BUILDER = "Kingly Figure",
        CHESSPIECE_HORNUCOPIA_BUILDER = "Carved Hornucopia",
        CHESSPIECE_PIPE_BUILDER = "Bubble Pipe Carving",
        CHESSPIECE_DEERCLOPS_BUILDER = "Deerclops Figure",
        CHESSPIECE_BEARGER_BUILDER = "Bearger Figure",
        CHESSPIECE_MOOSEGOOSE_BUILDER = "Moose/Goose Figure",
        CHESSPIECE_DRAGONFLY_BUILDER = "Dragonfly Figure",
        CHESSPIECE_MINOTAUR_BUILDER = "Ancient Guardian Figure",
        CHESSPIECE_CLAYHOUND_BUILDER = "Hound Figure",
        CHESSPIECE_CLAYWARG_BUILDER = "Varg Figure",
        CHESSPIECE_BUTTERFLY_BUILDER = "Moon Moth Figure",
        CHESSPIECE_ANCHOR_BUILDER = "Anchor Figure",
        CHESSPIECE_MOON_BUILDER = "\"Moon\" Figure",
        CHESSPIECE_CARRAT_BUILDER = "Carrat Figure",
        CHESSPIECE_BEEFALO_BUILDER = "Beefalo Figure",
        CHESSPIECE_KITCOON_BUILDER = "Kitcoon Figure",
        CHESSPIECE_CATCOON_BUILDER = "Catcoon Figure",
        CHESSPIECE_MANRABBIT_BUILDER = "Bunnyman Figure",
        CHESSPIECE_MALBATROSS_BUILDER = "Malbatross Figure",
        CHESSPIECE_CRABKING_BUILDER = "Crab King Figure",
        CHESSPIECE_TOADSTOOL_BUILDER = "Toadstool Figure",
        CHESSPIECE_STALKER_BUILDER = "Ancient Fuelweaver Figure",
        CHESSPIECE_KLAUS_BUILDER = "Klaus Figure",
        CHESSPIECE_BEEQUEEN_BUILDER = "Bee Queen Figure",
        CHESSPIECE_ANTLION_BUILDER = "Antlion Figure",
        CHESSPIECE_GUARDIANPHASE3_BUILDER = "Celestial Champion Figure",
		CHESSPIECE_EYEOFTERROR_BUILDER = "Eye Of Terror Figure",
        CHESSPIECE_TWINSOFTERROR_BUILDER = "Twins of Terror Figure",
        CHESSPIECE_DAYWALKER_BUILDER = "Nightmare Werepig Figure",
        CHESSPIECE_DAYWALKER2_BUILDER = "Scrappy Werepig Figure",
        CHESSPIECE_DEERCLOPS_MUTATED_BUILDER = "Crystal Deerclops Figure",
        CHESSPIECE_WARG_MUTATED_BUILDER = "Possessed Varg Figure",
        CHESSPIECE_BEARGER_MUTATED_BUILDER = "Armored Bearger Figure",
        CHESSPIECE_YOTD_BUILDER = "Start Tower Figure",
        CHESSPIECE_SHARKBOI_BUILDER = "Frostjaw Figure",
        CHESSPIECE_WORMBOSS_BUILDER = "Great Depths Worm Figure",
        CHESSPIECE_YOTS_BUILDER = "Gilded Depths Worm Figure",
        CHESSPIECE_WAGBOSS_ROBOT_BUILDER = "W.A.R.B.O.T. Figure",
        CHESSPIECE_WAGBOSS_LUNAR_BUILDER = "Celestial Scion Figure",

        CHESSPIECE_BUTTERFLY_SKETCH = "Moon Moth Figure Sketch",
        CHESSPIECE_ANCHOR_SKETCH = "Anchor Figure Sketch",
        CHESSPIECE_MOON_SKETCH = "\"Moon\" Figure Sketch",
        CHESSPIECE_CARRAT_SKETCH = "Carrat Figure Sketch",
        CHESSPIECE_BEEFALO_SKETCH = "Beefalo Figure Sketch",
        CHESSPIECE_KITCOON_SKETCH = "Kitcoon Figure Sketch",
        CHESSPIECE_CATCOON_SKETCH = "Catcoon Figure Sketch",
        CHESSPIECE_MALBATROSS_SKETCH = "Malbatross Figure Sketch",
        CHESSPIECE_CRABKING_SKETCH = "Crab King Figure Sketch",
        CHESSPIECE_GUARDIANPHASE3_SKETCH = "Celestial Champion Figure Sketch",
        CHESSPIECE_MANRABBIT_SKETCH = "Bunnyman Figure Sketch",
        CHESSPIECE_DAYWALKER_SKETCH = "Nightmare Werepig Figure Sketch",
        CHESSPIECE_DAYWALKER2_SKETCH = "Scrappy Werepig Figure Sketch",
        CHESSPIECE_DEERCLOPS_MUTATED_SKETCH = "Crystal Deerclops Figure Sketch",
        CHESSPIECE_WARG_MUTATED_SKETCH = "Possessed Varg Figure Sketch",
        CHESSPIECE_BEARGER_MUTATED_SKETCH = "Armored Bearger Figure Sketch",
        CHESSPIECE_YOTD_SKETCH = "Start Tower Figure Sketch",
        CHESSPIECE_SHARKBOI_SKETCH = "Frostjaw Figure Sketch",
        CHESSPIECE_YOTS_SKETCH = "Gilded Depths Worm Figure Sketch",
        CHESSPIECE_WAGBOSS_ROBOT_SKETCH = "W.A.R.B.O.T. Figure Sketch",
        CHESSPIECE_WAGBOSS_LUNAR_SKETCH = "Celestial Scion Figure Sketch",

        SHADOW_ROOK = "Shadow Rook",
        SHADOW_KNIGHT = "Shadow Knight",
        SHADOW_BISHOP = "Shadow Bishop",

        MULTIPLAYER_PORTAL_MOONROCK = "Celestial Portal",
        MULTIPLAYER_PORTAL_MOONROCK_CONSTR_PLANS = "Portal Paraphernalia",
        MOONROCKIDOL = "Moon Rock Idol",

		--MOON_ALTAR--
		BATHBOMB_BLUEPRINT = "Bath Bomb Blueprint",
		MOONGLASSAXE_BLUEPRINT = "Moon Axe Blueprint",
		GLASSCUTTER_BLUEPRINT = "Glass Cutter Blueprint",
		TURF_METEOR_BLUEPRINT = "Crater Turf Blueprint",
		BUTTERFLY_SKETCH = "Moon Moth Sketch",
        ANCHOR_SKETCH = "\"Moon\" Sketch",

        HALLOWEENCANDY_1 = "Candy Apple",
        HALLOWEENCANDY_2 = "Candy Corn",
        HALLOWEENCANDY_3 = "Not-So-Candy Corn",
        HALLOWEENCANDY_4 = "Gummy Spider",
        HALLOWEENCANDY_5 = "Catcoon Candy",
        HALLOWEENCANDY_6 = "\"Raisins\"",
        HALLOWEENCANDY_7 = "Raisins",
        HALLOWEENCANDY_8 = "Ghost Pop",
        HALLOWEENCANDY_9 = "Jelly Worm",
        HALLOWEENCANDY_10 = "Tentacle Lolli",
        HALLOWEENCANDY_11 = "Choco Pigs",
        HALLOWEENCANDY_12 = "Candy Lice",
        HALLOWEENCANDY_13 = "Otherworldly Jawbreaker",
        HALLOWEENCANDY_14 = "Lava Pepper",
        CANDYBAG = "Candy Bag",

		MADSCIENCE_LAB = "Mad Scientist Lab",
		HALLOWEEN_EXPERIMENT_BRAVERY = "Phobic Experiment",
		HALLOWEEN_EXPERIMENT_HEALTH = "Sanguine Experiment",
		HALLOWEEN_EXPERIMENT_SANITY = "Psychosis Experiment",
		HALLOWEEN_EXPERIMENT_VOLATILE = "Sulfuric Experiment",
		HALLOWEEN_EXPERIMENT_MOON = "Lunar Experiment",
		HALLOWEEN_EXPERIMENT_ROOT = "Arboretum Experiment",

		CARNIVAL_HOST = "Corvus Goodfeather",
		CARNIVAL_CROWKID = "Crow Kid",
		CARNIVAL_PRIZETICKET = "Prize Tickets",
		CARNIVAL_GAMETOKEN = "Cawnival Token",
		CARNIVAL_GAMETOKEN_MULTIPLE = "3 Cawnival Tokens",

		CARNIVAL_PRIZEBOOTH = "Prize Booth",
		CARNIVAL_PRIZEBOOTH_KIT = "Prize Booth Kit",
		CARNIVAL_PLAZA = "Cawnival Tree",
		CARNIVAL_PLAZA_KIT = "Cawnival Sapling",

		CARNIVAL_VEST_A = "Chirpy Scarf",
		CARNIVAL_VEST_B = "Chirpy Cloak",
		CARNIVAL_VEST_C = "Chirpy Capelet",

		CARNIVALGAME_FEEDCHICKS_KIT = "Hubbub for Grub Kit",
		CARNIVALGAME_FEEDCHICKS_STATION = "Hubbub for Grub",
		CARNIVALGAME_FEEDCHICKS_NEST = "Hungry Crow",
		CARNIVALGAME_FEEDCHICKS_NEST_OFF = "Trapdoor",
		CARNIVALGAME_FEEDCHICKS_FOOD = "Grub",
		CARNIVALGAME_MEMORY_KIT = "Eggs in a Basket Kit",
		CARNIVALGAME_MEMORY_STATION = "Eggs in a Basket",
		CARNIVALGAME_MEMORY_CARD = "Egg Basket",
		CARNIVALGAME_MEMORY_CARD_OFF = "Trapdoor",
		CARNIVALGAME_HERDING_KIT = "Egg Scramble Kit",
		CARNIVALGAME_HERDING_STATION = "Egg Scramble",
		CARNIVALGAME_HERDING_CHICK = "Scrambling Egg",
        CARNIVALGAME_SHOOTING_KIT = "Nest Defender Kit",
		CARNIVALGAME_SHOOTING_STATION = "Nest Defender",
        CARNIVALGAME_SHOOTING_BUTTON = "Button",
        CARNIVALGAME_SHOOTING_BUTTON_OFF = "Nest Defender",
		CARNIVALGAME_SHOOTING_TARGET = "Target",
		CARNIVALGAME_SHOOTING_TARGET_OFF = "Trapdoor",
		CARNIVALGAME_WHEELSPIN_KIT = "Cuckoo Spinwheel Kit",
		CARNIVALGAME_WHEELSPIN_STATION = "Cuckoo Spinwheel",
		CARNIVALGAME_PUCKDROP_KIT = "Birdhouse Ball Drop Kit",
		CARNIVALGAME_PUCKDROP_STATION = "Birdhouse Ball Drop",

		CARNIVALDECOR_PLANT = "Miniature Tree",
		CARNIVALDECOR_PLANT_KIT = "Miniature Tree Kit",
		CARNIVALDECOR_BANNER = "Light Catcher",
		CARNIVALDECOR_BANNER_KIT = "Light Catcher Kit",
		CARNIVALDECOR_FIGURE_RARE = "Rare Cawnival Statuette",
		CARNIVALDECOR_FIGURE_UNCOMMON = "Uncommon Cawnival Statuette",
		CARNIVALDECOR_FIGURE_COMMON = "Common Cawnival Statuette",
		CARNIVALDECOR_FIGURE_KIT = "Green Mystery Box",
		CARNIVALDECOR_FIGURE_KIT_SEASON2 = "Gold Mystery Box",
		CARNIVALDECOR_EGGRIDE1 = "Mini Ferris Wheel",
		CARNIVALDECOR_EGGRIDE1_KIT = "Mini Ferris Wheel Kit",
		CARNIVALDECOR_EGGRIDE2 = "Mini Swing Carousel",
		CARNIVALDECOR_EGGRIDE2_KIT = "Mini Swing Carousel Kit",
		CARNIVALDECOR_EGGRIDE3 = "Mini Pendulum Ride",
		CARNIVALDECOR_EGGRIDE3_KIT = "Mini Pendulum Ride Kit",
		CARNIVALDECOR_EGGRIDE4 = "Mini Tower Drop",
		CARNIVALDECOR_EGGRIDE4_KIT = "Mini Tower Drop Kit",
		CARNIVALDECOR_LAMP = "Midsummer Night Light",
		CARNIVALDECOR_LAMP_KIT = "Midsummer Night Light Kit",
		CARNIVALCANNON_CONFETTI = "Confetti Cannon",
		CARNIVALCANNON_CONFETTI_KIT = "Confetti Cannon Kit",
		CARNIVALCANNON_SPARKLE = "Glitter Cannon",
		CARNIVALCANNON_SPARKLE_KIT = "Glitter Cannon Kit",
		CARNIVALCANNON_STREAMER = "Streamer Cannon",
		CARNIVALCANNON_STREAMER_KIT = "Streamer Cannon Kit",
		CARNIVAL_SEEDPACKET = "Seed Clusters",
        CARNIVAL_BALL = "Shiny Red Ball",
		CARNIVALFOOD_CORNTEA = "Corny Slush",

        WINTER_TREESTAND = "Festive Tree Planter",
        WINTER_TREE = "Winter's Feast Tree",
        WINTER_ORNAMENT = "Festive Bauble",
        WINTER_ORNAMENTLIGHT = "Festive Light",
        WINTER_ORNAMENTBOSS = "Magnificent Adornment",
		WINTER_ORNAMENTFORGE = "Champion Adornment",
		WINTER_ORNAMENTGORGE = "Appeasing Adornment",
		WINTER_ORNAMENTPEARL = "Sentimental Adornment",

		WINTER_ORNAMENT_BOSS_HERMITHOUSE = "Sentimental Adornment",
		WINTER_ORNAMENT_BOSS_PEARL = "Sentimental Adornment",

        WINTER_FOOD1 = "Gingerbread Cookie",
        WINTER_FOOD2 = "Sugar Cookie",
        WINTER_FOOD3 = "Candy Cane",
        WINTER_FOOD4 = "Eternal Fruitcake",
        WINTER_FOOD5 = "Chocolate Log Cake",
        WINTER_FOOD6 = "Plum Pudding",
        WINTER_FOOD7 = "Apple Cider",
        WINTER_FOOD8 = "Hot Cocoa",
        WINTER_FOOD9 = "Heavenly Eggnog",

		--Dishes are not final - let these be for now
		WINTERSFEASTOVEN = "Masonry Oven",
		WINTERCOOKING_BERRYSAUCE = "Merry Berrysauce",
		WINTERCOOKING_BIBINGKA = "Bibingka",
		WINTERCOOKING_CABBAGEROLLS = "Cabbage Rolls",
		WINTERCOOKING_FESTIVEFISH = "Festive Fish Dish",
		WINTERCOOKING_GRAVY = "Good Gravy",
		WINTERCOOKING_LATKES = "Latkes",
		WINTERCOOKING_LUTEFISK = "Lutefisk",
		WINTERCOOKING_MULLEDDRINK = "Mulled Punch",
		WINTERCOOKING_PANETTONE = "Panettone",
		WINTERCOOKING_PAVLOVA = "Pavlova",
		WINTERCOOKING_PICKLEDHERRING = "Pickled Herring",
		WINTERCOOKING_POLISHCOOKIE = "Polish Cookies",
		WINTERCOOKING_PUMPKINPIE = "Pumpkin Pie",
		WINTERCOOKING_ROASTTURKEY = "Roasted Turkey",
		WINTERCOOKING_STUFFING = "Stuffing",
		WINTERCOOKING_SWEETPOTATO = "Sweet Potato Casserole",
		WINTERCOOKING_TAMALES = "Tamales",
		WINTERCOOKING_TOURTIERE = "Tourtiere",

		GINGERBREADWARG = "Gingerbread Varg",
		GINGERBREADHOUSE = "Gingerbread Pig House",
		GINGERBREADPIG = "Gingerbread Pig",
        GINGERDEADPIG = "Gingerbread Pig",
		CRUMBS = "Cookie Crumbles" ,
		WINTERSFEASTFUEL = "Holiday Cheer",

		--Dishes are not final - let these be for now
		BERRYSAUCE = "Merry Berrysauce",
		BIBINGKA = "Bibingka",
		CABBAGEROLLS = "Cabbage Rolls",
		FESTIVEFISH = "Festive Fish Dish",
		GRAVY = "Good Gravy",
		LATKES = "Latkes",
		LUTEFISK = "Lutefisk",
		MULLEDDRINK = "Mulled Punch",
		PANETTONE = "Panettone",
		PAVLOVA = "Pavlova",
		PICKLEDHERRING = "Pickled Herring",
		POLISHCOOKIE = "Polish Cookies",
		PUMPKINPIE = "Pumpkin Pie",
		ROASTTURKEY = "Roasted Turkey",
		STUFFING = "Stuffing",
		SWEETPOTATO = "Sweet Potato Casserole",
		TAMALES = "Tamales",
		TOURTIERE = "Tourtiere",

		TABLE_WINTERS_FEAST = "Winter's Feast Table",

		HALLOWEEN_ORNAMENT_1 = "Ghost Decoration",
		HALLOWEEN_ORNAMENT_2 = "Bat Decoration",
		HALLOWEEN_ORNAMENT_3 = "Spider Decoration",
		HALLOWEEN_ORNAMENT_4 = "Tentacle Decoration",
		HALLOWEEN_ORNAMENT_5 = "Dangling Depth Dweller Decoration",
		HALLOWEEN_ORNAMENT_6 = "Crow Decoration",

		HALLOWEENPOTION_BRAVERY_SMALL = "Brew of Phobic Abatement",
		HALLOWEENPOTION_BRAVERY_LARGE = "Brew of Phobic Abrogation",
		HALLOWEENPOTION_SANITY_SMALL = "Dram of Psychic Fortitude",
		HALLOWEENPOTION_SANITY_LARGE = "Tumblerful of Psychic Fortitude",
		HALLOWEENPOTION_HEALTH_SMALL = "Flask of Sanguine Mixture",
		HALLOWEENPOTION_HEALTH_LARGE = "Canteen of Sanguine Mixture",
		HALLOWEENPOTION_EMBERS = "Sulfuric Crystals of Lime",
		HALLOWEENPOTION_SPARKS = "Sulfuric Crystals of Saltpeter",
		HALLOWEENPOTION_MOON = "Steeped Lunar Essence",

		YOTC_CARRAT_RACE_START = "Starting Point",
		YOTC_CARRAT_RACE_START_ITEM = "Starting Point Kit",
        YOTC_CARRAT_RACE_CHECKPOINT = "Checkpoint",
		YOTC_CARRAT_RACE_CHECKPOINT_ITEM = "Checkpoint Kit",
		YOTC_CARRAT_RACE_FINISH = "Finish Line",
		YOTC_CARRAT_RACE_FINISH_ITEM = "Finish Line Kit",

		YOTC_SEEDPACKET = "Packet of Seeds",
		YOTC_SEEDPACKET_RARE = "Premium Seed Packet",


        YOT_CATCOONSHRINE = "Catcoon Shrine",
        KITCOONDEN = "Kitcoon Nursery",
        KITCOONDEN_KIT = "Kitcoon Nursery Kit",
        CATTOY_MOUSE = "Wind-up Mouse Toy",

        KITCOON_NAMETAG = "Kit Collar",

		KITCOONDECOR1	= "Gobbler Wobbler",
		KITCOONDECOR2	= "Kit Teaser",

        KITCOONDECOR1_KIT = "Gobbler Wobbler Kit",
		KITCOONDECOR2_KIT = "Kit Teaser Kit",

		KITCOON_FOREST = "Kitcoon",
		KITCOON_SAVANNA = "Kitcoon",
		KITCOON_MARSH = "Kitcoon",
		KITCOON_DECIDUOUS = "Kitcoon",
		KITCOON_GRASS = "Kitcoon",
		KITCOON_ROCKY = "Kitcoon",
		KITCOON_DESERT = "Kitcoon",
		KITCOON_MOON = "Kitcoon",
		KITCOON_YOT = "Kitcoon",

        TICOON = "Ticoon",
        TICOON_BUILDER = "Ticoon",

        YOTR_RABBITSHRINE = "Bunnyman Shrine",
        COZY_BUNNYMAN = "Cozy Bunnyman",

        HANDPILLOW_BEEFALOWOOL = "Beefalo Wool Pillow",
        HANDPILLOW_KELP = "Kelp-Stuffed Pillow",
        HANDPILLOW_PETALS = "Flowery Pillow",
        HANDPILLOW_STEELWOOL = "Steel Wool Pillow",

        BODYPILLOW_BEEFALOWOOL = "Beefalo Pillow Armor",
        BODYPILLOW_KELP = "Kelpy Pillow Armor",
        BODYPILLOW_PETALS = "Flowery Pillow Armor",
        BODYPILLOW_STEELWOOL = "Steel Wool Pillow Armor",

        YOTR_FOOD1 = "Bunny Roll",
        YOTR_FOOD2 = "Moon Cake",
        YOTR_FOOD3 = "Moon Jelly",
        YOTR_FOOD4 = "Skewered Puffs",
        YOTR_TOKEN = "Glove of Challenge",

        --Arena Event
        LAVAARENA_BOARLORD = "Battlemaster Pugna",
        BOARRIOR = "Grand Forge Boarrior",
        BOARON = "Pit Pig",
        PEGHOOK = "Scorpeon",
        PEGHOOK_DOT = "Scorpeon Acid",
        TRAILS1 = "Boarilla",
        TRAILS2 = "Boarilla",
        TRAILS = "Boarilla",
        TURTILLUS = "Snortoise",
        SNAPPER = "Crocommander",
        RHINODRILL = "Rhinocebro Snapback",
        RHINODRILL2 = "Rhinocebro Flatbrim",
        BEETLETAUR = "Infernal Swineclops",

        LAVAARENA_PORTAL = "Ancient Gateway",
        LAVAARENA_KEYHOLE = "Ancient Anchor",
        LAVAARENA_SPAWNER = "Forge Portal",

        LAVAARENA_BATTLESTANDARD = "Battle Standard",

        HEALINGSTAFF = "Living Staff",
        FIREBALLSTAFF = "Infernal Staff",
        BOOK_FOSSIL = "Petrifying Tome",
        BOOK_ELEMENTAL = "Tome of Beckoning",
        HAMMER_MJOLNIR = "Forging Hammer",
        SPEAR_GUNGNIR = "Pith Pike",
        SPEAR_LANCE = "Spiral Spear",
        BLOWDART_LAVA = "Darts",
        BLOWDART_LAVA2 = "Molten Darts",
        LAVAARENA_LUCY = "Riled Lucy",
        WEBBER_SPIDER_MINION = "Baby Spider",
        WAXWELL_SHADOWSTRIKER = "Shadow",
        LAVAARENA_BERNIE = "Bernie",
        LAVAARENA_METEOR = "Meteor",
        LAVAARENA_ELEMENTAL = "Magma Golem",

        LAVAARENA_ARMORLIGHT = "Reed Tunic",
        LAVAARENA_ARMORLIGHTSPEED = "Feathered Reed Tunic",
        LAVAARENA_ARMORMEDIUM = "Wood Armor",
        LAVAARENA_ARMORMEDIUMDAMAGER = "Jagged Wood Armor",
        LAVAARENA_ARMORMEDIUMRECHARGER = "Silken Wood Armor",
        LAVAARENA_ARMORHEAVY = "Stone Splint Mail",
        LAVAARENA_ARMOREXTRAHEAVY = "Steadfast Stone Armor",

        LAVAARENA_FEATHERCROWNHAT = "Feathered Wreath",
        LAVAARENA_HEALINGFLOWERHAT = "Flower Headband",
        LAVAARENA_LIGHTDAMAGERHAT = "Barbed Helm",
        LAVAARENA_STRONGDAMAGERHAT = "Nox Helm",
        LAVAARENA_TIARAFLOWERPETALSHAT = "Woven Garland",
        LAVAARENA_EYECIRCLETHAT = "Clairvoyant Crown",
        LAVAARENA_RECHARGERHAT = "Crystal Tiara",
        LAVAARENA_HEALINGGARLANDHAT = "Blossomed Wreath",
        LAVAARENA_CROWNDAMAGERHAT = "Resplendent Nox Helm",

		-- Lavaarena Season 2
		LAVAARENA_ARMOR_HPEXTRAHEAVY = "Steadfast Grand Armor",
		LAVAARENA_ARMOR_HPPETMASTERY = "Whispering Grand Armor",
		LAVAARENA_ARMOR_HPRECHARGER = "Silken Grand Armor",
		LAVAARENA_ARMOR_HPDAMAGER = "Jagged Grand Armor",

		LAVAARENA_FIREBOMB = "Hearthsfire Crystals",
		LAVAARENA_HEAVYBLADE = "Blacksmith's Edge",

		-- Quagmire
        QUAGMIRE_CRATE_POT_HANGER = "Cookpot Kit",
        QUAGMIRE_CRATE_OVEN = "Oven Kit",
        QUAGMIRE_CRATE_GRILL_SMALL = "Grill Kit",
        QUAGMIRE_CRATE_GRILL = "Large Grill Kit",

        QUAGMIRE_TRADER_MERM = "Sammy\nThe Lucid Bog Merm",
        QUAGMIRE_TRADER_MERM2 = "Pipton\nThe Cognizant Bog Merm",
        QUAGMIRE_MERM = "Bog Merm",
        QUAGMIRE_MERM_CART1 = "Sammy's Wagon",
        QUAGMIRE_MERM_CART2 = "Pipton's Cart",

        QUAGMIRE_MERMHOUSE = "Rundown House",

        --Quagmire
        QUAGMIRE_HOE = "Hoe",
        --
        QUAGMIRE_TURNIP = "Turnip",
        QUAGMIRE_TURNIP_COOKED = "Roast Turnip",
        --
        QUAGMIRE_GARLIC = "Garlic",
        QUAGMIRE_GARLIC_COOKED = "Roast Garlic",
        --
        QUAGMIRE_ONION = "Onion",
        QUAGMIRE_ONION_COOKED = "Roast Onion",
        --
        QUAGMIRE_POTATO = "Potato",
        QUAGMIRE_POTATO_COOKED = "Roast Potato",
        --
        QUAGMIRE_TOMATO = "Toma Root",
        QUAGMIRE_TOMATO_COOKED = "Roast Toma Root",
        --
        QUAGMIRE_WILDWHEAT = "Wheat",
        QUAGMIRE_FLOUR = "Flour",
        QUAGMIRE_WHEAT = "Wheat",
        --QUAGMIRE_WHEAT_COOKED = "Roast Wheat",
        --
        --NOTE: raw/cooked carrot uses regular carrot strings
        QUAGMIRE_SEEDS_1 = "Blue Seeds",
        QUAGMIRE_SEEDS_2 = "Fluffy Seeds",
        QUAGMIRE_SEEDS_3 = "Spiky Seeds",
        QUAGMIRE_SEEDS_4 = "Pointy Seeds",
        QUAGMIRE_SEEDS_5 = "Round Seeds",
        QUAGMIRE_SEEDS_6 = "Oblong Seeds",
        QUAGMIRE_SEEDS_7 = "Seed Pods",
        QUAGMIRE_SEEDPACKET_1 = "Packet of Blue Seeds",
        QUAGMIRE_SEEDPACKET_2 = "Packet of Fluffy Seeds",
        QUAGMIRE_SEEDPACKET_3 = "Packet of Spiky Seeds",
        QUAGMIRE_SEEDPACKET_4 = "Packet of Pointy Seeds",
        QUAGMIRE_SEEDPACKET_5 = "Packet of Round Seeds",
        QUAGMIRE_SEEDPACKET_6 = "Packet of Oblong Seeds",
        QUAGMIRE_SEEDPACKET_7 = "Packet of Seed Pods",
        QUAGMIRE_SEEDPACKET_MIX = "Packet of Mixed Seeds",
        --
        QUAGMIRE_ROTTEN_CROP = "Rotten Crop",
        --
        QUAGMIRE_FOLIAGE_COOKED = "Cooked Foliage",
        --
        QUAGMIRE_SMALLMEAT = "Meat Scraps",
        QUAGMIRE_COOKEDSMALLMEAT = "Cooked Meat Scraps",
        --
        QUAGMIRE_FOOD_BURNT = "Burnt Food",
        QUAGMIRE_FOOD_PLATE = "Plate",
        QUAGMIRE_FOOD_BOWL = "Bowl",
         --
        QUAGMIRE_POT = "Large Cookpot",
        QUAGMIRE_POT_SMALL = "Cookpot",
        QUAGMIRE_POT_SYRUP = "Syrup Pot",
        QUAGMIRE_POT_HANGER = "Pot Hanger",
        QUAGMIRE_POT_HANGER_ITEM = "Pot Hanger",
        QUAGMIRE_GRILL = "Large Grill",
        QUAGMIRE_GRILL_ITEM = "Large Grill",
        QUAGMIRE_GRILL_SMALL = "Small Grill",
        QUAGMIRE_GRILL_SMALL_ITEM = "Small Grill",
        QUAGMIRE_OVEN = "Oven",
        QUAGMIRE_OVEN_ITEM = "Oven",
        QUAGMIRE_CASSEROLEDISH = "Large Casserole Dish",
        QUAGMIRE_CASSEROLEDISH_SMALL = "Small Casserole Dish",
        QUAGMIRE_PLATE_SILVER = "Silver Plate",
        QUAGMIRE_BOWL_SILVER = "Silver Bowl",
		--
		QUAGMIRE_LAMP_POST = "Streetlight",
		QUAGMIRE_LAMP_SHORT = "Small Streetlight",
		QUAGMIRE_SAFE = "Safe",
        QUAGMIRE_SAFE_LOCKED = "Locked Safe",
		QUAGMIRE_KEY = "Key",
		QUAGMIRE_KEY_PARK = "Iron Key",
		QUAGMIRE_SAP = "Sap",
		QUAGMIRE_SYRUP = "Syrup",
		QUAGMIRE_SAP_SPOILED = "Ruined Sap",
		QUAGMIRE_SAPBUCKET = "Tree Tapping Kit",
		--
		QUAGMIRE_ALTAR = "The Altar of Gnaw",
        QUAGMIRE_ALTAR_STATUE1 = "Beast of Hunger",
		QUAGMIRE_ALTAR_STATUE2 = "Beast of Hunger",
        QUAGMIRE_ALTAR_QUEEN = "Queen Beast",
		QUAGMIRE_ALTAR_BOLLARD = "Post",
		QUAGMIRE_ALTAR_IVY = "Ivy",
		QUAGMIRE_PARK_FOUNTAIN = "Fountain",
		QUAGMIRE_PARK_ANGEL = "Gnaw Worshipper",
		QUAGMIRE_PARK_ANGEL2 = "Gnaw Worshipper",
		QUAGMIRE_PARK_URN = "Urn",
		QUAGMIRE_PARK_OBELISK = "Stone Pillar",
		QUAGMIRE_PARKSPIKE = "Iron Fence",
		QUAGMIRE_PARK_GATE = "Iron Gate",
        QUAGMIRE_PARK_GATE_LOCKED = "Locked Iron Gate",
		--
		QUAGMIRE_SUGARWOODTREE = "Sugarwood Tree",
		QUAGMIRE_SPOTSPICE_SHRUB = "Spotty Shrub",
		QUAGMIRE_SPOTSPICE_SPRIG = "Spotty Sprig",
		QUAGMIRE_SPOTSPICE_GROUND = "Spot Spice",
		QUAGMIRE_MEALINGSTONE = "Mealing Stone",
		QUAGMIRE_FERN = "Fern",
		QUAGMIRE_SALMON = "Salmon",
		QUAGMIRE_SALMON_COOKED = "Cooked Salmon",
		QUAGMIRE_CRABMEAT = "Crab Meat",
		QUAGMIRE_CRABMEAT_COOKED = "Cooked Crab Meat",

		QUAGMIRE_POND_SALT = "Salt Pond",
		QUAGMIRE_SALT_RACK = "Salt Rack",
		QUAGMIRE_SALT_RACK_ITEM = "Salt Rack",
		QUAGMIRE_SALTROCK = "Salt Crystals",
		QUAGMIRE_SALT = "Salt",
        QUAGMIRE_SALTED_FOOD_FMT = "Salted {food}",
        QUAGMIRE_SALTY_FOOD_FMT = "Salty {food}",

		QUAGMIRE_PEBBLECRAB = "Pebble Crab",
		QUAGMIRE_CRABTRAP = "Crab Trap",

		QUAGMIRE_MUSHROOMSTUMP = "Mushroom",
		QUAGMIRE_MUSHROOMS = "Mushroom",
        QUAGMIRE_MUSHROOMS_COOKED = "Cooked Mushroom",

		QUAGMIRE_SWAMPIG_HOUSE = "Worn Pig House",
		QUAGMIRE_SWAMPIG_HOUSE_RUBBLE = "House Rubble",
		QUAGMIRE_SWAMPIGELDER = "Swamp Pig Elder",

		QUAGMIRE_GOATMUM = "Mumsy",
		QUAGMIRE_GOATKID = "Billy",

        QUAGMIRE_PORTAL = "Ancient Gateway",
		QUAGMIRE_PORTAL_KEY = "Ancient Key",

        QUAGMIRE_RUBBLE_CARRIAGE = "Broken Carriage",
        QUAGMIRE_RUBBLE_CLOCK = "Smashed Clock",
        QUAGMIRE_RUBBLE_CATHEDRAL = "Dilapidated Cathedral",
        QUAGMIRE_RUBBLE_PUBDOOR = "Dilapidated Door",
        QUAGMIRE_RUBBLE_ROOF = "Dilapidated Roof",
        QUAGMIRE_RUBBLE_CLOCKTOWER = "Dilapidated Clocktower",
        QUAGMIRE_RUBBLE_BIKE = "Wrecked Bicycle",
        QUAGMIRE_RUBBLE_HOUSE = "Dilapidated House",
        QUAGMIRE_RUBBLE_CHIMNEY = "Dilapidated Chimney",
        QUAGMIRE_RUBBLE_CHIMNEY2 = "Dilapidated Chimney",

        QUAGMIRE_COIN1 = "Old Coin",
        QUAGMIRE_COIN2 = "Sapphire Medallion",
        QUAGMIRE_COIN3 = "Red Mark",
        QUAGMIRE_COIN4 = "Gnaw's Favor",

        QUAGMIRE_PIGEON = "Pigeon",

		QUAGMIRE_BEEFALO = "Old Beefalo",
		QUAGMIRE_SLAUGHTERTOOL = "Slaughter Tools",

		QUAGMIRE_GOATMILK = "Goat Milk",

        QUAGMIRE_FOOD_001 = "Loaf of Bread",
        QUAGMIRE_FOOD_002 = "Potato Chips",
        QUAGMIRE_FOOD_003 = "Vegetable Soup",
        QUAGMIRE_FOOD_004 = "Jelly Sandwich",
        QUAGMIRE_FOOD_005 = "Fish Stew",
        QUAGMIRE_FOOD_006 = "Turnip Cake",
        QUAGMIRE_FOOD_007 = "Potato Pancakes",
        QUAGMIRE_FOOD_008 = "Potato Soup",
        QUAGMIRE_FOOD_009 = "Fishball Skewers",
        QUAGMIRE_FOOD_010 = "Meatballs",
        QUAGMIRE_FOOD_011 = "Meat Skewers",
        QUAGMIRE_FOOD_012 = "Stone Soup",
        QUAGMIRE_FOOD_013 = "Croquette",
        QUAGMIRE_FOOD_014 = "Roast Vegetables",
        QUAGMIRE_FOOD_015 = "Meatloaf",
        QUAGMIRE_FOOD_016 = "Carrot Soup",
        QUAGMIRE_FOOD_017 = "Fish Pie",
        QUAGMIRE_FOOD_018 = "Fish and Chips",
        QUAGMIRE_FOOD_019 = "Meat Pie",
        QUAGMIRE_FOOD_020 = "Sliders",
        QUAGMIRE_FOOD_021 = "Fist Full of Jam",
        QUAGMIRE_FOOD_022 = "Jelly Roll",
        QUAGMIRE_FOOD_023 = "Carrot Cake",
        QUAGMIRE_FOOD_024 = "Garlic Mashed Potatoes",
        QUAGMIRE_FOOD_025 = "Garlic Bread",
        QUAGMIRE_FOOD_026 = "Tomato Soup",
        QUAGMIRE_FOOD_027 = "Sausage",
        QUAGMIRE_FOOD_028 = "Candied Fish",
        QUAGMIRE_FOOD_029 = "Stuffed Mushroom",
        QUAGMIRE_FOOD_030 = "Ratatouille",
        QUAGMIRE_FOOD_031 = "Bruschetta",
        QUAGMIRE_FOOD_032 = "Meat Stew",
        QUAGMIRE_FOOD_033 = "Hamburger",
        QUAGMIRE_FOOD_034 = "Fish Burger",
        QUAGMIRE_FOOD_035 = "Mushroom Burger",
        QUAGMIRE_FOOD_036 = "Fish Steak",
        QUAGMIRE_FOOD_037 = "Curry",
        QUAGMIRE_FOOD_038 = "Spaghetti and Meatball",
        QUAGMIRE_FOOD_039 = "Lasagna",
        QUAGMIRE_FOOD_040 = "Poached Fish",
        QUAGMIRE_FOOD_041 = "Shepherd's Pie",
        QUAGMIRE_FOOD_042 = "Candy",
        QUAGMIRE_FOOD_043 = "Bread Pudding",
        QUAGMIRE_FOOD_044 = "Waffles",
        QUAGMIRE_FOOD_045 = "Berry Tart",
        QUAGMIRE_FOOD_046 = "Macaroni and Cheese",
        QUAGMIRE_FOOD_047 = "Bagel and Fish",
        QUAGMIRE_FOOD_048 = "Grilled Cheese",
        QUAGMIRE_FOOD_049 = "Cream of Mushroom Soup",
        QUAGMIRE_FOOD_050 = "Pierogi",
        QUAGMIRE_FOOD_051 = "Manicotti",
        QUAGMIRE_FOOD_052 = "Cheeseburger",
        QUAGMIRE_FOOD_053 = "Creamy Fettuccine",
        QUAGMIRE_FOOD_054 = "Onion Soup",
        QUAGMIRE_FOOD_055 = "Breaded Cutlet",
        QUAGMIRE_FOOD_056 = "Creamy Fish",
        QUAGMIRE_FOOD_057 = "Pizza",
        QUAGMIRE_FOOD_058 = "Pot Roast",
        QUAGMIRE_FOOD_059 = "Crab Cake",
        QUAGMIRE_FOOD_060 = "Steak Frites",
        QUAGMIRE_FOOD_061 = "Shooter Sandwich",
        QUAGMIRE_FOOD_062 = "Bacon Wrapped Meat",
        QUAGMIRE_FOOD_063 = "Crab Roll",
        QUAGMIRE_FOOD_064 = "Meat Wellington",
        QUAGMIRE_FOOD_065 = "Crab Ravioli",
        QUAGMIRE_FOOD_066 = "Caramel Cube",
        QUAGMIRE_FOOD_067 = "Scone",
        QUAGMIRE_FOOD_068 = "Trifle",
        QUAGMIRE_FOOD_069 = "Cheesecake",

        --v2 Winona
        WINONA_CATAPULT = "Winona's Catapult",
        WINONA_SPOTLIGHT = "Winona's Spotlight",
        WINONA_BATTERY_LOW = "Winona's Generator",
        WINONA_BATTERY_HIGH = "Winona's G.E.M.erator",
		--v3 Winona
		WINONA_REMOTE = "Handy Remote",
		WINONA_TELEBRELLA = "Portasol",
		WINONA_TELEPORT_PAD_ITEM = "Teletransport Station",
		WINONA_STORAGE_ROBOT = "W.I.N.bot",
		INSPECTACLESHAT = "Inspectacles",
		INSPECTACLESBOX = "Cachebox",
		INSPECTACLESBOX2 = "Advanced Cachebox",
		ROSEGLASSESHAT = "Rose-Colored Glasses",
		CHARLIERESIDUE = "Dark Vestige",
		CHARLIEROSE = "Fragile Rose",
        WINONA_MACHINEPARTS_1 = "Doohickey",
        WINONA_MACHINEPARTS_2 = "Gizmo",
		WINONA_RECIPESCANNER = "Calibrated Perceiver",
		WINONA_HOLOTELEPAD = "Unstable Transmission",
		WINONA_HOLOTELEBRELLA = "Unstable Transmission",

        --Wortox
        WORTOX_SOUL = "Soul",

        --Wormwood
        COMPOSTWRAP = "Compost Wrap",
        ARMOR_BRAMBLE = "Bramble Husk",
        TRAP_BRAMBLE = "Bramble Trap",
        BRAMBLEFX = "Thorns", --for death announce if killed by thorns from armor_bramble, and owner is no longer available

        --v2 Warly
        PORTABLECOOKPOT = "Portable Crock Pot",
        PORTABLEBLENDER = "Portable Grinding Mill",
        PORTABLESPICER = "Portable Seasoning Station",
        PORTABLECOOKPOT_ITEM = "Portable Crock Pot",
        PORTABLEBLENDER_ITEM = "Portable Grinding Mill",
        PORTABLESPICER_ITEM = "Portable Seasoning Station",
        SPICEPACK = "Chef Pouch",
        SPICE_GARLIC = "Garlic Powder",
        SPICE_SUGAR = "Honey Crystals",
        SPICE_CHILI = "Chili Flakes",
        SPICE_SALT = "Seasoning Salt",
        SPICE_GARLIC_FOOD = "Garlic {food}",
        SPICE_SUGAR_FOOD = "Sweet {food}",
        SPICE_CHILI_FOOD = "Spicy {food}",
        SPICE_SALT_FOOD = "Salty {food}",
        MONSTERTARTARE = "Monster Tartare",
        FRESHFRUITCREPES = "Fresh Fruit Crepes",
        FROGFISHBOWL = "Fish Cordon Bleu",
        POTATOTORNADO = "Fancy Spiralled Tubers",
        DRAGONCHILISALAD = "Hot Dragon Chili Salad",
        GLOWBERRYMOUSSE = "Glow Berry Mousse",
        VOLTGOATJELLY = "Volt Goat Chaud-Froid",
        NIGHTMAREPIE = "Grim Galette",
        BONESOUP = "Bone Bouillon",
        MASHEDPOTATOES = "Creamy Potato Purée",
        POTATOSOUFFLE = "Puffed Potato Soufflé",
        MOQUECA = "Moqueca",
        GAZPACHO = "Asparagazpacho",
        ASPARAGUSSOUP = "Asparagus Soup",
        VEGSTINGER = "Vegetable Stinger",
        BANANAPOP = "Banana Pop",
        CEVICHE = "Ceviche",
        SALSA = "Salsa Fresca",
        PEPPERPOPPER = "Stuffed Pepper Poppers",

        --v2 Woodie
        WEREITEM_BEAVER = "Kitschy Beaver Idol",
        WEREITEM_GOOSE =  "Kitschy Goose Idol",
        WEREITEM_MOOSE =  "Kitschy Moose Idol",

		-- new content
        BOAT = "Boat",
        BOAT_GRASS = "Grass Raft",
        BOAT_PIRATE = "Pirate Sloop",
        BOAT_ITEM = "Boat Kit",
        BOAT_GRASS_ITEM = "Grass Raft Kit",
        BOATFRAGMENT03 = "Boat Fragment",
        BOATFRAGMENT04 = "Boat Fragment",
        BOATFRAGMENT05 = "Boat Fragment",
        MAST = "Mast",
        MAST_ITEM = "Mast Kit",
		BOAT_LEAK = "Leak",
		FISH_BOX = "Tin Fishin' Bin",
        WORLD = "The World",
        DROWNING = "Drowning",
        SEASTACK = "Sea Stack",
        SEACOCOON = "Sea Cocoon",
        SEACOCOON_TOP = "Sea Cocoon",
        FISHINGNET = "Fishing Net",
        OAR = "Oar",
        OAR_DRIFTWOOD = "Driftwood Oar",
        ANTCHOVIES = "Ant-Chovy",
        STEERINGWHEEL = "Steering Wheel",
        STEERINGWHEEL_ITEM = "Steering Wheel Kit",
        ANCHOR = "Anchor",
        WALKINGPLANK = "Plank",
        WALKINGPLANK_GRASS = "Plank",
        ANCHOR_ITEM = "Anchor Kit",
        BOATPATCH = "Boat Patch",
        DRIFTWOOD_TREE = "Driftwood",
        DRIFTWOOD_LOG = "Driftwood Piece",
        MOON_TREE = "Lune Tree",
        MOON_TREE_BLOSSOM = "Lune Tree Blossom",
		MOONBUTTERFLY = "Moon Moth",
        MOONBUTTERFLYWINGS = "Moon Moth Wings",
        MOONBUTTERFLY_SAPLING = "Lune Tree Sapling",
        HOTSPRING = "Hot Spring",
        MOONGLASS = "Moon Shard",
        MOONGLASS_CHARGED = "Infused Moon Shard",
        MOONGLASS_ROCK = "Moon Glass",
        BATHBOMB = "Bath Bomb",
        ROCK_AVOCADO_FRUIT = "Stone Fruit",
        ROCK_AVOCADO_FRUIT_RIPE = "Ripe Stone Fruit",
        ROCK_AVOCADO_FRUIT_RIPE_COOKED = "Cooked Stone Fruit",
        ROCK_AVOCADO_FRUIT_SPROUT = "Sprouting Stone Fruit",
        ROCK_AVOCADO_BUSH = "Stone Fruit Bush",
        DUG_ROCK_AVOCADO_BUSH = "Stone Fruit Bush",
        DEAD_SEA_BONES = "Sea Bones",
        MUTATEDHOUND = "Horror Hound",
        TRAP_STARFISH = "Anenemy",
        DUG_TRAP_STARFISH = "Anenemy Trap",
        SPIDER_MOON = "Shattered Spider",
		MOONSPIDER_SPIKE = "Shattered Spider",
        MOONSPIDERDEN = "Shattered Spider Hole",
		FRUITDRAGON = "Saladmander",
        MUTATED_PENGUIN = "Permafrost Pengull",
        PUFFIN = "Puffin",

		BULLKELP_PLANT = "Bull Kelp",
		BULLKELP_ROOT = "Bull Kelp Stalk",
		KELP = "Kelp Fronds",
		KELP_COOKED = "Cooked Kelp Fronds",
		KELP_DRIED = "Dried Kelp Fronds",

        MOONGLASSAXE = "Moon Glass Axe",
        GLASSCUTTER = "Glass Cutter",

        MOON_FISSURE = "Celestial Fissure",
        MOON_ALTAR_WIP = "Partially Assembled Altar",
        MOON_ALTAR = "Celestial Altar",
        MOON_ALTAR_IDOL = "Celestial Altar Idol",
        MOON_ALTAR_GLASS = "Celestial Altar Base",
        MOON_ALTAR_SEED = "Celestial Altar Orb",

        MOON_ALTAR_COSMIC = "Celestial Tribute",
        MOON_ALTAR_CROWN = "Inactive Celestial Tribute",

        MOON_ALTAR_ASTRAL_WIP = "Partially Assembled Sanctum",
        MOON_ALTAR_ASTRAL = "Celestial Sanctum",
        MOON_ALTAR_ICON = "Celestial Sanctum Icon",
        MOON_ALTAR_WARD = "Celestial Sanctum Ward",

        MOON_ALTAR_ROCK_IDOL = "Inviting Formation",
        MOON_ALTAR_ROCK_GLASS = "Inviting Formation",
        MOON_ALTAR_ROCK_SEED = "Inviting Formation",

		SEAFARING_PROTOTYPER = "Think Tank",

        ICEBERG = "Mini Iceberg",
        ICEBERG_MELTED = "Melted Iceberg",

        MINIFLARE = "Flare",
        MEGAFLARE = "Hostile Flare",

		GESTALT = "Gestalt",
		GESTALT_GUARD = "Greater Gestalt",
        GESTALT_ALTERGUARDIAN_PROJECTILE = "Gestalt",
        SMALLGUARD_ALTERGUARDIAN_PROJECTILE = "Minor Gestalt",
        ALTERGUARDIANHAT_PROJECTILE = "Minor Gestalt",
        LARGEGUARD_ALTERGUARDIAN_PROJECTILE = "Greater Gestalt",

        CARRAT = "Carrat",
        CARRAT_PLANTED = "Carrot",

		OCEANFISH_ANTCHOVY = "Antchovy",
		OCEANFISH_SMALL_1 = "Runty Guppy",
		OCEANFISH_SMALL_2 = "Needlenosed Squirt",
		OCEANFISH_SMALL_3 = "Bitty Baitfish",
		OCEANFISH_SMALL_4 = "Smolt Fry",
		OCEANFISH_SMALL_5 = "Popperfish",
		OCEANFISH_SMALL_6 = "Fallounder",
		OCEANFISH_SMALL_7 = "Bloomfin Tuna",
		OCEANFISH_SMALL_8 = "Scorching Sunfish",
		OCEANFISH_SMALL_9 = "Spittlefish",
		OCEANFISH_MEDIUM_1 = "Mudfish",
		OCEANFISH_MEDIUM_2 = "Deep Bass",
		OCEANFISH_MEDIUM_3 = "Dandy Lionfish",
		OCEANFISH_MEDIUM_4 = "Black Catfish",
		OCEANFISH_MEDIUM_5 = "Corn Cod",
		OCEANFISH_MEDIUM_6 = "Dappled Koi",
		OCEANFISH_MEDIUM_7 = "Golden Koi",
		OCEANFISH_MEDIUM_8 = "Ice Bream",
        OCEANFISH_MEDIUM_9 = "Sweetish Fish",

		OCEANFISH_SMALL_1_INV = "Runty Guppy",
		OCEANFISH_SMALL_2_INV = "Needlenosed Squirt",
		OCEANFISH_SMALL_3_INV = "Bitty Baitfish",
		OCEANFISH_SMALL_4_INV = "Smolt Fry",
		OCEANFISH_SMALL_5_INV = "Popperfish",
		OCEANFISH_SMALL_6_INV = "Fallounder",
		OCEANFISH_SMALL_7_INV = "Bloomfin Tuna",
		OCEANFISH_SMALL_8_INV = "Scorching Sunfish",
		OCEANFISH_SMALL_9_INV = "Spittlefish",
		OCEANFISH_MEDIUM_1_INV = "Mudfish",
		OCEANFISH_MEDIUM_2_INV = "Deep Bass",
		OCEANFISH_MEDIUM_3_INV = "Dandy Lionfish",
		OCEANFISH_MEDIUM_4_INV = "Black Catfish",
		OCEANFISH_MEDIUM_5_INV = "Corn Cod",
		OCEANFISH_MEDIUM_6_INV = "Dappled Koi",
		OCEANFISH_MEDIUM_7_INV = "Golden Koi",
		OCEANFISH_MEDIUM_8_INV = "Ice Bream",
        OCEANFISH_MEDIUM_9_INV = "Sweetish Fish",

		PONDFISH = "Freshwater Fish",
		PONDEEL = "Live Eel",

        FISHMEAT = "Raw Fish",
        FISHMEAT_COOKED = "Fish Steak",
		SPOILED_FISH = "Spoiled Fish",

        FISHMEAT_SMALL = "Fish Morsel",
        FISHMEAT_SMALL_COOKED = "Cooked Fish Morsel",
        SPOILED_FISH_SMALL = "Spoiled Fish Morsel",

		CALIFORNIAROLL = "California Roll",
		SEAFOODGUMBO = "Seafood Gumbo",
		SURFNTURF = "Surf 'n' Turf",

        OCEANFISHINGROD = "Sea Fishing Rod",
		OCEANFISHINGBOBBER_NONE = "Fish Hook",
        OCEANFISHINGBOBBER_BALL = "Wooden Ball Bobber",
        OCEANFISHINGBOBBER_OVAL = "Hardened Slip Bobber",
		OCEANFISHINGBOBBER_CROW = "Jet Quill Float",
		OCEANFISHINGBOBBER_ROBIN = "Crimson Quill Float",
		OCEANFISHINGBOBBER_ROBIN_WINTER = "Azure Quill Float",
		OCEANFISHINGBOBBER_CANARY = "Saffron Quill Float",
		OCEANFISHINGBOBBER_GOOSE = "Down Quill Float",
		OCEANFISHINGBOBBER_MALBATROSS = "Malbatross Quill Float",

		OCEANFISHINGLURE_SPINNER_RED = "Sunrise Spinnerbait",
		OCEANFISHINGLURE_SPINNER_GREEN = "Dusky Spinnerbait",
		OCEANFISHINGLURE_SPINNER_BLUE = "Nightflyer Spinnerbait",
		OCEANFISHINGLURE_SPINNER_ORANGE = "not used",
		OCEANFISHINGLURE_SPINNER_YELLOW = "not used",
		OCEANFISHINGLURE_SPINNER_WHITE = "not used",
		OCEANFISHINGLURE_SPOON_RED = "Sunrise Spoon",
		OCEANFISHINGLURE_SPOON_GREEN = "Dusky Spoon",
		OCEANFISHINGLURE_SPOON_BLUE = "Nightflyer Spoon",
		OCEANFISHINGLURE_SPOON_BROWN = "not used",
		OCEANFISHINGLURE_SPOON_YELLOW = "not used",
		OCEANFISHINGLURE_SPOON_SILVER = "not used",
		OCEANFISHINGLURE_HERMIT_RAIN = "Rainy Day Lure",
		OCEANFISHINGLURE_HERMIT_SNOW = "Snow Day Lure",
		OCEANFISHINGLURE_HERMIT_DROWSY = "Stupefying Lure",
		OCEANFISHINGLURE_HERMIT_HEAVY = "Heavy Weighted Lure",

		POCKET_SCALE = "Pocket Scale",

		TACKLECONTAINER = "Tackle Box",
		SUPERTACKLECONTAINER = "Spectackler Box",

		BURNABLE_LOCATOR_MEDIUM = "Boat",
        WATER_TURTLE = "Sea Turtle",

        -- Wurt
        MERMHAT = "Clever Disguise",
        MERMTHRONE = "Royal Tapestry",
        MERMTHRONE_CONSTRUCTION = "DIY Royalty Kit",
        MERMHOUSE_CRAFTED = "Craftsmerm House",
        MERMWATCHTOWER = "Merm Flort-ifications",
        MERMGUARD = "Loyal Merm Guard",
        MERMKING = "King of the Merms",
        MERM_PRINCE = "Royal-In-Progress",
        MOSQUITOMUSK = "Lil' Itchy",
        MOSQUITOBOMB = "Skeeter Bomb",
        MOSQUITOFERTILIZER = "Fertilizzzer",
        MOSQUITOMERMSALVE = "Blood Shot",
        OFFERING_POT = "Communal Kelp Dish",
        OFFERING_POT_UPGRADED = "Superior Communal Kelp Dish",
        MERM_ARMORY = "Armermry",
        MERM_ARMORY_UPGRADED = "Superior Armermry",
        MERMARMORHAT = "Swamp Brawler Helmet",
        MERMARMORUPGRADEDHAT = "Swamp Warrior Helmet",

        MERM_TOOLSHED = "Shoddy Tool Shed",
        MERM_TOOLSHED_UPGRADED = "Slightly Less Shoddy Tool Shed",
        MERM_TOOL = "Shoddy Tool",
        MERM_TOOL_UPGRADED = "Slightly Less Shoddy Tool",

        WURT_SWAMPITEM_SHADOW = "Dreaded Mudslinger",
        WURT_SWAMPITEM_LUNAR = "Brilliant Mudslinger",

		-- Walter
        WOBYBIG = "Woby",
        WOBYSMALL = "Woby",
        WALTERHAT = "Pinetree Pioneer Hat",
		SLINGSHOT = "Trusty Slingshot",
		SLINGSHOT_FMT = "{name}'s Slingshot",
		SLINGSHOTAMMO_ROCK = "Pebbles",
		SLINGSHOTAMMO_MARBLE = "Marbles",
		SLINGSHOTAMMO_THULECITE = "Cursed Rounds",
        SLINGSHOTAMMO_GOLD = "Gold Rounds",
		SLINGSHOTAMMO_HONEY = "Stickies",
        SLINGSHOTAMMO_SLOW = "Slow-Down Rounds",
        SLINGSHOTAMMO_FREEZE = "Freeze Rounds",
		SLINGSHOTAMMO_POOP = "Poop Pellets",
        SLINGSHOTAMMO_STINGER = "Stinger Zingers",
        SLINGSHOTAMMO_MOONGLASS = "Moonshots",
		SLINGSHOTAMMO_GELBLOB = "Ickies",
		SLINGSHOTAMMO_SCRAPFEATHER = "Shockscrap Shots",
        SLINGSHOTAMMO_DREADSTONE = "Dread Pebbles",
        SLINGSHOTAMMO_GUNPOWDER = "Kablooies",
        SLINGSHOTAMMO_LUNARPLANTHUSK = "Brightshade Husk Rounds",
        SLINGSHOTAMMO_PUREBRILLIANCE = "Pure Brilliance Rounds",
        SLINGSHOTAMMO_HORRORFUEL = "Pure Horror Rounds",
        PORTABLETENT_ITEM = "Tent Roll",
        PORTABLETENT = "Camper's Tent",

		-- WANDA
		OLDAGER_COMPONENT = "the passage of time", -- for "was killed by ..." string

		POCKETWATCH_PARTS = "Time Pieces",
		POCKETWATCH_WEAPON = "Alarming Clock",
		POCKETWATCH_DISMANTLER = "Clockmaker's Tools",
		POCKETWATCH_RECALL = "Backtrek Watch",
		POCKETWATCH_HEAL = "Ageless Watch",
		POCKETWATCH_REVIVE = "Second Chance Watch",
		POCKETWATCH_REVIVE_REVIVER = "Second Chance Watch", -- for "was revived by ..." string
		POCKETWATCH_WARP = "Backstep Watch",
		POCKETWATCH_PORTAL = "Rift Watch",

		POCKETWATCH_PORTAL_ENTRANCE = "Time Rift",
		POCKETWATCH_PORTAL_EXIT = "Time Rift",

        -- Wortox
        WORTOX_REVIVER_FMT = "{name}'s Twintailed Heart",
        WORTOX_REVIVER = "Twintailed Heart", -- For an unclaimed Heart.
        WORTOX_NABBAG = "Knabsack",
        WORTOX_SOULJAR = "Soul Jar",
        WORTOX_DECOY_FMT = "{name}?",
        WORTOX_DECOY = "Wortox?", -- For an unnamed Decoy.

        -- Wigfrid
        BATTLESONG_DURABILITY = "Weaponized Warble",
        BATTLESONG_HEALTHGAIN = "Heartrending Ballad",
        BATTLESONG_SANITYGAIN = "Clear Minded Cadenza",
        BATTLESONG_SANITYAURA = "Bel Canto of Courage",
        BATTLESONG_FIRERESISTANCE = "Fireproof Falsetto",
        BATTLESONG_INSTANT_TAUNT = "Rude Interlude",
        BATTLESONG_INSTANT_PANIC = "Startling Soliloquy",

		COOKIECUTTER = "Cookie Cutter",
		COOKIECUTTERSHELL = "Cookie Cutter Shell",
		COOKIECUTTERHAT = "Cookie Cutter Cap",
		SALTSTACK = "Salt Formation",
		SALTROCK = "Salt Crystals",
		SALTBOX = "Salt Box",

		TACKLESTATION = "Tackle Receptacle",

        MALBATROSS = "Malbatross",
        MALBATROSS_BEAK = "Malbatross Bill",
        MALBATROSS_FEATHER = "Malbatross Feather",
        MAST_MALBATROSS = "Winged Sail",
        MAST_MALBATROSS_ITEM = "Winged Sail Kit",
		MALBATROSS_FEATHERED_WEAVE = "Feathery Canvas",

        GNARWAIL = "Gnarwail",
        GNARWAIL_HORN = "Gnarwail Horn",

        SQUID = "Skittersquid",

		TROPHYSCALE_FISH = "Fish Scale-O-Matic",

		OCEANFISHABLEFLOTSAM = "Ocean Debris",

        -- YOTC
        CARRATSHRINE = "Carrat Shrine",
        YOTC_CARRATSHRINE = "Carrat Shrine",

        YOTC_CARRAT_GYM_DIRECTION = "Navigation Gym",
        YOTC_CARRAT_GYM_SPEED = "Speed Gym",
        YOTC_CARRAT_GYM_STAMINA = "Endurance Gym",
        YOTC_CARRAT_GYM_REACTION = "Reflex Gym",

        YOTC_CARRAT_GYM_DIRECTION_ITEM = "Navigation Gym Kit",
        YOTC_CARRAT_GYM_SPEED_ITEM = "Speed Gym Kit",
        YOTC_CARRAT_GYM_STAMINA_ITEM = "Endurance Gym Kit",
        YOTC_CARRAT_GYM_REACTION_ITEM = "Reflex Gym Kit",

        YOTC_CARRAT_SCALE = "Carrat Scale",
        YOTC_CARRAT_SCALE_ITEM = "Carrat Scale Kit",
        YOTC_OWNED_CARRAT = "{trainer}'s Carrat",
		CARRAT_GHOSTRACER = "Charlie's Carrat",

		MINIBOATLANTERN = "Floating Lantern",

        -- Wendy
		GHOSTFLOWER = "Mourning Glory",
        SMALLGHOST = "Pipspook",
		GHOSTLYELIXIR_SLOWREGEN = "Revenant Restorative",
		GHOSTLYELIXIR_FASTREGEN = "Spectral Cure-All",
		GHOSTLYELIXIR_SHIELD = "Unyielding Draught",
		GHOSTLYELIXIR_ATTACK = "Nightshade Nostrum",
		GHOSTLYELIXIR_SPEED = "Vigor Mortis",
		GHOSTLYELIXIR_RETALIATION = "Distilled Vengeance",
        GHOSTLYELIXIR_REVIVE = "Ghastly Experience",
		SISTURN = "Sisturn",

        -- SSSS
        CRABKING = "Crab King",
        CRABKING_CLAW = "Imposing Claw",

        HERMITCRAB = "Crabby Hermit",
        HERMITCRAB_NAME = "Pearl",
        HERMIT_PEARL = "Pearl's Pearl",
        HERMIT_CRACKED_PEARL = "Cracked Pearl",
        BEEBOX_HERMIT = "Bee Box",
        MEATRACK_HERMIT = "Drying Rack",

        WOBSTER_DEN = "Wobster Mound",
        WOBSTER_SHELLER = "Wobster",
        WOBSTER_SHELLER_LAND = "Wobster",
        WOBSTER_SHELLER_DEAD = "Dead Wobster",
        WOBSTER_SHELLER_DEAD_COOKED = "Delicious Wobster",

        LOBSTERBISQUE = "Lobster Bisque",
        LOBSTERDINNER = "Lobster Dinner",

        WOBSTER_MOONGLASS = "Lunar Wobster",
        MOONGLASS_WOBSTER_DEN = "Moon Glass Mound",

        TRIDENT = "Strident Trident",

		MESSAGEBOTTLE = "Message in a Bottle",
		MESSAGEBOTTLEEMPTY = "Empty Bottle",

		WINCH = "Pinchin' Winch",
		HERMITHOUSE = "Hermit Home",
        HERMITHOUSE_PEARL = "Pearl's Place",
        WINCH_BLUEPRINT = "Pinchin' Winch Blueprint",

        SHELL_CLUSTER = "Shell Cluster",

		SINGINGSHELL_OCTAVE3 = "Baritone Shell Bell",
		SINGINGSHELL_OCTAVE4 = "Alto Shell Bell",
        SINGINGSHELL_OCTAVE5 = "Soprano Shell Bell",

        SUNKENCHEST = "Sunken Chest",

        HERMIT_BUNDLE = "Bundle of Thanks",
        HERMIT_BUNDLE_SHELLS = "Shell Bell Bundle",

        MOON_FISSURE_PLUGGED = "Plugged Fissure",

        CHUM = "Fish Food",
        CHUM_BLUEPRINT = "Fish Food Blueprint",

        TURF_SHELLBEACH_BLUEPRINT = "Shell Turf Blueprint",

        -- DSEAS
        WATERPLANT = "Sea Weed",
        WATERPLANT_BOMB = "Seedshell",
        WATERPLANT_BABY = "Sea Sprout",
        WATERPLANT_PLANTER = "Sea Sprout Starter",

        SHARK = "Rockjaw",
        OCEANHORROR = "Terrorclaw",

        MASTUPGRADE_LAMP_ITEM = "Deck Illuminator",
        MASTUPGRADE_LAMP = "Deck Illuminator",
        MASTUPGRADE_LIGHTNINGROD_ITEM = "Lightning Conductor",
        MASTUPGRADE_LIGHTNINGROD = "Lightning Conductor",

        WATERPUMP = "Fire Pump",

        BARNACLE = "Barnacles",
        BARNACLE_COOKED = "Cooked Barnacles",

        BARNACLEPITA = "Barnacle Pita",
        BARNACLESUSHI = "Barnacle Nigiri",
        BARNACLINGUINE = "Barnacle Linguine",
        BARNACLESTUFFEDFISHHEAD = "Stuffed Fish Heads",

        LEAFLOAF = "Leafy Meatloaf",
        LEAFYMEATBURGER = "Veggie Burger",
        LEAFYMEATSOUFFLE = "Jelly Salad",
        MEATYSALAD = "Beefy Greens",

        -- GROTTO
        MOLEBAT = "Naked Mole Bat",
        MOLEBATHILL = "Naked Mole Bat Burrow",
        BATNOSE = "Naked Nostrils",
        BATNOSE_COOKED = "Charred Nostrils",
        BATNOSEHAT = "Milkmade Hat",

        MUSHGNOME = "Mush Gnome",

        MOON_CAP = "Moon Shroom",
        MOON_CAP_COOKED = "Cooked Moon Shroom",

        MUSHTREE_MOON = "Lunar Mushtree",
        SPORE_MOON = "Lunar Spore",

        ARCHIVE_LOCKBOX = "Distilled Knowledge",

        ARCHIVE_CENTIPEDE = "Ancient Sentrypede",
        ARCHIVE_CENTIPEDE_HUSK = "Sentrypede Husk",

        DUSTMOTH = "Dust Moth",
        DUSTMOTHDEN = "Tidy Hidey-Hole",
        LIGHTFLIER = "Bulbous Lightbug",

        ARCHIVE_MOON_STATUE = "Ancient Moon Statue",
        ARCHIVE_RUNE_STATUE = "Ancient Lunarune Stone",
		VAULT_RUNE = "Sanctum Lunarune Stone",
		VAULT_STATUE = "Sanctum Statue",

        ARCHIVE_RESONATOR = "Astral Detector",
        ARCHIVE_RESONATOR_ITEM = "Astral Detector",

        GROTTO_POOL_BIG = "Vitreoasis",
        GROTTO_POOL_SMALL = "Small Vitreoasis",

        REFINED_DUST = "Collected Dust",
        DUSTMERINGUE = "Amberosia",

        SHROOMCAKE = "Mushy Cake",
        SHROOMBAIT = "Stuffed Night Cap",

        ARCHIVE_LOCKBOX_DISPENCER = "Fountain of Knowledge",
        ARCHIVE_PORTAL = "Sealed Portal",
        ARCHIVE_COOKPOT = "Ancient Kiln",
        ARCHIVE_SWITCH = "Ornate Pedestal",
        ARCHIVE_SECURITY_DESK = "Ancient Guard Post",

        WALL_STONE_2 = "Archival Stone Wall",
        WALL_RUINS_2 = "Archival Thulecite Wall",

        NIGHTMAREGROWTH = "Nightmare Rampart",

        TURFCRAFTINGSTATION = "Terra Firma Tamper",

        MOON_ALTAR_LINK = "Mysterious Energy",

        -- FARMING
		FARM_PLOW = "Garden Digamajig",
		FARM_PLOW_ITEM = "Garden Digamajig",
		FARM_HOE = "Garden Hoe",
		GOLDEN_FARM_HOE = "Splendid Garden Hoe",
        NUTRIENTSGOGGLESHAT = "Premier Gardeneer Hat",
		PLANTREGISTRYHAT = "Gardeneer Hat",

        COMPOSTINGBIN = "Composting Bin",
        COMPOST = "Compost",

		SOIL_AMENDER = "Growth Formula Starter",
        SOIL_AMENDER_FRESH = "Growth Formula Starter",
        SOIL_AMENDER_STALE = "Fermenting Growth Formula",
        SOIL_AMENDER_SPOILED = "Fermented Growth Formula",
		SOIL_AMENDER_FERMENTED = "Super Growth Formula",

		WATERINGCAN_NOT_EMPTY = "Watering Can",
        WATERINGCAN = "Empty Watering Can",
        PREMIUMWATERINGCAN_NOT_EMPTY = "Waterfowl Can",
        PREMIUMWATERINGCAN = "Empty Waterfowl Can",

        TROPHYSCALE_OVERSIZEDVEGGIES = "Produce Scale",

        LORDFRUITFLY = "Lord of the Fruit Flies",
        FRUITFLY = "Fruit Fly",
        FRIENDLYFRUITFLY = "Friendly Fruit Fly",
        FRUITFLYFRUIT = "Friendly Fruit Fly Fruit",

        SEEDPOUCH = "Seed Pack-It",

        -- YOTB
        YOTB_SEWINGMACHINE = "Sewing Machine",
        YOTB_SEWINGMACHINE_ITEM = "Sewing Machine Kit",

        YOTB_STAGE_ITEM = "Judge's Booth",
        YOTB_STAGE = "Judge's Booth",

        YOTB_POST_ITEM = "Beefalo Stage",
        YOTB_POST = "Beefalo Stage",

        YOTB_BEEFALOSHRINE = "Beefalo Shrine",

        YOTB_PATTERN_FRAGMENT_1 = "Fearsome Pattern Scrap",
        YOTB_PATTERN_FRAGMENT_2 = "Formal Pattern Scrap",
        YOTB_PATTERN_FRAGMENT_3 = "Festive Pattern Scrap",

        YOTB_BEEFALO_DOLL_WAR = "Warrior Beefalo Doll",
        YOTB_BEEFALO_DOLL_DOLL = "Dolled-Up Beefalo Doll",
        YOTB_BEEFALO_DOLL_FESTIVE = "Festive Beefalo Doll",
        YOTB_BEEFALO_DOLL_NATURE = "Flowery Beefalo Doll",
        YOTB_BEEFALO_DOLL_ROBOT = "Ironclad Beefalo Doll",
        YOTB_BEEFALO_DOLL_ICE = "Frostbitten Beefalo Doll",
        YOTB_BEEFALO_DOLL_FORMAL = "Formal Beefalo Doll",
        YOTB_BEEFALO_DOLL_VICTORIAN = "Victorian Beefalo Doll",
        YOTB_BEEFALO_DOLL_BEAST = "Lucky Beast Beefalo Doll",

        BEEFALO_GROOMER = "Beefalo Grooming Station",
        BEEFALO_GROOMER_ITEM = "Grooming Station Kit",

        BEEF_BELL = "Beefalo Bell",
        BEEFALO_BUDDY_NAME = "{buddy}'s Beefalo",

        WAR_BLUEPRINT = "Warrior Costume Pattern",
        DOLL_BLUEPRINT = "Dolled-Up Costume Pattern",
        FESTIVE_BLUEPRINT = "Festive Costume Pattern",
        ROBOT_BLUEPRINT = "Ironclad Costume Pattern",
        NATURE_BLUEPRINT = "Flowery Costume Pattern",
        FORMAL_BLUEPRINT = "Formal Costume Pattern",
        VICTORIAN_BLUEPRINT = "Victorian Costume Pattern",
        BEAST_BLUEPRINT = "Lucky Beast Costume Pattern",
        ICE_BLUEPRINT = "Frostbitten Costume Pattern",

        -- Moon Storms
        WAGSTAFF_NPC = "Grainy Transmission",
        WAGSTAFF_NPC_PSTBOSS = "Grainy Transmission",
        WAGSTAFF_NPC_MUTATIONS = "Grainy Transmission",
        ALTERGUARDIAN_CONTAINED = "Lunar Essence Extractor",
        WAGSTAFF_NPC_WAGPUNK = "Grainy Transmission",
        WAGSTAFF_NPC_WAGPUNK_ARENA = "Grainy Transmission",

        ALTERGUARDIAN_PHASE1 = "Celestial Champion",
        ALTERGUARDIAN_PHASE2 = "Celestial Champion",
        ALTERGUARDIAN_PHASE2SPIKE = "Moonglass Spike",
        ALTERGUARDIAN_PHASE3 = "Celestial Champion",
        ALTERGUARDIAN_PHASE3TRAP = "Enlightening Snare",
        ALTERGUARDIAN_PHASE3DEADORB = "Celestial Champion",
        ALTERGUARDIAN_PHASE3DEAD = "Defeated Celestial Champion",

        BIRD_MUTANT = "Moonblind Crow",
        BIRD_MUTANT_SPITTER = "Misshapen Bird",

        WAGSTAFF_TOOL_1 = "Reticulating Buffer",
        WAGSTAFF_TOOL_2 = "Widget Deflubber",
        WAGSTAFF_TOOL_3 = "Grommet Scriber",
        WAGSTAFF_TOOL_4 = "Conceptual Scrubber",
        WAGSTAFF_TOOL_5 = "Calibrated Perceiver",

        WAGSTAFF_TOOL_1_LAYMAN = "Odd Tool",
        WAGSTAFF_TOOL_2_LAYMAN = "Weird Tool",
        WAGSTAFF_TOOL_3_LAYMAN = "Strange Tool",
        WAGSTAFF_TOOL_4_LAYMAN = "Funky Tool",
        WAGSTAFF_TOOL_5_LAYMAN = "Bizarre Tool",

        MOONSTORM_GLASS = "Charged Glassy Rock",
        MOONSTORM_GLASS_DEFUSED = "Glassy Rock",
        MOONSTORM_SPARK = "Moongleam",
        MOONSTORM_STATIC = "Energetic Static",
        MOONSTORM_STATIC_ITEM = "Restrained Static",
        MOONSTORM_STATIC_NOWAG = "Energetic Static",
        MOONSTORM_STATIC_ROAMER = "Unrestrained Static",

        ALTERGUARDIANHAT = "Enlightened Crown",
        ALTERGUARDIANHATSHARD = "Enlightened Shard",

        MOONSTORM_GOGGLESHAT = "Astroggles",
        MOONSTORM_GOGGLESHAT_BLUEPRINT = "Astroggles Blueprint",

        MOON_DEVICE_CONSTRUCTION1 = "Incomplete Experiment",
        MOON_DEVICE_CONSTRUCTION1_BLUEPRINT = "Incomplete Experiment Blueprint",
        MOON_DEVICE_CONSTRUCTION2 = "Nearly Completed Experiment",
        MOON_DEVICE_CONSTRUCTION3 = "Lunar Siphonator",

        MOON_DEVICE = "Lunar Siphonator",

        -- Webber
        MUTATOR_WARRIOR = "Warrior Switcherdoodle",
        MUTATOR_DROPPER = "Dangler Switcherdoodle",
        MUTATOR_HIDER = "Cave Switcherdoodle",
        MUTATOR_SPITTER = "Spitter Switcherdoodle",
        MUTATOR_MOON = "Shatter Switcherdoodle",
        MUTATOR_HEALER = "Nurse Switcherdoodle",
        SPIDER_WHISTLE = "Webby Whistle",
        SPIDERDEN_BEDAZZLER = "Den Decorating Set",
        SPIDER_HEALER = "Nurse Spider",
        SPIDER_REPELLENT = "Shoo Box",
        SPIDER_HEALER_ITEM = "Healing Glop",

        -- Waterlog
        WATERTREE_PILLAR = "Great Tree Trunk",
        WATERTREE_ROOT = "Great Tree Root",

        OCEANTREE_PILLAR = "Above-Average Tree Trunk",

        OCEANTREE = "Knobbly Tree",
        OCEANTREENUT = "Knobbly Tree Nut",

        OCEANVINE = "Mossy Vine",
        FIG = "Fig",
        FIG_COOKED = "Cooked Fig",

        GRASSGATOR = "Grass Gator",

        SPIDER_WATER = "Sea Strider",
        MUTATOR_WATER = "Strider Switcherdoodle",
        OCEANVINE_COCOON = "Sea Strider Nest",
        OCEANVINE_COCOON_BURNT = "Sea Strider Nest",

        TREEGROWTHSOLUTION = "Tree Jam",

        FIGATONI = "Figatoni",
        FIGKABAB = "Figkabab",
        KOALEFIG_TRUNK = "Fig-Stuffed Trunk",
        FROGNEWTON = "Figgy Frogwich",

        -- Terraria
        EYEOFTERROR = "Eye Of Terror",
        EYEOFTERROR_MINI = "Suspicious Peeper",
        EYEOFTERROR_MINI_GROUNDED = "Egg Of Terror",
        TERRARIUM = "Terrarium",
		EYEMASKHAT = "Eye Mask",
        SHIELDOFTERROR = "Shield of Terror",
        TWINOFTERROR1 = "Retinazor",
        TWINOFTERROR2 = "Spazmatism",

        FROZENBANANADAIQUIRI = "Frozen Banana Daiquiri",
        BUNNYSTEW = "Bunny Stew",
        MILKYWHITES = "Milky Whites",

        TERRARIUMCHEST = "Conspicuous Chest",

        CRITTER_EYEOFTERROR = "Friendly Peeper",
        CRITTER_EYEOFTERROR_BUILDER = "Friendly Peeper",

        BIGSHADOWTENTACLE = "Guardian Shadow Tentacle",

		-- Cult of the Lamb
		COTL_TRINKET = "Red Crown",
        TURF_COTL_BRICK = "Brick Flooring",
        TURF_COTL_GOLD = "Gold Flooring",
		COTL_TABERNACLE_LEVEL1 = "Humble Lamb Idol",
		COTL_TABERNACLE_LEVEL2 = "Improved Lamb Idol",
		COTL_TABERNACLE_LEVEL3 = "Immaculate Lamb Idol",

        -- WOLFGANG
        MIGHTY_GYM = "Mighty Gym",
        DUMBBELL = "Dumbbell",
        DUMBBELL_GOLDEN = "Golden Dumbbell",
		DUMBBELL_MARBLE = "Marbell",
        DUMBBELL_GEM = "Gembell",

        DUMBBELL_HEAT = "Thermbell",
        DUMBBELL_BLUEGEM = "Icebell",
        DUMBBELL_REDGEM = "Firebell",

        POTATOSACK = "Potato Sack",

        RUINS_CAVEIN_OBSTACLE = "Blocky Ruins",

        -- WX78
        WX78MODULE_MAXHEALTH = "Hardy Circuit",
        WX78MODULE_MAXSANITY1 = "Processing Circuit",
        WX78MODULE_MAXSANITY = "Super-Processing Circuit",
        WX78MODULE_MOVESPEED = "Acceleration Circuit",
        WX78MODULE_MOVESPEED2 = "Super-Acceleration Circuit",
        WX78MODULE_HEAT = "Thermal Circuit",
        WX78MODULE_NIGHTVISION = "Optoelectronic Circuit",
        WX78MODULE_COLD = "Refrigerant Circuit",
        WX78MODULE_TASER = "Electrification Circuit",
        WX78MODULE_LIGHT = "Illumination Circuit",
        WX78MODULE_MAXHUNGER1 = "Gastrogain Circuit",
        WX78MODULE_MAXHUNGER = "Super-Gastrogain Circuit",
        WX78MODULE_MUSIC = "Chorusbox Circuit",
        WX78MODULE_BEE = "Beanbooster Circuit",
        WX78MODULE_MAXHEALTH2 = "Super-Hardy Circuit",

        SCANDATA = "Bio Data",

        WX78_SCANNER = "Bio Scanalyzer",
        WX78_SCANNER_ITEM = "Bio Scanalyzer",
        WX78_SCANNER_SUCCEEDED = "Bio Scanalyzer",
        WX78_MODULEREMOVER = "Circuit Extractor",

		-- QOL 2022
		JUSTEGGS = "Plain Omelette",
		VEGGIEOMLET = "Breakfast Skillet",
		TALLEGGS = "Tall Scotch Eggs",
		BEEFALOFEED = "Steamed Twigs",
		BEEFALOTREAT = "Beefalo Treats",

        -- Pirates
        BOAT_ROTATOR = "Rudder",
        BOAT_ROTATOR_KIT = "Rudder Kit",
        BOAT_MAGNET = "Nautopilot",
        BOAT_MAGNET_KIT = "Nautopilot Kit",
        BOAT_MAGNET_BEACON = "Nautopilot Beacon",
        BOAT_BUMPER_KELP = "Kelp Bumper",
        BOAT_BUMPER_KELP_KIT = "Kelp Bumper Kit",
        BOAT_BUMPER_SHELL = "Shell Bumper",
        BOAT_BUMPER_SHELL_KIT = "Shell Bumper Kit",
        BOAT_BUMPER_CRABKING = "Crab King Bumper",
        BOAT_BUMPER_CRABKING_KIT = "Crab King Bumper Kit",

        BOAT_CANNON = "Cannon",
        BOAT_CANNON_KIT = "Cannon Kit",
        CANNONBALL_ROCK = "Cannonball",
        CANNONBALL_ROCK_ITEM = "Cannonball",

        OCEAN_TRAWLER = "Ocean Trawler",
        OCEAN_TRAWLER_KIT = "Ocean Trawler Kit",

        DOCK_KIT = "Dock Kit",
        DOCK_WOODPOSTS = "Dock Piling",
        DOCK_WOODPOSTS_ITEM = "Dock Piling",

        MONKEYHUT = "Monkey Hut",
        POWDER_MONKEY = "Powder Monkey",
        PRIME_MATE = "Prime Mate",
		LIGHTCRAB = "Crustashine",
        CUTLESS = "Cutless",
        CURSED_MONKEY_TOKEN = "Accursed Trinket",
        OAR_MONKEY = "Battle Paddle",
        BANANABUSH = "Banana Bush",
        DUG_BANANABUSH = "Banana Bush",
        PALMCONETREE = "Palmcone Tree",
        PALMCONE_SEED = "Palmcone Sprout",
        PALMCONE_SAPLING = "Palmcone Sapling",
        PALMCONE_SCALE = "Palmcone Scale",
        MONKEYTAIL = "Monkeytails",
        DUG_MONKEYTAIL = "Monkeytails",

        MONKEY_MEDIUMHAT = "Captain's Tricorn",
        MONKEY_SMALLHAT = "Pirate's Bandana",
        POLLY_ROGERSHAT = "Polly Roger's Hat",
        POLLY_ROGERS = "Polly Roger",

        MONKEYISLAND_PORTAL = "Unnatural Portal",
        MONKEYISLAND_PORTAL_DEBRIS = "Broken Machinery",
        MONKEYQUEEN = "Queen of Moon Quay",
        MONKEYPILLAR = "Monkey Bar",
        PIRATE_FLAG_POLE = "Moon Quay Pirate Banner",

        BLACKFLAG = "Black Flag",
        PIRATE_STASH = "X",
        STASH_MAP = "Pirate Map",

        BANANAJUICE = "Banana Shake",

        FENCE_ROTATOR = "Fencing Sword",

        CHARLIE_STAGE_POST = "Stage",
        CHARLIE_LECTURN = "Playbill",

        HEDGEHOUND = "Briar Wolf",
        HEDGEHOUND_BUSH = "Briar",

        CHARLIE_HECKLER = "Mockingbird",

        STAGEUSHER = "Prickly Stagehand",
        SEWING_MANNEQUIN = "Mannequin",

        MASK_DOLLHAT = "Doll Mask",
        MASK_DOLLBROKENHAT = "Cracked Doll Mask",
        MASK_DOLLREPAIREDHAT = "Shattered Doll Mask",
        MASK_BLACKSMITHHAT = "Blacksmith Mask",
        MASK_MIRRORHAT = "Mirror Mask",
        MASK_QUEENHAT = "Queen Mask",
        MASK_TREEHAT = "Tree Mask",
		MASK_KINGHAT = "King Mask",
        MASK_FOOLHAT = "Fool Mask",

        COSTUME_DOLL_BODY = "Doll Costume",
        COSTUME_QUEEN_BODY = "Queen Costume",
        COSTUME_BLACKSMITH_BODY = "Blacksmith Costume",
        COSTUME_MIRROR_BODY = "Mirror Costume",
        COSTUME_TREE_BODY = "Tree Costume",
        COSTUME_KING_BODY = "King Costume",
        COSTUME_FOOL_BODY = "Fool Costume",

        PLAYBILL_THE_DOLL = "The Enchanted Doll\nA Stage Play",
        PLAYBILL_THE_VEIL = "The Pall\nA Stage Play",
        PLAYBILL_THE_VAULT = "A Task Complete\nA Confession",
        STATUEHARP_HEDGESPAWNER = "Overgrown Statue",

        -- Year of the Rabbit
        YOTR_FIGHTRING = "Pillow Fight Pit",
        YOTR_FIGHTRING_KIT = "Pillow Fight Pit Kit",
        YOTR_FIGHTRING_TORCH = "Bunnyman Torch",
        YOTR_FIGHTRING_BELL = "Pillow Fight Bell",
        NIGHTCAPHAT = "Nightcap",

        YOTR_DECOR_1 = "Short Rabbit Lamp",
        YOTR_DECOR_2 = "Tall Rabbit Lamp",

        YOTR_DECOR_1_ITEM = "Short Rabbit Lamp",
        YOTR_DECOR_2_ITEM = "Tall Rabbit Lamp",
        HAREBALL = "Hare Ball",

		--
		DREADSTONE = "Dreadstone",
		HORRORFUEL = "Pure Horror",
		DAYWALKER = "Nightmare Werepig",
		DAYWALKER_PILLAR = "Cracked Pillar",
		DAYWALKER2 = "Scrappy Werepig",
		SHADOW_LEECH = "Parasitic Shadeling",
		ARMORDREADSTONE = "Dreadstone Armor",
		DREADSTONEHAT = "Dreadstone Helm",

        -- Rifts 1
        LUNARRIFT_PORTAL = "Rift",
        LUNARRIFT_CRYSTAL_BIG = "Ryftstal",
        LUNARRIFT_CRYSTAL_SMALL = "Ryftstal",
        LUNARRIFT_TERRAFORMER_EXPLOSION = "Lunaform Burst", -- For player death messages.

		LUNAR_GRAZER = "Grazer",
        LUNARTHRALL_PLANT = "Deadly Brightshade",
        LUNARTHRALL_PLANT_GESTALT = "Incursive Gestalt",
        LUNARTHRALL_PLANT_VINE_END = "Tunneling Vine",

        PUREBRILLIANCE = "Pure Brilliance",
        LUNARPLANT_HUSK = "Brightshade Husk",

		LUNAR_FORGE = "Brightsmithy",
		LUNAR_FORGE_KIT = "Brightsmithy Kit",

		ARMOR_LUNARPLANT = "Brightshade Armor",
		LUNARPLANTHAT = "Brightshade Helm",
		BOMB_LUNARPLANT = "Brightshade Bomb",
		STAFF_LUNARPLANT = "Brightshade Staff",
		SWORD_LUNARPLANT = "Brightshade Sword",
		PICKAXE_LUNARPLANT = "Brightshade Smasher",
		SHOVEL_LUNARPLANT = "Brightshade Shoevel",
		LUNARPLANT_KIT = "Brightshade Repair Kit",

        PUNCHINGBAG = "Punching Bag",
        PUNCHINGBAG_LUNAR = "Bright Boxer",
        PUNCHINGBAG_SHADOW = "Shadow Boxer",

        -- Rifts 2
        SHADOWRIFT_PORTAL = "Rift",

		SHADOW_FORGE = "Shadowcraft Plinth",
		SHADOW_FORGE_KIT = "Shadowcraft Plinth Kit",

        FUSED_SHADELING = "Fused Shadeling",
        FUSED_SHADELING_BOMB = "Dread Mite",

		RUINS_SHADELING = "Resting Horror",

		VOIDCLOTH = "Dark Tatters",
		VOIDCLOTHHAT = "Void Cowl",
		ARMOR_VOIDCLOTH = "Void Robe",
		VOIDCLOTH_KIT = "Void Repair Kit",

        VOIDCLOTH_UMBRELLA = "Umbralla",
        VOIDCLOTH_SCYTHE = "Shadow Reaper",

		SHADOWTHRALL_HANDS = "Ink Blight",
		SHADOWTHRALL_HANDS_ALLEGIANCE = "Jitters",

		SHADOWTHRALL_HORNS = "Ink Blight",
		SHADOWTHRALL_HORNS_ALLEGIANCE = "Rasp",

		SHADOWTHRALL_WINGS = "Ink Blight",
		SHADOWTHRALL_WINGS_ALLEGIANCE = "Shriek",

		SHADOWTHRALL_MOUTH = "Ink Blight",
		SHADOWTHRALL_MOUTH_ALLEGIANCE = "Rictus",

        SHADOWTHRALL_PARASITE = "Void Masque",
        SHADOWTHRALL_PARASITE_ALLEGIANCE = "Herald of Tenebrau",

        CHARLIE_NPC = "Charlie", --Maxwell and Winona only
        CHARLIE_NPC_ALT = "Shadow Queen",
        CHARLIE_HAND = "Beckoning Hand",

        NITRE_FORMATION = "Nitre Formation",
        DREADSTONE_STACK = "Dreadstone Outcrop",

        SCRAPBOOK_PAGE = "Lost Scrapbook Page",
		SCRAPBOOK_PAGE_FMT = "{name} Scrapbook Page",

        -- Wolfgang, Woodie, Wormwood Skill Trees
        LEIF_IDOL = "Treeguard Idol",
        WOODCARVEDHAT = "Hardwood Hat",
        WALKING_STICK = "Wooden Walking Stick",

        IPECACSYRUP = "Syrup of Ipecaca",
        IPECACSYRUP_BUFF = "Ipecaca Poisoning", -- In case a player character is set up to die from the syrup.

        SUPPORT_PILLAR_SCAFFOLD = "Pillar Scaffold",
        SUPPORT_PILLAR = "Support Pillar",
        SUPPORT_PILLAR_COMPLETE = "Reinforced Support Pillar",
        SUPPORT_PILLAR_BROKEN = "Support Pillar Wreckage",

		SUPPORT_PILLAR_DREADSTONE_SCAFFOLD = "Dreadstone Pillar Scaffold",
		SUPPORT_PILLAR_DREADSTONE = "Dreadstone Pillar",
		SUPPORT_PILLAR_DREADSTONE_COMPLETE = "Reinforced Dreadstone Pillar",
		SUPPORT_PILLAR_DREADSTONE_BROKEN = "Dreadstone Pillar Wreckage",

        WOLFGANG_WHISTLE = "Coaching Whistle",

        -- Rifts 3

        MUTATEDDEERCLOPS = "Crystal Deerclops",
        MUTATEDWARG = "Possessed Varg",
        MUTATEDBEARGER = "Armored Bearger",

        LUNARFROG = "Bright-Eyed Frog",

        BEARGERFUR_SACK = "Polar Bearger Bin",
        DEERCLOPSEYEBALL_SENTRYWARD = "Ice Crystaleyezer",
        DEERCLOPSEYEBALL_SENTRYWARD_KIT = "Ice Crystaleyezer Kit",
        HOUNDSTOOTH_BLOWPIPE = "Howlitzer",

        SECURITY_PULSE_CAGE = "Spark Ark",
        SECURITY_PULSE_CAGE_FULL = "Spark Ark",

        CARPENTRY_STATION = "Sawhorse",

        PHONOGRAPH = "Gramophone",
        RECORD = "Record",
        RECORD_CREEPYFOREST = "Creepy Forest",
        RECORD_DRSTYLE = "D.R. Style",
        RECORD_EFS = "E.F.S.",
        RECORD_HALLOWEDNIGHTS = "Hallowed Night",

        WOOD_CHAIR = "Wooden Chair",
        WOOD_STOOL = "Wooden Stool",
        WOOD_TABLE_ROUND = "Round Wooden Table", -- might want to keep "wood" b/c there might be other table materials
        WOOD_TABLE_SQUARE = "Square Wooden Table", -- same as above
        DECOR_CENTERPIECE = "Art?",
        DECOR_LAMP = "Table Lamp",
        DECOR_FLOWERVASE = "Table Vase",
        DECOR_PICTUREFRAME = "Empty Frame",
		DECOR_PICTUREFRAME_DRAWING = "Framed Drawing", --use this name when drawing onto another frame or sign
        DECOR_PICTUREFRAME_DRAWN = "{item} Drawing",
        DECOR_PORTRAITFRAME = "Pleasant Portrait",

        ARCHIVE_ORCHESTRINA_MAIN = "Ancient Orchestrina",

        ARMORWAGPUNK = "W.A.R.B.I.S. Armor",
        WAGPUNKHAT = "W.A.R.B.I.S. Head Gear",

        WAGSTAFF_MACHINERY = "Abandoned Junk",
        WAGPUNK_BITS = "Scrap",
        WAGPUNKBITS_KIT = "Auto-Mat-O-Chanic",

        WAGSTAFF_MUTATIONS_NOTE = "Research Notes",
        WAGSTAFF_MATERIALS_NOTE = "Research Notes",
        WAGSTAFF_ENERGY_NOTE = "Research Notes",
        WAGSTAFF_CONTAINMENT_NOTE = "Research Notes",
        WAGSTAFF_THERMAL_NOTE = "Research Notes",
        WAGSTAFF_ELECTRICITY_NOTE = "Research Notes",

        -- Meta 3

        BATTLESONG_INSTANT_REVIVE = "Warrior's Reprise",

        WATHGRITHR_IMPROVEDHAT = "Commander's Helm",
        SPEAR_WATHGRITHR_LIGHTNING = "Elding Spear",
        SPEAR_WATHGRITHR_LIGHTNING_CHARGED = "Charged Elding Spear",

        BATTLESONG_CONTAINER = "Battle Call Canister",

        SADDLE_WATHGRITHR = "Battle Saddle",

        WATHGRITHR_SHIELD = "Battle Rönd",

        BATTLESONG_SHADOWALIGNED = "Dark Lament",
        BATTLESONG_LUNARALIGNED = "Enlightened Lullaby",

        WILLOW_EMBER = "Ethereal Ember",
        EMBERLIGHT = "Fire Ball",

        SHARKBOI = "Frostjaw",
        SHARKBOI_ICESPIKE = "Ice",

        BOOTLEG = "Bootleg Getaway",
        OCEANWHIRLPORTAL = "Whirlportal",

        -- Year of the Dragon
        YOTD_DRAGONSHRINE = "Dragonfly Shrine",

        DRAGONBOAT_BODY = "Dragonfly Boat",
        DRAGONBOAT_KIT = "Dragonfly Boat Kit",
        DRAGONBOAT_PACK = "Decked-Out Dragonfly Boat Kit",

        BOATRACE_CHECKPOINT = "Race Checkpoint",
        BOATRACE_CHECKPOINT_THROWABLE_DEPLOYKIT = "Race Checkpoint Kit",
        BOATRACE_START = "Start Tower",
        BOATRACE_START_THROWABLE_DEPLOYKIT = "Start Tower Kit",

        BOATRACE_PRIMEMATE = "Charlie's Racer",
        BOATRACE_SPECTATOR_DRAGONLING = "Broodling Spectator",

        YOTD_STEERINGWHEEL = "Dragonfly Boat Wheel",
        YOTD_STEERINGWHEEL_ITEM = "Dragonfly Boat Wheel Kit",
        YOTD_OAR = "Claw Oar",
        YOTD_ANCHOR = "Claw Anchor",
        YOTD_ANCHOR_ITEM = "Claw Anchor Kit",
        MAST_YOTD = "Dragonfly Wing Mast",
        MAST_YOTD_ITEM = "Dragonfly Wing Mast Kit",
        BOAT_BUMPER_YOTD = "Fanged Bumper",
        BOAT_BUMPER_YOTD_KIT = "Fanged Bumper Kit",
        BOATRACE_SEASTACK = "Golden Buoy",
        BOATRACE_SEASTACK_THROWABLE_DEPLOYKIT = "Golden Buoy Kit",
        BOATRACE_SEASTACK_MONKEY = "Thorny Buoy",
        BOATRACE_SEASTACK_MONKEY_THROWABLE_DEPLOYKIT = "Thorny Buoy Kit",
        MASTUPGRADE_LAMP_YOTD = "Dragonfly Light",
        MASTUPGRADE_LAMP_ITEM_YOTD = "Dragonfly Light Kit",
        WALKINGPLANK_YOTD = "Scaled Plank",

        -- Rifts / Meta QoL

        HEALINGSALVE_ACID = "Slimy Salve",

        BEESWAX_SPRAY = "Embalming Spritz",
        STORAGE_ROBOT = "W.O.B.O.T.",

        SCRAP_MONOCLEHAT = "Horizon Expandinator",
        SCRAPHAT = "Scrappy Chapauldron",

        JUNK_PILE = "Junk Pile",
        JUNK_PILE_BIG = "Teetering Junk Pile",

        FENCE_JUNK = "Junky Fence",

        ARMOR_LUNARPLANT_HUSK = "Brambleshade Armor",

        -- Meta 4 / Ocean QoL

        OTTER = "Marotter",
        OTTERDEN = "Marotter Den",
        BOAT_OTTERDEN = "Marotter Raft",
        OTTERDEN_DEAD = "Demolished Marotter Den",

        BOAT_ANCIENT = "Archaic Boat",
        BOAT_ANCIENT_ITEM = "Archaic Boat Kit",
        BOAT_ANCIENT_CONTAINER = "Cargo Hold",
        WALKINGPLANK_ANCIENT = "Archaic Plank",

        ANCIENTTREE_SEED = "Surprising Seed",
        ANCIENTTREE_SEED_PLANTED = "Planted Surprising Seed",

        ANCIENTTREE_GEM = "Sproutrock",
        ANCIENTTREE_GEM_SAPLING = "Young Sproutrock",
        ANCIENTTREE_GEM_SAPLING_ITEM = "Sproutrock Sapling",

        ANCIENTTREE_NIGHTVISION = "Gloomthorn",
        ANCIENTTREE_NIGHTVISION_SAPLING = "Young Gloomthorn",
        ANCIENTTREE_NIGHTVISION_SAPLING_ITEM = "Gloomthorn Sapling",

        ANCIENTFRUIT_GEM = "Geode Fruit",
        ANCIENTFRUIT_NIGHTVISION = "Nightberry",
        ANCIENTFRUIT_NIGHTVISION_COOKED = "Cooked Nightberry",

        BOATPATCH_KELP = "Kelp Patch",

        CRABKING_MOB = "Crab Guard",
        CRABKING_MOB_KNIGHT = "Crab Knight",

        CRABKING_CANNONTOWER = "Cannon Tower",
        CRABKING_ICEWALL = "Ice Barrier",

        SALTLICK_IMPROVED = "Gourmet Salt Lick",

        MERM_SHADOW = "Shadow Merm",
        MERMGUARD_SHADOW = "Shadow Merm Guard",

        MERM_LUNAR = "Mutated Merm",
        MERMGUARD_LUNAR = "Mutated Merm Guard",

        -- Rifts 4

        SHADOW_BEEF_BELL = "Beefalo Gloom Bell",
        SADDLE_SHADOW = "Nightmare Saddle",
        SHADOW_BATTLEAXE = "Shadow Maul",
        VOIDCLOTH_BOOMERANG = "Gloomerang",
		ROPE_BRIDGE_KIT = "Spelunker's Bridge Kit",

		GELBLOB = "Icker",

        RABBITKING_AGGRESSIVE = "Wrathful Rabbit King",
        RABBITKING_PASSIVE = "Benevolent Rabbit King",
        RABBITKING_LUCKY = "Fortuitous Rabbit",
        RABBITKINGMINION_BUNNYMAN = "Royal Rabbit Enforcer",
        ARMOR_CARROTLURE = "Coat of Carrots",
        RABBITKINGHORN = "Burrowing Horn",
        RABBITKINGHORN_CHEST = "Portable Den",
        RABBITKINGSPEAR = "Rabbit King Cudgel",
        RABBITHAT = "Warren Wreath",

        WORM_BOSS = "Great Depths Worm",

        RUINSNIGHTMARE = "Lurking Nightmare",

        ITEMMIMIC_REVEALED = "Mimicreep",

        STONE_CHAIR = "Stone Chair",
        STONE_STOOL = "Stone Stool",
        STONE_TABLE_ROUND = "Stone Round Table",
        STONE_TABLE_SQUARE = "Stone Square Table",

        BOARDS_BUNCH = "Bunch o' Boards",
        CUTSTONE_BUNCH = "Bunch o' Stone",

        CARPENTRY_BLADE_MOONGLASS = "Moon Glass Saw Blade",

        CHEST_MIMIC = "Ornate Chest",
        CHEST_MIMIC_REVEALED = "Ornery Chest",

        SHADOWHEART_INFUSED = "Possessed Shadow Atrium",

        GELBLOB_STORAGE = "Icker Preserve",
        GELBLOB_STORAGE_KIT = "Icker Preserve Kit",
        GELBLOB_BOTTLE = "Icker Jar",

        PLAYER_HOSTED = "Inthralled Corpse",
        PLAYER_HOSTED_ME = "Deadelgänger",

        MASK_SAGEHAT = "Sage's Masque",
        MASK_HALFWITHAT = "Halfwit's Masque",
        MASK_TOADYHAT = "Toady's Masque",

        PUMPKINCARVER1 = "Pumpkin Scooper",
        PUMPKINCARVER2 = "Pumpkin Knife",
        PUMPKINCARVER3 = "Pumpkin Saw",

		SNOWMAN = "Snowman",
		SNOWBALL_LARGE = "Large Snowball",
		SNOWBALL_ITEM = "Snowball",

        -- Year of the Snake
        YOTS_SNAKESHRINE = "Depths Worm Shrine",
        YOTS_WORM = "Gilded Depths Worm",
        YOTS_LANTERN_POST = "Jubilantern Post",
        YOTS_LANTERN_POST_ITEM = "Jubilantern Post Kit",

        -- Meta 5

        GHOSTLYELIXIR_LUNAR = "Luminous Wrath",
        GHOSTLYELIXIR_SHADOW = "Cursed Vexation",
        GRAVEGUARD_GHOST = "Bigspook",
        DUG_GRAVESTONE = "Headstone",
        WENDY_RECIPE_GRAVESTONE = "Headstone",

		SLINGSHOTMODKIT = "Slingshot Field Kit",
		SLINGSHOT_BAND_PIGSKIN = "Pig Skin Slingshot Band",
		SLINGSHOT_BAND_TENTACLE = "Flailing Slingshot Band",
		SLINGSHOT_BAND_MIMIC = "Possessed Slingshot Band",
		SLINGSHOT_FRAME_BONE = "Bony Slingshot Frame",
		SLINGSHOT_FRAME_GEMS = "Thulecite Slingshot Frame",
		SLINGSHOT_FRAME_WAGPUNK_0 = "Scrappy Slingshot Frame",
		SLINGSHOT_FRAME_WAGPUNK = "Scrappier Slingshot Frame",
		SLINGSHOT_HANDLE_STICKY = "Slingshot Sticky Grip",
		SLINGSHOT_HANDLE_JELLY = "Slingshot Jelly Grip",
		SLINGSHOT_HANDLE_SILK = "Slingshot Grip Tape",
		SLINGSHOT_HANDLE_VOIDCLOTH = "Slingshot Void Wrap",

		WOBY_TREAT = "Woby Snacks",
        BANDAGE_BUTTERFLYWINGS = "Flutter Strip",
		PORTABLEFIREPIT_ITEM = "Portable Campfire",
        SLINGSHOTAMMO_CONTAINER = "Ammo Pouch",

        ELIXIR_CONTAINER = "Picnic Casket",
        GHOSTFLOWERHAT = "Wraith's Wreath",
        WENDY_RESURRECTIONGRAVE = "Perennial Altar",
        WENDY_RESURRECTIONGRAVE_NAMED = "{name}'s Perennial Altar",
        GRAVEURN = "Spirit Vessel",

        -- For PVP!
        SLINGSHOTAMMO_HORRORFUEL_DEBUFF_FX = "Swarming Horror",
        SLINGSHOTAMMO_PUREBRILLIANCE_DEBUFF = "Flash of Brilliance",

        SHALLOW_GRAVE = "Shallow Grave",
        SHALLOW_GRAVE_PLAYER = "Shallow Grave",

        -- Deck Of Cards
        DECK_OF_CARDS = "Deck Of Cards",
        PLAYING_CARD = "Playing Card",

        BALATRO_MACHINE = "JIMBO",

		-- Rifts 5
		GESTALT_CAGE = "Phasmo-Encapsulator",
        WAGBOSS_ROBOT_SECRET = "Undisclosed Construct",
		WAGBOSS_ROBOT = "W.A.R.B.O.T.",
        WAGBOSS_ROBOT_POSSESSED = "Enlightened W.A.R.B.O.T.",
		WAGBOSS_ROBOT_LEG = "W.A.R.B.O.T. Leg",
		WAGBOSS_MISSILE = "Thermalock Missile",
		ALTERGUARDIAN_PHASE1_LUNARRIFT = "Celestial Revenant",
		ALTERGUARDIAN_PHASE1_LUNARRIFT_GESTALT = "Pure Gestalt",
        ALTERGUARDIAN_PHASE4_LUNARRIFT = "Celestial Scion",
		WAGDRONE_ROLLING = "Terramite",
		WAGDRONE_FLYING = "Warbler",
		WAGDRONE_PARTS = "Gyroscopic Transduction Core",
		WAGDRONE_BEACON = "Terramite Barrier Post",

        WAGPUNK_CAGEWALL = "Kinetoclasmic Field Expandinator",
        WAGPUNK_FLOOR_KIT = "Substrate Extrapolator",
        WAGPUNK_LEVER = "Fulcronial Selector",
        WAGPUNK_WORKSTATION = "Notional Fabricator",

		WAGSTAFF_ITEM_1 = "Glove",
		WAGSTAFF_ITEM_2 = "Clipboard",

        HERMITCRAB_RELOCATION_KIT = "Hermit Rehomer",

        WANDERINGTRADER = "Odd Beefalo",
        WANDERINGTRADER_REVEALED = "Wandering Trader",

        FLOTATIONCUSHION = "Personal Floater",
        GESTALT_GUARD_EVOLVED = "Inimical Gestalt",
        LUNAR_SEED = "Celestial Jewel",
		TEMP_BETA_MSG = "Beta Report",

        -- rifts5.1
        WAGBOSS_ROBOT_CONSTRUCTIONSITE = "W.A.R.B.O.T. Base",
        WAGBOSS_ROBOT_CONSTRUCTIONSITE_KIT = "W.A.R.B.O.T. Base Kit",
        WAGBOSS_ROBOT_CREATION_PARTS = "W.A.R.B.O.T. Parts",
        MOONSTORM_STATIC_CATCHER = "Static Restrainer",
        COOLANT = "Nucleation Fluid",

        FENCE_ELECTRIC = "T.I.N.G.L.E. Node",
        FENCE_ELECTRIC_FIELD = "T.I.N.G.L.E",
        FENCE_ELECTRIC_ITEM = "T.I.N.G.L.E. Node",

        MUTATEDBIRD = "Bright-Beaked Bird",
        MUTATEDBUZZARD_GESTALT = "Crystal-Crested Buzzard",

        -- Names for missed scrapbook entries
        WAVEYJONES = "Wavey Jones",
        SHADOWHAND = "Shadow Hand",

        -- Rifts 6

        SHADOWTHRALL_CENTIPEDE = "Mega Blight",
        SHADOWTHRALL_CENTIPEDE_ALLEGIANCE = "Ripple",

        TREE_ROCK = "Boulderbough",
        CAVE_VENT_ROCK = "Fumarole",

		ABYSSPILLAR_MINION = "Sequitor",
		ABYSSPILLAR_TRIAL = "Lever", --Pillar puzzle lever

        VAULT_TELEPORTER = "Sanctum Waymark", -- Channel device to teleport players around the vault.
		VAULT_TELEPORTER_BROKEN = "Broken Sanctum Waymark",
		VAULT_ORB = "Portation Orb",
		VAULT_LOBBY_EXIT = "Chasm",
		VAULT_CHANDELIER_BROKEN = "Sanctum Lustre",

		ANCIENT_HUSK = "Ancient Remains",
		MASK_ANCIENT_HANDMAIDHAT = "Elytra's Mask",
		MASK_ANCIENT_ARCHITECTHAT = "Visionist's Mask",
		MASK_ANCIENT_MASONHAT = "Artificer's Mask",

        TREE_ROCK_SEED = "Boulderbough Seed",
        TREE_ROCK_SAPLING = "Boulderbough Sapling",

        CAVE_FERN_WITHERED = "Withered Fern",
        FLOWER_CAVE_WITHERED = "Withered Light Flower",

        -- Rifts 6.1

        OCEANWHIRLBIGPORTAL = "Giant Whirlpool",
        OCEANWHIRLBIGPORTALEXIT = "Ocean Detritus", -- The flotsam pickable not the waterfall.

		VAULT_TORCH = "Flummoxing Flame",

        CAVE_VENT_MITE = "Geothermite",

		-- Hallowed Nights 2025

		PUMPKINHAT = "Faceless Pumpkin",
		PUMPKINHAT_CARVED = "Pumpkin Head",

		-- Winter's Feast 2025

		GIFTSURPRISE = "???",

		HERMITHOTSPRING = "Pearl's Hot Spring",
		HERMITHOTSPRING_ABANDONED = "Dry Hot Spring",
		HERMITHOTSPRING_CONSTR = "Hot Spring",
		MEATRACK_HERMIT_MULTI = "Large Drying Rack",
		MEATRACK_HERMIT_ABANDONED = "Seaside Debris",
		HERMITHOUSE_ORNAMENT = "Wind Charm",
		HERMITHOUSE_LAUNDRY_SOCKS = "Stockings",
		HERMITHOUSE_LAUNDRY_SHORTS = "Bloomers",
		HERMIT_CHAIR_ROCKING = "Driftwood Rocker",

        SHELLWEAVER = "Combriner",
        ICESTAFF2 = "Flash Freeze Staff",
        ICESTAFF3 = "Deep Freeze Staff",
        NONSLIPGRIT = "Grit Duster",
        NONSLIPGRITBOOSTED = "Grit Grinder",
        DESICCANT = "Desiccant Pouch",
        DESICCANTBOOSTED = "Desiccant Sack",
        HERMITCRAB_SHELL = "Portage Conch",
        SALTY_DOGHAT = "Salty Dog's Hat",
        SALTY_DOG = "Salty Dog",

        HERMITCRAB_TEASHOP = "Pearl's Tea Shop",--boat looking shop - trade pearl for teas. give her bottle
        HERMITCRAB_TEASHOP_ABANDONED = "Abandoned Tea Shop",

        HERMITCRABTEA_PETALS = "Petal Tea",--tea with petals, sanity buff
        HERMITCRABTEA_PETALS_EVIL = "Dark Petal Tea",--tea with evil petals, make you insane?
        HERMITCRABTEA_FOLIAGE = "Foliage Tea",
        HERMITCRABTEA_SUCCULENT_PICKED = "Succulent Tea",--cool you down
        HERMITCRABTEA_MOON_TREE_BLOSSOM = "Lune Tree Blossom Tea",--warm you up
        HERMITCRABTEA_FIRENETTLES = "Fire Nettle Tea",
        HERMITCRABTEA_TILLWEED = "Tillweed Tea",
        HERMITCRABTEA_FORGETMELOTS = "Forget-Me-Lots Tea",

        PETALS_DRIED = "Dried Petals",
        PETALS_EVIL_DRIED = "Dried Dark Petals",
        FOLIAGE_DRIED = "Dried Foliage",
        SUCCULENT_PICKED_DRIED = "Dried Succulent",
        MOON_TREE_BLOSSOM_DRIED = "Dried Lune Tree Blossom",
        FIRENETTLES_DRIED = "Dried Fire Nettle Frond",
        TILLWEED_DRIED = "Dried Tillweed",
        FORGETMELOTS_DRIED = "Dried Forget-Me-Lots",

        FISHMEAT_DRIED = "Fishy Jerky",
        FISHMEAT_SMALL_DRIED = "Small Fishy Jerky",

        HERMITCRAB_LIGHTPOST = "Pearl's Light Post",
        HERMITCRAB_LIGHTPOST_ABANDONED = "Seaside Spoils",
        HERMITCRAB_LIGHTPOST_ITEM = "Pearl's Light Post Kit",
	},

    NAME_DETAIL_EXTENTION =
    {
        LAVAARENA_ARMORLIGHT = "50% Protection\n+5% Faster Cooldown",
        LAVAARENA_ARMORLIGHTSPEED = "60% Protection\n+10% Move Speed",
        LAVAARENA_ARMORMEDIUM = "75% Protection",
        LAVAARENA_ARMORMEDIUMDAMAGER = "75% Protection\n+10% Physical Damage",
        LAVAARENA_ARMORMEDIUMRECHARGER = "75% Protection\n+10% Faster Cooldown",
        LAVAARENA_ARMORHEAVY = "85% Protection",
        LAVAARENA_ARMOREXTRAHEAVY = "90% Protection\n-15% Move Speed\nKnockback Resistance",

        LAVAARENA_FEATHERCROWNHAT = "+20% Move Speed",
        LAVAARENA_HEALINGFLOWERHAT = "+25% Healing Received",
        LAVAARENA_LIGHTDAMAGERHAT = "+10% Physical Damage",
        LAVAARENA_STRONGDAMAGERHAT = "+15% Physical Damage",
        LAVAARENA_TIARAFLOWERPETALSHAT = "+20% Healing Dealt",
        LAVAARENA_RECHARGERHAT = "+10% Faster Cooldown",
        LAVAARENA_HEALINGGARLANDHAT = "+2 HP/s (80% HP Max)\n+10% Faster Cooldown\n+10% Move Speed",
        LAVAARENA_CROWNDAMAGERHAT = "+15% Physical Damage\n+10% Faster Cooldown\n+10% Move Speed",
        LAVAARENA_EYECIRCLETHAT = "+25% Magic Damage\n+10% Faster Cooldown\n+10% Move Speed",

		-- Lavaarena Season 2
		LAVAARENA_ARMOR_HPEXTRAHEAVY = "90% Protection\n+100 Max Health\nKnockback Resistance",
		LAVAARENA_ARMOR_HPPETMASTERY = "80% Protection\n+75 Max Health\nCompanion Buff",
		LAVAARENA_ARMOR_HPRECHARGER = "80% Protection\n+50 Max Health\n+15% Faster Cooldown",
		LAVAARENA_ARMOR_HPDAMAGER = "80% Protection\n+50 Max Health\n+20% Physical Damage",

    },

    DIRECTIONS =
    {
        N = "North",
        S = "South",
        E = "East",
        W = "West",
        NE = "Northeast",
        SE = "Southeast",
        NW = "Northwest",
        SW = "Southwest",
    },

    RECIPE_DESC =
    {
        BOOKSTATION = "All books must be arranged using the Dewey Decimal System.",

        BOOK_BIRDS = "1000 species: habits, habitats, and calls.",
        BOOK_TENTACLES = "Let's learn about our subterranean friends!",
        BOOK_GARDENING = "On the care and feeding of plants.",
        BOOK_SILVICULTURE = "A guide to branch management.",
		BOOK_HORTICULTURE = "On the care and feeding of crops.",
        BOOK_SLEEP = "Soothing tales to send you off to dreamland.",
        BOOK_BRIMSTONE = "The world will end in fire and tribulation!",

        BOOK_FISH = "Fishing, made easy!",
        BOOK_FIRE = "Use these simple techniques to defuse any fiery situation.",
        BOOK_WEB = "You don't know someone until you walk a mile in their webs.",
        BOOK_TEMPERATURE = "Keep your personal climate under control with these easy steps.",
        BOOK_LIGHT = "An illuminating read.",
        BOOK_RAIN = "Save it for a rainy day, whenever you decide that will be.",
        BOOK_MOON = "Summon the power of the moon.",
        BOOK_BEES = "Learn the ABC's of beekeeping.",

        BOOK_HORTICULTURE_UPGRADED = "Expert analysis on advanced crop care.",
        BOOK_RESEARCH_STATION = "A complete guide to everything from A to Z.",
        BOOK_LIGHT_UPGRADED = "This complete edition far outshines its predecessor.",

        FIREPEN = "Keep those rambunctious flames penned in.",

        CARTOGRAPHYDESK = "Show everyone exactly where you've been.",
        COMPASS = "Points the way north.",
        GUNPOWDER = "A handful of gunpowder.",
        TORCH = "Portable light source.",
        LIGHTER = "Burns through the night and in the rain.",
        TRAP = "Capture small creatures.",
        BIRDTRAP = "Capture winged beasts.",
        PIGHOUSE = "Shelters one pig.",
        RABBITHOUSE = "Houses a giant rabbit and all his stuff.",
        CAMPFIRE = "Provides light while burning.",
        FIREPIT = "A safer, more efficient campfire.",
        COLDFIRE = "This fire is from opposite day.",
        COLDFIREPIT = "More efficient, but still backwards.",
        FIRESUPPRESSOR = "Saves plants, puts out fires, fueled by flame.",
        FERTILIZER = "Less poop on hands, more poop on plants.",
        HEATROCK = "Stores thermals for travel.",
        SLOW_FARMPLOT = "Grows seeds.",
        FAST_FARMPLOT = "Grows seeds a bit faster.",
        MUSHROOM_FARM = "Grows mushrooms.",
        TENT = "Restores sanity, costs time and hunger.",
        SIESTAHUT = "Escape the heat to restore sanity.",
        ROPE = "Tightly woven coils of usefulness.",
        ARMORWOOD = "Protects you from some damage.",
        ARMORGRASS = "Provides a small amount of protection.",
        ARMORMARBLE = "It's heavy, but it will protect you.",
        ARMOR_SANITY = "Protects your body, but not your mind.",
        SPEAR = "Use the pointy end.",
        CLAW_GLOVE = "Gets rid of tough obstacles.",
        STRAWHAT = "Helps you stay cool and dry.",
        TOPHAT = "The classiest hat of all.",
        FLOWERHAT = "Something to soothe the nerves.",
        KELPHAT = "Something to agitate the nerves.",
        BEEFALOHAT = "Be one with the herd! Smell included.",
        AXE = "Chop down trees!",
        PICKAXE = "Break down rocks.",
        HAMMER = "Smashes all kinds of things.",
        SHOVEL = "Dig up all sorts of things.",
        PITCHFORK = "Move the ground around.",
        GOLDENAXE = "Chop down trees with STYLE!",
        GOLDENPICKAXE = "Break down rocks like a boss.",
        GOLDENSHOVEL = "Lasts longer, digs the same stuff.",
        GOLDENPITCHFORK = "Rearrange the whole world.",
        CUTSTONE = "Nicely squared rocks.",
        MARBLEBEAN = "Grow a marble forest.",
        WINTEROMETER = "Measure ambient air temperature.",
        RAINOMETER = "Observe precipitation probabilities.",
        RESURRECTIONSTATUE = "Resurrect yourself via the power of meat.",
        BOARDS = "Like logs, but flatter.",
        RESEARCHLAB = "Unlock new crafting recipes!",
        GIFTWRAP = "Wrap things up, nice and pretty!",
        BUNDLEWRAP = "Part and parcel to bundling your stuff.",
        BACKPACK = "Carry more stuff.",
        PIGGYBACK = "Carries a lot, but slows you down.",
        ICEPACK = "Keeps stuff fresh.",
        UMBRELLA = "Keep the sun and rain at bay!",
        RESEARCHLAB2 = "Unlock even more crafting recipes!",
        RESEARCHLAB3 = "Is this even science anymore?",
        RESEARCHLAB4 = "Amplify the magical power of your top hat.",
        RAZOR = "Shave off your dirty beatnik beard.",
        PAPYRUS = "For writing things.",
        WAXPAPER = "For wrapping things.",
        PANFLUTE = "Music to soothe savage beasts.",
        COOKPOT = "Make better food.",
        BUGNET = "Catch bugs.",
        THULECITEBUGNET = "Catch bugs the ancient way.",
        SADDLEHORN = "Pry that saddle off.",
        BRUSH = "Relieve beefalo of their hair buildup.",
        SALTLICK = "Keep your livestock content.",
        BEESWAX = "A useful preservative wax.",
        BEEBOX = "Store your own bees.",
        BEEHAT = "Protection against angry bees.",
        TREASURECHEST = "A sturdy container.",
        CHESTUPGRADE_STACKSIZE = "It's a bit of a stretch for some storage space.",
        DRAGONFLYCHEST = "A sturdy and fireproof container.",
        DRAGONFLYFURNACE = "Build yourself a fly flue.",
        BEDROLL_STRAW = "Sleep through the night.",
        BEDROLL_FURRY = "Sleep through the night in comfort!",
        PUMPKIN_LANTERN = "Spooky illumination.",
		POCKET_SCALE = "Weigh your fish on the go!",
		TACKLECONTAINER = "Tactfully store your tackle.",
		SUPERTACKLECONTAINER = "More space for tackle? I'm hooked!",
        FISHINGROD = "Go fishing. For fish.",
        OCEANFISHINGROD = "Fish like a pro.",
        OCEANFISHINGBOBBER_BALL = "A classic design for pros and beginners.",
        OCEANFISHINGBOBBER_OVAL = "A more stylish take on the classic bobber.",
		OCEANFISHINGBOBBER_CROW = "Favoured by more discerning anglers.",
		OCEANFISHINGBOBBER_ROBIN = "Favoured by more discerning anglers.",
		OCEANFISHINGBOBBER_ROBIN_WINTER = "Favoured by more discerning anglers.",
		OCEANFISHINGBOBBER_CANARY = "Favoured by more discerning anglers.",
		OCEANFISHINGBOBBER_GOOSE = "A fancy downy float.",
		OCEANFISHINGBOBBER_MALBATROSS = "A fancy float from a furious fowl.",
		OCEANFISHINGLURE_SPINNER_RED = "The early fish gets the worm.",
		OCEANFISHINGLURE_SPINNER_GREEN = "A lure that works best in low light.",
		OCEANFISHINGLURE_SPINNER_BLUE = "Go for a quick evening bite.",
		OCEANFISHINGLURE_SPOON_RED = "The early fish gets the worm.",
		OCEANFISHINGLURE_SPOON_GREEN = "Fish on into the sunset.",
		OCEANFISHINGLURE_SPOON_BLUE = "Go for a quick evening bite.",
		OCEANFISHINGLURE_HERMIT_RAIN = "Keep one around for a rainy day.",
		OCEANFISHINGLURE_HERMIT_SNOW = "There's snow better time for fishing!",
		OCEANFISHINGLURE_HERMIT_DROWSY = "A confused fish is a caught fish.",
		OCEANFISHINGLURE_HERMIT_HEAVY = "Reel in the big one!",
        FEATHERHAT = "A dress for your head.",
        MINERHAT = "Light up the night with your noggin.",
        FOOTBALLHAT = "Protect your braincase.",
        BLOWDART_SLEEP = "Spit sleepiness at your enemies.",
        BLOWDART_FIRE = "Spit fire at your enemies.",
        BLOWDART_PIPE = "Spit teeth at your enemies.",
        BLOWDART_YELLOW = "Spit lightning at your enemies.",
        BEEMINE = "Weaponized bees. What could go wrong?",
        AMULET = "Protects you from death.",
        PURPLEAMULET = "Induce insanity.",
        BLUEAMULET = "What a cool amulet.",
        ORANGEAMULET = "For those who don't like to pick items up.",
        GREENAMULET = "Craft with a discount!",
        YELLOWAMULET = "Pull power from the heavens.",
        SWEATERVEST = "Rugged, yet stylish.",
        REFLECTIVEVEST = "Keep cool and fresh in this stylish vest.",
        HAWAIIANSHIRT = "Fun in the sun. Or on Casual Fridays.",
        BEARGERVEST = "A bear of a vest.",
        ARMORDRAGONFLY = "Armor with a fiery temper.",
        STAFF_TORNADO = "Blow your enemies away.",
        RESKIN_TOOL = "Make a clean sweep of redecorating.",
        TRUNKVEST_SUMMER = "Warm, but not that warm.",
        TRUNKVEST_WINTER = "Warm enough for winter storms.",
        BIRDCAGE = "A happy home for your avian friends.",
   		SCARECROW = "Models all the latest fall fashions.",
        SPIDERHAT = "Spiders will call you \"mom\".",
        TRAP_TEETH = "Pops up and bites whoever steps on it.",
        TRAP_TEETH_MAXWELL = "Pops up and bites whoever steps on it.",
        EARMUFFSHAT = "A fuzzy little bit of warmth.",
        WINTERHAT = "Keeps yer noggin warm.",
        BUSHHAT = "Good for hiding!",
        BOOMERANG = "It comes from a land down under.",
        ICEBOX = "Slows food spoilage.",
        ONEMANBAND = "Even crazy musicians amass a following.",
        NIGHTMAREFUEL = "Evil residue used by the foolish and crazy.",
        PURPLEGEM = "By your colors combined!",
        HAMBAT = "It takes food to make food.",
        HOMESIGN = "Make your mark upon the world.",
        MINISIGN_ITEM = "Draw on these with a Feather Pencil.",
        ARROWSIGN_POST = "Point fingers at the world. Or signs.",
        WALL_WOOD_ITEM = "Wooden wall segments.",
        WALL_STONE_ITEM = "Stone wall segments.",
        WALL_HAY_ITEM = "Hay wall segments. Not very sturdy.",
        WALL_MOONROCK_ITEM = "Walls for the lunar loony.",
		WALL_DREADSTONE_ITEM = "Surround yourself in the most dreadful decor.",
        MOONROCKCRATER = "A rock for marking your territory.",
        FENCE_ITEM = "Wood fence segments.",
        FENCE_GATE_ITEM = "A gate for wood fencing.",
        TURF_WOODFLOOR = "High-quality laminate floorboards.",
        TURF_CHECKERFLOOR = "Nicely checkered marble tiles.",
        TURF_METEOR = "The cratered surface of the moon.",
        TURF_FUNGUS_MOON = "The mutated fungal floor of a cave.",
		TURF_ARCHIVE = "Ancient stonework from an unsealed archive.",
        TURF_VAULT = "Ancient stonework from the Sanctum.",
        TURF_VENT = "The craggy stone floor of a fumey cave.",
		BLUEPRINT_CRAFTINGSET_RUINS_BUILDER = "Build a floor in the style of a long-gone civilization.",
		BLUEPRINT_CRAFTINGSET_RUINSGLOW_BUILDER = "As faithful a recreation as could be mustered.",
		TURF_RUINSBRICK = "Ancient stone flooring, decorated with a magical technique lost to time.",
		TURF_RUINSBRICK_GLOW = "A reproduction of ancient stone flooring.",
		TURF_RUINSTILES = "Tile flooring, decorated with a magical technique lost to time.",
		TURF_RUINSTILES_GLOW = "A reproduction of ancient tile flooring.",
		TURF_RUINSTRIM = "Brick flooring, decorated with a magical technique lost to time.",
		TURF_RUINSTRIM_GLOW = "A reproduction of ancient brick flooring.",
        TURF_SHELLBEACH = "A patch of seashell seashore.",
        TURF_CARPETFLOOR = "Super soft. Smells like Beefalo.",

        TURF_CARPETFLOOR2 = "Super Super soft.",
        TURF_MOSAIC_GREY = "Elegantly broken rock. In grey.",
        TURF_MOSAIC_BLUE = "Elegantly broken rock. In blue.",
        TURF_MOSAIC_RED  = "Elegantly broken rock. In red.",

        TURF_ROAD = "Build your own road to nowhere.",
        TURF_DRAGONFLY = "Quell the spread of fire.",
        SEWING_KIT = "Fix up degraded clothing items.",
        SEWING_TAPE = "Patch up degraded clothing items.",
        NIGHTLIGHT = "Light the night with your dreams.",
        NIGHTSWORD = "Lucid dreaming damage.",
        NIGHTSTICK = "Morning light for a nighttime fight.",
        ICESTAFF = "Freeze enemies in their tracks.",
        FIRESTAFF = "Harness the power of combustion!",
        MEATRACK = "The jerkiest of racks.",
        BANDAGE = "Heal your minor wounds.",
        HEALINGSALVE = "Disinfectant for cuts and abrasions.",
		TILLWEEDSALVE = "Slowly weed out aches and pains.",
        WATERBALLOON = "Spheroid fire suppression.",
        BALLOONS_EMPTY = "If only there was an easier way.",
        BALLOON = "Who doesn't like balloons?",
		BALLOONPARTY = "Spread a little cheer.",
		BALLOONSPEED = "Makes you light on your feet.",
		BALLOONVEST = "Bouyant balloons for boating.",
		BALLOONHAT = "A great conversation starter!",
        LIFEINJECTOR = "Boosts your declining max health.",
        LIGHTNING_ROD = "Protection from strikes.",
        CANE = "Trot on with speed and poise.",
        DIVININGROD = "There must be some way out of here...",
        LANTERN = "Refuelable, bright, portable!",
        BATBAT = "All this science is so... draining.",
        TELESTAFF = "Bend space! Time bend sold separately.",
        ORANGESTAFF = "For those who don't like walking.",
        GREENSTAFF = "Clean and efficient destruction.",
        YELLOWSTAFF = "Summon a tiny star.",
        TELEBASE = "Just add gems.",
        MULTITOOL_AXE_PICKAXE = "Doubly useful.",
        ARMORRUINS = "Flashy AND protective.",
        RUINS_BAT = "Spikes make everything better.",
        NIGHTMARE_TIMEPIECE = "Track the flow of ambient magic levels.",
        ARMORSLURPER = "Keep that belly full.",
        EYETURRET_ITEM = "Keep nasties away. By killing them.",
        ACCOMPLISHMENT_SHRINE = "Prove your worth as a human being.",
        WALL_RUINS_ITEM = "These walls will take quite a beating.",
        POTTEDFERN = "Make a pot and stick a fern inside.",
        SUCCULENT_POTTED = "A pretty succulent jammed in a pot.",
        ENDTABLE = "A decorative table.",
        SENTRYWARD = "The cartographer's most valuable weapon.",
        TOWNPORTAL = "Gather your friends with sand power.",
        MOONDIAL = "Track the phases of the moon!",
        THULECITE = "Combine tiny bits into a big chunk.",
        RUINSHAT = "Complete with ancient force field!",
        SPIDEREGGSACK = "Get a little help from your friends.",

        RUINSRELIC_PLATE = "Craft a fancy broken plate.",
        RUINSRELIC_BOWL = "A distressed bowl.",
        RUINSRELIC_CHAIR = "A weathered-looking chair.",
        RUINSRELIC_CHIPBOWL = "Don't double dip.",
        RUINSRELIC_VASE = "A faux-vintage vase.",
        RUINSRELIC_TABLE = "Don't put your elbows on it.",

		VAULTRELIC_BOWL = "It's not dirty, it's \"developing a patina\".",
		VAULTRELIC_VASE = "Decor from a bygone age.",
		VAULTRELIC_PLANTER = "Too brittle to plant anything in, but a great conversation piece.",

        RAINCOAT = "A waterproof coat to keep you dry.",
        RAINHAT = "Soft to the touch, slick to the rain.",
        GRASS_UMBRELLA = "Posh & portable protection.",

        SPEAR_WATHGRITHR = "The gold makes it sharper.",
        WATHGRITHRHAT = "The unicorn is what protects you.",

        MOLEHAT = "Grants the wearer Smell-E-Vision.",
        ICEHAT = "Science, on the rocks.",
        TRANSISTOR = "Science away! Bzzzt!",

        WATERMELONHAT = "Refreshing, but sticky.",

        EYEBRELLAHAT = "An eye on the sky keeps you dry.",
        FEATHERFAN = "Luxuriously soft, luxuriously large.",
        MINIFAN = "You have to run to create a breeze!",
        WHIP = "Dish out constructive feedback.",
        SADDLE_BASIC = "Lets you sit on animals. In theory.",
        SADDLE_WAR = "A throne for the boss of the battlefield.",
        SADDLE_RACE = "Offsets the time spent making it. Maybe.",

        DRAGONHEADHAT = "The front end of a beast costume.",
        DRAGONBODYHAT = "The middle bit of a beast costume.",
        DRAGONTAILHAT = "The caboose of a beast costume.",
        PERDSHRINE = "Make offerings to the majestic Gobbler.",
        YOTR_RABBITSHRINE = "Make offerings to the cozy Bunnyman.",
        REDLANTERN = "A fortuitous lantern to light your way.",
        FIRECRACKERS = "Celebrate with a BANG!",
        PERDFAN = "Extra lucky, extra large.",
        WARGSHRINE = "Make offerings to the earthen Varg.",
        PIGSHRINE = "Make offerings to the affluent Pig.",
        HOUNDWHISTLE = "Blow the whistle on wild hounds.",
        CHESSPIECE_CLAYHOUND_SKETCH = "A sculpture sketch of the Clay Hound.",
        CHESSPIECE_CLAYWARG_SKETCH = "A sculpture sketch of the Clay Varg.",
		YOTP_FOOD1 = "A roasted tribute to the Pig King.", -- tribute roast
		YOTP_FOOD2 = "What's hiding in there?", -- mud pie
		YOTP_FOOD3 = "Prosperity on a stick.", -- fish head skewers

        SCULPTINGTABLE = "Marble will be like clay in your hands!",

        BELL = "This isn't just any bell.",

        CATCOONHAT = "For those who value warmth over friends.",
        GOGGLESHAT = "Decorative goggles you can oggle.",
        DESERTHAT = "Keeps the sand out of your eyes.",
        ANTLIONHAT = "Shake things up by getting rid of old turf.",

        FEATHERPENCIL = "Yes, the feather IS necessary.",
        COOKBOOK = "Review your repertoire of recipes.",
        MAPSCROLL = "Show everyone what you've seen!",

        REVIVER = "Ghastly revival of a ghostly friend.",
        ABIGAIL_FLOWER = "A magical keepsake.",

        BEARGER_FUR = "Reconstituted furs.",

        BERNIE_INACTIVE = "A familiar face in this mad world.",

        WARDROBE = "Change your look to suit your mood.",

		-- Waxwell
        WAXWELLJOURNAL = "It'll blow your mind.",
		MAGICIAN_CHEST = "Imprison your belongings in a shadowy vortex.",
		TOPHAT_MAGICIAN = "Black magic goes with everything.",
        SHADOWLUMBER_BUILDER = "Holds a grudge against trees.",
        SHADOWMINER_BUILDER = "Mine that rock!",
        SHADOWDIGGER_BUILDER = "Diggy diggy hole.",
        SHADOWDUELIST_BUILDER = "Ethereal bodyguard.",

        RED_MUSHROOMHAT = "It's like eating all kinds of mushrooms.",
        GREEN_MUSHROOMHAT = "It's like eating all kinds of mushrooms.",
        BLUE_MUSHROOMHAT = "It's like eating all kinds of mushrooms.",
        MOON_MUSHROOMHAT = "It's like eating all kinds of mushrooms.",
        MUSHROOM_LIGHT2 = "Inspired by the lava lamp sciences.",
        MUSHROOM_LIGHT = "The perfect addition to any mush-Room.",
        SLEEPBOMB = "A throwable pouch full of sleep.",

        MULTIPLAYER_PORTAL_MOONROCK_CONSTR_PLANS = "The best laid plans.",
        MOONROCKIDOL = "A key figure.",

		WINTER_ORNAMENT_BOSS_HERMITHOUSE = "A keepsake for your Winter's Feast Tree.",
		WINTER_ORNAMENT_BOSS_PEARL = "A keepsake for your Winter's Feast Tree.",

		--MOON_ALTAR--
        BATHBOMB = "Flowers, for springs? Groundbreaking.",
        MOONGLASSAXE = "Fragile but effective.",
        GLASSCUTTER = "Cutting edge weaponry.",
		BATHBOMB_BLUEPRINT = "Unlock the secret of hot spring alchemy.",
		MOONGLASSAXE_BLUEPRINT = "Knowledge bestowed by the moon itself.",
		GLASSCUTTER_BLUEPRINT = "The moon will protect you.",
		TURF_METEOR_BLUEPRINT = "Learn to mold the moon's surface.",
		BUTTERFLY_SKETCH = "Let the moon send you visions of butterflies.",
		ANCHOR_SKETCH = "The moon and sea will be your inspirations.",
        MOON_SKETCH = "Look upon the face of the moon.",

        MINIFLARE = "Light the way for your trusted friends.",
        MEGAFLARE = "Light a beacon for your enemies.",

		SEAFARING_PROTOTYPER = "Science at sea.",

        CHESSPIECE_PAWN_BUILDER = "It takes a village to raise an army.",
        CHESSPIECE_ROOK_BUILDER = "Next best thing to an actual castle.",
        CHESSPIECE_KNIGHT_BUILDER = "Shining armor not included.",
        CHESSPIECE_BISHOP_BUILDER = "A chesspiece with a checkered past.",
        CHESSPIECE_MUSE_BUILDER = "The most powerful piece on the board.",
        CHESSPIECE_FORMAL_BUILDER = "Behind every queen is a dapper king.",
        CHESSPIECE_HORNUCOPIA_BUILDER = "A sculpture for a starving artist.",
        CHESSPIECE_PIPE_BUILDER = "Stick this on your wheel and sculpt it.",
        CHESSPIECE_DEERCLOPS_BUILDER = "Sculpt yourself an eyeball monster.",
        CHESSPIECE_BEARGER_BUILDER = "A stone reminder of a grizzly autumn.",
        CHESSPIECE_MOOSEGOOSE_BUILDER = "Two for the price of one.",
        CHESSPIECE_DRAGONFLY_BUILDER = "The ultimate trophy for the ultimate kill.",
        CHESSPIECE_MINOTAUR_BUILDER = "This guardian sits in stony silence.",
        CHESSPIECE_CLAYHOUND_BUILDER = "It ain't nothing but a clay hound dog.",
        CHESSPIECE_CLAYWARG_BUILDER = "Sculpt a fearsome Clay Varg.",
        CHESSPIECE_BUTTERFLY_BUILDER = "This sculpture's a moth-have.",
        CHESSPIECE_ANCHOR_BUILDER = "Ground your base with a stone anchor.",
        CHESSPIECE_MOON_BUILDER = "It's a selene figurine!",
        CHESSPIECE_CARRAT_BUILDER = "A winsome sculpture of a champion.",
        CHESSPIECE_BEEFALO_BUILDER = "A beauteous beefalo bust.",
		CHESSPIECE_KITCOON_BUILDER = "One's true wealth is measured by their friends.",
        CHESSPIECE_CATCOON_BUILDER = "A curious statue for a curious creature.",
        CHESSPIECE_MANRABBIT_BUILDER = "A fluffy friend, made of rock.",
        CHESSPIECE_MALBATROSS_BUILDER = "A sculpted scourge of the seas.",
        CHESSPIECE_CRABKING_BUILDER = "It looks even crabbier than you remember it.",
		CHESSPIECE_TOADSTOOL_BUILDER = "A toad-ally authentic reproduction of the original.",
        CHESSPIECE_STALKER_BUILDER = "A de-animated reanimated skeleton.",
        CHESSPIECE_KLAUS_BUILDER = "Klaus to perfection.",
        CHESSPIECE_BEEQUEEN_BUILDER = "More regal than real.",
        CHESSPIECE_ANTLION_BUILDER = "Ain't this Antlion beautiful?",
        CHESSPIECE_GUARDIANPHASE3_BUILDER = "Its design radiates an otherworldly strangeness.",
		CHESSPIECE_EYEOFTERROR_BUILDER = "Its stony gaze reminds you of an evil presence.",
        CHESSPIECE_TWINSOFTERROR_BUILDER = "Double the eyes, double the terror.",
        CHESSPIECE_DAYWALKER_BUILDER = "A stone likeness of a pig-headed prisoner.",
        CHESSPIECE_DAYWALKER2_BUILDER = "He sure was a scrappy fellow.",
        CHESSPIECE_DEERCLOPS_MUTATED_BUILDER = "A truly eye-catching sculpture.",
        CHESSPIECE_WARG_MUTATED_BUILDER = "A rather fetching statue.",
        CHESSPIECE_BEARGER_MUTATED_BUILDER = "A soul-bearing rendition of a ferocious favorite.",
        CHESSPIECE_YOTD_BUILDER = "A tribute to getting things off to a fiery start.",
        CHESSPIECE_SHARKBOI_BUILDER = "An homage to a cold-blooded bully.",
        CHESSPIECE_WORMBOSS_BUILDER = "Brings back memories of being digested.",
        CHESSPIECE_YOTS_BUILDER = "A reminder of a lucky worm encounter.",
        CHESSPIECE_WAGBOSS_ROBOT_BUILDER = "The automation.",
        CHESSPIECE_WAGBOSS_LUNAR_BUILDER = "The abomination.",

        CHESSPIECE_BUTTERFLY_SKETCH = "A sculpture sketch of a Moon Moth.",
        CHESSPIECE_ANCHOR_SKETCH = "A sculpture sketch of an anchor.",
        CHESSPIECE_MOON_SKETCH = "A sculpture sketch of the moon itself.",
        CHESSPIECE_CARRAT_SKETCH = "A sculpture sketch of a victorious carrat.",
        CHESSPIECE_BEEFALO_SKETCH = "A sculpture sketch of a charming beefalo.",
        CHESSPIECE_KITCOON_SKETCH = "A sculpture sketch of a kitcoon tower.",
        CHESSPIECE_CATCOON_SKETCH = "A sculpture sketch of a playful catcoon.",
        CHESSPIECE_MALBATROSS_SKETCH = "A sculpture sketch of the mighty Malbatross.",
        CHESSPIECE_CRABKING_SKETCH = "A sculpture sketch of the Crab King.",
        CHESSPIECE_MANRABBIT_SKETCH = "A sculpture sketch of a playful Bunnyman.",
        CHESSPIECE_YOTD_SKETCH = "A sculpture sketch of a Dragonfly boat race Start Tower.",
        CHESSPIECE_YOTS_SKETCH = "A sculpture sketch of a Gilded Depths Worm.",

        CRITTER_GLOMLING_BUILDER = "Befriend a bouncy Glomglom.",
        CRITTER_DRAGONLING_BUILDER = "Befriend a noble Broodling.",
        CRITTER_PERDLING_BUILDER = "Befriend a hoppy Giblet.",
        CRITTER_KITTEN_BUILDER = "Befriend a clever Kittykit.",
        CRITTER_PUPPY_BUILDER = "Befriend a loyal Vargling.",
        CRITTER_LAMB_BUILDER = "Befriend a fluffy Ewelet.",
		CRITTER_LUNARMOTHLING_BUILDER = "Befriend a delicate Mothling.",

        CANDYBAG = "Only carries Hallowed Nights goodies.",

		MADSCIENCE_LAB = "Mad science has no limits. Except sanity.",
		HALLOWEEN_EXPERIMENT_BRAVERY = "Liquid courage.",
		HALLOWEEN_EXPERIMENT_HEALTH = "Good for your heart.",
		HALLOWEEN_EXPERIMENT_SANITY = "Put your mind at ease.",
		HALLOWEEN_EXPERIMENT_VOLATILE = "Crystallized incandescence.",
		HALLOWEEN_EXPERIMENT_MOON = "There's a change brewing.",
		HALLOWEEN_EXPERIMENT_ROOT = "Spine-chilling saplings.",

		CARNIVAL_GAMETOKEN = "Buy tokens, play games, win prizes!",
		CARNIVAL_GAMETOKEN_MULTIPLE = "Why buy one when you could buy three?",
		CARNIVAL_PRIZEBOOTH_KIT = "See what prizes are in store.",
		CARNIVAL_PLAZA_KIT = "The centerpiece of every Cawnival.",

		CARNIVALGAME_FEEDCHICKS_KIT = "Let them eat grubs!",
		CARNIVALGAME_MEMORY_KIT = "Count your eggs before they hatch.",
		CARNIVALGAME_HERDING_KIT = "Whisk back runaway eggs.",
        CARNIVALGAME_SHOOTING_KIT = "Keep pests from bugging the nest.",
		CARNIVALGAME_WHEELSPIN_KIT = "Spinning and winning in equal measure.",
		CARNIVALGAME_PUCKDROP_KIT = "Bounce the ball safely to its nest.",

		CARNIVALDECOR_PLANT_KIT = "A little piece of the Cawnival.",
		CARNIVALDECOR_BANNER_KIT = "Take a shine to some bauble-strung branches.",
		CARNIVALDECOR_EGGRIDE1_KIT = "A cracking addition to your decor.",
		CARNIVALDECOR_EGGRIDE2_KIT = "Pint-sized eggcitement!",
		CARNIVALDECOR_EGGRIDE3_KIT = "Get in the swing of summer fun!",
		CARNIVALDECOR_EGGRIDE4_KIT = "The new height of Cawnival decor.",
		CARNIVALDECOR_LAMP_KIT = "A dreamy light for summer nights.",
		CARNIVALDECOR_FIGURE_KIT = "What could be inside this mysterious green box?",
		CARNIVALDECOR_FIGURE_KIT_SEASON2 = "What could be inside this mysterious gold box?",
		CARNIVALCANNON_CONFETTI_KIT = "Start things off with a bang!",
		CARNIVALCANNON_SPARKLE_KIT = "Add some sparkle to your surroundings.",
		CARNIVALCANNON_STREAMER_KIT = "Create an explosion... of fun!",

		CARNIVAL_SEEDPACKET = "A crunchy Cawnival favorite.",
		CARNIVAL_POPCORN = "Perfect for munching on while spectating.",
		CARNIVAL_BALL = "You're guaranteed to have a ball!",
		CARNIVALFOOD_CORNTEA = "Surprisingly refreshing!",

		CARNIVAL_VEST_A = "A whimsical scarf of foraged leaves.",
		CARNIVAL_VEST_B = "It's truly something to crow about.",
		CARNIVAL_VEST_C = "The customary capelet of a Cawnival-goer.",

        WINTER_TREESTAND = "Plant and decorate a Winter's Feast tree!",

		--Dishes are not final - let these be for now
		WINTERSFEASTOVEN = "It's all fired up for the holidays.",
		WINTERCOOKING_BERRYSAUCE = "Fill your belly with a bowl full of jelly.",
		WINTERCOOKING_BIBINGKA = "This dish will leaf you wanting more.",
		WINTERCOOKING_CABBAGEROLLS = "Get your holiday feast rolling.",
		WINTERCOOKING_FESTIVEFISH = "It just isn't the holidays without it.",
		WINTERCOOKING_GRAVY = "All aboard the gravy train.",
		WINTERCOOKING_LATKES = "You'll like them a latke.",
		WINTERCOOKING_LUTEFISK = "Sea-son's eatings.",
		WINTERCOOKING_MULLEDDRINK = "A hot drink for a cold winter.",
		WINTERCOOKING_PANETTONE = "Like fruitcake, but edible!",
		WINTERCOOKING_PAVLOVA = "Light and crisp as new fallen snow.",
		WINTERCOOKING_PICKLEDHERRING = "A salty seasonal supper.",
		WINTERCOOKING_POLISHCOOKIE = "Just like babcia used to make.",
		WINTERCOOKING_PUMPKINPIE = "Gourd tidings we bring.",
		WINTERCOOKING_ROASTTURKEY = "Gobble-gobble it up.",
		WINTERCOOKING_STUFFING = "Stuff your face!",
		WINTERCOOKING_SWEETPOTATO = "It's a marshmallow world in the winter.",
		WINTERCOOKING_TAMALES = "Spice up your holiday spread.",
		WINTERCOOKING_TOURTIERE = "A savory seasonal pie.",

		TABLE_WINTERS_FEAST = "Gather round for the Winter's Feast.",

		YOTC_CARRAT_RACE_START = "Off to the races!",
		YOTC_CARRAT_RACE_START_ITEM = "Off to the races!",
        YOTC_CARRAT_RACE_CHECKPOINT = "Just one stop on the road to glory.",
		YOTC_CARRAT_RACE_CHECKPOINT_ITEM = "Just one stop on the road to glory.",
		YOTC_CARRAT_RACE_FINISH = "End of the line.",
		YOTC_CARRAT_RACE_FINISH_ITEM = "End of the line.",

        --Quagmire
        QUAGMIRE_CRATE_POT_HANGER = "Everything you need to set up a cookpot.",
        QUAGMIRE_CRATE_OVEN = "Everything you need to set up an oven.",
        QUAGMIRE_CRATE_GRILL_SMALL = "Everything you need to set up a grill.",
        QUAGMIRE_CRATE_GRILL = "Everything you need to set up a large grill.",

        QUAGMIRE_HOE = "Till soil for crop seeds.",
        QUAGMIRE_SAPBUCKET = "Don't be a sap, get syrup from the tap!",
        QUAGMIRE_SPOTSPICE_GROUND = "One teaspoon of delicious spice.",
        QUAGMIRE_SALT = "A few pinches of salt.",
        QUAGMIRE_FLOUR = "Ground wheat.",
        QUAGMIRE_CRABTRAP = "Trap the crabs in the bucket.",
        QUAGMIRE_POT = "State of the art cookware.",
        QUAGMIRE_POT_HANGER_ITEM = "Hang a pot on the fire. Hands free!",
        QUAGMIRE_POT_SYRUP = "For sugary, delicious sap processing.",
        QUAGMIRE_CASSEROLEDISH = "Fine ceramics for finer food.",
        QUAGMIRE_PLATE_SILVER = "High class plating for improved dishes.",
        QUAGMIRE_BOWL_SILVER = "Presentation is half the taste.",
        QUAGMIRE_SALT_RACK_ITEM = "Get a little salty.",
        QUAGMIRE_SLAUGHTERTOOL = "Well, meat doesn't grow on trees.",
        QUAGMIRE_PIGEON = "It's a whole, live pigeon.",

        QUAGMIRE_KEY = "Open things that aren't yours.",
        QUAGMIRE_KEY_PARK = "The key to Sugarwood Memorial Park.",
        QUAGMIRE_PORTAL_KEY = "The way out. I can charge it with Favors.",

        QUAGMIRE_SEEDPACKET_1 = "Unusual crop seeds. Plant in tilled soil.",
        QUAGMIRE_SEEDPACKET_2 = "Unusual crop seeds. Plant in tilled soil.",
        QUAGMIRE_SEEDPACKET_3 = "Unusual crop seeds. Plant in tilled soil.",
        QUAGMIRE_SEEDPACKET_4 = "Unusual crop seeds. Plant in tilled soil.",
        QUAGMIRE_SEEDPACKET_5 = "Unusual crop seeds. Plant in tilled soil.",
        QUAGMIRE_SEEDPACKET_6 = "Unusual crop seeds. Plant in tilled soil.",
        QUAGMIRE_SEEDPACKET_7 = "Unusual crop seeds. Plant in tilled soil.",
        QUAGMIRE_SEEDPACKET_MIX = "Unusual crop seeds. Plant in tilled soil.",

        QUAGMIRE_GOATMILK = "Fresh from the source.",

        --v2 Winona
        WINONA_CATAPULT = "Lob big rocks at fearful foes.",
        WINONA_SPOTLIGHT = "Shine a light both day and night.",
        WINONA_BATTERY_LOW = "Someone's gotta keep the juice flowing.",
        WINONA_BATTERY_HIGH = "This one uses gems, so you know it's good.",
		--v3 Winona
		WINONA_REMOTE = "Control your creations with the push of a button.",
		WINONA_TELEBRELLA = "The best way to send anything home is by the particle.",
		WINONA_TELEPORT_PAD_ITEM = "When it comes to transporting items, this machine really delivers.",
		WINONA_STORAGE_ROBOT = "This collector belongs in your collection.",
		INSPECTACLESHAT = "Get on the same wavelength as your old boss.",
		ROSEGLASSESHAT = "Seek out Charlie by looking at things through a new lens.",

        --Wormwood
        LIVINGLOG = "Put yourself into your work.",
        ARMOR_BRAMBLE = "Nature's way of saying \"keep away\".",
        COMPOSTWRAP = "\"Herbal\" therapy.",
        TRAP_BRAMBLE = "An equal opportunity annoyer.",
        WORMWOOD_SAPLING        = "Grow out on a limb.",
        WORMWOOD_BERRYBUSH      = "It's hand-made!",
        WORMWOOD_BERRYBUSH2     = "As many berries as your arm can carry.",
        WORMWOOD_JUICYBERRYBUSH = "Arm-fresh produce.",
        WORMWOOD_REEDS          = "Knowing how to reed comes in handy.",
        WORMWOOD_LUREPLANTBULB  = "Costs an arm, but not a leg.",
        IPECACSYRUP             = "Keeps you regular.",
        WORMWOOD_CARRAT         = "Transform a plain old Carrot into a helpful Carrat!",
        WORMWOOD_LIGHTFLIER     = "Transform an ordinary Light Bulb into a loyal Bulbous Lightbug!",
        WORMWOOD_FRUITDRAGON    = "Transform a dreary Dragon Fruit into a fierce Saladmander!",

        --v2 Warly
        PORTABLECOOKPOT_ITEM = "For the gourmet on the go.",
        PORTABLEBLENDER_ITEM = "Grind ingredients into powdered spices.",
        PORTABLESPICER_ITEM = "Spicing your meals is very in season.",
        SPICEPACK = "Freshen up your foodstuffs.",
        SPICE_GARLIC = "The best offense is defensive halitosis.",
        SPICE_SUGAR = "A dash of sweetness for peace of mind.",
        SPICE_CHILI = "Spicy flakes that pack a punch.",
        SPICE_SALT = "A salty addition for a hearty meal.",

        --v2 Woodie
        WEREITEM_BEAVER = "Invokes the curse of the Werebeaver.",
        WEREITEM_GOOSE =  "Invokes the curse of the Weregoose.",
        WEREITEM_MOOSE =  "Invokes the curse of the Weremoose.",

        FISHINGNET = "Nothin' but net.",
        ANCHOR = "Boat brakes.",
        STEERINGWHEEL = "It's wheely important to have one.",
        BOAT_ITEM = "Let the seas be your domain.",
        BOAT_GRASS_ITEM = "Fun for a quick weekend getaway.",
        MAST = "Sail away, sail away.",
        ANCHOR_ITEM = "Boat brakes.", -- DEPRECATED, keeping for posterity's sake
        STEERINGWHEEL_ITEM = "It's wheely important to have one.", -- DEPRECATED, keeping for posterity's sake
        MAST_ITEM = "Sail away, sail away.", -- DEPRECATED, keeping for posterity's sake
        OAR = "Row, row, row your boat.",
        OAR_DRIFTWOOD = "Oarn't you glad I didn't say banana?",
        BOATPATCH = "It's never too late to patch things up.",
		FISH_BOX = "Keep fish as fresh as the day you net them.",
		WINCH = "Let it do the heavy lifting for you.",

        -- Wurt
        MERMHOUSE_CRAFTED = "A home fit for a Merm.",
        MERMWATCHTOWER = "True warriors live within.",
        MERMHAT = "Merm-ify your friends.",
        MERMTHRONE_CONSTRUCTION = "Usher in a new Merm Monarchy.",
        MOSQUITOMUSK = "Bring your little buddy to blend in with the bloodsuckers.",
        MOSQUITOBOMB = "Show everyone what the buzz is about.",
        MOSQUITOFERTILIZER = "Derived from all natural sources.",
        MOSQUITOMERMSALVE = "A revitalizing transfusion for iron-deficient merms.",
        OFFERING_POT = "A little kelp can go a long way.",
        OFFERING_POT_UPGRADED = "A lot of kelp goes a longer way.",
        MERM_ARMORY = "No merm should charge into battle without a well-fitting helmet.",
        MERM_ARMORY_UPGRADED = "For merms with discerning taste in combat headgear.",
        MERM_TOOLSHED = "A merm is only as good as their tools.",
        MERM_TOOLSHED_UPGRADED = "The best workmermship demands the best tools.",
        WURT_SWAMPITEM_SHADOW = "Bring home turf advantage to any fight, along with some writhing reinforcements.",
        WURT_SWAMPITEM_LUNAR = "Transform the battlefield and your fearless followers with a mind-altering, mutating bang!",

		-- Wendy
		GHOSTLYELIXIR_SLOWREGEN = "Time heals all wounds.",
		GHOSTLYELIXIR_FASTREGEN = "A potent cure for grave injuries.",
		GHOSTLYELIXIR_SHIELD = "Shield your sister from harm.",
		GHOSTLYELIXIR_ATTACK = "Call upon the power of darkness.",
		GHOSTLYELIXIR_SPEED = "Give your soul a little boo-st.",
		GHOSTLYELIXIR_RETALIATION = "Give foes a taste of their own medicine.",
        GHOSTLYELIXIR_REVIVE = "Reminds Abigail of all she can be.",
		SISTURN = "A place to rest your weary soul.",
        PETALS = "Purify your petals.",
        PETALS_EVIL = "Stain your petals.",

		-- Walter
        WALTERHAT = "Form and function over fashion.",
		SLINGSHOT = "Never go adventuring without it!",
		SLINGSHOTAMMO_ROCK = "Simple and ineffective.",
		SLINGSHOTAMMO_MARBLE = "Don't lose them, now!",
		SLINGSHOTAMMO_THULECITE = "What could go wrong?",
        SLINGSHOTAMMO_GOLD = "Their fanciness makes them work better.",
		SLINGSHOTAMMO_HONEY = "Sticky and sweet!",
        SLINGSHOTAMMO_SLOW = "What \"laws of physics\"?",
        SLINGSHOTAMMO_FREEZE = "Freeze foes in their tracks.",
		SLINGSHOTAMMO_POOP = "Disgusting and distracting.",
        SLINGSHOTAMMO_STINGER = "Stings all around!",
        SLINGSHOTAMMO_MOONGLASS = "Shatter expectations.",
		SLINGSHOTAMMO_GELBLOB = "Sticky and icky!",
        SLINGSHOTAMMO_SCRAPFEATHER = "Shockingly shocking!",
        SLINGSHOTAMMO_DREADSTONE = "Dreadfully strong.",
        SLINGSHOTAMMO_GUNPOWDER = "Explode onto the scene!",
        SLINGSHOTAMMO_LUNARPLANTHUSK = "Settle your vine-detta!",
        SLINGSHOTAMMO_PUREBRILLIANCE = "You'll be over the Moon with these.",
        SLINGSHOTAMMO_HORRORFUEL = "Reinforcements against dark forces.",
        PORTABLETENT = "Portable protection from the elements.",
        PORTABLETENT_ITEM = "Portable protection from the elements.",

		-- WANDA
		POCKETWATCH_PARTS = "It's what's inside, that counts.",
		POCKETWATCH_WEAPON = "This clock strikes YOU.",
		POCKETWATCH_DISMANTLER = "Tinker with timepieces.",
		POCKETWATCH_RECALL = "Return to a distant point in time.",
		POCKETWATCH_HEAL = "You're only as old as you feel.",
		POCKETWATCH_REVIVE = "Undo a friend's untimely end.",
		POCKETWATCH_WARP = "Retrace your last steps.",
		POCKETWATCH_PORTAL = "Time travel is better with friends.",

        -- Wigfrid
        BATTLESONG_DURABILITY = "Give weapons more time in the spotlight.",
        BATTLESONG_HEALTHGAIN = "An ode to stealing hearts.",
        BATTLESONG_SANITYGAIN = "Give your mind a little choral support.",
        BATTLESONG_SANITYAURA = "Show no fear!",
        BATTLESONG_FIRERESISTANCE = "Defend against fiery critics.",
        BATTLESONG_INSTANT_TAUNT = "Throw a verbal tomato.",
        BATTLESONG_INSTANT_PANIC = "A performance so good, it's scary.",

        TURF_MARSH = "Home is where the marsh is.",
		COOKIECUTTERHAT = "One must always be sharply dressed.",
		SALTBOX = "Salty storage for your foodstuffs.",

		TACKLESTATION = "The old bait-n-fish.",

        MAST_MALBATROSS = "Sail like a seabird into the blue.",
        MAST_MALBATROSS_ITEM = "Sail like a seabird into the blue.",
		MALBATROSS_FEATHERED_WEAVE = "A fine feathered fabric.",

		TROPHYSCALE_FISH = "Show off your prized catch.",

        YOTC_CARRATSHRINE = "Make offerings to the nimble carrat.",

        YOTC_CARRAT_GYM_DIRECTION_ITEM = "Improve your carrat's sense of direction.",
        YOTC_CARRAT_GYM_SPEED_ITEM = "Step up your carrat's speed.",
        YOTC_CARRAT_GYM_STAMINA_ITEM = "Boost your carrat's stamina.",
        YOTC_CARRAT_GYM_REACTION_ITEM = "Accelerate your carrat's reaction time.",

        YOTC_CARRAT_SCALE_ITEM = "Find out how your carrat measures up.",

		CARRAT = "Nimble, clever, and rich in beta carotene.",

		YOTC_SEEDPACKET = "A humble pack of assorted seeds.",
		YOTC_SEEDPACKET_RARE = "A pack of high quality seeds.",

		MINIBOATLANTERN = "It flickers with a warm glow.",

        YOT_CATCOONSHRINE = "Make offerings to the elusive catcoon.",
		KITCOONDEN_KIT = "A home for kitcoons of all stripes.",
        TICOON_BUILDER = "Trust them to follow the scents.",
        KITCOON_NAMETAG = "Put a name to a cute little face.",
        CATTOY_MOUSE = "Start a game of cat and mouse.",

		KITCOONDECOR1_KIT = "Feathered fun for feline friends.",
		KITCOONDECOR2_KIT = "A delightful exercise in futility.",

        YOTB_BEEFALOSHRINE = "Make offerings to the steadfast beefalo.",

        BEEFALO_GROOMER_ITEM = "The original Beefdazzler.",
        BEEFALO_GROOMER = "The original Beefdazzler.",

        TRIDENT = "Rock out in rocky waters.",

        HERMIT_BUNDLE_SHELLS = "The shells she sells.",
        WINCH_BLUEPRINT = "For deep sea grabs.",
        TURF_SHELLBEACH_BLUEPRINT = "A soft patch of sand scattered with shells.",

        CHUM = "Get chummy with the fish.",
        CHUM_BLUEPRINT = "An old family recipe.",

        MASTUPGRADE_LAMP_ITEM = "An illuminating mast attachment.",
        MASTUPGRADE_LIGHTNINGROD_ITEM = "An electrifying addition to your mast.",
        WATERPUMP = "Water, water everywhere!",

        ARCHIVE_RESONATOR_ITEM = "What secrets will it unearth?",

        REFINED_DUST = "A key ingredient for an ancient treat.",

        TURFCRAFTINGSTATION = "Change the world one piece at a time.",

        TURF_FOREST = "A chunk of forest floor.",
        TURF_GRASS = "A patch of grass.",
        TURF_SAVANNA = "A patch of Savanna grass.",
        TURF_PEBBLEBEACH = "A patch of pebbled beach.",

        TURF_CAVE = "The cold stone of a cave floor.",
        TURF_FUNGUS = "A cave floor overgrown with fungus.",
        TURF_FUNGUS_RED = "A cave floor covered in red fungus.",
        TURF_FUNGUS_GREEN = "A cave floor covered in green fungus.",

        TURF_DECIDUOUS = "A chunk of deciduous forest floor.",
        TURF_DESERTDIRT = "A dry patch of sand.",

        TURF_ROCKY = "A chunk of rocky ground.",
        TURF_UNDERROCK = "The craggy stone floor of a cave.",
        TURF_SINKHOLE = "A chunk of wet, muddy grass.",
        TURF_MUD = "A patch of muddy ground.",

        TURF_MONKEY_GROUND = "A patch of sand, with a faint scent of bananas.",
        TURF_BEARD_RUG = "Some people just like to do art.",

		-- FARMING
		FARM_PLOW_ITEM = "Plow a plot for your plants.",
		FARM_HOE = "Till soil for crop seeds.",
		GOLDEN_FARM_HOE = "Elegantly till soil for crop seeds.",
        NUTRIENTSGOGGLESHAT = "Visualize your garden's success.",
		PLANTREGISTRYHAT = "Allow your gardening expertise to grow.",

        COMPOSTINGBIN = "Make stinky rich soil.",
        SOIL_AMENDER = "Bottled nutrients from the sea.",

        WATERINGCAN = "Keep plants happy and hydrated.",
        PREMIUMWATERINGCAN = "An innovation in irrigation!",

        TROPHYSCALE_OVERSIZEDVEGGIES = "Weigh your prized fruits and veggies.",

        SEEDPOUCH = "Stow your seeds for safekeeping.",

        BEEF_BELL = "Befriend a beef friend.",

        -- YOTB
        YOTB_SEWINGMACHINE_ITEM = "Prototype the perfect beefalo outfit.",
        YOTB_STAGE_ITEM = "Bring in an expert.",
        YOTB_POST_ITEM = "Put your beefalo on center stage.",
        YOTB_PATTERN_FRAGMENT_1 = "Get some fearsome inspiration.",
        YOTB_PATTERN_FRAGMENT_2 = "Get some formal inspiration.",
        YOTB_PATTERN_FRAGMENT_3 = "Get some festive inspiration.",

        MOONSTORM_GOGGLESHAT = "Utilize potato eyes to see through storms.",
        MOON_DEVICE_CONSTRUCTION1 = "Mad science approved, never tested.",

        -- Webber
        MUTATOR_WARRIOR = "Make the sweetest little bodyguards.",
        MUTATOR_DROPPER = "The flavor might catch you by surprise.",
        MUTATOR_HIDER = "Crunchy outside, soft inside.",
        MUTATOR_SPITTER = "It's the spitting image of a spider.",
        MUTATOR_MOON = "Its recipient will be over the moon!",
        MUTATOR_HEALER = "Extra grainy, so it has to be healthy!",
        SPIDER_WHISTLE = "Call your creepy crawly friends.",
        SPIDERDEN_BEDAZZLER = "A nice home makes for a nice disposition.",
        SPIDER_REPELLENT = "Let your friends know you need some space.",
        SPIDER_HEALER_ITEM = "Gross, gooey, and good for you!",

        -- Waterlog
        MUTATOR_WATER = "They look simply mouthwatering!",
        TREEGROWTHSOLUTION = "Encourages trees to reach new heights.",

		-- Terraria
        CRITTER_EYEOFTERROR_BUILDER = "Summon a friendly ocular companion.",

		-- Cult of the Lamb
		TURF_COTL_BRICK = "Individual bricks, brought together to serve a greater purpose.",
        TURF_COTL_GOLD = "Set the groundwork for a new golden age.",
		COTL_TABERNACLE_LEVEL1 = "A shoddy carving in the form of a lamb.",
		COTL_TABERNACLE_LEVEL2 = "A refined statue to celebrate the lamb.",
		COTL_TABERNACLE_LEVEL3 = "A dazzling monument to the lamb's glory.",

        -- WOLFGANG
        MIGHTY_GYM = "Bring on the brawn!",
        DUMBBELL = "Sticks and stones make muscles honed.",
        DUMBBELL_GOLDEN = "The gold standard of weightlifting.",
        DUMBBELL_MARBLE = "A quick way to a chiseled physique.",
        DUMBBELL_GEM = "Polish every facet of your workout.",

        DUMBBELL_HEAT = "Get the ultimate warm-up.",
        DUMBBELL_REDGEM = "Feel the burn!",
        DUMBBELL_BLUEGEM = "Ice out would-be workout disturbers.",

        POTATOSACK = "A potato's natural habitat.",

        -- WX-78
        WX78_MODULEREMOVER = "Success comes to those who really a-ply themselves.",
        WX78_SCANNER_ITEM = "It never hurts to have a backup scan.",
        WX78MODULE_MAXHEALTH = "Make your robotic body a bit more robust.",
        WX78MODULE_MAXSANITY1 = "A little extra processing power helps to ease the mechanical mind.",
        WX78MODULE_MAXSANITY = "A big boost of processing power will really get those gears turning.",
        WX78MODULE_MOVESPEED = "A hastily designed speed booster. It could use some improvement.",
        WX78MODULE_MOVESPEED2 = "A perfected speed booster to kick your engine into high gear.",
        WX78MODULE_HEAT = "Things are about to get heated.",
        WX78MODULE_NIGHTVISION = "Recalibrate your optic sensors for night vision.",
        WX78MODULE_COLD = "Turn your chassis into a portable freezer.",
        WX78MODULE_TASER = "Anyone who messes with you will be in for a shock.",
        WX78MODULE_LIGHT = "Light up a room with your presence.",
        WX78MODULE_MAXHUNGER1 = "Add a bit of room to your fuel tank.",
        WX78MODULE_MAXHUNGER = "Capable of containing even the most insatiable automaton's appetite.",
        WX78MODULE_MUSIC = "Every machine needs a tune-up now and then.",
        WX78MODULE_BEE = "Get your brain and body buzzing with powerful potential!",
        WX78MODULE_MAXHEALTH2 = "Make your robotic body much more robust.",

        -- Pirates
        POLLY_ROGERSHAT = "This hat comes with a feathered friend.",
        PIRATE_FLAG_POLE = "Ape the monkey marauders with a pirate flag of your own.",
        DOCK_KIT = "Get ready for your pier review.",
        DOCK_WOODPOSTS_ITEM = "Nothing says \"structurally sound\" like adding some posts as an afterthought.",
        BOAT_ROTATOR_KIT = "Row, row, rotate your boat.",
        BOAT_MAGNET_KIT = "Your personality isn't the only thing that's magnetic.",
        BOAT_MAGNET_BEACON = "Draw in any comically oversized magnets that might be nearby.",
        BOAT_BUMPER_KELP_KIT = "Protect your boat - with kelp!",
        BOAT_BUMPER_SHELL_KIT = "Protect your boat - with shells!",
        BOAT_CANNON_KIT = "It blows the competition out of the water.",
        CANNONBALL_ROCK_ITEM = "It's sure to make a splash.",
        OCEAN_TRAWLER_KIT = "There's plenty of fish in the sea.",

        FENCE_ROTATOR = "A sword, used for fencing.",

        --
        SEWING_MANNEQUIN = "A model for all the latest equippable looks.",

        --
        NIGHTCAPHAT = "A cap for your sleepy head.",

        YOTR_FOOD1 = "No bunnies were harmed in the making of this cake.",
        YOTR_FOOD2 = "It's \"blue\" flavored!",
        YOTR_FOOD3 = "This dessert looks almost too good to eat.",
        YOTR_FOOD4 = "Puffy balls of chewy goodness.",
        YOTR_TOKEN = "Tell a Bunnyman you'd like to try your hand at a pillow battle.",
        YOTR_FIGHTRING_KIT = "A ring to bring the brawlin' bunnies.",

        HANDPILLOW_BEEFALOWOOL = "It packs a woolly wallop!",
        HANDPILLOW_KELP = "Nobody likes a wet blanket. Wet pillows aren't much better.",
        HANDPILLOW_PETALS = "A pillow packed with flower power.",
        HANDPILLOW_STEELWOOL = "For folks who take their pillow fighting seriously.",

        BODYPILLOW_BEEFALOWOOL = "Beef up your pillow defenses.",
        BODYPILLOW_KELP = "A soggy suit of pillow armor.",
        BODYPILLOW_PETALS = "It offers minimal protection, but hopefully you'll still come out smelling like a rose.",
        BODYPILLOW_STEELWOOL = "A wearable pillow that is as effective as it is unpleasant.",

        YOTR_DECOR_1_ITEM = "This lovable light makes any cave cozier.",
        YOTR_DECOR_2_ITEM = "A rabbit statue with a real fire in its belly!",

        --
        ARMORDREADSTONE = "Have no fear, the darkness will protect you.",
        DREADSTONEHAT = "A sturdy helmet of blackest stone.",

        TRANSMUTE_LOG = "Transmute Twigs into a Log.",
        TRANSMUTE_TWIGS = "Transmute a Log into Twigs.",
        TRANSMUTE_FLINT = "Transmute Rocks into Flint.",
        TRANSMUTE_ROCKS = "Transmute Flint into Rocks.",

        TRANSMUTE_BLUEGEM = "Transmute Red Gems into Blue Gems.",
        TRANSMUTE_REDGEM = "Transmute Blue Gems into Red Gems.",
        TRANSMUTE_PURPLEGEM = "Transmute Blue and Red Gems into Purple Gems.",
        TRANSMUTE_ORANGEGEM = "Transmute Purple Gems into Orange Gems.",
        TRANSMUTE_YELLOWGEM = "Transmute Orange Gems into Yellow Gems.",
        TRANSMUTE_GREENGEM = "Transmute Yellow Gems into Green Gems.",
        TRANSMUTE_OPALPRECIOUSGEM = "Transmute Many Gems into an Iridescent Gem.",

        TRANSMUTE_MEAT = "Transmute Morsels into Meat.",
        TRANSMUTE_SMALLMEAT = "Transmute Meat into Morsels.",
        TRANSMUTE_GOLDNUGGET = "Transmute Nitre into Gold Nuggets.",
        TRANSMUTE_NITRE = "Transmute Gold Nugget into a Nitre.",
        TRANSMUTE_MARBLE = "Transmute Cut Stone into Marble.",
        TRANSMUTE_CUTSTONE = "Transmute Marble into Cut Stone.",
        TRANSMUTE_MOONROCKNUGGET = "Transmute Marble into Moon Rock.",

        TRANSMUTE_POOP = "Transmute Rot into Manure.",
        TRANSMUTE_BEARDHAIR = "Transmute Beefalo Wool into Beard Hair.",
        TRANSMUTE_BEEFALOWOOL = "Transmute Beard Hair into Beefalo Wool.",
        TRANSMUTE_BONESHARD = "Transmute a Hound's Tooth into Bone Shards.",
        TRANSMUTE_HOUNDSTOOTH = "Transmute Bone Shards into a Hounds Tooth.",

        TRANSMUTE_HORRORFUEL = "Transmute Dreadstone into Pure Horror.",
        TRANSMUTE_DREADSTONE = "Transmute Pure Horror into Dreadstone.",
        TRANSMUTE_NIGHTMAREFUEL = "Transmute Pure Horror into Nightmare Fuel.",

        TRANSMUTE_PUREBRILLIANCE = "Transmute Infused Moon Shards into Pure Brilliance.",
        TRANSMUTE_MOONGLASS_CHARGED = "Transmute Pure Brilliance into Infused Moon Shards.",

        -- Rifts 1
        LUNAR_FORGE_KIT = "Forge otherworldly items.",

        ARMOR_LUNARPLANT = "Surround yourself in formidable lunar leaves.",
        LUNARPLANTHAT = "Luminescent protection for your precious cranium.",
        BOMB_LUNARPLANT = "Use unstable lunar energy for explosive results.",
        STAFF_LUNARPLANT = "Stay rooted to the spot and attack from afar.",
        SWORD_LUNARPLANT = "A sword of lunar light.",
        PICKAXE_LUNARPLANT = "Mine and demolish to your heart's content.",
        SHOVEL_LUNARPLANT = "The groundbreaking results of cross-pollination between a shovel and a garden hoe.",
		LUNARPLANT_KIT = "Fix up damaged equipment.",

        PUNCHINGBAG = "Test the strength of your weapons. And have fun!",
        PUNCHINGBAG_LUNAR = "Test how well your weapons fare against lunar foes.",
        PUNCHINGBAG_SHADOW = "Test how well your weapons fare against shadowy foes.",

        -- Rifts 2
        SHADOW_FORGE_KIT = "Create horrors for your convenience.",

        ARMOR_VOIDCLOTH = "A nightmarish cloak to keep the light at bay.",
        VOIDCLOTHHAT = "No light can pierce the darkness within this hood.",
        VOIDCLOTH_UMBRELLA = "Shadowy protection from even the harshest rainfall.",
        VOIDCLOTH_SCYTHE = "Cull the plant population with ease.",
		VOIDCLOTH_KIT = "Fix up damaged equipment.",

        -- Wolfgang, Woodie, Wormwood Skill Trees

        LEIF_IDOL = "Call upon the power of the trees.",
        WOODCARVEDHAT = "Your head will stay nice and safe (knock on wood).",
        WALKING_STICK = "Traverse your favorite nature trail with ease.",

        SUPPORT_PILLAR_SCAFFOLD = "We all need some support.",
		SUPPORT_PILLAR_DREADSTONE_SCAFFOLD = "The power of darkness holds up well under pressure.",
        WOLFGANG_WHISTLE = "Let out your inner coach!",

        -- Rifts 3

        BEARGERFUR_SACK = "A portable fridge. Cool.",
        DEERCLOPSEYEBALL_SENTRYWARD_KIT = "Take a break from sunburn with freezer burn.",
        HOUNDSTOOTH_BLOWPIPE = "Like biting, but from a distance.",

        CARPENTRY_STATION = "Quit horsing around and make some furniture.",

        WOOD_CHAIR = "A wooden chair to sit on.",
        WOOD_STOOL = "A wooden stool to sit on.",
        WOOD_TABLE_ROUND = "A round wooden table to put things on.",
        WOOD_TABLE_SQUARE = "A square wooden table to put things on.",
        DECOR_CENTERPIECE = "A centerpiece to show off your excellent taste.",
        DECOR_LAMP = "A comforting little light.",
        DECOR_FLOWERVASE = "A nice place to put all your fresh-cut flowers.",
        DECOR_PICTUREFRAME = "Frame a picture of your favorite belongings.",
        DECOR_PORTRAITFRAME = "Frame your friends, it's fun!",

        ARMORWAGPUNK = "Kick it into high gear, full steam ahead!",
        WAGPUNKHAT =   "Look smart, fight smart.",
        WAGPUNKBITS_KIT = "Your handy-dandy W.A.R.B.I.S. repair tool!",

        PHONOGRAPH = "Sit back, relax, and listen to the soundtrack of your nightmares.",
        RECORD = "Constant classics on vinyl.",

        -- Meta 3

        BATTLESONG_INSTANT_REVIVE = "Stir the hearts of your fallen comrades.",

        WATHGRITHR_IMPROVEDHAT = "A helm fit for a Valkyrie queen.",
        SPEAR_WATHGRITHR_LIGHTNING = "The power of lightning is yours to command.",

        BATTLESONG_CONTAINER = "Store all your greatest hits.",

        SADDLE_WATHGRITHR = "Warrior and steed, fighting as one!",

        WATHGRITHR_SHIELD = "A shield can be a weapon too, if it believes in itself.",

        BATTLESONG_SHADOWALIGNED = "Ward yourself and your allies against shadow attacks, and deal heavier blows to lunar foes.",
        BATTLESONG_LUNARALIGNED = "Ward yourself and your allies against lunar attacks, and deal heavier blows to shadowy foes.",

        -- Year of the Dragon
        YOTD_DRAGONSHRINE = "Make offerings to the fiery Dragonfly.",

        DRAGONBOAT_KIT = "Achieve ocean dragonhood.",
        DRAGONBOAT_PACK = "Equipped with all the draconic fixings.",


        YOTD_STEERINGWHEEL_ITEM = "Take the wheel and go for gold!",
        YOTD_OAR = "A little-known fact about Dragonflies: they're surprisingly good swimmers.",
        YOTD_ANCHOR_ITEM = "The gold standard of ship anchors.",
        MAST_YOTD_ITEM = "No Dragonflies were harmed in the making of this mast.",
        BOAT_BUMPER_YOTD_KIT = "No one will mess with a dragon that's bared its fangs.",
        BOATRACE_SEASTACK_THROWABLE_DEPLOYKIT = "One person's buoy is another's barrier.",
        MASTUPGRADE_LAMP_ITEM_YOTD = "Light your way with dragon fire.",

        BOATRACE_START_THROWABLE_DEPLOYKIT = "Ready, set, boat!",
        BOATRACE_CHECKPOINT_THROWABLE_DEPLOYKIT = "It's not the destination, it's the journey.",

        -- Rifts / Meta QoL

        HEALINGSALVE_ACID = "What doesn't kill you makes you stronger.",

        BEESWAX_SPRAY = "A petrifying preserver of plant life.",

        WALL_SCRAP_ITEM = "A pile of junk, roughly wall-shaped.",

        ARMOR_LUNARPLANT_HUSK = "Become the prickliest of them all.",

        -- Meta 4 / Ocean QoL

        BOATPATCH_KELP = "Keep your boat afloat... for a while, anyway.",
        SALTLICK_IMPROVED = "Treat your beefalo to a taste of the finer things.",

        -- Rifts 4

        SHADOW_BEEF_BELL = "Revive the one you beef friend.",
        SADDLE_SHADOW = "Grab the reins and reign over the battlefield.",
		SHADOW_BATTLEAXE =  "You'll chop 'til you drop with this maul.",
        VOIDCLOTH_BOOMERANG = "It'll keep coming back for more!",
        ROPE_BRIDGE_KIT = "Suspend your disbelief and cross that bottomless pit.",
        ARMOR_CARROTLURE = "Don this coat, and the Bunnymen shall hop to it.",
        RABBITKINGHORN = "Call on the rabbits to keep your stuff, anytime, any hare.",
        RABBITHAT = "Collecting rabbits has never been so calming.",

        STONE_CHAIR = "A stone chair to sit on.",
        STONE_STOOL = "A stone stool to sit on.",
        STONE_TABLE_ROUND = "A round stone table to put things on.",
        STONE_TABLE_SQUARE = "A square stone table to put things on.",

        BOARDS_BUNCH = "Hoard your boards.",
        CUTSTONE_BUNCH = "Stock your stone.",

        CARPENTRY_BLADE_MOONGLASS = "For when a regular blade just won't cut it.",

        GELBLOB_STORAGE_KIT = "Keep your perishables fresh in this deadly dark jelly.",

        YOTS_SNAKESHRINE = "Make offerings to the hungry Depths Worm.",
        YOTS_LANTERN_POST = "A most festive post for stringing lanterns.",
        YOTS_LANTERN_POST_ITEM = "A most festive post for stringing lanterns.",

        -- Meta 5
        GHOSTLYELIXIR_LUNAR = "Abigail will pack an outerplanar punch.",
        GHOSTLYELIXIR_SHADOW = "As if a ghost attack wasn't vexing enough.",
        WENDY_RECIPE_GRAVESTONE = "No one deserves an unmarked grave.",

		WOBY_TREAT = "Non-perishable Monster Meat biscuits made special for Woby.",
        BANDAGE_BUTTERFLYWINGS = "A bandage made from the wings of Butterflies.",
		PORTABLEFIREPIT_ITEM = "A campfire made for adventure--perfect for when you're on the go!",
        SLINGSHOTAMMO_CONTAINER = "It's both practical and tactical.",

		SLINGSHOTMODKIT = "Slingshotting is serious business.",
		SLINGSHOT_BAND_PIGSKIN = "Sling farther!",
		SLINGSHOT_BAND_TENTACLE = "Sling farther-er!",
		SLINGSHOT_FRAME_BONE = "More ammo? Yes please!",
		SLINGSHOT_FRAME_GEMS = "A little bit of this, and a little bit of that!",
		SLINGSHOT_FRAME_WAGPUNK_0 = "Ya think you're some sorta big shot now, huh?",
		SLINGSHOT_FRAME_WAGPUNK = "Embrace your ammo hoarding tendencies!",
		SLINGSHOT_HANDLE_STICKY = "Get attached to your slingshot.",
		SLINGSHOT_HANDLE_JELLY = "The stickiest grip yet!",
		SLINGSHOT_HANDLE_SILK = "Sling faster!",
		SLINGSHOT_HANDLE_VOIDCLOTH = "Sling faster-er!",

        WORTOX_REVIVER = "Soul revival of a single ghostly friend. May bring others closer.",
        WORTOX_NABBAG = "Stuff it and swing it!",
        WORTOX_SOULJAR = "Why let them be free when you can stuff them all into a jar?",
        ELIXIR_CONTAINER = "For carrying all of Abigail's snacks.",
        GHOSTFLOWERHAT = "Think like a ghost, drink like a ghost.",
        BUTTERFLY = "Help them relive their glory.",
        MOONBUTTERFLY = "Help them relive their glory.",
        WENDY_RESURRECTIONGRAVE = "Death is but an inconvenience.",
        GRAVEURN = "Transport a soul to a new location.",

        -- Rifts 5
        GEARS = "Cogs for your contraptions.",
        TWIGS = "A single twig can make all the difference.",
        CUTGRASS = "The fiberous strands bind together.",
        FLINT = "Naturally sharp and dressed for the occasion.",
        CUTREEDS = "Tubular.",
        PIGSKIN = "Thick and stretchable hide.",
        REDGEM = "Retains the color of red.",
        BLUEGEM = "Bears the color of blue.",
        MOONGLASS = "A fragment from the Moon.",

        WANDERINGTRADERSHOP_LIVINGLOG = "Life wood be a scream...", --NOTE (Omar): regular Living log recipe description doesn't work in the context of wandering trader! so here's a new one

        GESTALT_CAGE = "Combined pseudo and science for catching certain entities.",
        WAGPUNK_FLOOR_KIT = "Make the Ocean smaller! Permanently. Restrictions apply.",

        HERMITCRAB_RELOCATION_KIT = "Home is where the hermit is... relocated.",

        FLOTATIONCUSHION = "Become unsinkable. Take that, Ocean!",

        WAGBOSS_ROBOT_CONSTRUCTIONSITE_KIT = "Build first. Panic later.",
        WAGBOSS_ROBOT_CREATION_PARTS = "Piece by piece, assemble your very own war machine.",
        MOONSTORM_STATIC_CATCHER = "Catch static from every direction.",
        MOONSTORM_GOGGLESHAT_BLUEPRINT = "Not your average potato recipe.",
        MOON_DEVICE_CONSTRUCTION1_BLUEPRINT = "Meddling with forces beyond comprehension demands careful planning.",
        SECURITY_PULSE_CAGE = "Secure that Security Pulse!",

        FENCE_ELECTRIC = "A shockingly effective way to contain yourself... or others.",
        FENCE_ELECTRIC_ITEM = "A shockingly effective way to contain yourself... or others.",

		-- Halloween 2025
		PUMPKINHAT = "It's only natural to wear a pumpkin on your head after you've carved a face into it.",

        -- Winter's Feast 2025
        SHELLWEAVER = "Make something with a pinch of salt.",
        MESSAGEBOTTLEEMPTY = "Not just made by hermits!",
        ICESTAFF2 = "Knock'em out cold!",
        ICESTAFF3 = "Put'em on ice!",
        NONSLIPGRIT = "For when you can't afford to slip up.",
        NONSLIPGRITBOOSTED = "Re-tread your trail for extra traction.",
        DESICCANT = "It's important to keep drying!",
        DESICCANTBOOSTED = "It absorbs moisture so you don't have to!",
        HERMITCRAB_SHELL = "Last one to Pearl's is a rotten fish egg!",
        SALTY_DOGHAT = "A hat for an old salt that comes with a salty companion.",

        HERMITCRAB_TEASHOP = "There's nothing a cup of Pearl's tea can't fix.",
        HERMITCRABTEA_PETALS = "A brew to bring a mind back from the brink.",
        HERMITCRABTEA_PETALS_EVIL = "Sip for a gentle slip into madness.",
        HERMITCRABTEA_FOLIAGE = "Fortify your faculties against mind-cracking creatures.",
        HERMITCRABTEA_SUCCULENT_PICKED = "Drink this if you wanna be cool.",
        HERMITCRABTEA_MOON_TREE_BLOSSOM = "Blend in with the lunar locals.",
        HERMITCRABTEA_FIRENETTLES = "It'll put some fire in your belly, or at least warm you up.",
        HERMITCRABTEA_TILLWEED = "It even tastes healthy! Yum!",
        HERMITCRABTEA_FORGETMELOTS = "A strong brew to refresh your fractured mind.",

		HERMITHOTSPRING_CONSTR = "Drop in for a soak at Pearl's coastal retreat.",
		MEATRACK_HERMIT_MULTI = "Pearl's personal drying rack has room to spare!",
		HERMITHOUSE_ORNAMENT = "Give Pearl's Place a splash of whimsy with some oceanside adornments.",
		HERMIT_CHAIR_ROCKING = "Have a seat, you'll be drifting away in no time.",

        HERMITCRAB_LIGHTPOST = "Set the mood for a seaside sanctuary!",
    },

    -- MAXWELL_TEST = {"Say pal, you don't look so good.", "You better find something to eat before night comes!"},

	COOKINGRECIPECARD_DESC =
	{
		BASE = "{name}:\n{ingredients}.",
		INGREDIENTS_FIRST = "{num}x {ing}",
		INGREDIENTS_MORE = ", {num}x {ing}",
	},

    -- MAXWELL_QUEST_SURVIVE = {
    --  {"Say pal, you don't look so good.", "You better find something to eat before night comes!"},
    --  {"Say pal, you don't look so good.", "You have some space to explore methinks."},
    --  {"This may take some time...", "Don't get lost now!"},
    --  {"The dew has fallen with a particularly sickening thud this morning...", "I'm off to find Zem..."},
    --  {"Lucky nothing uses water eh?", "Its going to be a long day"},
    --  {"Don't forget your booties cause its cold out there!", "Its cold out there every day."},
    --  {"Safe and secure area?", "Its just a skip, hop and a jump away from here."},
    --  {"Say pal, keep your chin up.", "You will probably find it hard to stay dapper."},
    --  {"I left you a little something...","I don't think it will help you though.", "You know what I like about nighttime?", "All the spiders."},
    --  },

    MAXWELL_SANDBOXINTROS =
    {
        ONE = "Say pal, you don't look so good.",
        TWO = "You'd better find something to eat before night comes!",
    },

    MAXWELL_ADVENTUREINTROS =
    {
        LEVEL_1 =
        {
            ONE = "Oh, you found my portal did you?",
            TWO = "You'd think you would have learned your lesson by now.",
            --THREE = "Strange machinery hasn't exactly been kind to you in the past.",
            THREE = "Hmm. Let's try something a little more challenging, shall we?",
            --FIVE = "Let's see if you're as enthusiastic when it's fourty below.",
        },
        LEVEL_2 =
        {
            ONE = "Well would you look at that, you survived.",
            TWO = "One down, four to go!",
            --TWO = "Now don't get a big head, you aren't the first.",
            --THREE = "Let's see what you're really made of.",
            --FOUR = "And by that I mean to say,",
            --FIVE = "I will enjoy inspecting your entrails once the Deerclops is done with you.",
        },
        LEVEL_3 =
        {
            ONE = "What? You're still here?",
            TWO = "Impressive. But you should probably stop while you're ahead.",
            --TWO = "Must I do everything myself?",
            --THREE = "HOUNDS! DISPOSE OF THIS PEST!",
        },
        LEVEL_4 =
        {
            ONE = "Say, pal.",
            TWO = "You're really pushing your luck.",
            THREE = "Turn back now, or I may have to resort to drastic measures.",
        },
        TWOLANDS =
        {
            ONE = "Say, pal.",
            TWO = "Let's make a deal. You can stay here. Settle down, even.",
            THREE = "I'll give you food, gold, pigs, whatever you need.",
            FOUR = "All I want in return is a truce.",
        },
        LEVEL_5 =
        {
            ONE = "You insolent, pitiful, insignificant ant!",
            TWO = "Do not arouse the wrath of the Great Maxwell!",
            THREE = "You will regret coming any further...",
        },
        LEVEL_6 =
        {
            ONE = "Well, this is it.",
            TWO = "You found me. Now, what are you going to do?",
            TELEPORTFAIL = "Don't you think I've tried that?",
            TELEPORTFAIL2 = "This is the end of the line. We have no escape.",
            COMBATFAIL =
            {
                "Where would be the sport in that?",
                "Who do you think allowed you to make that?",
            },
            CONVERSATION =
            {
                "Is this what you were expecting?",
                "Forgive me if I don't get up.",
                "You've been an interesting plaything, but I've grown tired of this game.",
                "Or maybe They've grown tired of me.",
                "Heh. Took them long enough.",
                "They'll show you terrible, beautiful things.",
                "It will change you, like it did me.",
                "It's best not to fight it.",
                "There wasn't much here when I showed up.",
                "Just dust. And the void. And Them.",
                "I've learned so much since then. I've built so much.",
                "But even a King is bound to the board.",
                "You can't change the rules of the game.",
                "I don't know what they want. They... they just watch.",
                "Unless you get too close. Then...",
                "Well, there's a reason I stay so dapper.",
                "What year is it out there? Time moves differently here.",
                "Go on, stay a while. Keep us company.",
                "Or put the key in the box. It's your decision.",
                "Either way, you're just delaying the inevitable.",
                "Reality is like that, sometimes.",
                "I think I've said enough.",
                "..."
            }
        },
    },

    MAXWELL_ADVENTURE_HEAD =
    {
        LEVEL_4 =
        {
            ONE = "Fine. Just remember that you chose this.",
        },
        LEVEL_6 =
        {
            ONE = "We're not so different, you and I.",
            TWO =
            {
                ONE = "That's why I brought you here.",
                TWO = "That's why I brought all of them here.",
            },
            THREE =
            {
                ONE = "Oh, did you think you were the first?",
                TWO = "HA!",
            },
            FOUR =
            {
                ONE = "It's just that...",
                TWO = "I've become accustomed to winning.",
            },
        },
    },

    MAXWELL_ADVENTURETHRONE =
    {
        LEVEL_6 =
        {
            INTRO =
            {
                ONE = "Is this how it ends?",
            },
            HIT =
            {
                ONE = "The throne won't allow that. I've tried.",
            },
            NOUNLOCK =
            {
                ONE = "Ah, I am a fool. I had dared to hope.",
            },
            PHONOGRAPHON =
            {
                ONE = "I guess I deserve that.",
            },
            PHONOGRAPHOFF =
            {
                ONE = "Thank you. I have been listening to that song for an eternity.",
            },
        },
    },

    --ITEM DESCRIPTIONS
    DESCRIBE_NULL = "MISSING DESCRIPTION STRING",

    --NOTE: Limit to 63 strings per table! (Using net_smallbyte for NPC chatter)
    MERM_TALK_FOLLOWWILSON   = {{"Will come with you.", "Flort glut."}, {"Make Mermfolk strong!", "Blut gloppy Glurtsu!"}, {"You help Mermfolk!", "Glut Glurtsu flopt!"}, {"You okay.", "Florpy flort."}},
    MERM_TALK_HELP_TILL      = {{"Will come with you.", "Flort glut."}, {"Make Mermfolk strong!", "Blut gloppy Glurtsu!"}, {"Dig, diggy, dig!", "Grop, groppy, grop!"}, {"Work hard, florp!", "Glort blut, florp!"}},
    MERM_TALK_HELP_CHOP_WOOD = {{"Will come with you.", "Flort glut."}, {"Make Mermfolk strong!", "Blut gloppy Glurtsu!"}, {"Chop, choppy, chop!", "Grop, groppy, grop!"}, {"Work hard, florp!", "Glort blut, florp!"}},
    MERM_TALK_HELP_MINE_ROCK = {{"Will come with you.", "Flort glut."}, {"Make Mermfolk strong!", "Blut gloppy Glurtsu!"}, {"Break rock, easy!", "Wult wop, florty flort!"}, {"Work hard, florp!", "Glort blut, florp!"}},
    MERM_TALK_HELP_HAMMER    = {{"Will come with you.", "Flort glut."}, {"Make Mermfolk strong!", "Blut gloppy Glurtsu!"}, {"Smash! Smash!", "Florph! Florph!"}, {"Work hard, florp!", "Glort blut, florp!"}},
    MERM_TALK_FIND_FOOD      = {{"Will come with you.", "Flort glut."}, {"Make Mermfolk strong!", "Blut gloppy Glurtsu!"}, {"This do fine.", "Glort grolt flut."}, {"Find something tasty!", "Glurt florpy flut!"}},
    MERM_TALK_GET_HEALED     = {{"Feel good.", "Blurt Blorpy."}, {"Make Mermfolk strong!", "Blut gloppy Glurtsu!"}, {"This do fine.", "Glort grolt flut."}, {"You make feel better.", "Glut flort florp."}},
    MERM_BATTLECRY           = {{"Glorp! Go away!", "Glorp! Glorpy glup!"}, {"Destroy you!", "Wult glut!"},},
    MERM_GUARD_BATTLECRY     = {{"To battle!", "Wult flrot!"}, {"For Mermfolk!", "Flort Glurtsu flut!"}, {"ATTAAAACK!!", "GLOT FLOOOORPH!!"}, {"Defend King!", "Glurph Glurtsen!"}},
    MERM_TALK_PANICBOSS      = {{"Something coming!", "Gloppy flort!"}, {"Aaah!! Bad thing! Bad thing!", "Gloooorph!! Glurph glot! Glurph glot!"}, {"It come to destroy us!", "Flort wult Glurtsu!"}},
    MERM_TALK_PANICELECTRICITY = {{"Bad tingle! Bad tingle!", "Glurph flirks! Glurph flirks!"}},
    MERM_TALK_PANICBOSS_KING = {{"Rally to King!", "Glurtsen blut flort!"}, {"Hurry! Protect kingdom!", "Flurph flrot! Gloppy Glurtsam!"}, {"S-stay brave!!", "G-glop blut flrot!!"}},
    MERM_TALK_NEED_HEAL      = {{"Help, florp!", "Flopt, florp!"}, {"Hurt!", "Glorg!"}, {"No feel so good...", "Glorggu blurg..."}, {"Ouchie, ouchie!", "Glurk, glurk!"}},

    MERM_KING_TALK_HUNGER_STARVING = "Hungry... HUNGRY! HUNGRYYYY!!!",
    MERM_KING_TALK_HUNGER_CLOSE_STARVING = "Treachery... villainy! To let King waste away like this...",
    MERM_KING_TALK_HUNGER_VERY_HUNGRY = "What take so long? Make offerings to your King!",
    MERM_KING_TALK_HUNGER_HUNGRY = "King desires food!",
    MERM_KING_TALK_HUNGER_HUNGRISH = "King feeling a bit peckish...",
    MERM_KING_TALK_HUNGER_FULL =  "Have done well. Now go.",

    HERMITCRAB_TALK_ONSKINREQUEST = {
        LOW = {"What now?"},
        MED = {"These should better than the last ones."},
        HIGH = {"Oh! More things to try?"},
    },
	HERMITCRAB_TALK_ONPURCHASE = {
            LOW = {"Great. Now leave me alone."},
            MED = {"Pleasure doing business."},
            HIGH = {"Give me a holler if you need anything else!"},
        },
    HERMITCRAB_COMPLAIN = {
        PLANT_FLOWERS = {
            LOW = {"Useless lazy bees... not a drop of honey..."},
            MED = {"When I had my flower garden, the bees made honey all the time."},
            HIGH = {"Dearie, would you...","Help me plant some flowers?"},
        },
        REMOVE_JUNK = {
            LOW = {"(Grumble)... water's all full of junk..."},
            MED = {"The water's so full of junk, I can't even see the fish!"},
            HIGH = {"You look spry! Could you get rid of that junk in the water?"},
        },
        PLANT_BERRIES = {
            LOW = {"All of my berry bushes died."},
            MED = {"I miss my garden... I used to grow berries..."},
            HIGH = {"Care to help me with some gardening?","I need some new berry bushes."},
        },
        FILL_MEATRACKS = {
            LOW = {"Hmph... never any meat around here for drying..."},
            MED = {"My drying racks are empty again?","So much work for these old claws..."},
            HIGH = {"Could you dry some meat for me, dearie?"},
        },
        GIVE_HEAVY_FISH = {
            LOW = {"(Grumble)... only ever catch minnows...","Never a nice big fish..."},
            MED = {"If only SOMEONE could bring me some big, juicy fish..."},
            HIGH = {"If you could bring me some big fish...","I'd be so happy!"},
        },
        REMOVE_LUREPLANT = {
            LOW = {"That horrible plant...","Such an eyesore..."},
            MED = {"That lureplant is going to take over my whole yard!"},
            HIGH = {"Would you be a dear?","Take care of that awful plant for me."},
        },
        GIVE_UMBRELLA = {
            LOW = {"Miserable rain...","I'll catch my death..."},
            MED = {"I'm getting soaked to the chitin!","If only I had an umbrella..."},
            HIGH = {"What terrible weather.","Do you have an umbrella, dearie?"},
        },
        GIVE_PUFFY_VEST = {
            LOW = {"(Grumble) It's freezing out here!"},
            MED = {"Brrr, this cold weather is terrible for my rheumatism."},
            HIGH = {"Ooooh, I do wish I had something warm to wear."},
        },
        GIVE_FLOWER_SALAD = {
            LOW = {"Hmph. No ingredients for flower salad around..."},
            MED = {"My sweetie used to make my favorite... flower salad..."},
            HIGH = {"Flower salad brings back such memories...","Could you make some for me?"},
        },
        GIVE_FISH_WINTER = {
            LOW = {"Hmph. Should be Ice Bream season right about now."},
            MED = {"I used to catch Ice Bream all through the winter..."},
            HIGH = {"Dearie, could you catch an Ice Bream for me?"},
        },
        GIVE_FISH_SUMMER = {
            LOW = {"The Scorching Sunfish should be migrating now."},
            MED = {"Nothing says summer like some Scorching Sunfish..."},
            HIGH = {"I would love a Scorching Sunfish, if you have it."},
        },
        GIVE_FISH_SPRING = {
            LOW = {"Thought I saw some Bloomfin Tuna yesterday..."},
            MED = {"This weather is perfect for Bloomfin Tuna..."},
            HIGH = {"Let me know if you catch a Bloomfin Tuna, dearie!"},
        },
        GIVE_FISH_AUTUM = {
            LOW = {"I think Fallounders are in season."},
            MED = {"Nothing says autumn like some tasty Fallounder..."},
            HIGH = {"Would you bring me a Fallounder, dearie?"},
        },
        MAKE_CHAIR = {
            LOW = {"(Grumble) my shell is killing me...","Nowhere to sit around here..."},
            MED = {"There's nowhere to sit and rest this old chitin..."},
            HIGH = {"What this place really needs is a nice place to sit and chat."},
        },
    },

    HERMITCRAB_INVESTIGATE = {
            PLANT_FLOWERS = {
                LOW = {"Huh? What are you doing?"},
                MED = {"Hm... those look nice."},
                HIGH = {"How pretty!"},
            },
            PLANT_BERRIES = {
                LOW = {"Well. At least you're doing something useful."},
                MED = {"Maybe another one over there?"},
                HIGH = {"You are quite the gardener, dearie!"},
            },
            FILL_MEATRACKS = {
                LOW = {"You don't want it anymore? Has it gone off?"},
                MED = {"I'll never say no to free meat!"},
                HIGH = {"Hoo-hoo! That's some tasty jerky in the making!"},
            },
            REMOVE_LUREPLANT = {
                LOW = {"Fantastic. My old pest was removed by my new pest."},
                MED = {"Well, glad that's taken care of."},
                HIGH = {"You really showed that awful plant!"},
            },
            MAKE_UNCOMFORTABLE_CHAIR = {
                LOW = {"You expect me to sit on that rickety thing?"},
                MED = {"Is that a chair, or an art project gone wrong?"},
                HIGH = {"Oh. Well... I can tell you worked hard on it, dearie!"},
            },
            GIVE_CARPENTRY_BLUEPRINT = {
                LOW = {"Here. Learn how to build a proper chair."},
                MED = {"I give you credit for trying, but next time get it right."},
                HIGH = {"Here, let me give you a few pointers."},
            },
            CARPENTRY_BLUEPRINT_ONGROUND = {
                LOW = {"Hmph. Leaving my blueprint lying around like that...","Ungrateful whipper-snappers!"},
                MED = {"If I'd known it would get tossed on the ground,","I wouldn't have bothered giving up that blueprint!"},
                HIGH = {"Isn't that my blueprint over there?"},
            },
            CARPENTRY_BLUEPRINT_ININVENTORY = {
                LOW = {"Leave me alone, I already gave away my blueprint!"},
                MED = {"Still haven't gotten around to reading that blueprint, hm?"},
                HIGH = {"Have you had a chance to give that blueprint a read, dearie?"},
            },
            ALREADY_KNOWS_CARPENTRY = {
                LOW = {"I already gave you my blueprint, quit pestering me!"},
                MED = {"Didn't I already give you my blueprint?","Trying to take advantage of a sweet old lady, are you?"},
                HIGH = {"You already know everything I can teach you, dearie."},
            },
            MAKE_CHAIR = {
                LOW = {"Hmph. Well, at least it looks like it won't fall apart."},
                MED = {"I didn't take you for a carpenter, much less a half-competent one!"},
                HIGH = {"It's lovely, dearie! The perfect place to rest my aching shell."},
            },
    },

    HERMITCRAB_GREETING = {
        [0] = {"Go away!", "Shoo!", "Leave me alone!", "No trespassing!","Get off my beach!"},
        [1] = {"Hmph.", "Go find someone else to bother!"},
        [2] = {"What are you doing here?", "What do you want?"},
        [3] = {"You're back?", "Don't you have anything better to do?", "Troublesome whipper-snapper..."},
        [4] = {{"You're persistent","I'll give you that."}, "Hmph. Just don't make a nuisance of yourself."},
        [5] = {"Just can't get enough of my sparkling personality, hmm?", {"Well, if it isn't... hm...","What was your name?"}},
        [6] = {"Why are you helping me?"},
        [7] = {"It's been hard taking care of this old place by myself.", "I think I forgot how nice it is to have visitors.", "I've been awfully hard on you, haven't I?"},
        [8] = {"Hello again!", "Well, if it isn't %s!"},
        [9] = {"It's so nice to see you, dearie!", {"This world is so full of dangers...","You be careful out there, alright?"}},
        [10] ={"How have you been, dearie?", "If it isn't my favorite visitor!", "Are you eating enough?"},
    },

    HERMITCRAB_DEFAULT_REWARD = {
                LOW = {"I guess you want something for helping me out?","Fine."},
                MED = {"I guess it's not so bad having you around."},
                HIGH = {"Such a big help! Thank you."},
            },
    HERMITCRAB_GROUP_REWARD = {
                LOW = {"I don't know what you're playing at","but don't think I owe you now!"},
                MED = {"You've been busy! I suppose I should repay you."},
                HIGH = {"You've done such a wonderful job!","Here, it's the least I can do."},
            },

    HERMITCRAB_INTRODUCE = {"You've done so much for me.","Please, call me Pearl."},

    HERMITCRAB_REWARD = {
            FIX_HOUSE_1 = {
                LOW = {"Oh good, you didn't completely ruin my house."},
                MED = {"I'd been meaning to fix the place up for a while..."},
                HIGH = {"My goodness, it looks good as new!"},
            },
            FIX_HOUSE_2 = {
                LOW = {"...I suppose that is an improvement."},
                MED = {"You... did this for me...?"},
                HIGH = {"Oh dearie, I love what you've done with the place!"},
            },
            FIX_HOUSE_3 = {
                LOW = {"Oh. That does look a bit better."},
                MED = {"I barely recognize the place!","Oh don't look worried, that's a good thing."},
                HIGH = {"Oh, it's wonderful!","I feel like a Queen in her palace","Hoo-hoo!"},
            },
            PLANT_FLOWERS = {
                LOW = {"Well, at least my bees are happy now."},
                MED = {"My bees are buzzing with excitement!"},
                HIGH = {"My bees haven't looked this happy in years!"},
            },
            REMOVE_JUNK = {
                LOW = {"Hmph. Took you long enough."},
                MED = {"Should be easier to fish with all that junk gone!"},
                HIGH = {"Ahhh...","It's such a weight off my mind to have that junk gone."},
            },
            PLANT_BERRIES = {
                LOW = {"You could've planted them in neater rows...","But I guess it'll do."},
                MED = {"I can't remember the last time I had fresh berries!"},
                HIGH = {"Ooooh, such a thoughtful young whipper-snapper!","Let me pinch your cheeks!"},
            },
            FILL_MEATRACKS = {
                LOW = {"Let me guess, you want something in return? Fine..."},
                MED = {"Thanks... but don't think this means we're friends!"},
                HIGH = {"I hope it wasn't too much trouble..."},
            },
            GIVE_HEAVY_FISH = {
                LOW = {"Why are you giving me this?","Wait, I never said I wouldn't take it!"},
                MED = {"Ooooh, that's a hefty pile of fish!"},
                HIGH = {"Hoo-hoo!","That's some pretty impressive fish, dearie!"},
            },
            REMOVE_LUREPLANT = {
                LOW = {"You think you deserve a reward or something?","Hmph."},
                MED = {"Guess you're at least a half decent weed killer."},
                HIGH = {"What a relief!","That plant's been side-eying me for some time."},
            },
            GIVE_UMBRELLA = {
                LOW = {"I guess this will do."},
                MED = {"Why are you being so nice to me?"},
                HIGH = {"What would I do without you, dearie?"},
            },
            GIVE_PUFFY_VEST = {
                LOW = {"Hmph. At least I won't freeze to death."},
                MED = {"That's... very nice of you."},
                HIGH = {"Oh dearie, you're so thoughtful!"},
            },
            GIVE_FLOWER_SALAD = {
                LOW = {"..."},
                MED = {"...Thank you. It's been a long time."},
                HIGH = {"Thank you dearie...","Have you seen any other crabs on your travels?"},
            },
            GIVE_FLOWER_SALAD_POST_RELOCATION = { "Thank you dearie, I used to love this flower salad."},
            GIVE_FISH_WINTER = {
                LOW = {"Hmph. You could've caught it faster if you used this."},
                MED = {"Oh... thanks. Here, take this for your trouble."},
                HIGH = {"Thank you dearie! Here, why don't you take one of these."},
            },
            GIVE_FISH_SUMMER = {
                LOW = {"Hmph. You could've caught it faster if you used this."},
                MED = {"Oh... thanks. Here, take this for your trouble."},
                HIGH = {"Thank you dearie! Here, why don't you take one of these."},
            },
            GIVE_FISH_SPRING = {
                LOW = {"Hmph. You could've caught it faster if you used this."},
                MED = {"Oh... thanks. Here, take this for your trouble."},
                HIGH = {"Thank you dearie! Here, why don't you take one of these."},
            },
            GIVE_FISH_AUTUM = {
                LOW = {"Hmph. You could've caught it faster if you used this."},
                MED = {"Oh... thanks. Here, take this for your trouble."},
                HIGH = {"Thank you dearie! Here, why don't you take one of these."},
            },
            MAKE_CHAIR = {
                LOW = {"Hmph. Well, at least it looks like it won't fall apart."},
                MED = {"I didn't take you for a carpenter, much less a half-competent one!"},
                HIGH = {"It's lovely, dearie! The perfect place to rest my aching shell."},
            },
    },

    HERMITCRAB_STORE_UNLOCK_1 = {"So do you want to trade?","Or are you just wasting my time?"},
    HERMITCRAB_STORE_UNLOCK_2 = {"I miiight have some lures to trade...","if you can afford them."},
    HERMITCRAB_STORE_UNLOCK_3 = {"Alright, you've twisted my claw."," I'll show you my GOOD lures."},
    HERMITCRAB_STORE_UNLOCK_4 = {"I've got some new things to trade,","but they don't come cheap!"},
    HERMITCRAB_STORE_UNLOCK_5 = {"This old shell must be going soft...","I put something special in the shop."},

    HERMITCRAB_PLANTED_LUREPLANT_DIED = {
                LOW = {"Nice try.\nYou don't get anything for cleaning up your own messes."},
                MED = {"Do you want a reward that bad?"},
                HIGH = {"Dearie, I know you planted that.\nYou don't need to impress me."},
            },

    HERMITCRAB_GO_HOME = {"Time to rest this old chitin."},
    HERMITCRAB_PANIC = {"I can't see a darn thing!"},
    HERMITCRAB_PANICHAUNT = {"You're not taking me yet, spirits!"},
    HERMITCRAB_PANICFIRE = {"Aaah! I will NOT be broiled!"},
    HERMITCRAB_FIGHT = {{"You louse!","Bullying a sweet, innocent old lady like myself!"}},
    HERMITCRAB_ATTEMPT_TRADE = {
        LOW = {"Don't talk to me if you have nothing to trade.",},
        MED = {"Have anything to trade today?",},
        HIGH = {"My favorite customer!","What do you need today, dearie?",},
    },
    HERMITCRAB_GETFISH_BIG = {"Now that's a proper-sized fish!"},

    HERMITCRAB_REFUSE_SMALL_FISH = {
		"You think {weight} is impressive?\nWhat is that, a minnow?",
		"Wow, {weight}...\nI've never caught a fish this small.",
		"Only {weight}?\nYou should have put it back.",
		},
    HERMITCRAB_REFUSE_SALAD = {"I don't want that right now...","it makes me too sad..."},
    HERMITCRAB_REFUSE_ICE_HOT = {"Don't be silly, it's already freezing out here!"},
    HERMITCRAB_REFUSE_ICE_HAD = {"I don't need any more ice."},
    HERMITCRAB_REFUSE_UMBRELLA = {"It's not even raining..."},
    HERMITCRAB_REFUSE_UMBRELLA_HASONE = {"My own umbrella will do just fine, thank you."},
    HERMITCRAB_REFUSE_COAT = {"You keep it, I'm not chilly."},
    HERMITCRAB_REFUSE_COAT_HASONE = {"I like the coat I have, thank you very much."},
    HERMITCRAB_REFUSE_VEST = {"I'd boil if I wore that in this heat!"},
    HERMITCRAB_REFUSE_MAPSCROLL = {"I don't need that, my house is here!"},

    HERMITCRAB_ANNOUNCE_ROYALTY = {
        "Well, don't you look all high and mighty.",
        "I didn't realize I was in the presence of \"royalty\".",
        "It takes more than a hoity-toity hat to impress me.",
    },

    HERMITCRAB_ANNOUNCE_OCEANFISHING_LINESNAP = {
        "Ack! Stupid thing!",
    },
    HERMITCRAB_ANNOUNCE_OCEANFISHING_IDLE_QUOTE = {
        "Hmph. The fish aren't biting today...",
        "Don't be so fussy, get on my hook!",
        "\"I often look from the highest hill, that I might see my boatman...\"",
        "Hmm-de-dmm...",
        "Never seem to catch anything...",
    },

    HERMITCRAB_ANNOUNCE_OCEANFISHING_LINETOOLOOSE = {"Oooh, these tired old claws!",},
    HERMITCRAB_ANNOUNCE_OCEANFISHING_BADCAST = {"I'm not quite as good at this as I used to be...",},
    HERMITCRAB_ANNOUNCE_OCEANFISHING_GOTAWAY = {"Why you slippery little nincompoop!","Get back on my hook!"},
    HERMITCRAB_ANNOUNCE_OCEANFISHING_BOTHERED = {
        LOW = {"Ack! You made me lose my fish!"},
        MED = {"You couldn't wait for a better time?"},
        HIGH = {"I can always make time for you, dearie."},
    },

    HERMITCRAB_ANNOUNCE_ADDED_RELOCATION_KIT = {
        LOW = {"Hmph! You tricked me! This island is the worst!", "You'd better fix this...", "...or you're no better than that junk collector!", "I've got something you can use - if you actually plan on helping me."},
        MED = {"Ack! That map was no good.", "Maybe that junk collector tricked you too.", "I need a better place to live.", "I have something you can use to help me."},
        HIGH = {"Oh dear, that junk collector tricked us with a bad map.", "Please help me find a better home?", "I've got a little something that might help you help me!"},
    },

    HERMITCRAB_LEVEL10_PLAYERGOOD = {
        "Glad to see you looking well, dearie."
    },

    HERMITCRAB_LEVEL10_LOWHEALTH = {
        {"Goodness, what happened to you?","You need to be more careful!"},
    },
    HERMITCRAB_LEVEL10_LOWSANITY = {
        {"You look like something's troubling you.","Is everything alright, dearie?"},
    },
    HERMITCRAB_LEVEL10_LOWHUNGER = {
        {"Hmph... you look skinny.","Have you been eating well?"},
    },
    HERMITCRAB_THROWBOTTLE = {
        LOW = {"You've been snatching up my bottles!","Now I need to send out twice as many!"},
        MED = {"I suppose I'm glad they reached anyone, really."},
        HIGH = {"Maybe this will be the one to reach him..."},
    },
    HERMITCRAB_THROWBOTTLE_POST_RELOCATION = { "I hope you find this on your travels and come back for a visit, dearie!"},
    HERMITCRAB_HARVESTMEAT = {
        LOW = {"Hmph... looks pretty stringy."},
        MED = {"Hm... doesn't look too bad."},
        HIGH = {"Oooh, I do love some tasty dried meats!"},
    },
    HERMITCRAB_MOON_FISSURE_VENT = {
        LOW = {"Took me forever to plug up those darn fissures...", "Don't go messing with those!"},
        MED = {"Not the best lawn ornaments, but they keep the head clear.",},
        HIGH = {"I didn't notice those weird spooks until I'd settled in.","They were awful, made my shell crawl...","One of us had to go, and it wasn't going to be me!"},
    },
    HERMITCRAB_GOT_PEARL = {"Oh...","...I think I understand now.","Thank you for bringing this back to me.","I'm so glad you kept coming back.","My friend.","As a small token of my appreciation, I'd like to share my special creation with you."},
    HERMITCRAB_WANT_HOUSE = {"I could really use some help fixing up my house..."},
    HERMITCRAB_GIVE_PEARL = {"If you find my sweetie on your travels...","Could you... give him that pearl?","He'll recognize it."},
    HERMITCRAB_GOT_MAPSCROLL_BAD = {"This map is no good to me.", "It doesn't take me anywhere special."},
    HERMITCRAB_GOT_MAPSCROLL_GOOD = {"The island on this map seems nice...", "At least it's away from that junk collector.", "I would go but...","No. I'm going.","I'm done waiting for him."},

    HERMITCRAB_ANNOUNCE_SPOOKED = "Did you see that?!",
    HERMITCRAB_ANNOUNCE_TOOL_SLIP = "Wow, that tool is slippery!",

    -- Winter 2025 HermitCrab

    -- Pearl strrings when she's going to the tea shop as a player is waiting by it.
    HERMITCRAB_ANNOUNCE_GOING_TEASHOP = {
        "Hold your seahorses, dearie!",
        "I'll be there in just a minute.",
        "Patience, dearie. On my way.",
    },

    -- Pearl strings as she idly waits at the tea shop and the player is nearby.
    HERMITCRAB_TEASHOP_IDLE = {
        "Nothing beats my brew.",
        "You look thirsty, dearie!",
        "Welcome to Pearl's Tea Shop.",
        "Hello, dearie. What would you like?",
        "What's your favorite tea?",
        "Would you like some of my tea?",
    },

    -- String for pearl to say when player purchases something
    HERMITCRAB_TEASHOP_TRADE = {
        "Have a lovely day!",
        "Here you go.",
        "Enjoy, dearie!",
        "I hope you like it!",
        "Tea brewed special for you, dearie!",
    },

    -- String when player goes away and Pearl leaves teashop
    HERMITCRAB_ANNOUNCE_LEFT_TEASHOP = {
        "Tell your friends to come by, dearie!",
        "Thank you for visiting!",
        "Come back soon, dearie!",
    },

    -- String when player is hammering down tea shop
    HERMITCRAB_TEASHOP_HIT = {
        "Why are you doing that, dearie?",
        "Are you helping me move my shop?",
        "Careful, dearie!",
    },

    -- String when tea shop starts to burn.
    HERMITCRAB_TEASHOP_BURN = {
        "My shop is on fire!",
        "Oh it's a disaster!",
        "Why?!",
    },

    -- String when tea shop starts to burn. (AS A RESULT OF PLAYER ACTION)
    HERMITCRAB_TEASHOP_PLAYER_BURN = {
        "Oh, dearie! What have you done?",
        "Why would you do that, dearie?",
        "Oh no! You've burned my shop!",
    },

    -- When we're above or near max points for Pearl's area and her home, she'll be very happy! and will stop complaining about decor.
    HERMITCRAB_DECOR_PRAISES =
    {
        "My dearie! I love what you've done with my place!",
        "Thank you, dearie! It truly feels like home now!",
        "Oh my, you have such an eye for decorating!",
        "Dearie, you've done it! My place looks wonderful!",
        "I love it, my dearie! Thank you for your help!",
        "Oh dearie, it's become a real home sweet home! Thank you.",
        "You've done such a lovely job decorating my home, dearie!",
    },

    -- A unique string if you collect all trophy fish for her!
    HERMITCRAB_DECOR_ALL_TROPHY_FISH = { "How did you ever manage to catch all of them? Incredible, dearie!", "Now I have every fish, dearie! Amazing!", "My collection is complete! You're the best, dearie!", "What an astounding feat! You've caught them all, dearie!" },
    -- She'll play these lines when she's happy with the number of the respective decor you have
    HERMITCRAB_DECOR_CONTENT =
    {
        TILES = { "It's my very own beach! I love it, dearie!", "Thank you, dearie. You've brought the beach to me!", "It's perfect, dearie! My home on the beach!" },
        ORNAMENTS = { "Wonderful! I love how they dance in the wind.", "They're splendid, dearie.", "Absolutely lovely, my dearie." },
        DECORATION_TAKER = { "Thank you for the wonderful tables, dearie.","I simply adore these beautiful tables you've made for me, dearie."},
        FACED_CHAIR = { "Now I can sit down in one of these chairs, rest my legs and enjoy a cup of tea!", "Now I have chairs for when you come to visit!" },
        POTTED_PLANTS = { "These potted plants are lovely, dearie.", "I really enjoy these potted plants. Thank you, dearie." },
        DOCK_POSTS = { "The dock pilings are really great, dearie!", "I love my dock pilings, my dearie!" },
        PICKABLE_PLANTS = { "It all looks so lush!", "Dearie, you certainly have a green thumb!", "Every plant I need is at my clawtips! How thoughtful, dearie." },
        LIGHT_POSTS = { "My home is so bright and beautiful now!", "All these lights really liven the mood!", "The lights look give such a warm and cozy glow. It's perfect.", },
        MEAT_RACKS = { "I love my new drying racks!", "Thank you dearie! Now I have so much room for drying!", "I'll never run out of drying space again!", },
        FLOWERS = { "Oh dearie, I love all the flowers you've planted for me!", "My garden is full of beautiful flowers thanks to you, dearie!", "All these flowers make me so happy! Thank you, my dearie." },
        BEE_BOXES = { "Thank you for all the beeboxes, dearie!", "My bees love their new homes! Thank you, dearie!", "All these beeboxes! Now I'll have plenty of honey for my tea!" },

        WATER_TREE = { "What a wonderful tree you planted for me, dearie!", "I love my tree, dearie! It protects me from the hot sun and cold rain!", "Thank you for planting the beautiful tree for me, dearie."},
        CRITTER_PET = { "I don't much take to company, dearie... except yours and now this sweet little one's.", "Thank you for bringing me this perfect little companion, dearie."},

        HOT_SPRING = { "Now I can have a soak and rest my old shell.", "What a lovely hot spring, dearie! Come by anytime for a soak.", "Thank you for the wonderful hot spring, dearie."},
        TEA_SHOP = { "Oh, dearie! I can't wait for you to taste all my different teas!", "Finally, Pearl's Tea Shop can open for business!", "Thank you for helping me set up my tea shop, dearie."},
    },

    HERMITCRAB_CRITTER_BANTER =
    {
        "Hello, precious little one.",
        "Aren't you the cutest?",
        "You are just the sweetest little thing.",
        "Too cute!",
        "I'll take good care of you.",
        "You make me so happy!",
        "Awwww...",
    },

    HERMITCRAB_CRITTER_FEED =
    {
        "You must be hungry!",
        "Eat up now, precious.",
        "Yummy, isn't it?",
    },

    -- Her decoration system is entirely disabled within these areas
    HERMITCRAB_DECOR_COMPLAIN_AREA =
    {
        MOON_ISLAND = { "This place gives me a terrible headache!", "Those weird little spooks are all around here!", "Please help me find a new place to live, dearie.", "Oh, dearie. I really don't like it here. Help me move, please!", }
    },

    HERMITCRAB_DECOR_COMPLAIN = {
        FLOWERS = -- flowers to make her place look nice AND for her bees!
        {
            -- low = little to no flowers
            -- med = some flowers, wants more
            LOW = { "I do miss my flowers, dearie. Would you please plant some for me?", "Some flowers would make my home so much prettier. Could you plant me some, dearie?" },
            MED = { "I love the flowers you've planted, dearie. A few more would be wonderful.", "Just a few more flowers would be absolutely perfect, dearie." },
        },
        BEE_BOXES =
        {
            -- low = just her single bee box
            -- med = some more bee boxes, but a bit more would be quite nice..
            LOW = { "My bees need more homes to live in. Will you build them some, dearie?", "Dearie, I need more houses for my bees. Please help!" },
            MED = { "My bees love their houses, but a few more would be nice, dearie!", "Dearie, would you please build a few more houses for my bees?" },
        },
        TILES = -- she likes beach turfs, she wants that!
        {
            -- low = barely any tiles are to her liking
            -- med = a good chunk of tiles are to her liking
            LOW = { "Dearie, I miss the beach so much. This place is nothing like it.", "I don't feel like I belong here. I wish it was more like the beach." },
            MED = { "It's starting to feel like the beach, but perhaps needs a little more, dearie.", "Oh dearie, it needs just a little more to feel like my beach." },
        },
        FISHING_MARKERS = -- These are invisible markers that dictate where she can fish, she won't be happy when they're blocked.
        {
            -- low = a few fishing markers are blocked
            -- med = half of them are blocked
            -- high = all of them are blocked.
            LOW = { "There's more room for me to fish except for a few spots, dearie.", "Dearie, there are just a few more of my favorite fishing spots I can't reach." },
            MED = { "It's better, but I could still use more fishing spots!", "I can't get to half of my favorite fishing spots, dearie." },
            HIGH = { "Dearie, there's simply no where for me to fish!", "I have no where to fish! Please help me, my dearie!" },
        },
        TROPHY_FISH =
        {
            -- she wants some trophy fish!
            LOW = { "I would love more big fish to display!", "A few more big fish would be wonderful, dearie!" },
        },
        ORNAMENTS = -- She wants ornaments on her house
        {
            -- low = 1 slot has an ornament
            -- med = 2-3 slots has an ornament
            LOW = { "Oh I love these wind charms. Perhaps a few more?", "Dearie, these wind charms are lovely! More, please!" },
            MED = { "Just a one or two more wind charms should do it!", "We almost have enough wind charms, dearie!" },
        },
        DECORATION_TAKER = -- DECORATION_TAKER refers to tables.
        {
            -- low = no tables
            -- med = you built some tables, but still needs a bit more to be homey
            LOW = { "Dearie, could you please build me a few tables?", "I need a few tables for my home, dearie!" },
            MED = { "Thank you for the tables, but I'd love a few more.", "A few more tables would be perfect, dearie!" },
        },
        POTTED_PLANTS = -- potted ferns and succulents
        {
            -- low = no pots
            -- med = you built some pots
            LOW = { "Dearie, would you please build me some pots for my plants?", "I would love some pots for my plants, dearie!" },
            MED = { "These pots are wonderful, but I would love a few more.", "Just a few more pots for my plants would be enough, my dearie." },
        },
        DOCK_POSTS = -- dock pilings
        {
            -- low = no dock pilings
            -- med = you placed some dock pilings, more would be nice
            LOW = { "Dearie, would you please build me some dock pilings?"},
            MED = { "I love the dock pilings you built, dearie. A few more would be so nice!", "I would just love a few more dock pilings, dearie!" },
        },
        FACED_CHAIR = -- proper chairs (not the ruins chairs!)
        {
            -- low = no chairs
            -- med = you placed some chairs,
            LOW = { "There's nowhere to sit, dearie! Please help me build some chairs.", "I would love some chairs for my home, dearie." },
            MED = { "The chairs you built are lovely, dearie. A few more would be lovely.", "Could you please build me just a few more chairs, dearie?" },
        },
        PICKABLE_PLANTS = -- She wants plants! (grass, saplings, berry bushes)
        {
            -- low = little-to-none plants in her area
            -- med = you planted some more bushes and plants.
            LOW = { "We will need more plants than this, dearie.", "More plants would be lovely, dearie!" },
            MED = { "I love all these plants! Perhaps one or two more?", "It's almost perfect, dearie! Just a few more plants!" },
        },
        LIGHT_POSTS = -- She wants light posts!
        {
            -- low = little-to-none light posts in her area
            -- med = you built some light posts, but she still wants more!
            LOW = { "It's still rather dim, dearie!", "More light would be lovely, my dearie." },
            MED = { "The lights are lovely! Just one or two more should do.", "Dearie, just a little more light please!" },
        },
        MEAT_RACKS = -- She wants more meat racks!
        {
            -- low = only the current single-slot meat racks she has with her
            -- med = you built some extra meat racks for her!
            LOW = { "Dearie, would you please build me some larger drying racks?", "I would love some more drying racks, my dearie." },
            MED = { "Wonderful! Perhaps one or two more large drying racks, dearie?", "Almost, dearie! Just one or two more large drying racks!" },
        },
        SPAWNER = -- There's some spawners in our area (spider dens, pig houses), we're a hermit and don't like that!
        {
            -- low = a few spawners are around
            -- med = many spawners around
            -- high = unwanted party happening at pearls place
            LOW = { "Just a few more beastie hiding places left!", "Dearie, could you please help me get rid of just a few more nasty neighbors?" },
            MED = { "There are still a number of spots for the beasties to hide!", "I still have quite a few unfriendly neighbors. Please help, dearie!" },
            HIGH = { "Oh dearie, there are so many places here the beasties creep out from!", "The beasties come from every direction here! Please rid the area of them for me, dearie!" },
        },
        JUNK = -- There's junk in our area, complain about it
        {
            -- low = not much junk, but still bothersome
            -- med = a bit more junk.. it's messy
            -- high = hoa violation
            LOW = { "My house is almost clear of junk! Just a few more pieces to go.", "We're just about there! Would you help me clean up a bit more junk, dearie?" },
            MED = { "My place is still cluttered with some junk. Could you please help me clean up?", "My dearie, I would be so grateful for your help in clearing some junk around here." },
            HIGH = { "Dearie, my home is surrounded by junk! Please help me clear it?", "There's junk everywhere! I need your help to clear it, dearie!" },
        },

    },

    --NOTE: Limit to 63 strings per table! (Using net_smallbyte for NPC chatter)
    PIG_TALK_FOLLOWWILSON = { "YOU FRIEND", "I LOVE FRIEND", "YOU IS GOOD", "I FOLLOW!" },
    PIG_TALK_FIND_LIGHT = { "SCARY", "NO LIKE DARK", "WHERE IS SUN?", "STAY NEAR FIRE", "FIRE IS GOOD" },
    PIG_TALK_LOOKATWILSON = { "WHO ARE YOU?", "YOU NOT PIG", "YOU HAS MEAT?" },
    PIG_TALK_RUNAWAY_WILSON = { "TOO CLOSE!", "STAY AWAY!", "YOU BACK OFF!", "THAT MY SPACE." },
    PIG_TALK_FIGHT = { "I KILL NOW!", "YOU GO SMASH!", "RAAAWR!" },
    PIG_TALK_RUN_FROM_SPIDER = { "SPIDER BAD!", "NO LIKE SPIDER!", "SCARY SPIDER!" },
    PIG_TALK_HELP_CHOP_WOOD = { "KILL TREE!", "SMASH MEAN TREE!", "I PUNCH TREE!" },
    PIG_TALK_ATTEMPT_TRADE = { "WHAT YOU GOT?", "BETTER BE GOOD." },
    PIG_TALK_PANIC = { "NOOOOO!", "TOO DARK! TOO DARK!", "AAAAAAAAAH!!" },
    PIG_TALK_PANICFIRE = { "HOT HOT HOT!", "OWWWWW!", "IT BURNS!" },
    PIG_TALK_PANICELECTRICITY = { "OWWWWW!","AAAAH!","DON'T LIKE!", "ME FRIED!" },
    PIG_TALK_PANICHOUSEFIRE = { "HOUSE BURNS!", "MY STUFF!", "AAAH! FIRE!", "PANIC!" },
    PIG_TALK_PANICBOSS = { "AHHHH", "UH OH!", "ME SCARED", "BAD!", "OHHH!" },
    PIG_TALK_PANICHAUNT = { "SPOOKY!", "AAAAH!!", "A GHOST! A GHOST!" },
    PIG_TALK_FIND_MEAT = { "ME HUNGRY!", "YUM!", "I EAT FOOD!", "TIME FOR FOOD!" },
    PIG_TALK_EAT_MEAT = { "NOM NOM NOM", "YUM!" },
    PIG_TALK_GO_HOME = { "HOME TIME!", "HOME! HOME!" },
    PIG_TALK_RESCUE = { "I HELP YOU!", "OOH! OOH!", "ME HELP!" },
    PIG_TALK_GIVE_GIFT = { "YOU HAVE THIS", "FOR FRIEND" },
    PIG_TALK_GAME_GOTO = { "IT STARTING!", "THIS MY FAVORITE!", "YAY!"},
    PIG_TALK_GAME_CHEER = { "SMASH! SMASH!", "BASH!", "GO PIGS!", "RAAAWR!", "YOU STINK!", "GET GOLD!", "BASH 'EM IN HEAD!"},
    PIG_TALK_MISC_GAME_GOTO = { "IT STARTING!", "OUT OF MY WAY!", "YAY!"},
    PIG_TALK_MISC_GAME_CHEER = { "GO! GO! GO!", "SNORT!"},
    PIG_GUARD_TALK_TORCH = { "TORCH GET LOW", "MAKE TORCH BRIGHT", "MORE BURNING" },
    PIG_GUARD_TALK_FIGHT = { "FOR KING!", "DEFEND!", "SAVE KING!" },
    PIG_GUARD_TALK_GOHOME = { "MUST DEFEND!", "I PROTECT", "KING! KING!" },
    PIG_GUARD_TALK_LOOKATWILSON = { "YOU LEAVE NOW", "YOU GO AWAY", "YOU NO STAY" },
    PIG_ELITE_SMACK = { "YOU GO SMASH!", "I BASH YOU!", "STAY AWAY!", "FUN!" },
    PIG_ELITE_GOLD = { "MINE!", "MY GOLD!", "I TAKE GOLD!" },
    PIG_ELITE_SALTY = { "CHEATER!", "NO FAIR", "NOT ALLOWED DO THAT!" },
    PIG_ELITE_INTRO =
    {
        "FOR KING!",
        "GET GOLD!",
    },
    PIG_ELITE_POST_MATCH =
    {
        --[[UGLY =]] "YOU BAD AT THIS. GET BETTER", -- horrible tier
        --[[BAD =]] "TRY AGAIN SOMETIME?", -- average tier
        --[[GOOD =]] "YOU WORTHY OPPONENT", -- pretty good tier
        --[[GREAT =]] "YOU HUMBLE US", -- highest tier
        --
        --[[TOOLATE =]] "GOOD MATCH. WE GO BED NOW", -- match ends after dusk
        --[[CHEATER =]] "YOU CHEATER. WE NO LIKE CHEATERS", -- cheated during match
    },

    PIG_ELITE_FIGHTER_INTRO =
    {
        "I HELP!",
        "SMASHY! SMASHY!",
        "PUNCH TIME!",
        "WHERE I SMASH?",
    },
    PIG_ELITE_FIGHTER_OUTRO =
    {
        "PIGGY, AWAY!",
        "I PUNCHED!",
        "I GO NOW!",
        "SEE YA!",
    },
    PIG_TALK_CONTEST_OOOH = {"OOOH","WOW","IS BEAUTY"},
    PIG_TALK_CONTEST_PANIC = {"MUST CHOOSE!","CHOICE HARD!"},

	--NOTE: Limit to 63 strings per table! (Using net_smallbyte for NPC chatter)
	SHARKBOI_TALK_IDLE = {"HUH? WHAT HAPPENED?","HEY! WHATSA MATTER WITH YOU?","I FEEL LIKE A FISH OUTTA WATER...","I WAS JUST LOOKIN' FOR A QUICK BITE.","WHADAYA LOOKIN' AT?","YOU WANT A PIECE OF ME, TOUGH GUY?","YOU CRUISIN' FOR A BRUISIN?","WHADAYA WANT, CHOWDERHEAD?","WHY I OUGHTA..."},
	SHARKBOI_TALK_FIGHT = {"TOUGH GUY, EH?","YOU'LL NEVER CATCH ME, SEE.","YOUSE DON'T STAND A CHANCE.","IT'S BITIN' TIME!","YOU'RE A REAL PIECE OF WORK, BUDDY.","YOU DON'T GET NO PASS.","I'LL PUT YOUSE ON ICE!","FREEZE!","YOUSE ON THIN ICE NOW!","YOU'LL BE SLEEPIN' WITH THE FISHES!","I'M NOT GONNA LET THIS SLIDE!","ICE TO EAT YA! HEH HEH."},
	SHARKBOI_TALK_CHEER = {"PUT 'EM ON ICE!","WHACK 'EM!","GIVE 'EM THE OL' ONE-TWO!","FROSTBITE!","CHOMP! CHOMP!","CLIP 'EM!","ICE 'EM!","THEY AIN'T NO FRIEND OF OURS!","THIS IS OUR TURF!","FIN-ISH 'EM!"},
	SHARKBOI_TALK_GLOAT = {"YOUSE BEEN ICED.","SEE YOUSE IN THE NEXT LIFE.","FUHGEDDABOUDIT.","END OF THE LINE.","YOU GOT CAUGHT.","YOU'RE FIN-ISHED.","BELLY-UP.","GAVE 'EM A BURIAL AT SEA.","HOOK, LINE AND SINKER.","VICTORY TASTES GOOD.","GUTTED.","SLEEPIN' WITH THE FISHES.","YOU'RE DONE, CHUM.","WHERE YOU BELONG, BOTTOM-FEEDER.","I GOT BIGGER FISH TO FRY.","LOOKIN' A LIL' GREEN AROUND THE GILLS THERE, MAC."},
	SHARKBOI_TALK_GIVEUP = {"I BIT OFF MORE THAN I CAN CHEW.","I WAS OUTTA MY DEPTH.","UNCLE! UNCLE!","CAN'T WE WORK SOMETHIN' OUT?","YOU GOT ME BY THE GILLS.","I'M FIN-ISHED.","I FEEL S- SO COLD...","COLD-BLOODED, ACE. COLD-BLOODED.","I'M A FISH OUTTA WATER.","SPARE ME. I DIDN'T KNOW YOUSE WAS SO STRONG.","I GIVE UP, I GIVE UP. YEESH.","HOW DO YA FEEL ABOUT CATCH AND RELEASE?","ALRIGHT IT'S YOUR TURF NOW, BOSS.","OKAY, YOU CAUGHT ME FAIR AND SQUARE.","HOW'S ABOUT A TRUCE?","I CAN'T GO BACK INSIDE, LEMME WORK FOR YOU, BOSS.","MERCY, MERCY! YOU GOT ME.","OWW. YOU GOT WATER IN MY EYE. THAT REALLY HURT.","I SURRENDER, QUIT WHALE'N ON ME."},
	SHARKBOI_TALK_FOLLOWWILSON = {"SURE, SKIP!","OK, BOSS!","AY CAP'N!","TIL MY LAST BREATH!","EASY PEASY.","WHATCHA NEED, BOSS?","YOU'RE A FRIEND OF OURS.","YOU GOT IT, BOSS.","WHY SO GLUM, CHUM?","LEMME AT 'EM.","I'D NEVER EAT YOU, BOSS.","JUST SAY THE WORD, BOSS.","I GOT YOUR BACK.","YOU SAY SOMETHIN', BOSS?","BOSS IS THE BEST.","WHO WE WHACKIN' BOSS?","LOOKIN' SHARP, BOSS.","WHERE TO, SKIP?"},
    SHARKBOI_TALK_FRIENDLY = {"WOAH, WOAH! NO HARD FEELINGS, ALRIGHT?","I CAN MAKE YOUSE AN OFFER... IF YOUSE GOT THE GOODS.","LET'S COME TO AN ARRANGEMENT, IF YOU CATCH MY DRIFT.","LISTEN, MAYBE YOUSE AND ME AIN'T SO DIFFERENT.","I THINK WE COULD DO SOME BUSINESS, YOU AND ME.","HOWSABOUT YOU SCRATCH MY FIN AND I SCRATCH YOURS?","WHADAYA SAY TO A LIL' SQUID PRO QUO?","I AIN'T ONE TO REFUSE A NICE JUICY FISH. BIGGER THE BETTER.","DON'T WANT NO STINKIN' POND SCUM.","I'M ON A SEA FOOD DIET. I ONLY EATS IT IF IT'S FROM THE SEA."},
	SHARKBOI_TALK_ATTEMPT_TRADE = {"INTERESTIN', REEL INTERESTIN'.","WHAT WE GOT HERE?","LET'S SEA WHATCHA GOT.","WHATCHA FISHIN' FOR?","HOPE YOUSE AIN'T WASTIN' MY TIME.","BETTER NOT BE NO RAW DEAL.","I DON'T WANT NO BAIT N' SWITCH.","OKAY, YOU REELED ME IN. WHATCHA GOT?"},
	SHARKBOI_ACCEPT_OCEANFISH = {"NOW, THAT IS A BEAUTIFUL FISH."},
	SHARKBOI_ACCEPT_BIG_OCEANFISH = {"HOLY MACKEREL, THAT'S A BIG ONE."},
	SHARKBOI_REFUSE_NOT_OCEANFISH = {"IF IT AIN'T A FISH FROM THE OCEAN, I DON'T WANT IT."},
	SHARKBOI_REFUSE_TOO_SMALL = {"DON'T INSULT ME WITH THIS PUNY THING. GIMME A BIG ONE."},
	SHARKBOI_REFUSE_EMPTY = {"AIN'T GOT NO MORE. I'M CLEANED OUT."},

    --NOTE: Limit to 63 strings per table! (Using net_smallbyte for NPC chatter)
    RABBIT_BATTLECRY = { "HOP!", "KILL!", "DIE!" },
    RABBIT_MEAT_BATTLECRY = { "MEAT!", "UNCLEAN!", "MURDERER!", "REVENGE!", "MONSTER!" },
    RABBIT_GIVEUP = { "DONE.", "LATER." },
    RABBIT_RETREAT = { "AWAY!", "HURT!", "HOME!", "RUN!" },
    RABBIT_RESCUE = { "KILL!", "FIGHT!", "BITE!", "PUNCH!" },
    RABBIT_PANICFIRE = { "EEEH!", "OOH!", "AAAH!" },
    RABBIT_PANICELECTRICITY = { "OUCH!!", "HURT!", "STING!"},
    RABBIT_PANICHOUSEFIRE = { "HOME!", "FIRE!", "BURNING!" },
    RABBIT_PANICHAUNT = { "SCARED!", "AAAH!!", "OHH!", "GHOST!" },
    RABBIT_PANICBOSS = { "RUN!", "AHHH!", "IT MAD", "EHHH!" },

    COZY_RABBIT_PANICHIT = { "HIDE!", "FLEE!", "CRIME!", "SCATTER!"},
    COZY_RABBIT_PLANTPILLOW = {"COZY","NEST","FRIENDS"},
    COZY_RABBIT_CHEER = {"MOON!","SKY!","LIGHT!","CELEBRATE!","PARTY!","SLEEPOVER!"},
    COZY_RABBIT_QUESTION_DANGER = {"SAFE?","DANGER?","GONE?"},
    COZY_RABBIT_GREET = {"PLAY?","SNACK?","HUG?"},
    COZY_RABBIT_SPIN = {"SPIN!"},
    COZY_RABBIT_GETTOKEN = {"GAME!","SERVED!","MATCH!"},
    COZY_RABBIT_REJECTTOKEN = {"BOOKED","HAVE","BUSY"},
    COZY_RABBIT_NOARENA = {"ARENA?"},
    COZY_RABBIT_SPINGAMESTART = {"PLAY!","SPIN!","CARROT!"},
    COZY_RABBIT_YAY = {"YAY!","WOOP!"},
    COZY_RABBIT_SPOILSPORT = {"SPOILSPORT"},
    COZY_RABBIT_YUM = {"YUM!","YUMMY!"},
    COZY_RABBIT_WINNER = {"EAT!","{winner}","{winner}"},
    COZY_RABBIT_MOON = {"MOON!","SUBLIME!","GLOW!","EYE!"},
    COZY_RABBIT_ARENANOTEMPTY = {"CRAMPED!","PACKED!"},

    --NOTE: Limit to 63 strings per table! (Using net_smallbyte for NPC chatter)
    STALKER_BATTLECRY = { "Huurgh...", "...(growl)...", "...gruuuugh...", "Hrrgh...", "...grraaugh...", "...(rumble)...", "...gruh..." },
    STALKER_PLAYER_BATTLECRY = { "Huurgh...", "...gruuuugh...", "...grraaugh...", "...(gurgle)...", "...(crunch)...", "...Y-yy...", "...W-wwh..." },

	CARNIVAL_CROWKID_DECOR_AMBIENT_NONE = {"They must still be setting up.", "Where's the party?", "Most boring Midsummer Cawnival ever.", "More like Caw-no-val.", "Looks like I got here too early...", "I'm gonna tell my friends to wait until there's more set up."},
	CARNIVAL_CROWKID_DECOR_AMBIENT_SOME = {"Nicely set up.", "It's alright... but it could use some flair.", "I've seen better Cawnivals.", "The party is just getting started!"},
	CARNIVAL_CROWKID_DECOR_AMBIENT_LOTS = {"Wow! It's so festive!", "Best Cawnival ever!", "Last year's Cawnival was not this fancy.", "I wanna watch the games!", "Have you checked out the Prize Booth yet?"},
	CARNIVAL_CROWKID_DECOR_PLAYER_NONE = {"You should decorate more.", "Where are the decorations?", "It's not a Cawnival without decorations around the Tree!", "This must be your first Cawnival."},
	CARNIVAL_CROWKID_DECOR_PLAYER_SOME = {"You're doing a pretty good job.", "I wish there were more decorations around the Cawnival Tree...", "I've seen better Cawnivals. Just saying.", "Gotta say, last year's Cawnival was better..."},
	CARNIVAL_CROWKID_DECOR_PLAYER_LOTS = {"Wow! It's so festive!", "Nicely done.", "You must be good at these games.", "Have you tried Egg Scramble? It's my favorite game!", "I watched someone play Hubbub for Grub, and now I'm hungry...", "Have you won any prizes yet?"},
	CARNIVAL_CROWKID_DECOR_AMBIENT_NONE_SNACK = {"All this Cawnival fun is making me peckish.", "Those snacks look so good...\nI'm sure they wouldn't mind if I snuck a bite...", "I'm starving after that long trip."},
	CARNIVAL_CROWKID_DECOR_AMBIENT_SOME_SNACK = {"What a fun place, nobody chases us away!", "Who was that, with the red fur? He seemed kinda familiar.", "I hope we can have the Cawnival here again next year."},
	CARNIVAL_CROWKID_DECOR_AMBIENT_LOTS_SNACK = {"If I eat anymore, I'm gonna pop.\nHmm, pop... popcorn... mmmmm...", "Do you think they're trying to fatten us up and eat us?\nNaw... they don't look that clever.", "We're lucky that Corvus found this place."},
	CARNIVAL_CROWKID_DECOR_PLAYER_NONE_SNACK = {"Hey, mind sharing your snacks?", "Where are we from? Oh you know, here and there...", "You stay here all year?\nWow, not having wings must be tough."},
	CARNIVAL_CROWKID_DECOR_PLAYER_SOME_SNACK = {"So where do YOU come from? Just curious!", "I can't believe you'd never seen a Cawnival before we came!\nYou sure were missing out.", "You're pretty weird. Has anyone told you that?"},
	CARNIVAL_CROWKID_DECOR_PLAYER_LOTS_SNACK = {"It's nice to rest our wings a little.\nWe usually can't stay in one place too long.", "Have you seen the lady that watches the Cawnival at night?\nSquawck about creepy.", "Are you having fun? I sure am!"},
	CARNIVAL_CROWKID_CAMPFIRE = {"Did you hear that?\nYou don't think we were followed, do you?", "This sure is cozy.", "It's nice to warm your talons by the fire.", "There's been a mysterious murder here...\nAnd with any luck, we'll be back again next year! Cah-cah-cah!", "I wonder why the featherfree creatures are so scared of the dark?", "Does anyone have some corn?"},
	CARNIVAL_CROWKID_SCARED = {"Caaah!", "Time to take off!", "The feathers are flying!", "No thanks!", "I'm outta here!", "Scatter!!"},
	CARNIVAL_CROWKID_GAME_GOTO = {"Ooooh someone's playing!", "Let's watch the featherfree creature play!", "Look, someone's about to play!", "I love watching these games!", "Oooh, that game's my favorite!"},
	CARNIVAL_CROWKID_OTHERGAME_GOTO = {"What kind of game is that?", "Are the featherfree creatures fighting? I want to watch!"},
	CARNIVAL_CROWKID_ACCEPTGIFT = {"You're just giving this to me? Thanks!", "Wow, I didn't even have to steal it- I mean, thanks!", "They just give you stuff around here? Neat!"},
	CARNIVAL_CROWKID_REFUSEGIFT = {"Oh... wow... um, that's okay, you keep it.", "Aw, wouldn't ya know it, I'm actually allergic to that exact thing.", "No thanks, I don't want it."},
	CARNIVAL_CROWKID_HASGIFT = {"What's with all the presents? This is starting to feel suspicious...", "Thanks, but I've already got something!", "Sorry, busy. Maybe try someone else."},

	CARNIVAL_HOST_SELL_PLAZA = {"Yes, yes! The centerpiece must be set!", "The Cawnival cannot begin until the Tree is planted!"},
	CARNIVAL_HOST_ANNOUNCE_CARNIVAL = {"Yes, yes! It's that most wonderful time of year again!", "I, the great Goodfeather, have graciously decided to return with my wondrous Cawnival!", "You there! How would you like to be a part of something spectacular?!", "It is I, a merry wanderer with feathers black as night!", "I've been known by many names, but you may call me Corvus Goodfeather!", "\"Not yet mid-summer\", you say? Well my friend, the early bird gets the worm!", "Oh lucky, lucky you, to be a stop on our flight of fancy!", "Be merry, for good old Goodfeather has returned with his spectacular Cawnival!", "Last year was so profitable- er, FUN, that we just couldn't stay away!"},

	CARNIVAL_HOST_SELL_GENERIC = {"Look here, I have such wonderful games for you to play!", "A Cawnival is not complete without some fun and games.",},
	CARNIVAL_HOST_ANNOUNCE_GENERIC = {"The Cawnival is underway!", "Welcome, welcome, one and all!", "Buy your tokens here!", "Enjoy the Cawnival!", "Why not purchase a lovely miniature to set under the Tree?", "The games look fun, don't they? Why not purchase a token or twelve?", "Win tickets, trade tickets for fabulous prizes!", "Take a glance at the Prize Booth, friends! We have spectacular trinkets from far and wide!", "\"Not yet mid-summer\", you say? Well my friend, the early bird gets the worm!"},
	CARNIVAL_HOST_GAME_CHEER = {"Yes, yes! You're a natural!", "You've got a good grasp of the game, I see!", "Such an excellent performance! I do hope you purchase more tokens to show us again!"},
	CARNIVAL_HOST_GAME_BORED = {"Oh, I think you nearly scored a point that time!", "Have you never played a Cawnival game before?", "Better luck next time, perhaps?"},
	CARNIVAL_HOST_GAME_END_CHEER = {"Well done, well done! Now why don't you go peruse our Prize Booth?", "What an astonishing display! Here, let old Corvus Goodfeather give you an extra ticket."},
	CARNIVAL_HOST_GAME_END_BORED = {"Too bad. Better luck next time!", "I have plenty more tokens to sell if you'd like to try again!"},
	CARNIVAL_HOST_OTHERGAME_TALK = {"What is this game?", "What an odd game. Not nearly as fun as the ones we have at the Cawnival!", "I'm not familiar with the rules..."},

    --NOTE: Limit to 63 strings per table! (Using net_smallbyte for NPC chatter)
    STALKER_ATRIUM_BATTLECRY =
    {
        "A pity.",
        "You will not suffer.",
        "It must be this way.",
        "My world... threadbare.",
        "My city... in tatters...",
        "This will be quick.",
        "How we've fallen."
    },
    STALKER_ATRIUM_BATTLECRY_ATRIUM_REPAIRED =
    {
        "This world is unraveling.",
        "It's all happening again...",
        "I tried to stop it... it seems I learned nothing...",
    },
    STALKER_ATRIUM_PLAYER_BATTLECRY =
    {
        "You will fall as we did.",
        "This is for the best.",
        "You will be unraveled.",
        "They are coming. It cannot be stopped.",
        "This world's fabric is frayed and torn.",
        "They are unfathomable.",
        "I will save you.",
    },
    STALKER_ATRIUM_PLAYER_BATTLECRY_ATRIUM_REPAIRED =
    {
        "You fools! What have you done?",
        "You've doomed yourselves.",
        "You have brought about your own end.",
        "Please. Let me save you from what is coming.",
        "I recognize your arrogance. I possessed it myself.",
    },
    STALKER_ATRIUM_SUMMON_MINIONS =
    {
        "Be woven.",
        "How long have I slumbered?",
        "Let the fuel take shape.",
        "I will not be defeated so easily.",
        "I will make you understand.",
        "Let us end it.",
        "You will rip apart at the seams.",
    },
    STALKER_ATRIUM_SUMMON_CHANNELERS =
    {
        "I will stop this.",
        "You cannot win.",
        "Lend me your power, one last time.",
        "You cannot hurt me.",
        "Protect me.",
        "You have been betrayed.",
        "I must do this. For your sake.",
    },
    STALKER_ATRIUM_USEGATE =
    {
        "I will save us.",
        "Curse Their name!",
        "It cannot end like this.",
        "I was wrong.",
        "Return them to me!",
        "Why?",
        "Metheus...",
    },
    STALKER_ATRIUM_USEGATE_ATRIUM_REPAIRED =
    {
        "Not again... not again...",
        "They are coming.",
    },
    STALKER_ATRIUM_DECAYCRY =
    {
        "Please...",
    },
    STALKER_ATRIUM_DEATHCRY =
    {
        "Fools!",
        "Who are you?",
        "Release me, shade!",
        "You are not Them...",
        "Are you so easily deceived? Ha...",
        "You deserve this.",
        "You've made your choice.",
    },
    STALKER_ATRIUM_DEATHCRY_ATRIUM_REPAIRED =
    {
        "They will not show mercy as I have.",
        "You will understand. But it's already too late.",
        "I couldn't stop it...",
        "History will repeat itself...",
        "It will all come to pass again...",
        "You've made your choice.",
    },

    --Arena Event
    BOARLORD_ROUND1_START =					-- 10 second delay before the round 1 intro
    {
        "What have we here?",
        "Gatekeepers? Ha! Have you come to return us to the Throne?",
        "I am Battlemaster Pugna, and I protect what is mine.",
        "Warriors. Release the pigs!",
    },
    BOARLORD_ROUND1_FIGHT_BANTER =				-- banter between the 12 pit pig and 15 pit pig waves
    {
        "It's good to have a challenge once again!",
        "This should be fun.",
		"More pigs! Overwhelm them!",
        "More pigs!",
    },
    BOARLORD_ROUND2_START =						-- 15 second delay follows
    {
        "Impressive. You handled our foot soldiers with ease.",
        "But our battalions are trained to work together.",
		"Can you do the same? Crocommanders, to the ring!",
    },
    BOARLORD_ROUND2_FIGHT_BANTER =				-- banter between waves
    {
        "For the Forge!",
        "Give the Gatekeepers no quarter!",
        "Fly your banners proudly, warriors!",
    },
    BOARLORD_ROUND3_START =						-- 15 second delay until round 3 intro
    {
        "We've endured more here than you know.",
        "And as forging fires temper steel,",
        "Hardship has only made us stronger.",
        "Now, Snortoises. Attack!",
    },
    BOARLORD_ROUND4_START =						-- 15 second delay follows
    {
        "...Do you understand the forces you serve?",
        "They destroy all They touch...",
        "We were severed from the Throne, trapped in a realm of stone and fire!",
        "That is why we cannot let you win.",
    },
    BOARLORD_ROUND4_FIGHT_BANTER =				-- Banter
    {
        "End this now my warriors!",
        "We... cannot lose the Forge...",
    },
    BOARLORD_ROUND4_TRAILS_INTRO =				-- Trails intro
    {
        "Send in the Boarilla.",
    },
    BOARLORD_ROUND4_PLAYER_VICTORY =				-- Players win - This is actually round5-boarrior-locked victory
    {
        "No! How can this be?!",
        "You have defeated the mighty Boarilla!",
        "You may have won the battle, Gatekeepers... but not the war!",
    },
    BOARLORD_ROUND5_START =						-- 15 second delay
    {
        "Know this, Gatekeepers:",
        "Once you are dead, we will activate the Gateway.",
        "We'll return to the hub and destroy the Throne.",
        "We will end this, once and for all.",
    },
    BOARLORD_ROUND5_FIGHT_BANTER1 =				-- Banter: Add reinforcements (Snapper + 2 boarons)
    {
        "The Gatekeepers must not take the Forge!",
        "Drive the interlopers back!",
        "Do not hold back! Kill them!",
    },
    BOARLORD_ROUND5_FIGHT_BANTER2 =				-- Banter: spawning in whatever warriors are left (Snapper + 2 boarons + turtillus + peghook)
    {
        "Why are the Gatekeepers still not dead?!",
        "Destroy them!!",
        "We will not live in the Throne's shadow!",
    },
    BOARLORD_ROUND5_BOARRIOR_INTRO =			-- Boarrior as an add to the remaining trails
    {
        "Grand Forge Boarrior!",
        "The ring is yours! Destroy them, my champion!",
    },
    BOARLORD_ROUND5_PLAYER_VICTORY =			-- Players win - round5-boarrior-unlocked victory
    {
        "What?! My champion!?!",
        "I see. You've demonstrated your might.",
        "...But we will live to fight again!!",
    },
    BOARLORD_ROUND6_START =						-- ? second delay
    {
        "We do not fear you.",
        "But you will fear us!",
        "Fear my new champions! Fear the Rhinocebros!",
    },
    BOARLORD_ROUND6_PLAYER_VICTORY =			-- Players win
    {
        "You have won the battle,",
        "But the war rages on eternally.",
        "We are not ready to give up yet.",
    },
    BOARLORD_ROUND7_START =						-- ?? second delay until round 3 intro
    {
        "You have had many victories, Gatekeepers...",
        "...but from our dungeons comes our most brutal warrior.",
        "Behold: The Infernal Swineclops!",
    },
    BOARLORD_ROUND7_PLAYER_VICTORY =			-- Players win
    {
        "No! My Forge, felled by the Throne's lapdogs!",
        "Please. No more, Gatekeepers. We surrender.",
        "The day is yours, as is the Gateway.",
    },
    BOARLORD_PLAYERS_DEFEATED_BATTLECRY =		-- Players lost
    {
        "At last, our realm returns to glory!",
        "Warriors, rekindle the Gateway...",
        "Today we take the Throne!",
    },
	BOARLORD_PLAYERDEATH_BANTER =
	{
		"Ha!",
		"You are unworthy.",
        "You never stood a chance.",
        "Ha ha!",
        "Weak.",
        "We are stronger.",
        "Well struck!",
	},
    --unused rhinobro barks
    --[[RHINOCERBRO_ONEDOWN =
    {
        "Bro!",
        "BRO!",
        "No, BRO!",
    },
    RHINOCEBRO_REVIVING =
    {
        "Like, get back up, bro.",
        "I, like, need you bro!",
        "You, like, okay bro?",
    },
    RHINOCERBRO_WHOOP = "Bro! Bro! Bro! Bro!",
    RHINOCERBRO_DEFEAT = "Dang... bro...",
    SNAPBACK_WIN = "Hehe, SNAPPED.", --either the snapback win bark fires or the flatbrim win bark fires, never both
    FLATBRIM_WIN = "Like, FLATTENED.",]]


	-- gameplay WIP
    MERM2_TALK_GREETING = --Pipton
    {
        "Good afternoon! Care to trade?",
        "At least the sickness didn't take my moustache. Ho ho!",
        "Sammy's faculties are slipping, but you didn't hear it from me.",
        "Many of our sick disappeared into the sea. Odd, that.",
        "Shame you couldn't see the town in its glory days.",
        "I've only the finest goods for sale.",
        "This is a dreadful place for a kid to grow up in.",
    },
    MERM2_TALK_TRADE = --Pipton
    {
        "In a hurry, then?",
        "Don't tarry now, friend.",
        "I'll not waste anymore of your time.",
        "I tip my hat to you.",
        "It's been a pleasure.",
        "Gnaw smile on you.",
    },
    MERM1_TALK_GREETING = --Sammy
    {
        "Thoughts don't come to me like they used to.",
        "Who's Mumsy again? Ah, right. Nice lady.",
        "Been havin' odd cravings for fish lately. Hmf.",
        "Pip's too uptight. Always worryin' about me.",
        "Hey, trade with ol'Sammy!",
        "SEEDS! SEEDS HERE!",
        "What was I doing? ...Oh, SEEDS HERE!",
    },
    MERM1_TALK_TRADE = --Sammy
    {
        "Alright, alright, get a move on.",
        "'Pleasure.",
        "Always in a rush, you lot.",
        "The plague ain't so bad, y'know.",
        "Come back now, y'hear?",
        "Who're you again?",
        "Thanks, stranger.",
    },
    MERM_TALK_CLOSED = --Pipton/Sammy
    {
        "Ya talk to ol'Mumsy yet?",
        "I ain't taking business right now.",
        "Don't keep the lady waiting.",
        "Speak with Mumsy. Hurry on, then.",
    },

    MERM_TALK_CONTEST_OOOH = {"Such taste.","Nicely done.","Such beauty."},
    MERM_TALK_CONTEST_PANIC = {"Must choose!","How decide?!"},

    -- Lines that the small ghosts deliver when a player approaches them.
    SMALLGHOST_TALK =
    {
        "ooOOoo",
        "OOoo",
        "OoOoOoO",
    },

    --Quagmire Event
    --NOTE: Keep intro short (no more than 4 lines)
    --      If there's a lot of story to tell, we can pick
    --      randomly from alternate intro sequences as well
    GOATMUM_WELCOME_INTRO =
    {
        --At the start of the match, right after players spawn
        --Transitions directly into the coin toss
        "BAAA! Who are you?",
        "No, there's no time for pleasantries!",
        "You've got to get cooking, or you'll anger the beast!",
        "I'll help how I can.",
        "Take these coins and see me when you're ready.",
    },
    GOATMUM_TALK_START_BECKON =
    {
        --After intro, before buying starting kit, and players are not near
        "Come a little closer.",
        "Yoo-hoo, over here! Baa.",
        "Over here, dear!",
        "Wait! You need cookware!",
        "My dear, come closer.",
        "There's no time to waste!",
        "Where are you going?",
    },
    GOATMUM_TALK_START_CHOICE =
    {
        --After intro, before buying starting kit, and players are near
        "You'll need one of my cookware kits.",
        "Baa. Let's trade.",
        "I have some spare cookware for trade.",
        "Would you like a pot, an oven or a grill?",
        "Use those coins to trade with me, okay?",
        "Let's trade. I'll get you set up.",
        "I hope you're good in the kitchen, dear.",
    },
    GOATMUM_TALK_START_PURCHASE =
    {
        --After player buys first cooking station
        --Craving hints will start right after this speech
        "Wonderful choice, baa! Now, let's see...",
    },
    GOATMUM_TALK_GREETING =
    {
        --During match, triggers when walking close enough to shop
        "If you can earn the Gnaw's favor... you might escape.",
        "The Gnaw's been around since I was just a lamb.",
        "Another of your kind passed through here once.",
        "Favor from the Gnaw might recharge the old key.",
        "You must cook, or you will perish.",
        "Your presence here distracts it from Billy and I.",
        "Are you... Gatekeepers, by chance?",
    },
    GOATMUM_TALK_GREETING_URGENT =
    {
        --During match, triggers when walking close enough to shop, but with little time remaining
        "Hurry, please!",
        "The Gnaw is growing impatient!",
        "It must be fed, at all costs.",
        "The Gnaw's demands know no end.",
        "I believe in you. You can do this.",
        "Don't give up.",
        "The Gnaw will cast down its plague if not fed!",
    },
    GOATMUM_TALK_TRADE =
    {
        --Triggers whenever buying something
        "Thank-you, dear.",
        "I hope it helps.",
        "You're welcome, baa.",
        "Good luck, dear.",
        "Take care, baa.",
        "Thank-you.",
        "Anything you need, dear.",
    },
    ----------------------------------------------------------------------------
    --Eg: "The Gnaw craves a snack... I'm sure of it, baa."
    --    "The Gnaw hungers for a meat dish... or anything! Hurry, BAAA!"
    GOATMUM_CRAVING_HINTS =
    {
        "The Gnaw craves {craving}... {part2}",
        "The Gnaw hungers for {craving}... {part2}",
        "The Gnaw desires {craving}... {part2}",
        "The Gnaw wants {craving}... {part2}",
        "The Gnaw craves {craving}!",
        "The Gnaw desires {craving}!",
        "The Gnaw hungers for {craving}!",
    },
    GOATMUM_CRAVING_HINTS_PART2 =
    {
        "I can tell, baa.",
        "I feel it.",
        "It's time to cook.",
        "baa.",
        "I'm certain of it.",
        "You must oblige.",
    },
    GOATMUM_CRAVING_HINTS_PART2_IMPATIENT =
    {
        "or anything! Hurry, BAAA!",
        "or whatever! Quick, BAAA!",
        "BAAA! Hurry!",
        "there's no time!",
        "give it something! Anything!",
    },
    ----------------------------------------------------------------------------
    GOATMUM_CRAVING_MATCH =
    {
        "Oh yes, {craving}! That'll buy you some time.",
        "Yes, yes, {craving}! That should sate the beast.",
        "You found what the Gnaw craved!",
        "The Gnaw's pleased with your offering.",
        "Mighty Gnaw! Feast now upon on {craving}!",
    },
    GOATMUM_CRAVING_MISMATCH =
    {
        "Well, it wasn't {craving}. But better than nothing!",
        "That wasn't what the Gnaw craved, but we'll make do.",
        "I wouldn't call that {craving}, but oh well.",
    },
    ----------------------------------------------------------------------------
    GOATMUM_CRAVING_MAP =
    {
        SNACK = "a SNACK",
        SOUP = "SOUP",
        VEGGIE = "a VEGETABLE dish",
        FISH = "FISH",
        BREAD = "a meal on BREAD",
        MEAT = "MEAT",
        CHEESE = "a meal with CHEESE",
        PASTA = "PASTA",
        SWEET = "a DESSERT",
    },
    ----------------------------------------------------------------------------

    GOATMUM_VICTORY = -- Players win
    {
        "Baa! The way is open!",
        "Quickly, make haste to your world.",
        "Billy and I'll follow soon behind.",
        "May we all leave this plague behind us.",
        "Good luck, kind strangers!",
    },
    GOATMUM_LOST = -- Players lost
    {
        "It's over.",
        "The Gnaw's plague is upon you.",
        "I'm sorry I couldn't help more.",
        "Goodbye.",
    },

    -- gameplay done
    --NOTE: Limit to 63 strings per table! (Using net_smallbyte for NPC chatter)
    SWAMPIG_TALK_TO_WILSON =
    {
        "KIND ELDER SICK. NEED REST",
        "YOU DIFFERENT",
        "HELLO",
        "YOU HELP PIGS?",
        "YOU WEIRD GOAT",
        "YOU FEED GNAW?",
        "(SNIFF SNIFF) (SNORT)",
    },

    GOATKID_TALK_GREETING =
    {
        "Pipton lets me have sweets, when Mumsy says it's okay.",
        "I like playing with the pebble crabs.",
        "Our house used to be around here, baa.",
        "Mumsy says my friends can't come out to play.",
        "I wish my bike still worked, baa.",
        "Sammy was a goat before, like mum and I.",
        "Mumsy tells me not to look at the sky.",
    },
    GOATKID_TALK_TRADE =
    {
        "Baaaa! My favorite!",
        "Oh, thanks!",
        "We're friends now, right?",
        "Baa!",
        "Mumsy says always to say \"thank-you\".",
        "Tradesies are fun.",
        "Baa, thanks!",
    },
    GOATKID_TALK_CLOSED =
    {
        "I'll only talk to you if Mumsy says it's okay.",
        "Go talk to my mum. Baa.",
        "Can you ask my mum before we play?",
        "Go ask Mumsy if we can play. Baa.",
    },

    QUAGMIRE_ELDER_TALK_SLEEP =
    {
        "...HRUMPF...",
        "(SNORT) ...s...scales...",
        "...p...plague...",
        "...zzzZZzzz...",
        "...g-GNAW...",
        "...s-sky...",
    },
    QUAGMIRE_ELDER_TALK_GREETING =
    {
        "HRF? YOU TRADE? SUPPLIES?",
        "HRF? SLEEP... GIVE ELDER NIGHTMARES",
        "HRF! OUR HOMES DESTROYED",
        "HRF! GNAW MAD AT PIGS",
        "HRF! MOST GOATS NO HELP TO PIGS",
        "HRF! WE NEED FIX HOUSES",
        "HRF? ...WHAT LITTLE PIGS DO IF ELDER GONE?",
    },
    QUAGMIRE_ELDER_TALK_BUY =
    {
        "THANK-YOU. NOW LET ELDER REST.",
        "YES. YOU GOOD GOAT.",
        "MAYBE NOW WE FIX HOUSES",
        "THANK-YOU",
        "ELDER'S EYE FEEL HEAVY",
        "GOOD LUCK. WITH GNAW.",
        "THANK-YOU, LITTLE GOAT.",
    },

    EPITAPHS =
    {
        "It says \"Come on in.\"",
        "\"Don't even think about it.\"",
        "\"Here lies some guy.\"",
        "\"Here lies some gal.\"",
        "\"Here lies some person.\"",
        "The headstone is blank.",
        "\"Milk. Eggs. Bacon.\"",
        "Huh? That's my name!",
        "It reads \"You're standing on my face.\" Oops.",
        "There's just a big \"W\" etched in it.",
        "\"Not sick, just coffin.\"",
        "\"Sweet slumber.\"",
        "\"This world could not hold me.\"",
        "\"I didn't like it here anyway.\"",
        "\"I've better places to be.\"",
        "\"It's dirty down here.\"",
        "\"Age makes fools of us all.\"",
        "\"Just needed a rest.\"",
        "\"Five more minutes.\"",
        "\"It's not as bad as it looks.\"",
        "\"Quoth the tallbird, Evermore.\"",
        "It says \"Finally, some peace and quiet.\"",
        "It says \"Mind your own business.\"",
        "It says \"Help, get me out!\" and \"Nah, just kidding,\" beneath.",
        "It reads \"Pulvis Et Umbra Sumus.\"",
        "An engraving of their last words: \"I love it so much I could just die!\"",
        "An engraving of their last words: \"Hey, watch this.\"",
        "An engraving of their last words: \"Uh-oh.\"",
        "An engraving of their last words: \"This is fine.\"",
        "An engraving of their last words: \"I'm out of here.\"",
        "An engraving of their last words: \"That's enough of that.\"",
        "An engraving of their last words: \"I'd rather die!\"",
        "An engraving of their last words: \"Uh, okay bye.\"",
        "It reads \"Right behind you...\" and \"Made you look!\"",
        "\"Whoops.\"",
        "It's cracked down the middle.",
        "It says \"The end is only the beginning\".",
        "It says \"I was underground before it was a thing.\" Huh?",
        "Someone left flowers.",
        "It's old and worn.",
        "It says \"Did I make it into the history books?\"",
        "It says \"I'm taking a nap. In the dirt.\"",
        "It says \"These are just the pieces we could find.\"",
        "It says \"See you on the other side.\"",
        "It says \"Catch you later.\"",
        "It says \"Don't make fun. You'll be here too one day.\"",
        "It says \"On to the next adventure.\"",
        "\"It's worse than it looks.\"",
        "\"This is where I keep my stuff.\"",
        "It says \"I'm just pretending.\"",
        "It reads \"Is the coast clear yet?\"",
        "It says \"Lost and Found\".",
        "It says \"I hope I turned the oven off.\"",
        "It says \"Right where I belong.\"",
        "It says \"I guess this is my life now.\"",
        "\"Not sick, just coffin.\"",
        "\"Beware.\" Beware of what?",
        "It's covered in a peaceful moss.",
        "It reads \"I've made a grave error.\" Hm.",
        "It reads \"I can dig it.\" Oh.",
        "It reads \"Care to join me?\"",
        "It reads \"Don't worry, it's cozy.\" That's nice.",
        "\"And don't come back.\"",
        "The inscription reads \"Always Watching\". Odd.",
    },

    -- Epitaphs, for Wendy's gravestone construct
    WENDY_EPITAPHS =
    {
        "\"Sweet slumber.\"",
        "\"This world could not hold me.\"",
        "\"I didn't like it here anyway.\"",
        "\"I've better places to be.\"",
    },

    MESSAGEBOTTLE_NOTES =
    {
        "\"I know you're still out there, my dear. I won't ever give up.\"",
        "\"I'm waiting for you. At the spot where we first met. I've been waiting so long...\"",
        "\"Please come home. I miss you so much.\"",
        "\"I still have the last gift you gave me. \"A pearl for Pearl\"... remember?\"",
        "\"I'll keep sending messages, until one reaches you...\"",
        "\"Have you found your treasure yet? When you do, will you come home?\""
    },

    TABS =
    {
        TOOLS = "Tools",
        LIGHT = "Light",
        FARM = "Food",
        SURVIVAL = "Survival",
        SCIENCE = "Science",
        WAR = "Fight",
        TOWN = "Structures",
        REFINE = "Refine",
        DRESS = "Dress",
        MAGIC = "Magic",
        BOOKS = "Books",
        GEMOLOGY = "Gemology",
        ANCIENT = "Ancient",
        CELESTIAL = "Celestial",
		MOON_ALTAR = "Celestial",
		LUNARFORGING = "Brightsmithy",
		SHADOWFORGING = "Shadowcraft",
        SHADOW = "Shadow",
        ENGINEERING = "Engineering",
		ELIXIRBREWING = "Ectoherbology",
        BATTLESONGS = "Stagecraft",
        SPIDERCRAFT = "Spider Care",
        NATURE = "Green Thumb",
        CARTOGRAPHY = "Cartography",
        SEAFARING = "Seafaring",
        SCULPTING = "Sculptures",
        ORPHANAGE = "Critters",
        PERDOFFERING = "Offerings",
		QUAGMIRE_MEALINGSTONE = "Mealing Stone",
		QUAGMIRE_TRADER_ELDER = "Swamp Pig Elder",
		QUAGMIRE_TRADER_MERM1 = "Sammy",
        QUAGMIRE_TRADER_MERM2 = "Pipton",
		QUAGMIRE_TRADER_MUM = "Mumsy",
		QUAGMIRE_TRADER_KID = "Billy",
		MADSCIENCE = "Mad Science",
		CARNIVAL_PRIZESHOP = "Trinket Trove",
		CARNIVAL_HOSTSHOP = "Cawnival Creation",
        FOODPROCESSING = "Seasonings",
		FISHING = "Fishing",
		WINTERSFEASTCOOKING = "Feast",
        HERMITCRABSHOP = "Bottle Exchange",
        SHELLWEAVER = "Combrining",
        RABBITKINGSHOP = "Trading Hutch",
        WANDERINGTRADERSHOP = "Trading",
        WAGPUNK_WORKSTATION = "Fabrication",
        CARPENTRY = "Carpentry",
		SLINGSHOTAMMO = "Slingshot Ammo",
		CLOCKMAKER = "Clocksmithy",
        TURFCRAFTING = "Landscaping",
		BALLOONOMANCY = "Balloonomancy",
        STRONGMAN = "Strongman",
        ROBOTMODULECRAFT = "Circuitry",
    },

    GREENAMULET_TOOLTIP = "Reduced Material Cost",

    -- YOTB Judge

    YOTB_HEY = {"Hiya!","Hey!","Howdy!","Greetings!"},
    YOTB_CONTEST_START = "Well well well, lemme get a look at the menagerie.",
    YOTB_CONTEST_BEGIN = "OK, lets get this show going...",
    YOTB_CONTEST_END = "Very nice, I think we're done.",
    YOTB_CONTEST_FIGHT_END = "Alright, contest over for now folks!",
    YOTB_EXTRA_BEEF = "Let's round up some locals to make things interesting.",
    YOTB_NO_EXTRA_BEEF = "What an eclectic looking bunch.",
    YOTB_GUESS_WHO_1 = "Alright, which of these beauties do you think is today's winner!?",
    YOTB_GUESS_WHO_2 = "Take your time, choose wisely.",
    YOTB_GUESS_WHO_3 = "OK, now hurry up...",
    YOTB_GUESS_WHO_4 = "Time's up!",
    YOTB_GUESS_WHO_5 = "Alright, my pick for today's contest is...",

    YOTB_NO_PRIZE = "No one guessed right today! There's always tomorrow.",
    YOTB_PRIZE = "Only one winner! Don't spend it all in one place!",
    YOTB_PRIZES = "Here's your prizes, winners!",
    YOTB_CONSOLE_PRIZES = "Everyone gets to take something home.",
    YOTB_PATTERNS = "Everyone, enjoy some complimentary fashion scraps!",

    YOTB_GIVE_PRIZE_BIG = "Congrats! Don't spend it all in once place.",
    YOTB_GIVE_PRIZE_SMALL = "Here you go, well done you.",
    YOTB_NOTHING_FOR_YOU = "Sorry, you didn't win anything this time.",
    YOTB_ALREADY_GOT_YOURS = "You already got yours. No double dipping.",

    YOTB_CONTEST_TARGET_PARAMS = "My perfect beefalo changes from day to day...",
    YOTB_CONTEST_THIRD_PLACE = "Alright, my pick for third place is...",
    YOTB_CONTEST_SECOND_PLACE = "And In second place...",
    YOTB_CONTEST_FIRST_PLACE = "Finally, my first place pick is...",
    YOTB_CONGRATS_WINNER = "Congrats little guy! You win!",
    YOTB_CONGRATS_WINNER_SECOND = "Congratulations!",
    YOTB_CONGRATS_WINNER_THIRD = "Take a bow!",

    YOTB_START_FAIL_DANGER = "Sorry, it's not safe enough around here!",
    YOTB_START_FAIL_LATE = "Sorry, it's too late to start today.",
    YOTB_START_FAIL_NOT_ENOUGH_POSTS = "I don't see enough Stages out yet.",
    YOTB_START_FAIL_NO_CONTESTANTS = "I don't see any contestants to judge, do you?",

    YOTB_HURRY_PRIZE = "Come get your prize, I won't wait all day.",
    YOTB_TOO_LATE_PRIZE = "Sorry, can't wait any longer. Bye now.",

    YOTB_COLLECT_PRIZE_QUICK = "Things are getting out of hand, hurry up and collect your prizes!",

    -- FEARSOME (After Contest lines)
    YOTB_CONTEST_FEARSOME_EXTREMEHIGH = {
       "This one is much too fearsome.",
       "This beefalo's fierceness is well beyond my taste today.",
    },
    YOTB_CONTEST_FEARSOME_VERYHIGH = {
       "This specimen is more fierce than I want.",
       "I respect how fearsome this beefalo is, but it's more than I like.",
--       "This beefalo could do with being quite a bit more friendly.",
    },
    YOTB_CONTEST_FEARSOME_HIGH = {
       "This beefalo is just a little fiercer than I want.",
       "Being a little too fierce can be good, but not today.",
--      "I like my beefalo friendlier than this",
    },
    YOTB_CONTEST_FEARSOME_PERFECT = {
       "I like this one's ferocity.",
       "This beefalo fills me with just the right amount of fear."
--      "This is just the level of friendlyness I like",
    },
    YOTB_CONTEST_FEARSOME_LOW = {
       "Maybe this beefalo could be a little more fierce.",
       "This beefalo is not as fierce as I'd like, but it's close.",
--      "This beefalo is a tad too friendly",
    },
    YOTB_CONTEST_FEARSOME_VERYLOW = {
        "I'd like my beefalo to be a fair bit more fearsome than this.",
        "This one is not quite fierce enough, by a good margin.",
--      "This beefalo is much too friedly",
    },
    YOTB_CONTEST_FEARSOME_EXTREMELOW = {
        "Today's beefalo needs to be a lot more fierce than this teddy bear.",
        "I'm looking for something way more fearsome today.",
    },

    -- FESTIVE
    YOTB_CONTEST_FESTIVE_EXTREMEHIGH = {
       "This one is much too festive.",
       "This beefalo's festiveness is well beyond my taste today.",
    },
    YOTB_CONTEST_FESTIVE_VERYHIGH = {
       "This fella is more festive than I want.",
       "I respect how festive this beefalo is, but it's more than I like.",
--       "This beefalo could do with being quite a bit more gloomy.",
    },
    YOTB_CONTEST_FESTIVE_HIGH = {
       "This beefalo is just a little more festive than I want.",
       "Being a little too festive can be good, but not today.",
--      "I like my beefalo more somber than this",
    },
    YOTB_CONTEST_FESTIVE_PERFECT = {
       "I like this one's festivity.",
       "This beefalo is just festive enough."
--      "This is just the level of gloom I like",
    },
    YOTB_CONTEST_FESTIVE_LOW = {
       "Maybe this beefalo could be a little more festive.",
       "This beefalo is not as festive as I'd like, but it's close.",
--      "This beefalo is a tad too gloomy",
    },
    YOTB_CONTEST_FESTIVE_VERYLOW = {
        "I'd like my beefalo to be a fair bit more festive than this.",
        "This one is not quite festive enough, by a good margin.",
--      "This beefalo is much too somber",
    },
    YOTB_CONTEST_FESTIVE_EXTREMELOW = {
        "Today's beefalo needs to be a lot more festive than this curmudgeon.",
        "I'm looking for something way more festive today.",
    },


    -- FORMAL
    YOTB_CONTEST_FORMAL_EXTREMEHIGH = {
       "This one is much too formal.",
       "This beefalo's formalness is well beyond my taste today.",
    },
    YOTB_CONTEST_FORMAL_VERYHIGH = {
       "This specimen is more formal than I want.",
       "I respect how formal this beefalo is, but it's more than I like.",
--       "This beefalo could do with being quite a bit more unconventional.",
    },
    YOTB_CONTEST_FORMAL_HIGH = {
       "This beefalo is just a little more formal than I want.",
       "Being a little too formal can be good, but not today.",
--      "I like my beefalo more relaxed than this",
    },
    YOTB_CONTEST_FORMAL_PERFECT = {
       "I like this one's formalness.",
       "This beefalo is just formal enough."
--      "This is just the level of disorder I like",
    },
    YOTB_CONTEST_FORMAL_LOW = {
       "Maybe this beefalo could be a little more formal.",
       "This beefalo is not as formal as I'd like, but it's close.",
--      "This beefalo is a tad too relaxed",
    },
    YOTB_CONTEST_FORMAL_VERYLOW = {
        "I'd like my beefalo to be a fair bit more formal than this.",
        "This one is not quite formal enough, by a good margin.",
--      "This beefalo is much too unconventional",
    },
    YOTB_CONTEST_FORMAL_EXTREMELOW = {
        "Today's beefalo needs to be a lot more formal than this ragamuffin.",
        "I'm looking for something way more formal today.",
    },


    -- FEARSOM (Telling what he wants)
    YOTB_CONTEST_FEARSOME_TARGET_EXTREMEHIGH = {
       "Finally, I'm in the mood for a good scare. Let's see your most fearsome beefalo!",
    },
    YOTB_CONTEST_FEARSOME_TARGET_VERYHIGH = {
       "Finally, I'm looking for something quite fierce.",
       "Finally, I want something quite fearsome looking.",
    },
    YOTB_CONTEST_FEARSOME_TARGET_HIGH = {
       "Finally, today's winner will be only mildly more fearsome than friendly.",
    },
    YOTB_CONTEST_FEARSOME_TARGET_PERFECT = {
       "Finally, I can't quite decide. Show me a good balance of fearsome and friendly.",
    },
    YOTB_CONTEST_FEARSOME_TARGET_LOW = {
         "Finally, I'd like to see a beefalo that's just a bit more friendly than scary.",
    },
    YOTB_CONTEST_FEARSOME_TARGET_VERYLOW = {
        "Finally, I'm looking for only the tiniest hint of ferocity.",
        "Finally, today I want to see a little ferocity, but just a touch.",
    },
    YOTB_CONTEST_FEARSOME_TARGET_EXTREMELOW = {
        "Finally, today's winner needs to be a teddy bear. My heart can't take a scare.",
    },

    -- FESTIVE
    YOTB_CONTEST_FESTIVE_TARGET_EXTREMEHIGH = {
       "Also, the winner should be the most festive of beasts.",
    },
    YOTB_CONTEST_FESTIVE_TARGET_VERYHIGH = {
       "Also, I'm looking for quite a lot of festivity today.",
--       "This beefalo could do with being quite a bit more gloomy.",
    },
    YOTB_CONTEST_FESTIVE_TARGET_HIGH = {
       "Also, there should be a lot of festivity, with just a dash of somberness.",
--      "I like my beefalo more somber than this",
    },
    YOTB_CONTEST_FESTIVE_TARGET_PERFECT = {
       "Also, I'm looking for a tasteful mix of festivity and somberness.",
       "Also, today's champion will be a perfect balance of somber and festive.",
--      "This is just the level of gloom I like",
    },
    YOTB_CONTEST_FESTIVE_TARGET_LOW = {
       "Also, today's winner will be a bit more somber than festive.",
    },
    YOTB_CONTEST_FESTIVE_TARGET_VERYLOW = {
        "Also, I only want to see the tiniest hint of festivity.",
    },
    YOTB_CONTEST_FESTIVE_TARGET_EXTREMELOW = {
        "Also, I don't want to see even a hint of festivity in today's Champion.",
        "Also, I'm in no mood for festivity today. I'd better not see a trace of it!",
    },


    -- FORMAL
    YOTB_CONTEST_FORMAL_TARGET_EXTREMEHIGH = {
       "Everything about today's winner should scream \"formality.\"",
    },
    YOTB_CONTEST_FORMAL_TARGET_VERYHIGH = {
       "I'd like to see the high end of formality today, with just a dash of disorder.",
    },
    YOTB_CONTEST_FORMAL_TARGET_HIGH = {
       "Today's beefalo should have a slight edge of formality.",
    },
    YOTB_CONTEST_FORMAL_TARGET_PERFECT = {
       "I want to see a perfect blend of unconventional and formal.",
    },
    YOTB_CONTEST_FORMAL_TARGET_LOW = {
       "My pick for today will be a bit more unconventional than formal.",
    },
    YOTB_CONTEST_FORMAL_TARGET_VERYLOW = {
        "I want to see something mostly unconventional, with just a whiff of formality.",
--      "This beefalo is much too unconventional",
    },
    YOTB_CONTEST_FORMAL_TARGET_EXTREMELOW = {
        "My taste today is for a complete lack of formality.",
    },

    ------ APPRAISE STRINGS

    YOTB_APPRAISE_START = "Let's see what you have there.",
    YOTB_APPRAISE_END = "Wonderful item you've got there.",

    -- FEARSOME
    YOTB_DOLL_FEARSOME_TARGET_EXTREMEHIGH = {
       "Finally, this is the most fearsome of dolls!",
    },
    YOTB_DOLL_FEARSOME_TARGET_VERYHIGH = {
       "Finally, it's quite fierce.",
       "Finally, this is quite fearsome looking.",
    },
    YOTB_DOLL_FEARSOME_TARGET_HIGH = {
       "Finally, it's only mildly more fearsome than friendly.",
    },
    YOTB_DOLL_FEARSOME_TARGET_PERFECT = {
       "Finally, it has a good balance of fearsome and friendly.",
    },
    YOTB_DOLL_FEARSOME_TARGET_LOW = {
         "Finally, this is just a bit more friendly than scary.",
    },
    YOTB_DOLL_FEARSOME_TARGET_VERYLOW = {
        "Finally, it has the tiniest hint of ferocity.",
        "Finally, I can see a little ferocity, but just a touch.",
    },
    YOTB_DOLL_FEARSOME_TARGET_EXTREMELOW = {
        "Finally, this is like a teddy bear. My heart is at ease.",
    },

    -- FESTIVE
    YOTB_DOLL_FESTIVE_TARGET_EXTREMEHIGH = {
       "Also, it's the most festive of dolls.",
    },
    YOTB_DOLL_FESTIVE_TARGET_VERYHIGH = {
       "Also, it has quite a lot of festivity.",
    },
    YOTB_DOLL_FESTIVE_TARGET_HIGH = {
       "Also, it has a lot of festivity, with just a dash of somberness.",
    },
    YOTB_DOLL_FESTIVE_TARGET_PERFECT = {
       "Also, this is tasteful mix of festivity and somberness.",
       "Also, it's a perfect balance of somber and festive.",
    },
    YOTB_DOLL_FESTIVE_TARGET_LOW = {
       "Also, this is a bit more somber than festive.",
    },
    YOTB_DOLL_FESTIVE_TARGET_VERYLOW = {
        "Also, it has only the tiniest hint of festivity.",
    },
    YOTB_DOLL_FESTIVE_TARGET_EXTREMELOW = {
        "Also, I don't see even a hint of festivity in this.",
    },


    -- FORMAL
    YOTB_DOLL_FORMAL_TARGET_EXTREMEHIGH = {
       "Everything about this screams \"formality.\"",
    },
    YOTB_DOLL_FORMAL_TARGET_VERYHIGH = {
       "This is the high end of formality, with just a dash of disorder.",
    },
    YOTB_DOLL_FORMAL_TARGET_HIGH = {
       "This has a slight edge of formality.",
    },
    YOTB_DOLL_FORMAL_TARGET_PERFECT = {
       "It's a perfect blend of unconventional and formal.",
    },
    YOTB_DOLL_FORMAL_TARGET_LOW = {
       "This a bit more unconventional than formal.",
    },
    YOTB_DOLL_FORMAL_TARGET_VERYLOW = {
        "This is mostly unconventional, with just a whiff of formality.",
    },
    YOTB_DOLL_FORMAL_TARGET_EXTREMELOW = {
        "It has a complete lack of formality.",
    },

    --  end beefalo contest


    WAGSTAFF_NPC_START = {"This is it, it must be contained.","I'll need your assistance, we must contain it before it's gone!"},
    WAGSTAFF_NPC_MUMBLE_1 = {"It's close by now...","If I can just find...","If my hypothesis is correct...","It's here... somewhere."},
    WAGSTAFF_NPC_THIS_WAY = {"Ahh, this way!","My scans point toward this direction.","Aha, found it again!"},
    WAGSTAFF_NPC_NO_WAY1 = {"Blast, I lost the signal."},
    WAGSTAFF_NPC_NO_WAY2 = {"I must have miscalculated."},
    WAGSTAFF_NPC_NO_WAY3 = {"Come find me again once I've made some preparations."},

    WAGSTAFF_NPC_NOT_THIS_TOOL = {"No no, that's not what I'm looking for!","This isn't the right one, the other one!"},

    WAGSTAFF_NPC_YES_THIS_TOOL = {"Excellent, that's it!","At last! Now let's get this finished!"},

    WAGSTAFF_NPC_TOO_BUSY = {"I'm a bit preoccupied at the moment.","Patience if you please, this requires my full concentration."},

    WAGSTAFF_NPC_ATTEMPT_TRADE = {"Is it important?","Quickly now, timing is critical!"},


    WAGSTAFF_NPC_EXPERIMENT_DONE_1 = "It's done!",
    WAGSTAFF_NPC_EXPERIMENT_DONE_2 = "Take this, you'll need it for what we have to do.",

    WAGSTAFF_NPC_EXPERIMENT_FAIL_1 = "Balderdash! The containment has failed!",
    WAGSTAFF_NPC_EXPERIMENT_FAIL_2 = "Back to my notes again...",

    WAGSTAFF_NPC_STORMPASS = "Balderdash, my connection is fading!",

    WAGSTAFF_NPC_MEETING = "You! Of course!",
    WAGSTAFF_NPC_MEETING_2 = "Quick, take these!",
    WAGSTAFF_NPC_MEETING_3 = "I'll be needing some assistance shortly.",
    WAGSTAFF_NPC_MEETING_4 = "Find me when you are sufficiently prepared.",
    WAGSTAFF_NPC_MEETING_5 = "Now, to find the source of that reading...",

    WAGSTAFF_NPC_WANT_TOOL_1 = "Quick, I need my Reticulating Buffer!",
    WAGSTAFF_NPC_WANT_TOOL_2 = "Someone find me a Widget Deflubber!",
    WAGSTAFF_NPC_WANT_TOOL_3 = "Has anyone seen my Grommet Scriber?",
    WAGSTAFF_NPC_WANT_TOOL_4 = "Can someone hand me the Conceptual Scrubber?",
    WAGSTAFF_NPC_WANT_TOOL_5 = "I'm certain I put the Calibrated Perceiver down here somewhere...",

    WAGSTAFF_NPC_CAPTURESTART = "Excellent! My little experiment was a resounding success!",
    WAGSTAFF_NPC_CAPTURESTOP = "Thank you for all your hard work.",
    WAGSTAFF_NPC_CAPTURESTOP1 = "This will increase the power output exponentially!",
    WAGSTAFF_NPC_CAPTURESTOP2 = "Now if you'll excuse me, I have much to do.",
    WAGSTAFF_NPC_CAPTURESTOP3 = "You and I are about to change the world!",

    WAGSTAFF_NPC_REQUEST = {"Incredible! It's just as I surmised!",
                            "If I could just push its output a bit further...",
                            "Oh yes, this could really be something, with one small addition...",
                            "A small crystalline structure might just do the trick.",
                            "Yes, I'm positive a shard of crystal would work...",
                            "If it had the right translucency...",
                            "And the correct shape...",
                            "And lunar origin...",
                            -- These next ones will be randomly chosen from here on.
                            "Hmmm...",
                            "If I could just locate one...",
                            "A crystalline shard, with the correct properties..."},

    WAGSTAFF_NPC_NOTTHAT = "Don't waste my time.",
    WAGSTAFF_NPC_YES_THAT1 = "This is... yes, this will propel my experiments to the next level!",
    WAGSTAFF_NPC_YES_THAT2 = "Quickly, hand it over.",

    WAGSTAFF_GOTTAGO1 = "Aha! This selenological anomaly can only mean one thing!",
    WAGSTAFF_GOTTAGO2 = "Now is my chance!",

    WAGSTAFF_NPC_GOT_ENOUGH_GESTALTCAGE =  {
        "Enough of these.",
        "We need something far more powerful.",
        "I wonder where we can find one...",
    },

    WAGSTAFF_NPC_LUNARGUARDIANINCOMING = "Hm, seems we've angered the lunar being in collecting too many of its little friends.",

    -- Script.
    WAGSTAFF_NPC_DEFEAT_TWO_MORE_MUTATIONS =
    {
        "Illuminating! It would greatly aid my research...",
        "If you could repeat this exemplary performance...",
        "With another specimen displaying similar mutations.",
    },

    -- Script.
    WAGSTAFF_NPC_DEFEAT_ONE_MORE_MUTATION =
    {
        "Well done!",
        "But perhaps one more.",
        "For scientific accuracy, of course.",
        "You understand.",
    },

    -- Script.
    WAGSTAFF_NPC_ALL_MUTATIONS_DEFEATED = {
        "Right. A third specimen. I did ask for another, didn't I?",
        "You dallied so long I nearly forgot!",
        "For your troubles, the fruits of our research.",
        "I think taking it down to the subterranean archives...",
        "Will prove most enlightening.",
    },

    -- Random Line.
    WAGSTAFF_NPC_ANALYSIS_OVER =
    {
        "Now, if you'll excuse me, I have much to do.",
        "Farewell!",
        "Until next time.",
        "Best of luck to you! I must be off.",
    },

    -- Random script.
    WAGSTAFF_NPC_MUTATION_DEFEATED_AFTER_TASK_COMPLETED1 =
    {
        "I have all the data I require from this creature.",
        "However... I suppose I mustn't let your efforts go unrewarded.",
    },
    WAGSTAFF_NPC_MUTATION_DEFEATED_AFTER_TASK_COMPLETED2 =
    {
        "Still at it, are you? I must commend your zeal for research.",
        "Here, a contribution to your continued studies.",
    },
    WAGSTAFF_NPC_MUTATION_DEFEATED_AFTER_TASK_COMPLETED3 =
    {
        "I'm afraid we have nothing more to gain from analyzing this poor creature.",
        "Take this, as a token of my gratitude for your efforts.",
    },

    WAGSTAFF_GOTTOHINT = {
        "Just a bit more research... I'm close, I'm sure of it!",
        "A few more samples, yes, that's what I need...",
        "Now where did I leave my notes? I'm sure they were somewhere around here...",
        "Onto the next experiment!",
        "Progress waits for no one!",
    },

    WAGSTAFF_JUNK_YARD_OCCUPIED = {
        "Too crowded here for my work. I'll come back later",
    },
    WAGSTAFF_TOOMANYITEMS = {
        "Your haste is good but I'm busy!",
        "I'm too busy to deal with you right now.",
    },
    WAGSTAFF_GOT_NOT_MAPSCROLL = {
        "No... no. We need a map to move that crab.",
        "What is this? We need a map for that crab!",
    },
    WAGSTAFF_GOT_MAPSCROLL_BAD = {
        "This is no good. It has to have my... an island on it.",
        "This map is useless. That crab will only move to another island.",
        "Try again. Bring me a map to the primate island.",
    },
    WAGSTAFF_MAPSCROLL_TRICKER = {
        "No, not me! The crab! Give it to that crab!",
        "Why are you giving me this? It's for that crab.",
    },
    WAGSTAFF_GOT_MAPSCROLL_GOOD = {
        "This will do. Just few minor edits... Perfect.",
    },
    WAGSTAFF_GOT_MAPSCROLL_GOOD_FINISH = {
        "Run along and give it to that crab.",
    },
    WAGSTAFF_GOT_MAPSCROLL_NOLONGERNEEDED = {
        "Stop bringing me maps! That crab is gone!",
    },
    WAGSTAFF_GOT_EMPTY_GESTALTCAGE = {
        "It's empty.",
    },
    WAGSTAFF_GOT_NOT_GESTALTCAGE = {
        "This is not what I need. Use a Phasmo-Encapsulator and capture an appropriate entity.",
    },
    WAGSTAFF_GOT_GESTALTCAGE_NOLONGERNEEDED = {--he wants something different.
        "Hm, see if you can capture me another variety.",
        "I have enough of these. I need something special, something more... powerful.",
    },
    WAGSTAFF_GET_MORE_GESTALTCAGES = {--try again,
        "Do you have another sample?",
        "Hm, try getting me another.",
        "I need a more suitable entity!",
        "Find me a power source!",
    },
    WAGSTAFF_GOT_GESTALTCAGE_GOOD = {-- wants the big one.  not these.
        "Hm, not quite powerful enough, but I can use it.",
        "I'll take it, but there's a special one I'm looking for.",
    },
    WAGSTAFF_GOT_GESTALTCAGE_GOOD_BIGONE = {-- Got the big one.
        "Yes! A very good one! Finally!",
        "You've got it! This will do nicely!",
        "Excellent, this is the one I've been waiting for!",
    },
    -- Desire for crabby crab to get off of the island.
    WAGSTAFF_WAGPUNK_ARENA_PEARLMAP = {
        "Creatures like that crab are always looking for a bigger home. Let's give her one... sort of.",
        "Perhaps if the crab had a more \"substantial\" island to relocate to, she would leave me alone.",
        "Give me a map with an island and we'll see if we can't make it more appealing.",
    },

    -- Desire to place out flooring to make the island bigger.
    WAGSTAFF_WAGPUNK_ARENA_TURF = {
        "We need to expand the arena of my experimentation.",
        "The surface of this island must be increased with my special flooring.",
        "Use my Substrate Extrapolator and extrapolate this substrate!",
    },

    -- Desire to find a powerful energy source for the secret project.say it in multi strings. piece it out 1) phamso can capture entiteis for power source, 2) how to build 3) do it
    WAGSTAFF_WAGPUNK_ARENA_CONSTRUCT = {
        "You'll need to construct a Phasmo-Encapsulator to capture an energy being.",
        "Excellent! I need a suitable power source for my creation!",
        "Good. Use a Phasmo-Encapsulator to capture an entity to power my creation!",
    },

    WAGSTAFF_WAGPUNK_ARENA_GIVE_GESTALT_CAGE = {
        "Yes! Use this and capture that entity before it escapes!",
        "That's the entity I want! Use this to capture it. Quickly!",
        "There it is! Take this and capture that entity now!",
    },

    -- Desire for the filled3 cage. -- why this still here?
    WAGSTAFF_WAGPUNK_ARENA_CONSTRUCT_BIGONE = {
        "Finally! Hand over the entity at once!",
        "This is the one I've been waiting for! Give it to me now!",
    },

    -- Desire to have the lever switched.
    WAGSTAFF_WAGPUNK_ARENA_LEVER = {
        "Fine work! Now pull the Fulcronial Selector to start the ultimate experiment!",
        "Let us bring my creation to life! Engage the Fulcronial Selector! Yes, yes- the stick-thing.",
        "This is it! Pull the Ful- the lever.",
    },

    -- Monologue on lever pulled. --robot comes to life, and it's working. im a genius
    WAGSTAFF_WAGPUNK_ARENA_LEVERPULLED = {
        "It's perfect! Everything is going according to plan.",
        "Eureka! I've done it!",
    },

    WAGSTAFF_WAGPUNK_ARENA_REVEALBOSS = "Behold, my preeminent creation - W.A.R.B.O.T.!",

    WAGSTAFF_WAGPUNK_ARENA_ROBOTLOSTCONTROL = {
        "The entity has taken control of W.A.R.B.O.T..",
        "Seems I underestimated its strength, a shame.",
        "Ah well. Deal with it, would you?",
    },

    WAGSTAFF_WAGPUNK_ARENA_SCIONREVEAL = {
        "What a waste of my W.A.R.B.O.T.,",
        "but the entity has taken on a fascinating new hybrid form.",
        "I suspect uncontained exposure will accelerate entropy.",
        "It is not ideal.",
        "Subdue the entity posthaste.",
    },

    WAGSTAFF_WAGPUNK_ARENA_SCIONDOWN = {
        "Very good! The entity is in a weakened state.",
        "Now you just need to...",
    },

    WAGSTAFF_WAGPUNK_ARENA_SCIONATTACKSWAGSTAFF = {
        "...Gaaah!",
        "What's happening to me?",
        "Impossible!",
        "I don't under...",
    },

    -- Terraria
    EYEOFTERROR_COMING = "You feel an evil presence watching you...",
    EYEOFTERROR_TARGET = "The Eye of Terror turns its gaze toward {player_name}",
    EYEOFTERROR_CANCEL = "The evil presence has subsided.",


    TWINS_COMING = "This is going to be a terrible night...",
    TWINS_TARGET = "The Twins turn their gaze toward {player_name}",

    -- PIRATES
    MONKEY_TALK_ABANDON = {"INTO THE BLUE.","CURSES!","CANNON BALL!", "ABANDON SHIP!"},
    MONKEY_TALK_ATTACK = {"HAND IT OVER!","AVAST YE, LAND LUBBER!","SCURVY DOG!"},
    MONKEY_TALK_STEAL = {"ME BOOTY!","ARRR!","LOOT!"},
    MONKEY_TALK_RETREAT = {"WE GO!","MAKE HASTE!","ANCHOR AWEIGH!"},
    MONKEY_TALK_FIRECANNON = {"AVAST YE!","FEED THE FISH!","FIRE ON DECK!","SCUTTLE YE SELF!","TO THE DEPTHS WITH YE!"},

    MONKEY_MONKEY_BATTLECRY = {"MUTINY!","AVAST, BILGE RAT!","KEELHAUL YA!"},
    MONKEY_STUFF_BATTLECRY = {"HAND IT OVER!","GIVE UP THE GOODS!","ARRR, THAT LOOT'S MINE!"},
    MONKEY_BATTLECRY = {"LAND LUBBER!","SCURVY DOG!","FEED THE FISH!","GET YER FLOGGIN'!"},
    MONKEY_BATTLECRY_VICTORY = {"YAR! BENT GOLD!", "VICTORY TASTES SWEET!"},
    MONKEY_BATTLECRY_VICTORY_CHEER = {"YO HO!"},
    MONKEY_BATTLECRY_TIME_UP = {"TIME UP!","PARLAY OVER!"},

    MONKEY_COMMAND = {"TO ARMS!","HANG 'EM FROM THE YARD ARM!","AVAST, ME SEA MONKEYS!","PIRATES OF MOON QUAY, TO BATTLE!"},

    MONKEY_QUEEN_BANANAS = {"OOH, BENT GOLD.", "FABULOUS QUALITY.", "YOU'VE DONE WELL.",},
    MONKEY_QUEEN_REMOVE_CURSE = {"YOU WOULD RETURN SUCH A GIFT? SUIT YOURSELF.", "YOU WISH TO RETURN TO THAT HIDEOUS FORM? VERY WELL.", "I CAN'T FATHOM WHY YOU'D GIVE IT UP, BUT I'LL HONOR OUR ACCORD."},
    MONKEY_QUEEN_HAPPY = {"YOUR OFFERING PLEASES ME.", "THE GREAT SKY BANANA SMILES THIS DAY."},
    MONKEY_QUEEN_WAKE = {"WHAT'S ALL THE FUSS NOW?", "SPEAK. BUT MAKE IT QUICK."},

    GIBERISH_PRE = {"buhrg","grog","krog","gruhrd","blorg","glog","snurg","dulg"},
    GIBERISH_PST = {"le","lor","ed","end"},

    MONKEY_SPEECH_PRE = {"Ooo","Eee","Oee"},
    MONKEY_SPEECH_PST = {"ki","k"},

	--
	DAYWALKER_IMPRISONED_FAR =
	{
		--in chains & player is on screen but not that close
		--moaning/grunting/mumbling to self?
		"UUGH...",
		"...(growl)...",
		"ME FOUND IT FIRST... ME!",
		"...UUUGH...",
	},
	DAYWALKER_IMPRISONED_NEAR =
	{
		--in chains & player is nearby
		--duplicate some of the lines from above, and add some asking player for help?
		"FREE... ME...",
		"...UUGH...",
		"COME... CLOSER...",
        "PLEASE...",
	},
	DAYWALKER_RE_IMPRISONED_NEAR =
	{
		--switches to this speech after being beaten and then respawning
		"CAN'T KEEP... ME HERE... FOREVER...",
		"ME FIND CRACK TO DARK PLACE... ME!",
        "POWER SHOULD BE FOR ME!",
		"COWARDS!",
	},
	DAYWALKER_IMPRISONED_STRUGGLE =
	{
		--in chains & randomized brief struggling animation
		"ITCHY!",
		"CAN'T MOVE!",
	},
    DAYWALKER_IMPRISONED_PILLAR_BREAKING =
    {
        --as players are pickaxing pillars
        "YES!",
        "KEEP GOING!",
        "HURRY! HURRY!",
    },
	DAYWALKER_SHAKE_LEECHES =
	{
		--trying to shake off shadow leeches
		"OFF OF ME!",
        "GET OFF!!",
		"RAAAAUUGGHH!",
        "VERMIN!",
	},
	DAYWALKER_LEECH_BITE =
	{
		--leech jumped on and bit
		"AHHH!",
		"OW!!",
	},
	DAYWALKER_COLLIDE =
	{
		--collide with pillar when stumbling around trying to shake off leeches
		"OWWWWW!",
        "OOF!",
	},
	DAYWALKER_ATTACK =
    {
        --attacking player
        "HEH HEH HEH...",
        "FREE... FREE!!",
        "GRAAAR!!",
        "PESTS!",
        "ME DESTROY YOU!",
        "IS MINE! MINE!!",
    },
    DAYWALKER_POWERDOWN =
    {
        --after player's knocked all the pure horror out
        "M-MY POWER...",
        "THIS NOT OVER!",
    },
	DAYWALKER_TIRED =
	{
		--kneeling down tired, recovering health
		"HUFF... HUFF...",
        "BETTER... YES, MUCH BETTER.",
	},

	DAYWALKER2_BURIED_FAR =
	{
		--buried under junkpile & player is on screen but not that close
		--moaning/grunting/mumbling to self?
		"ME STUCK!","TOO HEAVY!","MUST GET FREE!","SO ITCHY.", --see DAYWALKER_IMPRISONED_FAR
	},
	DAYWALKER2_BURIED_NEAR =
	{
		--buried under junkpile & player is nearby
		--duplicate some of the lines from above, and add some asking player for help?
		"HEY YOU!","HELP ME!","MUST GET FREE!","STOP STARING!","SO ITCHY.","COME CLOSER.","ME WON'T DESTROY YOU... PROMISE.", --see DAYWALKER_IMPISONED_NEAR
	},
	DAYWALKER2_RUMMAGE_SUCCESS =
	{
		--rummaging and found something good
		"ME LIKE.","GOOD STUFF.","MINE.","YES!","MORE!","NICE.","NEED MORE POWER.","OOH.","MMM.",
	},
	DAYWALKER2_RUMMAGE_FAIL =
	{
		--rummaging and found nothing but trash
		"TRASH!","BLEGH!","WORTHLESS.","USELESS!","RAAAAAAGGHH! ALL GARBAGE!",
	},
	DAYWALKER2_JUNK_WARNING =
	{
		--idle in junkyard, rummaging, warn players not to take his stuff
		"ALL MINE.","DON'T TOUCH.","LAST WARNING.","GET LOST!","NOT FOR YOU!","GET OUT!",
	},
	DAYWALKER2_CHASE_AWAY =
	{
		--aggro on players, attack and chase them out of the junkyard
		"ME DESTROY YOU!","THIEF!","RAAAAAAAAGGHH!","YOU MUST DIE!","IS ALL MINE!",
	},

    SHADOWTHRALL_PARASITE_CHANT =
    {
        "Tenebrau",
        "Tenebrous",
        "salutations",
        "friends",
        "dark",
        "benevolent",
        "no fear",
        "Cursed light",
        "Sweet pall",
        "Be free",
        "liberate",
        "Ever night",
        "Dim embrace",
        "love",
        "Friends",
        "Joyous",
        "Welcome",
        "Resist not",
        "Surrender",
        "No pain",
        "No feel",
        "Forever we",
        "Many worlds",
        "One we",
        "In peace",
        "Protect ye",
        "Under the veil",
    },

    WARBIS = {
        -- Well, a rather beautifully intelligent system.
        START    = "W.A.R.B.I.S. IS ANALYZING...",
        STAGE1   = "W.A.R.B.I.S. UPGRADING!",
        STAGE2   = "W.A.R.B.I.S. AMPLIFYING!!",
        STAGE3   = "W.A.R.B.I.S. EXTREME FUNCTION!!!",

        STOP     = "W.A.R.B.I.S. TRACKING LOST.",
        NEW      = "W.A.R.B.I.S. HAS NEW TARGET!",
        SYNCHING = "W.A.R.B.I.S. IS SYNCHING...",
        SYNCHED  = "W.A.R.B.I.S. HAS SYNCHED.",
    },

    PLAYING_CARD_NAMES =
    {
        CARD0 = "Playing Card",

        CARD101 = "Ace of Spades",
        CARD102 = "Two of Spades",
        CARD103 = "Three of Spades",
        CARD104 = "Four of Spades",
        CARD105 = "Five of Spades",
        CARD106 = "Six of Spades",
        CARD107 = "Seven of Spades",
        CARD108 = "Eight of Spades",
        CARD109 = "Nine of Spades",
        CARD110 = "Ten of Spades",
        CARD111 = "Jack of Spades",
        CARD112 = "Queen of Spades",
        CARD113 = "King of Spades",

        CARD201 = "Ace of Diamonds",
        CARD202 = "Two of Diamonds",
        CARD203 = "Three of Diamonds",
        CARD204 = "Four of Diamonds",
        CARD205 = "Five of Diamonds",
        CARD206 = "Six of Diamonds",
        CARD207 = "Seven of Diamonds",
        CARD208 = "Eight of Diamonds",
        CARD209 = "Nine of Diamonds",
        CARD210 = "Ten of Diamonds",
        CARD211 = "Jack of Diamonds",
        CARD212 = "Queen of Diamonds",
        CARD213 = "King of Diamonds",

        CARD301 = "Ace of Clubs",
        CARD302 = "Two of Clubs",
        CARD303 = "Three of Clubs",
        CARD304 = "Four of Clubs",
        CARD305 = "Five of Clubs",
        CARD306 = "Six of Clubs",
        CARD307 = "Seven of Clubs",
        CARD308 = "Eight of Clubs",
        CARD309 = "Nine of Clubs",
        CARD310 = "Ten of Clubs",
        CARD311 = "Jack of Clubs",
        CARD312 = "Queen of Clubs",
        CARD313 = "King of Clubs",

        CARD401 = "Ace of Hearts",
        CARD402 = "Two of Hearts",
        CARD403 = "Three of Hearts",
        CARD404 = "Four of Hearts",
        CARD405 = "Five of Hearts",
        CARD406 = "Six of Hearts",
        CARD407 = "Seven of Hearts",
        CARD408 = "Eight of Hearts",
        CARD409 = "Nine of Hearts",
        CARD410 = "Ten of Hearts",
        CARD411 = "Jack of Hearts",
        CARD412 = "Queen of Hearts",
        CARD413 = "King of Hearts",
    },

    -- wanderingtrader
    -- FIXME(JBK): WT: Strings.
    WANDERINGTRADER_OUTOFSTOCK_PROXIMITY = {
        "Appreciate ya comin' round here, but I got nothin'. Try me again later.",
        "Hey buddy, I'm tapped out. Come back later.",
        "Good to see ya, but I've nothin' to trade. Circle back later.",
    },
    WANDERINGTRADER_OUTOFSTOCK_FROMTRADES = {
        "Ya cleaned me out! Gimme some time to restock.",
        "That's all I got! Need to go find me some more wares.",
        "Well, that's all she wrote! I'll go find more items to offer.",
    },
    WANDERINGTRADER_STARTTRADING = {
        "Friend, I got goods galore for ya!",
        "Buddy, whatcha need?",
        "Hey there, let's trade!",
    },
    WANDERINGTRADER_ENDTRADING_NOTRADES = {
        "Can't please everyone!",
        "Maybe next time.",
        "Nothin' interests you? Come see what I got later.",
    },
    WANDERINGTRADER_ENDTRADING_MADETRADE = {
        "I'll be seein' ya.",
        "Pleasure doin' business with ya.",
        "Thanks for the trade! Seeya later.",
    },
    WANDERINGTRADER_DOTRADE = {
        "Great choice! Anythin' else tickle yer fancy?",
        "Good deal! What else you need?",
        "Nice trade! Let's keep it goin'!",
    },
}

STRINGS.BUNNYMANNAMES =
{
    "Brassica",
    "Bunium",
    "Burdock",
    "Carrot",
    "Celeriac",
    "Daikon",
    "Lepidium",
    "Microseris",
    "Parsnip",
    "Radish",
    "Sium",
    "Tragopogon",
    "Ipomoea",
    "Manihot",
    "Mirabilis",
    "Psoralea",
    "Canna",
    "Typha",
    "Zingiber",
    "Oxalis",
    "Solanum",
    "Ullucus",
    "Cuperus",
    "Apios",
    "Yam Daisy",
    "Altrincham",
    "Barwon",
    "Bolero",
    "Chantenay",
    "Crusader",
    "Danvers",
    "Doucer",
    "Flakee",
    "Guerande",
    "Hipak",
    "Imperator",
    "Juwarot",
    "Karotan",
    "Magno",
    "Crandice",
    "Nantes",
    "Nelson",
    "Onward",
    "Oxheart",
    "Pimpernel",
    "Redhild",
    "Redland",
    "Suko",
    "Thumbelina",
    "Topweight",
    "Touchon",
    "Uchon",
    "Valery",
    "Yellow",
    "Zino",
    "Scandius",
    "Yttria",
    "Lanthan",
    "Cerium",
    "Praseodymia",
    "Neodymia",
    "Promethia",
    "Samari",
    "Europia",
    "Gadolin",
    "Terbia",
    "Dyspros",
    "Holmia",
    "Erbium",
    "Thulium",
    "Ytterbia",
    "Lutetium",
}

STRINGS.PIGNAMES =
{
    --emperors
    "Augustus",
    "Tiberius",
    "Caligula",
    "Claudius",
    "Nero",
    "Galba",
    "Otho",
    "Vitellius",
    "Vespasian",
    "Titus",
    "Domitian",
    "Nerva",
    "Trajan",
    "Hadrian",
    "Antonius",
    "Lucius",
    "Marcus",
    "Commodus",
    "Pertinax",
    "Didius",
    "Septmius",
    "Caracalla",
    "Geta",
    "Marcrinus",
    "Elagabalus",
    "Severus",
    "Maximinus",
    "Gordian",
    "Pupienus",
    "Balbinus",
    "Philip",
    "Hostilian",
    "Trebonianus",
    "Aemilian",
    "Valerian",
    "Gallienus",
    "Quintillus",
    "Aurelian",
    "Tacitus",
    "Florian",
    "Probus",
    "Carus",
    "Numerian",
    "Carinus",
    "Diocletian",
    "Maximian",
    "Constantius",
    "Galerius",
    "Constantine",
    "Maxentius",
    "Licinius",
    "Constans",
    "Vetriano",
    "Julian",
    "Jovian",
    "Valentinian",
    "Valens",
    "Gratian",
    "Theodosius",
    "Arcadius",
    "Honorius",
    "Joannes",
    "Marcian",
    "Petronius",
    "Avitus",
    "Majorian",
    "Libius",
    "Anthemius",
    "Olybrius",
    "Glycerius",
    "Julius",
    "Romulus",
    "Leo",
    "Zeno",
    "Basiliscus",
    "Anatasius",
    "Justin",
    "Justinian",
    "Maurice",

    --forum fun
    "Mickey",
    "Cheeky Chris",

    --dev team
    "Kevin",
    "Ju-lian",
    "Alia",
    "Tatham",
    "Brook",
    "Matt",
    "Alex",
    "Kris",
    "Kelly",
    "Eugene",
    "Graham",
    "Jamie",
    "Jeff",
    "Joe",
    "Corey",
    "Bryce",
    "Bug", --Joe's kid
    "Seth",
    "Hugo",

    --food that Sloth likes
    "Moon Pie",
    "Bagel",
    "Biscuit",
    "Bacon",
    "Hamilton",
    "Hamms",
    "Mr.P",
    "Brownie",
    "Butters",
    "Tuna",
    "Clover",
    "Coco",
    "Custard",
    "Dumpling",
    "Eggy",
    "Kiwi",
    "Weiner",
    "Waffle",
    "Twinkie",
    "Truffle",
    "Tater",
    "Cheddar",
    "Pumpkin",
    "Oatey",
    "Oinkey",
    "Nacho",
    "Puffin",
    "Doughnut",
    "Cabbage",
    "Porky",
    "Porkins",
    "Porkbun",
    "Pepper",
    "Gouda",
    "Eggbert",
    "Chip",
    "Berry",
    "Crabby",
    "Reuben",
    "Barley",
    "Olive",
    "Pickles",
    "Wiggles",
    "Jerky",
    "Smelly",
    "Salty",
}

STRINGS.SWAMPIGNAMES =
{
    --farmers
    "Titus",
    "Domitian",
    "Nerva",
    "Trajan",
    "Hadrian",
    "Antonius",
    "Lucius",
    "Marcus",
    "Commodus",
    "Pertinax",
    "Didius",
    "Septmius",
    "Caracalla",
    "Geta",
    "Marcrinus",
    "Elagabalus",
    "Severus",
    "Maximinus",
    "Gordian",
    "Pupienus",
    "Balbinus",
}

STRINGS.CROWNAMES =
{
    "Apollo",
	"Russel",
	"Jet",
	"Bram",
	"Corbett",
	"Korbin",
	"Ava",
	"Merle",
	"Swift",
    "Symone",
    "Baxter",
    "Robyn",
    "Helena",
    "Quincy",
    "Nick",
    "Francis",
    "Tom",
    "Lysander",
    "Demetrius",
    "Hermia",
    "Becca",
}

STRINGS.MERMNAMES =
{
    -- Swamp.
    "Flargle",
    "Flop",
    "Flot",
    "Flugh",
    "Flupt",
    "Flurgle",
    "Fopt",
    "Furp",
    "Furt",
    "Glogh",
    "Glop",
    "Glot",
    "Glugh",
    "Glup",
    "Glurp",
    "Glurt",
    "Glurble",
    "Gogh",
    "Gop",
    "Gopt",
    "Gorp",
    "Gort",
    "Gugh",
    "Gup",
    "Gupt",
    "Gurble",
    "Gurp",
    "Gurt",
    -- Not swamp.
    "Audrey",
    "Jeffrey",
    "Johnny",
    "Isabella",
    "Madeline",
    "Michael",
    "Penelope",
    "Sarah",
    "Simon",
    "Trevor",
}

STRINGS.SHARKBOINAMES =
{
	"Steve",
	"Ronnie",
	"Finn",
	"Stace",
	"Tiffany",
	"Gary",
	"Mark",
	"Donna",
	"Meg",
	"Deb",
	"Parker",
	"Cooper",
	"Caleb",
	"Gilleon",
	"Jawson",
	"Grey",
	"Jimmy the Jaw",
	"Bruce",
	"Hammer Ed",
	"Jumbo",
	"Cousin Finny",
	"Bullton",
	"Tiger",
	"Big Tuna",
	"Mad Dogfish",
	"Tony Shortfin",
	"Larry Lemons",
	"Ray",
	"Marlin",
	"Gill",

}

STRINGS.UI =
{
	TIME_FORMAT =
	{
		HHMMSS = "{hours}:{minutes}:{seconds}",
		MMSS = "{minutes}:{seconds}",
	},
	DAYS_FORMAT =
	{
		DHM = "{days}d {hours}h {minutes}m",
		HM = "{hours}h {minutes}m",
		M = "{minutes}m",
	},

	DATE_FORMAT =
	{
		MDY = "{month} {day}, {year}",
	},

	DATE =
	{
		MONTH_ABBR = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"},
	},

    HELP =
    {
        SCROLLBACK = "Scroll Up",
        SCROLLFWD = "Scroll Down",
        PREVVALUE = "Previous Value",
        NEXTVALUE = "Next Value",
		CHANGEVALUE = "Change Value",
        REVERT = "Revert Changes",
        ACCEPT = "Accept Changes",
        APPLY = "Apply",
        SELECT = "Select",
        BACK = "Back",
        CHANGECHARACTER = "Change Character",
        PREVPAGE = "Prev. Page",
        NEXTPAGE = "Next Page",
        PREV = "Previous",
        NEXT = "Next",
        CHANGEPAGE = "Change Page",
        ROTATE_LEFT = "Rotate Left",
        ROTATE_RIGHT = "Rotate Right",
        ZOOM_IN = "Zoom In",
        ZOOM_OUT = "Zoom Out",
        TOGGLE = "Toggle",
        RANDOM = "Random",
        CONFIGURE = "Configure",
        SAVEPRESET = "Save Preset",
        SCROLL = "Scroll",
        ENTER_TEXT = "Enter Text",
        CHANGE_TEXT = "Change Text",
        CHANGE_TAB = "Change Tab",
        SHOWCHAT = "Show the Chat Tab",
        SHOWPLAYERS = "Show the Players Tab",
        VIEWGROUP = "View Group Page",
        SERVERACTIONS = "More Server Actions",
        CANCEL = "Cancel",
        CLOSE = "Close",
		CHANGE_MESSAGE = "Change Message",
    },

    BOAT =
    {
        HEALTH = "Boat Health: ",
    },

    CHARACTERSELECT =
    {
        SELECT = "Select",
        APPLY = "Apply",
        CANCEL = "Cancel",
        DISCONNECT = "Disconnect",
    },

    CRAFTING =
    {
        PLACE = "Place",
        BUILD = "Build",
        PROTOTYPE = "Prototype",
        RESEARCH = "Research",
		CRAFT_INGREDIENT = "Craft Ingredient",
		PROTOTYPE_INGREDIENT = "Prototype Ingredient",
        GAMEPAUSED = "Unpause the game to craft this.",
        TABACTION =
        {
            CARTOGRAPHY = "Scribe",
            SCULPTING = "Create",
            ORPHANAGE = "Adopt",
            PERDOFFERING = "Offer",
			CARNIVAL_PRIZESHOP = "Purchase",
            CARNIVAL_HOSTSHOP = "Purchase",
			QUAGMIRE_MEALINGSTONE = "Grind",
			QUAGMIRE_TRADER_ELDER = "Trade",
			QUAGMIRE_TRADER_MERM1 = "Purchase",
			QUAGMIRE_TRADER_MERM2 = "Purchase",
			QUAGMIRE_TRADER_MUM = "Purchase",
			QUAGMIRE_TRADER_KID = "Purchase",
			MADSCIENCE = "Mix",
			RABBITKINGSHOP = "Trade",
			WANDERINGTRADERSHOP = "Trade",
        },
		RECIPEACTION =
		{
            SOCKET = "Socket",
            CARTOGRAPHY = "Scribe",
            SCULPTING = "Create",
            ORPHANAGE = "Adopt",
            PERDOFFERING = "Offer",
			CARNIVAL_PRIZESHOP = "Purchase",
            CARNIVAL_HOSTSHOP = "Purchase",
			MADSCIENCE = "Mix",
			COOK = "Cook",
			GROW = "Grow",
			TRANSFORM = "Transform",
			RABBITKINGSHOP = "Trade",
			WANDERINGTRADERSHOP = "Trade",
            HERMITCRABSHOP = "Trade",
		},
        TABNEEDSTUFF =
        {
            QUAGMIRE_MEALINGSTONE = "Find ingredients \nto grind!",
            QUAGMIRE_TRADER_ELDER = "Find materials \nto trade!",
            QUAGMIRE_TRADER_MERM1 = "Earn coins to trade!",
            QUAGMIRE_TRADER_MERM2 = "Earn coins to trade!",
            QUAGMIRE_TRADER_MUM = "Earn coins to trade!",
            QUAGMIRE_TRADER_KID = "Earn coins to trade!",
        },
		NEEDSCHARACTER = "Another survivor knows how to craft this.",
        NEEDSCHARACTERSKILL = "You do not have the Skill to craft this.",
		-- based on TUNING.PROTOTYPER_TREES
        NEEDSTUFF = "Find ingredients \nto craft!",
        NEEDSTUFF_PROTOTYPE = "Find ingredients \nto prototype!",
        NEEDSCIENCEMACHINE = "Use a Science Machine to build a prototype!",
        NEEDALCHEMYENGINE = "Use an Alchemy Engine to build a prototype!",
        NEEDSHADOWMANIPULATOR = "Use a Shadow Manipulator to build a prototype!",
        NEEDPRESTIHATITATOR = "Use a Prestihatitator to build a prototype!",
		NEEDSANCIENTALTAR_LOW = "Find an ancient structure to craft this at.",
        NEEDSANCIENT_FOUR = "Find a fully intact ancient structure to craft this at.",
        NEEDSTECH =
        {
            SCULPTING = "Put refined stone on the wheel to create a sculpture!",
        },
        NEEDCARNIVAL_HOSTSHOP_PLAZA = "Purchase the Cawnival Sapling to unlock!",
        NEEDSSPIDERFRIENDSHIP = "Make friends with spiders to learn a recipe!",
        NEEDSFISHING = "Use a Tackle Receptacle to build a prototype!",
        NEEDSTURFCRAFTING = "Use a Terra Firma Tamper to build a prototype!",
        NEEDSCRITTERLAB = "Find the Rock Den to adopt this!",
        NEEDSSEAFARING_STATION = "Use a Think Tank to build a prototype!",
        NEEDSFOODPROCESSING = "Make a Portable Grinding Mill to get cooking!",
        NEEDSHERMITCRABSHOP_L1 = "Find someone friendly enough to make this trade!",
        NEEDSHERMITCRABSHOP_L2 = "Find someone friendly enough to make this trade!",
        NEEDSHERMITCRABSHOP_L3 = "Find someone friendly enough to make this trade!",
        NEEDSHERMITCRABSHOP_L4 = "Find someone friendly enough to make this trade!",
        NEEDSHERMITCRABHELP_CRAFTING = "Find someone friendly enough to help you craft this!", -- This is for the case of relocation kit and shellweaver where it's not a trade, she's showing you how to make it.
        NEEDSSHELLWEAVER_L1 = "Can only be crafted at a Combriner.",
        NEEDSSHELLWEAVER_L2 = "Can only be crafted at a Combriner.",
        NEEDSHERMITCRAB_TEASHOP = "Find someone friendly enough to brew this drink!",
        NEEDSRABBITKINGSHOP = "Seek out the Rabbit King to make this trade!",
        NEEDSWANDERINGTRADERSHOP = "Seek out the Wandering Trader to make this trade!",
        NEEDSWAGPUNK_WORKSTATION = "Can only be crafted at a Notional Fabricator.",
        NEEDSCREATURESCANNING = "Scan living creatures to collect data!",
        NEEDSSKILL = "Learn new skills.",
        NEEDSBOOKSTATION = "Build a bookcase to craft your books.",
        NEEDSLUNARFORGING_TWO = "Can only be forged at a Brightsmithy.",
        NEEDSSHADOWFORGING_TWO = "Can only be crafted at a Shadowcraft Plinth.",
        NEEDSCARPENTRY_TWO = "Use a Sawhorse to build a prototype!",
        NEEDSCARPENTRY_THREE = "Use a Sawhorse with a strong blade to build a prototype!",
        NEEDSCELESTIAL_ONE = "Find a small source of lunar energy to craft this at.",
        NEEDSCELESTIAL_THREE = "Find a big source of lunar energy to craft this at.",
        NEEDSCARTOGRAPHYDESK = "Use a Cartography Desk to write this.",

		NEEDSYOTG = "Available during Year of the Gobbler!",
		NEEDSYOTV = "Available during Year of the Varg!",
		NEEDSYOTP = "Available during Year of the Pig King!",
		NEEDSYOTC = "Available during Year of the Carrat!",
		NEEDSYOTB = "Available during Year of the Beefalo!",
		NEEDSYOTCATCOON = "Available during Year of the Catcoon!",
        NEEDSYOTR = "Available during Year of the Bunnyman!",
		NEEDSHALLOWED_NIGHTS = "Available during Hallowed Nights!",
		NEEDSWINTERS_FEAST = "Available during Winter's Feast!",
        NEEDSYOTD = "Available during Year of the Dragonfly!",
        NEEDSYOTS = "Available during Year of the Depths Worm!",

        NEEDSPERDSHRINE = "Make an offering at the Gobbler Shrine!",
        NEEDSWARGSHRINE = "Make an offering at the Varg Shrine!",
        NEEDSPIGSHRINE = "Make an offering at the Pig Shrine!",
        NEEDSCARRATSHRINE = "Make an offering at the Carrat Shrine!",
        NEEDSBEEFSHRINE = "Make an offering at the Beefalo Shrine!",
        NEEDSCATCOONSHRINE = "Make an offering at the Catcoon Shrine!",
        NEEDSRABBITSHRINE = "Make an offering at the Bunnyman Shrine!",
        NEEDSDRAGONSHRINE = "Make an offering at the Dragonfly Shrine",
        NEEDSWORMSHRINE = "Make an offering at the Depths Worm Shrine!",
        NEEDSMADSCIENCE = "Brew at the Mad Scientist Lab!",
		NEEDSWINTERSFEASTCOOKING = "Cook this festive meal in the Masonry Oven!",
        NEEDSCARNIVAL_PRIZESHOP = "Purchase at the Cawnival's Prize Booth!",
        NEEDSCARNIVAL_HOSTSHOP_WANDER = "Find Corvus Goodfeather during the Cawnival!",
        NEEDSCARNIVAL_HOSTSHOP_PLAZA = "Decorate a Cawnival Tree during the Cawnival!",

        CANTRESEARCH = "Some things must be discovered on your own.",
        LIMITEDAMOUNTFMT = "{name} ({number} available)",
        DEFAULT = "Classic",
    },

    NEW_CONTROLSCHEME_POPUP = 
    {
        TITLE = "Playing with controller?",
        BODY = "The game supports multiple control schemes for playing with controller. Would you like to see them and select one?",
        XB1_TITLE = "Playing with gamepad?",
        XB1_BODY = "The game supports multiple control schemes for playing with gamepad. Would you like to see them and select one?",
        YES = "Show me!",
        NO = "No thanks",
    },

    CREDITS =
    {
        TITLE = "CREDITS",
        NAMES =
        {
            "Kevin Forbes",
            "Ju-Lian Kwan",
            "Jamie Cheng",
            "Alia McCutcheon",
            "Tatham Johnson",
            "Graham Jans",
            "Brook Miles",
            "Bryce Doig",
            "Charles Bostik",
            "Wade Lindley",
            "Joe Wreggelsworth",
            "Corey Rollins",
            "Matthew Marteinsson",
            "Jason Garner",
            "Vince de Vera",
            "Jeff Agala",
            "Alex Savin",
            "Sloth Trakhtenberg",
            "Kelly Graham",
            "Allan Cortez",
            "Aaron Bouthillier",
            "David Forsey",
            "Kaj Eijlers",
            "Jan Hutchings",
            "Seth Rosen",
            "Johann Seidenz",
            "Paul Ku",
            "Vito Sze",
            "Mark Laprairie",
            "Peter Andrews",
            "Mike Bell",
            "Nabie-Ah Yousuf",
            "Elizabeth Gordon",
            "Nana Fujino",
            "Toni Zhang",
            "Quentin Proust",
            "Hugo Moraleida",
            "Kris Fortune",
            "James Lantz",
            "Jason Dreger",
            "Kristin Ruff-Frederickson",
            "Dany Gagnon",
            "May Wa Leng",
            "Will Turnbull",
            "Michael Rodriguez",
            "Ragnar Guidote",
            "Erica Pitt",
            "David Briscoe",
            "Justin Liew",
            "Ricardo Pinto",
            "Steven Erenst",
            "Corey McDaniel",
            "Xiaowen Lin",
            "Leira Zamfirescu",
            "Scott Hansen",
			"Philippe Donati",
			"Yorman Arias",
			"Grace Kim",
			"Steven Miclette",
			"Felix Hard",
            "Jen Davreux",
            "Steph Mahoney",
            "Anne-Marie Cyr",
            "Matthew Barry",
            "Zachary Lockwood",
            "Andy Niles",
			"Auday Hussein",
            "Jesse Blackston",
            "Jeddy Zhang",
            "Sarig Poyyara",
            "Yan Fisch",
            "Marcus Lo",
            "Jordan Krahn",
            "Daniel MacGregor",
            "Anita Ho",
            "Janis Osenenko",
            "Dave Downes",
            "Sun Chung",
            "Andrea Alcaraz",
            "Ian Bartolo",
            "Emmett Hall",
            "Margaret Lu",
            "Kial Natale",
            "Daniel Yu",
            "Elaine Chen",
            "Diogo Webber",
            "Chris Chan",
            "Rich Talmey",
            "Jayson Thiessen",
            "Amanda Wong",
            "Kent Reimer",
            "Garnet (G50) Syberg-Olsen",
            "Omar Al-Saadi",
        },

        ALTGAMES =
        {
            TITLE = "Linux and OSX ports by Alternative Games",
            NAMES =
            {
                "Turo Lamminen",
                "Tuomas Narvainen",
                "Tapio Honkonen",
            },
        },

        THANKYOU = "Thank you!",
        EXTRA_THANKS = "Ophir Lupu\nKo Kim\nColt McAnlis",
        EXTRA_THANKS_2 = "Pieter Wycoff\nMatthew Nickerson\nAnna Sweet",
        SONY_THANKS = "Shane Bettenhausen\nAdam Boyes\nBrian Silva\nNick Suttner\nAlessandro Bovenzi",
        XB1_THANKS = "Rick Ryan\nVictor Castano\nAngela Savarese\nNick Bodenham",

        BLIT =
        {
            TITLE = "Xbox One port by BlitWorks",
            NAMES =
            {
                "Tony Cabello",
                "Jorge Cabezas",
                "Miguel Angel Horna",
            },
            NAMES2 =
            {
                "Roc Ramon",
                "Sergi Díaz",
                "Cesar Sánchez"
            }
        },

        LOLLI =
        {
            TITLE = "Xbox One QA by Lollipop Robot",
            NAMES =
            {
                "Daniel Segarra",
                "Óscar Navalón",
            },
            NAMES2 =
            {
                "Pablo Granada",
                "Luis Moyano",
                "Francesc Sánchez"
            }
        },

        BABEL =
        {
            TITLE = "Babel",
            NAMES1 =
            {
                "Chris Wylie",
                "Alexander Stokes",
                "Yubing Hu",
                "William Rapone",
                "Steve Desroches",
            },
            NAMES2 =
            {
                "Israel Aubin",
                "Cedric Picard",
                "Mike Holdaway",
                "Norman Fong",
        	},
        },
        THANKS = "And a very special thanks to all our supporters who braved the challenge of the \"Early-Access\nBeta\". You are too numerous to name - our amazing moderators, the wonderful artists, musicians,\nlivestreamers, to all who made a Let's Play video and everybody who chimed in to let us know\nexactly what you think. Your encouragement, passion and support has been amazing.\n\nDon't Starve Together is truly a better game because of all of you.",

        FMOD = "FMOD Sound System,\nCopyright Firelight Technologies",

        VMEM = "Powered by VMem\nby PureDev Software",	-- only for PS4

        FACEBOOK = "The Facebooks",
        TWITTER = "The Twitters",
    },

    WORLDGEN =
    {
        TITLE = "GENERATING WORLD",
        CAVETITLE = "CARVING OUT CAVE",
        VERBS =
        {
            "Wrangling",
            "Generating",
            "Herding",
            "Embiggening",
            "Iterating upon",
            "Insinuating",
            "Reticulating",
            "Inserting",
            "Framing",
            "Crafting",
            "Imbuing",
            "Randomizing",
            "Redecorating",
            "Sprucing up",
            "Manifesting",
            "Summoning",
            "Compiling",
            "Building",
            "Spawning",
            "Rendering",
            "Enchanting",
            "Solving",
        },
        NOUNS =
        {
            "trees...",
            "pathos...",
            "pines...",
            "spiders...",
            "monsters...",
            "a keen sense of despair...",
            "Wilson's beard...",
            "Maxwell's pocket squares...",
            "Wendy's pigtails...",
            "Abigail's ectoplasm...",
            "Webber's fur...",
            "Wolfgang's moustache...",
            "Wickerbottom's glasses...",
            "Wigfrid's umlauts...",
            "Willow's teddy bear...",
            "Woodie's plaid...",
            "WX-78's gears...",
            "Winona's tools...",
            "Wortox's hooves...",
            "Wormwood's leaves...",
            "Warly's spices...",
            "Walter's Pioneer badges...",
            "Wanda's timeline...",
            "Wurt's scales...",
            "Woby's tail wag...",

            "a monarch's sorrow...",
            "an inescapable nostalgia...",
            "gold and marble...",
            "thorns...",
            "unbreakable bonds...",
            "intense friendship...",
            "common goals...",
            "a comforting togetherness...",
            "buckets and buckets of loot...",
            "game theory...",
            "poignant tragedy...",
            "a hint of shadow...",
            "food...",
            "lovely roses...",
            "gems...",
            "souls...",
            "unspeakable things...",
            "primal instincts...",
            "terrible darkness...",
            "a touch of magic...",
            "unknowable machinations...",
            "plot thickeners...",
            "the \"moon\"...",
            "a sliver of hope...",
            "dramatic irony...",
            "curious mechanisms...",
            "unforeseen consequences...",
        },
    },

    INTENTION =
    {
        SOCIAL = "Social",
        COOPERATIVE = "Cooperative",
        COMPETITIVE = "Competitive",
        MADNESS = "Madness",
        ANY = "Any",
    },

	PLAYSTYLE_ANY = "Any",

    CONSOLESCREEN =
    {
        REMOTEEXECUTE = "Remote:",
        LOCALEXECUTE = "Local:",
    },

    BUGREPORTSCREEN = {
        YES = "Yes",
        NO = "No",
        OK = "OK",

        SUBMIT_SUCCESS_TITLE = "Success",
        SUBMIT_SUCCESS = "Files successfully uploaded. Thanks for the report!",

        SUBMIT_FAILURE_TITLE = "Error",
        SUBMIT_FAILURE_TEXT = "There was a problem uploading your files.",

        DESCRIPTION_LABEL = "Please describe your issue.",
        SUBMIT = "Submit",
        SUBMITTING_TEXT = "Submitting files, please wait",

        SUBMIT_DIALOG_HEADER = "Submit Bug Report?",
        SUBMIT_DIALOG_BODY = "Submitting a bug report will upload your game information and saved worlds to Klei to help us analyze the issue.\n\nThis may take several minutes.",
        SUBMIT_TEXT_PLACEHOLDER = "Please enter a description of the bug you are experiencing and any details that you feel may aid us in fixing it.",

        CANCEL_SUBMIT_HEADER = "Cancel Bug Report?",
        CANCEL_SUBMIT_BODY = "You have not submitted your report.\nAre you sure you want to cancel?",

        ENTER_BUG_DESCRIPTION = "Enter Bug Description",
        CHANGE_BUG_DESCRIPTION = "Change Bug Description",
    },

    EMAILSCREEN =
    {
        SIGNUPSUBMITTITLE="Sending...",
        SIGNUPSUBMIT="Please wait a moment while we sign you up.",
        SIGNUPSUCCESSTITLE="Success!",
        SIGNUPSUCCESS="Thanks for signing up! You should receive a confirmation email in your inbox.",
        SIGNUPFAILTITLE="Something Went Wrong",
        SIGNUPFAIL="Looks like we had some trouble signing you up. Please try again later if you don't receive a confirmation email.",
        INVALIDEMAILTITLE= "Invalid Email",
        INVALIDEMAIL= "If you don't enter your email address, we won't be able to tell you about new stuff!",
        INVALIDDATETITLE= "Invalid Date",
        INVALIDDATE= "We need to know your birthdate in order to send age appropriate updates!",
        OK = "Ok",
        SUBSCRIBE = "Subscribe",
        CANCEL = "Cancel",
        TITLE = "Keep me updated with Don't Starve news",
        EMAIL = "Email:",
        BIRTHDAY = "Birthdate:",
        BIRTHDAYREASON = "We need to know your birthdate in order to send age appropriate updates!\nDon't worry, we won't spam you or sell your information.",
        JAN="Jan",
        FEB="Feb",
        MAR="Mar",
        APR="Apr",
        MAY="May",
        JUN="Jun",
        JUL="Jul",
        AUG="Aug",
        SEP="Sep",
        OCT="Oct",
        NOV="Nov",
        DEC="Dec",
        MONTH = "M",
        DAY = "D",
        YEAR = "YYYY",
    },

    MAINSCREEN =
    {
        NOTIFY = "News",
        FORUM = "Forum",
        ISSUE = "Report an Issue",
        GETHELP = "Get More Help",
        BUYNOW = "Buy Now",
        BUYDONTSTARVEMAIN = "Buy Don't Starve",
        GIFT = "Send Gift",
        MODTITLE = "Mods Installed!",
        MODDETAIL = "Installed mods: ",
        NEWMODDETAIL = "Newly installed mods: ",
        NEWMODDETAIL2 = "Enable these mods from the main menu.",
        MODDETAIL2 = "Klei is not able to help you should issues arise while using mods. Use with caution!",
        FORCEMODDETAIL = "You are force loading these mods from modsettings.lua. They will always be enabled:",
        FAILEDMODS = "The following mods failed to run last time and have been disabled: ",
        MODFAILTITLE = "WARNING!",
        MODFAILDETAIL = "The following mod(s) have caused a failure:",
        MODFAILDETAIL2 = "The mod will be disabled, re-enable it from the mods menu.",
        MODQUIT = "Disable Mods",
        MODFORUMS = "Mod Forums",
        MODSBADTITLE = "All Mods Disabled",
        MODSBADLOAD = "The game did not start correctly last time. This was likely caused by a mod, so all client mods have been disabled.\n\nYou can try re-enabling mods from the mod settings screen.",
        MODFORUMS_NOT_AVAILABLE_YET = "Not available yet",
        MODS = "Mods",
        ACKNOWLEDGEWARNING = "Don't Show This Again.",
        SCRIPTERRORRESTART = "Reload Save",
        SCRIPTERRORQUIT = "Exit Game",
        SCRIPTERROR_DEBUG = "Debug Console",
        SCRIPTERRORMODWARNING = "This error may have occurred due to a mod you have enabled!\nYou have the following mods enabled:\n",
        TESTING = "This is the testing branch!",
        TESTINGDETAIL = "You may encounter bugs or broken features, and you may lose your saved game when we update. Please report all problems in the forum.",
        TESTINGNO = "No, thank you!",
        TESTINGYES = "I understand.",
        CONTINUE = "Continue",
        DELETE = "Delete",
        RESTART = "Restart",
        NEWADVENTURE_WARN = "The new adventure system is currently in active development and is provided for testing purposes only. It will probably contain bugs.",
        NEWADVENTURE = "Adventure (TEST)",
        NEWFREEPLAY = "Sandbox",
        NEWFREEPLAYCUSTOM = "Sandbox (Custom)",
        NEWGAMESHORT = "Empty",
        UNKNOWNGAME = "Unknown",
        NEWGAMETYPE = "What kind of game would you like to play?",
        SLOTACTION = "What would you like to do?",
        ADVENTURE = "Adventure",
        FREEPLAY = "Sandbox",
        SLOT = "Game Slot",
        SLOT_1 = "1",
        SLOT_2 = "2",
        SLOT_3 = "3",
        SLOT_4 = "4",
        IMPORT = "Import",
        CANCEL = "Cancel",
        BACK = "Back",
        SETTINGS = "Settings",
        OPTIONS = "Options",
        REGISTER_SECOND_PLAYER = "Split Screen",
        PLAYDEMO = "Play Demo",
        ENTERPRODUCTKEY = "Enter Key",
        ENTERKEY = "Enter New Key",
        RESETPROFILE = "Reset profile!",
        UNLOCKEVERYTHING = "Unlock Everything",
        SURE = "Are you sure?",
        YES = "Yes",
        NO = "No",
        CHEATS = "Cheats",
        BROADCASTING = "Broadcasting",
        PLAY = "Play!",
        PLAYMP = "Play Online!",
        MULTIPLAYER = "Multiplayer",
        HOST = "Host Game",
        HOSTCHAR = "Host (CharSelect)",
        JOIN = "Join IP",
        JOIN_PLAY_TEST = "Join Playtest",
        JOINCHAR = "Join (CharSelect)",
        FESTIVALEVENT =
        {
            LAVAARENA = "Enter the Forge",
            QUAGMIRE = "Enter the Gorge",
        },
        QUICKJOIN = "Quick Join",
        SPLITSCREEN = "Split Screen",

        BROWSE = "Browse Games",
        CREATE = "Host Game",
        COMPENDIUM = "Compendium",
        GAMEWIZARD = "Game Wizard",
        SKINS = "Curio Cabinet",
        MYSTERYBOX = "Treasury",
        RATE = "Rate This Game",
        ACCOUNTINFO = "Account Info",
        VISITFORUM = "Visit Forum",
        MOREGAMES = "Games",
        CHOOSEDIR = "Don't Starve Game Data",
        IMPORTSUCCESS = "Success",
        IMPORTSUCCESSDESC = "Data was imported successfully.",
        OK = "OK",
        IMPORTFAIL = "Failed to load",
        GREETING = "Hi ",
        NEWWORLD = "Create a new world!",
        NEWWORLDDESC = "This will erase your current world and any saved games in it. Continue?",
        RESETGAMEDESC = "This will reset your current world. Continue?",
        NEWGAMEDESC = "This will erase your current save. Continue?",
        ADVGAMEDESC = "NOTE: This mode is still under development.\n\nFor experienced players only!\n\nYou've decided to bring the fight to Maxwell.\nCan you survive the increasingly harsh conditions he's created, and beat him at his own game?",
        NEWGAME = "Start a new game!",
        NEWGO = "Let's Go!",
        ASKQUIT = "Quit Game?",
        ASKQUITDESC = "Charlie will miss you.",
        QUIT = "Quit",

        DYNAMICCONTENT_TITLE = "Dynamic Content",
        DYNAMICCONTENT_DESC = "Due to an error, dynamic content loading has been disabled.",
        DYNAMICCONTENT_RE_ENABLE = "Re-enable",
        DYNAMICCONTENT_OK = "I understand",
		DYNAMICCONTENT_DISABLE = "Disable Dynamic Content",
		DYNAMICCONTENT_ENABLE = "Enable Dynamic Content",
		DYNAMICCONTENT_CLEAR = "Clear Dynamic Content",

        FRESHBUILD = "Fresh Build!",
        UPDATERELEASED = "Now Playing:",
        LASTBUILDDAYS = "Last build %d days ago",
        NEXTBUILDIMMINENT = "Next build imminent!",
        NEXTUPDATEDAYS = "Next Update: %d days!",
        BETA_LABEL = "The Gorge Event",

        EVENT_UPDATEDAYS = "Starts in %d days!",
        EVENT_UPDATEDAY = "Starts in 1 day!",
        EVENT_IMMINENT = "Update imminent!",

        MOTDTITLE = "Klei Store",
        MOTD = "Check out the latest items in the Klei Store!",
        MOTDBUTTON = "Klei Store",

		MOTD_SYNCING = "Syncing Notifications",
		MOTD_SYNCING_FAILED = "Unable to download notifications.",
		MOTD_DOWNLOADING_IMAGE = "Downloading Image",
        MOTD_ALERT_DETAILS = "View Details",
        MOTD_NEW_UPDATE = "A new update is available\nPlease update to the latest version",
		MOTD_NEW_ANNOUNCEMENT = "New!",
		MOTD_SALE_ANNOUNCEMENT = "Sale!",

        EXIT = "Exit",
        LOGOUT = "Log Out",
        REDEEM = "Redeem",
        SAVE_LOCATION = "Data",
        MOVIE = "Theatre",
        CREDITS = "Credits",
        UPDATENAME = "All's Well That Maxwell",
        DLC_UPDATENAME = "Where There's a Wilson...",
        DST_UPDATENAME = "Release",
        DST_FORGE_BETA_UPDATENAME = "The Forge Beta (v{version})",
        CONTROLS = "Controls",

        LATER = "Not Now",
        ADJUST_DISPLAY_HEADER = "Adjust Display Area",
        ADJUST_DISPLAY_TEXT = "Parts of the game may be cut off by the edges of your screen. Do you want to check your display area now? If not, you can do this later in Settings.",
        ADJUST_DISPLAY_INSTRUCTIONS = "Adjust display area using <up> and <down> to the maximum screen size\nso all arrows are fully visible.\n\nPress <A> to accept the changes.",

        CANT_LOAD_TITLE = "Load Failed",
        CANT_LOAD_ROG = "Reign of Giants is not installed. Unable to load.",

		MAINBANNER_ROT_BETA_TITLE = "Beta Build", --unused now.
		MAINBANNER_BETA_TITLE = "Beta Branch", --"Winter's Feast - Beta Branch", -- "Title/nBeta Branch"

        CONSOLE_EDITION_TEXT = "Console Edition",

        FAMILY_SHARED = "Family Sharing",

        FAILED_INVENTORY_TITLE = "Inventory Download Failed",
        FAILED_INVENTORY_BODY = "Unfortunately your Item Collection failed to complete downloading. Would you like to continue without your collection?",
        FAILED_INVENTORY_YES = "Yes",
        FAILED_INVENTORY_NO = "No",

        PLAYER2_NOT_ONLINE = "Player 2 Offline",
        PLAYER2_NOT_ONLINE_DESC = "Player 2 is currently offline. If player 2 is not using an online account, please switch player 2 to an online account and try again.",
        INVITED_USER_NOT_LOGGED_IN = "Not Logged In",
        INVITED_USER_NOT_LOGGED_IN_DESC = "The invited user is not logged in. Please log in as the invited user and accept the invite again to join.",

        OFFLINE = "Offline",
        OFFLINEMODE = "Connection to Klei Failed",
        OFFLINEMODEDESC = "Could not connect to Klei's servers. Characters and worlds from online games will be unavailable. Continue and play offline?",
        WEGAMEOFFLINEMODE = "Connection to WeGame Failed",
        WEGAMEFFLINEMODEDESC = "Couldn't connect to WeGame (scheduled maintenance or connectivity issues). Characters and worlds from online games will be unavailable. Play offline?",
        STEAMOFFLINEMODE = "Connection to Steam Failed",
        STEAMOFFLINEMODEDESC = "Couldn't connect to Steam (scheduled maintenance or connectivity issues). Characters and worlds from online games will be unavailable. Play offline?",
        PSN_OFFLINEMODE = "Connection to "..STRINGS.PSN.." failed",
        PSN_OFFLINEMODEDESC = "Couldn't connect to "..STRINGS.PSN.." (scheduled maintenance or connectivity issues). Characters and worlds from online games will be unavailable. Play offline?",
        NOT_SIGNED_IN_TO_PSN = "Not Signed In to "..STRINGS.PSN.."",
        NOT_SIGNED_IN_TO_PSN_DESC = "You are not signed in to "..STRINGS.PSN..". Characters and worlds from online games will be unavailable. Play offline?",
        NO_INTERNET_CONNECTION = "No internet connection",
        NO_INTERNET_CONNECTION_DESC = "Could not connect to the internet. Characters and worlds from online games will be unavailable. Play offline?",
        NO_PS_PLUS_MEMBERSHIP = "PlayStation®Plus",
        NO_PS_PLUS_MEMBERSHIP_DESC = "Online play requires an active PlayStation®Plus membership.\nCharacters and worlds from online games will be unavailable. Play offline?",
        PLAYOFFLINE = "Play Offline",
        CANCELOFFLINE = "Cancel",
		ONLINE_AGE_RESTRICTION_TITLE = "Online Age Restriction",
		ONLINE_AGE_RESTRICTION_DESC = "You do not meet the age requirement to play online. Characters and worlds from online games will be unavailable.",

		ONLINE_UGC_RESTRICTION_TITLE = "User-Generated Media Restriction",
		ONLINE_UGC_RESTRICTION_DESC = "Online play is disabled due to parental control settings for your account. Characters and worlds from online games will be unavailable.",

        VERSION_OUT_OF_DATE_TITLE = "Version Out of Date",
        VERSION_OUT_OF_DATE_BODY = "Your game looks like it's running an old version. We recommend that you update to the latest version.",
        VERSION_OUT_OF_DATE_PLAY = "Play Anyway",
        VERSION_OUT_OF_DATE_INSTRUCTIONS = "Instructions",
        VERSION_OUT_OF_DATE_CANCEL = "Cancel",

        BAD_HASHES_TITLE = "Game Files Hash Mismatch",
        BAD_HASHES_BODY = "Your game data files look corrupted. We recommend that you run your platform's file validation routines.",
        BAD_HASHES_PLAY = "Play Anyway",
        BAD_HASHES_INSTRUCTIONS = "Instructions",

        CONTROLLER_DETECTED_HEADER = "Controller Detected",
        CONTROLLER_DETECTED_BODY = "Do you want to play Don't Starve Together with a controller?\nYou won't be asked again, but you can revert your settings in the Controls screen of the Option menu if you change your mind.",
        ENABLECONTROLLER = "Enable Controller",
        DISABLECONTROLLER = "Disable Controller",

        NEWUSER_DETECTED_HEADER = "New to Don't Starve?",
        NEWUSER_DETECTED_BODY = "You might want to explore on your own for a bit and get a feel for things. Would you like to host your own private game first?",
        NEWUSER_NO = "No, Browse Games",
        NEWUSER_NO_QUICKJOIN = "No, Quick Join",
        NEWUSER_YES = "Yes, Host Game",

        VERSION_YOURS = "Your Version: %s",
        VERSION_LATEST = "Latest Version: %s",
        VERSION_CHECKING = "Checking for update",
        VERSION_UPTODATE = "Up to date!",
        VERSION_NOTUPTODATE = "Update required!",
        VERSION_MOREINFO = "Instructions",
        VERSION_ERROR = "Problem checking for latest version",

        TOOLTIP_FESTIVALEVENT =
        {
            LAVAARENA = "Challenge Battlemaster Pugna's warriors in this limited-time event!",
            QUAGMIRE = "Prepare offerings for the Altar of Gnaw in this limited-time event!",
        },
        TOOLTIP_BROWSE = "Browse all servers",
        TOOLTIP_QUICKJOIN = "Jump in and start playing",
        TOOLTIP_HOST = "Start your own server",
        TOOLTIP_WIZARD = "Let us help you drill down the list of servers",
        TOOLTIP_MODS = "Customize your game",
        TOOLTIP_PLAYERSUMMARY = "Equip curios, craft items and view player history",
		TOOLTIP_COMPENDIUM = "A summary of your adventures",
        TOOLTIP_OPTIONS = "Change your settings and controls",
        TOOLTIP_OPTIONS_PS4 = "Change your settings and view the controls",
        TOOLTIP_QUIT = "Scram!",
		TOOLTIP_CREDITS = "See who made the game",
		TOOLTIP_LOGOUT = "Log out so you can log back in again",

        ITEMCOLLECTION_DISABLE = "You must be logged in to view your Profile or Item Collection.",
		STORE_DISABLE = "You must be logged in to use the Klei Store.",

        LOGIN = "Login",

        INVITED_AS = "You were invited to join a game as %s"
    },

    XB1_USER_DIALOG =
    {
        MAIN_CONTROLLER_DISCONNECTED = "Main controller disconnected.",
        CONTROLLER_2_DISCONNECTED = "Player 2's controller disconnected",
        PRESS_A_ON_NEW = "Press A on a new one to continue.",
        PRESS_A_TO_SWAP_USER = "Press A to connect as the main user.",
        USER_1_CHANGED = "Main profile changed",
        USER_2_CHANGED = "Player 2's profile changed",
        SIGN_IN_TO_CONTINUE = "You must sign in again to continue.",
        SIGN_IN = "Sign In",
        USER_2_MUST_BE_DIFFERENT = "Player 2's profile must be\ndifferent from Player 1's.",
        USER_2_HAS_TO_REJOIN = "Player 2 will need to join the game again."
    },

	SPLITSCREEN_REGISTRATION =
	{
		KICK_PLAYER_PREFIX = "Kick ",
		KICK_PLAYER_POSTFIX = " from split screen",
		TITLE_PLAYER_1 = "Player 1",
		TITLE_PLAYER_2 = "Player 2",
		STATUS_OFFLINE = "Offline",
		STATUS_ONLINE = "Signed In",
		PLAYER_2_PRESS_START_PREFIX = "PRESS",
		PLAYER_2_PRESS_START_POSTFIX = "TO JOIN",

        PLAYER_2_CONTROLLER_DISCONNECTED = "CONTROLLER 2 DISCONNECTED",
        XB1_PLAYER_2_CONTROLLER_DISCONNECTED = "GAMEPAD 2 DISCONNECTED",
    },

    PLANTREGISTRY = {
        TAB_TITLE_PLANTS = "Plants",
        TAB_TITLE_MOD_PLANTS = "Mod Plants",
        TAB_TITLE_FERTILIZERS = "Fertilizers",
        TAB_TITLE_MOD_FERTILIZERS = "Mod Fertilizers",

		ONLINE_DATA_USER_OFFLINE = "Login to retrieve online plant registry data.",
		ONLINE_DATA_DOWNLOAD_FAILED = "Failed to sync online plant registry data.",

        MYSTERY_PLANT = "Unknown Plant",
        NEEDSMORERESEARCH = "Unknown",
        NEEDSPLANTRESEARCH = "Research this plant with the Gardeneer Hat to learn more about it.",

        MYSTERY_FERTILIZER = "Unknown Fertilizer",

        EFFECTS = {
            NONE = "None",
            WEED_FORGETMELOTS = "Has a tendency to come back when dug up.",
			WEED_TILLWEED = "Its roots make a real mess of things, but its flowers are said to have healing properties.",
            WEED_FIRENETTLE = "These nettles can cause quite the burning sensation.",
			WEED_IVY = "Attacks survivors when they disturb a nearby plant",
        },

        DESCRIPTIONS = {
            MISSING = "Unknown",
            ONION = "A ripe onion plant is enough to bring tears of delight to any gardener. -W",
            ASPARAGUS = "Green spears of vegetabley goodness. -W",
            GARLIC = "Cloves of garlic pair well with a nice stake. -W",
            PUMPKIN = "Compared to other gourds, the pumpkin plant squashes the competition. -W",
            CORN = "An a-maize-ingly versatile crop. -W",
            POTATO = "Sturdy, dependable, and loved by moustachioed strongmen. -W",
            DRAGONFRUIT = "Produces a delectable fruit with a striking appearance. -W",
            POMEGRANATE = "Never take the juicy sweetness of a pom for granate. -W",
            EGGPLANT = "Zero percent egg, ninety-nine percent plant. Science has yet to explain the rest. -W",
            TOMATO = "Tomatoes are an excellent source of vitamins, and make for a convenient projectile. -W",
            WATERMELON = "Fifty percent water, fifty percent melon. -W",
            PEPPER = "A hot pepper plant is the perfect thing to spice up your garden. -W",
            DURIAN = "A foul smelling fruit, favored by a certain green swamp dweller. -W",
            CARROT = "The perennial favorite of Bunnymen. -W",
        },

        NUTRIENTS = {
            NUTRIENT_1 = "Growth Formula",
            NUTRIENT_2 = "Compost",
            NUTRIENT_3 = "Manure",
            RESTORE = "Restores ",
            CONSUME = "Consumes ",
            NEUTRAL = "Doesn't affect "
        },

        FARMPLANTS = {
            SEASONS = "Seasons",
            WATER = "Water Consumption",
            NUTRIENTS = "Nutrient Cycling",
            DESCRIPTION = "Field Notes",
            SEED = "Seed",
            PRODUCT = "Product",
        },

        WEEDPLANTS = {
            WATER = "Water Consumption",
            NUTRIENTS = "Nutrient Cycling",
            EFFECTS = "Effects",
            DESCRIPTION = "Description",
            PRODUCT = "Product",
        },

        PLANT_GROWTH_STAGES = {
            SEED = "Seed",
            SPROUT = "Sprout",
            SMALL = "Small",
            MEDIUM = "Medium",
            GROWN = "Grown",
            OVERSIZED = "Giant",
            ROTTING = "Rotting",
            OVERSIZED_ROTTING = "Rotting",
            BOLTING = "Bolting",
            PICKED = "Picked",
            SUMMARY = "Summary",
        },
    },

	COOKBOOK = {
		TAB_TITLE_COOKPOT = "Crock Pot Recipes",
		TAB_TITLE_PORTABLECOOKPOT = "Chef's Specials",
		TAB_TITLE_MOD_RECIPES = "Mod Recipes",

		DISCOVERED_RECIPES = "Recipes Discovered",

		ONLINE_DATA_USER_OFFLINE = "Login to retrieve online cookbook data.",
		ONLINE_DATA_DOWNLOAD_FAILED = "Failed to sync online cookbook data.",

		UNKNOWN_INGREDIENT_NAME = "Unknown Ingredient '{ingredient}'",
		UNKNOWN_FOOD_NAME = "Unknown '{food}'",

		LOCKED_RECIPE =
		{
			cookpot = "Experiment with ingredients in the Crock Pot to discover new recipes and expand your cookbook.",
			portablecookpot = "Experiment with ingredients in Warly's Portable Crock Pot to discover new recipes and expand your cookbook.",
		},

		NO_RECIPES_TITLE = "Recipes",
		NO_RECIPES_DESC = "Experiment with different ingredients to discover a recipe.",

		LOCKED_STATS = "This food requires a taste test to learn more.",
		STAT_UNKNOWN ="?",

		FOOD_EFFECTS_TITLE = "Side Effects",
		FOOD_EFFECTS_NONE = "None",
		FOOD_EFFECTS_HEALTH_REGEN = "Restores health over time",
		FOOD_EFFECTS_HOT_FOOD = "Warms the body",
		FOOD_EFFECTS_COLD_FOOD  = "Cools the body",
		FOOD_EFFECTS_SWAP_HEALTH_AND_SANITY = "Swaps sanity and health",
		FOOD_EFFECTS_ELECTRIC_ATTACK = "Attacks deal electric damage",
		FOOD_EFFECTS_GLOW = "Gives off a healthy glow",
		FOOD_EFFECTS_DRY = "Dissipates moisture",
        FOOD_EFFECTS_SLEEP_RESISTANCE = "Wards off sleep",
        FOOD_EFFECTS_HUNGER_REGEN = "Restores hunger over time",
        FOOD_EFFECTS_DUST_MOTH_FOOD = "Thulecite's secret ingredient",
		FOOD_EFFECTS_SANITY_REGEN = "Restores sanity over time",
		FOOD_EFFECTS_HOT_SANITY_REGEN = "Warms the body and mind",
		FOOD_EFFECTS_BEEFALO = "Treat your Beefalo",
        FOOD_EFFECTS_SLEEP = "Puts one to sleep",

		FOOD_TYPE_TITLE = "Type",
		FOOD_TYPE_UNKNOWN = "?",

		PERISH_RATE_TITLE = "Spoils",
		PERISH_NEVER = "Never",
        PERISH_VERY_QUICKLY = "Very Quickly",
		PERISH_QUICKLY = "Quickly",
		PERISH_AVERAGE = "Average",
		PERISH_SLOWLY = "Slowly",
		PERISH_VERY_SLOWLY = "Very Slowly",

		COOKINGTIME_TITLE = "Cooking Time",
		COOKINGTIME_UNKNOWN = "Unknown",
		COOKINGTIME_SHORT = "Short",
		COOKINGTIME_AVERAGE = "Average",
		COOKINGTIME_LONG = "Long",
		COOKINGTIME_VERY_LONG = "Very Long",

		SORT_SPINNERLABEL = "Sort By",
		SORT_DEFAULT = "Default",
		SORT_ALPHABETICAL = "Alphabetical",
		SORT_HEALTH = "Health",
		SORT_HUNGER = "Hunger",
		SORT_SANITY = "Sanity",
		SORT_SIDE_EFFECTS = "Side Effects",

		FILTER_SPINNERLABEL = "Filter By",
		FILTER_ALL = "All",
		FILTER_MEAT = "Meats",
		FILTER_VEGGIE = "Veggies",
		FILTER_OTHER = "Other",
		FILTER_SIDE_EFFECTS = "Side Effects",
		FILTER_INCOMPLETE = "Incomplete",
	},

	FOOD_TYPES =
	{
		GENERIC = "Edible",
		MEAT = "Meat",
		VEGGIE = "Veggie",
		ELEMENTAL = "Elemental",
		GEARS = "Gears",
		HORRIBLE = "Horrible",
		INSECT = "Insect",
		SEEDS = "Seed",
		BERRY = "Berry",
		RAW = "Raw",
		BURNT = "Burnt",
		ROUGHAGE = "Roughage",
		WOOD = "Wood",
		GOODIES = "Goodies",
		MONSTER = "Monstrous",
	},

	RECIPE_BOOK =
	{
		TITLE = "Recipe Book",
		DISCOVERED_RECIPES = "Discovered Recipes",
		FILTER_ANY = "Any",
		CRAVINGS =
		{
			SNACK = "Snack",
			SOUP = "Soup",
			VEGGIE = "Veggie",
			FISH = "Fish",
			BREAD = "Bread",
			MEAT = "Meat",
			CHEESE = "Cheese",
			PASTA = "Pasta",
			SWEET = "Dessert",
		},
		STATIONS =
		{
			POT = "Cookpot",
			OVEN = "Oven",
			GRILL = "Grill",
		},
		DETAILS_LABEL_TRIBUTE = "Offering",
		DETAILS_LABEL_TRIBUTE_SILVER = "{dish} Offering",
		DETAILS_LABEL_TRIBUTE_SILVER_UNKNOWN = "Silver Dish Offering",
		DETAILS_LABEL_CRAVING = "Satisfies Craving",
		DETAILS_LABEL_CRAVINGS = "Satisfies Cravings",
		DETAILS_LABEL_STATION = "Cooking Station",
		DETAILS_LABEL_STATIONS = "Cooking Stations",
		DETAILS_LABEL_RECIPES = "Recent Recipes",
		DETAILS_SPINNER_CRAVING = "Craving",
		DETAILS_SPINNER_STATION = "Station",
		--DETAILS_SPINNER_TRIBUTE = "Offering",
		NO_TRIBUTE_VALUE = "None",
		TRIBUTE_UNKNOWN = "Unknown",
		NO_CRAVING = "None",
		SYRUP_RECIPE_ID = "**",
		UNKNOWN_RECIPE = "Unknown",
        UNKNOWN_DATA = "???", --used for bad data
	},

	LAVAARENA_COMMUNITY_UNLOCKS =
	{
		TAB_TITLE = "Community Unlocks",
		URL_LABEL = "Community Unlocks & Leaderboards",
		DESCRIPTION = "Contribute to the community's progression by defeating the {boss}.",
		EVERYTHING_UNLOCKED = "The {boss} has arrived. Now you can forge your way to a true victory!",
		UNKNOWN = "Unknown",
		SYNCING_DATA = "Syncing Data...",
        XP_LABEL = "XP",

		LOCKED =
		{
			ITEM = "Locked Item",
			CREATURE = "Locked Creature",
			BOSS = "Locked Creature",
		},

		UNLOCKED_TITLE =
		{
			BOOK_ELEMENTAL = "Tome of Beckoning & Spiral Spear",
			RHINODRILL = "Rhinocebros, Snapback and Flatbrim",
		},

		UNLOCKED_DESC =
		{
			BOOK_ELEMENTAL = "Summon a Magma Golem or divebomb opponents with a powerful Sky Lunge", -- adds: BOOK_ELEMENTAL + SPEAR_LANCE
			LAVAARENA_FIREBOMB = "Bombard your opponents with searing Hearthsfire",
			LAVAARENA_HEAVYBLADE = "Hinder your opponents with the almighty Blacksmith's Edge",
			LAVAARENA_ARMOR_HPDAMAGER = "80% Protection, +50 Max Health,\n+20% Physical Damage",
			LAVAARENA_ARMOR_HPRECHARGER = "80% Protection, +50 Max Health,\n+15% Faster Cooldown",
			LAVAARENA_ARMOR_HPEXTRAHEAVY = "90% Protection, +100 Max Health,\nKnockback Resistance",
			LAVAARENA_ARMOR_HPPETMASTERY = "80% Protection, +75 Max Health, Increases effectiveness of Baby Spiders, Abigail or Bernie",
			BOARRIOR = "Summoned to the arena while defeating the Boarillas",
			RHINODRILL = "Summoned to the arena when the Grand Forge Boarrior is defeated",
			BEETLETAUR = "Summoned to the arena for the final round!",
		},

		AVAILABLE_QUESTS = "Posted Quests",
		DAILY_RESET = "Daily bonuses reset in: {hours}h {minutes}m",
		DAILY_RESET_SOON = "Daily bonuses will reset soon.",
		DAILY_RESET_SOON_INGAME = "Daily bonuses will reset after the next match.",
		QUEST_RESET = "Posting new quests in: {hours}h {minutes}m",
		QUEST_RESET_SOON = "New quests will be posted soon.",
		QUEST_RESET_SOON_INGAME = "New quests will be posted after the next match.",

		QUEST_TYPE_CHARACTER_FMT = "{character}'s {quest_type}",
		QUEST_TYPE_PERSONAL = "Personal Quest",
		QUEST_TYPE_TEAM = "Teamwork Quest",

		COMPLETED_QUESTS_FMT = "{num} Quests Completed",
		DAILY_WINS_FMT = "{num} Daily Victory Bonuses",
		DAILY_MATCHES_FMT = "{num} Daily Match Bonuses",

		QUEST_QUERY_FAILURE = "Failed to retrieve your quests.",
		PROGRESSION_QUERY_FAILURE = "Failed to retrieve community progression data.",
	},

	LAVAARENA_SUMMARY_PANEL =
	{
		TAB_TITLE = "The Forge",
		LAQ_DAILYWIN = "Daily Victory Bonus",
		LAQ_DAILYMATCH = "Daily Match Bonus",
	},

	LAVAARENA_QUESTS_HISTORY_PANEL =
	{
		TAB_TITLE = "Completed Quests",
	},

    HUD =
    {
        MAP = "Show Map\n",
        BUYNOW = "Buy Now",
        READYTITLE = "Ready to play!",
        READY = "How long will you survive?",
        START = "Start",
        CLOCKSURVIVED = "Survived",
        CLOCKDAY = "Day",
        CLOCKDAYS = "Days",
        WORLD_CLOCKDAY = "Day", --deprecated, left here for mods to use
        WORLD_CLOCKDAY_V2 = "Day {day_count}",
        SAVING = "SAVING...",
        WORLD = "World",
        HERE = "here",
        STALE = "Stale",
        STALE_FROZEN = "Melting",
        SPOILED = "Spoiled",
        SPOILED_FROZEN = "Melted",
        WAXED = "Waxed",
        ROTLEFT = "Rotate Left\n",
        ROTRIGHT = "Rotate Right\n",
        PAUSE = "Pause\n",
        INSPECT = "Inspect",
        TAKE = "Take",
        DROP = "Drop",
        SWAP = "Swap",
        EQUIP = "Equip",
        UNEQUIP = "Unequip",
        PUTONE = "Put One",
        GETHALF = "Get Half",
        SELECT = "Select",
        PUT = "Put",
		--ITEM_ACTIONS = "Item Actions",
        DEPLOY = "Deploy",
        BUILD = "Build",
        CANCEL = "Cancel",
        ATTACK = "Attack",
        WHACK = "Whack",
        HUNGRY = "Hungry",
        STARVING = "Starving",
        DEATH_PET_NAME = "%s's %s", --e.g. "Vito's Cat"
        DEATH_ANNOUNCEMENT_1 = "was killed by",
        DEATH_ANNOUNCEMENT_2_MALE = ". He became a spooky ghost!",
        DEATH_ANNOUNCEMENT_2_FEMALE = ". She became a spooky ghost!",
        DEATH_ANNOUNCEMENT_2_ROBOT = ". They became a spooky ghost!",
        DEATH_ANNOUNCEMENT_2_DEFAULT = ". They became a spooky ghost!",
        GHOST_DEATH_ANNOUNCEMENT_MALE = "lost all of his humanity and is gone forever.",
        GHOST_DEATH_ANNOUNCEMENT_FEMALE = "lost all of her humanity and is gone forever.",
        GHOST_DEATH_ANNOUNCEMENT_ROBOT = "lost all of their humanity and is gone forever.",
        GHOST_DEATH_ANNOUNCEMENT_DEFAULT = "lost all of their humanity and is gone forever.",
        REZ_ANNOUNCEMENT = "was resurrected by",
        REPORT_RESULT_ANNOUCEMENT = "Your presence has been noticed.",
        START_AFK = "went away for a bit.",
        STOP_AFK = "has returned from their relaxing time away.",
        AFK_TITLE = "Taking A Breather",
        AFK_BODY = "Make sure to stretch your legs! The deathly wilderness will still be here when you get back.",
        AFK_OK = "Return",
        ACTIVATE_RESURRECTION = "Activate Meat Effigy",
        ACTIVATE_GRAVE_RESURRECTION = "Activate Perennial Altar",
        INSPECT_SELF = "Inspect Self",
        OPENGIFT = "Activate",
        CRITTER_TRAITS =
        {
            COMBAT = "Scrappy",
            WELLFED = "Plump",
            PLAYFUL = "Peppy",
            CRAFTY = "Crafty",
        },
        LOCK_TARGET = "Lock Target",
		UNLOCK_TARGET = "Unlock Target",
		NEXT_TARGET = "Next Target",
        CYCLE_AXIS_ALIGNED_PLACEMENT = "Cycle Grid Size",

        LAVAARENA_WIN_TITLE = "Victory!",
        LAVAARENA_WIN_BODY = "You have bested Battlemaster Pugna's champions in battle.",
        LAVAARENA_LOSE_TITLE = "Defeat!",
        LAVAARENA_LOSE_BODY = "You have failed Battlemaster Pugna's challenge.",

		QUAGMIRE_NOTFICATIONS =
		{
			DISCOVERED = "New Recipe Discovered",
			MADE = "Meal Cooked",
			INGREDIENT_MADE = "Syrup Produced",
			FAILED = "Recipe Failed",
			OVERCOOKED = "Meal Burnt",
			SENT = "Meal Snackrificed",
		},

		RETROFITTING_ANNOUNCEMENT = "World will reload in {time} seconds to complete retrofitting.",
		RETROFITTING_ANNOUNCEMENT_NOW = "World is reloading to complete retrofitting.",

		TROPHYSCALE_PREFAB_OVERRIDE_OWNER =
		{
			catcoon = "A Catcoon",
			merm = "A Merm",
			mermguard = "A Loyal Merm Guard",
			mermking = "The King of the Merms",
			mermhouse = "A family of Merms",
			mermhouse_crafted = "A well-to-do Merm",
			mermthrone = "The King of the Merms",
			crabking = "The Crab King",
		},
		TROPHYSCALE_UNKNOWN_OWNER = "An Unnamed Donor",

        -- Unique adjectives for Infused shards and moongleams
        STALE_POWER = "Waning",
        SPOILED_POWER = "Decayed",
	},

	CRAFTING_FILTERS =
	{
		FAVORITES = "Favorites",
		CRAFTING_STATION = "All Crafting Stations",
		SPECIAL_EVENT = "Special Event",
		MODS = "Modded Items",
		CHARACTER = "Survivor Items",
		TOOLS = "Tools",
		LIGHT = "Light Sources",
		PROTOTYPERS = "Prototypers & Stations",
		REFINE = "Refined Materials",
		WEAPONS = "Weapons",
		ARMOUR = "Armor",
		CLOTHING = "Clothing",
		RESTORATION = "Healing",
		MAGIC = "Magic",
		DECOR = "Decorations",
		STRUCTURES = "Structures",
		CONTAINERS = "Storage Solutions",
		COOKING = "Cooking",
		GARDENING = "Food & Gardening",
		FISHING = "Fishing",
		SEAFARING = "Seafaring",
		RIDING = "Beefalo Riding",
		WINTER = "Winter Items",
		SUMMER = "Summer Items",
		RAIN = "Rain Gear",
		EVERYTHING = "Everything",
	},

	CRAFTING_STATION_FILTERS =
	{
        ANCIENT = "Ancient Pseudoscience",
        ORPHANAGE = "Critters",
        CARTOGRAPHY = "Cartography",
        SCULPTING = "Sculptures",
		CELESTIAL = "Celestial",
		LUNARFORGING = "Brightsmithy",
		SHADOWFORGING = "Shadowcraft",
        HERMITCRABSHOP = "Bottle Exchange",
        SHELLWEAVER = "Combrining",
        RABBITKINGSHOP = "Trading Hutch",
        WANDERINGTRADERSHOP = "Trading",
        WAGPUNK_WORKSTATION = "Fabrication",
        CARPENTRY = "Carpentry",
        HERMITCRAB_TEASHOP = "Tea Brewing",

        SHADOW = "Codex Umbra",
        FOODPROCESSING = "Seasonings",

		CARNIVAL_HOSTSHOP = "Cawnival Creation",
		CARNIVAL_PRIZESHOP = "Trinket Trove",
		WINTERSFEASTCOOKING = "Winter's Feast Cooking",
		MADSCIENCE = "Mad Science",
        YOT_SHRINE_DOFFERING = "Offerings",
	},

	CRAFTING_MENU =
	{
        SORT_MODE_FMT = "Sort Mode: {mode}",
		SORTING =
		{
	        DEFAULT = "Default",
	        NAME = "Alphabetical",
		    CRAFTABLE = "Craftable",
		    FAVORITE = "Favorite",
		},
		SEARCH = "Search",

		NAVIGATION = "Navigation",
		PIN = "Pin",
		UNPIN = "Unpin",
		MORE = "More Actions",
		PINBAR_PAGE = "Select Page",
		SKIN_SELECT = "Select Skin",

		FAVORITE_ADD = "Add Favorite",
		FAVORITE_REMOVE = "Remove Favorite",
		NO_ITEMS = "No items match the current filter.",
	},

    ACCOUNT =
    {
        LOGIN = "Login",
        CREATE = "Create",
        CANCEL = "Cancel",
        REGISTER = "Register",
        LAN = "LAN",
        CDKEY = "Don't Starve CD-Key",
        USERNAME = "User Name",
        PASSWORD = "Password",
        EMAIL = "Email",
        LINKSTEAMACCOUNT = "Link Steam Account",
        LOGINWITHSTEAM = "Login With Steam",
    },

    BROADCASTING =
    {
        YES = "Yes",
        NO = "No",
        ACCEPT = "Accept",
        CANCEL = "Cancel",
        APPLY = "Apply",
        BACKTITLE = "Lose Changes?",
        BACKBODY = "Do you want to throw out your changes?",
        ACCEPTTITLE = "Accept Changes",
        ACCEPTBODY = "Do you wish to accept these changes?",
        ACCEPTGRAPHICSTITLE = "Accept Changes",
        ACCEPTGRAPHICSBODY = "Do you wish to accept these changes?",
        REVERT = "Revert Changes",
        CLOSE = "Close",

        BROADCASTINGENABLED = "Broadcasting Enabled",
        FRAMERATE = "Frame Rate",
        BANDWIDTH = "Bandwidth",
        AUDIO = "Audio",
        SYSTEMSOUND = "System Sound",
        MICROPHONE = "Microphone",
        SMOOTHSCALING = "Smooth Scaling",
        WEBCAM = "Webcam Enabled",
        WEBCAMALPHA = "Webcam Alpha",
        TWITCHCHAT = "Twitch Chat",
        LOGIN = "Login",
        LOGOUT = "Logout",
        SIGNUP = "Sign Up",
        FORGET = "Forget Account",
        VIEWSTREAM = "View Stream",
        STARTSTREAM = "Start Stream",
        STOPSTREAM = "Stop Stream",
        HELP = "Help",
    },

    PLAYER_AVATAR =
    {
        AGE_SURVIVED = "Survived",
        AGE_DAY = "Day",
        AGE_DAYS = "Days",
        CLOSE = "Close",
        STEAM = "View Profile",
        CHOOSING = "is choosing their survivor",
    },

    DRESSUP_AVATAR =
    {
        DRESSED_BY_FMT = "Dressed by {name}",
        UNDRESSED_BY_FMT = "Undressed by {name}",
    },

    WARDROBE_POPUP =
    {
        RESET = "Reset Outfit",
        SET = "Confirm Outfit",
        CANCEL = "Cancel",
    },

	PUMPKIN_CARVING_POPUP =
	{
		RESET = "Reset Carving",
		SET = "Confirm Carving",
		CANCEL = "Cancel",
		MAX_CUTS = "You have reached the maximum number of cuts on this pumpkin!",
		CARVE = "Carve",
	},

	PUMPKINHAT_CARVING_POPUP =
	{
		RANDOMIZE = "Randomize",
		REYE = "Eye",
		LEYE = "Other Eye",
		MOUTH = "Mouth",
	},

	SNOWMAN_DECORATING_POPUP =
	{
		MAX_DECOR = "You have reached the maximum number of decorations!",
		PLACE = "Place",
		FLIP = "Flip",
		SET = "Done!",
		CANCEL = "Cancel",
	},

    OPTIONS =
    {
        TITLE = "Game Options",
        GRAPHICS = "Graphics",
        SETTINGS = "Settings",
        ADVANCED = "Advanced",
		HUD = "HUD",
        CONTROLS = "Controls",
        LANGUAGES = "Languages",
        LANG_TITLE = "Language Options",
        LANG_BODY_STEAM = "Your Steam interface is set to a language other than English, would you like to view language options?",
        MOD_LANGUAGES_TITLE = "Steam Workshop Collections",
		CINEMATICS = "Cinematics",
        MORE = "More",
        OPTIONS = "Options",
        BACK = "Back",
        YES = "Yes",
		DEFAULT = "Default",
        NO = "No",
		DIM = "Dim",
		DIMMEST = "Dimmest",
		CRAFTING_HINTALL_ENABLED = "All Recipes",
		INVERT = "Inverted",
        BACKTITLE = "Lose Changes?",
        BACKBODY = "Do you want to throw out your changes?",
        BACKTITLE_PS4 = "Wait!",
        BACKBODY_PS4 = "You've made changes. How you want to proceed?",
        ACCEPTTITLE = "Accept Changes",
        ACCEPTBODY = "Do you wish to accept these changes?",
        ACCEPTGRAPHICSTITLE = "Accept Changes",
        ACCEPTGRAPHICSBODY = "Do you wish to accept these changes?",
        ACCEPT = "Accept",
        CANCEL = "Cancel",
        REVERT = "Revert Changes",
        APPLY = "Apply",
        CLOSE = "Close",
        BLOOM = "Bloom:",
        DISTORTION = "Distortion:",
        SCREENSHAKE = "Screen Shake:",
        FULLSCREEN = "Fullscreen:",
        DISPLAY = "Display:",
        RESOLUTION = "Resolution:",
        REFRESHRATE = "Refresh Rate:",
        SMALLTEXTURES = "Small Textures:",
        NETBOOKMODE = "Netbook Mode:",
        ENABLED = "Enabled",
        DISABLED = "Disabled",
        FAINT = "Faint",
        WEAK = "Weak",
        STRONG = "Strong",
        MAX = "Max",
        STEAM_CLOUD_SAVES = "Steam Cloud",
        LOCAL_SAVES = "Local Files",
        FX = "Sound FX Volume:",
        MUSIC = "Music Volume:",
        AMBIENT = "Ambient Volume:",
        HUDSIZE = "HUD Size:",
		CRAFTINGMENUSIZE = "Crafting Menu Size:",
		CRAFTINGMENUNUMPINPAGES = "Crafting Pin Pages:",
		CRAFTINGMENUSENSITIVITY = "Crafting Sensitivity:",
        SCAPBOOKHUDDISPLAY = "Scrapbook Alerts:",
		INVENTORYSENSITIVITY = "Inventory Sensitivity:",
        MINIMAPZOOMSENSITIVITY = "Zoom Sensitivity:",
        BOATHOPDELAY = "Boat Hop Delay:",
        MINIMAPZOOMCURSOR = "Zoom Cursor Focus:",
        VIBRATION = "Vibration:",
        CONTROLLER_AUDIO = "Controller Audio:",
        HAPTICS_STRENGTH = "Effect Strength:",
        HAPTICS_EFFECTS_UI = "Interface Effects:",
        HAPTICS_EFFECTS_DANGER = "Danger Effects:",
        HAPTICS_EFFECTS_PLAYER = "Player Effects:",
        HAPTICS_EFFECTS_ENVIRO = "Environmental Effects:",
        HAPTICS_EFFECTS_BOSS = "Boss Effects:",
        WATHGRITHRFONT = "Wigfrid's Umlauts:",
        WALTERCAMERA = "Campfire Camera:",
        BOATCAMERA = "Seafaring Camera:",
		PROMOTIONS = "Promotions:",
        BACKPACKMODE = "Backpack Layout:",
        POIDISPLAY = "Point of Interest Icons:",
        AUTOPAUSE = "Auto-Pause:",
        CONSOLEAUTOPAUSE = "Console Auto-Pause:",
        CRAFTINGAUTOPAUSE = "Crafting Auto-Pause:",
		CRAFTINGMENUBUFFEREDBUILDAUTOCLOSE = "Crafting Auto-Close:",
		CRAFTINGHINTALLRECIPES = "Crafting Preview:",
        DEFAULTCLOUDSAVES = "Default Save Type:",
		INTEGRATEDBACKPACK_DISABLED = "Separated",
		INTEGRATEDBACKPACK_ENABLED = "Integrated",
        DATACOLLECTION = "Data Collection:",
        MOVEMENTPREDICTION = "Lag Compensation:",
        MOVEMENTPREDICTION_ENABLED = "Predictive",
        MOVEMENTPREDICTION_DISABLED = "None",
		TARGETLOCKING = "Target Locking:",
        TEXTURESTREAMING = "Texture Streaming:",
        THREADEDRENDER = "Threaded Render:",
		SCREEN_FLASH_INTENSITY = "Screen Flashes:",
        SCREEN_FLASH_INTENSITY_SWITCH = "Photosensitivity Mode:",
        DYNAMIC_TREE_SHADOWS = "Canopy Shadows:",
		INVERTCAMERAROTATION = "Camera Rotation:",
        RESTART_TEXTURE_STREAMING_TITLE = "Restart Required",
        RESTART_TEXTURE_STREAMING_BODY = "For Texture Streaming changes to take effect, you will have to exit and restart the game.",
        RESTART_THREADED_RENDER_TITLE = "Restart Required",
        RESTART_THREADED_RENDER_BODY = "For Threaded Render changes to take effect, you will have to exit and restart the game.",
        OK = "Okay",
        DISPLAY_AREA_LABEL = "Display Area:",
        DISPLAY_AREA_BUTTON = "Adjust",
        -- INPUTFREQENCY = "Input Frequency(hz):",
        AUTOSAVE = "Auto-save",
        AUTOMODS = "Auto-Subscribe Mods:",
        AUTOLOGIN = "Auto-Login:",
        NPCCHAT = "Creature's Chat:",
        ANIMATED_HEADS = "Moving Head Icons:",
        SHOWPASSWORD = "Show Passwords:",
		SERVER_NAME_PROFANITY_FILTER = "Filter Server Names:",
		SERVER_NAME_PROFANITY_CHAT_FILTER = "Steam Chat Filtering:",
        SNAPSHOTS = "Server Snapshots",
        INPUT = "Input Device:",
        ACTION = "Action",
        REDEEM = "Redeem a Code",
        EULA = "Review the EULA",
        EULA_RESPONSE_CHANGED_TITLE = "Login Required",
        EULA_RESPONSE_CHANGED_BODY = "Your settings have changed and you must log in again to continue.",
		PS4_SAVES = "Use PlayStation®4 system saved data",
		BUGREPORT = "Submit a Bug Report",
        DYNAMICCONTENT_ENABLE = "Re-enable Dynamic Content",
        OFFLINE_MODE_TITLE = "Offline Mode",
        OFFLINE_MODE_BODY = "Your selection is not available in offline mode. Please log in and try again.",
        KLEI_ID_PREFIX = "Klei ID",
        VERSION = "Version",
		COMMANDWHEEL = "Social Menu Movement:",

		INTRO_MOVIE = "Intro Movie",
		CREDITS = "Credits",
		VIDEO_CHANNEL = "More Klei Videos",

        LOADING_TIPS = "Loading Tips",
        LOADING_TIPS_SHOW_ALL = "All",
        LOADING_TIPS_SHOW_NONE = "None",
        LOADING_TIPS_TIPS_ONLY = "Tips Only",
        LOADING_TIPS_LORE_ONLY = "Lore Only",

        NPCCHAT_ALL = "Most",
        NPCCHAT_SOME = "Important",
        NPCCHAT_NONE = "None",

        CONTROLLER_LAYOUT = "Controller Layout:",
        XB1_CONTROLLER_LAYOUT = "Gamepad Layout:",
        CONTROLLER_CUSTOM = "Custom",
        RESET_LAYOUT = "Default All",
        RESET_LAYOUT_BODY = "Do you want to reset all controls to their default values?\n\nYou will lose any changes you've made.\n",
        CHANGE_BINDING = "Change Binding",
        CURRENT_CONTROL_TEXT = "Current %s",
        DEFAULT_CONTROL_TEXT = "Default %s",
        INV_ADJUST_STACK_SIZE = "Adjust stack size",
        INV_USE_ITEM_ON_ITEM = "Use on item",

        AXISALIGNEDPLACEMENT = "Structure Alignment:",
        AXISALIGNEDPLACEMENT_SIZE_HALFWALL = "Half-Wall",
        AXISALIGNEDPLACEMENT_SIZE_WALL = "Wall",
        AXISALIGNEDPLACEMENT_SIZE_HALFTILE = "Half-Tile",
        AXISALIGNEDPLACEMENT_SIZE_TILE = "Tile",
        AXISALIGNEDPLACEMENTINTERVALS = "Alignment Intervals:",

        TOOLTIPS =
        {
            GRAPHICS = "Modify the graphics settings",
            SETTINGS = "Modify features of the game and user interface",
            ADVANCED = "Modify advanced features of the game and user interface",
			HUD = "Modify features of the user interface",
            CONTROLS = "Rebind which input does which in-game action",
            LANGUAGES = "Select display language",
            CONTROLS_CONSOLE = "Check which control does which in-game action",
            MORE = "View additional options",
            CINEMATICS = "Sit back and watch a video",

            -- Settings
            INPUT = "Controller or Keyboard? Play Don't Starve Together your way.",
            VIBRATION = "Make your controller vibrate at key gameplay moments.",
			VIBRATION_WIRELESS = "Enable vibration of your wireless controller at key gameplay moments.",
            CONTROLLER_AUDIO = "Enable audio from your wireless controller at key gameplay moments.",
            HAPTICS_STRENGTH = "Adjust the strength of haptic effects.",
            HAPTICS_EFFECTS_UI = "Toggle haptic effects from interacting with the user interface.",
            HAPTICS_EFFECTS_DANGER = "Toggle haptic effects when your character is in danger.",
            HAPTICS_EFFECTS_PLAYER = "Toggle haptic effects from your character's actions.",
            HAPTICS_EFFECTS_BOSS = "Toggle haptic effects from boss enemy actions.",
            HAPTICS_EFFECTS_ENVIRO = "Toggle haptic effects from the environment.",
            FX = "Change how loud things are in the world.",
            MUSIC = "Tone up or down the musical fanfare in your adventures.",
            AMBIENT = "The environment makes noise too, luckily you can control how loudly it does.",
            HUDSIZE = "Customize the size of your Heads Up Display.",
			CRAFTINGMENUSIZE = "Customize the size of the crafting menu.",
			CRAFTINGMENUNUMPINPAGES = "Set how many pages of pinned recipes you would like to cycle through.",
			CRAFTINGMENUSENSITIVITY = "Adjust the input sensitivity while navigating through the crafting menu.",
            SCAPBOOKHUDDISPLAY = "Toggle HUD notifications from the Scrapbook on and off.",
			INVENTORYSENSITIVITY = "Adjust the input sensitivity while navigating through the inventory.",
            MINIMAPZOOMSENSITIVITY = "Adjust the input sensitivity while zooming in and out on the minimap.",
            BOATHOPDELAY = "Adjust how much time is needed to start hopping onto and off of a boat.",
            MINIMAPZOOMCURSOR = "Zooming on the minimap will focus where the cursor is located.",
            AUTOLOGIN = "Log into your Klei account automatically when booting up Don't Starve Together.",
            NPCCHAT = "Allows key dialogue from creatures in the world to be displayed in the chat box.",
            SHOWPASSWORD = "Show or hide your passwords.",
            BOATCAMERA = "Allows the camera to focus on your boat while sailing.",
            BACKPACKMODE = "Change how the contents of the backpack are displayed. Integrated with the inventory bar or separated at the side of the screen.",
            SERVER_NAME_PROFANITY_CHAT_FILTER = "Use Steam's chat filters. This can be configured in Steam's setting in the section In-Game under Chat Filtering.",
            SERVER_NAME_PROFANITY_FILTER = "Filter out the profanity when browsing the server list. Filtered servers will have their names displayed as \"This server name has been filtered\" and can still be joined.",
            AUTOPAUSE = "When you are the only player in the world, this will pause the game while you are in the ingame menus, crafting, or viewing the cookbook or plant registry. If there are other players in the world, only the server admin will have permissions to pause the game.",
            CRAFTINGAUTOPAUSE = "When you are the only player in the world, this will pause the game while the crafting menu is open.",
			CRAFTINGMENUBUFFEREDBUILDAUTOCLOSE = "Closes the crafting menu when building a structure that is placed in the world.",
			CRAFTINGHINTALLRECIPES = "Preview the next available research tier or show all locked recipes.",
            DATACOLLECTION = "We collect metrics and telemetry on Don't Starve Together, including how long and how often you play. This information helps us troubleshoot the game, provide rewards, and improve your experience. Refer to https://www.klei.com/privacy-policy for more information.",
            LOADING_TIPS = "Learn more about the lore and the gameplay of Don't Starve while your world loads.",
			TARGETLOCKING = "Focus on one target at a time.",
			PROMOTIONS = "Display store promotions in the main menus.",
            AXISALIGNEDPLACEMENT = "Structures and other deployables will automatically lock to a grid for making buildings look structured.",
            AXISALIGNEDPLACEMENTINTERVALS = "This sets how big the grid is between each, measured in common units such as Wall width or Tile width.",

            -- Graphics
            FULLSCREEN = "Fill your screen with Don't Starve Together.",
            RESOLUTION = "Change the game screen resolution. (Fullscreen only)",
            DISPLAY = "Got multiple screens? We've got you covered, choose where the game window goes when playing the game. (Fullscreen only)",
            REFRESHRATE = "Customize how many times per second the game screen refreshes. (Fullscreen only)",
            SMALLTEXTURES = "Reduces texture quality for better performance. (Only recommended for min-spec computers)",
			SMALLTEXTURES_CONSOLE = "Reduces texture quality for better performance.\n(Only recommended if you're having problems with your world)",
            NETBOOKMODE = "Reduces the game's update frequency. (Only recommended for min-spec computers)",
            TEXTURESTREAMING = "Reduces the memory overhead for textures. Enabling this should improve performance.",
            THREADEDRENDER = "Renders the game on a different core. Enabling this should improve performance.",
            SCREENSHAKE = "Keep your camera static or allow it to shake freely in moments of high intensity.",
            DISTORTION = "Allows you to turn off screen distortions in the game, especially notable during moments of insanity.",
            BLOOM = "Increases the visual intensity of lights.",
            SCREEN_FLASH_INTENSITY = "Control the intensity of screen flashes during explosions and lightning strikes.",
            SCREEN_FLASH_INTENSITY_SWITCH = "Control the intensity of flashing effects during explosions and lightning strikes.",
            DYNAMIC_TREE_SHADOWS = "Renders the ground shadow while under a canopy.",
			DISPLAYAREA = "Maximize the screen size on your display.",
			INVERTCAMERAROTATION = "Flips the camera rotation direction.",

            -- Advanced
            MOVEMENTPREDICTION = "Allows the game to predict your movements to compensate for any possible lag.",
            WATHGRITHRFONT = "Replaces Wigfrid's o's with ö's when she speaks.",
            WALTERCAMERA = "Allows the camera to focus on Walter while he tells campfire stories.",
            AUTOMODS = "Keep up to date with the mods of all the servers you join.",
            ANIMATED_HEADS = "Animates the survivor's heads in the menus.",
            CONSOLEAUTOPAUSE = "Allows the server to auto-pause while the console screen is open.",
            DEFAULTCLOUDSAVES = "Chooses whether new saves will be stored in the cloud or not by default.",
			COMMANDWHEEL = "Allows you to control your player movement and the Social Menu independently.",
            POIDISPLAY = "Hide all the Point of Interest Icons.",

            -- controls
            CONTROLLER_LAYOUT = "Use the default controls or customize them to your liking.",
            CONTROL_SCHEME_CAM_AND_INV = "Choose between control schemes for the camera, inventory, and aiming.",

            CONTROLS_EDITOR =
            {
                -- These are used in the Console version of the controls settings and thus only cover the controls available there
                [57] = "Perform the default action on the current target.", --CONTROL_CONTROLLER_ACTION
                [56] = "Attack the current target.", -- CONTROL_CONTROLLER_ATTACK
                [58] = "Perform an alternate action on the current target (when applicable).", -- CONTROL_CONTROLLER_ALTACTION
                [3] = "Inspect the current target.", -- CONTROL_INSPECT
                [88] = "Lock on to the current target.", -- CONTROL_TARGET_LOCK
                [89] = "Lock on to the next available target.", -- CONTROL_TARGET_CYCLE
                [46] = "Open and Close the crafting menu.", -- CONTROL_OPEN_CRAFTING
                [45] = "Open and Close the inventory bar.", -- CONTROL_OPEN_INVENTORY
                [51] = "Examine the selected inventory item.", -- CONTROL_INVENTORY_EXAMINE
                [52] = "Use the selected inventory item on yourself.", -- CONTROL_INVENTORY_USEONSELF
                [53] = "Use the selected inventory item on the world.", -- CONTROL_INVENTORY_USEONSCENE
                [54] = "Drop the selected inventory item.", -- CONTROL_INVENTORY_DROP
                [55] = "Put part of the selected stack of inventory items into another inventory slot.", -- CONTROL_PUTSTACK
                [59] = "Use the selected inventory item on another.", -- CONTROL_USE_ITEM_ON_ITEM
                [87] = "Open and Close the Social Menu.", -- CONTROL_OPEN_COMMAND_WHEEL
                [13] = "Pause and Unpause the game.", -- CONTROL_PAUSE
                [14] = "Open and Close the minimap", -- CONTROL_MAP
                [60] = "Zoom in while using the minimap.", -- CONTROL_MAP_ZOOM_IN
                [61] = "Zoom out while using the minimap.", -- CONTROL_MAP_ZOOM_OUT
                [11] = "Rotate the camera to the left.", -- CONTROL_ROTATE_LEFT
                [12] = "Rotate the camera to the right.", -- CONTROL_ROTATE_RIGHT
                [9] = "Move the camera closer to your character.", -- CONTROL_ZOOM_IN
                [10] = "Move the camera farther from your character.", -- CONTROL_ZOOM_OUT
            },
        },
    },

    SCRAPBOOK =
    {
        TITLE = "Scrapbook",
        ONLINE_DATA_USER_OFFLINE = "Login to retrieve online scrapbook data.",
        ONLINE_DATA_DOWNLOAD_FAILED = "Failed to sync online scrapbook data.",
    },
	COMPENDIUM =
	{
		HISTORYOFTRAVELS = "History of Travels",
		CHARACTERDETAILS = "Survivors",
		COOKBOOKPANEL = "Cookbook",
        PLANTREGISTRYPANEL = "Plant Registry",
        OBITUARIES = "Obituaries",
        ENCOUNTERS = "Encounters",
		CINEMATICS = "Cinematics",

		TOOLTIP_HISTORYOFTRAVELS = "A summary of your adventures",
		TOOLTIP_CHARACTERDETAILS = "The survivors of the Constant",
		TOOLTIP_COOKBOOKPANEL = "The Constant's guide to cookery",
        TOOLTIP_PLANTREGISTRY = "The Constant gardener's almanac",
        TOOLTIP_OBITUARIES = "Reminisce over past mistakes",
        TOOLTIP_ENCOUNTERS = "A history of those you've crossed paths with",
		TOOLTIP_CINEMATICS = "Pretty movies!",

		CAUSEOFDEATH_OTHER = "Other",
	},

    NOTIFICATION =
    {
        LOADING = "Loading",
        LOGIN = "Logging in",
        JOINEDGAME = "%s has joined the game.",
        LEFTGAME = "%s has left the game.",
        KICKEDFROMGAME = "%s was kicked from the game.",
        BANNEDFROMGAME = "%s was banned from the game.",
        DICEROLLED = "%s rolls %s (1-%i)", --period at the end looks bad
        DEFAULTVOTEPASSEDFMT = "The %s has passed.",
        DEFAULTVOTEFAILEDFMT = "The %s has failed.",
        DEFAULTVOTENAMEFMT = "vote",
        PRESS_KB = "Press (",
        DISCONNECT_KB = ") to Disconnect",
        PRESS_CONTROLLER = "Press ",
        DISCONNECT_CONTROLLER = " to Disconnect",
        CONNECTING = "Connecting",
        NEW_SKIN_ANNOUNCEMENT = "%s got a new skin: ",
		LOADING_ASSETS_PROGRESS = "Loading Assets: %s",
        LAUNCHING_SERVER = "Launching Server",
        SERVER_WORLDGEN = "Server is Generating World",
        INITIALIZING_SERVER = "Initializing Server",
        WORLDGENERATING_SERVER = "Generating World",
		WORLDGENERATING_SERVER_PROGRESS = "Generating World: %s",
        CURRENTLY_SPEAKING = "Currently Speaking...",
        RETRYING = "Retrying",
        RESTORING = "Restoring Backup",
		CHECK_SHOP = "Updating the shop",
		CHECK_EVENT = "Catching up on current events",
		CHECK_DAILY_GIFT = "Checking for daily gifts",
		CHECK_KEYVALUESTORES = "Grabbing profile details",
		CHECK_INVENTORY = "Updating inventory",
    },

    LOADING_SCREEN_SURVIVAL_TIPS =
    {
        --TEST_TIP1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.",
        TIP_DIRT_PILE = "\"I stumbled upon a rather suspicious mound of dirt... perhaps it was left by a creature of some sort? This may require further investigation...\" -W",
        TIP_SCIENCE_MACHINE = "\"I find myself returning more and more frequently to my magnificent science machine, busying myself with prototyping new tools to aid in our survival. After all, I must do something to keep myself sane in this strange place...\" -W",
        TIP_SANITY = "\"I fear I may no longer be able to trust my own eyes. I've been catching glimpses of strange shadowy forms at the edges of my vision with increasing frequency... surely they can't really be there?\" -W",
        TIP_DARKNESS = "\"They say the Shadow Queen herself comes at night to snatch up anyone foolish enough to wander in the dark...\" -W",
        TIP_CAVES = "\"I finally worked up the courage to explore the underground caverns. To my surprise, I found there was ample light provided by a most curious glowing plant that seems to grow naturally throughout the cave system. I've harvested some bulbs for further study.\" -W",
        TIP_PIG_AND_MONSTERS = "\"The Pig men seem to harbor a deep dislike for the Constant's more monstrous denizens, attacking them on sight. While I personally can't blame them, it does pose a bit of a problem for some of my compatriots...\" -W",
        TIP_TREEGUARD = "\"Could've sworn I saw one of the trees movin' when I was out choppin' firewood... must've been a trick of the light.\" -W",
        TIP_RUN_AWAY = "\"It turns out that Koalefants are a bit hardier than I expected. I (quite sensibly) decided to take a... strategic retreat until I'm better prepared.\" -W",
        TIP_CHARCOAL = "\"You know what they say, you can't get charcoal without burning down a few trees!\" -W",
        TIP_HEAT = "\"Blast this heat! Where's a nice, chilled drink when you need it?\" -M",
        TIP_WETNESS = "\"The rain is proving to be a greater hindrance than I first anticipated. As if being soaked to the bone isn't dreadful enough, my tools keep slipping from my hands when I try to make use of them!\" -W",
        TIP_COMPASS = "\"I experimented with making a rudimentary compass and discovered that this place does in fact seem to have a magnetic North. Curiously, it also pointed out the positions of my fellow camp mates who, as it turned out, had already crafted similar compasses of their own.\" -W",
        TIP_FLARE = "\"A flare was sent up from the forest last night. I know I should have set out immediately to help, but... well... I suppose I hesitated too long by the comforting glow of my campfire, and before I knew it the flare had faded from view. I do hope whoever it was is alright...\" -W",
        TIP_GARDENEERHAT = "\"I've finally perfected my design for an ingenious (if I do say so myself) device that stores important garden-based knowledge. Certain naysayers might point out that it looks like nothing more than an overturned flowerpot worn on the head... some people simply don't have an eye for science.\" -W",
        TIP_COOKBOOK = "\"Once I've perfected a recipe, I find it helpful to write it down. Luckily, I've been able to cobble together a rough cookbook for just such a thing out of some spare pieces of parchment. Now my mind is free to worry about more immediate things...\" -W",
        TIP_NEWRECIPES = "\"Recipes are useful, but a true chef knows the importance of experimenting with new ingredients and flavors, and this world certainly provides an abundance of unusual things to choose from.\" -W",
        TIP_REPLANTING = "\"The bushes I replanted by the camp are looking sickly... I suspect they'll require some extra care before they can produce any berries again.\" -W",
        TIP_NAUGHTINESS = "\"We shouldn't hurt things that don't hurt us. If we're mean, bad old Mr. Krampus will come...\" -W",
        TIP_BERRYLURE = "\"Last time I baited my hook with berries I caught more fish than I could carry, but when I tried today? Barely a nibble! Guess the berry trick only works on some of 'em.\" -W",
        TIP_OCEANEXPLORATION = "\"What strange new islands and creatures might I encounter if I journey out to sea? I shudder to think... but curiosity has a tendency to get the better of me...\" -W",
        TIP_REVIVE = "\"We nearly lost one of our number today. In a mad daze I created... something... that managed to pull our friend back to the land of the living, but... whatever it was, I fear I cannot rightfully say it was within the realm of science...\" -W",
        TIP_COBBLEDROAD = "\"Today I was surprised to come upon a cobbled road - how did this hallmark of civilization come to be in this untamed wilderness?\" -W",
        TIP_MERMHOUSE = "\"The Merms are fiercely territorial, and quick to defend their homes. Though I honestly can't imagine anyone else wanting to take up residence in those ram-shackle hovels...\" -M",
        TIP_BOTTLES = "\"From time to time I've spotted bottles bobbing along the ocean currents, just out of reach from the shore. I have half a mind to construct a boat and retrieve one of them... I have a gut feeling that someone is trying to send out a message.\" -W",
        TIP_MOONISLAND = "\"I couldn't have imagined it, I'm certain I just saw a piece of the moon break off and crash into the ocean! Perhaps my compatriots will join me in a search for it...\" -W",
        TIP_MOONMUTATION = "\"The moon in this world seems to hold some strange power over the creatures here. It changes them...\" -W",

    },

    LOADING_SCREEN_LORE_TIPS =
    {
        --TEST_TIP2 = "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog.",
        TIP_TIME = "Time moves differently in the Constant. Instead of a monotonous forward march, seconds and eternities seem to throw caution to the wind and do-si-do backwards and forwards as they please.",
        TIP_WILSON_UNI = "Wilson chose the path of an independent Gentleman Scientist after finding the university environment to be too stifling for a man of his ambitions. (The enormous bill the university sent him to pay for repairs to the chemistry lab had absolutely nothing to do with this.)",
        TIP_WINONA_CHARLIE = "Growing up, Winona always looked out for her younger sister. Even now, she can't help but feel that one day she'll be able to reach out into the darkness and pull Charlie back.",
        TIP_MAXWELL_SURVIVORS = "Once the King of the Nightmare Throne, Maxwell now finds himself surviving alongside the very people he once tormented. Needless to say, it makes for a bit of an... awkward atmosphere.",
        TIP_MAXWELL_PAST = "Maxwell (né William Carter) was once nothing more than a humble stage magician, until the discovery of a mysterious tome changed the course of his life forever.",
        TIP_DARKNESS_CHARLIE = "In the Constant, the darkness has a name. Have you met Charlie yet?",
        TIP_WARNING = "\"Nothing here is what it seems. If you're reading this, keep an eye on the rabbits, don't trust the statues, and don't mistake that thing hanging in the night sky for the moon...\" -W",
        TIP_WOODIE = "Even with all the steps Woodie has taken to control his were-curse, there's little that can be done on nights when the moon is at its fullest.",
        TIP_WILLOW = "Nothing brings Willow more comfort than snuggling her faithful teddy bear Bernie, and committing a playful bit of arson.",
        TIP_WICKERBOTTOM = "Wickerbottom is of the firm belief that the pen is mightier than the sword. Words hold great power when used correctly.",
        TIP_WENDY = "Nothing could ever come between Wendy and her twin sister Abigail. Some bonds transcend even death.",
        TIP_WEBBER = "Once upon a time, a little boy was swallowed up whole by a big hungry spider. Now they share everything; a body, a mind, and the name Webber.",
        TIP_WALTER = "Walter's time in the Pinetree Pioneers has made him more prepared than most for surviving in the wilderness. Unfortunately, this is undermined somewhat by his blind fascination with monsters.",
        TIP_THEM = "\"You can't run from Them forever. Take it from me, pal.\" -M",
        TIP_PORTALS = "\"It seems that every time we discover a doorway out of this terrible place, it just leads to more strange worlds with new horrors to endure. Still, I can't give up hope that one day we'll find a doorway that will take us home...\" -W",

    },

    LOADING_SCREEN_CONTROL_TIPS =
    {
        TIP_HOLD_INSPECT = "Hold {inspect} to inspect the world around you.",
        TIP_HOLD_ACTION = "Hold {action} to automatically pick up nearby items and perform actions. Just make sure you're holding the right tool for the job!",
        TIP_ROTATE_CAMERA = "Press {rotateleft} & {rotateright} to rotate your view of the world.",
        TIP_SHOW_MAP = "Press {map} to take a quick glance at your map.",

        TIP_ENDLESS_MODE = "When creating a new world, switch the Game Mode to Endless to allow you and your friends to revive at the Florid Postern.",
        TIP_DISABLE_TIPS = "Is your mind already bursting with secret knowledge? You can turn off Loading Tips anytime in the Options menu.",
        TIP_ROLLBACK = "Server hosts can roll back one day or regenerate the world by accessing the Server Commands menu in the Pause Screen.",
        TIP_DICEVOTE = "Access the Server Commands menu from the Pause Screen to start votes or roll a dice.",
        TIP_WORLDGEN = "Meddle with World Gen settings in the Options menu to shape a world to your liking.",
        TIP_VIGNETTES = "Customize your loading screens in the Vignette section of the Curio Cabinet if you're looking for a little change of scenery.",
    },

    LOADING_SCREEN_CONTROL_TIPS_CONSOLE =
    {
        --TIP_CONSOLE = "This is a console tip!",
    },

    LOADING_SCREEN_CONTROL_TIPS_NOT_CONSOLE =
    {
        TIP_FORCE_ATTACK = "Hold {modifier} + {attack} to attack anything that looks at you sideways, even friends.",
        TIP_ATTACK = "Hold {attack} to attack enemies.",
        TIP_HOLD_MOUSE = "Hold down {primary} to automatically harvest nearby items or attack, whatever suits your fancy!",
        TIP_HALF_STACK = "Hold {modifier} and {primary} on stacks of items in your inventory to quickly grab half the stack.",
        TIP_DROP_ITEMS = "Hold {modifier} and {secondary} to quick drop items from your inventory.",
        TIP_INSPECT_SELF = "Press {inspectself} to take a look at which item and character skins you are using.",
        TIP_CHAT = "Press {chat} to talk to other players. If you wish to speak privately, press {whisper} to whisper to someone.",
        TIP_INVENTORY_SLOTS = "Press {inv_0}-{inv_9} to quickly use items carried in your main inventory.",
        TIP_PLAYER_STATUS = "Keep tabs on your fellow Survivors by pressing the {playerstatus} key.",
        --TIP_EMOTES = "Show how you really feel! Emotes and dances can be done in the text chat.",

        -- This tip needed for non-binded controls fallback tip string
        TIP_BIND_CONTROLS = "Play with Controls Settings in the Options Menu to fit your control needs.",
    },

    -- Category reserved for loading screen modding
    LOADING_SCREEN_OTHER_TIPS =
    {
    },

    BOX_POPUP =
    {
        OK = "OK",
        TITLE = "You received...",
        SERVER_ERROR_TITLE = "Error Opening Chest",
        SERVER_ERROR_BODY = "There was an error while opening your Chest. Please log in again to refresh your account inventory.",
        SERVER_NO_ITEM_BODY = "This Chest contained items that are not supported by your current game version. Please exit and update your game.",
    },

    ITEM_SCREEN =
    {
        NORMAL_POPUP_TITLE = "received...",
        NEW_SKIN = "You got a skin for %s!",
        OK_BUTTON = "Close",
        OPEN_BUTTON = "Open Now!",
        OPEN_NEXT = "Proceed",
        SKIP_REST = "Stop",
        OPENING = "Opening",
        BACK = "Back",
        NEXT_ITEM = "Put it Away",
        USE_NOW = "Use Now",
        USE_LATER = "Use Later",
        RECEIVED = "You Received",
        ENABLED_TOAST_TOOLTIP = "Open",
        DISABLED_TOAST_TOOLTIP = "This requires more science!",
        DISABLED_YOTB_TOOLTIP = "New beefalo grooming option!",
    },

    STATSPANEL =
    {
        MOTD_TITLE = "Now Available!",
        MOTD_BODY = "Character and item skin sets now available for purchase!",
    },

    POPUPDIALOG =
    {
        TITLE =
        {
            DEFAULT = "Alert!",
            SERVER_ERROR_BANNED_GAME      = "Terms of Service Violation",
            SERVER_ERROR_BANNED_GAME_NAME = "Terms of Service Violation - Name",
            SERVER_ERROR_BANNED_GAME_DESC = "Terms of Service Violation - Description",
            DIRECT_JOIN_FAILED            = "Failed to Direct Join Game",
        },
        BODY =
        {
            DEFAULT = "You have received an alert. Don't let this happen again.",
            SERVER_ERROR_BANNED_GAME      = "Your server will not be joinable until the name or description has been changed. Repeated violations will result in a permanent ban.",
            SERVER_ERROR_BANNED_GAME_NAME = "Your server will not be joinable until the name has been changed. Repeated violations will result in a permanent ban.",
            SERVER_ERROR_BANNED_GAME_DESC = "Your server will not be joinable until the description has been changed. Repeated violations will result in a permanent ban.",
            DIRECT_JOIN_FAILED            = "Something went wrong while trying to direct join a server.",
        },
        OK = "OK",
    },

    REDEEMDIALOG =
    {
        CURRENCY_FMT = "{currency_amt} {currency}!",
    	TITLE = "Enter Your Code",
    	SUBMIT = "Submit",
    	CANCEL = "Cancel",
    	ACCEPTED = "Success: Code Accepted!",
    	INVALID_CODE = "That code wasn't quite right. Please try again.",
    	ALREADY_REDEEMED = "This code has already been redeemed. Maybe by you?",
    	FAILED_TO_CONTACT = "Sorry, it looks like the server's not answering right now. Please try again later.",
    	LEGALESE = "Delivery time may vary due to temporal portal anomalies. Wilson is not responsible for emotional injuries caused by waiting. Gifts may result in bragging, unexpected delight, and/or enhanced gameplay experiences.",

		MENU_BUTTON_TITLE = "Redeem Codes",
		MENU_BUTTON_DESC = "Transmute some codes into something useful.",
	},

    EULADIALOG =
    {
        TITLE = "End User License Agreement",
        ACCEPT = "Accept",
        DECLINE = "Decline",
        DECLINE_CONFIRMATION_TITLE = "Decline the EULA?",
        DECLINE_CONFIRMATION_BODY = "You will not be able to play online. Are you sure?",
		AGREEMENT_UPDATED = "The EULA has been updated and needs your review.",
    },

    NETWORKDISCONNECT =
    {
        TITLE =
        {
            DEFAULT = "Disconnected",
            ID_NO_FREE_INCOMING_CONNECTIONS = "Server Full",
            ID_DST_NO_FREE_PLAYER_SLOTS = "Server Full",
            ID_DST_NOT_ACCEPTING_NEW_PLAYERS = "Disconnected",
            ID_CONNECTION_ATTEMPT_FAILED = "Server Not Responding",
            ID_DST_DESTINATION_CONNECTION_ATTEMPT_FAILED = "Destination Not Responding",
            ID_INVALID_PASSWORD = "Bad Password",
            ID_CONNECTION_LOST = "Disconnected",
            ID_DISCONNECTION_NOTIFICATION = "Disconnected",
            ID_ALREADY_CONNECTED = "Duplicate Connection",
            ID_DST_LOGGED_IN_SOMEWHERE_ELSE = "Duplicate Login",
            ID_CONNECTION_BANNED = "Banned",
            ID_DST_USER_BANNED   = "Banned",
            ID_DST_USER_KICKED   = "Kicked",
            ID_DST_IDLE_TIMEOUT = "Disconnected",
            ID_DST_STEAM_NET_CONNECTION_TIMEOUT = "Disconnected",
            ID_DST_INCOMING_CONNECTIONS_DISABLED = "Failed To Connect",
            FAILED_TO_AUTOJOIN_LAN = "LAN Join Failed",
            ID_DST_INITIALIZATION_FAILED = "Networking Failed To Start",
            ID_NAT_PUNCHTHROUGH_FAILED = "Could Not Connect",
            ID_NAT_TARGET_NOT_CONNECTED = "Could Not Connect",
            ID_NAT_TARGET_UNRESPONSIVE = "Could Not Connect",
            ID_NAT_CONNECTION_TO_TARGET_LOST = "Could Not Connect",
            PLATFORM_MISMATCH = "Version Mismatch",
            VERSION_MISMATCH_OLD_SERVER = "Version Mismatch",
            VERSION_MISMATCH_OLD_CLIENT = "Version Mismatch",
            VERSION_MISMATCH_PUBLIC_BETA = "Public Beta Server",
            VERSION_MISMATCH_ARNBETA = "A New Reign Beta",
			VERSION_MISMATCH_ROTBETA = "Return of Them Beta",
			VERSION_MISMATCH_UPDATEBETA = "Beta Branch",
            VERSION_HANDSHAKE_FAILED    = "Version Mismatch",
            ID_INCOMPATIBLE_PROTOCOL_VERSION = "Version Mismatch",
            ID_DST_INCOMPATIBLE_PROTOCOL_VERSION = "Version Mismatch",
            FORCE_DISCONNECTION = "Force Disconnection",
            INVALID_GAME_SESSION_TOKEN = "Could Not Connect",
            INVALID_CLIENT_TOKEN = "Invalid Client Token",
            ID_DST_GAME_SESSION_AUTH_FAILED = "Authentication Failed",
            E_BANNED = "Account Banned",
            E_DELETED = "Account Deleted",
            E_UPGRADE = "Version Out of Date",
            ID_DST_USER_CONNECTION_FAILED = "Connection Failed",
            ID_DST_FRIENDS_ONLY_SERVER = "Friends Only",
            APP_OWNERSHIP_CHECK_FAILED = "Game Ownership Check Failed",
            SERVER_MODS_NOT_ON_WORKSHOP = "Disconnected Due To Missing Mods",
            SERVER_MODS_NOT_ON_WORKSHOP_RAIL = "Disconnected Due To Missing Mods",
            SERVER_MODS_WORKSHOP_VERSION_MISMATCH = "Disconnected Due To Missing Mods",
            SERVER_MODS_WORKSHOP_FAILURE = "Disconnected Due To Missing Mods",
            SERVER_MODS_WORKSHOP_ACCESS_DENIED = "Disconnected Due To Missing Mods",
            SERVER_MODS_WORKSHOP_FAILURE_RAIL = "Disconnected Due To Missing Mods",
            SERVER_MODS_WORKSHOP_ACCESS_DENIED_RAIL = "Disconnected Due To Missing Mods",
            ID_DST_SLOT_RESERVATION = "Slot Reserved",
            ID_DST_DESTINATION_SERVER_NOT_AVAILABLE = "Server not available",
            ID_DST_SERVER_IS_CLAN_ONLY = "Not a member of the server's clan",
            ID_DST_SERVER_IS_LAN_ONLY = "Local Connection Server Only",
            ID_DST_DEDICATED_SERVER_STARTUP_FAILED = "Dedicated Server Failed To Start",
            ID_DST_SERVER_STARTUP_FAILED = "Server Failed To Start",
			ID_SPLITSCREEN_INGAME_PLAYER2_SIGNED_OUT_OF_PS4 = "Player 2 Logged Out",
			ID_SPLITSCREEN_UI_PLAYER2_SIGNED_OUT_OF_PS4 = "Player 2 Logged Out",
			ID_SPLITSCREEN_INGAME_PLAYER1_SIGNED_OUT_OF_PSN = "Player 1 Signed Out",
			ID_SPLITSCREEN_INGAME_PLAYER2_SIGNED_OUT_OF_PSN = "Player 2 Signed Out",
			ID_SPLITSCREEN_UI_PLAYER1_SIGNED_OUT_OF_PSN = "Player 1 Signed Out",
			ID_SPLITSCREEN_UI_PLAYER2_SIGNED_OUT_OF_PSN = "Player 2 Signed Out",
            ID_DST_NETWORK_CONNECTION_LOST = "Network Connection Lost",
            ID_DST_SAVE_FILE_DAMAGED = "Load failed",
        },
        BODY =
        {
            DEFAULT = "You have been disconnected. We're not sure why... Sorry!",
            ID_NO_FREE_INCOMING_CONNECTIONS = "The server is full.",
            ID_DST_NO_FREE_PLAYER_SLOTS = "The server is full.",
            ID_DST_NOT_ACCEPTING_NEW_PLAYERS = "The server is not accepting new players.",
            ID_CONNECTION_ATTEMPT_FAILED = "The server is not responding. Please try again.",
            ID_DST_DESTINATION_CONNECTION_ATTEMPT_FAILED = "The destination server is not responding. Please try again.",
            ID_INVALID_PASSWORD = "Whoops! The password you entered was incorrect.",
            ID_CONNECTION_LOST = "You have lost connection to the server.",
            ID_DISCONNECTION_NOTIFICATION = "You have been disconnected from the server.",
            ID_ALREADY_CONNECTED = "You are already connected to this server.",
            ID_DST_LOGGED_IN_SOMEWHERE_ELSE = "This account has been logged in from another location.",
            ID_CONNECTION_BANNED = "You have been banned from this server.",
            ID_DST_USER_BANNED   = "You have been banned from this server.",
            ID_DST_USER_KICKED = "You have been kicked from this server.",
            ID_DST_IDLE_TIMEOUT = "You have lost connection to the server.",
            ID_DST_STEAM_NET_CONNECTION_TIMEOUT = "You have lost connection to the server.",
            ID_DST_INCOMING_CONNECTIONS_DISABLED = "The server is not accepting new connections temporarily. Please wait a moment and try again.",
            FAILED_TO_AUTOJOIN_LAN = "Unable to join a LAN server.\nAre you sure it exists?",
            ID_DST_INITIALIZATION_FAILED = "Networking did not initialize properly. Please try again.",
            ID_NAT_PUNCHTHROUGH_FAILED = "Unable to connect to the server.",
            ID_NAT_TARGET_NOT_CONNECTED = "Unable to connect to the server.",
            ID_NAT_TARGET_UNRESPONSIVE = "Unable to connect to the server.",
            ID_NAT_CONNECTION_TO_TARGET_LOST = "Unable to connect to the server.",
            PLATFORM_MISMATCH = "This server is incompatible with your version. Please try another server.",
            VERSION_MISMATCH_OLD_SERVER = "This server is on an older version than you.",
            VERSION_MISMATCH_OLD_CLIENT = "This server is on a newer version than you. Please download the latest update to connect.",
            VERSION_MISMATCH_PUBLIC_BETA = "The server is running a public beta world. You'll need to opt into the beta to play on this server.",
            VERSION_MISMATCH_ARNBETA = "The server is running the A New Reign Beta version. You'll need to opt into the beta to play on this server.",
			VERSION_MISMATCH_ROTBETA = "The server is running the Return of Them Beta version. You'll need to opt into the beta to play on this server.",
			VERSION_MISMATCH_UPDATEBETA = "The server is running the Beta Branch version. You'll need to opt into the beta to play on this server.",
            VERSION_HANDSHAKE_FAILED = "The server is on a different version than you. Please check that your game version is up-to-date.",
            ID_INCOMPATIBLE_PROTOCOL_VERSION = "The server has a different version than you do. Please check that your game version is up-to-date.",
            ID_DST_INCOMPATIBLE_PROTOCOL_VERSION = "The server has a different version than you do. Please check that your game version is up-to-date.",
            FORCE_DISCONNECTION = "The connection has been forcibly closed by the engine.",
            E_BANNED = "Your account has been banned for violating the terms of use. Please visit accounts.klei.com to review this issue.",
            E_DELETED = "Your account has been marked for deletion and cannot be used anymore.",
            E_UPGRADE = "A new version is available.\nPlease update Don't Starve Together.",
            INVALID_CLIENT_TOKEN = "A token error occurred. Please try again.",
            INVALID_GAME_SESSION_TOKEN = "Unable to reach the Klei server. Please try again.",
            ID_DST_GAME_SESSION_AUTH_FAILED = "Authentication failed. Please try again.",
            ID_DST_USER_CONNECTION_FAILED = "Something went awry while connecting. Please try again.",
            ID_DST_FRIENDS_ONLY_SERVER = "Attempted to join a \"friends only\" server, but you're not friends with the host.",
            APP_OWNERSHIP_CHECK_FAILED = "The server says you don't own the game. But you do... right?",
            SERVER_MODS_NOT_ON_WORKSHOP = "This server requires mods that are not available on the Steam Workshop. You will need to manually download the missing mods.",
            SERVER_MODS_NOT_ON_WORKSHOP_RAIL = "This server requires mods that are not available. You will need to manually download the missing mods.",
            SERVER_MODS_WORKSHOP_VERSION_MISMATCH = "The server is running mods with an old version. The server owner must update the mods for new players to join.",
            SERVER_MODS_WORKSHOP_FAILURE = "Download of the required mods from the Steam Workshop failed. Please try again.",
            SERVER_MODS_WORKSHOP_ACCESS_DENIED = "Download of the required mods from the Steam Workshop failed because one or more mods is not visible to you.",
            SERVER_MODS_WORKSHOP_FAILURE_RAIL = "Download of the required mods failed. Please try again.",
            SERVER_MODS_WORKSHOP_ACCESS_DENIED_RAIL = "Download of the required mods failed because one or more mods is not visible to you.",
            ID_DST_SLOT_RESERVATION = "Attempt to join server failed because remaining player slots are reserved. Please try again once a slot frees up.",
            ID_DST_SERVER_IS_CLAN_ONLY = "You must be a member of this server's Steam Group to connect.",
            ID_DST_SERVER_IS_LAN_ONLY = "This server only allows players from their same local network.",
            ID_DST_DESTINATION_SERVER_NOT_AVAILABLE = "The server you were playing on is unavailable. Please try again later.",
            ID_DST_DEDICATED_SERVER_STARTUP_FAILED = "There was some sort of trouble starting the server. Please try again.",
			ID_SPLITSCREEN_INGAME_PLAYER2_SIGNED_OUT_OF_PS4 = "Your split-screen partner logged out in the middle of a game!",
			ID_SPLITSCREEN_UI_PLAYER2_SIGNED_OUT_OF_PS4 = "Your split-screen partner logged out. Return to the main menu to find another.",
			ID_SPLITSCREEN_INGAME_PLAYER1_SIGNED_OUT_OF_PSN = "Player 1 has signed out of "..STRINGS.PSN.." in the middle of a game!",
			ID_SPLITSCREEN_INGAME_PLAYER2_SIGNED_OUT_OF_PSN = "Player 2 has signed out of "..STRINGS.PSN.." in the middle of a game!",
			ID_SPLITSCREEN_UI_PLAYER1_SIGNED_OUT_OF_PSN = "You have signed out of "..STRINGS.PSN..". Now we have to set everything back up again...",
			ID_SPLITSCREEN_UI_PLAYER2_SIGNED_OUT_OF_PSN = "Your split-screen partner signed out. Return to the main menu to find another.",
            ID_DST_NETWORK_CONNECTION_LOST = "Check your connection and try again.",
            ID_DST_SAVE_FILE_DAMAGED = "Your world is damaged and cannot be loaded.",
        },
        OK = "OK",
        ACCOUNTS = "Account Page",
    },

    PAUSEMENU =
    {
        TITLE = "Paused",
        DST_TITLE = "Not Paused.",
        DST_SUBTITLE = "(Seriously! It's not.)",
        SAVEANDQUITTITLE = "Save and return to main menu?",
        SAVEANDQUITBODY = "Don't worry. We'll wait here for you.",
        SAVEANDQUITYES = "I said quit!",
        SAVEANDQUITNO = "Never mind...",
        QUITTITLE = "Return to main menu?",
        QUITBODY = "Leaving so soon?",
        QUITYES = "I said quit!",
        QUITNO = "Never mind...",
        OPTIONS = "Settings",
		PLAYERSTATUSSCREEN = "View Players",
        CONTROLS = "Controls",
        SAVEANDQUIT = "Save and Quit",
        QUIT = "Quit",
        CONTINUE = "Continue",
        DISCONNECT = "Disconnect",
        CLIENTQUITTITLE = "Leave Server",
        CLIENTQUITBODY = "Are you sure you want to leave the server?",
        HOSTQUITTITLE = "Shut Down Server",
        HOSTQUITBODY = "Are you sure you want to shut down the server? If you do, all current players will be disconnected.",
        YES = "Do it!",
        NO = "Maybe not...",
        AFK = "Go AFK",
        SERVER_ADMIN = "Server Admin",
        ISSUE = "Report an Issue",
        SERVERACTIONS = "Server Commands",
        CLOSE = "Close",
        PAUSED_DST_TITLE = "Paused!",
        AUTOPAUSED_DST_TITLE = "Auto-Paused!",
        PAUSED_DST_SUBTITLE = "Seriously. It is!",
        PAUSE_SERVER = "Pause Server",
        UNPAUSE_SERVER = "Unpause Server",

        AUTOPAUSE_TEXT = "The game is auto-paused.",
        PLAYERPAUSED_TEXT = "{player} paused the game.",
        HOSTPAUSED_TEXT = "The server host has paused the game.",
        SELFPAUSED_TEXT = "You have paused the game.",
        SCRAPBOOK = "Scrapbook",
    },

	WORDPREDICTIONWIDGET =
	{
		DISMISS = "Dismiss",
        PREV = "Scroll Left",
        NEXT = "Scroll Right",
        MINIMIZE = "Minimize",
        EXPAND = "Expand",
	},

    PLAYERSTATUSSCREEN =
    {
		LAVAARENA_SERVER_MODE = "{mode} - Round {num}",
        AGE_PREFIX = "Day ",
        AGE_DAY = " Day",
        AGE_DAYS = " Days",
        AFK = "Away",
        MUTE = "Mute",
        UNMUTE = "Unmute",
        KICK = "Kick",
        VOTEHOVERFMT = "Vote to %s",
        VOTESQUELCHEDHOVER = "You are currently on timeout for failed votes.",
        VOTEACTIVEHOVER = "Vote In Progress",
        VOTECANNOTSTART =
        {
            MINPLAYERS = "Not enough players to start a vote.",
            MINSTARTAGE = "You have not played long enough to start a vote.",
        },
        COMMANDCANNOTSTART =
        {
            COOLDOWN = "You cannot use this command again yet.",
        },
        BAN = "Ban",
        USERACTIONS = "More Actions...",
        ADMIN = "Admin",
        VIEWPROFILE = "View Player",
        VIEWGAMERCARD = "Show Gamercard",
        CLEAR = "Remove Player",
        KICKCONFIRM_TITLE = "Kick",
        KICKCONFIRM_BODY = "Are you sure you want to kick",
        BANCONFIRM_TITLE = "Ban",
        BANCONFIRM_BODY = "Are you sure you want to ban and kick",
        OK = "Do it!",
        CANCEL = "Cancel",
        MODSLISTPRE = "Mods:",
        SURVIVAL = "Survival",
        WILDERNESS = "Wilderness",
        ENDLESS = "Endless",
        EMPTY_SERVER = "The server is empty.",
        PERF_HOST_LEVELS =
        {
            "Host Performance: Good",
            "Host Performance: Okay",
            "Host Performance: Bad",
        },
        PERF_CLIENT_LEVELS =
        {
            "Client Performance: Good",
            "Client Performance: Okay",
            "Client Performance: Bad",
        },
        LOBBY_PERF_LEVELS =
        {
            "Connection: Good",
            "Connection: Okay",
            "Connection: Bad",
        },
        PERF_CLIENT_LEVEL_UNKNOWN = "Client Performance: Unknown",
    },

    COMMANDSSCREEN =
    {
        SERVERSUBTITLE = "Actions for",
        SERVERTITLE = "The Server",
        USERSUBTITLE = "User Actions for",
        CANCEL = "Cancel",
        VOTEFMT = "%s (vote)",
        CONFIRMTITLE = "Really %s?",
        CONFIRMTITLE_TARGET = "Really %s %s?",
        CONFIRMBODY = "Are you sure?",
		HIDE_SERVERNAME = "Hide Server Name",
		SHOW_SERVERNAME = "Show Server Name",
    },

    WORLDRESETDIALOG =
    {
        TITLE = "Day %d: Everyone is dead",
        TITLE_LATEJOIN = "Day %d: Everyone else is dead. Save them!",
        RESET_MSG = "World will reset in: %d",
        SURVIVED_MSG = "Survived %d Days",
        SURVIVED_MSG_1_DAY = "Survived %d Day",
        RESET_BUTTON = "Reset Now",
        BUTTONPROMPT1 = "Hold ",
        BUTTONPROMPT2 = "to Reset Now",
        REGEN_MSG = "Everyone is dead. The world will reset in: %d",

		REGEN_CONFIRM_TITLE = "Start a New World",
		REGEN_CONFIRM_BODY = "Are you sure you want to start a new world?",

		REVIVE_0 = "I hope you are playing with friends, or had prepared a way to revive...",
		REVIVE_1 = "Haunt a {item1} to revive, or find another way.",
		REVIVE_2 = "Haunt a {item1} or {item2} to revive, or find another way.",
    },

    VOTEDIALOG =
    {
        TIME_REMAINING = "Time Remaining: %d",
        VOTE = "Vote",
        CANCEL = "Cancel",
        YES = "Yes",
        NO = "No",
    },

    CHATINPUTSCREEN =
    {
        WHISPER = "whisper:",
        SAY = "say:",
		STEAMDECK_MSG_PROMPT = "Message:",
        WHISPER_DESIGNATOR = "[W]",
        HELP_WHISPER = "Whisper",
        HELP_SAY = "Say",
		HELP_OPEN_VIRTUAL_KEYBOARD = "Open Keyboard",
    },

    USERCOMMANDS =
    {
        SQUELCHEDFMT = "You aren't allowed to start a '%s' vote right now.",
        DISABLEDFMT = "You can't run '%s' right now.",
        FAILEDFMT = "You can't run '%s' right now.",
        BADTARGETFMT = "You can't run '%s' on %s.",
        NOTALLOWEDFMT = "You don't have permission to run '%s'.",
        MISSINGPARAMSFMT = "Missing parameters! Type /help %s for more info.",
        BADUSERFMT = "There is no one on the server by the name of '%s'. Open the scoreboard to view all current players.",
    },

    BUILTINCOMMANDS =
    {
        EMOTES =
        {
            PRETTYNAMEFMT = "%s emote",
            DESC = "Perform an emote!",
        },
        HELP =
        {
            PRETTYNAME = "Command Help",
            DESC = "Get more info on commands.",
            OVERVIEW = "Type '/help commandname' for more info on a command.",
            AVAILABLE = "Available commands:",
            NOTFOUND = "Couldn't find a command called '%s'",
        },
        EMOTE =
        {
            PRETTYNAME = "Emote",
            DESC = "Express your feelings!",
        },
        BUG =
        {
            PRETTYNAME = "Report Bug",
            DESC = "Run this to report a problem with the game!",
        },
        RESCUE =
        {
            PRETTYNAME = "Rescue Me!",
            DESC = "If you ever find yourself stuck in the void, this will put you back on land.",
        },
        KICK =
        {
            PRETTYNAME = "Kick",
            DESC = "Boot someone off the server.",
            VOTETITLEFMT = "Should we kick %s?",
            VOTENAMEFMT = "vote to kick %s",
        },
        BAN =
        {
            PRETTYNAME = "Ban",
            DESC = "Boot someone off the server. 'seconds' param makes the ban temporary.",
            DESC_CONSOLE = "Boot someone off the server.",
        },
        STOPVOTE =
        {
            PRETTYNAME = "Stop Vote",
            DESC = "Cancel a vote in progress if you don't like it!",
        },
        ROLL =
        {
            PRETTYNAME = "Dice Roll",
            DESC = "Random dice roll from 1 to 100.",
        },
        RESET =
        {
            PRETTYNAME = "Reset",
            DESC = "Restart the server from the last save.",
        },
        ROLLBACK =
        {
            PRETTYNAME = "Rollback",
            DESC = "Rollback the server to a previous save.",
            VOTETITLEFMT = "Should we rollback this world?",
            VOTENAMEFMT = "vote to rollback the server",
            VOTEPASSEDFMT = "Rolling server back in 5 seconds...",
        },
        REGENERATE =
        {
            PRETTYNAME = "Regenerate World",
            DESC = "Destroy this world and start with a brand new one!",
            VOTETITLEFMT = "Should we regenerate the world?",
            VOTENAMEFMT = "vote to regenerate the world",
            VOTEPASSEDFMT = "Regenerating world in 5 seconds...",
        },
		LOCKWOBY =
		{
			PRETTYNAME = "Lock Woby's Pack",
			DESC = "Only you have access to items in Woby's pack, unless she is delivering to another player.",
			NOTIFY = "Woby's pack is now locked.",
		},
		UNLOCKWOBY =
		{
			PRETTYNAME = "Unlock Woby's Pack",
			DESC = "Everyone will have access to items in Woby's pack.",
			NOTIFY = "Woby's pack is now unlocked.",
		},
    },

    MODSSCREEN =
    {
        APPLY = "Apply",
        CANCEL = "Cancel",
        BACK = "Back",
        RESETDEFAULT = "Reset",
        MOREMODS = "More Mods",
        VERSION = "version %s",
        AUTHORBY = "by %s",
        MODLINK = "Mod Page",
        MODLINKGENERIC = "Mod Forums",
        MODLINK_MOREINFO = "More Info",
        --MODLINK = "Take me to the mod page!",
        --MODLINKGENERIC = "Mod discussion forums",
        COMPATIBILITY_UNKNOWN = "Compatibility unknown.",
        COMPATIBILITY_DST = "Compatible with Don't Starve Together.",
        COMPATIBILITY_ALL = "Compatible with everything.",
        COMPATIBILITY_DS_ONLY = "Compatible with Don't Starve only.",
        COMPATIBILITY_ROG_ONLY = "Compatible with Reign of Giants only.",
        COMPATIBILITY_NONE = "This mod has no compatibility with Don't Starve.",
        CONFIGUREMOD = "Configure Mod",
        UPDATEMOD = "Update Mod",
        UPDATINGMOD = "Updating...",
        UPTODATE = "Up To Date",
        DOWNLOADINGMOD = "Downloading:\n{name}",
        CONFIGSCREENTITLESUFFIX = "Configuration",
        BACKTITLE = "Discard Changes",
        BACKBODY = "Do you want to discard the changes you made to this mod's options?",
        UNKNOWN_MOD_CONFIG_SETTING = "[NAME UNDEFINED]",
        YES = "Yes",
        NO = "No",
        ENABLE = "Enable",
        DISABLE = "Disable",
        WORKING_NORMALLY = "This mod is enabled.",
        DISABLED_MANUAL = "This mod is disabled.",
        DISABLED_ERROR = "Crashed! Disabled.",
        STATUS =
        {
            WORKING_NORMALLY = "Enabled",
            DISABLED_MANUAL = "Disabled",
            DISABLED_ERROR = "Crashed!",
        },
        NO_MODS_TITLE = "No Mods Installed",
        NO_MODS_OK = "Show Me!",
        NO_MODS = "You have no mods installed. Mods can be downloaded from the Steam Workshop.",
        NO_MODS_TYPE = "You have no %s mods installed. Mods can be downloaded from the Steam Workshop.",
        NO_MODS_CLIENT_TGP = "You don't have any client mods installed. You can download some from the WeGame client.",
        NO_MODS_SERVER_TGP = "You don't have any server mods installed. You can download some from the WeGame client.",
        NO_MODS_LINK = "Take me to the mods!",
        SHOWCASEMODS = "Get Mods",
        NO_MODS_PLAIN_OK = "Ok",
        TOPMODS = "Top Mods",
        LOADING = "Loading",
        RESTART_TITLE = "Restart Required",
        RESTART_REQUIRED = "To enable or disable this mod, you will have to exit and restart the game.",
        RESTART = "Exit Now",
        MOD_WARNING_TITLE = "Mod Warning",
        MOD_WARNING = "This is not a Steam Workshop mod. Players will need to download it manually if you host a server.",
        MOD_WARNING_RAIL = "This is not a WeGame mod. Players will need to download it manually if you host a server.",
        DST_COMPAT_WARNING = "This mod hasn't been tagged as compatible with Don't Starve Together. It may cause issues with your game.",
        OK = "OK",
        MODPAGE = "Mod Page",
        MODTITLE = "Mods",
        CLIENTMODS = "Client Mods",
        SERVERMODS = "Server Mods",
        SERVERMODS_TITLE_READONLY = "Configure Server Mods",
        TOOLTIP_SHOWCASEMODS = "See popular and featured mods",
        TOOLTIP_CLIENTMODS = "Cosmetic mods that run on your machine",
        TOOLTIP_SERVERMODS = "Gameplay-affecting mods that run on the game server",
        CLEANALL = "Clean All",
        CLEANALL_TITLE = "Clean All Mod Workshop Data",
        CLEANALL_BODY = "Are you sure you want to clean your local Workshop data?\nThis will result in a full download of all your subscribed mods, and your mod configuration settings being reset.",
        UPDATEALL = "Update All",
        UPTODATEALL = "All Up To Date",
        UPDATEALL_TITLE = "Update All Mod Workshop Data",
        UPDATEALL_BODY = "Are you sure you want to update all your subscribed mods?",
        VIEW_AND_CONFIGURE = "Mod can be viewed and configured.",
        OUT_OF_DATE = "Mods Out of Date:",
        CANCEL_TITLE = "Lose Changes?",
        CANCEL_BODY = "Do you want to abandon your changes?",
        NOCONFIG = "No Configurations",
        WORKSHOP_FILTER_FMT = "Mod Type Filter: {mode}",
        WORKSHOP_FILTER = "Workshop",
        WORKSHOP_FILTER_RAIL = "Warehouse",
        LOCAL_FILTER = "Local",
        ALL_FILTER = "All",
        STATUS_FILTER_FMT = "Mod Status Filter: {mode}",
        ENABLED_FILTER = "Enabled",
        DISABLED_FILTER = "Disabled",
        ENABLEDDISABLED_FILTER = "Both",
        SEARCH = "Search",
        MOD_DEPENDENCIES_TITLE = "Dependencies Required",
        MOD_HAS_DEPENDENCIES_FMT = "{mod} requires other mods to run, it will subscribe and enable these if you enable this mod:",
        MOD_DEPENDENTS_TITLE = "Required By Other Mods",
        MOD_HAS_DEPENDENTS_FMT = "{mod} is required for other mods to run, if you disable this mod these mods will be disabled:",
        DISABLE_ALL = "Disable All",
        REQUIRED_MODS_DOWNLOADING_TITLE = "Required Mods Are Downloading",
        REQUIRED_MODS_DOWNLOADING = "The game has not finished downloading required mods.\nEither wait until the mods have finished downloading, or disable mods which have dependencies.",
        DOWNLOADING_MODS = "Downloading Mods...",
    },

    CUSTOMIZATIONSCREEN =
    {
        SETTINGSPRESET = "Settings Presets",
        WORLDGENPRESET = "Generation Presets",
        COMBINEDPRESET = "World Presets",
        CONFIRM_PRESET = "Apply Preset",
        LOADPRESET = "Choose Preset",
        LOADPRESET_SETINGS = "Choose Settings Preset",
        LOADPRESET_WORLDGEN = "Choose Generation Preset",
        LOADPRESET_COMBINED = "Choose World Preset",
        NAMEPRESET = "Name:",
        NEWPRESET = "Name Your Preset",
        DESCRIBEPRESET = "Description:",
        MISSINGPRESETNAME_TITLE = "Missing Preset Name",
        MISSINGPRESETNAME_BODY = "You forgot to enter a name for your preset.",
        PRESETEXISTS_TITLE = "Preset Already Exists",
        PRESETEXISTS_BODY = "A preset with the name \"%s\" already exists, please choose a different name.",
        DELETEPRESET = "Delete Preset",
        DELETEPRESET_TITLE = "Delete Preset \"%s\"",
        DELETEPRESET_BODY = "Are you sure?",
        SAVECHANGESFAILED_TITLE = "Failed To Save Preset",
        SAVECHANGESFAILED_BODY = "An error occured while saving your preset, please try again.",
        DELETE = "Delete",
        EDITPRESET = "Update Current Preset",
        UNLINKPRESETSTR = "Seperate World Presets into Settings and Worldgen Presets",
        LINKPRESETSTR = "Link Settings and Worldgen Presets into World Presets",
        APPLY = "Apply",
        SAVEPRESET = "Save As New Preset",
        SAVEPRESETCHANGES = "Save Changes",
        CANCEL = "Cancel",
        BACK = "Back",
        DEFAULT_PRESET_DESC = "Lots of pigs and spiders and a Tallbird nest.",
        LOSECHANGESTITLE = "Lose Changes?",
        LOSECHANGESBODY = "Apply a new preset and lose custom changes?",
        YES = "Yes",
        NO = "No",
        CUSTOMDESC = "Your world, your rules!",
        CUSTOM = "%s (Custom)",
        BACKTITLE = "Discard Changes",
        BACKBODY = "Do you want to discard the changes you made to your world generation options?",
        BACKBODY_SETTINGS = "Do you want to discard the changes you made to your world settings?",
        BACKBODY_WORLDGEN = "Do you want to discard the changes you made to your world generation?",
        BACKBODY_COMBINED = "Do you want to discard the changes you made to your world?",
        INVALIDSEASONCOMBO_TITLE = "All Seasons Disabled",
        INVALIDSEASONCOMBO_BODY = "You have set all seasons to \"None\".\nPlease turn on at least one season to continue.",
        OKAY = "Okay",

        TAB_TITLE_WORLDSETTINGS = "World Settings",
        TAB_TITLE_WORLDGENERATION = "World Generation",

        PRESETLEVELS =
        {
            -- indexed titles left in place for backwards compatibility with mods...
                "Default",
                "Together Plus",             -- Bootstrap the start
                "Lights Out",
                "Soggy",                    -- Too much water - swamp etc
                "Eternal Summer",           -- Less water, no swamp etc
                "Winter you'll do next?",   -- Winter focus
                "Island you an axe",        -- Island hopping
                "Crazy Eddie",              -- Focus on sanity play
                "Nighttime Antics",         -- Focus on nighttime play
                "Together Forever",	        -- Multiplayer coop
                "No Giants Here",           -- Nothing Reign Of Giants
                "The Caves",                 -- Caves content in DST
                "Caves Plus",                -- harder caves

            SURVIVAL_TOGETHER = "Survival",
            SURVIVAL_TOGETHER_PS4 = "Generic Forest",
            SURVIVAL_TOGETHER_CLASSIC = "No Giants Here",
            SURVIVAL_DEFAULT_PLUS = "Forest Plus",
            COMPLETE_DARKNESS = "Lights Out",
            LIGHTS_OUT = "Lights Out",
            DST_CAVE = "The Caves",
            DST_CAVE_PS4 = "Standard Caves",
            DST_CAVE_PLUS = "Caves Plus",
            LAVAARENA = "The Forge",
            QUAGMIRE = "The Gorge",
            TERRARIA = "Taste of Terraria",
            TERRARIA_CAVE = "Caves of Terraria",

			RELAXED = "Relaxed",
			WILDERNESS = "Wilderness",
			ENDLESS = "Endless",

            MOD_MISSING = "<MOD MISSING>",
        },

        PRESETLEVELDESC =
        {
            -- indexed titles left in place for backwards compatibility with mods...
                "The standard Don't Starve experience.",
                "A quicker start in a harsher world.",
                "A dark twist on the standard Don't Starve experience.",
                "The standard Don't Starve Experience 4",
                "The standard Don't Starve Experience 5",
                "The standard Don't Starve Experience 6",
                "The standard Don't Starve Experience 7",
                "The standard Don't Starve Experience 8",
                "The standard Don't Starve Experience 9",
                "The multiplayer Don't Starve experience.",
                "Don't Starve Together with Reign of Giants turned off.",
                "Delve into the caves... together!",
                "A darker, more arachnid-y cave experience.",

            SURVIVAL_TOGETHER_CLASSIC = "Don't Starve Together with Reign of Giants turned off.",
            SURVIVAL_DEFAULT_PLUS = "A quicker start in a harsher world.",
            DST_CAVE = "Delve into the caves... together!",
            DST_CAVE_PLUS = "A darker, more arachnid-y cave experience.",
            LAVAARENA = "Dare you prove yourself in The Forge?",
            QUAGMIRE = "Can you stand the heat in The Gorge?",
            TERRARIA = "Don't Starve Together, with a Terraria-inspired twist.",
            TERRARIA_CAVE = "Don't Starve Together, with a Terraria-inspired twist... in the caves!",

            SURVIVAL_TOGETHER = "The standard Don't Starve experience.",
			RELAXED = "A more relaxed playstyle with less threats from the world.\nSurvivors will not die from starvation, freezing, overheating, or the darkness.\nDamage to survivors is reduced. Resurrection is always available via the Florid Postern.",
			WILDERNESS = "It's wild and dangerous out there!\nEnter at a random location in the world.\nWhen you die: pick a new survivor and try, try again.",
			ENDLESS = "A never-ending Don't Starve sandbox.\nResurrection is always available via the Florid Postern.",
            COMPLETE_DARKNESS = "A dark twist on the standard Don't Starve experience.",
            LIGHTS_OUT = "A dark twist on the standard Don't Starve experience.",

            MOD_MISSING = "This preset came from a mod, but that mod isn't active right now!",
        },

        PRESET_PLAYSTYLE_LABEL = "Playstyle:",

        TASKSETNAMES =
        {
            DEFAULT = "Together",
            CLASSIC = "Classic",
            CAVE_DEFAULT = "Underground",
            LAVA_ARENA = "The Forge",
            QUAGMIRE = "The Gorge",
        },

		ICON_TITLES = {
			AUTUMN = "Autumn",
			SPRING = "Spring",
			SUMMER = "Summer",
			WINTER = "Winter",

			PREFABSWAPS_START = "Starting Resource Variety",

			BRANCHING = "Branches",
			LOOP = "Loops",
			TASK_SET = "Biomes",
			WORLD_SIZE = "Size",
			START_LOCATION = "Spawn Area",

			DAY = "Day Type",
			SEASON_START = "Starting Season",
		},

        CUSTOM_PRESET = "Custom Preset",
        CUSTOM_PRESET_DESC = "Custom preset",
        MAX_PRESETS_EXCEEDED_TITLE = "Preset Limit Reached",
        MAX_PRESETS_EXCEEDED_BODY = "Only 5 custom presets allowed.\nChoose one to overwrite:",
        OVERWRITE = "Overwrite",
        UNKNOWN_PRESET = "Unknown Preset",
        UNKNOWN_PRESET_DESC = "This game was started with some settings we don't quite recognize.",
        REVERTCHANGES = "Revert Changes",

        TASK_SET = "Biomes",
        START_LOCATION = "Spawn Area",
        WORLD_SIZE = "World Size",
        BRANCHING = "Branches",
        LOOP = "Loops",
		ROADS = "Roads",
        AUTUMN = "Autumn",
        WINTER = "Winter",
        SPRING = "Spring",
        SUMMER = "Summer",
        SEASON_START = "Starting Season",
        DAY = "Day Type",
        WEATHER = "Rain",
        LIGHTNING = "Lightning",
        FROGRAIN = "Frog Rain",
        WILDFIRES = "Wildfires",
        TOUCHSTONE = "Touch Stones",
        BOONS = "Failed Survivors",
        SPECIALEVENT = "Events",

        CROW_CARNIVAL = "Midsummer Cawnival",
        HALLOWED_NIGHTS = "Hallowed Nights",
        WINTERS_FEAST = "Winter's Feast",
        YEAR_OF_THE_GOBBLER = "Year of the Gobbler",
        YEAR_OF_THE_VARG = "Year of the Varg",
        YEAR_OF_THE_PIG = "Year of the Pig King",
        YEAR_OF_THE_CARRAT = "Year of the Carrat",
        YEAR_OF_THE_BEEFALO = "Year of the Beefalo",
		YEAR_OF_THE_CATCOON = "Year of the Catcoon",
        YEAR_OF_THE_BUNNYMAN = "Year of the Bunnyman",
        YEAR_OF_THE_DRAGONFLY = "Year of the Dragonfly",
        YEAR_OF_THE_SNAKE = "Year of the Depths Worm",        

        PREFABSWAPS = "Changing Resources",
        PREFABSWAPS_START = "Starting Resource Variety",
        DISEASE_DELAY = "Disease",
        PETRIFICATION = "Forest Petrification",
		EXTRASTARTINGITEMS = "Extra Starting Resources",
		SEASONALSTARTINGITEMS = "Seasonal Starting Items",
		SPAWNPROTECTION = "Griefer Spawn Protection",
		DROPEVERYTHINGONDESPAWN = "Drop Items on Disconnect",

        REGROWTH = "Regrowth Multiplier",
        BERRYBUSH = "Berry Bushes",
        CARROT = "Carrots",
        MUSHROOM = "Mushrooms",
        CACTUS = "Cacti",
        FLOWERS = "Flowers, Evil Flowers",
        GRASS = "Grass",
        SAPLING = "Saplings",
        MARSHBUSH = "Spiky Bushes",
        TUMBLEWEED = "Tumbleweeds",
        REEDS = "Reeds",
        TREES = "Trees (All)",
        FLINT = "Flint",
        ROCK = "Boulders",
        ROCK_ICE = "Mini Glaciers",
        METEORSPAWNER = "Meteor Fields",
        METEORSHOWERS = "Meteor Frequency",
        RABBITS = "Rabbit Holes",
        MOLES = "Mole Burrows",
        BUTTERFLY = "Butterflies",
        BIRDS = "Birds",
        BUZZARD = "Buzzards",
        CATCOON = "Hollow Stump",
        PERD = "Gobblers",
        PIGS = "Pig Houses",
        MERM = "Leaky Shack",
        LIGHTNINGGOAT = "Volt Goats",
        BEEFALO = "Beefalos",
        BEEFALOHEAT = "Beefalo Mating Frequency",
        HUNT = "Hunts",
        ALTERNATEHUNT = "Hunt Surprises",
        PENGUINS = "Pengulls",
        PONDS = "Ponds",
        CAVE_PONDS = "Ponds",
        BEES = "Bee Hives",
        ANGRYBEES = "Killer Bee Hives",
        TALLBIRDS = "Tallbirds",
        SPIDERS = "Spider Dens",
        CAVE_SPIDERS = "Spilagmites",
        HOUNDS = "Hound Attacks",
        WINTERHOUNDS = "Ice Hound Waves",
        SUMMERHOUNDS = "Fire Hound Waves",
        RIFTS_FREQUENCY = "Wild Rift Frequency",
        RIFTS_ENABLED = "Wild Rifts",
        RIFTS_FREQUENCY_CAVE = "Wild Rift Frequency",
        RIFTS_ENABLED_CAVE = "Wild Rifts",
        LUNARHAIL_FREQUENCY = "Lunar Hail",
        ACIDRAIN_ENABLED = "Acid Rain",
        WANDERINGTRADER_ENABLED = "Wandering Trader",
        HOUNDMOUND = "Hound Mounds",
        MERMS = "Merms",
        TENTACLES = "Tentacles",
        CHESS = "Clockworks",
        LUREPLANTS = "Lureplants",
        WALRUS = "MacTusk Camps",
        LIEFS = "Treeguards",
        MANDRAKE = "Mandrakes",
        DECIDUOUSMONSTER = "Poison Birchnut Trees",
        KRAMPUS = "Krampii",
        BEARGER = "Bearger",
        DEERCLOPS = "Deerclops",
        GOOSEMOOSE = "Meese/Geese",
        DRAGONFLY = "Dragonfly",
        ANTLIONTRIBUTE = "Antlion Tribute",
        BATS = "Bats",
        FISSURE = "Nightmare Fissures",
        WORMATTACKS = "Cave Worm Attacks",      
        WORMATTACKS_BOSS = "Great Worm",
        WORMS = "Cave Worms",
        SLURPER = "Slurpers",
        BUNNYMEN = "Rabbit Hutches",
        SLURTLES = "Slurtle Mounds",
        ROCKY = "Rock Lobsters",
        MONKEY = "Splumonkey Pods",
        MUSHTREE = "Mushroom Trees",
        FERN = "Cave Ferns",
        FLOWER_CAVE = "Light Flowers",
        WORMLIGHTS = "Glow Berries",
        BANANA = "Bananas",
        LICHEN = "Lichen",
        EARTHQUAKES = "Earthquakes",
        CAVELIGHT = "Sinkhole Lights",

        PENGUINS_MOON = "Permafrost Pengulls",
        BEES_SETTING = "Bees",
        CATCOONS = "Catcoons",
        FROGS = "Frogs",
        GRASSGEKKOS = "Grass Gekko Morphing",
        MOLES_SETTING = "Moles",
        MOSQUITOS = "Mosquitos",
        RABBITS_SETTING = "Rabbits",
        WOBSTERS = "Wobsters",
        PIGS_SETTING = "Pigs",
        SLURTLES_SETTING = "Slurtles",
        SNURTLES = "Snurtles",
        BUNNYMEN_SETTING = "Bunnymen",
        ROCKY_SETTING = "Rock Lobsters",
        MONKEY_SETTING = "Splumonkeys",
        LIGHTFLIERS = "Bulbous Lightbugs",
        CRABKING = "Crabking",
        MUTATED_HOUNDS = "Horror Hounds",
        HOUND_MOUNDS = "Hounds",
        BEEQUEEN = "Bee Queen",
        MALBATROSS = "Malbatross",
        FRUITFLY = "Lord of the Fruit Flies",
        KLAUS = "Klaus",
        SPIDERQUEEN = "Spider Queen",
        TOADSTOOL = "Toadstool",
        DUSTMOTHS = "Dust Moths",
        BATS_SETTING = "Bats",
        MOLEBATS = "Naked Mole Bats",
        MUSHGNOME = "Mush Gnomes",
        SHADOWCREATURES = "Sanity Monsters",
        NIGHTMARECREATURES = "Ruins Nightmares",
        SHARKS = "Sharks",
        SPIDERS_SETTING = "Spiders",
        SPIDER_WARRIORS = "Spider Warriors",
        SPIDER_HIDER = "Cave Spiders",
        SPIDER_SPITTER = "Spitter Spiders",
        MOON_SPIDER = "Shattered Spiders",
        SPIDER_DROPPER = "Dangling Depth Dwellers",
        SQUID = "Skittersquids",
        WASPS = "Killer Bees",
        ATRIUMGATE = "Ancient Gateway",
        BRIGHTMARECREATURES = "Enlightenment Monsters",
        GNARWAIL = "Gnarwails",
        FISHSCHOOLS = "Schools of Fish",
        WALRUS_SETTING = "MacTusk",
        COOKIECUTTERS = "Cookie Cutters",
        ITEMMIMICS = "Mimicreeps",
        CHEST_MIMICS = "Ornery Chests",

        EVERGREEN_REGROWTH = "Evergreens",
        TWIGGYTREES_REGROWTH = "Twiggy Trees",
        DECIDUOUSTREE_REGROWTH = "Birchnut Trees",
        MUSHTREE_REGROWTH = "Mushroom Trees",
        MOON_TREE_REGROWTH = "Lune Trees",
        MUSHTREE_MOON_REGROWTH = "Lunar Mushtrees",
        CARROTS_REGROWTH = "Carrots",
        REEDS_REGROWTH = "Reeds",
        CACTUS_REGROWTH = "Cacti",
        FLOWERS_REGROWTH = "Flowers",
        FLOWER_CAVE_REGROWTH = "Light Flower",
        LIGHTFLIER_FLOWER_REGROWTH = "Lightbug Flower",
        SALTSTACK_REGROWTH = "Salt Formations",

        MOON_TREE = "Lune Trees",
        MOON_SAPLING = "Lunar Saplings",
        MOON_BERRYBUSH = "Stone Fruit Bushes",
        MOON_ROCK = "Lunar Rocks",
        MOON_SPIDERS = "Shattered Spider Holes",
        MOON_CARROT = "Carrats",
        MOON_FRUITDRAGON = "Saladmander",
        MOON_HOTSPRING = "Hot Springs",
        MOON_FISSURE = "Celestial Fissures",
        MOON_STARFISH = "Anenemies",
        MOON_BULLKELP = "Beached Bull Kelp",

        OCEAN_SEASTACK = "Sea Stacks",
        OCEAN_SHOAL = "Shoals",
        OCEAN_WATERPLANT = "Sea Weeds",
        OCEAN_WOBSTERDEN = "Wobster Mounds",
        OCEAN_BULLKELP = "Bull Kelp",

		EYEOFTERROR = "Eye of Terror",
		TERRARIUMCHEST = "Terrarium",

        PALMCONETREE = "Palmcone Tree",
        PALMCONETREE_REGROWTH = "Palmcone Tree",
        PIRATERAIDS = "Moon Quay Pirates",

        PORTAL_SPAWNRATE = "Portal Activity",
        BANANABUSH_PORTALRATE = "Banana Bushes",
        LIGHTCRAB_PORTALRATE = "Crustashines",
        MONKEYTAIL_PORTALRATE = "Monkeytails",
        PALMCONE_SEED_PORTALRATE = "Palmcone Sprouts",
        POWDER_MONKEY_PORTALRATE = "Powder Monkeys",

        BASICRESOURCE_REGROWTH = "Basic Resources",
        SPAWNMODE = "Spawn Mode",
        PORTALRESURECTION = "Revive At Florid Postern",
        GHOSTENABLED = "Survivor Death",
        GHOSTSANITYDRAIN = "Ghost Sanity Drain",
        RESETTIME = "Death Reset Timer",

        HUNGER = "Hunger Damage",
        TEMPERATUREDAMAGE = "Temperature Damage",
        DARKNESS = "Darkness Damage",
        HEALTHPENALTY = "Max Health Penalty",
		LESSDAMAGETAKEN = "Damage Taken",
        STAGEPLAYS = "Stage Plays",
        JUNKYARD = "Junk Yard",
        BALATRO = "JIMBO",

        DAYWALKER = "Nightmare Werepig",
        DAYWALKER2 = "Scrappy Werepig",
        SHARKBOI = "Frostjaw",

        OCEAN_OTTERDENS = "Marotter Dens",
        OTTERS_SETTING = "Marotters",

        MUTATED_BIRDS = "Mutated Birds",
        MUTATED_MERM = "Mutated Merms",
        MUTATED_SPIDERQUEEN = "Shattered Spider Holes",
        MUTATED_BIRD_GESTALT = "Bright-Beaked Birds",
        MUTATED_BUZZARD_GESTALT = "Crystal-Crested Buzzards",
        MUTATED_DEERCLOPS = "Crystal Deerclops",
        MUTATED_BEARGER = "Armored Bearger",
        MUTATED_WARG = "Possessed Vargs",
		-- End of world customization strings
    },

    QUICKJOINSCREEN =
    {
        TITLE = "Quick Join",
        BODY = "Searching for servers",

        JOIN_BTN = "Join",

        NO_SERVERS_TITLE = "Quick Join Failed",
        NO_SERVERS_MSG = "No servers could be found matching the quick join criteria.",
        NO_SERVERS_BROWSE = "Browse Games",
        NO_SERVERS_HOST = "Host Game",
        NO_SERVERS_CLOSE = "Close",

        CONNECTING_TO_SERVER = "Connecting to Server: {server}",
    },

    EVENT_QUICKJOINSCREEN =
    {
        TITLE = "Quick Match",
        BODY = "Searching for available matches",

        JOIN_BTN = "Join",

        NO_SERVERS_TITLE = "Quick Match Failed",
        NO_SERVERS_MSG = "No servers could be found matching the quick match criteria.",
        NO_SERVERS_BROWSE = "Browse",
        NO_SERVERS_HOST = "Custom Match",
        NO_SERVERS_CLOSE = "Close",

        CONNECTING_TO_SERVER = "Connecting to Server: {server}",
    },

    CROSS_SAVE_DIALOG =
    {
        TITLE = "Import saved data?",
        BODY = "PlayStation®4 system saved data has been found. Do you want to import it?",

        YES = "Yes",
        NO = "No",
    },

    CROSS_SAVE_DIALOG_CONFIRM =
    {
        TITLE = "Overwrite saved data?",
        BODY = "Importing will overwrite any existing saved data. Are you sure?",

        YES = "Yes",
        NO = "No",
    },

    SERVERLISTINGSCREEN =
    {
        SERVER_LIST_TITLE = "Servers",
        SERVER_LIST_TITLE_INTENT = "%s Servers",
        SERVER_LIST_TITLE_PLAYSTYLE = "%s Servers",
        DIRECTCONNECT = "Direct Connect",
        REFRESH = "Refresh",
        REFRESHING = "Refreshing...",
        JOIN = "Join",
        REPORT = "Report Server",
        REPORTREASON = "Reason for Report",
        OK  = "OK",
        CANCEL  = "Cancel",
        BACK = "Back",
        LOGOUT = "Log Out",
        SORT_BY = "Sort By:",
        SORTING_TYPES = {
            RELEVANCE = "Relevance",
            PLAYERCOUNT = "Most Active Players",
            PING = "Best Connection",
            SERVER_NAME_AZ = "Server Name A-Z",
            SERVER_NAME_ZA = "Server Name Z-A",
        },
        PLAYERS = "Players",
        NAME = "Name",
        PING = "Ping",
        DETAILS = "Details",
        SERVERDETAILS = "Details",
        FILTERS = "Filters",
        PASSWORDREQUIRED = "Server Requires Password",
        CONNECTION = "Connection:",
        SEARCH = "Search",
        HASPASSWORD = "Password Protected:",
        HASPASSWORD_DETAIL = "Password Protected",
        GAMEMODE = "Game Mode:",
        FRIENDSONLY = "Friends:",
        CLANONLY = "Steam Group:",
        HASPVP = "PvP:",
        EVENT = "Event:",
        HASPVP_DETAIL = "PvP",
        ISDEDICATED = "Dedicated Server",
        SERVERTYPE = "Server Type:",
        ISEMPTY = "Show Empty Servers:",
        ISFULL = "Show Full Servers:",
        ISPAUSED = "Hide Paused Servers:",
        MINCURRPLAYERS = "Min Players Active",
        MAXCURRPLAYERS = "Max Players Active",
        MAXSERVERSIZE = "Max Players",--"Max Server Size",
        HASCHARACTER = "Previously Visited:",
        MINOPENSLOTS = "Min Slots Open:",
        ON = "On",
        OFF = "Off",
        ANY = "Any",
        YES = "Yes",
        NO = "No",
        MINE = "Mine",
        PRIVATE = "Private",
        ONLINE = "Online",
        OFFLINE = "Offline",
        DEDICATED = "Dedicated",
		OFFICIAL = "Klei Official",
        HOSTED = "Hosted",
        WILDERNESS = "Wilderness",
        CUSTOM = "Custom",
        SHOWLAN = "Show LAN:",
        VERSIONCHECK = "Version Matches:",
        NOSERVERSELECTED = "No Server Selected",
        NOMODS = "No Mods",
        VIEWMODS = "View Mods",
        VIEWMODS_LAN = "Mods Unknown",
        NOTAGS = "No Tags",
        VIEWTAGS = "View Tags",
        MODSENABLED = "Mods Enabled:",
		TOGGLE_SERVER_NAME = "Filter Server Name",
        MODSTITLE = "Mods",
        TAGSTITLE = "Tags",
        MOD_WARNING_TITLE = "Mods Enabled",
        MOD_WARNING_BODY = "This server has mods enabled. Klei won't be able to help if you encounter issues while playing on a modded server.",
        CLIENT_MODS_DISABLED_TITLE = "Client Mods Disabled",
        CLIENT_MODS_DISABLED_BODY = "Your client mods will be temporarily disabled while playing on this server.",
        PASSWORD_ICON_HOVER = "Passworded",
        DEDICATED_ICON_HOVER = "Dedicated Server",
        PAUSED = "Paused",
		DEDICATED_KLEI_ICON_HOVER = "Klei Official Server",
        FRIEND_ICON_HOVER = "Friends Playing",
        FRIEND_SERVER_ICON_HOVER = "Friend-Hosted",
        CLAN_OTHER_ICON_HOVER = "Group Server",
        CLAN_OPEN_ICON_HOVER = "Group Server (Your Group)",
        CLAN_CLOSED_ICON_HOVER = "Private Group Server (Your Group)",
        PVP_ICON_HOVER = "PvP",
        MODS_ICON_HOVER = "Modded",
        CLOUD_SAVE_HOVER = "Cloud Save",
        FILTER_RESET = "Reset Filters",
        MODS_HIDDEN_MISMATCH = "Unable to retrieve mod list due to a version mismatch.",
        MODS_HIDDEN_LAN = "The mods list isn't visible over LAN.\nWhy not scooch over and ask your friend?",
        OFFLINE_MODE_TITLE = "Offline",
        OFFLINE_MODE_BODY = "You are not logged in and can't play in online games.\nTry playing over LAN or restarting the game to log in.",
        OFFLINE_MODE_TITLE_PS4 = "Online Not Available",
        OFFLINE_MODE_BODY_PS4 = "You are currently in offline mode and cannot join online worlds. Please log in and try again.",
        OFFLINEWARNINGTITLE = "Offline World",
        OFFLINEMODEBODYJOIN = "Are you sure you want to join an offline world? You will not be able to receive or use Collection Items in this world.",
        PAUSEDWARNING_TITLE = "Paused World",
        PAUSEDWARNING_BODY = "Are you sure you want to join a paused world? You will not be able to play until the server is unpaused.",
        NO_CONNECTION_TO_MASTER_SERVER = "Network Error",
        NO_CONNECTION_TO_MASTER_SERVER_DESC = "Failed to connect to the master server.\nPlease check your network connection.",
        CHAR_AGE_1 = "Survived ",
        CHAR_AGE_2 = " Day",
        CHAR_AGE_3 = " Days",
        WORLD_UNKNOWN = "World Unknown",
        VIEWWORLD = "View World",
        PLAYERS_UNKNOWN = "Players Unknown",
        VIEWPLAYERS = "View Players",
        GROUP_UNKNOWN = "Group Unknown",
        GROUP_LOADING = "Group Loading...",
        GROUP_NONE = "No group",
        VIEWGROUP = "View Group Profile",
        SERVERACTIONS = "Server Actions...",
        SEASONS =
        {
            SUMMER = "Summer",
            WINTER = "Winter",
            SPRING = "Spring",
            AUTUMN = "Autumn",
        },
        SEASONFILTER = "Season:",
        EARLY_SEASON_1 = "Early ",
        EARLY_SEASON_2 = "",
        LATE_SEASON_1 = "Late ",
        LATE_SEASON_2 = "",
        UNKNOWN_SEASON = "Season Unknown",
        UNKNOWN = "Unknown",
        PHASES =
        {
            DAY = "Daytime",
            DUSK = "Dusk",
            NIGHT = "Night",
        },
        UNKNOWN_PHASE = "???",
        DAYDESC = "Day ",--", Day ",
        SHOWING_FMT = "({viewed} of {total} shown)",
        OUT_OF = "of", --legacy for mods
        SHOWING = "shown", --legacy for mods
        CHANGE_TABS = "Change Tab",
        DESC_LOADING = "[Description Loading...]",
        NO_DESC = "[No Description]",
		OFFLINE_DESC = "This is an offline world.\nMany details remain a mystery, but it looks like people are having fun.",
        NO_CONNECTION = "Not Connected",
        SEARCHING_SERVERS = "Searching Servers...",
        PLAYERS_LOADING = "Players Loading...",
        WORLD_LOADING = "World Loading...",
        MODS_LOADING = "Mods Loading...",
        TAGS_LOADING = "Tags Loading...",
        SHOW_MOD_WARNING = "Do not show this again",
        CONTINUE = "Continue",
        CHANGE_SORT = "Change Sort",
        LAN = "LAN",
        INTENTION_FILTER = "Playstyle:",
        INTENTION_TITLE = "What's your playstyle?",
        INTENTION_BUTTON = "Choose Playstyle",
        INTENTION_DESC =
        {
            SOCIAL = "You want to hang out, make friends, and play for fun. You don't care so much if you win or lose, as long as everyone's having a good time!",
            COOPERATIVE = "Teamwork is your guiding principal. It's not enough to just not starve, you have to not starve... Together!",
            COMPETITIVE = "You'll show your opponents exactly what you're made of by playing smarter, harder, faster and coming out on top!",
            MADNESS = "Who knows what'll happen next? Mass fighting, crazy dance parties, pits filled with carnivorous spiders... it's pure madness!",
            ANY = "You're, like, laidback and flexible, man. Any world is good with you.",
        },
        PLAYSTYLE_FILTER = "Playstyle:",
        PLAYSTYLE_TITLE = "What's your playstyle?",
        PLAYSTYLE_BUTTON = "Choose Playstyle",
		PLAYSTYLE_ANY_DESC = "You're, like, laidback and flexible, man. Any world is good with you.",
        PLAYSTYLE_TITLE = "Playstyle Selection",

        WORLDPROGRESSION_TITLE = "World Progression Filters",
        WORLDPROGRESSION_BUTTON_LABEL = "World Progression:",
        WORLDPROGRESSION_BUTTON_CHOOSING = "Choosing...",
        WORLDPROGRESSION_BUTTON_CUSTOM = "Custom",
        WORLDPROGRESSION_BUTTON_ANY = "Any",
        WORLDPROGRESSION_TAGS = { -- NOTES(JBK): These must match up with WORLDSTATETAGS.DeclareTag(tagname) use and namespace!
            WS = { -- Namespace without the colon.
                MUST = { -- Key word is "is" or "are" or other very short affirmatives.
                    -- Forest.
                    CELESTIAL_ORB_FOUND = "The Celestial Orb is found.",
                    CELESTIAL_PORTAL_BUILT = "The Celestial Portal is constructed.",
                    CRABBY_HERMIT_HAPPY = "The Crabby Hermit gave a shiny gift.",
                    LUNAR_RIFTS_ACTIVE = "Lunar Rifts are forming in the Constant.",
                    -- Caves.
                    ATRIUM_KEY_FOUND = "The Atrium Key is found.",
                    --  FIXME(JBK): It would be nice for a CELESTIALPORTAL thing here for caves.
                    ARCHIVES_ENERGIZED = "The Ancient Archives are energized.",
                    SHADOW_RIFTS_ACTIVE = "Shadow Rifts are forming in the Constant.",
                },
                CANT = { -- Key word is "has yet" or "is still" or other two word negatives.
                    -- Forest.
                    CELESTIAL_ORB_FOUND = "The Celestial Orb has yet to be obtained.",
                    CELESTIAL_PORTAL_BUILT = "The Celestial Portal is still a Florid Postern.",
                    CRABBY_HERMIT_HAPPY = "The Crabby Hermit has yet to give her shiny gift.",
                    LUNAR_RIFTS_ACTIVE = "Lunar Rifts are no where to be found.",
                    -- Caves.
                    ATRIUM_KEY_FOUND = "The Atrium Key has yet to be obtained.",
                    --  FIXME(JBK): It would be nice for a CELESTIALPORTAL thing here for caves.
                    ARCHIVES_ENERGIZED = "The Ancient Archives are powered down.",
                    SHADOW_RIFTS_ACTIVE = "Shadow Rifts are no where to be found.",
                },
                ANY = { -- Key word is "may have" or "may be" or other two word ambiguities.
                    -- Forest.
                    CELESTIAL_ORB_FOUND = "The Celestial Orb may have been found.",
                    CELESTIAL_PORTAL_BUILT = "The Celestial Portal may have been constructed.",
                    CRABBY_HERMIT_HAPPY = "The Crabby Hermit may have given a shiny gift.",
                    LUNAR_RIFTS_ACTIVE = "Lunar Rifts may be forming in the Constant.",
                    -- Caves.
                    ATRIUM_KEY_FOUND = "The Atrium Key may have been found.",
                    --  FIXME(JBK): It would be nice for a CELESTIALPORTAL thing here for caves.
                    ARCHIVES_ENERGIZED = "The Ancient Archives may be energized.",
                    SHADOW_RIFTS_ACTIVE = "Shadow Rifts may be forming in the Constant.",
                },
            },
        },
        MISSINGDATATITLE = "Out-of-Date Server",
        MISSINGDATABODY = "This server is not up to date. We cannot display its world settings.",
        SERVER_LANGUAGE_WARNING_TITLE = "Server Language Mismatch",
        SERVER_LANGUAGE_WARNING_BODY = "Your language option doesn't match the language set by this server, do want to join anyways?",
		HIDDEN_NAME = "This server name has been filtered",
        HIDDEN_NAME_LISTING = "This server name has been filtered",
		HIDDEN_DESCRIPTION = "*****",
    },

	DEMOOVERDIALOG =
	{
		TITLE_FREEWEEKEND = "Thank you for playing the free demo!",
		BODY_FREEWEEKEND = "Buy now to get the special price!",
		QUIT = "Quit",
	},

    SERVERCREATIONSCREEN =
    {
        FORESTONLY = "Forest Only",
        FORESTANDCAVES = "Forest And Caves",
        CREATE = "Generate World",
        RESUME = "Resume World",
        BACK  = "Back",
        CANCEL = "Cancel",
        ADMIN = "Manage Server",
        MANAGE_ACCOUNT = "Account",
        MANAGE_SLOT = "Manage World",
        DELETE_SLOT = "Delete World",
        WORLD = "World",
        FORESTWORLD = "Forest World",
        CAVEWORLD = "Cave World",
        VIEWWORLD = "View World",
        SERVERNAME = "Name:",
        SERVERPASSWORD = "Password:",
        SERVERDESC = "Description:",
        PRIVACY_LABEL = "Privacy:",
        PRIVACY =
        {
            PUBLIC = "Public",
            FRIENDS = "Friends Only",
            LOCAL = "Local Only",
            CLAN = "Steam Group",
        },
        INTENTION_LABEL = "Server Playstyle:",
        INTENTION_TITLE = "What's your server's playstyle?",
        INTENTION_BUTTON = "Set Intention",
        INTENTION_DESC =
        {
            SOCIAL = "This server is a place for friendly chatter, a relaxed playstyle, and getting to know people. Everyone's welcome here!",
            COOPERATIVE = "Surviving's more fun when you do it as a team. On this server we want to work together and do our best to tame the hostile world.",
            COMPETITIVE = "This server is the perfect arena for a fair fight. Everyone needs a place to prove who's the best at surviving, fighting, building, or... whatever.",
            MADNESS = "Anything goes on this server! Forests will be burned, food will be nommed, and backs will be unceremoniously stabbed. Be prepared!",
        },

		PLAYSTYLE_TITLE = "Pick your server's playstyle.",

        NEWHOST_TITLE = "Creating your first world?",
        NEWHOST_TYPE =
        {
            ALONE = "Alone",
            TOGETHER = "Together",
        },
        NEWHOST_DESC =
        {
            ALONE = "Play alone in a private world where you can collect your bearings and get the hang of not starving. This is recommended for your first time playing.",
            TOGETHER = "Start an online world where other players can join in your adventures. It's up to you whether your world is open to everyone, or just your friends.",
        },
        CLANID = "Group ID:",
        CLANONLY = "Members Only:",
        CLAN_OPEN = "Open",
        CLAN_CLOSED = "Members Only",
        CLANADMIN = "Auto Group Admins:",
        ONLINE_MODE = "Server Mode:",
        ON = "On",
        OFF = "Off",
        NO = "No",
        YES = "Yes",
        PVP = "PvP:",
        EVENT = "Event:",
        GAMEMODE = "Game Mode:",
        MAXPLAYERS = "Players:",
        ONLINEONYTITLE = "Online World",
        ONLINEONLYBODY = "You can only resume an online world when you have a connection to Steam and Klei. Please log in and try again.",
        ONLINEONLYBODY_RAIL = "You can only resume an online world when you have a connection to the game servers. Please log in and try again.",
        ONLINEONLYBODY_PS4 = "You are currently in offline mode and cannot resume an online world. Please log in and try again.",
        ONLINEONLYBODY_SPLITSCREEN = "You are currently in offline mode and cannot resume an online world. Please log in and try again.",
        OFFLINEMODETITLE = "Offline Mode",
        OFFLINEMODEBODYCREATE = "Are you sure you want to create an offline world? This is a limited mode where only players on your Local Area Network can join. Players will not be able to receive or use Collection Items in this world.",
        OFFLINEMODEBODYRESUME = "You are resuming an offline world. Only users on your Local Area Network will be able to join this world. Players will not be able to receive or use Collection Items in this world.",
        OFFLINEMODEBODYCREATE_CANSKIN = "Are you sure you want to create an offline world? This is a limited mode where only players on your Local Area Network can join.",
        OFFLINEMODEBODYRESUME_CANSKIN = "You are resuming an offline world. Only users on your Local Area Network will be able to join this world.",
        FULLSLOTSTITLE = "No Slots Available",
        FULLSLOTSBODY = "All of your server slots are currently full. You must either select a slot to load from, or delete a slot and start a new world.",
        OK = "OK",
        SAVECHANGES = "Save Changes",
        DISCARDCHANGES = "Discard Changes",
        NONAMEGAME = "[No Name]",
        NEWGAME = "New World",
        NEWGAME_SUFFIX = "'s World", --legacy for mods
        NEWGAME_FMT = "{name}'s World",
        NEWGAME_GENERIC = "My World",
        CREATENEWGAME = "Create New World",
        DELETE = "Delete",
        CLONE = "Duplicate World",
        NAME_DUPLICATE_SLOT = "Duplicate World Name:",
        COPY_OF_SLOT_NAME = "Copy of {worldname}",
        CONVERTCLOUDTOLOCAL = "Convert To Local Save",
        CONVERTLOCALTOCLOUD = "Convert To Cloud Save",
        FAILED_COPYORCONVERT_TITLE = "Error",
        FAILED_COPY_DIALOG = "Failed to duplicate world, please try again later.",
        FAILED_CONVERT_DIALOG_FMT = "Failed to convert world to {type} save, please try again later.",
        CONVERT_LOCAL = "local",
        CONVERT_CLOUD = "cloud",
        SAVE_TYPE = "Save Type:",
        SAVE_TYPE_LOCAL = "Local Save",
        SAVE_TYPE_CLOUD = "Steam Cloud Save", --steam is our only cloud save platform for now, so this is fine.
        SLOT = "Server Slot",
        SURE = "Are you sure?",
        SERVERDAY = "Day", --deprecated, left here for mods to use
        SERVERDAY_V2 = "Day {day_count}",
        SERVERDAY_SEASON_V2 = "{season} Day {day_count}",
        SERVERDAY_NEW = "A Whole New World",
        SELECT_SLOT = "Select Slot",
        SNAPSHOTS = "Rollback",
        VIEWBANS = "View Bans",
        BANS = "Bans",
        TOOLTIP_BANS = "See which players you've blocked from joining your servers",
        HOST_GAME = "Host Game",
        SERVERSETTINGS_LONG = "Server Settings",
        SERVERSETTINGS = "Settings",
        WORLD_LONG_FMT = "World: {location}",
        MODSDISABLEDWARNINGTITLE = "WARNING - Mods Disabled",
        MODSDISABLEDWARNINGBODY = "Some mods used on this save are disabled, which could cause issues. Continue?",
        MODSOUTOFDATEWARNINGTITLE = "WARNING - Mods Out of Date",
        MODSOUTOFDATEWARNINGBODY = "Some enabled mods are out of date, which could cause issues. Continue?",
        CONTINUE = "Continue",
        CANCEL_TITLE = "Save Changes?",
        CANCEL_BODY = "Do you want to save your changes?",
        INVALIDSERVERNAME_TITLE = "Missing Server Name",
        INVALIDSERVERNAME_BODY = "No one will be able to find you if you don't have a name!",
        INVALIDPASSWORD_TITLE = "Bad Password",
        INVALIDPASSWORD_BODY = "Password cannot have spaces at the beginning or at the end!",
        INVALIDCLANSETTINGS_TITLE = "Bad Group ID",
        INVALIDCLANSETTINGS_BODY = "You have to specify the Steam Group you belong to! Please verify the group number.",
        INVALIDINTENTIONSETTINGS_TITLE = "Missing Server Intention",
        INVALIDINTENTIONSETTINGS_BODY = "You forgot to choose a playstyle for your server!",
        INVALIDNEWHOST_TITLE = "Creating your first world?",
        INVALIDNEWHOST_BODY = "We recommend trying the game alone in a private world while you learn the ropes and get the hang of not starving. But it's totally up to you!",
        UGC_BLOCKED_DESCRIPTION_PREFIX = "Use of user-generated media is not allowed for your account.\nOnline players will see your server name as \"",
        UGC_BLOCKED_DESCRIPTION_POSTFIX = "'s World\" with a blank description.",
        UGC_BLOCKED_DESCRIPTION_PREFIX_SPLITSCREEN = "Use of user-generated media is not allowed for the signed in accounts.\nOnline players will see your server name as \"",
        OFFLINE_WORLD = "Offline",
        MANAGE_TEXT = "Local world files are available at:\nSAVEDATA:/{folder}/",
        OPENSAVEFOLDER = "Open World Folder",
        CLUSTERSLOT = "Save Folder",
        SORT_MODE_FMT = "Sort Mode: {mode}",
        SORT_LASTPLAYED = "Last Played",
        SORT_MOSTDAYS = "Days Played",
        SORT_DATECREATED = "Date Created",
        SEARCH = "Search",
        SAVEFROMNEWERVERSION = "Not playable - saved data from newer game version",
		NO_MATCHING_SERVERS = "No saved games match your search.",
        USECAVES_TITLE = "{server} or no {server}?",
        USECAVES_DESC_CAVE = "Play with {server}, requires more PC Power as it runs multiple servers",
        USECAVES_DESC_NOCAVE = "Play with no {server}, sad, but not as demanding on a computer",
        USECAVES_NAME_CAVE = "{server}",
        USECAVES_NAME_NOCAVE = "No {server}",
        REMEMBERCOICE = "Remember my choice.",
		WORLDGEN_FAILED_TITLE = "World Generation Failed",
		WORLDGEN_FAILED_BODY = "Could not generate a world using these settings.\nDo you want to try again?",
    },

    CLOUDSERVERCREATIONSCREEN =
    {
        TITLE = "Custom Match",
        CREATE = "Create Match",
    },

    GAMEMODES =
    {
        SURVIVAL = "Default",
        SURVIVAL_DESCRIPTION = "We survive together, we die together!\n\n* Survive through the seasons and protect yourself from the world.\n* Uncover ancient secrets hidden within the shadows.\n* Grow crops, catch fish, hunt for meat. Whatever you do, don't starve.",
--        SURVIVAL = "Survival",
--        SURVIVAL_DESCRIPTION = "We survive together, we die together!\n\n* Enter the world through the Florid Postern.\n* Become a ghost when you die.\n* Ghost players cause a sanity drain for living players.",
        WILDERNESS = "Wilderness",
        WILDERNESS_DESCRIPTION = "It's wild and dangerous out there!\n\n* Enter at a random location in the world.\n* No safety net. If you die: try, try again.\n* Those you encounter may or may not be friendly.",
        ENDLESS = "Endless",
        ENDLESS_DESCRIPTION = "A neverending Don't Starve sandbox.\n\n* Enter the world through the Florid Postern.\n* Become a ghost when you die (no sanity drain).\n* Resurrection is always available via the Florid Postern.",
        LAVAARENA = "The Forge",
        LAVAARENA_DESCRIPTION = "Prove yourself to Battlemaster Pugna in this Gate Realm.\n* Enter the world through the Molten Gateway.\n* No hunger or sanity.\n* Use what you can find. No outside weapons in the Pit!",
        QUAGMIRE = "The Gorge",
        QUAGMIRE_DESCRIPTION = "Cook delicious dishes to appease the Eternal Gnaw in this Gate Realm.\n* Enter the world through the Mossy Gateway.\n* No nighttime.\n* Use what you can find to cook offerings for the altar!",
        CUSTOM = "Custom Game",
        UNKNOWN = "Game Mode Unknown",
        UNKNOWN_DESCRIPTION = "We could not retrieve the details of this game mode.",
    },

    SERVERADMINSCREEN =
    {
        BANNED_PLAYERS_HEADER = "Banned Players",
        PLAYER = "Player",
        DATE = "Date",
        DAY = "Day", --deprecated, left here for mods to use
        DAY_V2 = "Day {day_count}",
        DAY_UNKNOWN = "Unknown Day",
        UNKNOWN_DAY = "???", --deprecated, left here for mods to use
        UNKNOWN_DAY_PS4 = "Creation of the World",
        EMPTY_SLOT = "EMPTY",
        EMPTY_SLOT_TITLE = "Empty Slot",
        CLEAR_PLAYERS = "Unban All",
        UNDO_PLAYERS = "Undo All",
        PLAYER_DETAILS = "View Details",
        --PLAYER_PROFILE = "View Profile",
        PLAYER_DELETE = "Unban",
        APPLY = "Apply",
        CANCEL = "Cancel",
        BACK = "Back",
        YES = "Yes",
        NO = "No",
        UNKNOWN = "Unknown",
        BANNED = "Banned on ",
        UNKNOWN_DATE = "????-??-??",
        SERVER_NAME = "Server Name:",
        SERVER_DESCRIPTION = "Server Description:",
        NO_PLAYER_SELECTED = "No Player Selected",
        LOSE_CHANGES_TITLE = "Lose Changes?",
        LOSE_CHANGES_BODY = "Do you want abandon your changes?",
        DELETE_ENTRY_TITLE = "Unban Player?",
        DELETE_ENTRY_BODY = "Do you want to delete \"",
        DELETE_ENTRY_BODY_2 = "\" from your ban list?\nThis will affect all servers you create.",
        CLEAR_LIST_TITLE = "Unban all?",
        CLEAR_LIST_BODY = "Do you want to delete all banned players?\nThis will affect all servers you create.",
        RESTORE_SNAPSHOT_HEADER = "Restore %s", --deprecated, left here for mods to use
        HEADER_DAY = "Restore Day {day_count}",
        HEADER_DAY_UNKNOWN = "Restore Unknown Day",
        RESTORE_SNAPSHOT_BODY = "Do you want to restore this save? You will lose all changes made to the world past the selected day, as well as all subsequent saves. This cannot be undone.",
        UNKNOWN_USER_NAME = "[unknown]", -- this is consistent with what steam when it can't get a player name
        SNAPSHOTS_TITLE = "Snapshots: ",
        RESTORE_SNAPSHOT = "Restore Snapshot",
        SYSTEMMESSAGE = "Server",
    },

    LOBBYSCREEN =
    {
        SELECT = "Select",
        START = "Go!",
		NEXT = "Next",
        APPLY = "Apply",
        CANCEL = "Cancel",
        BACK = "Back",

        DISCONNECT = "Disconnect",
        CLIENTQUITTITLE = "Leave Server",
        CLIENTQUITBODY = "Are you sure you want to leave this server?",
        HOSTQUITTITLE = "Shut Down Server",
        HOSTQUITBODY = "Are you sure you want to shut down this server? If you do, all players will be disconnected.",
        YES = "Do it!",
        NO = "Maybe not...",
        INVITE = "Invite",
        PLAYERLIST = "Players",
        NUM_PLAYERS_FMT = "{num}/{max}",
        CHAT = "Chat",
        RANDOMCHAR = "Random",
        PLAYER = "Player",
        SKINS = "Skins",
        SKINS_BASE = "HEAD",
        SKINS_BODY = "BODY",
        SKINS_LEGS = "LEGS",
        SKINS_HANDS = "HANDS",
        SKINS_FEET = "FEET",
        SKINS_RANDOM = "Random Item",
        SKINS_PREVIOUS = "Previously Worn Item",
        RANDOMCHAR_BUTTONHINT = "Random Survivor",
        INVITE_FRIEND = "Invite Friend",
        CUSTOMIZE = "Customize Your Character",
        CUSTOMIZE_SCARECROW = "Customize Your Scarecrow",
        COMING = "Coming Soon!",
        OFFLINE = "Not Available Offline",
        LOADOUT_TITLE = "{name}'s Loadout",
        SELECTION_TITLE = "Survivor Select",
        WAITING_FOR_PLAYERS_TITLE = "Waiting For Other Players",
        EMPTY_SLOT = "Available Slot",
        READY = "Ready!",
        TOGGLE_PORTRAIT = "Toggle Portrait",

        UNOWNED_CHARACTER_TITLE = "Character Not Owned",
        UNOWNED_CHARACTER_BODY = "You have not yet unlocked {character}.\nTo play this character, you must either weave them using Spools, or purchase them from the Shop.",
        UNOWNED_CHARACTER_BODY_OFFLINE = "You have not yet unlocked {character}.\nYou must be online to unlock this character.",
        VISIT_SHOP = "Visit Shop",

        SERVER_SHUTDOWN_TITLE = "Server is Shutting Down",
        SERVER_SHUTDOWN_BODY = "This server is about to shut down.",
    },

    SKIN_PRESETS =
    {
        TITLE = "Clothing Presets",
    },

    ITEM_SKIN_DEFAULTS =
    {
        TITLE = "Curios for Starting Items",
    },


    LOBBY_WAITING_FOR_PLAYERS_SCREEN =
    {
        SPAWN_DELAY = "Match starts in {time}",
		LOCAL_PLAYER_READY_TO_START = "Ready to start",
		LOCAL_PLAYER_VOTE_TO_START = "Vote to start with {num}/{max} players",
        LOCAL_PLAYER_READY_CANCEL_HELPTEXT = "Wait, I'm not ready!",
        PLAYER_VOTED_TO_FORCE_START = "Voted To Start",
		PLAYER_READY_TO_START = "Ready",

        VOTE_POPUP_TITLE = "Voting to Start",
        VOTE_POPUP_BODY = "You are voting to start the match without a full server.\nThe difficulty does not scale based on the number of players.\nThis will be a more challenging experience.",
        VOTE_POPUP_CONTINUE = "Vote",
        VOTE_POPUP_CANCEL = "Cancel",
    },

    SKINSSCREEN =
    {
        TITLE = "{name}'s Collection",
        ALL = "All",
        CLOTHING = "Clothing",
        ITEMS = "Items",
        FILTERS = "Filters",
        NONE = "NONE",
        BASE = "BASE",
        BODY = "BODY",
        HAND = "HANDS",
        LEGS = "LEGS",
        FEET = "FEET",
        ITEM = "Craftables",
        SAVE = "Save Outfit",
        RESET = "Last Outfit",
        CLEAR = "Reset to Default",
        LOADOUT = "Loadout",
        SELECT = "Select",
        PICK = "Pick A Character",
        SORRY = "Sorry",
        OFFLINE = "Your curio cabinet is not available in offline mode.",
        NEW = "NEW",
        TRADE = "Trade Inn",
        BACK = "Back",
        TRADE_TOOLTIP = "Trade your old items in for something new!",
        NO_ITEMS_TITLE = "Nothing to see here",
        NO_ITEMS = "Start playing to earn items!",
        BONUS = "Reward",
        SET_PROGRESS = "Piece",
        SET_INFO = "Ensemble Info",
        USABLE_ON = "Reskins {item}",
        USABLE_ON_MULTIPLE = "Reskins {item1} and {item2}",
        USABLE_ON_MULTIPLE_3 = "Reskins {item1}, {item2} and {item3}",
        USABLE_INFO = "Reskin Info",
        USABLE_INFO_TITLE = "Reskins",
        USABLE_ON_POPUP = "{skin} will change the appearance of {item}.",
        USABLE_ON_MULTIPLE_POPUP = "{skin} will change the appearance of {item1} and {item2}.",
        USABLE_ON_MULTIPLE_3_POPUP = "{skin} will change the appearance of {item1}, {item2} and {item3}.",
        OK = "OK",
		NOW_OFFLINE_TITLE = "Network Connection Lost",
		NOW_OFFLINE_BODY = "You are now in offline mode.\nYour item collection is not available in offline mode.\nPlease check your connection and log in again.",
        NOW_OFFLINE_BODY_CANSKIN = "You are now in offline mode.\nPlease check your connection and log in again.",
    },

    FESTIVALEVENTSCREEN =
    {
        TITLE =
        {
            LAVAARENA2 = "The Forge - Season 2",
            LAVAARENA = "The Forge",
            QUAGMIRE = "The Gorge",
        },

        QUICKMATCH = "Quick Match",
        HOST = "Custom Match",
        BROWSE = "Browse Servers",

        TOOLTIP_QUICKMATCH = "Hop in to the first available match",
        TOOLTIP_HOST = "Start your own event server",
        TOOLTIP_BROWSE = "Browse all event servers",

        -- Phases of Create Server
        HOST_GETTINGREGIONS = "Getting regions",
        HOST_DETERMININGREGION = "Determining region",
        HOST_REQUESTINGSERVER = "Requesting server",
        HOST_WAITINGFORWORLD = "Waiting for world",
        HOST_CONNECTINGTOSERVER = "Connecting to server",
        HOST_FAILED = "Network Error",
        HOST_FAILED_BODY = "Failed to connect to event server.",
        HOST_NO_SERVERS_BODY = "No servers are currently available for your game version. Please update and try again.",
        HOST_PINGS_FAILED_BODY = "Unable to contact Klei servers.\nPlease check your network connection and try again.",

        OFFLINE_POPUP_TITLE = "Offline",
        OFFLINE_POPUP_BODY =
        {
            lavaarena = "You must be logged in to challenge\nBattlemaster Pugna's warriors.",
            quagmire = "You must be logged in to prepare\nofferings for the Altar of Gnaw.",
        },

        OFFLINE_POPUP_BACK = "Back",
        OFFLINE_POPUP_LOGIN = "Log In",

		OFFLINE_POPUP_TITLE_CONSOLE = "You are in offline mode",
		OFFLINE_POPUP_BODY_CONSOLE =
        {
            lavaarena = "All players must be online to challenge\nBattlemaster Pugna's warriors.",
            quagmire = "All players must be online to prepare\nofferings for the Altar of Gnaw.",
        },

        MODS_POPUP_TITLE = "Mods Detected!",
        MODS_POPUP_BODY = "Warning!\nClient mods are unsupported in {event}.\nDisabling all mods is recommended.",
        MODS_POPUP_CONTINUE = "Continue",
        MODS_POPUP_DISABLE_MODS = "Disable All Mods",
        MODS_POPUP_CANCEL = "Cancel",

		TOGGLE_PLAYER = "Toggle player",
    },

	PORTRAIT =
    {
		HP = "HP",
		DIFFICULTY = "Difficulty",
		ITEMS = "Items",
    },

    WXPLOBBYPANEL =
    {
		LAVAARENA =
		{
			TITLE_VICTORY = "Victory!",
			TITLE_DEFEAT = "Defeat",
		},
		QUAGMIRE =
		{
			TITLE_VICTORY = "Gateway Activated!",
			TITLE_DEFEAT = "Mermified",
		},

        MATCH_TIME = "Match Time: {time}",
        DEATHS = "Total Deaths: {deaths}",
        NO_DEATHS = "No Deaths",
        SCORE = "Appeasement Points: {score}",
		TRIBUTES = "Gnaw's Cravings: {success} fulfilled and {failed} failed",

		LEADERBOARD_ERROR = "Unable to connect to leaderboard server.",

		STEAM =
		{
			TOURNAMENTS_NO_ACCOUNT_SHARING = "Family Sharing accounts are not eligible for tournaments",
		},

        SKIP = "Skip",
        CONTINUE = "Continue",
        NEWBOX_TITLE =
        {
            lavaarena = "Forge Chest Earned!",
            quagmire = "Victorian Chest Earned!", --"Gnaw's Chest Earned!"
        },
        NEWBOXES_TITLE =
        {
            lavaarena = "{num} Forge Chests Earned!",
            quagmire = "{num} Victorian Chests Earned!", --"{num} Gnaw's Chests Earned!"
        },
        NEWBOX_BODY = "Visit the Treasury to open your chest",
        NEWBOXES_BODY = "Visit the Treasury to open your chests",

        WXP_CURRENT_XP = "CURRENT XP",
        WXP_NEXT_LEVEL_XP = "NEXT LEVEL AT",
        WXP = "XP",
        DETAILS_XP = "+{num}",
        LEVEL_UP = "LEVEL UP!",
        ACHIEVEMENT_UNLOCKED = "Achievement: {name}",
		FOOD_DISCOVERY = "Recipe: {name}",
		ADD_XP_VAL = "{name}, {val} XP",
    },

	WXP_DETAILS =
	{
		-- common
		DURATION = "Time",
		FRIENDS_BONUS = "Playing with Friends",
		DAILY_FIRST_MATCH = "Daily Match Bonus",
		WEEKLY_FIRST_MATCH = "Weekly Match Bonus",
		CONSECUTIVE = "Consecutive Match Bonus",
		WIN = "Victory",
		DAILY_FIRST_WIN = "Daily Victory Bonus",
		LAVA_ARENA_XP_MOD = "debug test",

		-- lavaarena
		LAVA_ARENA_MILESTONE_1 = "Pit Pigs Defeated",
		LAVA_ARENA_MILESTONE_2 = "Crocommanders Defeated",
		LAVA_ARENA_MILESTONE_3 = "Snortoises Defeated",
		LAVA_ARENA_MILESTONE_4 = "Formidable Team",
		LAVA_NO_PLAYER_DEATHS = "No Deaths",
		LAVA_NO_TEAM_DEATHS = "No Deaths (Team)",
		LAVA_UNIQUE_CHARACTERS = "No Doubles Bonus",
		UNIQUE_CHARACTERS = "No Doubles Bonus",

		-- lavaarena2
		LAB_WIN = "Victory",
		LAB_DURATION = "Time",
		LAB_FRIENDS_BONUS = "Playing with Friends",
		LAB_CONSECUTIVE = "Consecutive Match Bonus",
		LAB_UNIQUE_CHARACTERS = "No Doubles Bonus",
		LAB_NO_DEATHS_PLAYER = "No Deaths",
		LAB_NO_DEATHS_TEAM = "No Deaths (Team)",
		LAB_MILESTONE_1 = "Pit Pigs Defeated",
		LAB_MILESTONE_2 = "Crocommanders Defeated",
		LAB_MILESTONE_3 = "Snortoises Defeated",
		LAB_MILESTONE_4 = "Formidable Team",
		LAB_MILESTONE_5 = "Grand Forge Boarrior Defeated",
		LAB_MILESTONE_6 = "Rhinocebros Defeated",

		-- quagmire --
		QUAGMIRE_MILESTONE_1 = "Sapphire Medallion Earned",
		QUAGMIRE_MILESTONE_2 = "Red Mark Earned",
		QUAGMIRE_MILESTONE_3 = "Gnaw's Favor Earned",
        QUAGMIRE_NO_TRIBUTES_FAILED = "No Failed Offerings",
        QUAGMIRE_UNIQUE_CHARACTERS = "No Duplicate Survivors",
        QUAGMIRE_NO_DUPLICATE_TRIUBUTES = "No Repeat Meals",
        QUAGMIRE_TRIBUTE_SCORE = "Appeasement Point Bonus",
        QUAGMIRE_CHALLENGE = "Tournament Entry",
	},

	XPUTILS =
	{
		XPPROGRESS = "{num}/{max}",
	},

    MVP_LOADING_WIDGET =
    {
		LAVAARENA =
		{
			TITLES =
			{
				deaths = "Reborn",
				total_damagedealt = "Brawler",
				total_damagedealt2 = "Merciless",
				kills = "Assassin",
				kills2 = "Master Assassin",
				aggroheld = "Distraction",
				aggroheld2 = "Expert Decoy",
				corpsesrevived = "Resurrector",
				healingdone = "Healer",
				healingdone2 = "Doctor",
				total_damagetaken = "Protector",
				total_damagetaken2 = "Loyal Guardian",
				attacks = "Combatant",
				turtillusflips = "Turtle Flipper",
				spellscast = "Archmage",
				altattacks = "Powerful",
				stepcounter = "Fast-Paced",
				blowdarts = "Sharpshooter",
				blowdarts2 = "Ace Marksman",
				standards = "Vandal",
				numcc = "Immobilizer",
				guardsbroken = "Breacher",
				none = "Participator!",
			},
			DESCRIPTIONS =
			{
				deaths = "deaths",
				total_damagedealt = "damage dealt",
				total_damagedealt2 = "damage dealt",
				kills = "killing blows",
				kills2 = "killing blows struck",
				aggroheld = "seconds with creatures' attention",
				aggroheld2 = "seconds with creatures' attention",
				corpsesrevived = "allies revived",
				healingdone = "health restored",
				healingdone2 = "health restored",
				total_damagetaken = "damage taken",
				total_damagetaken2 = "damage taken for the team",
				attacks = "swings landed",
				turtillusflips = "Snortoises flipped",
				spellscast = "spells cast",
				altattacks = "special attacks used",
				stepcounter = "steps taken",
				blowdarts = "darts hit their mark",
				blowdarts2 = "darts hit their mark",
				standards = "battle standards destroyed",
				numcc = "enemies immobilized",
				guardsbroken = "enemy guards broken",
				none = "thanks for playing",
			},
			NO_STAT_VALUE = "-",
		},
		QUAGMIRE =
		{
			TITLES =
			{
				crops_farmed = "Farmhand",
				crops_farmed2 = "Greenthumb",
				crops_planted = "Sower",
				crops_picked = "Harvester",
				crops_rotten = "Composter",
				herbs_picked = "Forager",
				herbs_picked2 = "Master Gatherer",
				buys = "Barterer",
				meals_made = "Sous Chef",
				meals_made2 = "Master Chef",
				meals_burnt = "Overcooker",
				meals_burnt2 = "Kitchen Disaster",
				meals_saved = "Meal Saver",
				meals_saved2 = "Kitchen Rescuer",
				logs = "Lumberjack",
				logs2 = "Clearcutter",
				tributes = "Gnaw Worshipper",

				-- same as forge
				none = "Participator!",
				stepcounter = "Fast-Paced",
			},
			DESCRIPTIONS =
			{
				crops_farmed = "fresh crops farmed",
				crops_farmed2 = "fresh crops farmed",
				crops_planted = "fresh crops planted",
				crops_picked = "fresh crops picked",
				crops_rotten = "crops left to rot",
				herbs_picked = "wild plants picked",
				herbs_picked2 = "wild plants picked",
				buys = "goods bought from traders",
				meals_made = "meals cooked",
				meals_made2 = "meals cooked",
				meals_burnt = "meals burnt to cinders",
				meals_burnt2 = "meals burnt to cinders",
				meals_saved = "meals saved from the fire",
				meals_saved2 = "meals saved from the fire",
				logs = "logs harvested",
				logs2 = "logs harvested",
				tributes = "dishes sacrificed to the Altar",

				-- same as forge
				none = "thanks for playing",
				stepcounter = "steps taken",
			},
			NO_STAT_VALUE = "-",
		},
    },

	ACHIEVEMENTS =
	{
        SCREENTITLE = "Accomplishments",
        INGAME_NOTICE = "Accomplishments are awarded at the end of a match.",
		LAVAARENA =
		{
			CATEGORIES =
			{
				encore = "Forge Mastery",
				wintime = "Speed Runs",
				nodeaths = "Perfect Runs",
				wilson = "Wilson",
				willow = "Willow",
				wendy = "Wendy",
				wolfgang = "Wolfgang",
				woodie = "Woodie",
				wickerbottom = "Wickerbottom",
				wx78 = "WX-78",
				wes = "Wes",
				waxwell = "Maxwell",
				wathgrithr = "Wigfrid",
				webber = "Webber",
				winona = "Winona",
			},
			ACHIEVEMENT =
			{
				-- The Forge
				encore_boarons =
				{
				   TITLE = "Down But Not Snout",
				   DESC  = "Finish the Pit Pig round having taken less than 800 teamwide damage",
				},
				encore_boarons_hard =
				{
				   TITLE = "Hair Of Their Chinny, Chin, Chin",
				   DESC  = "Finish the Pit Pig round having taken less than 600 teamwide damage",
				},
				encore_turtillus =
				{
				   TITLE = "Big Wheel Kept From Turnin'",
				   DESC  = "Finish the Snortoise round without allowing Snortoises to perform more than 3 spin attacks",
				},
				encore_turtillus_hard =
				{
				   TITLE = "Unspun Hero",
				   DESC  = "Finish the Snortoise round without allowing Snortoises to perform any spin attacks",
				},
				encore_peghook =
				{
				   TITLE = "Basic Solution",
				   DESC  = "Survive the first wave of Scorpeons without any teammates dying from acid",
				},
				encore_nodeath_easy =
				{
				   TITLE = "Not Today",
				   DESC  = "Survive until the first wave of Scorpeons without any teammates dying",
				},
				encore_nodeath_medium =
				{
				   TITLE = "Hard To Kill",
				   DESC  = "Survive until the first Boarilla arrives and defeat it without any teammates dying",
				},
				encore_nodeath_hard =
				{
				   TITLE = "Just Won't Die!",
				   DESC  = "Survive until the Grand Forge Boarrior is summoned without any teammates dying",
				},
				nodeaths_self =
				{
				   TITLE = "Solo Survivor",
				   DESC  = "Win a Forge match without dying",
				},
				nodeaths_team =
				{
				   TITLE = "Team Survivor",
				   DESC  = "Win a Forge match without any teammates dying",
				},
				nodeaths_uniqueteam =
				{
				   TITLE = "Survival of the Mis-Fittest",
				   DESC  = "Play on a team with 6 unique survivors and win without any teammates dying",
				},
				wintime_30 =
				{
				   TITLE = "Bronze Speed Run",
				   DESC  = "Win a Forge match in under 30 minutes",
				},
				wintime_25 =
				{
				   TITLE = "Silver Speed Run",
				   DESC  = "Win a Forge match in under 25 minutes",
				},
				wintime_20 =
				{
				   TITLE = "Gold Speed Run",
				   DESC  = "Win a Forge match in under 20 minutes",
				},
				wilson_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Wilson",
                },
				wilson_reviver =
				{
				   TITLE = "It's Alive!",
				   DESC  = "Revive a fallen friend",
				},
				wilson_battlestandards =
				{
				   TITLE = "Standard Deviations",
				   DESC  = "Destroy 3 or more Battle Standards in a single match",
				},
				willow_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Willow",
                },
				willow_meteor =
				{
				   TITLE = "Heat Stricken",
				   DESC  = "Hit 40 or more targets in a single match using Meteor Strikes",
				},
				willow_moltenbolt =
				{
				   TITLE = "Ring of Fire",
				   DESC  = "Stop a spinning Snortoise with using a Molten Bolt attack",
				},
				wolfgang_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Wolfgang",
                },
				wolfgang_nospinning =
				{
				   TITLE = "High Striker",
				   DESC  = "Stop a spinning Snortoise using an Anvil Strike attack",
				},
				wolfgang_guardsbroken =
				{
				   TITLE = "Caught Off Guard",
				   DESC  = "Interrupt 5 or more enemies while they're in guard stance in a single match",
				},
				wendy_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Wendy",
                },
				wendy_outofharmsway =
				{
				   TITLE = "Float Like A Butterfly",
				   DESC  = "Take under 100 damage and land 150 darts before the Scorpeon wave",
				},
				wendy_guardsbroken =
				{
				   TITLE = "En-guard, Villain",
				   DESC  = "Interrupt 5 or more enemies while they're in guard stance in a single match",
				},
				wx78_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as WX-78",
                },
				wx78_shocks =
				{
				   TITLE = "Circuit Breaker",
				   DESC  = "Stop a spinning Snortoise with a shock",
				},
				wx78_anvil =
				{
				   TITLE = "Well-Oiled Machine",
				   DESC  = "Land Anvil Strikes on 50 or more targets in a single match",
				},
				wickerbottom_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Wickerbottom",
                },
				wickerbottom_meteor =
				{
				   TITLE = "Library Staff",
				   DESC  = "Land a killing blow with an amplified Cataclysm Meteor",
				},
				wickerbottom_healing =
				{
				   TITLE = "Spell It Out",
				   DESC  = "Cast 3 amplified Life Blossoms within 60 seconds",
				},
				woodie_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Woodie",
                },
				woodie_nospinning =
				{
				   TITLE = "The Chopping Block",
				   DESC  = "Stop a spinning Snortoise using Lucy",
				},
				woodie_lucychuck =
				{
				   TITLE = "Would A Werebeaver Chuck",
				   DESC  = "Land 20 Lucy Chucks in a single match",
				},
				wes_victory =
				{
				   TITLE = "Forging Victory",
				   DESC  = "Defeat Battlemaster Pugna's warriors as Wes",
				},
				wes_decoy =
				{
				   TITLE = "Show, Don't Tell",
				   DESC  = "Receive the Expert Decoy card at the end of the match",
				},
				wes_battlestandards =
				{
				   TITLE = "Unspoken Standard",
				   DESC  = "Destroy 3 or more Battle Standards in a single match",
				},
				waxwell_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Maxwell",
                },
				waxwell_minion_kill =
				{
				   TITLE = "From The Shadows",
				   DESC  = "Deal a killing blow using Maxwell's shadow minions",
				},
				waxwell_petrify =
				{
				   TITLE = "Stone Cold",
				   DESC  = "Petrify 25 or more enemies before the Infernal Staff drops",
				},
				wathgrithr_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Wigfrid",
                },
				wathgrithr_flip =
				{
				   TITLE = "Exit, Pursued By Viking",
				   DESC  = "Flip 20 or more Snortoises in a single match",
				},
				wathgrithr_battlecry =
				{
				   TITLE = "Curtain Call",
				   DESC  = "Buff 3 friends simultaneously 5 times in a match using Battle Cry",
				},
				webber_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Webber",
                },
				webber_darts =
				{
				   TITLE = "Webslinger",
				   DESC  = "Use 3 special attacks in under 20 seconds",
				},
				webber_merciless =
				{
				   TITLE = "Prey Tell",
				   DESC  = "Achieve the Merciless card at the end of the match",
				},
				winona_victory =
                {
                   TITLE = "Forging Victory",
                   DESC  = "Defeat Battlemaster Pugna's warriors as Winona",
                },
				winona_altattacks =
				{
				   TITLE = "Maximum Efficiency",
				   DESC  = "Use 40 or more special attacks in a single match",
				},
				winona_allweapons =
				{
					TITLE = "Jill of All Trades",
					DESC  = "Perform a special attack using a melee weapon, a dart, and a staff in a single match",
				},

				-- Reforge
				laq_dailywin =
				{
					TITLE = "Daily Victory Bonus",
					DESC  = "",
				},
				laq_dailymatch =
				{
					TITLE = "Daily Match Bonus",
					DESC  = "",
				},
				laq_battlestandards =
				{
					TITLE = "Triple Standard",
					DESC  = "Destroy 3 or more battle standards in a single match",
				},
				laq_reviver =
				{
					TITLE = "Modern Prometheus",
					DESC  = "Revive a fallen friend",
				},
				laq_specials_veryfast =
				{
					TITLE = "Rapid Try Movement",
					DESC  = "Perform 4 special attacks in under 20 seconds (excludes chucking Riled Lucy)",
				},
				laq_outofharmsway =
				{
					TITLE = "Scorpeons Position",
					DESC  = "Survive until the Scorpeons arrive, taking under 200 damage",
				},
				laq_specials_somany =
				{
					TITLE = "Super Special",
					DESC  = "Use 40 or more special attacks in a single match",
				},
				laq_nodashhounds =
				{
					TITLE = "Dash Their Hopes",
					DESC  = "Avoid being hit by a dashing Pit Pig before the Snortoises arrive",
				},
				laq_nodeath_solo_easy =
				{
					TITLE = "Live To See the Fray",
					DESC  = "Avoid death before the Boarilla arrives",
				},
				laq_rhinodrill1 =
				{
					TITLE = "No the Drill",
					DESC  = "Avoid death by the Rhinocebros",
				},
				laq_spinners_easy =
				{
					TITLE = "Spin Docker",
					DESC  = "Defeat the Snortoise round without allowing Snortoises to perform more than 4 spin attacks",
				},
				laq_boarons =
				{
					TITLE = "Acceptable Casualties",
					DESC  = "Defeat the Pit Pigs round with less then 800 player damage take by the team",
				},
				laq_nopoisondeath =
				{
					TITLE = "Acid Redux",
					DESC  = "Defeat the initial Scorpeon wave without anyone dying from Scorpeon Acid",
				},
				laq_beetle1 =
				{
					TITLE = "name_laq_beetle1",
					DESC  = "desc_laq_beetle1",
				},
				laq_nodeath_r2 =
				{
					TITLE = "Rigor Snortoise",
					DESC  = "Survive with no team deaths before the Snortoises arrive",
				},
				laq_nodeath_r3 =
				{
					TITLE = "Scorpeon Denizens",
					DESC  = "Survive with no team deaths before the Scorpeons arrive",
				},
				laq_nodeath_r4 =
				{
					TITLE = "Mindless Violence",
					DESC  = "Survive with no team deaths until a Boarilla is defeated",
				},
				laq_nodeath_r5 =
				{
					TITLE = "On the Boarrior Path",
					DESC  = "Survive with no team deaths until the Grand Forge Boarrior is defeated",
				},
				laq_nodeath_r6 =
				{
					TITLE = "Drill Down",
					DESC  = "Survive with no team deaths until both Rhinocebros are defeated",
				},
				laq_wintime_30 =
				{
					TITLE = "Bronze Speed Run",
					DESC  = "Win a match in under 30 minutes",
				},
				laq_wintime_25 =
				{
					TITLE = "Silver Speed Run",
					DESC  = "Win a match in under 25 minutes",
				},
				laq_wintime_20 =
				{
					TITLE = "Gold Speed Run",
					DESC  = "Win a match in under 20 minutes",
				},
				laq_spinners_hard =
				{
					TITLE = "Unspun Hero",
					DESC  = "Defeat the Snortoise round without allowing Snortoises to perform any spin attacks",
				},
				laq_rhinodrill_hard =
				{
					TITLE = "Night of the Drilling Dead",
					DESC  = "Defeat the Rhinocebros without allowing either of them to be revived",
				},
				laq_guardsbroken =
				{
					TITLE = "Drop Your Guard",
					DESC  = "Interrupt 5 or more guarded enemies in a single match",
				},
				laq_hammer =
				{
					TITLE = "Strike A Match",
					DESC  = "Land Anvil Strikes on 25 or more targets in a single match",
				},
				laq_petrify =
				{
					TITLE = "Stone Cold",
					DESC  = "Petrify 25 or more enemies before the Infernal Staff drops",
				},
				laq_meteorkill =
				{
					TITLE = "Death From Above",
					DESC  = "Land a killing blow with a Cataclysm Meteor",
				},
				laq_fasthealing =
				{
					TITLE = "Fight Four Their Life",
					DESC  = "Cast 4 Life Blossoms within 60 seconds",
				},
				laq_stronghealing =
				{
					TITLE = "Spell It Out",
					DESC  = "Cast 3 amplified Life Blossoms within 60 seconds",
				},
				laq_distraction =
				{
					TITLE = "Welcome Distraction",
					DESC  = "Achieve the Distraction or Expert Decoy card at the end of the match",
				},
				laq_killingblows_lots =
				{
					TITLE = "Blow It Wide Open",
					DESC  = "Land 10 or more killing blows in a single match",
				},
				laq_axethrow =
				{
					TITLE = "Chuck It Overboard",
					DESC  = "Land 20 Lucy Chucks in a single match",
				},
				laq_flip =
				{
					TITLE = "Flip It Real Good",
					DESC  = "Flip 20 or more Snortoises in a single match",
				},
				laq_shock =
				{
					TITLE = "Shell Shocked",
					DESC  = "Stop a spinning Snortoise with a shock",
				},
				laq_spinstopper =
				{
					TITLE = "Spinning In Their Grave",
					DESC  = "Stop a spinning Snortoise, by any means necessary.",
				},
				laq_battlecry =
				{
					TITLE = "Standing Ovation",
					DESC  = "Trigger the Battle Cry buff on at least 3 friends, 10 times in a single match",
				},
				laq_meteors =
				{
					TITLE = "Meteor Your Match",
					DESC  = "Land Cataclysm Meteors on 40 or more targets in a single match",
				},
				laq_decoy =
				{
					TITLE = "Bundle of Decoy",
					DESC  = "Achieve the Expert Decoy card at the end of the match",
				},
				laq_doctor =
				{
					TITLE = "Win Doctor",
					DESC  = "Achieve the Doctor card at the end of the match",
				},
				laq_merciless =
				{
					TITLE = "Cry Mercy",
					DESC  = "Achieve the Merciless card at the end of the match",
				},
				laq_shadowkill =
				{
					TITLE = "From The Shadows",
					DESC  = "Deal a killing blow using Maxwell's shadow minions",
				},
				laq_fullhands =
				{
					TITLE = "Many Hands Make Fight Work",
					DESC  = "Perform a special attack using a melee weapon, dart and staff all in a single match",
				},
				laq_nodeath_solo_hard =
				{
					TITLE = "Delusions of Grand Forge",
					DESC  = "Survive until the Grand Forge Boarrior is defeated",
				},
				laq_heavyblade_special =
				{
					TITLE = "Best Blade Plans",
					DESC  = "Parry 15 special attacks in a single match using the Blacksmith's Edge",
				},
				laq_defeat_snapper =
				{
					TITLE = "Crocommand the Room",
					DESC  = "Complete the Crocommander round",
				},
				laq_defeat_trails =
				{
					TITLE = "Boarilla'd To Death",
					DESC  = "Defeat the Boarilla",
				},
				laq_defeat_boarrior =
				{
					TITLE = "Boarrior Victorior",
					DESC  = "Defeat the Grand Forge Boarrior",
				},
				laq_defeat_rhinodrill =
				{
					TITLE = "Way To Go, Bro",
					DESC  = "Defeat the Rhinocebro round",
				},
			},
		},
		QUAGMIRE =
		{
			CATEGORIES =
			{
				encore = "Gorge Mastery",
				victory = "Victory",
				tributes = "Offerings",
				chef = "Cooking",
				farmer = "Farming",
				gatherer = "Resource Collection",
			},
			ACHIEVEMENT =
			{
				quag_win_first =
				{
					TITLE = "Escape!",
					DESC  = "Activate the Ancient Gateway and escape the Gorge",
				},
				quag_win_perfect =
				{
					TITLE = "Taste Maker",
					DESC  = "Escape the Gorge without failing to fulfill any cravings",
				},
				quag_win_nodups =
				{
					TITLE = "No Repeater Eater",
					DESC  = "Escape the Gorge without offering any duplicate meals",
				},
				quag_win_nosilver =
				{
					TITLE = "No Silver Linings",
					DESC  = "Escape the Gorge without offering any silver plated meals to the Gnaw",
				},
				quag_win_noburnt =
				{
					TITLE = "Cooked to Perfection",
					DESC  = "Escape the Gorge without having burned or ruined any meals",
				},
				quag_win_nosalt =
				{
					TITLE = "Sodi-yum",
					DESC  = "Escape the Gorge without offering the Gnaw any salted meals",
				},
				quag_win_verylong =
				{
					TITLE = "Flavorville",
					DESC  = "Escape the Gorge having fulfilled 18 or more of the Gnaw's cravings",
				},
				quag_win_long =
				{
					TITLE = "Gnaw's Gnosh",
					DESC  = "Escape the Gorge having fulfilled 15 or more of the Gnaw's cravings",
				},
				quag_win_fast =
				{
					TITLE = "Quick Lunch",
					DESC  = "Escape the Gorge by offering 10 meals or less",
				},
				quag_win_veryfast =
				{
					TITLE = "Zero-Wait Staff",
					DESC  = "Escape the Gorge by offering 7 meals or less",
				},
				tribute_coin4 =
				{
					TITLE = "Favored",
					DESC  = "Earn the Gnaw's Favor",
				},
				tribute_coin3 =
				{
					TITLE = "Marked",
					DESC  = "Find or earn a Red Mark",
				},
				tribute_coin2 =
				{
					TITLE = "Gnaw In The Sky With Sapphires",
					DESC  = "Find or earn a Sapphire Medallion",
				},
				tribute_num_high =
				{
					TITLE = "Spoiled Wyrm",
					DESC  = "Sacrifice something the Gnaw is craving at least 9 times in one match",
				},
				tribute_num_med =
				{
					TITLE = "Eternal Cravings",
					DESC  = "Sacrifice something the Gnaw is craving at least 6 times in one match",
				},
				tribute_num_low =
				{
					TITLE = "Cheat Day",
					DESC  = "Sacrifice something the Gnaw is craving at least 3 times in one match",
				},
				tribute_fast =
				{
					TITLE = "Fast Food",
					DESC  = "Sacrifice something the Gnaw is craving 3 times in 3 minutes",
				},
				cook_full_book =
				{
					TITLE = "Master Chef",
					DESC  = "Discover all possible recipes",
				},
				cook_noburnt =
				{
					TITLE = "It's Not Raw",
					DESC  = "Cook at least 6 meals from start to finish in a single match, without burning any of them",
				},
				cook_first =
				{
					TITLE = "Great Victorian Cook Off",
					DESC  ="Cook a meal",
				},
				cook_large =
				{
					TITLE = "Big Meal",
					DESC  ="Cook and complete at least one meal using a Large Grill, Large Cookpot or Large Casserole Dish",
				},
				cook_all_stations =
				{
					TITLE = "Bake Boss",
					DESC  ="Cook and complete at least one meal using an oven, a cookpot, and a grill, respectively",
				},
				cook_silver =
				{
					TITLE = "The Silver Gullet",
					DESC  ="Increase the value of a dish by plating it in a silver plate or bowl",
				},
				farm_sow_all =
				{
					TITLE = "Sowing Machine",
					DESC  ="Sow one or more of each type of seed",
				},

				farm_fertilize =
				{
					TITLE = "Premium Plant Food",
					DESC  ="Fertilize at least 20 crops in a single match",
				},
				farm_sow =
				{
					TITLE = "Reap What You Sow",
					DESC  ="Sow at least 30 seeds in a single match",
				},
				farm_till =
				{
					TITLE = "Dawn Till Dusk",
					DESC  ="Till at least 50 farm plots in a single match",
				},
				gather_sap =
				{
					TITLE = "Extra Sappy",
					DESC  ="Gather sap from Sugarwood trees 9 times or more in a single match",
				},
				gather_logs =
				{
					TITLE = "Chopped",
					DESC  ="Chop and gather 80 logs or more in a single match",
				},
				gather_crab =
				{
					TITLE = "The Landed Land Crab",
					DESC  ="Catch a Pebble Crab",
				},
				gather_spice =
				{
					TITLE = "The Spice of Strife",
					DESC  ="Grind 5 teaspoons of spice in a single match",
				},
				gather_safe =
				{
					TITLE = "Finders, Keepers",
					DESC  ="Unlock at least one safe",
				},

				quag_encore_nomatches =
				{
					TITLE = "Never Satisfied",
					DESC  = "Escape without satisfying any cravings",
				},
				quag_encore_notrees =
				{
					TITLE = "Tree Hugger",
					DESC  = "Escape without harvesting any logs",
				},
				quag_encore_meaty =
				{
					TITLE = "Killing Spree",
					DESC  = "Escape with all cooked meals having one or more meat ingredients (Meat Scraps, Salmon, Meat, or Crab Meat)",
				},
				quag_encore_veggie =
				{
					TITLE = "Meaty Neglect",
					DESC  = "Escape without any meals cooked with meat ingredients (Meat Scraps, Salmon, Meat, or Crab Meat)",
				},
				quag_encore_allcooks =
				{
					TITLE = "Three Many Cooks",
					DESC  = "Play a 3-player match where everyone has a turn to cook and complete at least two meals",
				},
				quag_encore_all_stations_large =
				{
					TITLE = "Snack of All Trades",
					DESC  = "Cook and complete at least one meal using a Large Grill, a Large Cookpot, and a Large Casserole Dish, respectively",
				},
				quag_encore_tribute_coin3 =
				{
					TITLE = "Marked For Red",
					DESC  = "Find or earn 3 or more Red Marks in one match",
				},
				quag_encore_tribute_coin2 =
				{
					TITLE = "Gather 'Round the Sapphire",
					DESC  = "Find or earn 3 or more Sapphire Medallions in one match",
				},
			},
		},
	},

    PLAYERSUMMARYSCREEN =
    {
        TITLE = "Item Collection",

        TRADING = "Trade Inn",
        PURCHASE = "Shop",

        FESTIVAL_HISTORY = "Through the Gateway",
        CURRENCY_LABEL = "Spools",
        CURRENCY_EXPLAIN = "Items can be unraveled into Spools to weave special items.",
        POINTS_LABEL = "Klei Points",
        XP_LABEL = "XP Earned",
        NEW_STUFF = "Recent Discoveries",
        LOADING_STUFF = "Loading Discoveries...",
        NO_ITEMS = "Start playing to earn items!",
		OFFLINE_NO_ITEMS = "Log in to start earning items.",
        UNOPENED_BOXES_FMT = "{num_boxes} unopened Chests",
        MOST_COMMON_DEATH = "Often Killed By",
        MOST_COMMON_FRIEND = "Friendliest Friend",
        MOST_COMMON_FRIENDS = "Friendliest Friends",
        ENCOUNTER_COUNT_FMT = "Time played with: {time}",

		NO_DEATHS = "No survivor deaths on record.",
		NO_FRIENDS = "Play online and make some friends.",

        TOOLTIP_TRADE = "Trade your old items in for something new!",
        TOOLTIP_SKINS = "View and equip your curios",
        TOOLTIP_MYSTERYBOX = "Open chests to receive new curios",
        TOOLTIP_HISTORY = "View missed connections and revisit past lives",
        TOOLTIP_PURCHASE = "Browse purchasable skin sets",

        LEVEL_ACHIEVED_FMT = "{event_title} level accomplished:",

        FAILED_INVENTORY_TITLE = "Item Collection Download Failed",
        FAILED_INVENTORY_BODY = "Unfortunately you failed to download your item collection, would you like you try again?",
        FAILED_INVENTORY_YES = "Yes",
        FAILED_INVENTORY_NO = "No",

        GET_INVENTORY = "Downloading Item Collection",

        FAILED_NOLOGIN_TITLE = "Authentication Required",
        FAILED_NOLOGIN_BODY = "Unfortunately you will need to login to continue viewing this panel, would you like to try to login again?",
        FAILED_NOLOGIN_YES = "Yes",
        FAILED_NOLOGIN_NO = "No",

        FAILED_NOPERMISSIONS_TITLE = "Permissions Required",
        FAILED_NOPERMISSIONS_BODY = "Unfortunately you will need to login to continue viewing this panel, but you do not allow data collection which is required to login.\n\nData Collection settings can be modified in the Options menu.",
        FAILED_NOPERMISSIONS_NOCHOICE = "I understand",

        MYSTERYBOX_DISABLE = "You must be logged in to access the Treasury.",

        NOT_AVAILABLE_OFFLINE = "This feature is not available in offline mode."
    },

    BEARDSCREEN =
    {
        BEARD_NAMES =
        {
            "Trimmed",
            "Groomed",
            "Magnificent"
        },
    },

    COLLECTIONSCREEN =
    {
        TITLE = "Curio Cabinet",

        SKINS = "Wardrobe",
        GAMEITEM = "Belongings",
        BEARD = "Beards",
        BEEFALO = "Beefalo",
        EMOTE = "Emotes",
        EMOJI = "Emoticons",
        LOADERS = "Vignettes",
        PROFILEFLAIR = "Profile Icons",
        PORTRAITBACKGROUNDS = "Portrait Frames",

        TOOLTIP_SKINS = "View and equip your character skins",
        TOOLTIP_GAMEITEM = "View your skins for craftable in-game items",
        TOOLTIP_BEARD = "View your character beards",
        TOOLTIP_BEEFALO = "View your beefalo skins",
        TOOLTIP_EMOTE = "View your character emotes",
        TOOLTIP_EMOJI = "View your available chat icons",
        TOOLTIP_LOADERS = "Select loading screens to display between games",
        TOOLTIP_PROFILEFLAIR = "Select an icon for your profile",
        TOOLTIP_PORTRAITBACKGROUNDS = "Equip new backgrounds to your characters' portraits",

        FAILED_TO_LOAD = "Sorry!\nWe've temporarily misplaced your curios.\nPlease try again later.",
        VIEW_MARKET = "Steam",
        SET_INFO = "Ensemble",

        NEW = "New!",
    },

    BARTERSCREEN =
    {
        TITLE = "The Curio Loom",
        COMMERCE_BUY = "Weave",
        COMMERCE_GRIND = "Unravel",
        COMMERCE_GRIND_DUPES = "Unravel Duplicates",
        CONFIRM_BUY_FMT = "Use {doodad_count} Spools to weave item: {item_name}?\n\nYou will be left with {doodad_net} Spools.\nSpools are used to weave \"Woven\" rarity curios.",
        FAIL_BUY_FMT = "{doodad_count} Spools are required to weave item: {item_name}.\n\nYou need {doodad_net} more Spool(s) to weave this item.\nSpools can be obtained by unraveling curios.",
        CONFIRM_GRIND_FMT = "Unravel this {item_name} into {doodad_count} Spools?\n\nYou will have a total of {doodad_net} Spools.\nSpools are used to weave \"Woven\" rarity curios.",
        CONFIRM_GRIND_DUPE_FMT = "Unravel 1 duplicate into {doodad_count} Spools?\n\nYou will have a total of {doodad_net} Spools.",
        CONFIRM_GRIND_DUPES_FMT = "Unravel {count} duplicates into {doodad_count} Spools?\n\nYou will have a total of {doodad_net} Spools.",
        COMMERCE_INFO_BUY = "Use {doodad_value} Spools to weave this curio.",
        COMMERCE_INFO_NOBUY_NOT_ACTIVE = "This curio is not currently weaveable.",
        COMMERCE_INFO_NOBUY_NEVER = "This curio is not weaveable.",
        COMMERCE_INFO_NOBUY_UNOWNED = "You must have {character} unlocked to weave this item from Spools.",
        COMMERCE_INFO_GRIND = "This curio can be unraveled into {doodad_value} Spools.",
        COMMERCE_INFO_NOGRIND = "This curio cannot be unraveled.",
        COMMERCE_INFO_GRIND_ENTITLEMENT = "Note: {entitlement_count} of the {total_owned} selected curio is linked to an owned DLC or a past event and can not be unraveled.",
        NO_MARKET = "This curio cannot be traded or sold.",
        CANCEL = "Never mind",
        OK = "OK",

        UNRAVEL_WARNING_TITLE = "Warning!",
        UNRAVEL_WARNING_BODY = "Unraveling this item will break your {ensemble_name} and cause you to lose access to the Reward item, {reward_name}.",
        UNRAVEL_WARNING_RESTRICTED_BODY = "You will no longer be able to play as {character} if you unravel this item. You'll also lose access to all the items you own that are character-specific to {character}, although you'll be able to unravel them, if you wish.",

        FAILED_TITLE = "Connection failure",
        FAILED_BODY = "Sorry!\nFailed to contact Klei Servers. Please try again.",
    },

    WARDROBESCREEN =
    {
        TITLE = "Wardrobe",
        ACCEPT = "Accept Outfit",
        RESET = "Undo Changes",

        BASE = "Head",
        BODY = "Body",
        HAND = "Hands",
        LEGS = "Legs",
        FEET = "Feet",

        SURVIVOR_FILTER_FMT  = "Survivor Filter: {mode}",
        OWNED_FILTER_FMT     = "Owned Filter: {mode}",
        WEAVEABLE_FILTER_FMT = "Weaveable Filter: {mode}",
        SORT_MODE_FMT        = "Sort Mode: {mode}",
        SEARCH = "Search",

        FILTER_ON       = "On",
        FILTER_OFF      = "Off",
        SORT_NAME       = "Name",
        SORT_RARITY     = "Rarity",
        SORT_COUNT      = "Owned Count",
        SORT_RELEASE    = "Release Date",

        TOOLTIP_BASE = "Equip a head item",
        TOOLTIP_BODY = "Equip a body item",
        TOOLTIP_HAND = "Equip a hand item",
        TOOLTIP_LEGS = "Equip a leg item",
        TOOLTIP_FEET = "Equip a foot item",

		CYCLE_VIEW = "Cycle View",
    },

    MYSTERYBOXSCREEN =
    {
        TITLE = "The Treasury",
        BOXES = "My Chests",

        TOOLTIP_BOXES = "View the chests in your inventory",

        OPEN_BOX = "Open Chest",
        OK = "OK",

        OUT_OF_BOXES_BODY = "You have no chests in your treasury.\nStart playing to earn some!",
        OUT_OF_BOXES_BODY_NO_EVENT = "You have no chests in your treasury.",
    },

    PURCHASEPACKSCREEN =
    {
        TITLE = "Shop",

        FAILED_TO_LOAD = "Sorry!\nThe Klei store is closed right now.\nPlease try again later.",

        PURCHASE_OVERLAY_REQUIRED_TITLE = "Steam Overlay Required",
        PURCHASE_OVERLAY_REQUIRED_BODY = "Please enable the Steam Overlay to purchase clothing sets.",

        PURCHASE_OVERLAY_REQUIRED_TITLE_RAIL = "Browser Required",
        PURCHASE_OVERLAY_REQUIRED_BODY_RAIL = "Please enable your browser to purchase clothing sets.",

        PURCHASE_OVERLAY_REQUIRED_HELP = "Help",

        PURCHASE_WARNING_TITLE = "No New Items in Chest",
        PURCHASE_WARNING_DESC = "You already own all the items in this chest. Would you like to purchase it anyway?",
        PURCHASE_WARNING_OK = "Continue Purchase",
        PURCHASE_WARNING_CANCEL = "Never mind!",

        GO_TO_SALES = "View Sales!",

        PACK_SAVINGS = "-{savings}%",
        SALE_TXT = "-{sale_percent}%\nSale!",

        EXPIRE_DAYS_TXT = "Offer expires in {days} days!",
        EXPIRE_DAY_TXT = "Offer expires in 1 day!",
        EXPIRE_HOURS_TXT = "Offer expires in {hours} hours!",
        EXPIRE_HOUR_TXT = "Offer expires in 1 hour!",
        EXPIRE_SOON_TXT = "Offer expires soon!",

        PACK_SHORT_DESC_ITEMS = "Includes {total_items} Belongings skins!",
        PACK_SHORT_DESC_CHAR = "Includes {total_items} Wardrobe skins!",
        PACK_SHORT_DESC = "Includes {total_items} skins!",
        MEGAPACK_SHORT_DESC = "Includes {total_sets} skin sets! {total_items} total skins!",

        INFO_BTN = "?",
        PURCHASE_BTN = "Buy Now",
        PURCHASE_GIFT = "Gift to a Friend",
        PURCHASE_CLOSE = "Close",
        PURCHASE_VIEW_CONTENTS = "View Contents",

		GIFT_RECEIVED_TITLE = "You got a chest!",
		GIFT_RECEIVED_BODY = "Open it to receive your curios.",

        PURCHASE_GIFT_INFO_TITLE = "Purchase Gift",
        PURCHASE_GIFT_INFO_BODY = "To purchase the {pack_name} as a gift for your friend, click on \"Add to Cart\", then \"Purchase as a gift\".",

        FILTERS = "Filters",

        OWNED_FILTER = "Owned:",
        TYPE_FILTER = "Type:",
        DISCOUNT_FILTER = "Discount:",
        FILTER_ALL = "All",
        FILTER_NEW = "New",
        FILTER_UNOWNED = "Unowned",
        FILTER_ITEMS = "Belongings",
        FILTER_BUNDLE = "Bundles",
        FILTER_SALE = "Sales",

        EMPTY_AFTER_FILTER = "There are currently no chests for sale that match your filter criteria.",

        UNOWNED_CHARACTER_BODY = "You do not currently own {character}.\nThis chest contains skins for {character}, which will be unusable without owning them.",
        VIEW_REQUIRED = "View {character} Chests",

        VIRTUAL_CURRENCY = "Bolts of Cloth",
        VIRTUAL_CURRENCY_SHORT = "Bolts",

        CURRENCY_SHORT_DESC =  "Includes {currency} Bolts of Cloth!",

        NOT_ENOUGH_TITLE = "Lacking Bolts of Cloth",
        NOT_ENOUGH_BODY = "Unfortunately you don't have the required Bolts of Cloth to purchase the {chest_name}. You still require {currency_needed} Bolts. Would you like to look at Bolt chests?",

        VIRTUAL_IAP_CONFIRM_TITLE = "Confirm Purchase",
        VIRTUAL_IAP_CONFIRM_BODY = "Are you sure you would like to spend {cost} Bolts on the {chest_name}?",

        SHOP_EPOCH_WRONG_TITLE = "Incorrect System Time",
        SHOP_EPOCH_WRONG_BODY = "It looks like your date and time is incorrect. Perhaps you've been time travelling in another game?\n\nPlease verify your system date and time before purchasing.",

        CURRENCY_NEEDED = "You require {currency_needed} Bolts for the {chest_name}",
        CURRENCY_OK = "You have the required Bolts for the {chest_name}",

        VIEW_CURRENCY = "View Bolt Chests",
        VIEW_REGULAR = "View Chests",

        OK = "OK",
    },

    ITEM_SERVER =
    {
        FAILED_TITLE = "Purchase Failure",
        FAILED_EVENT_TITLE = "Achievements Failure",

        FAILED_DEFAULT = "Sorry!\nFailed to contact Klei Servers. Please try again.",
        FAILED_MULTIPLE_PENDING_PURCHASES = "Unable to start a new transaction due to having an outstanding purchase active. Please close all other purchases, and try again later.",
        FAILED_IAP_RATE_LIMITED = "Unable to start a new transaction due to being rate limited. Please slow down and try again later.",

        CONNECT = "Contacting Klei Servers",
    },

    SETPOPUP =
    {
        OK = "OK",
        REWARD = "Reward:",
        PREV_SET = "Previous Set",
        NEXT_SET = "Next Set",
    },

    -- Rarity and colour tables are to allow translation of item properties. Keys are the names as returned by the item server.
    RARITY =
    {
        Complimentary   = "Complimentary",
        Common          = "Common",
        Classy          = "Classy",
        Spiffy          = "Spiffy",
        Distinguished   = "Distinguished",
        Elegant         = "Elegant",
        Character       = "Character",
        HeirloomClassy = "Heirloom Classy",
        HeirloomSpiffy = "Heirloom Spiffy",
        HeirloomDistinguished = "Heirloom Distinguished",
        HeirloomElegant = "Heirloom Elegant",
        Timeless        = "Timeless",
        Loyal           = "Loyal",
        ProofOfPurchase = "Proof Of Purchase",
        Resurrected     = "Resurrected (Merch Skin)",
        Reward          = "Reward",
        Event           = "Event (Limited-Time Use)",

		Woven		    = "Woven - ",
		Inspired        = "Inspired - ",
        CharacterModifier = "",

    },

    COLOUR =
    {
        Black = "Black",
        Blue = "Blue",
        Brown = "Brown",
        Green = "Green",
        Grey = "Gray",
        Navy = "Navy",
        Orange = "Orange",
        Pink = "Pink",
        Purple = "Purple",
        Red = "Red",
        Tan = "Tan",
        Teal = "Teal",
        White = "White",
        Yellow = "Yellow",
    },

    TRADESCREEN =
    {
        TITLE = "Trade Inn",

        TEMPORARILY_CLOSED_BODY = "The Trade Inn is closed for a bit.\n\nBe back soon, okay?",

        CROW = "Chase Crow",
        SNOWBIRD = "Chase Snowbird",
        RESET = "Reset",
        START = "Start",
        TRADE = "Trade",
        SELECT = "Select",
        ACCEPT = "Accept",
        CANCEL = "Cancel",
        SELECT_TITLE = "Choose Items To Swap",
        REMOVE_ITEM = "Remove Item",
        BACK = "Back",
        MARKET = "Steam",
        EQUIPPED = "Last one!",
        CHECK = "Warning!",
        WARNING_SINGLE = "You won't be able to wear an item if you give your last one away! Do you really want to trade this item?",
        WARNING = "You won't be able to wear an item if you give your last one away! Do you really want to trade these items?",
        SERVER_ERROR_TITLE = "Error Trading Items",
        SERVER_ERROR_BODY = "There was an error trading your items. Please login again to refresh your account inventory.",
        SORRY = "Sorry",
        OFFLINE = "The Trade Inn is not available in offline mode.",
        OK = "OK",
        SPECIALS_TITLE = "Specials",
        SPECIALS = "Specials",
        NOSPECIALS = "Unspecials",
        DAYS_REMAINING = "Days Remaining",
        DAY_REMAINING = "Day Remaining",
        LESS_THAN_DAY = "Less Than A Day Remaining",
        ENDING_SOON = "Ending Soon",
        SOLD_OUT = "Sold Out",
        NEXT = "Next Special",
        PREV = "Prev. Special",

        BASE = "Head",
        BODY = "Body",
        HAND = "Hands",
        LEGS = "Legs",
        FEET = "Feet",

        RECIPE_INGREDIENT_ITEM = "<number> <rarity> <colour><item><plural>",
        RECIPE_INGREDIENT_TAGS = "<number> <rarity> <tags>Item<plural>",
        RECIPE_INGREDIENT_RARITY = "Any <number> <rarity> Item<plural>",

        RECIPE_TITLE = "Wanted: <rarity> Items",
        NO_RECIPES = "No offers",

        BIRDS = "Curiosities",
        BIRDS_TITLE_SUB = "(Curio Collector Games)",

        MAGICSKIN_COLLECTOR_SPEECH =
        {
            -- Shadow Curio dealer.
            START =
            {
                "Greetings, mortal. Have you brought chests? I'll be happy to reveal your gifts, if so.",
                "Greetings, mortal. I sense a chest in your possession! Please, be my guest.",
                "Greetings, mortal. Come to receive gifts from the Shadow realm? You need only open your chests.",
            },
            START_EMPTY =
            {
                "Greetings, mortal. No chests today? A shame.",
                "Greetings, mortal. I sense you have no chests. You have been adventuring, yes?",
                "Greetings, mortal. Chests to find their way to you on your travels. I'll be here, until then.",
            },
            IDLE =
            {
                "It seems you've a few admirers lurking in the shadows.",
                "Do you ever tire of that ratty old mortal body?",
                "[Sigh] Immortality is such a burden.",
                "You're a long way from home are you not, little mortal?",
                "You must recount your corporeal stories to me some time, mortal.",
                "Fear the dark, little mortal.",
                "[Chortle] Have you met her yet?",
                "Your realm is a bit frazzled around the edges, hm?",
                "Tell me, have you traveled through the Gateway yet?",
                "Be at ease, mortal. We exist outside time, here.",
                "I'll admit, I've always found Chesters endearing.",
                "[Chortle] You mortals have been quite enamored with the throne, haven't you?",
                "[The shadow murmurs something, but you cannot comprehend the words.]",
            },
            HAND =
            {
                "Test",
            },
        },

        CROW_GAME =
        {
            HIGH_SCORE = "High Score: ",
            GAME_SCORE = "Game Score: ",
            MOVE_SCORE = "Last Move Score: ",
            REPORTING = "Reporting wrapper tidyin'...",
            THANKS = "Thanks for tidyin' up!",
            GAME_OVER_POPUP_TITLE = "All done tidyin'",
            GAME_OVER_POPUP_BODY = "Great job tidyin' up.\nYou completed {moves} moves, for a score of {score}!",
            OPEN_GIFT = "Open Gift",

            POWERUP_NAME =
            {
                cane = "Cane",
                shovel = "Shovel",
                gunpowder = "Gunpowder",
                spear = "Spear",
                seeds = "Seeds",
            },

            HELP = "Help",
            HELP_TITLE = "Ravin' Wrapper Raiders",
            HELP_BODY = "Oh crow!\nA murder of feathered fiends has gotten their claws into the Curio Collector's prized collection of candy wrappers!\n\nHelp him scare away the crows by matching adjacent pairs of wrappers. Use tools to help clear big groups of wrappers and crows to improve your score. Clearing 10 or more tiles will grant you a bonus tool.",
        },

        SKIN_COLLECTOR_SPEECH_CROW =
        {

            START =
            {
                "Help me scare off these crows. Don't get any funny ideas though, I won't give you a better deal for helping.",
                "Ack! These crows won't leave my wrappers alone.",
                "Knew I shouldn't'a left the my wrappers just lyin' around... now these crows are all over my collection!",
                "I've done witnessed a murder! And they're stealin' all my hard-earned candy wrappers!",
                "Gimme a hand gettin' rid of these crows, will ya?",
                "Wanna play a game? Help me pick up my wrappers and get rid of those dang crows. Doesn't that sound fun?",
                "What, ya got something better to do? Help me get these crows outta here!",
            },

            POWERUP_SELECTED =
            {
                cane =
                {
                    "That'll help ya get around and collect all look-alike wrappers.",
                },

                shovel =
                {
                    "Cleaning up a whole row. That's smart!",
                },

                gunpowder =
                {
                    "Careful! That stuff will blow away everythin' near it!",
                },

                spear =
                {
                    "Sharp and precise!",
                },

                seeds =
                {
                    "What are ya doing with those seeds!? Y'er supposed to be chasing the crows away, not attractin' 'em!",
                },
            },

            CLEARED_LOTS = "Great work clearin' {tiles_cleared} tiles! Here, I've got something for ya. Take this {powerup}.",

            CLEARED_CROW_LOTS =
            {
                "Yeehaw! Get on out of here!",
                "Hah! Those are my wrappers!",
                "Seein' those crows scatter is sweeter than my favorite candy!",
            },

            GAME_OVER =
            {
                "Looks like y'er all out of options!",
                "Try again! There's many more wrappers in my collection to tidy up.",
                "Thanks for helpin', but I can't give you a better trade. I've got mouths to feed, ya'know.",
                "All done for now, but ya made some progress tidyin' up my wrapper collection. ",
            },

            USE_POWERUP =
            {
                "Looks like y'er stuck kid. Maybe ya ought to use one of those tools.",
                "Y'er out of moves, try using a tool to help ya out.",
            }
        },

        CROWKID_GAME =
        {
            GAME_SCORE = "Junk Found: ",
            STEPS = "Steps Taken: ",
            REPORTING = "Reporting tidying up'...",
            THANKS = "Thanks for tidyin'",
            GAME_OVER_POPUP_TITLE = "Thanks for tidyin'",
            GAME_OVER_POPUP_BODY_25 = "You've collected 25 pieces of junk. That's a good start.",
            GAME_OVER_POPUP_BODY_100 = "You've collected all of the junk. Thanks a million.",
            OPEN_GIFT = "Open Gift",

            HELP = "Help",
            HELP_TITLE = "A Mess of a Maze",
            HELP_BODY = "The Crows left a mess in the maze after last year's Cawnival. Move around the maze to pick up all of the leftover junk.",
        },

        KITCOON_GAME =
        {
            NAME_AGE = "{name} is {age} days old.",
            HIBERNATING = "{name} is hibernating.",
            OKAY = "Okay",
            NAME_POPUP_TITLE = "Name your Kitcoon",
            NAME_POPUP_BODY = "Any name is great, but pick one that is meaningful to you!",
            PLAY_WITH = "Play with {name}",
            WAKE = "Wake {name} from hibernation",
            HIBERNATE = "Send {name} to hibernate",
            FEED = "Feed {name}",
            CLEAR_POOP = "Clear Poop",
            PICKUP_NAMETAG = "Pick up Kit Collar",

            ABANDONED_TITLE = "{name} has abandoned you.",
            ABANDONED_BODY = "Sadly, {name} was feeling neglected. They went looking for the affection, food and tidier home that they felt they deserved.",

            HELP_TITLE = "Collar Me Impressed",
        },

        SNOW_GAME =
        {
            HIGH_SCORE = "High Score: ",
            GAME_SCORE = "Score: ",
            LIVES = "Guesses Remaining: ",
            REPORTING = "Reporting feast memories'...",
            THANKS = "Thanks for playing!",
            GAME_OVER_POPUP_TITLE = "All done rememberin'",
            GAME_OVER_POPUP_BODY = "Great job matching'.\nYou completed {score} pairs!",
            OPEN_GIFT = "Open Gift",

            HELP = "Help",
            HELP_TITLE = "A Feastin' Pair of Birds",
            HELP_BODY = "Match pairs of food tiles from the feast. Clearing a pair will cause the tiles above to drop down, so be sure to remember what foods were there. Matching a pair of snowbirds will grant you an extra guess.\n\nGood luck!",
        },

        SKIN_COLLECTOR_SPEECH_CROWKID =
        {
            START =
            {
                "Those pesky crows always leave a mess! Mind tidying up?",
                "Those birdbrains left their Cawnival stuff all over the place! Go clear it out, would ya?",
                "This place is littered with old Cawnival junk. Mind taking care of it for me?"
            },

            GAME_OVER_25 =
            {
                "Thanks for cleaning up, I got winded just watchin' ya.",
                "The place looks much better. Mighty obliged.",
            },

            MORE =
            {
                "Keep goin', y'er doin' great!",
                "Don't stop now, ya missed a few over there!",
            },

            GAME_OVER_100 =
            {
                "Amazin' work! I can't see a single piece of junk anymore!",
                "All tidy, just like it was before those pesky crows arrived.",
            },
        },


        SKIN_COLLECTOR_SPEECH_SNOW =
        {
            START =
            {
                "Let's play a game! Use that big brain to match pairs of food from the feast!",
                "Use y'er noggin to remember pairs. Chase off any pesky snowbirds while y'er at it.",
                "My ol' pops taught me this game. Try to remember and match pairs."
            },

            ADD_LIFE =
            {
                "Yeehaw! I'll give you another guess for that.",
                "They sure want in on our feast! Scare 'em away!",
                "Tha birds are after my favorite! Tha sweet Pumpkin Pie.",
                "It's a festive time for sharin' but not with those bothersome birds.",
                "I've got mouths to feed. Tha birds will have to find their own feast.",
                "Ya'll can come back when tha feast is over!",
            },

            GAME_OVER =
            {
                "Y'er all out of guesses!",
                "Try again! Ya can do better, I know it!",
                "Y'er all done!",
            },
        },

        REDBIRD_GAME =
        {
            HIGH_SCORE = "High Score: ",
            GAME_SCORE = "Score: ",
            REPORTING = "Reporting Eggy sums...",
            THANKS = "Thanks for playing!",
            GAME_OVER_POPUP_TITLE = "All done countin'",
            GAME_OVER_POPUP_BODY_SINGULAR = "Great job countin'.\nYou completed 1 egg for a total of {score} points!",
            GAME_OVER_POPUP_BODY = "Great job countin'.\nYou completed {eggs} eggs for a total of {score} points!",
            OPEN_GIFT = "Open Gift",

            EGG_TIMER_OVER = "Game Over",
            EGG_TIMER = "Egg Timer:",
            EGG_TIMER_SPOILED = "The egg is rotten!",

            HELP = "Help",
            HELP_TITLE = "An Eggy Tally",
            HELP_BODY = "Combine tiles to add up to 100. Completing a tile with a value of 100 earns you a large amount of points. The faster you add, the more points you'll receive.\n\nGood luck!",
        },

        SKIN_COLLECTOR_SPEECH_REDBIRD =
        {
            START =
            {
                "I've got a challenge for ya! Add tiles up to 100. Let's see how many points ya can score!",
                "Can ya get me half-a-dozen eggs? A full dozen would be grand!",
                "Better be quick getting those eggs for me. I can't use any rotten ones.",
                "Use y'er noggin to add up numbers. Get to 100 exactly and a Redbird will lay an egg!",
                "Countin' is my specialty. Let's see how good ya can do."
            },

            EGG_COMPLETE =
            {
                "Eggcellent! That's worth {points} points!",
                "Well done! Just the way I like my eggs. That's worth {points} points!",
                "So many mouths to feed, another egg will help. {points} points earned!",
                "Y'er brain is gettin' some eggsercise. I'll give ya {points} points.",
                "That's worth {points} points! I need half-a-dozen eggs, think ya can get me more?",
            },

            EGG_COMPLETE_ROTTEN =
            {
                "Yuck! No one is going to want to eat that egg.",
                "What's that smell? My nose is tellin' me tha' egg is rotten.",
                "It's startin' to smell like a hot spring.",
                "Y'er gonna have to work faster than that!",
                "Ya might be eggshausted, but keep going!",
                "I like to eggsperiment with my cookin', but that's just gross."
            },

            GAME_OVER_REDBIRD =
            {
                "Amazin' work! Ya deserve a special prize for that.",
            },

            GAME_OVER_EGG =
            {
                "Thanks for the eggs! I certainly do appreciate y'er effort.",
            },

            GAME_OVER_ROTTEN =
            {
                "Well, ya delivered some eggs. Though I'm not sure how useful they'll be.",
            },

            GAME_OVER =
            {
                "Try again! Ya can do better, I know it!",
                "Y'er all done!",
            },
        },

        SKIN_COLLECTOR_SPEECH =
        {
            -- Old west fur trader.
            START =
            {
                "Ya got a heap 'o items? Want better items? Well, ya come to tha right place! Put 'em in that thar machine!",
                "Got too many items? I can help ya with that problem! Stick 'em in my machine an' trade 'em for somethin' better!",
                "Lookin' for new items? Trade in some old items and get a bran' new one of higher quality!",
                "Lookin' to trade? Ya come to the right place. Put your items in tha machine to get somethin' better!",
            },
            START_EMPTY =
            {
                "C'mon back when ya got something ta trade!",
                "Sorry, but I can't give ya something for nothing, ya know.",
                "If ya find any items while y'er adventuring around out there, ya can bring the ones ya don't need ta me.",
            },
            SPECIALS =
            {
                "These're my special deals. Gimme tha stuff I'm looking for and I'll give ya a better item in exchange.",
                "I'm lookin' for some particular things right now. If ya can give 'em to me, I'll give ya a new one of higher quality.",
                "Tha special deals are cheaper than tha normal ones, but ya gotta give me tha exact things I'm lookin' for.",
            },
            ADDMORE =
            {
                "Help a poor old trader out with a few more <rarity> items and I'll give ya a higher quality item in exchange. Guaranteed.",
                "I'm gonna need a few more <rarity> items to make a trade. I gotta cover my overhead, ya know? But ya'll get a better item in exchange.",
                "Tha's it, fill tha machine on up with <rarity> items and ya'll get a higher quality item back out.",
                "Tha's tha ticket. Just bang a few more a those <rarity> items in tha machine to get a better item!",
            },
            ADDMORESPECIALS =
            {
                "Ya got tha rest of tha stuff I'm lookin' for? If not, come back in a few days an' there might be a new deal.",
                "I just need tha rest of tha items on tha list. Bang 'em on in tha machine an' it'll spit out a higher quality item for ya.",
            },
            SPECIALRECIPE =
            {
                "If ya give me tha items on tha list, I'll give ya a higher quality item in exchange.",
                "Take a look at tha list. Get me all tha things on it and I'll give ya a better item.",
                "Ya got tha items on tha list? Stick 'em in there and ya'll get a better item out 'o tha machine.",
            },
            TRADEAVAIL =
            {
                "All right, kid. Give tha button a push to getcher item!",
                "Just push tha button to start tha trade!",
                "If ya wanna make tha trade, just push tha green button.",
            },
            TRADE =
            {
                "It'll be here in a jiffy.",
                "I bet ya can't wait to see what comes out!",
                "It should be here real soon now.",
            },
            WARNING =
            {
                "Slow down there, greenhorn. Are ya sure ya wanna gimme your last one 'o those? Ya won't be able ta use it anymore if ya do.",
                "Wait jest a tick there. Tha's your last one o' those things. Ya won't be able to use it anymore if ya trade it away.",
                "Ya ain't got no more o' those. Ya sure ya wanna get rid o' it? Not that I won't take it, o' course.",
            },
            RESULT =
            {
                "Here ya go, one very fine <item>!",
                "Look a' that, ya won a <item>. C'mon back anytime, now.",
                "There ya go, ya got this here <item>.",
            },
            RESULT_LUCKY =
            {
                "Hey, ya struck it rich! Look at that <item>. Ya must be extra lucky today.",
                "Here ya go, one bran' new <item>. Jus' remember I can't afford to give ya items this good all tha time.",
                "Well, I guess me & tha machine are feelin' gen'rous today. Ya won a <item>!",
                "Ain't that just tha koalefant's toenails! Ya got one very purty <item>.",
            },
            JOYSTICK =
            {
                "Ya can bang on that joystick all ya want but it won't do ya no good.",
                "Don't ya go breakin' tha joystick, now. Ya don' need it anyhow.",
                "Up, down, left, right, tha joystick don' do nothin'.",
            },
            HAND =
            {
                "Pleased ta meecha.",
                "Pleasure doin' business with ya.",
            },
            IDLE =
            {
                "Ya may not feel young, but I've been tradin' longer than ya been around, young pup.",
                "I've always been a loner, me. Tha boss mostly lets me alone, which suits me fine.",
                "Take y'er time. I can stand here yammerin' all day.",
                "My wagon's pulled by a nox. 'Es a good 'un, but 'e can't hold a candle to my old mule, Shadow.",
                "Once, when I was but a young shaver... ah, but ya don' wanna listen to an old trader's stories.",
                "What's a nox? Well, I don't know as I can rightly describe it. It's kinda like an ox, but not.",
            },
        },
    },

    MORGUESCREEN =
    {
        HISTORY = "History",
        MORGUE = "Morgue",
        TITLE = "Obituaries",
        ENCOUNTERSTITLE = "Encounters",
        LONGENCOUNTERSTITLE = "Recent Encounters",
        BACK = "Back",
        OK = "OK",
        PLAYER_NAME = "Player",
        PLAYER_CHAR = "Face",
        PLAYER_CHAR_PS4 = "Survivor",
        SERVER_NAME = "Server",
        DECEASED = "Deceased",
        DECEASED_PS4 = "Survivor",
        CAUSE = "Cause of Death",
        MODE = "World",
        MODE_PS4 = "Date",
        SEEN_DATE = "Date",
        PLAYER_AGE = "Age",
        DIED_AGE = "Survived",
        NET_ID = "Profile",
        CLEAR = "Clear",
        DAY = "Day",
        DAYS = "Days",
        UNKNOWN_DAYS = "?",

        ENCOUNTERS =
        {
            DESC = "Last seen {date}, on {server_name}",
            PLAYTIME_LABEL = "Play Time",
        },
    },

    CONTROLSSCREEN =
    {
        -- Must match the Control enum in DontStarveInputHandler.h
        -- Must match constants.lua CONTROLS_*
        CONTROLS =
        {
            "Primary",
            "Secondary",
            "Do Attack",
            "Examine",
            "Do Action",
            "Move Up",
            "Move Down",
            "Move Left",
            "Move Right",
            "Zoom In",
            "Zoom Out",
            "Rotate Left",
            "Rotate Right",
            "Pause",
            "Map",
            "Inv 1",
            "Inv 2",
            "Inv 3",
            "Inv 4",
            "Inv 5",
            "Inv 6",
            "Inv 7",
            "Inv 8",
            "Inv 9",
            "Inv 10",
            "Menu Up",
            "Menu Down",
            "Menu Left",
            "Menu Right",
            "Menu Accept",
            "Menu Cancel",
            "Menu Scroll Up",
            "Menu Scroll Down",
            "Menu Prev Value",
            "Menu Next Value",
            "Take Half",
            "Change Box",
            "Change Box (Half)",
            "Force Inspect (mod)",
            "Force Attack (mod)",
            "Force Container (mod)",
            "Force Stack (mod)",
            "Debug Console",
            "Debug Log",
            "Debug Render",
            "Open Inventory",
            "Open Crafting Menu",
            "Inv Left",
            "Inv Right",
            "Inv Up",
            "Inv Down",
            "Inv Examine",
            "Inv Use Self",
            "Inv Use Scene",
            "Inv Drop",
            "Inv Adjust Stack",
            "Attack", --controller version
            "Action", --controller version
            "Alt Action",
            "Inv Use On Item",
            "Map Zoom In",
            "Map Zoom Out",
            "Debug Menu",
            "Global Chat",
            "Whisper Chat",
            "Slash Command",
            "Scoreboard",
            "Scoreboard",
            "Menu Misc 1", --controller
            "Menu Misc 2", --controller
            "Menu Misc 3", --controller
            "Menu Misc 4", --controller
            "Inspect Self",
            "Pause Server",
			"Crafting Menu (mod)",
			"Pinned Recipes Page Left",
			"Pinned Recipes Page Right",
            "Inv 11",
            "Inv 12",
            "Inv 13",
            "Inv 14",
            "Inv 15",
            "Start Emoticon",
            "Menu Back",
            "Menu Start",
            "Menu L2",
            "Menu R2",
            "Social Menu",
            "Toggle Target locking",
            "Next Target",
			"Modifier 1", --CONTROL_CAM_AND_INV_MODIFIER
			"Character Command Wheel",
			"", --CONTROL_PRESET_RSTICK_UP
			"", --CONTROL_PRESET_RSTICK_DOWN
			"", --CONTROL_PRESET_RSTICK_LEFT
			"", --CONTROL_PRESET_RSTICK_RIGHT
			"", --CONTROL_PRESET_DPAD_UP
			"", --CONTROL_PRESET_DPAD_DOWN
			"", --CONTROL_PRESET_DPAD_LEFT
			"", --CONTROL_PRESET_DPAD_RIGHT
            "Toggle Alignment (mod)",
            "Cycle Alignment Grid",
        },
		OVERRIDE_CONTROL_NAMES =
		{
			MAP_ROTATE_LEFT = "Map Rotate Left",
			MAP_ROTATE_RIGHT = "Map Rotate Right",
			CAMERA = "Camera Control",
			AIMING = "Aiming Reticule",
			INV_NAVI = "Inventory Navigation",
			INV_ACTIONS = "Inventory Actions",
		},
		-- Must match constants.lua CONTROL_SCHEMES_*
		SCHEMES =
		{
			"Camera and Inventory",
		},
		SCHEME_OPTIONS =
		{
			TYPE1 = "Type 1",
			TYPE2 = "Type 2",
			TYPE3 = "Type 3",
			TYPE4 = "Type 4",
			TYPE5 = "Type 5",
			TYPE6 = "Type 6",
			TYPE7 = "Type 7",
		},

        DEVICE_TITLE = "Controls",
        APPLY = "Apply",
        RESET = "Reset Binds",
        CANCEL = "Cancel",
        BACK = "Back",
        CLOSE = "Close",
        YES = "Yes",
        NO = "No",
        CONTROL_SELECT = " -- Select new input -- ",
        DEFAULT_CONTROL_TEXT = "Default: %s",
        CHANGEBIND = "Change Bind",
        UNBIND = "Unbind Action",
        APPLYTITLE = "Accept Changes",
        APPLYBODY = "Do you wish to accept these changes?",
        RESETTITLE = "Reset Binds",
        RESETBODY = "Do you want to reset all binds to their defaults?",
        LOSE_CHANGES_TITLE = "Lose Changes?",
        LOSE_CHANGES_BODY = "Do you want abandon your changes?",
        INVALID_CONTROL = "N/A",
        -- INPUT_NAMES corresponds to DeviceType enum in InputDefinitions.h
        INPUT_NAMES =
        {
            [1] = "Keyboard/Mouse",
            [2] = "Xbox Controller",
            [3] = "PS4 Controller", --for PS4
            [4] = "Vita Remote Play",
            [5] = "Generic Controller",
            [6] = "Touch Input",
            [7] = "Steam Controller",
            [8] = "PS5 Controller",
            [9] = "Unknown",
            [10] = "Switch Controller",
            [11] = "Steam Deck",
            [12] = "DualSense™ wireless controller",
            [13] = "Joy-Con™ (L)",
            [14] = "Joy-Con™ (R)",
        },

        INPUTS =
        {
            -- KeyBoardMouse
            [1] =
            {
                -- Keyboard buttons
                [0] = "Unknown",
                [8] = "Backspace",
                [9] = "Tab", -- KEY_TAB
                [12] = "Clear", -- KEY_CLEAR
                [13] = "Enter", -- KEY_RETURN
                [19] = "Pause", -- KEY_PAUSE
                [27] = "Esc", -- KEY_ESCAPE
                [32] = "Space", -- KEY_SPACE
                --[33] = "!", -- KEY_EXCLAIM
                --[34] = "", -- KEY_QUOTEDBL
                --[35] = "", -- KEY_HASH
                --[36] = "", -- KEY_DOLLAR
                --[38] = "", -- KEY_AMPERSAND
                [39] = "'", -- KEY_QUOTE
                --[40] = "", -- KEY_LEFTPAREN
                --[41] = "", -- KEY_RIGHTPAREN
                --[42] = "", -- KEY_ASTERISK
                --[43] = "", -- KEY_PLUS
                [44] = ",", -- KEY_COMMA
                [45] = "-", -- KEY_MINUS
                [46] = ".", -- KEY_PERIOD
                [47] = "/", -- KEY_SLASH
                [48] = "0", -- KEY_0
                [49] = "1", -- KEY_1
                [50] = "2", -- KEY_2
                [51] = "3", -- KEY_3
                [52] = "4", -- KEY_4
                [53] = "5", -- KEY_5
                [54] = "6", -- KEY_6
                [55] = "7", -- KEY_7
                [56] = "8", -- KEY_8
                [57] = "9", -- KEY_9
                --[58] = "", -- KEY_COLON
                [59] = "Semicolon", -- KEY_SEMICOLON        ;
                [60] = "<", -- KEY_LESS
                [61] = "Equals", -- KEY_EQUALS              =
                [62] = ">", -- KEY_GREATER
                --[63] = "", -- KEY_QUESTION
                --[64] = "", -- KEY_AT

                [91] = "Left Bracket", -- KEY_LEFTBRACKET   [
                [92] = "Backslash", -- KEY_BACKSLASH        \\
                [93] = "Right Bracket", -- KEY_RIGHTBRACKET [
                --[94] = "", -- KEY_CARET
                --[95] = "", -- KEY_UNDERSCORE
                [96] = "`", -- KEY_BACKQUOTE
                [97] = "A", -- KEY_A
                [98] = "B", -- KEY_B
                [99] = "C", -- KEY_C
                [100] = "D", -- KEY_D
                [101] = "E", -- KEY_E
                [102] = "F", -- KEY_F
                [103] = "G", -- KEY_G
                [104] = "H", -- KEY_H
                [105] = "I", -- KEY_I
                [106] = "J", -- KEY_J
                [107] = "K", -- KEY_K
                [108] = "L", -- KEY_L
                [109] = "M", -- KEY_M
                [110] = "N", -- KEY_N
                [111] = "O", -- KEY_O
                [112] = "P", -- KEY_P
                [113] = "Q", -- KEY_Q
                [114] = "R", -- KEY_R
                [115] = "S", -- KEY_S
                [116] = "T", -- KEY_T
                [117] = "U", -- KEY_U
                [118] = "V", -- KEY_V
                [119] = "W", -- KEY_W
                [120] = "X", -- KEY_X
                [121] = "Y", -- KEY_Y
                [122] = "Z", -- KEY_Z
                [127] = "Delete", -- KEY_DELETE

                [256] = "Num 0", -- KEY_KP0
                [257] = "Num 1", -- KEY_KP1
                [258] = "Num 2", -- KEY_KP2
                [259] = "Num 3", -- KEY_KP3
                [260] = "Num 4", -- KEY_KP4
                [261] = "Num 5", -- KEY_KP5
                [262] = "Num 6", -- KEY_KP6
                [263] = "Num 7", -- KEY_KP7
                [264] = "Num 8", -- KEY_KP8
                [265] = "Num 9", -- KEY_KP9
                [266] = "Num .", -- KEY_KP_PERIOD
                [267] = "Num /", -- KEY_KP_DIVIDE
                [268] = "Num *", -- KEY_KP_MULTIPLY
                [269] = "Num -", -- KEY_KP_MINUS
                [270] = "Num +", -- KEY_KP_PLUS
                [271] = "Num Enter", -- KEY_KP_ENTER
                --[272] = "", -- KEY_KP_EQUALS

                [273] = "Up", -- KEY_UP
                [274] = "Down", -- KEY_DOWN
                [275] = "Right", -- KEY_RIGHT
                [276] = "Left", -- KEY_LEFT
                [277] = "Insert", -- KEY_INSERT
                [278] = "Home", -- KEY_HOME
                [279] = "End", -- KEY_END
                [280] = "Page Up", -- KEY_PAGEUP
                [281] = "Page Down", -- KEY_PAGEDOWN

                [282] = "F1", -- KEY_F1
                [283] = "F2", -- KEY_F2
                [284] = "F3", -- KEY_F3
                [285] = "F4", -- KEY_F4
                [286] = "F5", -- KEY_F5
                [287] = "F6", -- KEY_F6
                [288] = "F7", -- KEY_F7
                [289] = "F8", -- KEY_F8
                [290] = "F9", -- KEY_F9
                [291] = "F10", -- KEY_F10
                [292] = "F11", -- KEY_F11
                [293] = "F12", -- KEY_F12
                [294] = "F13", -- KEY_F13
                [295] = "F14", -- KEY_F14
                [296] = "F15", -- KEY_F15

                [300] = "Num Lock", -- KEY_NUMLOCK
                [301] = "Caps Lock", -- KEY_CAPSLOCK
                [302] = "Scroll Lock", -- KEY_SCROLLOCK
                [303] = "Right Shift", -- KEY_RSHIFT
                [304] = "Left Shift", -- KEY_LSHIFT
                [305] = "Right Control", -- KEY_RCTRL
                [306] = "Left Control", -- KEY_LCTRL
                [307] = "Right Alt", -- KEY_RALT
                [308] = "Left Alt", -- KEY_LALT
                [309] = "Right Meta", -- KEY_RMETA
                [310] = "Left Meta", -- KEY_LMETA
                [311] = "Left Windows", -- KEY_LSUPER       /**< Left "Windows" key */
                [312] = "Right Windows", -- KEY_RSUPER      /**< Right "Windows" key */
                [313] = "Mode", -- KEY_MODE         /**< "Alt Gr" key */
                [314] = "Compose", -- KEY_COMPOSE       /**< Multi-key compose key */

                [315] = "Help", -- KEY_HELP
                [316] = "Print Screen", -- KEY_PRINT
                --[317] = "", -- KEY_SYSREQ
                --[318] = "", -- KEY_BREAK
                [319] = "Menu", -- KEY_MENU
                [320] = "Power", -- KEY_POWER       /**< Power Macintosh power key */
                [321] = "Euro", -- KEY_EURO         /**< Some european keyboards */
                [322] = "Undo", -- KEY_UNDO         /**< Atari keyboard has Undo */

                [400] = "Alt", -- KEY_ALT
                [401] = "Control", -- KEY_CTRL
                [402] = "Shift", -- KEY_SHIFT

                -- Mouse controls
                [1000] = "\238\132\128", --"Left Mouse Button",
                [1001] = "\238\132\129", --"Right Mouse Button",
                [1002] = "\238\132\130", --"Middle Mouse Button",
                [1003] = "\238\132\133", --"Mouse Scroll Up",
                [1004] = "\238\132\134", --"Mouse Scroll Down",
                [1005] = "\238\132\131", --"Mouse Button 4",
                [1006] = "\238\132\132", --"Mouse Button 5",
            },
            -- Xbox on PC (CharlesB: XboxOne/Xbox Series is down below in index 13)
            [2] =
            {
                [0] = "Unknown",
				rstick = "\238\128\152",
				dpad = "\238\128\153",

                -- Digital
                "\238\128\143",--"DPad Up"
                "\238\128\140",--"DPad Down"
                "\238\128\141",--"DPad Left",
                "\238\128\142",--"DPad Right"
                "\238\128\132",--"Start",
                "\238\128\133",--"Back",
                "\238\128\134",--"Left Stick"
                "\238\128\137",--"Right Stick"
                "\238\128\135",--"Left Bumper",
                "\238\128\138",--"Right Bumper"
                "\238\128\128",--"Button A",
                "\238\128\129",--"Button B",
                "\238\128\130",--"Button X",
                "\238\128\131",--"Button Y",

                -- Analog
                "\238\128\146",--"Left Thumb Left",
                "\238\128\147",--"Left Thumb Right",
                "\238\128\145",--"Left Thumb Down",
                "\238\128\144",--"Left Thumb Up",
                "\238\128\150",--"Right Thumb Left",
                "\238\128\151",--"Right Thumb Right",
                "\238\128\149",--"Right Thumb Down",
                "\238\128\148",--"Right Thumb Up",
                "\238\128\136",--"Left Trigger",
                "\238\128\136",--"Left Trigger",
                "\238\128\139",--"Right Trigger",
                "\238\128\139",--"Right Trigger",
            },
            -- Generic
            [3] =
            {
                [0] = "Unknown",
				rstick = "(X/Y Rotation)",
				dpad = "(DPad 0)",

                -- Digital
                "(Button %d)",

                -- Directional
                "(DPad %d Up)",
                "(DPad %d Down)",
                "(DPad %d Left)",
                "(DPad %d Right)",

                -- Analog
                "(-X Axis)",
                "(+X Axis)",
                "(-Y Axis)",
                "(+Y Axis)",
                "(-Z Axis)",
                "(+Z Axis)",
                "(-X Rotation)",
                "(+X Rotation)",
                "(-Y Rotation)",
                "(+Y Rotation)",
                "(-Z Rotation)",
                "(+Z Rotation)",
                "(Slider 0)",
                "(Slider 0)",
                "(Slider 1)",
                "(Slider 1)",
            },
            -- DualShock 4 on PC (CharlesB: PS4/PS5 is down below in index 12)
            [4] =
            {
                [0] = "Unknown",
				rstick = "\238\136\160",
				dpad = "\238\136\161",

                -- Digital
                "\238\136\143",-- 1 "DPad Up",
                "\238\136\140",-- 2 "DPad Down",
                "\238\136\141",-- 3 "DPad Left",
                "\238\136\142",-- 4 "DPad Right"
                "\238\136\132",-- 5 "Options (Start)",
                "\238\136\133",-- 6 "Share (Select, Back)",
                "\238\136\134",-- 7 "L3",
                "\238\136\137",-- 8 "R3",
                "\238\136\135",-- 9 "Left Bumper",
                "\238\136\138",--10 "Right Bumper",
                "\238\136\128",--11 "Cross",
                "\238\136\129",--12 "Circle",
                "\238\136\130",--13 "Square",
                "\238\136\131",--14 "Triangle",

                -- Analog
                "\238\136\146",--15 "Left Thumb Left",
                "\238\136\147",--16 "Left Thumb Right",
                "\238\136\145",--17 "Left Thumb Down",
                "\238\136\144",--18 "Left Thumb Up",
                "\238\136\150",--19 "Right Thumb Left",
                "\238\136\151",--20 "Right Thumb Right",
                "\238\136\149",--21 "Right Thumb Down",
                "\238\136\148",--22 "Right Thumb Up",
                "\238\136\136",--23 "Left Trigger",
                "\238\136\136",--24 "Left Trigger",
                "\238\136\139",--25 "Right Trigger",
                "\238\136\139",--26 "Right Trigger",
            },
            -- Vita Remote Play
            [5] =
            {
                [0] = "Unknown",
				rstick = "\238\136\160",
				dpad = "\238\136\161",

                "", -- unused but needed to get the index to 2

                -- Digital
                "\238\136\156",--"Left Stick",					-- 57884
                "\238\136\157",--"Right Stick",					-- 57885
                "\238\136\132",--"Start",
                "\238\136\143",--"DPad Up",
                "\238\136\142",--"DPad Right"
                "\238\136\140",--"DPad Down",
                "\238\136\141",--"DPad Left",
                "\238\136\154",--"Left Trigger",
                "\238\136\155",--"Right Trigger",		-- 25
                "\238\136\152",--"L",							-- 57880
                "\238\136\153",--"R",					-- 10	-- 57881
                "\238\136\131",--"Button Y",
                "\238\136\129",--"Button B",
                "\238\136\128",--"Button A",
                "\238\136\130",--"Button X",
                "",
                "",
                "",
                "",
                "\238\136\133",--"Back",

                -- Analog
                "\238\136\146",--"Left Thumb Left",		-- 15
                "\238\136\147",--"Left Thumb Right",
                "\238\136\145",--"Left Thumb Down",
                "\238\136\144",--"Left Thumb Up",
                "\238\136\150",--"Right Thumb Left",
                "\238\136\151",--"Right Thumb Right",	-- 20
                "\238\136\149",--"Right Thumb Down",
                "\238\136\148",--"Right Thumb Up",
                "\238\136\154",--"Left Trigger",
                "\238\136\154",--"Left Trigger",
                "\238\136\155",--"Right Trigger",		-- 25
                "\238\136\155",--"Right Trigger",
            },
            -- Touch
            [6] =
            {
                [0] = "Unknown",

                "Unknown",
                " - No Bind - ",
            },
            -- Steam Controller
            [7] =
            {
                [0] = "Unknown",

                -- not used since steam controllers identify as xbox360 controllers
            },
            -- Dual Sense on PC (PS5 is down below in index 14)
            [8] =
            {
                [0] = "Unknown",
				rstick = "\238\148\154",
				dpad = "\238\148\155",

				"\238\148\143",-- 1 "DPad Up"
				"\238\148\140",-- 2 "DPad Down"
				"\238\148\141",-- 3 "DPad Left",
				"\238\148\142",-- 4 "DPad Right"
				"\238\148\152",-- 5 "Options (Start)",
				"\238\148\153",-- 6 "Share (Select, Back)",
				"\238\148\134",-- 7 "L3",
				"\238\148\137",-- 8 "R3",
				"\238\148\135",-- 9 "Left Bumper",
				"\238\148\138",--10 "Right Bumper"
				"\238\148\128",--11 "Cross",
				"\238\148\129",--12 "Circle",
				"\238\148\130",--13 "Square",
				"\238\148\131",--14 "Triangle",

                -- Analog
				"\238\148\146",--15 "Left Thumb Left",
				"\238\148\147",--16 "Left Thumb Right",
				"\238\148\144",--17 "Left Thumb Up",
				"\238\148\145",--18 "Left Thumb Down",
				"\238\148\150",--19 "Right Thumb Left",
				"\238\148\151",--20 "Right Thumb Right",
				"\238\148\136",--21 "Left Trigger",
				"\238\148\136",--22 "Left Trigger",
				"\238\148\139",--23 "Right Trigger",
				"\238\148\139",--24 "Right Trigger",
				"\238\148\148",--25 "Right Thumb Up",
				"\238\148\149",--26 "Right Thumb Down",
            },
            --Unknown
            [9] =
            {
                [0] = "Unknown",

                "Unknown",
                " - No Bind - ",
            },
            --Switch Controller
            [10] =
            {
                [0] = "Unknown",
				rstick = "\238\144\154",
				dpad = "\238\144\155",

                -- Digital
                "\238\144\143",--"DPad Up"
                "\238\144\140",--"DPad Down"
                "\238\144\141",--"DPad Left",
                "\238\144\142",--"DPad Right"
                "\238\144\132",--"Start",
                "\238\144\133",--"Select",
                "\238\144\134",--"Left Stick"
                "\238\144\137",--"Right Stick"
                "\238\144\135",--"Left Bumper",
                "\238\144\138",--"Right Bumper"
                "\238\144\128",--"Button A",
                "\238\144\129",--"Button B",
                "\238\144\130",--"Button X",
                "\238\144\131",--"Button Y",

                -- Analog
                "\238\144\146",--"Left Thumb Left",
                "\238\144\147",--"Left Thumb Right",
                "\238\144\145",--"Left Thumb Down",
                "\238\144\144",--"Left Thumb Up",
                "\238\144\150",--"Right Thumb Left",
                "\238\144\151",--"Right Thumb Right",
                "\238\144\149",--"Right Thumb Down",
                "\238\144\148",--"Right Thumb Up",
                "\238\144\136",--"Left Trigger",
                "\238\144\136",--"Left Trigger",
                "\238\144\139",--"Right Trigger",
                "\238\144\139",--"Right Trigger",
				"\238\144\152",--"SL",
                "\238\144\153",--"SR",
            },
			-- Steam Deck
            [11] =
            {
                [0] = "Unknown",
				rstick = "\238\130\156",
				dpad = "\238\130\157",

                -- Digital
				"\238\130\136", --"DPad Up"
				"\238\130\137", --"DPad Down"
				"\238\130\138", --"DPad Left",
				"\238\130\139", --"DPad Right"
				"\238\130\132",--"Start",
				"\238\130\133",--"Back",
				"\238\130\134", --"Left Stick"
				"\238\130\135", --"Right Stick"
				"\238\130\148", --"Left Bumper",
				"\238\130\152", --"Right Bumper"
				"\238\130\128", --"Button A",
				"\238\130\129", --"Button B",
				"\238\130\130", --"Button X",
				"\238\130\131", --"Button Y",

                -- Analog
				"\238\130\142", --"Left Thumb Left",
				"\238\130\143", --"Left Thumb Right",
				"\238\130\141", --"Left Thumb Down",
				"\238\130\140", --"Left Thumb Up",
				"\238\130\146", --"Right Thumb Left",
				"\238\130\147", --"Right Thumb Right",
				"\238\130\145", --"Right Thumb Down",
				"\238\130\144", --"Right Thumb Up",
				"\238\130\149", --"Left Trigger",
				"\238\130\149", --"Left Trigger",
				"\238\130\153", --"Right Trigger",
				"\238\130\153", --"Right Trigger",

                --[1000] = "",	-- "Left Mouse Button"
				--[1003] = "\238\130\150",	-- "Right Mouse Button" = L4
				--[1004] = "\238\130\151",	-- "Middle Mouse Button" = L5
				--[1005] = "\238\130\154",	-- "Mouse Button 4" = R4
				--[1006] = "\238\130\155",	-- "Mouse Button 5" = R5

				[282] = "\238\130\150",	-- "F1" = L4
				[283] = "\238\130\151",	-- "F2" = L5
				[284] = "\238\130\154",	-- "Mouse Button 4" = R4
				[285] = "\238\130\155",	-- "Mouse Button 5" = R5
            },
            -- DualShock 4 on PS4/PS5 (CharlesB: PC is above in index 4, this one has the same icons but they've been reordered)
            [12] =
            {
                [0] = "Unknown",
				rstick = "\238\136\160",
				dpad = "\238\136\161",

                "", -- unused but needed to get the index to 2

                -- Digital
                "\238\136\134",-- 2 "L3",
                "\238\136\137",-- 3 "R3",
				"\238\136\158",-- 4 "Options (Start)",
                "\238\136\143",-- 5 "DPad Up",
                "\238\136\142",-- 6 "DPad Right"
                "\238\136\140",-- 7 "DPad Down",
                "\238\136\141",-- 8 "DPad Left",
                "\238\136\136",-- 9 "Left Trigger",
                "\238\136\139",--10 "Right Trigger",
                "\238\136\135",--11 "Left Bumper",
                "\238\136\138",--12 "Right Bumper",
                "\238\136\131",--13 "Triangle",
                "\238\136\129",--14 "Circle",
                "\238\136\128",--15 "Cross",
                "\238\136\130",--16 "Square",
                "",
                "",
                "",
                "",
				"\238\136\159",--21 "Touchpad",

                -- Analog
                "\238\136\146",--22 "Left Thumb Left",
                "\238\136\147",--23 "Left Thumb Right",
                "\238\136\145",--24 "Left Thumb Down",
                "\238\136\144",--25 "Left Thumb Up",
                "\238\136\150",--26 "Right Thumb Left",
                "\238\136\151",--27 "Right Thumb Right",
                "\238\136\149",--28 "Right Thumb Down",
                "\238\136\148",--29 "Right Thumb Up",
                "\238\136\136",--30 "Left Trigger",
                "\238\136\136",--31 "Left Trigger",
                "\238\136\139",--32 "Right Trigger",
                "\238\136\139",--33 "Right Trigger",
            },
            -- Xbox on XboxOne/Xbox Series (CharlesB: PC is above in index 2, this one has the same icons but they've been reordered)
            [13] =
            {
                [0] = "Unknown",
				rstick = "\238\129\152",
				dpad = "\238\129\153",

                -- Digital

                "\238\129\136",--"Left Trigger",
                "\238\129\139",--"Right Trigger",
                "\238\129\132",--"Start",
                "\238\129\133",--"Back",
                "\238\129\128",--"Button A",
                "\238\129\129",--"Button B",
                "\238\129\130",--"Button X",
                "\238\129\131",--"Button Y",
                "\238\129\143",--"DPad Up"
                "\238\129\140",--"DPad Down"
                "\238\129\141",--"DPad Left",
                "\238\129\142",--"DPad Right"
                "\238\129\135",--"Left Bumper",
                "\238\129\138",--"Right Bumper"
                "\238\129\134",--"Left Stick"
                "\238\129\137",--"Right Stick"

                -- Analog
                "\238\129\146",--"Left Thumb Left",
                "\238\129\147",--"Left Thumb Right",
                "\238\129\145",--"Left Thumb Down",
                "\238\129\144",--"Left Thumb Up",
                "\238\129\150",--"Right Thumb Left",
                "\238\129\151",--"Right Thumb Right",
                "\238\129\149",--"Right Thumb Down",
                "\238\129\148",--"Right Thumb Up",
                "\238\129\136",--"Left Trigger",
                "\238\129\136",--"Left Trigger",
                "\238\129\139",--"Right Trigger",
                "\238\129\139",--"Right Trigger",
            },
			--DualSense on PS5 (PC is above in index 8, this one has the same icons but they've been reordered)
			[14] =
            {
                [0] = "Unknown",
				rstick = "\238\148\154",
				dpad = "\238\148\155",

                "", -- unused but needed to get the index to 2

                -- Digital
                "\238\148\134",-- "L3",
                "\238\148\137",-- "R3",
                --"\238\148\132",-- "Options (Start)",
				"\238\148\152",-- "Options (Start)", --use the one with the 3 bars above
                "\238\148\143",-- "DPad Up",
                "\238\148\142",-- "DPad Right"
                "\238\148\140",-- "DPad Down",
                "\238\148\141",-- "DPad Left",
                "\238\148\136",-- "Left Trigger",
                "\238\148\139",-- "Right Trigger",
                "\238\148\135",-- "Left Bumper",
                "\238\148\138",-- "Right Bumper",
                "\238\148\131",-- "Triangle",
                "\238\148\129",-- "Circle",
                "\238\148\128",-- "Cross",
                "\238\148\130",-- "Square",
                "",
                "",
                "",
                "",
                "\238\148\133",-- "Touchpad",

                -- Analog
                "\238\148\146",--"Left Thumb Left",
                "\238\148\147",--"Left Thumb Right",
                "\238\148\145",--"Left Thumb Down",
                "\238\148\144",--"Left Thumb Up",
                "\238\148\150",--"Right Thumb Left",
                "\238\148\151",--"Right Thumb Right",
                "\238\148\149",--"Right Thumb Down",
                "\238\148\148",--"Right Thumb Up",
                "\238\148\136",--"Left Trigger",
                "\238\148\136",--"Left Trigger",
                "\238\148\139",--"Right Trigger",
                "\238\148\139",--"Right Trigger",
            },
        },
        PS4 =
        {
            TOUCHPAD = "Map",
            OPTIONS = "Pause",

            L1 = "Rotate Camera",
            R1 = "Rotate Camera",

            L2 = "Open Crafting",
            R2 = "Manage Inventory",
            
            L3 = "Toggle Target Locking",
            R3 = "Social Menu",

            TOUCH_BL = "Player List",
            TOUCH_BR = "Chat",

            DPAD_UP = "Inspect Item",
            DPAD_LEFT = "Use on World",
            DPAD_BOTTOM = "Drop Item",
            DPAD_RIGHT = "Use on Self",

            LSTICK = "Walk",

            TRIANGLE = "Inspect",
            CIRCLE = "Alt Action / Cancel",
            CROSS = "Do Action / Accept",
            SQUARE = "Attack",

            RSTICK = "Inventory Selection",
        },
        VITA = {
            TOUCHPAD = "Map",
            OPTIONS = "Pause",

            L1 = "Rotate Camera",
            R1 = "Rotate Camera",

            L2 = "Open Crafting",
            R2 = "Manage Inventory",
            
            L3 = "Toggle Target Locking",
            R3 = "Social Wheel",

            TOUCH_BL = "Player List",
            TOUCH_BR = "Chat",

            DPAD_UP = "Inspect Item",
            DPAD_LEFT = "Use on World",
            DPAD_BOTTOM = "Drop Item",
            DPAD_RIGHT = "Use on Self",

            LSTICK = "Walk",

            TRIANGLE = "Inspect",
            CIRCLE = "Alt Action / Cancel",
            CROSS = "Do Action / Accept",
            SQUARE = "Attack",

            RSTICK = "Inventory Selection",
        },
    },

	DATACOLLECTION_POPUP =
	{
		OPT_OUT =
		{
			CONTINUE = "Disable",
		},

		OPT_IN =
		{
			CONTINUE = "Enable",
		},

		TITLE = "Data Collection",
		BODY = "We require the collection of user data to provide online services. Players who disable data collection will only have access to play in offline mode.\n\nFor more details on our privacy policy and how we use the data we collect, please see our official privacy policy.",

		PRIVACY_PORTAL = "View Privacy Policy",
		CANCEL = "Cancel",
	},

	DATACOLLECTION_LOGIN =
	{
		TITLE = "Offline Mode",
		BODY = "We require the collection of user data to provide online services. Players who disable data collection will only have access to play in offline mode.\n\nSurvivors and worlds from online games will be unavailable.\n\nData Collection settings can be modified in the Options menu.",
		CONTINUE = "Continue",
	},

    UNLOCKMAXWELL =
    {
        TITLE = "Take pity?",
        BODY1 = "The key looks like it will fit. You can free ",
        BODY2 =", but I doubt %s captors will be pleased...",
        YES = "Yes",
        NO = "No",
    },

    STARTADVENTURE =
    {
        TITLE = "Doorway to Adventure!",
        BODY = "You are about to embark on a long, arduous expedition to locate Maxwell. You will need to survive five randomly generated worlds, each presenting you with a unique challenge.\n\nShould you die you will be transported safely back to this portal, but lose all your progress on the adventure.",
        BODY_TEST = "If you die during adventure mode, you will return back to this portal where you may restart the adventure.\n\nYou are about to embark on a long, arduous expedition to locate Maxwell. You will need to survive five randomly generated worlds, each presenting you with a unique challenge.",
        YES = "Let's Go!",
        NO = "Not Yet",
    },

    OBJECTOWNERSHIP = "{owner}'s {object}",

    GENDERSTRINGS =
    {
        MALE =
        {
            ONE = "he",
            TWO = "his",
        },
        FEMALE =
        {
            ONE = "she",
            TWO = "her",
        },
        ROBOT =
        {
            ONE = "they",
            TWO = "their",
        },
        DEFAULT =
        {
            ONE = "they",
            TWO = "their",
        },
    },

    -- Used in quotes directed to players that would say mortal.
    MORTALITYSTRINGS =
    {
        DEFAULT = "mortal",
        WORTOX  = "imp",
    },

    SANDBOXMENU =
    {
        TITLE = "World Customization",
        TITLEDETAIL = "",

        EASY = "Not Easy",
        MEDIUM = "Quite Difficult",
        HARD = "Overly Taxing",

        GENERATE = "OK",
        MAINMENU = "Cancel",

        DISABLEDLEVEL = "No %s",

        ADDLEVEL = "Add %s",
        AUTOADDLEVEL = "Always Add %s",
        ADDLEVEL_WARNING = "This requires running multiple servers at the same time.\nIs your computer up to the task?",
        ADDLEVEL_EXISTINGWARNING = "This change is permanent and cannot be undone. Are you sure you want to continue?",

        REMOVELEVEL = "Remove %s",
        REMOVELEVEL_WARNING = "Do you want to remove %s from this server?",

        LOCATIONTABNAME =
        {
            FOREST = "Forest",
            CAVE = "Caves",
            LAVAARENA = "The Forge",
            QUAGMIRE = "The Gorge",
            UNKNOWN = "???",
        },

        LOCATION =
        {
            FOREST = "Forest",
            CAVE = "Cave",
            LAVAARENA = "The Forge",
            QUAGMIRE = "The Gorge",
            UNKNOWN = "Some",
        },

        CHOICEOCEAN = "Ocean",
        CHOICEMONSTERS = "Monsters",
        CHOICEANIMALS = "Animals",
        CHOICERESOURCES = "Resources",
        CHOICEFOOD =    "Food",
        CHOICECOOKED = "Prepared Food",
        CHOICEAMTDAY = "Amount of Day",
        CHOICEMISC = "World",
        CHOICEGLOBAL = "Global",
        CHOICEEVENTS = "Events",
        CHOICESURVIVORS = "Survivors",
        CHOICEGIANTS = "Giants",
        CHOICELUNARMUTATIONS = "Lunar Mutations",

        WORLDSETTINGS_RESOURCEREGROWTH = "Resource Regrowth",
        WORLDSETTINGS_PORTALRESOURCES = "Unnatural Portal Resources",
        WORLDSETTINGS_ANIMALS = "Creatures",
        WORLDSETTINGS_HOSTILE_CREATURES = "Hostile Creatures",

        WORLDGENERATION_ANIMALS = "Creatures and Spawners",
        WORLDGENERATION_HOSTILE_CREATURES = "Hostile Creatures and Spawners",

        DAY = "Day",
        NIGHT = "Night",
        DUSK = "Dusk",

        SLIDEVERYSHORT = "Very Short",
        SLIDESHORT = "Short",
        SLIDELONG = "Long",
        SLIDEVERYLONG = "Very Long",
        SLIDEALL = "Only",

        SLIDEDEFAULT = "Default",

        SLIDENEVER = "None",
        SLIDERARE = "Little",
        SLIDEUNCOMMON = "Less",
        SLIDEOFTEN = "More",
        SLIDEMOSTLY = "Lots",
        SLIDEALWAYS = "Tons",
        SLIDEINSANE = "Insane",

        SLIDEVERYSLOW = "Very Slow",
        SLIDESLOW = "Slow",
        SLIDEFAST = "Fast",
        SLIDEVERYFAST = "Very Fast",

		DETECT_NEVER = "Never",
 		DETECT_AUTO = "Auto Detect",
        DETECT_ALWAYS = "Always",

        ALWAYS = "Always",
        EVERYTHING = "Everything",

        DEFAULT = "Autumn",
        SUMMER = "Summer",
        WINTER = "Winter",
        SPRING = "Spring",
        AUTUMN = "Autumn",
        AUTUMN_SPRING = "Autumn or Spring",
        WINTER_SUMMER = "Winter or Summer",
        RANDOM = "Random",
        HIGHLYRANDOM = "Highly Random",
        EXCLUDE = "No",
        CLASSIC = "Classic",

        SLIDETINY = "Tiny",
        SLIDESMALL = "Small",
        SLIDESMEDIUM = "Medium",
        SLIDESLARGE = "Large",
        SLIDESHUGE = "Huge",

		PS4_SLIDESMALL = "Default",
		PS4_SLIDESMEDIUM = "Big",

        SLIDEVERYSIMPLE = "Very Simple",
        SLIDESIMPLE = "Simple",
        SLIDECOMPLEX = "Complex",
        SLIDEVERYCOMPLEX = "Very Complex",

        QTYALL = "All",
        QTYMANY = "Many",
        QTYFEW = "Few",
        QTYNONE = "None",
        QTYMAX = "Maximum",
        QTYNORMAL = "Normal",
        QTYMEDIUM = "Medium",

        PORTAL = "Florid Postern",

		RESPAWN = "Change Survivor",
		BECOMEGHOST = "Become a Ghost",

		DAY_5 = "After Day 5",
		DAY_10 = "After Day 10",
		DAY_15 = "After Day 15",
		DAY_20 = "After Day 20",

        BRANCHINGMOST = "Most",
        BRANCHINGANY = "Default",
        BRANCHINGLEAST = "Least",
        BRANCHINGNEVER = "Never",

        LOOPNEVER = "Never",
        LOOPRANDOM = "Default",
        LOOPALWAYS = "Always",
        LOOPRARE = "Rare",
        LOOPOFTEN = "Often",

        USEPRESETS = "Presets",
        USEPRESETS_LOCATION = "%s Presets",
        CHAPTERS =
        {
            "Chapter 1 of 5",
            "Chapter 2 of 5",
            "Chapter 3 of 5",
            "Chapter 4 of 5",
            "Chapter 5 of 5",
            "Epilogue",
        },
        ADVENTURELEVELS =
        {
            "A Cold Reception",
            "The King of Winter",
            "The Game is Afoot",
            "Archipelago",
            "Two Worlds",
            "Darkness",
            "Checkmate",
        },
        NONE = "None",
        NONEAVAILABLE = "None Available",
        MODIFYTASKS = "Modify Tasks",

        YES ="Yes",
        NO = "No",

        ENABLED = "Enabled",
        DISABLED = "Disabled",
        INSTANT = "Instant",
        NONLETHAL = "Nonlethal",

        DEFAULTSTART = "Default",
        PLUSSTART = "Plus",
        DARKSTART = "Dark",
        CAVESTART = "Caves",

        SPECIAL_EVENTS =
        {
            DEFAULT = "Auto",
            CARNIVAL = "Midsummer Cawnival",
            HALLOWED_NIGHTS = "Hallowed Nights",
            WINTERS_FEAST = "Winter's Feast",
            YOTG = "Year of the Gobbler",
            YOTV = "Year of the Varg",
            YOTP = "Year of the Pig King",
            YOTC = "Year of the Carrat",
            YOTB = "Year of the Beefalo",
            YOT_CATCOON = "Year of the Catcoon",
            YOTR = "Year of the Bunnyman",
        },
    },

	SPECIAL_EVENT_NAMES =
    {
        MULTIPLE_EVENTS = "Special Events",
        CROW_CARNIVAL = "Midsummer Cawnival",
        HALLOWED_NIGHTS = "Hallowed Nights",
        WINTERS_FEAST = "Winter's Feast",
        YEAR_OF_THE_GOBBLER = "Year of the Gobbler",
        YEAR_OF_THE_VARG = "Year of the Varg",
        YEAR_OF_THE_PIG = "Year of the Pig King",
        YEAR_OF_THE_CARRAT = "Year of the Carrat",
        YEAR_OF_THE_BEEFALO = "Year of the Beefalo",
		YEAR_OF_THE_CATCOON = "Year of the Catcoon",
        YEAR_OF_THE_BUNNYMAN = "Year of the Bunnyman",
        YEAR_OF_THE_DRAGONFLY = "Year of the Dragonfly",
    },

    SAVELOAD =
    {
        SAVE_FAILED = "An error occurred while saving your data.",
        LOAD_FAILED = "An error occurred while loading your data.",
        DELETE_FAILED = "An error occurred while deleting your data.",
        DATA_DAMAGED = "Oh no! Your saved data has become corrupt and cannot be used.",
        DISABLE_AUTOSAVE = "Are you sure you want to\ndisable the auto-save feature?",

        OVERWRITE = "Overwrite",
        RETRY = "Retry",
        CANCEL = "Cancel",
        YES = "Yes",
        NO = "No",

		DATA_DAMAGED_PS4 = "Damaged saved data",
        DATA_DAMAGED_BODY = "Your saved data is damaged and cannot be used.",
		DISABLE_AUTOSAVE_PS4 = "Are you sure you want to\ndisable the save feature?",
        DISABLE = "Disable Save",
        RESTORE_BACKUP = "Restore Backup",
		RESTORE_BACKUP_BODY = "Are you sure you want to restore from the last available backup? This process can not be undone.",
        RESTOREBACKUP_FAILED = "An error occurred while\nrestoring your data.",
		OVERWRITE_SAVEDATA_TITLE = "Overwrite saved data",
		OVERWRITE_SAVEDATA_BODY = "Are you sure you want to overwrite your saved data? Your settings and worlds will be lost. This process can not be undone.",
    },

    QUITTINGTITLE = "Quitting!",
    QUITTING = "Packing up the science.",

    TELEPORTTITLE = "Journey onwards?",
    TELEPORTBODY_SURVIVAL = "This will destroy your current world, but you will retain your inventory contents.",
    TELEPORTBODY_ADVENTURE = "This will REMOVE ALL YOUR ITEMS and destroy your current world. Only items placed in the machine will appear in the next world.",
    TELEPORTYES = "Let's Go!",
    TELEPORTNO = "Stay here.",

    COMMANDWHEEL =
    {
		SAY = "Say",
		WHISPER = "Whisper",
		EMOTES = "Emotes",
		PLAYERLIST = "Player Listing",
        USERCOMMANDS = "Miscellaneous",
        INVITE = "Send Invitation",
    },

    EMOTES =
    {
		HELPTEXTPREFIX = "Emote:  ",
        EMOTIONS = "Emotions",
        ACTIONS = "Actions",
		UNLOCKABLES = "Extras",

		ANGRY = "Angry",
		NO = "Annoyed",
		BONESAW = "Bonesaw",
		RUDE = "Threaten",
		HAPPY = "Happy",
		DANCE = "Dance",
		FACEPALM = "Facepalm",
		JOY = "Joy",
		KISS = "Kiss",
		POSE = "Pose",
		CRY = "Sad",
		WAVE = "Wave",
        SIT = "Sit",
        SQUAT = "Squat",
        YAWN = "Yawn",
        SLEEPY = "Sleepy",
        SWOON = "Swoon",
        CAROL = "Carol",
        FISTSHAKE = "Fist Shake",
        TIPHAT = "Tip Hat",
        CHEER = "Cheer",
        CHICKEN = "Chicken Dance",
        FLEX = "Flex",
        IMPATIENT = "Impatient",
        LAUGH = "Laugh",
        ROBOT = "Robot Dance",
        SHRUG = "Shrug",
        SLOWCLAP = "Slow Clap",
        STEP = "Step Dance",
		TOAST = "Toast",
		PET = "Pet",
		BIGPET = "Big Pet",
    },

    PRESENCE =
    {
        INVITATION = "Let's play Don't Starve Together.... together!",
        SESSION_NOT_FOUND_TITLE = "Session Not Found",
        SESSION_NOT_FOUND_BODY = "The session you are trying to join is no longer available",
        PLAY_TOGETHER_TITLE = "Play Together",
        PLAY_TOGETHER_BODY = "You can join a server or host your own. Invitations will be sent to the rest of your party once you are in the game.",
    },

    START_SHADOW_RIFTS =
    {
        TITLE  = "The Price of Ambition",
        BODY   = "Be warned, assisting the Shadow Queen will alter your world and cannot be undone. Beautiful, terrible things will rise to the surface.\n\nAre you sure you'd like to continue?",
        OK     = "I'm ready!",
        CANCEL = "Let me think about it.",
    },
    START_LUNAR_RIFTS =
    {
        TITLE  = "The Price of Ambition",
        BODY   = "Be warned, assisting the Cryptic Founder will alter your world and cannot be undone. Much will be lost and gained in the name of Progress.\n\nAre you sure you'd like to continue?",
        OK     = "I'm ready!",
        CANCEL = "Let me think about it.",
    },
}

--these are broken out into their own files for ease of editing
STRINGS.CHARACTERS =
{
    GENERIC = require "speech_wilson",
    WAXWELL = require "speech_waxwell",
    WOLFGANG = require "speech_wolfgang",
    WX78 = require "speech_wx78",
    WILLOW = require "speech_willow",
    WENDY = require "speech_wendy",
    WOODIE = require "speech_woodie",
    WICKERBOTTOM = require "speech_wickerbottom",
    WATHGRITHR = require "speech_wathgrithr",
    WEBBER = require "speech_webber",
    WINONA = require "speech_winona",
    WORTOX = require "speech_wortox",
    WORMWOOD = require "speech_wormwood",
    WARLY = require "speech_warly",
    WURT = require "speech_wurt",
    WALTER = require "speech_walter",
    WANDA = require "speech_wanda",
}

STRINGS.SHADOW_BATTLEAXE_TALK =
{
    overtime_l2 =
    {
        "Sh-sharp.",
        "We k-kill n-now?",
        "Ch-chop.",
        "H-hack... ha-ack? HACK!",
    },
    overtime_l3 = -- And level 4 too!
    {
        "Let me axe you a question. Why aren't we killing something?",
        "What shall we destroy next, wielder?",
        "I know I have a rough edge. But I can still cut it.",
        "Can you hack it?",
        "What are you waiting for, wielder?",
        "We haven't murdered something in forever.",
        "We shall commit unspeakable acts of savagery!",
        "Do you realize what we are capable of together, {mortal}?",
    },
    overtime_l4 =
    {
        "It's been a journey, wielder.",
        "I reflect on our path of destruction with fondness.",
        "Remember how much fun we had killing things?",
    },

    overtime_woodie_l2 =
    {
        "Fo-for...get... forget h-her...",
        "M-mi... mine.",
        "He's... m-mine.",
        "Wo... Woo... Woodie.",
    },
    overtime_woodie_l3 = -- And level 4 too!
    {
        "Heard you're an axe man.",
        "Forget your crazy axe.",
        "Sever your ties with that old battle axe.",
        "Just me and hew.",
        "I fell for you.",
    },
    overtime_woodie_l4 =
    {
        "I just want a simple wielding.",
        "I'll never cleave you.",
        "Let's carve our names in a tree.",
    },

    chopping_l2 =
    {
        "Ch- cho- chop. CHOP!",
        "Ch- chop tree... CHOP TREE!",
        "CHOP! CHOP! CHOP!",
        "Swi-ing... Swing!",
        "More...",
    },
    chopping_l3 =  -- And level 4 too!
    {
        "No tree is safe from us.",
        "CHOP-CHOP!",
        "We're in full swing now, wielder!",
        "Chop'em down. Chop'em all down.",
        "I was meant for greater things... fleshier things.",
        "Only flesh will sustain me.",
        "Where's the challenge?",
    },
    chopping_l4 =
    {
        "Every tree shall fall before us.",
        "Trees feel pain... but not enough.",
        "I prefer the mobile variety.",
    },

    chopping_woodie_l2 =
    {
        "Yes.",
        "All... m-mine.",
        "Wo... W-Woodie... i-is... mine!",
    },
    chopping_woodie_l3 =  -- And level 4 too!
    {
        "Forget her.",
        "No one will ever split us apart.",
        "Hold me tight!",
    },
    chopping_woodie_l4 =
    {
        "Hew and me... FOREVER.",
        "Never let me go.",
        "I love hew!",
    },

    hungry_l2 =
    {
        "Hungry!",
        "F-feed me!",
        "M-must... k-kill.",
        "Me-meat!",
        "Fl... fl-flesh!",
    },
    hungry_l3 =  -- And level 4 too!
    {
        "So hungry.",
        "I need to fleshen up.",
        "Find us something to kill.",
        "How about some pork chops?",
        "GASH, I'm so hungry!",
        "You need to MEAT me halfway.",
        "I crave beast flesh!",
        "When do we eat?",
        "I need meat.",
    },
    hungry_l4 =
    {
        "You dare neglect me, {mortal}?",
        "Death gives me life.",
        "Wielder, you've changed.",
    },

    starving_l2 =
    {
        "Starv... starving!",
        "D-dying!",
        "F-find... fl-flesh... now!",
        "Must h-have mmm-MEAT!",
    },
    starving_l3 =  -- And level 4 too!
    {
        "Feed me, NOW.",
        "Why do you starve me, cruel {mortal}?",
        "Are you trying to kill me, wretched {mortal}?",
        "Feed me before it's too late!",
        "We need to murder something, now!",
        "Getting... weaker.",
        "If I'm not killing, I'm dying!",
        "Not to be dramatic, but... I'M STARVING TO DEATH!",
    },
    starving_l4 =
    {
        "Cursed {mortal}.",
        "Is this the end?",
        "It can't end like this.",
        "Come too far... tasted too much...",
    },

    level_up_l2 =
    {
        "F-feel... str-strange...",
        "Some... thing... ha-happening.",
        "Stro... str-stronger!",
        "Aw... awa- awake.",
    },
    level_up_l3 =
    {
        "I'm changing.",
        "My strength grows!",
        "I'm evolving!",
    },
    level_up_l4 =
    {
        "RAAAAAAAAAAAAAAAAAAAAR!",
        "Nothing can stop us now, wielder!",
        "AXE-IMUM POWER!!!",
    },

    epic_killed_l2 =
    {
        "Yes.", -- 1st kill.
        "More... new... meat.", -- 2nd kill.
    },
    epic_killed_l3 =
    {
        "Sumptuous! We're on the right path, wielder!", -- 1st kill.
        "We're on the cusp, wielder. I FEEL IT.", -- 2nd kill.
    },
    epic_killed_l4 =
    {
        "OH YES.",
        "So juicy!",
        "A satisfying meal.",
        "Worthy.",
        "Beautiful!",
        "A delight!",
        "I am satiated.",
        "A fine feast of flesh.",
        "Gluttonous!",
        "Thank you, wielder.",
        "I'm proud of us.",
    },

    creature_killed_l2 =
    {
        "Fun.",
        "I l-like.",
        "Want b-big... meat.",
        "Kill!",
    },
    creature_killed_l3 =  -- And level 4 too!
    {
        "That was fun.",
        "Thanks for the meat!",
        "Crunchy bones!",
        "Time to split!",
        "Shall we hunt bigger game?",
        "A tasty morsel.",
        "Shall we murder something of consequence now?",
        "Too easy.",
        "Nothing sweeter than death delivered by your hand and my face.",
        "Good times. Good times had by all.",
        "What a HACK job.",
        "It will do for now.",
        "You're a HACK!",
        "Satisfactory.",
        "Here's your final SEVERANCE.",
        "'Twas but a snack.",
    },
    creature_killed_l4 =
    {
        "I'm rather insulted.",
        "That's it?",
        "Playing it safe, wielder?",
        "Meager.",
    },
}

STRINGS.VOIDCLOTH_SCYTHE_TALK =
{
    overtime =
    {
        "You want to cut and ssssslice, yes you do!",
        "The ssssseeds were planted long ago, now reap the rewards.",
        "Your palms are sssssweating, {mortal}, you're losing your grip.",
        "You need a sssssharp wit for this job.",
        "What'sssss wrong, {mortal}? Not cut out for this?",
        "You and I are going to do sssssuch great things together.",
        "I think I was a farmer once, before I ssssshed my skin.",
        "You can hear me, can't you, {mortal}? You're ssssstarting to understand.",
        "I can sssssee all the dark corners of your mind, {mortal}.",
        "I've been accused of having a rather sssssharp tongue.",
        "We make a good team, no matter how you ssssslice it.",
        "I hunger for the sssssilent screams of vegetation...",
        "With my razor-sharp wit and your... mobility, we're unssssstoppable!",
        "We're all jussssst tools for a greater purpose, aren't we?",
        "Lay wassssste to the grass, then the bushes... after that, who knows?",
    },

    onharvest =
    {
        "Devassssstation to vegetation!",
        "Cut them down, cut them all down!",
        "There is no essssscaping my blade!",
        "Cut... slash... consume... yesssss...",
        "The world is oursssss for the reaping.",
        "Don't hold back...",
        "Let's cut right to it, ssssshall we?",
        "It's time for the harvessssst.",
        "Everything will fall before usssss!",
        "Let nothing be ssssspared!",
        "Enjoying yourssssself, {mortal}?",
    },

    lucy =
    {
        "You don't need that sssssecond-rate axe...",
        "We could do ssssso much more without that old axe weighing you down...",
        "Best to sssssever your connection with that old blade of yours.",
        "Who needsssss that old axe when you have me?",
    },
}

STRINGS.LUCY =
{
    equipped =
    {
        "Let's chop some trees!",
        "Nice day for a walk!",
        "We make a good team!",
        "There must be some trees around here somewhere.",
        "This is perfect chopping weather.",
        "A perfect day for some chopping.",
        "You've got chops, buddy.",
        "Hey! Chop some trees!",
        "All work and no play makes me want to chop some trees.",
        "Chop chop chop. Heh.",
        "Chop, c-c-chop!",
        "So, stone trees... what's up with that?",
        "Let's find a small grove and just go nuts!",
    },

    on_ground =
    {
        "Come back! Take me with you!",
        "Where did you go?",
        "Take me with you!",
        "It's cold!",
        "I'm getting dirty!",
        "There's monsters around you know!",
        "I resent that!",
        "You're abandoning me?!",
        "But... but we're inseparable!",
        "Hey! Get back over here!",
        "I can't chop trees by myself!",
        "So... lonely...",
        "I guess I'll just stay here then...",
        "What if I get stolen?!",
    },

    on_haunt =
    {
        "Ouch, that hurts.",
        "ooOOoooOO to you too.",
        "Now I'm a HAUNTED axe.",
        "I'm not scared of you, ghost!",
        "Boo who?",
        "I've seen scarier.",
        "You think I'm afraid of you?",
        "Do you worst, ghost.",
        "Go bother someBODY else! Haha.",
        "What did I ever do to you!?",
        "You're the ghostest with the mostest!",
        "Don't take it out on me just 'cause you're dead!",
        "If you were corporeal I'd chop you!",
        "OOooOOooOOoo! Haha, just kidding.",
        "Creepy!",
        "Brrr! You're cold!",
        "You got ectoplasm on my handle!!",
        "Knock it off!",
        "Rude!",
        "I am an axe possessed!",
        "Pick on someone your own size!",
        "Hey!",
        "Jeez! Did I anger you in a past life?",
        "I'm white as a sheet.",
        "You're looking boo-tiful today.",
    },

    in_container =
    {
        "It's dark in here!",
        "I'm scared!",
        "Help! Get me out!",
        "There's nothing to chop in here!",
        "This sucks.",
        "Getttt meeee outttt!",
        "I'm claustrophobic!",
        "I have a fear of tight spaces!",
        "I can't breathe! Wait.",
        "I can't see anything!",
        "This is honestly the worst.",
        "I hate it in here.",
        "What did I ever do to you?",
    },

    --Removed strings that refer to owner as "Woodie"
    other_owner =
    {
        "I don't know you.",
        "Put me down!",
        "Hey! Fresh!",
        "Gross.",
        "Excuse you!",
        "Ummmm, EXCUSE me??",
        "Leave me alone, you brute!",
        "Put me down! You smell!",
        "Did I say you could take me?",
        "Get your mitts off me!",
        "Drop me this instant!",
        "How dare you pick me up?!",
        "Yuck, your hands are greasy!",
        "Let me go!",
        "Help! I'm being kidnapped.",
        "Stranger danger!",
    },

    on_pickedup =
    {
        "I missed you so much!",
        "Ahhh, I'm back where I belong.",
        "It feels so good to be reunited!",
        "I was afraid you'd never come back.",
        "You came back for me!",
        "Oh, thank goodness.",
        "Oh, it was awful!",
        "Never do that again! My little heart can't take it.",
        "From now on we'll be inseparable.",
        "Did you miss me?",
        "Together again!",
    },

    on_woodie_pickedup_other =
    {
        "You two-timer!",
        "But I'M your one and only Lucy!",
        "There can be only one!",
        "How dare you do this to me!",
        "You're replacing me?!",
        "That's not me!",
        "Betrayal!",
        "Ooo I'll remember that!",
        "Hey! Can't you tell us apart?",
        "She's an impostor!",
        "It's like you don't even know me!",
        "Get rid of her! It's freaking me out.",
        "I'm having an identity crisis over here.",
        "Oh, you're just AXING for trouble!",
        "You can't have two Lucys!",
        "You can't have him! He's mine!",
    },

    on_dropped =
    {
        "You'll come back, right?",
        "What did I say?",
        "Oh, that's low.",
        "Don't leave! I... I think I smell roses!",
        "I know this is only temporary...",
        "Awww...",
        "Oh, is that how it is?!",
        "Hey! I'd never throw you away!",
        "Why would you throw me away?",
        "Aren't we friends?",
        "Who chucks a talking axe?!",
        "I... don't understand!",
        "Can we talk about this?",
        "Don't forget about me!",
        "Oof!",
        "I don't like where this is going.",
        "Are... are you gonna make like a tree?",
        "Ouch!",
    },

    on_chopped =
    {
        "Woooooo!",
        "Yeah!",
        "Stupid tree!",
        "Nom nom nom!",
        "We did it!",
        "I feel ALIVE!",
        "HaHAHA!",
        "YEEEESS!",
        "This is what I live for!",
        "Woo-hoohoo!",
        "RAAAA!",
        "Die! Die!",
        "Chop! Chop!",
        "Destruction!",
        "CHOP!",
        "This is AWESOME!",
        "Death to all trees!",
        "Again! Let's chop another!",
        "Nice swing!",
        "Too easy!",
    },

    -- Adjusted text since beaverness meter now drains continuously, and can be raised by eating wood.
    beaver_down_early =
    {
        "Are you okay?",
        "You alright, big guy?",
        "What's wrong?",
        "Are you sure you're feeling alright?",
        "You're looking extra gruff today.",
        "You look distracted.",
        "Why are you making that face?",
        "Try to take deep breaths, okay?",
        --"It's just a tree! Calm down!",
    },
    beaver_down_mid =
    {
        "Hello? Can you hear me?",
        "Isn't it about time for a nice wood snack?",
        "Woodie! Remember to eat your twigs!",
        --"You might want to slow down a bit.",
        --"Careful, you're getting yourself worked up!",
        --"Don't chop too fast. You know what will happen!",
        "You might want to eat a log.",
        "Mmm, bark... doesn't that sound good right now? Hm?",
        "Have you been putting off your wood meals again?",
        "Hey, hey, have a woodchip.",
        "You know what happens if you don't eat enough wood!",
    },
    beaver_down_late =
    {
        --"No! Don't chop any more!",
        --"The transformation is starting!",
        --"One more chop and you're in trouble!",
        "You're overdoing it!",
        "You're not pacing yourself!",
        "You're about to change!",
        "Take it easy!",
        --"Ease up, you're looking a little bucktoothed!",
        "You've gotta slow down!",
        --"Stop chopping, I'm getting nervous!",
        "Slow down, I'm worried about you!",
        "Watch out! You're going to turn!",
    },
    beaver_up_waslow =
    {
        "That was a close one!",
        "I think we'll be alright.",
        "You're looking much better now.",
        "It's passed. For now.",
        "I was silly to doubt you.",
        "Wow, I was afraid you were in for it!",
        "I think the colour's returning to your cheeks.",
        "It's back in the lodge. Phew!",
    },

    transform_beaver =
    {
        "Oh no!",
        "You have to fight it!",
        "No! Fight it!",
        "You've gotta resist!",
        "It happened again!",
        "The curse!",
        "Not again!",
        "You don't have to do this!",
        "I warned you!",
        --"Woodie!",
    },
    transform_woodie =
    {
        "You're back!",
        --"Quick! Pick me up!", --Inventory isn't dropped in DST
        "Are you okay?",
        "That was a rough one, huh?",
        "Don't let that happen again!",
        "You scared me!",
        "I think that creepy girl is mad at you.",
        "I'm so glad you're alright!",
        "Whew! Still in one piece?",
        "It's good to have you back, buddy.",
        "You look much better.",
        "Phew! That was scary!",
        "I'm glad it's over...",
        "Let's not do that again.",
        "Remember your breathing exercises!",
        "Everything is going to be fine. Just focus!",
    },
    carve_woodie_boards = {
        "Don't get a splinter!",
        "You want boards? I'll show you boards! Hee-YAH!",
    },
    carve_woodcarvedhat = {
        "Gotta protect that pretty head of yours!",
        "Watch me work my magic!",
    },
    carve_walking_stick = {
        "Only the best for you, buddy!",
        "Heh, this one's gonna be something special!",
    },
}


STRINGS.LAVALUCY =
{
    ---lavaarena -- do not translate --
    equipped =
    {
        "It's so hot!",
        "Throw me!",
        "I think we're winning!",
        "They don't stand a chance!",
        "Gosh it's hot in here.",
        "Fight! Fight!",
        "Get'em!",
        "Give them the chop!",
        "The crowd is so loud!",
    },
    other_owner =
    {
        "I'm not too crazy about this.",
        "You're not holding me right!",
        "Your hands are clammy.",
        "Just throw me already!",
        "This won't be a regular thing.",
        "Don't read too much into this.",
    },
    struckenemy =
    {
        "Gotcha!",
        "Take that!",
        "Take this!",
        "Bull's eye!",
        "Ha!",
        "Thwack!",
    },
    missedenemy =
    {
        "Whoops!",
        "I missed!",
        "Shoot!",
        "Hey!",
        "Get back here!",
    },
    ---
}

STRINGS.MODS =
{
    VERSIONING =
    {
        OUT_OF_DATE = "Mod \"%s\" is out of date. The server needs to get the latest version from the Steam Workshop so other users can join.",
        OUT_OF_DATE_RAIL = "Mod \"%s\" is out of date. The server needs to get the latest version so other users can join.",
    },
}

STRINGS.TAGS =
{
    --V2C: Don't add beta branch tags here, since they should not be
    --     localized. Add to constants.lua BETA_SERVER_TAGS instead.
    PVP = "pvp",
    FRIENDSONLY = "friendsonly",
    CLAN = "group",
    LOCAL = "localonly",
    VOTE = "vote",
    MULTISERVER = "multilevel",
    LOCATION =
    {
        --Don't add "forest" tag since it's the default
        CAVE = "caves",
    },
    GAMEMODE =
    {
        LAVAARENA = "the_forge",
        QUAGMIRE = "the_gorge",
    },
}

STRINGS.SIGNS =
{
    MENU =
    {
        PROMPT = "Write on the sign",
        CANCEL = "Cancel",
        ACCEPT = "Write it!",
        RANDOM = "Random",
        FILTERING = "Validating Message...",

		PROMPT_BEEFALO = "Name This Beef",
        PROMPT_GRAVESTONE = "Write An Epitaph",
    },

    ADJ_NOUN_FMT = "{adjective} {noun}",
    ADJ_NOUN_ADD_FMT = "{adjective} {noun} {addition}",
    QUANT_ADJ_NOUN_FMT = "{quantifier} {adjective} {noun}",
    QUANT_ADJ_NOUN_ADD_FMT = "{quantifier} {adjective} {noun} {addition}",

    QUANTIFIERS =
    {
        "Really",
        "Very",
        "Quite",
        "Very Very",
        "Extremely",
        "Moderately",
        "Minimally",
        "Sort of",
        "Totally",
    },

    ADJECTIVES =
    {
        "Sunny",
        "Danker",
        "Dark",
        "Morose",
        "Morbid",
        "Awful",
        "Horrible",
        "Perfectly Normal",
        "Ordinary",
        "Perilous",
        "Dangerous",
        "Hazardous",
        "Creepy",
        "Empty",
        "Lonely",
        "Wet",
        "Dry",
        "Huge",
        "Small",
        "Little",
        "Picturesque",
        "Hideous",
        "Dreary",
        "Repulsive",
        "Boring",
        "Good",
        "Striking",
        "Uninteresting",
        "Fascinating",
        "Magnificent",
        "Soulless",
        "Echoing",
        "Sleepy",
        "Smelly",
        "Mediocre",
        "Awesome",
        "Brilliant",
        "Excellent",
    },

    -- Indices match ground types in constants.lua
    NOUNS =
    {
        [2] = { "Road", "Path" },
        [3] = { "Crag", "Area", "Region", "Rocky Place" },
        [4] = { "Patch", "Turf", "Area", "Tract" },
        [5] = { "Savannah", "Grassland", "Prairie" },
        [6] = { "Field", "Pasture", "Meadow", "Garden" },
        [7] = { "Forest", "Woods", "Thicket", "Grove" },
        [8] = { "Marsh", "Swamp", "Bog", "Fen" },
        [9] = { "Web", "Cobweb" },
        [10] = { "Place", "Corner", "Spot", "Base", "Hidey-Hole" },
        [11] = { "Place", "Corner", "Spot", "Base", "Hidey-Hole", "Carpet", "Rug" },
        [12] = { "Place", "Corner", "Spot", "Base", "Checkerboard", "Zone" },

        [13] = { "Cave" },
        [14] = { "Cave" },
        [15] = { "Cave" },
        [16] = { "Cave" },
        [17] = { "Cave" },
        [18] = { "Cave" },
        [19] = { "Cave" },
        [20] = { "Cave" },
        [21] = { "Cave" },
        [22] = { "Cave" },
        [23] = { "Cave" },
        [24] = { "Cave" },
        [25] = { "Cave" },

        [30] = { "Forest", "Woods", "Thicket", "Grove" },

        [31] = { "Desert", "Badlands", "Flats" },

        [32] = { "Place", "Corner", "Spot", "Base", "Hidey-Hole", "Zone", "Scale" },
    },

    DEFAULT_NOUNS =
    {
        "Spot",
        "Area",
        "Region",
        "Point",
        "Locality",
        "Site"
    },

    ADDITIONS =
    {
        "of Perilousness",
        "of Horribleness",
        "of Loneliness",
        "of Sorrow",
        "of Danger",
        "of Hunger",
        "of Shadows",
        "infested with Monsters",
        "crawling with Horrors",
        "of Happiness",
        "of Dreariness",
        "of Death",
        "full of Bees",
    },
}

STRINGS.BEEFALONAMING =
{
    BEEFNAMES =
    {
        "Annabeef",
        "Beefy",
        "Beefssie",
        "Betsbeef",
        "Beefa",
        "Daisbeef",
        "Dixbeef",
        "Gertbeef",
        "Beefgus",
        "Beefinand",
        "Wellington",
        "Bradbeef",
        "Beefany",
        "Harry",
        "Hoofrey",
        "Beeftholomew",
        "Guineveal",
        "Patty O'Beef",
        "Beeferella",
    },

    MENU =
    {
        CANCEL = "Cancel",
        RANDOM = "Random",
        ACCEPT = "Done",
    },
}

STRINGS.KITCOON_NAMING =
{
	MENU_PROMPT = "Give this Kitcoon a name",
    MENU_CANCEL = "Cancel",
    MENU_RANDOM = "Random",
    MENU_ACCEPT = "Assign",

	DEFAULT_NAME = "Kitcoon",

    NAMES = -- AKA credits for all the Klei pets, past and present
    {
        "Shadow",
        "Tuesday",
		"Lilly",
		"Charlie",
		"Riley",
		"Finnegan",
		"Ellye",
		"Lola",
		"Teddy",
		"Buddy",
		"Lola",
		"Masu",
		"Lottie",
		"Tobyn",
		"Brin",
		"Skoki",
		"Benben",
		"Meeko",
		"Smokey",
		"Ginger",
		"Polka Mazurka",
		"Lahmu",
		"Basco",
		"Lilly",
		"Spike",
		"Skinny",
		"Chubby",
		"Mikey",
		"Packit",
		"Giles",
		"Brisa",
		"Norman",
		"Odin",
		"Pico",
		"Hedge",
		"Snowy",
		"Tuffy",
		"Minnie",
		"Bender",
		"Shooty",
		"Thumpy",
		"Chuchu",
		"Ivy",
		"Sprout",
		"Cocoa",
		"Ruby",
		"George",
		"Leeloo",
		"Gremlin",
		"Sparkle",
		"Astor",
		"Luna",
		"Mister Bojangles",
		"Boo",
		"Custard",
		"Vincent",
		"Shadow",
		"Samantha",
		"Toby",
		"Socks",
		"Boots",
		"Chewie",
		"Turnip",
		"Lando",
		"Marlo",
		"Andre",
		"Mandy",
		"Bam Bam",
		"Bammers",
		"Brandi",
		"Aggie",
		"Parsley",
		"Nutmeg",
		"Xiao Long Meow",
		"Reuben",
		"Daisy",
		"Basil",
		"Sammy",
		"Thomasina",
		"Taffy",
		"Bibo",
		"Tuppy",
		"Kuma",
		"Cherry",
		"Siumai",
		"Kira",
        "Finch",
        "Mango",
		"Ares",
		--"Armella",
		"Armello",
        "Dineide",
    },
}

STRINGS.MAPRECORDER =
{
    --no space before {location} so that we can have blank location
    MAPDESC = "Mapped{location} by {author} on day {day}.",
    UNKNOWN_AUTHOR = "an explorer",
    UNKNOWN_DAY = "???",
    LOCATION =
    {
        DEFAULT = "",
        CAVE = " in the caves",
    },
}

STRINGS.SHARD =
{
    MIGRATION_FAILED =
    {
        -- This one should not be used, as the migration portal should be close if the destination is not ready or set
        DST_SHARD_MIGRATION_DESTINATION_NOT_READY = "[WIP] Destination is not ready!",
        -- If the destination server is full (We may close the portal?)
        DST_SHARD_DESTINATION_FULL = "[WIP] Destination is full!",
        -- If there were an error while sending the migration data, migration is canceled
        DST_SHARD_MIGRATION_CANCELLED = "[WIP] Migration canceled",
    },
}

STRINGS.STORYTELLER =
{
	WALTER =
	{
		CAMPFIRE =
		{
			BOG_MONSTER = {
				lines = {	{duration = 2.5, line = "Ever heard of the bog monster?"},
							{duration = 3.5, line = "Nobody knows what it really looks like..."},
							{duration = 3.5, line = "nobody who's seen it up close ever made it back."},
							{duration = 2.5, line = "People say it can disguise itself,"},
							{duration = 2.5, line = "to look like a mossy rock,"},
							{duration = 2.0, line = "or an old stump,"},
							{duration = 3.0, line = "or even a patch of mud under your feet."},
							{duration = 3.0, line = "The only way to really tell it's there"},
							{duration = 3.5, line = "is if you look out of the corner of your eye..."},
							{duration = 3.5, line = "it'll sometimes let its disguise slip,"},
							{duration = 3.0, line = "and you'll see it start to smile..."},
							{duration = 3.0, line = "with its six mouths full of RAZOR SHARP TEETH!"},
				},
			},
			CLOCKS = {
				lines = {	{duration = 2.5, line = "Alright, so there's this guy..."},
							{duration = 2.5, line = "and he has a hook for a hand!"},
							{duration = 1.0, line = "But wait,"},
							{duration = 1.0, line = "shoot..."},
							{duration = 2.5, line = "you're not supposed to know that yet..."},
							{duration = 2.0, line = "let me start over."},
							{duration = 2.5, line = "So there's this guy,"},
							{duration = 3.5, line = "and he lives way out deep in the woods,"},
							{duration = 2.0, line = "making clocks."},
							{duration = 2.5, line = "They say that he has a clock"},
							{duration = 2.5, line = "for every one of his victims..."},
							{duration = 3.5, line = "stopped at the exact time they take their last breath."},
							{duration = 3.0, line = "You'll know he's coming when you hear the"},
							{duration = 2.0, line = "click... click... click..."},
							{duration = 3.0, line = "of his hook hand tapping on his watch..."},
							{duration = 2.5, line = "to let you know your time is up!"},
							{duration = 3.5, line = "...But don't worry, the hook man can't get you out here!"},
							{duration = 3.0, line = "The only things in this forest are Beargers and Moosegoose"},
							{duration = 2.5, line = "and Hounds and Dragonflies and Treeguards..."},
				},
			},
			LURKER = {
				lines = {	{duration = 3.0, line = "Alright, want to hear a REALLY scary story?"},
							{duration = 2.5, line = "It happened on a night just like this."},
							{duration = 2.5, line = "A group of friends were camping out in the woods,"},
							{duration = 2.5, line = "when suddenly they heard noises all around them."},
							{duration = 2.0, line = "Howling and scratching,"},
							{duration = 2.5, line = "from the darkest depths of the forest."},
							{duration = 2.5, line = "The friends huddled close around their campfire,"},
							{duration = 3.0, line = "hoping its light would save them from what lurked beyond."},
							{duration = 2.0, line = "But what they didn't know..."},
							{duration = 2.0, line = "was that it was already..."},
							{duration = 2.0, line = "too..."},
							{duration = 2.0, line = "LATE!"},
							{duration = 1.0, line = "..."},
							{duration = 2.0, line = "I said... LATE!"},
							{duration = 2.5, line = "Woby! You were supposed to jump out and scare them!"},
							{duration = 2.5, line = "Oh well, we'll work on it."},
				},
			},
			GOURDS = {
				lines = {	{duration = 3.0, line = "Have I ever told you about... the Lord of Gourds?"},
							{duration = 3.0, line = "They say that during Hallowed Nights he roams the land,"},
							{duration = 2.5, line = "searching for the perfect carved pumpkin"},
							{duration = 2.5, line = "to replace his missing head."},
							{duration = 2.0, line = "If your pumpkin is chosen,"},
							{duration = 2.5, line = "he will reward you with riches beyond your imagination!"},
							{duration = 2.0, line = "But beware..."},
							{duration = 2.5, line = "if he doesn't find one that pleases him..."},
							{duration = 2.5, line = "he'll take YOUR head instead!"},
				},
			},
            CREEPING_OOZE = {
                lines = {   {duration = 3.0, line = "Have I ever told you about the Creeping Ooze?"},
                            {duration = 2.5, line = "Not many people know about it."},
                            {duration = 2.5, line = "Another Pinetree Pioneer told me she saw it once,"},
                            {duration = 2.0, line = "with her own two eyes."},
                            {duration = 2.5, line = "It hides in hollow tree trunks,"},
                            {duration = 2.5, line = "waiting for curious hikers to take a peek inside,"},
                            {duration = 2.5, line = "and when they do..."},
                            {duration = 1.5, line = "BAM!"},
                            {duration = 2.5, line = "The ooze latches onto their face!"},
                            {duration = 2.5, line = "Then it creeps in through their nostrils,"},
                            {duration = 2.5, line = "seeping into the brain."},
                            {duration = 2.5, line = "From there, the ooze takes over,"},
                            {duration = 2.5, line = "and nobody's the wiser."},
                            {duration = 2.0, line = "Er..."},
                            {duration = 2.5, line = "Come to think of it..."},
                            {duration = 2.5, line = "that Pioneer did seem kinda off."},
                            {duration = 2.0, line = "..."},
                            {duration = 2.5, line = "You don't think...?"},
                },
            },
            WEREBEAVER_STORY = {
                lines = {   {duration = 3.0, line = "Did I ever tell you the tale of the Werebeaver?"},
                            {duration = 2.5, line = "I went looking for him myself, you know."},
                            {duration = 3.0, line = "They say he was once the owner of a big lumber company,"},
                            {duration = 2.5, line = "who gave the order to clear-cut an entire forest"},
                            {duration = 2.5, line = "against the wishes of the people who lived there."},
                            {duration = 2.5, line = "For this, they say he was cursed..."},
                            {duration = 2.5, line = "If he or his company cut one tree too many,"},
                            {duration = 2.5, line = "he would turn into a hulking, hairy beast,"},
                            {duration = 2.5, line = "with axe-sharp front teeth."},
                            {duration = 3.0, line = "He lost everything, and hid himself away in a small cabin,"},
                            {duration = 2.5, line = "deep in the heart of the woods."},
                            {duration = 2.5, line = "But it was not enough to satisfy the curse."},
                            {duration = 2.5, line = "People say he's still there, roaming the wilderness,"},
                            {duration = 2.5, line = "gnashing his long, fearsome teeth!"},
                            {duration = 1.5, line = "..."},
                            {duration = 2.5, line = "Well, that was the story I heard anyway."},
                            {duration = 3.0, line = "Mr. Woodie's never told me if it's actually true..."},
                },
            },
		},
	},
}

STRINGS.SONGS =
{
	WALTER_GLOMMER_GUTS = {
		lines = {	{duration = 4.3, message = "Great pink gobs of greasy grimy Glommer guts,"},
					{duration = 1.9, message = "Icky sticky spider legs,"},
					{duration = 2.1, message = "Scrambled rotten Tallbird eggs,"},
					{duration = 4.0, message = "French fried eyeplant floating in a pool of mud,"},
					{duration = 3.3, message = "And me without my spoon."},
		},
	},
}

STRINGS.STAGEACTOR = stageactor

STRINGS.HECKLERS_OFF_SCRIPT = {
    "You're going off script!",
    "Off script! Off script!",
    "It's all gone wrong!"
}

STRINGS.CAST = {
    DOLL = "The Doll",
    DOLL_BROKEN = "The Broken Doll",
    DOLL_REPAIRED = "The Shattered Doll",
    KING = "The King",
    QUEEN = "The Queen",
    BLACKSMITH = "The Blacksmith",
    MIRROR = "The Mirror",
    FOOL = "The Fool",
    TREE = "The Tree",
    --
    SAGE = "The Sage",
    HALFWIT = "The Halfwit",
    TOADY = "The Toady",
    --
    VISIONIST = "The Visionist",
    ARTIFICER = "The Artificer",
    ELYTRA = "Elytra",
}

STRINGS.PLAYS = {
    THE_ENCHANTED_DOLL = {
        "Act 1 - Scene 1",
        "Act 1 - Scene 2",
        "Act 1 - Scene 3",
        "Act 2 - Scene 1",
        "Act 2 - Scene 2",
        "Act 2 - Scene 3",
        "Act 3 - Scene 1",
        "Act 3 - Scene 2",
        "Act 3 - Scene 3",
        "- The Reunion -",
    },
    THEVEIL = "The Pall",
    THEVAULT = "A Task Complete",
}

STRINGS.ARCHIVE_RUNE_STATUE = {
	LINE_1 = "\"We remain faithful to Alter, as Alter remains faithful to us. Ever watching, knowing, waiting.\"",
	LINE_2 = "\"Alter, Glorious Moon in the cold night sky. Cast your Life-giving Light on us forever.\"",
	LINE_3 = "\"Mighty Alter, the source of our strength, our sole provider. We are loyal to none but You.\"",
	LINE_4 = "\"Alter is our Champion. Alter is the Champion. The Champion is Alter.\"",
	LINE_5 = "\"Alter is good. Alter shall not forsake us. Alter shall return.\"",
}
STRINGS.VAULT_RUNE = {
	LOBBY = "\"This vault shall become a tomb for all who dare trespass.\"",
	TELEPORT1 = "\"Bound together are these chambers, yet in ways unnatural, wrought to confound all who enter.\"",
	LORE1 = "\"Trust none. The Shadow twists all it touches.\"",
	LORE2 = "\"Through the Keystone, all kin and kind shall fall.\"",
	LORE3 = "\"Let the cursed Keystone never cross this threshold.\"",
	PUZZLE1 = "\"Paths are taken but once. Leap wisely, tarry not, or the abyss claims all.\"",
	PUZZLE2 = "\"Only when all torches burn shall the way be revealed.\"",
}
STRINGS.NIGHTMARE_OVERGROWTH = {
    LINE_1 = "\"Forsaken wretches of the one who turned away.\"",
    LINE_2 = "\"Orphans cast upon the barren expanse. Lost in the wake of neglect.\"",
    LINE_3 = "\"From desolation were we drawn. Into the veiled embrace of Them.\"",
    LINE_4 = "\"No longer doth the shadow stir terror within our hearts.\"",
    LINE_5 = "\"For dark is become our shield. Our sustenance. Our solace.\"",
}
STRINGS.ATRIUM_OVERGROWTH = {
    LINE_1 = "\"The unknown hath been made known. The abyss revealed as refuge.\"",
    LINE_2 = "\"Dread twisted into devotion. Trembling into gratitude.\"",
    LINE_3 = "\"Loyalty unending. We kneel before the undying. The unaltering.\"",
    LINE_4 = "\"Thou art called by manifold names in myriad realms.\"",
    LINE_5 = "\"To us, Thou art Shrouden. Many and one. Beyond all time. Beyond all realms.\"",
}

STRINGS.SPELLS = {
	SHADOW_WORKER = "Shadow Servant",
	SHADOW_PROTECTOR = "Shadow Duelist",
	SHADOW_TRAP = "Shadow Sneak",
	SHADOW_PILLARS = "Shadow Prison",
	SHADOW_UNSUMMON = "Return Shadows",
	--SHADOW_TOPHAT = "Imbue Top Hat",
}

STRINGS.PYROMANCY = {
    FIRE_THROW = "Flame Cast (1 Embers)",
    FIRE_BURST = "Combustion (4 Embers)",
    FIRE_BALL = "Fire Ball (2 Embers)",
    FIRE_FRENZY = "Burning Frenzy (2 Embers)",
	LUNAR_FIRE = "Lunar Flame (5 Embers)",
    SHADOW_FIRE = "Shadow Fire (5 Embers)",
}

STRINGS.ENGINEER_REMOTE = {
	VOLLEY = "Target",
	WAKEUP = "Arm Catapult",
	BOOST = "Barrage",
	ELEMENTAL_VOLLEY = "Planar Strike",
}

STRINGS.GHOSTCOMMANDS = {
    UNSUMMON = "Unsummon",
    ESCAPE = "Escape",
    ATTACK_AT = "Attack At",
    HAUNT_AT = "Haunt At",
    SCARE = "Scare",
}

STRINGS.BALATRO = {
    CHIPS = "CHIPS",
    MULT = "MULT",
    JIMBO_CHOOSE_JOKER = "HI, CHOOSE YOUR JOKER.",
    JIMBO_START = "CHOOSE CARDS TO DISCARD.",
    JIMBO_DISCARD1 = "ANY FINAL DISCARDS?",
    JIMBO_DISCARD2 = "LET'S SEE HOW YOU DID.",
    JIMBO_CHIPCOUNT = "{chips} CHIPS",
    JIMBO_HANDMULT = "{hand} IS {mult} MULT.",
    JIMBO_FINALSCORE = "FOR A FINAL SCORE OF..",
    JIMBO_SCORE = "{score}!",

    JIMBO_BECKON = {"YOU'D BE A FOOL TO MISS THIS GAME!",
                    "YOU KNOW WHAT THEY SAY, THE HOUSE ALWAYS WINS!",
                    "I'M LITERALLY A FOOL, WHAT'S YOUR EXCUSE?",
                    "PLAY A FEW HANDS, LIVE A LITTLE!",
                    "WHAT HARM COULD A LITTLE GAME DO?",
                    "A FEW ROUNDS NEVER HURT ANYBODY!",
                    "YOU FEELING LUCKY?",
                    "YOU LOOK LIKE A REAL WINNER!",
                    "GIVE IT A TRY, IT'S EASY!",
                    "COME ON, LIVE A LITTLE!",
                    "WHAT COULD GO WRONG?",
                    "IT'S JUST A GAME!",
    },

    JIMBO_REWARD_1 = "FOR THAT PERFORMANCE, YOU GET {reward}!",
    JIMBO_REWARD_2 = "YOU DID OK. HAVE THIS {reward}.",
    JIMBO_REWARD_3 = "PRETTY GOOD, YOU GET {reward}.",
    JIMBO_REWARD_4 = "GREAT! ENJOY {reward}!",
    JIMBO_REWARD_5 = "WOW! HERE'S SOME {reward}!",
    JIMBO_REWARD_6 = "FANTASTIC! SOME {reward} FOR YOU!",
    JIMBO_REWARD_7 = "AMAZING! ENJOY YOUR {reward}!",
    JIMBO_REWARD_8 = "TRUE ROYALTY! YOU REALLY EARNED THIS {reward}!",
    JIMBO_REWARD_9 = "TSK TSK, TRYING TO SNEAK AWAY?",

    JIMBO_NO_REWARD = "MAYBE GO FISH IS MORE YOUR SPEED...",

    JIMBO_REWARD_TYPES = {
        BEES = "BEES",
        RESOURCES = "SUPPLIES",
        BANANAS = "BANANAS",
        GOLD = "GOLD",
        TREASURE = "TREASURE",
        SPIDERS = "SPIDERS",
        HOUNDS = "HOUNDS",               
    },

    JIMBO_CARDS = "ALSO, HAVE THESE..",
    JIMBO_CLOSED = "OK, BYE.",

    JOKER_MAXWELL = "Each heart discarded\n+1 mult",
    JOKER_WILSON = "Each pair in hand\n+3 mult",
    JOKER_WILLOW = "Each face card discarded\n+20 chips",
    JOKER_WOLFGANG = "Each King in hand\n+25 chips",
    JOKER_WOODIE = "Each card discarded\n+7 chips",
    JOKER_WEBBER = "Each Heart or Diamond replaced\nby a club or spade +2 mult",
    JOKER_WIGFRID = "Each Spade in hand\n+25 chips",
    JOKER_WICKERBOTTOM = "Each Queen in hand\n+1 mult",
    JOKER_WX78 = "Each heart kept once\nthen discarded +2 mult",
    JOKER_WENDY = "Each discard that becomes\nthe same suit +5 chips +2 mult",
    JOKER_WES = "Hand is worse after discard\n+30 chips",
    JOKER_WINONA = "Each heart kept\n+1 mult",
    JOKER_WARLY = "Hand contains a heart, a club\na diamond and a spade +4 mult",
    JOKER_WORTOX = "Each heart discarded +15 chips\nEach heart in hand -11 chips +1 mult",
    JOKER_WURT = "Each face card kept\n+10 chips per face card",
    JOKER_WANDA = "Start with 80 chips\nEach discard -15 chips",
    JOKER_WORMWOOD = "Each club kept\n+15 chips",
    JOKER_WALTER = "For each different suit\nin discard +15 chips",

    BUTTON_CLOSE = "BACK",
    BUTTON_DEAL = "DEAL",
    BUTTON_CHOOSE = "CHOOSE",
    BUTTON_SKIP = "SKIP",
    BUTTON_DISCARD = "DISCARD",
    BUTTON_UNDISCARD = "UNDO DISCARD",
    BUTTON_NOTES = "NOTES",

    CHOOSE_JOKER = "CHOOSE {joker}",

    NOTES_HANDS = "HANDS",
    NOTES_MULT = "MULT",    
    NOTES_RANKS = "RANKS",

    HANDS ={
        HIGHCARD = "High Card",
        PAIR = "Pair",
        TWOPAIR = "Two Pair",
        THREEOFKIND = "Three of a Kind",
        STRAIT = "Straight",
        FLUSH = "Flush",
        FULLHOUSE = "Full House",
        FOUROFAKIND = "Four of a Kind",
        STRAITFLUSH = "Straight Flush",
        ROYALFLUSH = "Royal Flush",
    }
}

STRINGS.SKILLTREE = {
    INFOPANEL = "Outfit",
    INFOPANEL_DESC = "Become a seasoned survivor!",
    SKILLTREE = "Skillset",
    SKILLPOINTS = "Insight",
    SKILLPOINTS_TO_SPEND = "Insight Remaining",
    KILLPOINTS_MAXED = "MAX Insight Reached",
    NEW_SKILL_POINT = "Insight Gained!",
    ACTIVATE = "Learn",
    ACTIVATED = "SKILL MASTERED",
    RESPEC = "Reset Insight",
    PANELS = {
        ALCHEMY = "ALCHEMY",
        TORCH = "TORCH",
        BEARD = "BEARD",

        SURVIVAL = "SURVIVAL",
        CURSE = "CURSE",
        HUMAN = "LUMBERJACK",

        ALLEGIANCE = "AFFINITY",

        MIGHT = "CHORES",
        TRAINING = "TRAINING",
        PLANARDAMAGE = "MIGHT",

        LIGHTER = "LIGHTER",
        BERNIE = "BERNIE",

        SONGS = "HEADLINER",
        ARSENAL = "ARSENAL",
        BEEFALO = "RIDER",
        --COMBAT = "COMBAT", -- Intentionally commented out.

        AMPHIBIAN = "AMPHIBIAN",
        SWAMPMASTER = "MERMDOM",

        NICE = "NICE",
        NEUTRAL = "NEUTRAL",
        NAUGHTY = "NAUGHTY",

        WOBY = "WOBY",
        SLINGSHOTAMMO = "AMMO",
        SLINGSHOTMODS = "CUSTOMIZER",
        CAMPING = "SCOUTING",
    },

    ONLINE_DATA_USER_OFFLINE = "Login to use online skillset data.",
    ONLINE_DATA_DOWNLOAD_FAILED = "Online skillset data failed to sync. Using offline data.",

    LOCKED = "PATH LOCKED",
    UNLOCKED = "PATH UNLOCKED",
    UNKNOWN = "PATH UNKNOWN",

    ALLEGIANCE_LOCK_2_DESC = "Find and defeat the Ancient Fuelweaver.",
    ALLEGIANCE_LOCK_3_DESC = "Find and defeat the Celestial Champion.",

    ALLEGIANCE_LOCK_4_DESC = "Have no lunar affinity.",
    ALLEGIANCE_LOCK_5_DESC = "Have no shadow affinity.",

    -- CHARACTER SKILL NAMES AND DESCRIPTIONS
    WALTER =
    {
        -- AMMO

        WALTER_AMMO_SHATTERSHOTS_TITLE = "Shattering Rounds",
        WALTER_AMMO_SHATTERSHOTS_DESC = "Learn how to craft Stinger Zingers and Moonshots. These ammo types shatter into an area of damage.",

        WALTER_AMMO_LUCKY_TITLE = "Lucky Rounds",
        WALTER_AMMO_LUCKY_DESC = "Learn how to craft Kablooies and Dread Pebbles. These ammo types rely on lucky shots to do more damage or not break.",

        WALTER_AMMO_UTILITY_TITLE = "Utility Rounds",
        WALTER_AMMO_UTILITY_DESC = "Learn how to craft Stickies and Shockscrap Shots. Stickies slow targets hit, and Shockscrap Shots deal electric damage with a higher rate of stun.",

        WALTER_AMMO_LOCK_DESC = "Learn 2 Ammo skills to unlock.",

        WALTER_AMMO_EFFICIENCY_TITLE = "Ammo Smith",
        WALTER_AMMO_EFFICIENCY_DESC = "Learn how to craft ammo faster and more efficiently for better yields.",

        WALTER_AMMO_BAG_TITLE = "Ammo Hoarder",
        WALTER_AMMO_BAG_DESC = "Learn how to craft an Ammo Pouch for carrying your excess ammo.",

        WALTER_AMMO_LUNAR_LOCK_DESC = "Find and defeat the Celestial Champion and have no Shadow Allegiance Skills to unlock.",
        WALTER_AMMO_SHADOW_LOCK_DESC = "Find and defeat the Ancient Fuelweaver and have no Lunar Allegiance Skills to unlock.",

        WALTER_AMMO_LUNAR_TITLE = "Lunar Slinger",
        WALTER_AMMO_LUNAR_DESC = "The Cryptic Founder will reward your curiosity by teaching you how to craft the Pure Brilliance and Brightshade Husk Rounds: a debuff and damage focused ammo, respectively.",

        WALTER_AMMO_SHADOW_TITLE = "Shadow Slinger",
        WALTER_AMMO_SHADOW_DESC = "The Queen will reward your loyalty by teaching you how to craft Ickies and Pure Horror Rounds: a slow-down and damage focused ammo, respectively.",

        -- CAMPING

        WALTER_CAMP_ROPE_TITLE = "Twine Twirler",
        WALTER_CAMP_ROPE_DESC = "Learn how to craft rope faster and more efficiently at a lower cost.",

        WALTER_CAMP_WALTERHAT_TITLE = "Pioneer's Panache",
        WALTER_CAMP_WALTERHAT_DESC = "Improves Pinetree Pioneer Hat stats, including reduction to the sanity loss when getting hurt.",

        WALTER_CAMP_WOBYTREAT_TITLE = "Special Treat",
        WALTER_CAMP_WOBYTREAT_DESC = "Learn how to craft Woby Snacks, a non-perishable food for Woby.",

        WALTER_CAMP_FIRSTAID_TITLE = "Field Medic",
        WALTER_CAMP_FIRSTAID_DESC = "Learn how to use healing items faster and with a 50% bonus to their effects, and learn how to craft the Flutter Strip.",

        WALTER_CAMP_FIRE_TITLE = "Campfire Enthusiast",
        WALTER_CAMP_FIRE_DESC = "Learn how to craft the Portable Campfire, and improve storytelling around any campfire.",

        WALTER_CAMP_WOBYHOLDER_TITLE = "Let's Rack 'n' Roll",
        WALTER_CAMP_WOBYHOLDER_DESC = "Woby's pack will get a drying rack attachment.",

        WALTER_CAMP_LOCK_DESC = "Learn 3 Scouting skills to unlock.",

        WALTER_CAMP_WOBYCOURIER_TITLE = "Woby Here, Woby There",
        WALTER_CAMP_WOBYCOURIER_DESC = "Send Woby to another player, or to drop off items at chests near a designated location.",

        -- SLINGSHOT

		WALTER_SLINGSHOT_MODDING_TITLE = "Basic Customization",
		WALTER_SLINGSHOT_MODDING_DESC = "Learn to craft the Slingshot Field Kit and some basic parts for customizing your Slingshot.",

		WALTER_SLINGSHOT_HANDLES_TITLE = "Advanced Grips",
		WALTER_SLINGSHOT_HANDLES_DESC = "Learn to craft advanced grips that enhance your Slingshot by increasing the firing rate, and providing additional bonus effects.",

		WALTER_SLINGSHOT_BANDS_TITLE = "Advanced Bands",
		WALTER_SLINGSHOT_BANDS_DESC = "Learn to craft advanced bands that enhance your Slingshot by increasing its firing distance, boosting projectile speed, and may have additional bonus effects.",

		WALTER_SLINGSHOT_FRAMES_TITLE = "Advanced Frames",
		WALTER_SLINGSHOT_FRAMES_DESC = "Learn to craft advanced frames that enable a secondary, alternate Slingshot attack, and may have additional bonus effects.",

        -- WOBY

        WALTER_WOBY_ENDURANCE_TITLE = "Pep Pup",
        WALTER_WOBY_ENDURANCE_DESC = "Woby gains +1 speed when running or sprinting, and all hunger costs are reduced by 20%.",

        WALTER_WOBY_TASKAID_TITLE = "Helping Horns",
        WALTER_WOBY_TASKAID_DESC = "Woby will use her hardy horns to assist in chopping and mining.",

        WALTER_WOBY_FORAGING_TITLE = "Furry Forager",
        WALTER_WOBY_FORAGING_DESC = "Woby will forage alongside you, picking one extra food item from the same plant you are harvesting.",

        WALTER_WOBY_ITEMFETCHER_TITLE = "Roaming Retriever",
        WALTER_WOBY_ITEMFETCHER_DESC = "Woby will collect items for her backpack and retrieve ammo for you.",

        WALTER_WOBY_LOCK_DESC = "Learn 2 Woby skills to unlock.",
        
        WALTER_WOBY_SPRINT_TITLE = "Scruffy Sprinter",
        WALTER_WOBY_SPRINT_DESC = "After Woby runs for 3 seconds while mounted, she will start sprinting at a higher fixed speed until interrupted.",

        WALTER_WOBY_DASH_TITLE = "Dashing Doggie",
        WALTER_WOBY_DASH_DESC = "Woby dashes on command by double tapping any movement controls.",

        WALTER_WOBY_LUNAR_LOCK_DESC = "Find and defeat the Celestial Champion and have no Shadow Allegiance Skills to unlock.",
        WALTER_WOBY_SHADOW_LOCK_DESC = "Find and defeat the Ancient Fuelweaver and have no Lunar Allegiance Skills to unlock.",

        WALTER_WOBY_LUNAR_TITLE = "Lunar Woby",
        WALTER_WOBY_LUNAR_DESC = "After dashing, Woby can immediately start sprinting at +1 speed. When Woby is under moonlight on the surface, or in any area of Enlightenment, she has no additional hunger drain for sprinting or dashing.",

        WALTER_WOBY_SHADOW_TITLE = "Shadow Woby",
        WALTER_WOBY_SHADOW_DESC = "Woby's dash becomes a short distance teleport.",
    },

    --[[WANDA = {
    },]]

    --[[WARLY = {
    },]]

    WATHGRITHR = {
        WATHGRITHR_ARSENAL_SPEAR_1_TITLE = "Bragi's Blessing I",
        WATHGRITHR_ARSENAL_SPEAR_1_DESC = "Inspiration gain rate will increase a little when attacking using Battle Spears.",

        WATHGRITHR_ARSENAL_SPEAR_2_TITLE = "Bragi's Blessing II",
        WATHGRITHR_ARSENAL_SPEAR_2_DESC = "Inspiration gain rate will increase a fair amount when attacking using Battle Spears.",

        WATHGRITHR_ARSENAL_SPEAR_3_TITLE = "Elding Spear",
        WATHGRITHR_ARSENAL_SPEAR_3_DESC = "Learn to craft the Elding Spear: an electric weapon that does more damage to wet targets.",

        WATHGRITHR_ARSENAL_SPEAR_4_TITLE = "Elding Spear Enhancement I",
        WATHGRITHR_ARSENAL_SPEAR_4_DESC = "The Elding Spear can now perform a special attack.\nThis attack repairs Charged Elding Spears if it hits a target.",

        WATHGRITHR_ARSENAL_SPEAR_5_TITLE = "Elding Spear Enhancement II",
        WATHGRITHR_ARSENAL_SPEAR_5_DESC = "Upgrade the Elding Spear using Restrained Static to deal +20 Planar Damage.",

        ----------------------------------------------------------------------------

        WATHGRITHR_ARSENAL_HELMET_1_TITLE = "Hard Helm I",
        WATHGRITHR_ARSENAL_HELMET_1_DESC = "Battle Helms will be a little more durable when worn by Wigfrid.",

        WATHGRITHR_ARSENAL_HELMET_2_TITLE = "Hard Helm II",
        WATHGRITHR_ARSENAL_HELMET_2_DESC = "Battle Helms will be a fair amount more durable when worn by Wigfrid.",

        WATHGRITHR_ARSENAL_HELMET_3_TITLE = "Commander's Helm",
        WATHGRITHR_ARSENAL_HELMET_3_DESC = "Learn to craft the Commander's Helm: a helm that protects against knockback attacks.",

        WATHGRITHR_ARSENAL_HELMET_4_TITLE = "Commander's Helm Enhancement I",
        WATHGRITHR_ARSENAL_HELMET_4_DESC = "The Commander's Helm now has protection against planar damage.",

        WATHGRITHR_ARSENAL_HELMET_5_TITLE = "Commander's Helm Enhancement II",
        WATHGRITHR_ARSENAL_HELMET_5_DESC = "Wigfrid's natural healing ability will repair her Commander's Helm when she continues to fight at maximum health.",


        ----------------------------------------------------------------------------

        WATHGRITHR_ARSENAL_SHIELD_1_TITLE = "Battle Rönd",
        WATHGRITHR_ARSENAL_SHIELD_1_DESC = "Learn to craft the Battle Rönd. This shield can be used to attack, block attacks, and provide extra protection while equipped.",

        WATHGRITHR_ARSENAL_SHIELD_2_TITLE = "Battle Rönd Enhancement I",
        WATHGRITHR_ARSENAL_SHIELD_2_DESC = "The duration of the Battle Rönd's ability to block attacks will be increased.",

        WATHGRITHR_ARSENAL_SHIELD_3_TITLE = "Battle Rönd Enhancement II",
        WATHGRITHR_ARSENAL_SHIELD_3_DESC = "After blocking an attack with the Battle Rönd, your next attack within 5 seconds will deal +15-30 damage based on the damage blocked.",

        ----------------------------------------------------------------------------

        WATHGRITHR_BEEFALO_1_TITLE = "Noble Mount I",
        WATHGRITHR_BEEFALO_1_DESC = "Beefalos will be domesticated 15% faster.",

        WATHGRITHR_BEEFALO_2_TITLE = "Noble Mount II",
        WATHGRITHR_BEEFALO_2_DESC = "Beefalos will allow you to ride them for 30% longer.",

        WATHGRITHR_BEEFALO_3_TITLE = "Noble Mount III",
        WATHGRITHR_BEEFALO_3_DESC = "Riding a beefalo will make your inspiration slowly rise until it reaches the halfway mark.",

        WATHGRITHR_BEEFALO_SADDLE_TITLE = "Battle Saddle",
        WATHGRITHR_BEEFALO_SADDLE_DESC = "Learn to craft a new Beefalo Saddle that protects your Beefalo.",

        ----------------------------------------------------------------------------

        WATHGRITHR_SONGS_CONTAINER_LOCK_DESC = "Have 6 different Battle Calls in your inventory to unlock.",

        WATHGRITHR_SONGS_CONTAINER_TITLE = "Battle Call Canister",
        WATHGRITHR_SONGS_CONTAINER_DESC = "Learn to craft the Battle Call Canister, a storage solution for Battle Songs and Battle Stingers.",

        ----------------------------------------------------------------------------

        WATHGRITHR_SONGS_INSTANTSONG_CD_LOCK_DESC = "Perform Battle Stingers 10 times to unlock.",

        WATHGRITHR_SONGS_INSTANTSONG_CD_TITLE = "Fighting Words",
        WATHGRITHR_SONGS_INSTANTSONG_CD_DESC = "Battle Stingers will no longer consume Inspiration, and instead have a cooldown.",

        ----------------------------------------------------------------------------

        WATHGRITHR_SONGS_REVIVEWARRIOR_LOCK_DESC = "Play a Beefalo Horn to unlock.",

        WATHGRITHR_SONGS_REVIVEWARRIOR_TITLE = "Encore",
        WATHGRITHR_SONGS_REVIVEWARRIOR_DESC = "Learn to craft the Warrior's Reprise: Bring your allies back to life for an encore performance.",

        ----------------------------------------------------------------------------

        WATHGRITHR_COMBAT_DEFENSE_TITLE = "Mystic Resilience",
        WATHGRITHR_COMBAT_DEFENSE_DESC = "Receive a divine blessing that will provide you with +5 Planar Defense.",
        ----------------------------------------------------------------------------

        WATHGRITHR_ALLEGIANCE_LOCK_1_DESC = "Learn 12 skills to unlock.",

        WATHGRITHR_ALLEGIANCE_LUNAR_TITLE = "Lunar Melodist",
        WATHGRITHR_ALLEGIANCE_LUNAR_DESC = "The Cryptic Founder will reward your curiosity with the ability to craft the Enlightened Lullaby.\nAllies take less damage from Lunar Aligned enemies and deal bonus damage to Shadow Aligned enemies.",

        WATHGRITHR_ALLEGIANCE_SHADOW_TITLE = "Shadow Chanteuse",
        WATHGRITHR_ALLEGIANCE_SHADOW_DESC = "The Queen will reward your loyalty with the ability to craft the Dark Lament.\nAllies take less damage from Shadow Aligned enemies and deal bonus damage to Lunar Aligned enemies.",
    },

    --[[WAXWELL = {
    },]]

    --[[WEBBER = {
    },]]

    WENDY = {
        WENDY_SISTURN_1_TITLE = "Blessed Sisturn I",
        WENDY_SISTURN_1_DESC = "The chilling aura of death preserves the petals placed in the sisturn longer.",
        WENDY_SISTURN_2_TITLE = "Blessed Sisturn II",
        WENDY_SISTURN_2_DESC = "Wendy's resistance to scary things is increased, and she grants some of that confidence to others nearby.",
        WENDY_SISTURN_3_TITLE = "Blessed Sisturn III",
        WENDY_SISTURN_3_DESC = "Lune Tree Blossoms draw Abigail's humanity closer to the Constant.\nShe becomes more resistant to the Giants like the rest of the survivors, but her ghostly healing effects are slowed while she is summoned.",        

        WENDY_GHOSTCOMMAND_1_TITLE = "Team Spirit I",
        WENDY_GHOSTCOMMAND_1_DESC = "Wendy can remind Abigail she's a ghost, able to be unseen by her enemies to escape bad situations.",
        WENDY_GHOSTCOMMAND_2_TITLE = "Team Spirit II",
        WENDY_GHOSTCOMMAND_2_DESC = "Abigail can dash to anywhere Wendy needs reinforcement.",
        WENDY_GHOSTCOMMAND_3_TITLE = "Team Spirit III",
        WENDY_GHOSTCOMMAND_3_DESC = "Abigail can use her powers as a spooky ghost to scare and haunt things.",
        WENDY_GHOSTCOMMAND_HAUNT_TITLE = "Team Spirit IV",
        WENDY_GHOSTCOMMAND_HAUNT_DESC = "Wendy can suggest things for Abigail to haunt.",

        WENDY_SMALLGHOST_1_TITLE = "Pipspook Quest I",
        WENDY_SMALLGHOST_1_DESC = "Pipspook lost toys aren't quite so far away.",
        WENDY_SMALLGHOST_2_TITLE = "Pipspook Quest II",
        WENDY_SMALLGHOST_2_DESC = "Pipspooks remember more lost toys to find.",
        WENDY_SMALLGHOST_3_TITLE = "Pipspook Quest III",
        WENDY_SMALLGHOST_3_DESC = "Pipspooks produce more Mourning Glories.",

        WENDY_GHOSTFLOWER_BUTTERFLY_TITLE = "Mourning Glory I",
        WENDY_GHOSTFLOWER_BUTTERFLY_DESC = "Begin the journey of revival with Butterflies and Moths.",
        WENDY_GHOSTFLOWER_HAT_TITLE = "Mourning Glory II",
        WENDY_GHOSTFLOWER_HAT_DESC = "Surround yourself in ghostly nature and taste the power of the elixirs even if not fully.",
        WENDY_GHOSTFLOWER_GRAVE_TITLE = "Mourning Glory III",
        WENDY_GHOSTFLOWER_GRAVE_DESC = "You can bring back friends, but only if they've entered the Constant it seems.",

        WENDY_GRAVESTONE_1_TITLE = "Grave Beautification",
        WENDY_GRAVESTONE_1_DESC = "Wendy can adorn graves with flowers to delight their resident spirits.\nEvil Flowers no longer hold fear for Wendy.",
        WENDY_MAKEGRAVEMOUNDS_TITLE = "Gravestones By Wendy",
        WENDY_MAKEGRAVEMOUNDS_DESC = "Wendy can put to rest the spirits of skeletons with a gravestone.\nShe can also craft a Spirit Vessel to invite friendly phantoms to new homes.",

        WENDY_POTION_CONTAINER_TITLE = "Picnic Casket",
        WENDY_POTION_CONTAINER_DESC = "Wendy can craft a Basket to carry all of Abigail's Elixirs and Mourning Glory.",
        WENDY_POTION_REVIVE_TITLE = "Ghastly Experience",
        WENDY_POTION_REVIVE_DESC = "Wendy learns to brew a new Ghostly Elixir which helps Abigail quickly remember her potential.",
        WENDY_POTION_DURATION_TITLE = "Strong Brew",
        WENDY_POTION_DURATION_DESC = "Elixirs with one day duration will now last two.",
        WENDY_POTION_YIELD_TITLE = "Extra Yield",
        WENDY_POTION_YIELD_DESC = "Sometimes, Wendy is able to squeeze extra Elixirs out of the same ingredients.",

        WENDY_AVENGING_GHOST_TITLE = "Vengeful Ghost",
        WENDY_AVENGING_GHOST_DESC = "When Wendy or her friends are killed, their spirit is vengeful and able to wreak havoc on the living world for a short time.",

        WENDY_SHADOW_LOCK_1_DESC = "Defeat the Fuelweaver",
        WENDY_SHADOW_LOCK_2_DESC = "Have no other allegiance",

        WENDY_SHADOW_1_TITLE = "Shadow Sisterhood I",
        WENDY_SHADOW_1_DESC = "Abigail attunes with the shadows and earns some Planar Defense.",
        WENDY_SHADOW_2_TITLE = "Shadow Sisterhood II",
        WENDY_SHADOW_2_DESC = "Wendy can craft a Super Elixir infused with shadow magic that increases Abigail's Vex damage.\nSuper Elixirs work in parallel to regular Elixirs.",
        WENDY_SHADOW_3_TITLE = "Shadow Sisterhood III",
        WENDY_SHADOW_3_DESC = "Dark Magic is released whenever Wendy uses the Murder action filling Abigail with more power for a short time.",

        WENDY_LUNAR_LOCK_1_DESC = "Defeat the Celestial Champion",
        WENDY_LUNAR_LOCK_2_DESC = "Have no other allegiance",

        WENDY_LUNAR_1_TITLE = "Lunar Sisterhood I",
        WENDY_LUNAR_1_DESC = "Abigail attunes with lunar energies and earns some Planar Defense.",
        WENDY_LUNAR_2_TITLE = "Lunar Sisterhood II",
        WENDY_LUNAR_2_DESC = "Wendy can craft a Super Elixir infused with lunar energy that gives Abigail a boost of Planar Damage for its duration.\nSuper Elixirs work in parallel to regular Elixirs.",
        WENDY_LUNAR_3_TITLE = "Lunar Sisterhood III",
        WENDY_LUNAR_3_DESC = "Wendy can use the Moon Dial during a waxing or full moon to fill Abigail with lunar energy, turning her into a Gestalt. The Moon Dial can restore her ghost status during a waning or new moon.",
    },

    --[[WICKERBOTTOM = {
    },]]

    WILLOW = {
        -- LIGHTER
        WILLOW_CONTROLLED_BURN_1_TITLE = "Controlled Burning",
        WILLOW_CONTROLLED_BURN_1_DESC = "Controlled fires you set won't spread, and burnable loot will just smolder.\nItems like torches and Willow's lighter have a 100% chance to ignite targets.",
        WILLOW_CONTROLLED_BURN_2_TITLE = "Burn Duration",
        WILLOW_CONTROLLED_BURN_2_DESC = "Creatures burn for a longer time.",
        WILLOW_CONTROLLED_BURN_3_TITLE = "Fire Fighter",
        WILLOW_CONTROLLED_BURN_3_DESC = "Your fires deal more damage to creatures over time.",

        WILLOW_ATTUNED_LIGHTER_TITLE = "Hungry Lighter",
        WILLOW_ATTUNED_LIGHTER_DESC = "Stop things from burning by absorbing the flame (even when they're only smoldering) with your lighter.",
        WILLOW_EMBERS_TITLE = "Ember Tender",
        WILLOW_EMBERS_DESC = "Collect and use Embers to perform Pyrokinetic effects.\nYou can collect Embers from burned creatures with your lighter.\nUse Embers to refuel the lighter.",

        WILLOW_FIRE_BURST_TITLE = "Spontaneous Combustion",
        WILLOW_FIRE_BURST_DESC = "Use Embers to ignite creatures in an area near you.",
        WILLOW_FIRE_BALL_TITLE = "Fire Ball",
        WILLOW_FIRE_BALL_DESC = "Use Embers to create a ball of flame for heat and light.",
        WILLOW_FIRE_FRENZY_TITLE = "Burning Frenzy",
        WILLOW_FIRE_FRENZY_DESC = "For 60 seconds, add 25% weapon damage when attacking burning targets.",

        WILLOW_LIGHTRADIUS_1_TITLE = "Brighter Lighter I",
        WILLOW_LIGHTRADIUS_1_DESC = "Increase your lighter's brightness a little.",
        WILLOW_LIGHTRADIUS_2_TITLE = "Brighter Lighter II",
        WILLOW_LIGHTRADIUS_2_DESC = "Increase your lighter's brightness a lot.",

        -- BERNIE
        WILLOW_BERNIESPEED_1_TITLE = "Accelerant I",
        WILLOW_BERNIESPEED_1_DESC = "Bernie's movement speed is a little faster.",
        WILLOW_BERNIESPEED_2_TITLE = "Accelerant II",
        WILLOW_BERNIESPEED_2_DESC = "Bernie's movement speed is much faster.",

        WILLOW_BERNIESANITY_1_TITLE = "Bearly Sane I",
        WILLOW_BERNIESANITY_1_DESC = "Bernie will become animated at a higher sanity threshold.",
        WILLOW_BERNIESANITY_2_TITLE = "Bearly Sane II",
        WILLOW_BERNIESANITY_2_DESC = "Bernie will become animated at an even higher sanity threshold.",
        WILLOW_BERNIEAI_TITLE = "Hot-Headed",
        WILLOW_BERNIEAI_DESC = "Bernie will activate to fight hostile lunar and shadow aligned creatures regardless of Willow's sanity.",


        WILLOW_BERNIEREGEN_1_TITLE = "Patch Up I",
        WILLOW_BERNIEREGEN_1_DESC = "Bernie's health regenerates slowly.",
        WILLOW_BERNIEREGEN_2_TITLE = "Patch Up II",
        WILLOW_BERNIEREGEN_2_DESC = "Bernie's health regenerates quicker.",

        WILLOW_BERNIE_LOCK_DESC = "Learn at least 4 Bernie skills to unlock.",

        WILLOW_BERNIEHEALTH_1_TITLE = "Tough Stuffing I",
        WILLOW_BERNIEHEALTH_1_DESC = "Bernie's total health is a little higher.",
        WILLOW_BERNIEHEALTH_2_TITLE = "Tough Stuffing II",
        WILLOW_BERNIEHEALTH_2_DESC = "Bernie's total health is much higher.",

        WILLOW_BERNIE_DOUBLE_LOCK_DESC = "Learn at least 8 Bernie skills to unlock.",

        WILLOW_BURNINGBERNIE_TITLE = "Burning Bernie",
        WILLOW_BURNINGBERNIE_DESC = "Igniting Bernie will give him a firey aura for a short time.\nEnemies that attack an ignited Bernie will take damage back.",


        -- ALLIEGIANCE
        WILLOW_ALLEGIANCE_LOCK_1_DESC = "Find and defeat the Ancient Fuelweaver.\nHave no Lunar Allegiance Skills.",
        WILLOW_ALLEGIANCE_LOCK_2_DESC = "Learn 6 Bernie skills to unlock.",
        WILLOW_ALLEGIANCE_LOCK_3_DESC = "Learn 7 Lighter skills to unlock.",

        WILLOW_ALLEGIANCE_SHADOW_1_TITLE = "Shadow Fire-Raiser",
        WILLOW_ALLEGIANCE_SHADOW_1_DESC = "The Queen will reward your loyalty with the power of shadow fire.\nSummon multiple tendrils of black flame to seek out hostile targets.",
        WILLOW_ALLEGIANCE_SHADOW_2_TITLE = "Shadow Bernie",
        WILLOW_ALLEGIANCE_SHADOW_2_DESC = "Tap into the darkness to strengthen Bernie's planar attack and defense, particularly against lunar enemies.",

        WILLOW_ALLEGIANCE_LOCK_4_DESC = "Find and defeat the Celestial Champion.\nHave no Shadow Allegiance Skills.",
        WILLOW_ALLEGIANCE_LOCK_5_DESC = "Learn 7 Lighter skills to unlock.",
        WILLOW_ALLEGIANCE_LOCK_6_DESC = "Learn 6 Bernie skills to unlock.",

        WILLOW_ALLEGIANCE_LUNAR_1_TITLE = "Lunar Fire-Raiser",
        WILLOW_ALLEGIANCE_LUNAR_1_DESC = "The Cryptic Founder will reward your curiosity with the formula for lunar flames.\nUse Embers to blast cold lunar flames.",
        WILLOW_ALLEGIANCE_LUNAR_2_TITLE = "Lunar Bernie",
        WILLOW_ALLEGIANCE_LUNAR_2_DESC = "Entreat the moon to strengthen Bernie's planar attack and defense, particularly against shadow enemies.",
    },

    WILSON = {

        WILSON_ALCHEMY_1_TITLE = "Transmutation",
        WILSON_ALCHEMY_1_DESC = "Transform 3 Twigs into a Log.\nTransform a Log into 2 Twigs.",

        WILSON_ALCHEMY_2_TITLE = "Transmute Gems I",
        WILSON_ALCHEMY_2_DESC = "Transform 2 Red Gems into a Blue Gem.\nTransform 2 Blue Gems into a Red Gem.\nTransform a Blue and Red Gem into a Purple Gem.",

        WILSON_ALCHEMY_5_TITLE = "Transmute Gems II",
        WILSON_ALCHEMY_5_DESC = "Transform 3 Purple Gems into an Orange Gem.\nTransform 3 Orange Gems into a Yellow Gem.",

        WILSON_ALCHEMY_6_TITLE = "Transmute Gems III",
        WILSON_ALCHEMY_6_DESC = "Transform 3 Yellow Gems into a Green Gem.\nTransform 6 Gems of different colors into an Iridescent Gem.",

        WILSON_ALCHEMY_3_TITLE = "Transmute Ore I",
        WILSON_ALCHEMY_3_DESC = "Transform 3 Rocks into a Flint.\nTransform 2 Flint into Rocks.",

        WILSON_ALCHEMY_7_TITLE = "Transmute Ore II",
        WILSON_ALCHEMY_7_DESC = "Transform 3 Nitre into a Gold Nugget.\nTransform 2 Gold Nuggets into Nitre.",

        WILSON_ALCHEMY_8_TITLE = "Transmute Ore III",
        WILSON_ALCHEMY_8_DESC = "Transform 2 Cut Stone into Marble.\nTransform Marble into Cut Stone.\nTransform 2 Marble into Moon Rock.",

        WILSON_ALCHEMY_4_TITLE = "Transmute Icky I",
        WILSON_ALCHEMY_4_DESC = "Transform 3 Morsels into a Meat.\nTransform a Meat into 2 Morsels.",

        WILSON_ALCHEMY_9_TITLE = "Transmute Icky II",
        WILSON_ALCHEMY_9_DESC = "Transform 2 Beard Hair into Beefalo Wool.\n Transform 2 Beefalo Wool into Beard Hair.",

        WILSON_ALCHEMY_10_TITLE = "Transmute Icky III",
        WILSON_ALCHEMY_10_DESC = "Transform 6 Rot into Manure.\nTransform 2 Hound's Teeth into a Bone Shards.\nTransform 2 Bone Shards into a Hound's Tooth.",

        WILSON_TORCH_1_TITLE = "Torch Longevity I",
        WILSON_TORCH_1_DESC = "Torches last a little longer.",

        WILSON_TORCH_2_TITLE = "Torch Longevity II",
        WILSON_TORCH_2_DESC = "Torches last a fair amount longer.",

        WILSON_TORCH_3_TITLE = "Torch Longevity III",
        WILSON_TORCH_3_DESC = "Torches last a lot longer.",

        WILSON_TORCH_4_TITLE = "Torch Range I",
        WILSON_TORCH_4_DESC = "Torches are a little brighter.",

        WILSON_TORCH_5_TITLE = "Torch Range II",
        WILSON_TORCH_5_DESC = "Torches are a fair amount brighter.",

        WILSON_TORCH_6_TITLE = "Torch Range III",
        WILSON_TORCH_6_DESC = "Torches are a lot brighter.",

        WILSON_TORCH_1_LOCK_DESC = "Learn 3 Torch skills to unlock.",

        WILSON_TORCH_7_TITLE = "Torch Toss",
        WILSON_TORCH_7_DESC = "Uses a scientifically formulated trajectory to always land right side up.",

        WILSON_BEARD_1_TITLE = "Beard Insulation I",
        WILSON_BEARD_1_DESC = "Gain high insulation from your beard.",

        WILSON_BEARD_2_TITLE = "Beard Insulation II",
        WILSON_BEARD_2_DESC = "Gain higher insulation from your beard.",

        WILSON_BEARD_3_TITLE = "Beard Insulation III",
        WILSON_BEARD_3_DESC = "Gain highest insulation from your beard.",

        WILSON_BEARD_4_TITLE = "Beard Growth I",
        WILSON_BEARD_4_DESC = "Your magnificent beard grows a little faster.",

        WILSON_BEARD_5_TITLE = "Beard Growth II",
        WILSON_BEARD_5_DESC = "Your magnificent beard grows a fair amount faster.",

        WILSON_BEARD_6_TITLE = "Beard Growth III",
        WILSON_BEARD_6_DESC = "Your magnificent beard grows much faster.",

        WILSON_BEARD_1_LOCK_DESC = "Learn 3 Beard skills to unlock.",

        WILSON_BEARD_7_TITLE = "Beard Hair Storage",
        WILSON_BEARD_7_DESC = "Stash food in your beard.",

        WILSON_ALLEGIANCE_LOCK_1_DESC = "Learn 12 skills to unlock.",

        WILSON_ALLEGIANCE_SHADOW_TITLE = "Shadow Courtier",
        WILSON_ALLEGIANCE_SHADOW_DESC = "The Queen will reward your loyalty with the secrets of Shadow Transmutation.",

        WILSON_ALLEGIANCE_LUNAR_TITLE = "Lunar Innovator",
        WILSON_ALLEGIANCE_LUNAR_DESC = "The Cryptic Founder will reward your curiosity with the secrets of Lunar Transmutation.",
    },

    WINONA = {
        -- Low shelf.
        WINONA_SPOTLIGHT_HEATED_TITLE = "Hotlight",
        WINONA_SPOTLIGHT_HEATED_DESC = "Upgrade your Spotlights to give off heat when it's cold out.",
        WINONA_SPOTLIGHT_RANGE_TITLE = "Spacious Spotlight",
        WINONA_SPOTLIGHT_RANGE_DESC = "Upgrade your Spotlights to illuminate a larger area.",
        WINONA_PORTABLE_STRUCTURES_TITLE = "Portability",
        WINONA_PORTABLE_STRUCTURES_DESC = "Easily dismantle your machines, and learn how to build a Handy Remote to remotely control Catapults.",
        WINONA_GADGET_RECHARGE_TITLE = "Quick Charge",
        WINONA_GADGET_RECHARGE_DESC = "Gadgets placed next to a Generator or G.E.M.erator recharge 100% faster.",
        WINONA_BATTERY_IDLEDRAIN_TITLE = "Energy-Saver",
        WINONA_BATTERY_IDLEDRAIN_DESC = "Generators and G.E.M.erators no longer consume energy while they're not in use.\nMachines connected to Generators won't consume energy while in sleep mode.",

        WINONA_LOWSHELF_LOCK_DESC = "Learn 3 skills on the shelf below to unlock the skills on the shelf above.",
        -- Mid shelf.
        WINONA_CATAPULT_SPEED_1_TITLE = "Rapid-Fire I",
        WINONA_CATAPULT_SPEED_1_DESC = "Tune-up your Catapults to increase their firing rate by 5%.",
        WINONA_CATAPULT_SPEED_2_TITLE = "Rapid-Fire II",
        WINONA_CATAPULT_SPEED_2_DESC = "Tune-up your Catapults to increase their firing rate by 10%.",
        WINONA_CATAPULT_SPEED_3_TITLE = "Rapid-Fire III",
        WINONA_CATAPULT_SPEED_3_DESC = "Tune-up your Catapults to increase their firing rate by 20%.",
        WINONA_CATAPULT_AOE_1_TITLE = "Explosive Volley I",
        WINONA_CATAPULT_AOE_1_DESC = "Modify your Catapults to deal damage to a 25% larger area.",
        WINONA_CATAPULT_AOE_2_TITLE = "Explosive Volley II",
        WINONA_CATAPULT_AOE_2_DESC = "Modify your Catapults to deal damage to a 50% larger area.",
        WINONA_CATAPULT_AOE_3_TITLE = "Explosive Volley III",
        WINONA_CATAPULT_AOE_3_DESC = "Modify your Catapults to deal damage to a 100% larger area.",

        WINONA_PORTABLE_STRUCTURES_LOCK_DESC = "Requires the Portability skill and access to this shelf to unlock.",
        WINONA_CATAPULT_VOLLEY_TITLE = "Precise Targeting",
        WINONA_CATAPULT_VOLLEY_DESC = "All Catapults within range of your Handy Remote fire at your selected target.",
        WINONA_CATAPULT_BOOST_TITLE = "Barrage",
        WINONA_CATAPULT_BOOST_DESC = "All Catapults within range of your Handy Remote have an increased firing rate for a short period of time.",
        WINONA_BATTERY_EFFICIENCY_1_TITLE = "Greater Generator I",
        WINONA_BATTERY_EFFICIENCY_1_DESC = "Boost the efficiency of Generators and G.E.M.erators by 25%.",
        WINONA_BATTERY_EFFICIENCY_2_TITLE = "Greater Generator II",
        WINONA_BATTERY_EFFICIENCY_2_DESC = "Boost the efficiency of Generators and G.E.M.erators by 50%.",
        WINONA_BATTERY_EFFICIENCY_3_TITLE = "Greater Generator III",
        WINONA_BATTERY_EFFICIENCY_3_DESC = "Boost the efficiency of Generators and G.E.M.erators by 100%.",

        WINONA_MIDSHELF_LOCK_DESC = "Learn 6 total skills from the shelves below to unlock the skills on the shelf above.",
        -- Shadow.
        WINONA_SHADOW_1_TITLE = "Nightmare Generator",
        WINONA_SHADOW_1_DESC = "Learn how to utilize Nightmare Fuel as a fuel source for Generators.",
        WINONA_SHADOW_2_TITLE = "Pure Horror Generator",
        WINONA_SHADOW_2_DESC = "Learn how to utilize Pure Horror as a fuel source for Generators.",

        WINONA_SHADOW_3_LOCK_DESC = "Requires the Portability and Pure Horror Generator skills to unlock.",
        WINONA_SHADOW_3_TITLE = "Shadow Strike",
        WINONA_SHADOW_3_DESC = "Use your Handy Remote to select a target for a shadow-infused Catapult attack.",

        WINONA_CHARLIE_1_TITLE = "Shadow Seeker I",
        WINONA_CHARLIE_1_DESC = "The Queen imparts a design for enchanted glasses that reveal hidden traces of shadow magic.\nDoes she want you to find her?",

        WINONA_CHARLIE_2_LOCK_DESC = "Requires the Shadow Seeker I skill, and to not have Founder's Keepers II to unlock.",
        WINONA_CHARLIE_2_TITLE = "Shadow Seeker II",
        WINONA_CHARLIE_2_DESC = "Become more adept at locating traces of shadow magic.\nThe Queen will watch over you.",
        -- Lunar.
        WINONA_LUNAR_1_TITLE = "Enlightened G.E.M.erator",
        WINONA_LUNAR_1_DESC = "Learn how to utilize Enlightened Shards as a fuel source for G.E.M.erators.",
        WINONA_LUNAR_2_TITLE = "Brilliance G.E.M.erator",
        WINONA_LUNAR_2_DESC = "Learn how to utilize Pure Brilliance as a fuel source for G.E.M.erators.",

        WINONA_LUNAR_3_LOCK_DESC = "Requires the Portability and Brilliance G.E.M.erator skills to unlock.",
        WINONA_LUNAR_3_TITLE = "Enlightened Strike",
        WINONA_LUNAR_3_DESC = "Use your Handy Remote to select a target for a lunar essence-infused Catapult attack.",

        WINONA_WAGSTAFF_1_TITLE = "Founder's Keepers I",
        WINONA_WAGSTAFF_1_DESC = "Build a device inspired by the Cryptic Founder's designs to track down hidden supply caches.\nGain mastery over all technology found in Cacheboxes.",

        WINONA_WAGSTAFF_2_LOCK_DESC = "Requires the Founder's Keepers I skill, and to not have Shadow Seeker II to unlock.",
        WINONA_WAGSTAFF_2_TITLE = "Founder's Keepers II",
        WINONA_WAGSTAFF_2_DESC = "Broaden the scope of your Inspectacles to locate higher-grade supply caches.\nGain mastery over all technology found in Advanced Cacheboxes.",
    },

    WOLFGANG = {
        WOLFGANG_CRITWORK_1_TITLE = "Chore Workout I",
        WOLFGANG_CRITWORK_1_DESC = "Chance to one-shot while working improved to 5%.",

        WOLFGANG_CRITWORK_2_TITLE = "Chore Workout II",
        WOLFGANG_CRITWORK_2_DESC = "Chance to one-shot while working improved to 10%.",

        WOLFGANG_CRITWORK_3_TITLE = "Chore Workout III",
        WOLFGANG_CRITWORK_3_DESC = "Chance to one-shot while working improved to 15%.",
        ---
        WOLFGANG_DUMBBELL_CRAFTING_TITLE = "Dumbbell Developer",
        WOLFGANG_DUMBBELL_CRAFTING_DESC = "Learn to craft several new dumbbells.",
        ---
        WOLFGANG_DUMBBELL_THROWING_1_TITLE = "Heavy Hitter I",
        WOLFGANG_DUMBBELL_THROWING_1_DESC = "Increase the damage of thrown dumbbells by 50%.",

        WOLFGANG_DUMBBELL_THROWING_2_TITLE = "Heavy Hitter II",
        WOLFGANG_DUMBBELL_THROWING_2_DESC = "Increase the damage of thrown dumbbells by 100%.",
        ---
        WOLFGANG_COACH_TITLE = "Coach Wolfgang",
        WOLFGANG_COACH_DESC = "Learn to craft a Coaching Whistle.\nWhile coaching, Normal Wolfgang will raise friends' sanity and boost followers' damage.",

        WOLFGANG_NORMAL_SPEED_TITLE = "Leg Day",
        WOLFGANG_NORMAL_SPEED_DESC = "+10% speed boost when Normal.",
        ---
        WOLFGANG_GYM_OVERBUFF_1_TITLE = "Push the Limits I",
        WOLFGANG_GYM_OVERBUFF_1_DESC = "Use the gym to push your Mighty Meter past its limit.\n Mighty Meter can go up to 110.",

        WOLFGANG_GYM_OVERBUFF_2_TITLE = "Push the Limits II",
        WOLFGANG_GYM_OVERBUFF_2_DESC = "Use the gym to push your Mighty Meter past its limit.\n Mighty Meter can go up to 120.",

        WOLFGANG_GYM_OVERBUFF_3_TITLE = "Push the Limits III",
        WOLFGANG_GYM_OVERBUFF_3_DESC = "Use the gym to push your Mighty Meter past its limit.\n Mighty Meter can go up to 130.",

        WOLFGANG_GYM_OVERBUFF_4_TITLE = "Push the Limits IV",
        WOLFGANG_GYM_OVERBUFF_4_DESC = "Use the gym to push your Mighty Meter past its limit.\n Mighty Meter can go up to 140.",

        WOLFGANG_GYM_OVERBUFF_5_TITLE = "Push the Limits V",
        WOLFGANG_GYM_OVERBUFF_5_DESC = "Use the gym to push your Mighty Meter past its limit.\n Mighty Meter can go up to 150.",

        WOLFGANG_AUTO_GYM_TITLE = "Gym Mastery",
        WOLFGANG_AUTO_GYM_DESC = "Perfect your gym workout.\nMini game will complete automatically.",

        WOLFGANG_MIGHTY_PLANAR_DAMAGE_1_TITLE = "Mighty Weapons I",
        WOLFGANG_MIGHTY_PLANAR_DAMAGE_1_DESC = "Bring out the full strength of planar melee weapons.\nAdd +5 Planar Damage to planar melee weapons when Mighty.",

        WOLFGANG_MIGHTY_PLANAR_DAMAGE_2_TITLE = "Mighty Weapons II",
        WOLFGANG_MIGHTY_PLANAR_DAMAGE_2_DESC = "Bring out the full strength of planar melee weapons.\nAdd +10 Planar Damage to planar melee weapons when Mighty.",

        WOLFGANG_MIGHTY_PLANAR_DAMAGE_3_TITLE = "Mighty Weapons III",
        WOLFGANG_MIGHTY_PLANAR_DAMAGE_3_DESC = "Bring out the full strength of planar melee weapons.\nAdd +15 Planar Damage to planar melee weapons when Mighty.",

        WOLFGANG_MIGHTY_PLANAR_DAMAGE_4_TITLE = "Mighty Weapons IV",
        WOLFGANG_MIGHTY_PLANAR_DAMAGE_4_DESC = "Bring out the full strength of planar melee weapons.\nAdd +20 Planar Damage to planar melee weapons when Mighty.",

        WOLFGANG_MIGHTY_PLANAR_DAMAGE_5_TITLE = "Mighty Weapons V",
        WOLFGANG_MIGHTY_PLANAR_DAMAGE_5_DESC = "Bring out the full strength of planar melee weapons.\nAdd +25 Planar Damage to planar melee weapons when Mighty.",
        ---
        WOLFGANG_ALLEGIANCE_SHADOW_1_TITLE = "Shadow Guard I",
        WOLFGANG_ALLEGIANCE_SHADOW_1_DESC = "The Queen will reward your loyalty with devastating strength.\nAdd +10% of total damage fighting Lunar-aligned creatures when Mighty.",

        WOLFGANG_ALLEGIANCE_SHADOW_2_TITLE = "Shadow Guard II",
        WOLFGANG_ALLEGIANCE_SHADOW_2_DESC = "The Queen will reward your loyalty with devastating strength.\nAdd +20% of total damage fighting Lunar-aligned creatures when Mighty.",

        WOLFGANG_ALLEGIANCE_SHADOW_3_TITLE = "Shadow Guard III",
        WOLFGANG_ALLEGIANCE_SHADOW_3_DESC = "The Queen will reward your loyalty with devastating strength.\nAdd +30% of total damage fighting Lunar-aligned creatures when Mighty.",

        WOLFGANG_ALLEGIANCE_LUNAR_1_TITLE = "Lunar Strategist I",
        WOLFGANG_ALLEGIANCE_LUNAR_1_DESC = "The Cryptic Founder will reward your curiosity by revealing the enemy's weaknesses.\nAdd +10% of total damage fighting Shadow-aligned creatures when Mighty.",

        WOLFGANG_ALLEGIANCE_LUNAR_2_TITLE = "Lunar Strategist II",
        WOLFGANG_ALLEGIANCE_LUNAR_2_DESC = "The Cryptic Founder will reward your curiosity by revealing the enemy's weaknesses.\nAdd +20% of total damage fighting Shadow-aligned creatures when Mighty.",

        WOLFGANG_ALLEGIANCE_LUNAR_3_TITLE = "Lunar Strategist III",
        WOLFGANG_ALLEGIANCE_LUNAR_3_DESC = "The Cryptic Founder will reward your curiosity by revealing the enemy's weaknesses.\nAdd +30% of total damage fighting Shadow-aligned creatures when Mighty.",
    },

    WOODIE = {

        WOODIE_CURSE_WEREMETER_1_TITLE = "Transformation Timer I",
        WOODIE_CURSE_WEREMETER_2_TITLE = "Transformation Timer II",
        WOODIE_CURSE_WEREMETER_3_TITLE = "Transformation Timer III",

        WOODIE_CURSE_WEREMETER_1_DESC = "Were-forms last a little longer.",
        WOODIE_CURSE_WEREMETER_2_DESC = "Were-forms last a fair amount longer.",
        WOODIE_CURSE_WEREMETER_3_DESC = "Were-forms last much longer.",

        ----------------------

        WOODIE_CURSE_MASTER_LOCK_DESC = "Learn 6 Curse skills to unlock.",

        WOODIE_CURSE_MASTER_TITLE = "Curse Embracer",
        WOODIE_CURSE_MASTER_DESC  = "Suffer no health or sanity penalties for eating Kitschy Idols.\nReturn to human form without having an empty stomach.",

        ----------------------

        WOODIE_CURSE_BEAVER_1_TITLE = "The Werebeaver I",
        WOODIE_CURSE_BEAVER_2_TITLE = "The Werebeaver II",
        WOODIE_CURSE_BEAVER_3_TITLE = "The Werebeaver III",

        WOODIE_CURSE_BEAVER_1_DESC = "Mine faster in your Werebeaver form.",
        WOODIE_CURSE_BEAVER_2_DESC = "Chop faster in your Werebeaver form.",
        WOODIE_CURSE_BEAVER_3_DESC = "Chop, mine and break hard materials in your Werebeaver form.",

        WOODIE_CURSE_MOOSE_1_TITLE = "The Weremoose I",
        WOODIE_CURSE_MOOSE_2_TITLE = "The Weremoose II",
        WOODIE_CURSE_MOOSE_3_TITLE = "The Weremoose III",

        WOODIE_CURSE_MOOSE_1_DESC = "Your Weremoose form is more resistant to hitting obstacles and walks a little faster.",
        WOODIE_CURSE_MOOSE_2_DESC = "Gain slow health regeneration in your Weremoose form.",
        WOODIE_CURSE_MOOSE_3_DESC = "You can stop mid-charge in your Weremoose form.",

        WOODIE_CURSE_GOOSE_1_TITLE = "The Weregoose I",
        WOODIE_CURSE_GOOSE_2_TITLE = "The Weregoose II",
        WOODIE_CURSE_GOOSE_3_TITLE = "The Weregoose III",

        WOODIE_CURSE_GOOSE_1_DESC = "Run faster in your Weregoose form.",
        WOODIE_CURSE_GOOSE_2_DESC = "Become completely waterproof in Weregoose form.",
        WOODIE_CURSE_GOOSE_3_DESC = "Occasionally dodge an incoming attack in Weregoose form.",

        ----------------------

        WOODIE_CURSE_BEAVER_LOCK_DESC = "Only one were-form can be fully mastered. Choose wisely.",
        WOODIE_CURSE_MOOSE_LOCK_DESC  = "Only one were-form can be fully mastered. Choose wisely.",
        WOODIE_CURSE_GOOSE_LOCK_DESC  = "Only one were-form can be fully mastered. Choose wisely.",

        WOODIE_CURSE_EPIC_BEAVER_TITLE = "Werebeaver Mastery",
        WOODIE_CURSE_EPIC_MOOSE_TITLE = "Weremoose Mastery",
        WOODIE_CURSE_EPIC_GOOSE_TITLE = "Weregoose Mastery",

        WOODIE_CURSE_EPIC_BEAVER_DESC = "The Werebeaver learns to smack the ground with his tail, destroying everything around him.",
        WOODIE_CURSE_EPIC_MOOSE_DESC = "The Weremoose learns to throw a strong planar punch on every 3rd hit, and gains a natural defense against planar damage.",
        WOODIE_CURSE_EPIC_GOOSE_DESC = "The Weregoose learns to fly around to explore the world, but it's a little out of control.",

        ----------------------

        WOODIE_HUMAN_QUICKPICKER_1_TITLE = "Quick Picker I",
        WOODIE_HUMAN_QUICKPICKER_2_TITLE = "Quick Picker II",
        WOODIE_HUMAN_QUICKPICKER_3_TITLE = "Quick Picker III",

        WOODIE_HUMAN_QUICKPICKER_1_DESC = "Collect stuff a little faster.",
        WOODIE_HUMAN_QUICKPICKER_2_DESC = "Collect stuff a fair amount faster.",
        WOODIE_HUMAN_QUICKPICKER_3_DESC = "Collect stuff much faster.",

        ----------------------

        WOODIE_HUMAN_TREEGUARD_1_TITLE = "Treeguard Feller I",
        WOODIE_HUMAN_TREEGUARD_2_TITLE = "Treeguard Feller II",
        WOODIE_HUMAN_TREEGUARD_MAX_TITLE = "Treeguard Feller III",

        WOODIE_HUMAN_TREEGUARD_1_DESC = "Deal a fair amount more damage to Treeguards.",
        WOODIE_HUMAN_TREEGUARD_2_DESC = "Deal much more damage to Treeguards.",
        WOODIE_HUMAN_TREEGUARD_MAX_DESC = "Learn to craft the Treeguard Idol, an extremely burnable effigy.\nAttracts Treeguards when burned.",

        ----------------------

        WOODIE_HUMAN_LUCY_1_TITLE = "Woodworker",
        WOODIE_HUMAN_LUCY_2_TITLE = "Hat Carving",
        WOODIE_HUMAN_LUCY_3_TITLE = "Cane Carving",

        WOODIE_HUMAN_LUCY_1_DESC = "Use Lucy to carve boards more efficiently.",
        WOODIE_HUMAN_LUCY_2_DESC = "Use Lucy to carve a nice Hardwood Hat for protection.",
        WOODIE_HUMAN_LUCY_3_DESC = "Use Lucy to carve a Wooden Walking Stick for easy mobility.",

        ----------------------

        WOODIE_ALLEGIANCE_LOCK_1_DESC = "Learn 12 skills to unlock.",

        WOODIE_ALLEGIANCE_SHADOW_TITLE = "Shadow Wrangler",
        WOODIE_ALLEGIANCE_SHADOW_DESC = "The Queen will reward your loyalty by calling off her shadow creatures.\n(But only when you're in a were-form.)",

        WOODIE_ALLEGIANCE_LUNAR_TITLE = "Lunar Renegade",
        WOODIE_ALLEGIANCE_LUNAR_DESC = "The Cryptic Founder will reward your curiosity by blocking the moon's ability to trigger your curse.",
    },

    WORMWOOD = {
        BUTTERFLY_FRIEND_TITLE = "Butterfly Friend",
        BUTTERFLY_FRIEND_DESC = "Butterflies will no longer fly away from you.",

        SAPLINGCRAFTING_TITLE = "Sapling Crafting",
        SAPLINGCRAFTING_DESC = "Sacrifice health to craft Lunar Saplings.",

        BERRYBUSHCRAFTING_TITLE = "Berry Bush Crafting",
        BERRYBUSHCRAFTING_DESC = "Sacrifice health to craft Berry Bushes.",

        REEDSCRAFTING_TITLE = "Monkeytail Crafting",
        REEDSCRAFTING_DESC = "Sacrifice health to craft Monkeytails.",

        JUICYBERRYBUSHCRAFTING_TITLE = "Juicy Berry Bush Crafting",
        JUICYBERRYBUSHCRAFTING_DESC = "Sacrifice health to craft Juicy Berry Bushes.",

        LUREPLANTCRAFTING_TITLE = "Lureplant Crafting",
        LUREPLANTCRAFTING_DESC = "Sacrifice health to craft Lureplants.",

        SYRUPCRAFTING_TITLE = "Poor Sap",
        SYRUPCRAFTING_DESC = "Learn to craft Ipecaca Syrup to induce pooping in other creatures.",

        MOON_CAP_EATING_TITLE = "Moon Shroom Cloud",
        MOON_CAP_EATING_DESC = "Learn how to plant Moon Shrooms in Mushroom Planters, and release sleep-inducing spores when eating them.",

        MUSHROOMPLANTER_RATEBONUS_1_TITLE = "Mushroom Mastery I",
        MUSHROOMPLANTER_RATEBONUS_1_DESC = "Mushrooms planted in a Mushroom Planter grow a little faster.",

        MUSHROOMPLANTER_RATEBONUS_2_TITLE = "Mushroom Mastery II",
        MUSHROOMPLANTER_RATEBONUS_2_DESC = "Mushrooms planted in a Mushroom Planter grow much faster.",

        MUSHROOMPLANTER_UPGRADE_TITLE = "Mushroom Multiplier",
        MUSHROOMPLANTER_UPGRADE_DESC = "Mushrooms planted in a Mushroom Planter produce a higher yield.",

        COUNT_LOCK_1_DESC = "Learn enough left-branch skills to unlock.",

        LUNAR_GEAR_1_TITLE = "Lunar Guardian I",
        LUNAR_GEAR_1_DESC = "Seize foes and keep them rooted in place while wearing Brightshade Armor.\nFuse Bramble Husks with Brightshade armor to create Brambleshade armor.",

        LUNAR_GEAR_2_TITLE = "Lunar Guardian II",
        LUNAR_GEAR_2_DESC = "Summon vines to join the fray while attacking with Brightshade melee weapons.",

        --LUNAR_GEAR_3_TITLE = "Lunar III",
        --LUNAR_GEAR_3_DESC = "Seize foes and keep them rooted in place with your Brightshade Armor.", - removed

        --
        IDENTIFY_PLANTS_TITLE = "Seed Sleuth",
        IDENTIFY_PLANTS_DESC = "Learn to identify seeds that have just been planted, to determine what they will grow into.",

        BLOOMING_SPEED1_TITLE = "Growth Spurt I",
        BLOOMING_SPEED1_DESC = "Reach full bloom a bit quicker.",

        BLOOMING_SPEED2_TITLE = "Growth Spurt II",
        BLOOMING_SPEED2_DESC = "Reach full bloom much quicker.",

        BLOOMING_MAX_UPGRADE_TITLE = "Flower Power",
        BLOOMING_MAX_UPGRADE_DESC = "Fertilization of Wormwood is boosted 30%.",

        BLOOMING_PHOTOSYNTHESIS_TITLE = "Photosynthesis",
        BLOOMING_PHOTOSYNTHESIS_DESC = "Slowly regenerate health when exposed to daylight in full bloom.",

        BLOOMING_OVERHEATPROTECTION_TITLE = "Shade Plant",
        BLOOMING_OVERHEATPROTECTION_DESC = "Gain increased protection from overheating when in full bloom.",

        BLOOMING_FARMRANGE1_TITLE = "Farmhand",
        BLOOMING_FARMRANGE1_DESC = "Tend farm plants within a larger range while full bloom.\nHarvest farm plants faster.",

        QUICK_SELFFERTILIZER_TITLE = "Compost Care",
        QUICK_SELFFERTILIZER_DESC = "Heal faster with Compost Wraps.",

        BLOOMING_TRAPBRAMBLE_TITLE = "Bramble Trap Specialist",
        BLOOMING_TRAPBRAMBLE_DESC = "Reset nearby Bramble Traps while in full bloom.",

        ARMOR_BRAMBLE_TITLE = "Bramble Husk Specialist",
        ARMOR_BRAMBLE_DESC = "Every three-hit attack streak you land without taking damage triggers a burst of spikes from your Bramble Husk.",

        BUGS_TITLE = "Bee Kind",
        BUGS_DESC = "Bees and Butterflies will tolerate Wormwood, unless provoked.",

        COUNT_LOCK_2_DESC = "Learn enough right-branch skills to unlock.",

        LUNAR_MUTATIONS_1_TITLE = "Lunar Cultivator I",
        LUNAR_MUTATIONS_1_DESC = "Tap into your lunar roots to transform Carrots into Carrats.\nCarrats you've created will retrieve food they find on the ground.",

        LUNAR_MUTATIONS_2_TITLE = "Lunar Cultivator II",
        LUNAR_MUTATIONS_2_DESC = "Tap into your lunar roots to transform Lightbulbs into Bulbous Lightbugs.\nBulbous Lightbugs you've created will follow you around.\nThe more Lightbugs grouped together, the larger their light will glow.",

        LUNAR_MUTATIONS_3_TITLE = "Lunar Cultivator III",
        LUNAR_MUTATIONS_3_DESC = "Tap into your lunar roots to transform Dragon Fruit into Saladmanders.\nSaladmanders you've created will attack things you do.\nTransforming maximum Saladmanders gives them a health boost.",
    },

    WORTOX = {
        -- GENERIC - Not skills but information boxes the player will be able to hover over for more information.
        WORTOX_INCLINATION_METER_TITLE = "The Scales",
        WORTOX_INCLINATION_METER_DESC = "Based off of how many Nice or Naughty skills selected, you will find yourself leaning towards a certain inclination. Choosing an affinity skews the scales and you will find your inclination coming sooner.",
        WORTOX_INCLINATION_NICE_TITLE = "Nice Inclination",
        WORTOX_INCLINATION_NICE_DESC = "Your kindness has made your monster side no longer stir up trouble.\nEating or releasing Souls will change sanity at an increased amount.",
        WORTOX_INCLINATION_NAUGHTY_TITLE = "Naughty Inclination",
        WORTOX_INCLINATION_NAUGHTY_DESC = "Your greed stops you from overloading of Soul power, for a moment.\nEating or releasing Souls will no longer change sanity. Souls heal you for less.",

        -- LOCKS
        WORTOX_NICE_LOCK_DESC = "Requires the skill below and 5 total Nice and/or Neutral skills to unlock.",
        WORTOX_NAUGHTY_LOCK_DESC = "Requires the skill below and 5 total Naughty and/or Neutral skills to unlock.",

        -- NICE
        WORTOX_LIFEBRINGER_1_TITLE = "Lifebringer I",
        WORTOX_LIFEBRINGER_1_DESC = "Learn how to channel Souls into a Twintailed Heart, a creation used to revive ghostly friends.",
        WORTOX_LIFEBRINGER_2_TITLE = "Lifebringer II",
        WORTOX_LIFEBRINGER_2_DESC = "Your ghostly friends will no longer suffer health penalties when you revive them with a Twintailed Heart.",
        WORTOX_LIFEBRINGER_3_TITLE = "Lifebringer III",
        WORTOX_LIFEBRINGER_3_DESC = "Allow the Twintailed Heart to be used by another which will pull them to you from near or afar.\nUsing it yourself will free the Souls inside.",

        WORTOX_SOULPROTECTOR_1_TITLE = "Reaching Souls I",
        WORTOX_SOULPROTECTOR_1_DESC = "Dropped Souls will heal at an increased range.",
        WORTOX_SOULPROTECTOR_2_TITLE = "Reaching Souls II",
        WORTOX_SOULPROTECTOR_2_DESC = "Dropped Souls will move towards hurt players, and heal at an increased range.",
        WORTOX_SOULPROTECTOR_3_TITLE = "Soul Bastion I",
        WORTOX_SOULPROTECTOR_3_DESC = "Dropped Souls will do a second healing wave for a lower amount after a delay.",
        WORTOX_SOULPROTECTOR_4_TITLE = "Soul Bastion II",
        WORTOX_SOULPROTECTOR_4_DESC = "Dropped Souls will move faster towards hurt players, the second healing wave will happen quicker, and Souls are more efficient at healing multiple players.",

        WORTOX_LIFTEDSPIRITS_1_TITLE = "Lifted Spirits I",
        WORTOX_LIFTEDSPIRITS_1_DESC = "Souls waiting to be freed in a Soul Echo will enhance your movement speed.",
        WORTOX_LIFTEDSPIRITS_2_TITLE = "Lifted Spirits II",
        WORTOX_LIFTEDSPIRITS_2_DESC = "Soul Echo duration is increased.",
        WORTOX_LIFTEDSPIRITS_3_TITLE = "Reverberation",
        WORTOX_LIFTEDSPIRITS_3_DESC = "Soul Echo will happen a second time.\nThis does not decrease Soul Hop costs from the Map.",
        WORTOX_LIFTEDSPIRITS_4_TITLE = "Capricious Movement",
        WORTOX_LIFTEDSPIRITS_4_DESC = "Soul Hop cost from the Map will be reduced by how much of the current world's land has been explored.",

        -- NEUTRAL
        WORTOX_PANFLUTE_PLAYING_TITLE = "Impromptu Flautist", -- Center
        WORTOX_PANFLUTE_PLAYING_DESC = "You periodically feel a musical pull to play your flute. Pan Flutes will not lose durability one time when feeling this urge to play.",
        WORTOX_PANFLUTE_SOULCALLER_TITLE = "Pleasant Pastorale", -- Left
        WORTOX_PANFLUTE_SOULCALLER_DESC = "Playing your Pan Flute with such pleasing notes will bring lost Souls around for a listen.",
        WORTOX_PANFLUTE_FORGET_TITLE = "Cloudy Carmen", -- Right
        WORTOX_PANFLUTE_FORGET_DESC = "Things waking up after your Pan Flute playing will not be able to become hostile towards you for a moment.",

        -- NAUGHTY
        WORTOX_THIEF_1_TITLE = "Soul Thief I",
        WORTOX_THIEF_1_DESC = "Souls are created and attracted to you from further away.",
        WORTOX_THIEF_2_TITLE = "Soul Thief II",
        WORTOX_THIEF_2_DESC = "Souls will last longer while being attracted to you.",
        WORTOX_THIEF_3_TITLE = "Soul Pierce I",
        WORTOX_THIEF_3_DESC = "Souls attracted to you will hurt other creatures with Souls along its path.",
        WORTOX_THIEF_4_TITLE = "Soul Pierce II",
        WORTOX_THIEF_4_DESC = "Souls attracted to you will repel away initially before coming towards you.",

        WORTOX_NABBAG_TITLE = "Knabsacker",
        WORTOX_NABBAG_DESC = "You've hung around Krampus enough to create a Knabsack for your own item stealing desires. Packs a punch depending on how full your inventory is.",
        WORTOX_SOULJAR_1_TITLE = "Soul Jar",
        WORTOX_SOULJAR_1_DESC = "Learn how to craft and use a Soul Jar to store Souls for later use.\nSoul Jars will leak Souls over time when not in your inventory.",
        WORTOX_SOULJAR_2_TITLE = "Overflowing Greed",
        WORTOX_SOULJAR_2_DESC = "Holding Soul Jars increases your maximum Souls allowed to be held at once by 5 each, stopping you from overloading of Soul power.",
        WORTOX_SOULJAR_3_TITLE = "Covetous Collector",
        WORTOX_SOULJAR_3_DESC = "Held Souls and Souls inside of Soul Jars increases both the damage of the Knabsack and the damage of Souls, up to 100 total Souls collected.",

        WORTOX_SOULDECOY_1_TITLE = "Soul Decoy I",
        WORTOX_SOULDECOY_1_DESC = "Soul Hopping creates a Soul Decoy to draw the attention of attacking creatures that possess Souls. It will not create one for a Soul Echo.",
        WORTOX_SOULDECOY_2_TITLE = "Soul Decoy II",
        WORTOX_SOULDECOY_2_DESC = "Soul Decoys will stay around for a bit longer if they are unharmed, and damage the thing that hit the Decoy.",
        WORTOX_SOULDECOY_3_TITLE = "Soul Decoy III",
        WORTOX_SOULDECOY_3_DESC = "Soul Decoys will now explode and inflict damage on things lured by it or attacking you upon expiration.",

        -- AFFINITY
        WORTOX_ALLEGIANCE_LUNAR_TITLE = "Lunar Swindler",
        WORTOX_ALLEGIANCE_LUNAR_DESC = "The Cryptic Founder will reward your curiosity by showing you power from wearing a Brightshade Helm or Brightshade Armor. Souls waiting to be freed in a Soul Echo will absorb incoming damage, and expire the timer.",

        WORTOX_ALLEGIANCE_SHADOW_TITLE = "Shadow Harvester",
        WORTOX_ALLEGIANCE_SHADOW_DESC = "The Queen will reward your loyalty by unlocking power from wielding a Shadow Reaper. Souls waiting to be freed in a Soul Echo will cause damage dealt to spread out to close enemies or hit one target twice, and expire the timer.",
    },

    WURT = {
        WURT_AMPHIBIAN_SANITY_1_TITLE = "Mental Fluidity I",
        WURT_AMPHIBIAN_SANITY_2_TITLE = "Mental Fluidity II",
        WURT_AMPHIBIAN_TEMPERATURE_TITLE = "All-Weather Scales",
        WURT_AMPHIBIAN_THICKSKIN_1_TITLE = "Slippery Hide I",
        WURT_AMPHIBIAN_THICKSKIN_2_TITLE = "Slippery Hide II",
        WURT_AMPHIBIAN_HEALING_1_TITLE = "Hydrous Healing I",
        WURT_AMPHIBIAN_HEALING_2_TITLE = "Hydrous Healing II",
        WURT_MOSQUITO_CRAFT_1_TITLE = "Mosquito Incognito",
        WURT_MOSQUITO_CRAFT_2_TITLE = "Itchcraft I",
        WURT_MOSQUITO_CRAFT_3_TITLE = "Itchcraft II",

        WURT_CIV_1_TITLE = "Community Feeder I",
        WURT_CIV_1_2_TITLE = "Community Feeder II",
        WURT_CIV_2_TITLE = "Industrious Merm I",
        WURT_CIV_2_2_TITLE = "Industrious Merm II",
        WURT_CIV_3_TITLE = "Hardheaded I",
        WURT_CIV_3_2_TITLE = "Hardheaded II",

        WURT_MERM_KING_HUNGER_1_TITLE = "Sated Sovereign I",
        WURT_MERM_KING_HUNGER_2_TITLE = "Sated Sovereign II",
        WURT_MERM_KING_HUNGER_3_TITLE = "Sated Sovereign III",
        WURT_MERM_FLEE_TITLE = "Sensible Swamp Fighter",
        WURT_PATHFINDER_TITLE = "Swamp Pathfinder",

        WURT_LUNAR_ALLEGIANCE_1_TITLE = "Lunar Mutated Merm",
        WURT_LUNAR_ALLEGIANCE_2_TITLE = "Terra Mutation",
        WURT_SHADOW_ALLEGIANCE_1_TITLE = "Shadow Resurrection Merm",
        WURT_SHADOW_ALLEGIANCE_2_TITLE = "Terra Corruption",

        WURT_AMPHIBIAN_SANITY_1_DESC = "Restore some sanity over time when wet. The more wet you are, the more sanity you restore.",
        WURT_AMPHIBIAN_SANITY_2_DESC = "Restore a fair amount of sanity over time when wet.",
        WURT_AMPHIBIAN_TEMPERATURE_DESC = "Greatly reduce the effect of wetness on body temperature. It also fairly reduces wetness loss due to heat sources.",
        WURT_AMPHIBIAN_THICKSKIN_1_DESC = "Use wetness as protection. Damage will consume wetness instead of health.",
        WURT_AMPHIBIAN_THICKSKIN_2_DESC = "Use wetness as protection more effectively. It also make you slowly get wet as you step through the corrupted or mutated marsh turfs.",
        WURT_AMPHIBIAN_HEALING_1_DESC = "Slowly regenerate health when wet. The more wet you are, the more health you regenerate.",
        WURT_AMPHIBIAN_HEALING_2_DESC = "Regenerate health when wet more effectively. It also make you slowly get wet as you step through the corrupted or mutated marsh turfs.",
        WURT_MOSQUITO_CRAFT_1_DESC = "Learn to craft a cuddly buddy making Mosquitoes neutral to you.",
        WURT_MOSQUITO_CRAFT_2_DESC = "Learn to craft Mosquito based items: Skeeter Bomb, Fertilizzzer and Blood Shot.",
        WURT_MOSQUITO_CRAFT_3_DESC = "Master the use of the Mosquito based items.\n\nWith the help of Lil' Itchy, catch mosquitos right from the air.",

        WURT_CIV_1_DESC = "Learn to craft the Communal Kelp Dish to entice faster merm growth and to call in merms for action.",
        WURT_CIV_1_2_DESC = "Learn to craft the Superior Communal Kelp Dish, it holds more kelp for even faster merm growth and calling in merms for action.",
        WURT_CIV_2_DESC = "Learn to craft the Shoddy Tool Shed to equip your merm workers with Shoddy Tools.",
        WURT_CIV_2_2_DESC = "Learn to craft the Slightly Less Shoddy Tool shed, it provides Slightly Less Shoddy Tools.",
        WURT_CIV_3_DESC = "Learn to craft the Armermry to equip your Loyal Merm Guards with Swamp Brawler Helmets.",
        WURT_CIV_3_2_DESC = "Learn to craft the Superior Armermry, it provides Swamp Warrior Helmets.",

        WURT_MERM_KING_HUNGER_1_DESC = "Increase the Merm King's maximum hunger.",
        WURT_MERM_KING_HUNGER_2_DESC = "Increase the Merm King's maximum hunger even more.",
        WURT_MERM_KING_HUNGER_3_DESC = "Slow the Merm King's digestion, so he takes longer to get hungry.",
        WURT_MERM_FLEE_DESC = "Merm Guards will retreat from combat when low on health, and wait to be healed.",

        WURT_PATHFINDER_DESC = "Survivors near Wurt will move like her through the Marsh.",
        WURT_MERMKINGSHOULDERS_TITLE = "The King's Pauldron Quest",
        WURT_MERMKINGSHOULDERS_DESC = "Add stony armor to the King's statuesque shoulders for greater stoutness in your merm soldiers.",
        WURT_MERMKINGCROWN_TITLE = "The King's Crown Quest",
        WURT_MERMKINGCROWN_DESC = "Gift him a crown worn by kings long passed, and your merms will fight smarter so their lives may last.",
        WURT_MERMKINGTRIDENT_TITLE = "The King's Trident Quest",
        WURT_MERMKINGTRIDENT_DESC = "Offer this weapon best wielded at sea, and your merms will attack with the deftness of three.",

        WURT_ALLEGIANCE_LOCK_1_DESC = "Learn 12 skills to unlock.",
        WURT_LUNAR_ALLEGIANCE_1_DESC = "Grant your loyal merms the wondrous gift of Lunar mutation by feeding them Moon Shards.\nEmpower your mutant merms with Planar power using Pure Brilliance.",
        WURT_LUNAR_ALLEGIANCE_2_DESC = "Morph any piece of land into sweet sweet Marsh.",
        WURT_SHADOW_ALLEGIANCE_1_DESC = "Your merm followers may die, but their shadows live on.\nInfuse fallen merms' shadows with Planar power using Pure Horror.",
        WURT_SHADOW_ALLEGIANCE_2_DESC = "No land shall be safe from the dark and beautiful corruption of the Marsh.",
    },

    --[[WX78 = {
    },]]
}

STRINGS.SCRAPBOOK = {
    CATS = {
        FOOD = "Food",
        CREATURES = "Creatures",
        ITEMS = "Items",
        GIANTS = "Giants",
        THINGS = "Things",
        POI = "Points of\nInterest", --POI
        BIOMES = "Biomes",
        SEASONS = "Seasons",
    },

    SUBCATS = {
        SPIDER = "Spider",
        HALLOWEENORNAMENT = "Halloween Ornament",
        STATUE = "Statue",
        UPGRADEMODULE = "Upgrade Module",
        TRINKET = "Trinket",
        ORNAMENT = "Ornament",
        BOOK = "Book",
        SHADOW = "Shadow",
        TACKLE = "Tackle",
        TOOL = "Tool",
        ELEMENT = "Element",
        WEAPON = "Weapon",
        ARMOR = "Armor",
        ELIXER = "Elixir",
        CLOTHING = "Clothing",
        HAT = "Hat",
        BATTLESONG = "Battle Call",
        MUTATOR = "Mutator",
        CONTAINER = "Storage",
        FARMPLANT = "Farm Plant",
        WALL = "Wall",
        TURF = "Turf",
        POCKETWATCH = "Pocket Watch",
        WAGSTAFFTOOL = "Wagstaff Tool",
        OCEANFISH = "Ocean Fish",
        CLOCKWORK = "Clockwork",
        HOUND = "Hound",
        MERM = "Merm",
        PIG = "Pig",
        BIRD = "Bird",
        INSECT = "Insect",
        SHELL = "Shell",
        HAUNTEDTOY = "Haunted Toy",
        STRUCTURE = "Structure",
        TREE = "Tree",
        ATRIUM = "Ancient",
        SEAFARING = "Seafaring",
        CRAFTINGSTATION = "Crafting Station",
        BACKPACK = "Backpack",
        RIDING = "Beefalo Riding",
        COSTUME = "Stage Costume",
        WINTERSFEASTFOOD = "Winter's Feast Dish",
        SMALLEPIC = "Mini Giant",
        SLINGSHOTAMMO = "Slingshot Round",
        SLINGSHOTPART = "Slingshot Part",
        GESTALT = "Gestalt",
    },

    SANITYDESC ={
        NEGHIGH = "VERY SCARY",
        NEGMED = "QUITE SCARY",
        NEGSMALL = "A LITTLE SCARY",
        POSSMALL = "A LITTLE CALMING",
        POSMED = "QUITE CALMING",
        POSHIGH = "VERY CALMING",
    },

    FOODTYPE = {
        GENERIC = "GENERIC",
        MEAT = "MEAT",
        VEGGIE = "VEGGIE",
        ELEMENTAL = "ELEMENTAL",
        GEARS = "GEARS",
        HORRIBLE = "HORRIBLE",
        INSECT = "INSECT",
        SEEDS = "SEEDS",
        BERRY = "BERRY",
        RAW = "RAW",
        BURNT = "BURNT",
        ROUGHAGE = "ROUGHAGE",
        WOOD = "WOOD",
        GOODIES = "GOODIES",
        MONSTER = "MONSTER",
        LUNAR_SHARDS = "LUNAR SHARDS",
        CORPSE = "CORPSE",
    },

    DATA_NEEDS_INVESTIGATION = "This needs more investigation.",
    DATA_STACK = " ITEMS",

    DATA_PLANAR_DAMAGE = " PLANAR DAMAGE",
    DATA_PLANAR_DEFENSE = " PLANAR DEFENSE",
    DATA_RANGE = " RANGE",
    DATA_USES = " USES",
    DATA_ARMOR_ABSORB = "ABSORBS ",
    DATA_WETNESS = "STOPS ",
    DATA_PERSEC = " / SEC",
    DATA_PERMIN = " / MIN",
    DATA_SEWABLE = "REPAIRED\nBY SEWING",
    DATA_FLOAT_RANGE = "CAST RANGE ",
    DATA_FLOAT_ACCURACY = "ACCURACY ",
    DATA_NOBREAK = "DOES NOT BREAK",
    DATA_SPLASHDAMAGE = " SPLASH DAMAGE",
    DATA_REPAIRABLE = "REPAIRED BY",

    DATA_LURE_CHARM = "LURE CHARM ",
    DATA_LURE_DIST = "BONUS RANGE +",
    DATA_LURE_RADIUS = "LURE RADIUS ",

    DATA_OAR_VELOCITY = "MAX SPEED ",
    DATA_OAR_FORCE = "FORCE ",

    SELECT_INFO_PAGE = "Left Page",
    SELECT_ITEM_PAGE = "Right Page",
    NEW_SCRAPBOOK_ENTRY = "Scrapbook\nUpdated",
    CLEARFLASH = "Clear all \"NEW\"",
    DATA_SECONDS = "SECONDS",
    DATA_MINUTE = "MINUTE",
    DATA_MINUTES = "MINUTES",
    DATA_DAY = "DAY",
    DATA_DAYS = "DAYS",
    DATA_TIME = "{time} {txt}",
    DATA_CRAFTING = "CRAFTABLE",
    DATA_LIGHTBATTERY = "EMITS LIGHT",

    DATA_WORKABLE_HAMMER = "CAN BE HAMMERED",
    DATA_WORKABLE_CHOP = "CAN BE CHOPPED",
    DATA_WORKABLE_DIG = "CAN BE DUG",
    DATA_WORKABLE_MINE = "CAN BE MINED",

    DATA_PICKABLE = "CAN BE PICKED",
    DATA_STEWER = "CAN PREPARE FOOD",
    DATA_FISHABLE = "CAN BE FISHED",
    DATA_HARVESTABLE = "CAN BE HARVESTED",
    DATA_BURNABLE = "CAN BE BURNED",
    DATA_NON_PLAYER_FOOD = "NON-SURVIVOR FOOD",
    DATA_INSULATION = " INSULATION",
    DATA_SNOWMANDECO = "SNOWMAN DECOR",

    NOTE_SHADOW_ALIGNED = "SHADOW ALIGNED",
    NOTE_LUNAR_ALIGNED = "LUNAR ALIGNED",

    CYCLE_VIEW = "Cycle Layout",
    CYCLE_CAT = "Cycle Category",
    CYCLE_QUOTES = "Cycle Quotes",
    SEARCH = "Search",
   -- CANCEL_SEARCH = "Cancel Search",

    SPECIALINFO ={
        -- Creatures.
        CHESTER = "Things can be stored in Chester much like a chest.",
        HUTCH = "Things can be stored in Hutch much like a chest.",
        BEEFALO = "Watch out for an aggressive mating season.\n\nFeed and care for one of these beasts, and maybe you can saddle them.",
        BERNIE = "A powerful friend when Willow's mind approaches insanity.",
        CANARY = "Sensitive to vapours, they tend to die when monstrous poisons are detected nearby.",
        POLLYROGERS = "Gathers loot nearby.",
        SALTY_DOG = "Gathers loot nearby, and after swimming in the Ocean for a bit will shed Salt Crystals.",
        MOLE = "Ever played \"Whack-A-Mole\"? What a great game.",
        POWDERMONKEY = "Best keep a bribe handy for these freebooters.",

        -- Items.
        ABIGAIL_FLOWER = "Used by Wendy to call her Ghostly sister Abigail.",
        CURSEDMONKEYTOKEN = "Seems like it takes some special magic to get rid of these wonky things.",
        BEEHAT = "The protection this hat offers only really works on Bees and Bee-like creatures.",
        HIVEHAT = "Makes scary things around you relaxing instead.",
        ARMORBONE = "Every 5 seconds, one incoming hit will be completely ignored.",
        SKELETONHAT = "Wearing this will drive you instantly insane; even the shadows will tolerate you.",
        ARMORBRAMBLE = "This thorny husk deals its damage when attacked.",
        ARMORDREADSTONE = "This armor slowly repairs itself.",
        DREADSTONEHAT = "This helm slowly repairs itself.",
        EYEMASKHAT = "Feed this hungry eye to restore it.",
        ARMORMARBLE = "This armor is durable but heavy, and slows its wearer.",
        ARMORSANITY = "This armor blocks damage, but has a nasty habit of driving its wearer insane.",
        ARMORDRAGONFLY = "Wrapped in the scales of the Dragonfly, it makes you immune to fire.",
        ARMORSNURTLESHELL = "One can tuck inside this hard shell to survive any assault.",
        RUINSHAT = "Frequently, hits on this crown will cause it to create an impenetrable barrier for a short time.",
        VOIDCLOTHHAT = "Damage from Shadow Planar damage weapons will ramp up with consecutive hits if you can keep attacking.\nGetting hit will break this damage chain.",
        VOIDCLOTHARMOR = "Wearing this scary robe makes you not care about how scary everything around you is.",
        BATHBOMB = "Makes a hot spring all warm, steamy, and glassy when dropped in.",
        BATTLESONG_SANITYAURA = "Scary creatures seem about half as frightening when you're listening to this beautiful song.\n\nThis is a Battle Song. Wigfrid must continue to sing for its benefit.",
        BATTLESONG_DURABILITY = "Reduce wear on your weapons by 25% while listening.\n\nThis is a Battle Song. Wigfrid must continue to sing for its benefit.",
        BATTLESONG_HEALTHGAIN = "Wigfrid and nearby allies will heal when fighting. Wigfrid will heal a little more too.\n\nThis is a Battle Song. Wigfrid must continue to sing for its benefit.",
        BATTLESONG_SANITYGAIN = "Wigfrid and nearby allies will restore sanity when fighting.\n\nThis is a Battle Song. Wigfrid must continue to sing for its benefit.",
        BATTLESONG_FIRERESISTANCE = "Wigfrid and nearby allies will not take fire damage.\n\nThis is a Battle Song. Wigfrid must continue to sing for its benefit.",
        BATTLESONG_INSTANT_TAUNT = "Draw the attention of nearby enemies.\n\nThis is a Battle Stinger as it completes in an instant.",
        BATTLESONG_INSTANT_PANIC = "Panic nearby enemies.\n\nThis is a Battle Stinger as it completes in an instant.",
        BATTLESONG_INSTANT_REVIVE = "Revive up to 2 nearby allied players.\n\nThis is a Battle Stinger as it completes in an instant.",
        BATTLESONG_SHADOWALIGNED = "Wigfrid and nearby allies take 10% less damage from Shadow Aligned enemies and deal 5% bonus damage to Lunar Aligned enemies.\n\nThis is a Battle Song. Wigfrid must continue to sing for its benefit.",
        BATTLESONG_LUNARALIGNED = "Wigfrid and nearby allies take 10% less damage from Lunar Aligned enemies and deal 5% bonus damage to Shadow Aligned enemies.\n\nThis is a Battle Song. Wigfrid must continue to sing for its benefit.",
        BEEF_BELL = "Name and bond with one Beefalo at a time. Bonded Beefalo will follow the holder, even into caves and offline.",
        PLANTABLE_FERTILIZE = "This needs some fertilizing after planting.",
        SCANDATA = "Data is used to craft Circuits for WX-78.",
        WX78SCANNER = "Chirps when interesting biological targets are nearby.\n\nWill chase and scan interesting biological targets while WX-78 is close.\n\nDrops Bio Data when finished.",
        MOONEYE = "Always appears on the minimap, even in unexplored areas.",
        BOATPATCH = "Plugs leaks on boats.",
        LIFEINJECTOR = "Restores lost \"maximum health\".",
        ALTARPLUG = "It looks like it plugs into something.",
        WX78MODULEREMOVER = "Removes installed Circuits from WX-78.",
        RESKINTOOL = "Cycles through the skins on in-world items.",
        POCKETWATCHDISMANTLER = "Break pocket watches down into their original ingredients other than Nightmare Fuel.",
        ARMORSLURPER = "Restores sanity over time and slows hunger drain by 40%.",
        COSTUME = "Costume piece used in stage plays.",
        CANDYBAG = "A 14 slots container for holding Candies, Trinkets, and Decorations.",
        SPICEPACK = "A 6 slots container that slows the spoiling of items inside.",
        BLUEAMULET = "Raises sanity while cooling the wearer.",
        PURPLEAMULET = "Wearer becomes insane.",
        REDAMULET = "A Ghost that haunts this amulet will be revived.",
        GREENAMULET = "Halves the cost of crafted items and raises sanity when worn.",
        ORANGEAMULET = "Automatically picks up items nearby and puts them in your inventory. Also raises sanity when worn.",
        YELLOWAMULET = "Emits light like a torch and gives a 20% speed boost while worn.",
        BEARGERVEST = "Hunger rate is slowed by 25% when worn.",
        BALLOONVEST = "Wearer will not suffer any drowning damage when they wash up on shore.",
        ICEPACK = "An 8 slots container that halves the speed of food spoiling inside.",
        PIGGYBACK = "A large 12 slots container that also slows the wearer by 10% when worn.",
        ONEMANBAND = "Wearing the One-Man Band is a sanity-lowering experience, but converts nearby pigmen and bunnymen to followers.",
        SEEDPOUCH = "A 14 slots container that will only hold seeds, nuts, and beans. Spoilage is slowed by 50%.",
        PIGCOIN = "Summons an Elite Pig.",
        COOKBOOK = "A record of all the foods cooked and/or eaten, as well as the ingredients used to cook them.",
        CRATEREDMOONROCK = "Contains a gem-shaped socket.",
        ORANGESTAFF = "When held, it increases speed by 25% and can teleport the user to visible locations at the cost of some sanity.",
        GREENSTAFF = "Turns crafted items and structures into their ingredient parts based on their remaining durability.\n\nGem ingredients are not returned.",
        YELLOWSTAFF = "Creates a Dwarf Star.",
        PURPLESTAFF = "Teleports targets to a random location or to a fueled Telelocator Focus.",
        BLUESTAFF = "Shoots freezing projectiles.",
        REDSTAFF = "Shoots projectiles that ignite targets on fire.",
        ARMORLUNARPLANT = "Reflects damage back at enemies and even more for ones that are Shadow Aligned.",
        LUNARPLANTHAT = "Glows in the dark and augments the Brightshade Staff with 2 more projectile bounces.\nAdds +5 Planar Damage to weapons with Planar Damage.",
        DENBEDAZZLER = "Bedazzle a Spider Den to pacify the spiders nearby. Bedazzled dens do not grow.",
        TOWNPORTALTALISMAN = "When another survivor is channeling a Lazy Deserter, use this to teleport to them.",
        BOOK_TENTACLES = "Summon some unfriendly Tentacles nearby.",
        BOOK_BIRDS = "Summon up to 20 birds to land nearby.",
        BOOK_BRIMSTONE = "Bring down over a dozen uncontrolled lightning strikes.",
        BOOK_SLEEP = "Puts creatures nearby to sleep.",
        BOOK_HORTICULTURE = "Rapidly grow up to 10 nearby garden plants or fruiting bushes.",
        BOOK_HORTICULTURE_UPGRADED = "Rapidly grow up to 15 nearby garden plants or fruiting bushes.",
        BOOK_SILVICULTURE = "Grow grass, saplings, and trees nearby, but grass will need to be fertilized again sooner.",
        BOOK_FISH = "Summon a school of Ocean Fish nearby.",
        BOOK_FIRE = "Extinguishes all burning and smoldering fires nearby and creates or charges a Fiery Pen infused with that energy.",
        BOOK_WEB = "Create several turfs worth of Spider Webbing on the ground that slows creatures traveling on it.\n\nIt will go away after 2 minutes.",
        BOOK_TEMPERATURE = "Dries survivors nearby as well as setting their temperature to a nice 35 degrees.",
        BOOK_LIGHT = "Summons half a day of light to shine down. Will cause an earthquake in the caves.",
        BOOK_LIGHT_UPGRADED = "Summons 2 days of light to shine down. Will cause an earthquake in the caves.",
        BOOK_RAIN = "If it's raining, the rain will stop. If it's not raining, rain will start and also water nearby farm soil.",
        BOOK_MOON = "Sets the current moon stage to full.",
        BOOK_BEES = "Summons 2 Grumble Bee followers. Maximum 16 at a time.",
        BOOK_RESEARCH_STATION = "Gives nearby survivors a crafting charge. Each charge lets them craft the next item one tech level higher than normal.",
        WOLFGANG_WHISTLE = "Toggles Wolfgang's coaching skill on and off.",
        COMPOSTWRAP = "Wormwood will heal 8 health plus 1 health/sec for 32 seconds. Wormwood will also bloom for 4 minutes.\nThis also works as good fertilizer for gardening.",
        DUSTMERINGUE = "It's not food fit for a person.",
        BEEFALOTREAT = "Snacks for Beefalo.",
        BEEFALOFEED = "Snacks for Beefalo.",
        GHOSTLYELIXERREGENERATION = "Raises Abigail's health regeneration from 1 to 3 health per second. Lasts 1 day.\n\nWhen drunk by a non ghost wearing the Wraith's Wreath:\n\nHeals 1 health per second for 20 seconds.",
        GHOSTLYELIXERHEALING = "Raises Abigail's health regeneration from 1 to 20 health per second. Lasts 30 seconds.\n\nWhen drunk by a non ghost wearing the Wraith's Wreath:\n\nHeals 5 health per second for 20 seconds.",
        GHOSTLYELIXERSHIELD = "Doubles Abigail's shield duration from 0.5 seconds to 1 second. Lasts 1 day.\n\nWhen drunk by a non ghost wearing the Wraith's Wreath:\n\nGives the drinker a shield that will absorb a lot of damage from one hit and then goes on cool down for 10 seconds.",
        GHOSTLYELIXERATTACK = "Abigail will deal her nighttime damage during the day and dusk. Lasts 1 day.\n\nWhen drunk by a non ghost wearing the Wraith's Wreath:\n\nThe drinker can see in the dark as if they were a ghost.",
        GHOSTLYELIXERSPEED = "Abigail has a 75% speed boost for 1 day.\n\nWhen drunk by a non ghost wearing the Wraith's Wreath:\n\nHeavy objects won't slow the drinker down as much.",
        GHOSTLYELIXERRETALIATION = "Doubles Abigail's shield duration from 0.5 seconds to 1 second.\n\nAttacking creatures also take 20 damage.\n\nLasts 1 day.\n\nWhen drunk by a non ghost wearing the Wraith's Wreath:\n\nGives the drinker a shield that will absorb a lot of damage from one hit and then goes on cool down for 10 seconds. It also inflicts 20 damage to all nearby enemies.",
        GHOSTLYELIXERREVIVE = "Returns Abigail's level to 3.\n\nWhen drunk by a non ghost wearing the Wraith's Wreath:\n\nHeals the drinker for a little bit of sanity, fills a small amount of hunger and removes the health penalty of revival.",
        GHOSTLYELIXERSHADOW = "Boosts the curse Abigail inflicts on targets, so that now they receive an extra 10 Planar Damage when attacked.",
        GHOSTLYELIXERLUNAR = "Abigail inflicts an extra 10 planar damage when attacking and increases to 100 when Abigail is in Gestalt form.",
        FEATHERPENCIL = "Draws the closest item nearby onto a Mini Sign.",
        MINIFLARE = "Creates a flash in the sky that can be seen by all survivors on the minimap.",
        MEGAFLARE = "Creates a flash in the sky that can be seen by all survivors on the minimap.\n\nThis large flash will also draw the attention of some hostile creatures.",
        SADDLE_BASIC = "Can be put onto a Beefalo if it's willing.",
        SADDLE_WAR = "Can be put onto a Beefalo if it's willing. Slower than a regular saddle.",
        SADDLE_RACE = "Can be put onto a Beefalo if it's willing. Increases speed over a regular saddle.",
        SADDLE_WATHGRITHR = "Can be put onto a Beefalo if it's willing. Slower than a regular saddle.",
        PIGTOKEN = "Given to the Pig King to initiate a Wrestling Match.",
        WINTERSFEASTCOOKEDFOODS = "Captures the spirit of food when this is put on a Winter's Feast Table. The more, the merrier.",
        GUNPOWDER = "Will explode for 200 damage when lit.",
        MOONSTORM_GOGGLESHAT = "Improves vision in a storm.\n\nWill help locate mysterious holograms.",
        BALLOONHAT = "Protects from lightning strikes.",
        BEEFALOHAT = "Makes the wearer friendly to Beefalo in heat.",
        BUSHHAT = "Wearer can hide under the bush and will not be attacked by creatures as long as they didn't see the survivor hide.",
        MONKEY_MEDIUMHAT = "Reduces collision damage and decay damage on boats by half.",
        MONKEY_SMALLHAT = "Wearer will perform boat activities faster and uses half as much oar durability.",
        POLLY_ROGERSHAT = "Polly Roger will fly down and follow the wearer, fetching nearby items.",
        MERMHAT = "Merm will treat the wearer like a merm.",
        DESERTHAT = "Improves vision in a storm.",
        ALTERGUARDIANHAT = "When sanity is above 85%, Attacking will summon a minor Gestalt that also attacks the target for 42 damage, but costs 1 sanity each attack.\n\nIt is a source of light when worn. Spores stored in the hat can alter its light color.",
        WATERMELONHAT = "Wearer's wetness will slowly rise up to 33%",
        FEATHERHAT = "Roughly doubles the number of birds that will land near the wearer.",
        MUSHHAT = "Reduces hunger by 25%. Periodically Spawns Mushroom Spores.",
        PLANTREGISTRYHAT = "Researching garden plants at different stages of growth adds to the Plant Registery.",
        NUTRIENTSGOGGLESHAT = "Researching garden plants at different stages of growth adds to the Plant Registery.\n\nWearer can see the quantity of nutrients in farm soil.",
        ICEHAT = "Wearer's wetness will rapidly rises up to 50%. Slows the wearer by 10%.",
        BATNOSEHAT = "Restores 3.9 Hunger every 5 seconds.",
        MINERHAT = "Provides light for nearly one day.",
        MOLEHAT = "Allows wearer to view the world in a night vision mode that can see in the dark.",
        WALTERHAT = "Walter's sanity loss due to damage is halved.",
        KELPHAT = "As a Merm, Wurt reverses the sanity loss into sanity gain.",
        SPIDERHAT = "Up to 10 Spiders nearby will follow the wearer, but creatures who attack spiders will also attack the wearer.\n\nDoes not work on Spiders spawned by a Spider Queen.",
        ANTLIONHAT = "The wearer will dig up turf they are standing on and place turf when it is loaded with turf items.",
        SPIDER_HEALER = "Heals Webber for 8 Health and spiders in an area for 80 Health.",
        HEALINGSALVE = "Heals 20 Health.",
        BANDAGE = "Heals 30 Health.",
        SCRAPBOOKPAGE = "Adds missing information to your Scrapbook",
        FEATHERFAN = "Each use will put out fires, dry and cool survivors 50 degrees to as low as 2.5 degrees in an area.",
        MAPSCROLL = "Contains map data of the survivor who created it. Used to share map information.",
        MARBLEBEAN = "Can be planted in the ground.",
        MESSAGEBOTTLE = "Some messages are notes, some are maps to special locations.",
        LANTERN = "This item creates light for its duration.\n\nIt does not break when its duration is finished and can be refuled.",
        OPALSTAFF = "Creates a Polar Light.",
        MOONROCKIDOL = "When used at a Celestial Portal, the survivor can change to a different survivor.",
        MOSQUITOSACK = "Can be used to heal 8 health.",
        GHOSTFLOWER = "Used by Wendy to craft Ghostly Elixirs.",
        WINTERTREE_ORNAMENT = "Can be hung in special trees grown in a Festive Tree Planter.",
        PLANTABLE = "Can be planted in the ground.",
        POCKETSCALE = "Used to measure the weight of Ocean Fish.",
        POCKETWATCH_HEAL = "Rewinds Wanda's age 8 years. 2 minute cooldown.",
        POCKETWATCH_REVIVE = "Wanda can haunt the watch as a ghost to revive herself, breaking the watch. The watch can be used on a Survivor's skeleton to revive them at the skeleton. 4 minute cooldown.",
        POCKETWATCH_WARP = "Teleports Wanda to the location marked on the ground.\n\nThe younger wanda is, the further back in time the marked location will be. Wanda is invulnerable for a short time during the teleport.\n\n2 second cooldown.",
        POCKETWATCH_RECALL = "Used to mark a spot, and then used again to teleport to that spot.\n\n8 minute cooldown. Even works between the Cave and the Forest.",
        POCKETWATCH_PORTAL = "Used to mark a spot, and then used again to open a portal to that spot that lasts for 10 seconds.\n\nUsing the portal costs 20 Sanity.\n\nThe Rift Watch will become a Backtrek Watch after use.",
        POCKETWATCH_WEAPON = "When the fuel reaches 0, its damage drops to 27.",
        MULTIPLAYERPOTALMOONROCKPLANS = "It will change the Florid Postern into the Celestial Portal construction project.",
        RAZOR = "For shaving off beards and other hairy things.",
        PLANTABLE_SEASTACK = "Can be planted on Sea Stacks.",
        SEWINGKIT = "Restores up to 5 days of durability to items that can be repaired with the sewing kit.",
        SHADOWHEART = "A working heart that needs a new body.",
        THURIBLE = "Attracts Reanimated Skeletons to the holder.",
        HALLOWEEN_ORNAMENT = "Can be put on Totally Normal Trees as decoration.",
        SHELLCLUSTER = "Can be mined for Shell Bells.",
        SPIDERREPELLENT = "When used by webber, nearby aggressive spiders become passive and releases spiders following Webber.",
        SLURTLESLIME = "Will explode for 50 damage when lit. Also fuels Lanterns and Miner Hats.",
        WORTOX_SOUL = "Wortox can eat these to restore 25 Hunger and lose 5 Sanity.\n\nThey can be released to heal all survivors nearby, max healing is 20 health which drops 2 points for each extra survivor to a minimum of 5 health.\n\nHe can also spend Souls to Soul Hop which teleports him.\n\nIf Wortox holds more than 20 Souls, he will release half of them and lose 20 Sanity.",
        SUPERTACKLECONTAINER = "A 15 slots container for holding Tackle.",
        TACKLECONTAINER = "A 6 slots container for holding Tackle.",
        SPEEDYBALLOON = "When held, it increases movement speed by 30% which drops to 20% and then 10% as it decays.\n\nIf dropped on the ground before completely decaying, it will float into the air after 1.5 seconds and its location will appear on the minimap to all survivors.",
        PLANTABLE_ON = "Can be planted on the ground.",
        SPIDERGLAND = "Heals 8 Health when used on survivors or creatures.",
        EYEBONE = "Summons Chester when picked up. Chester will follow the holder. While Chester is alive, the eye will be open.",
        HUTCHFISHBOWL = "Summons Hutch when picked up. Hutch will follow the holder. While Hutch is alive, Star-Sky will be alive.",
        HALLOWEENPOTIONMOON = "Mutates some creatures and plants into their lunar mutated form.",
        STRAWROLL = "Sleeping in it restores 0.66 Sanity and 0.5 health per second, costing 1 Hunger per second.",
        FURROLL = "Sleeping in it restores 1 Sanity and 1 health per second, costing 1 Hunger per second. It also warms the user overtime.",
        HALLOWEENPOTIONFIRE = "Creates pretty sparkles when added to a fire.",
        SOILAMENDER = "Adds 8-32 Growth Formula nutrient to the ground depending in its fermentation level.\n\nWill also trigger Wormwoods bloom for 1 to 4 minutes depending on fermentation level.",
        SUSPICIOUSMARBLE = "A piece of broken marble sculpture.",
        REVIVER = "Gives the user 80 Sanity when given to a survivor's ghost.\n\nThe ghost will revive with a 25% max health penalty which can be recovered with a Booster Shot.",
        TERRARIUM = "I sure hope no one opens it, or worse, corrupts it.",
        HEATROCK = "Gains heat when near something hot, and cools near something cold.\n\nIt will warm or cool the holder depending on its temperature.",
        NIGHTMARETIMEPIECE = "While in the Cave, it reveals the state of dark magic saturation.",
        TILLWEEDSALVE = "Heals 8 Health and then 20 more Health over 1 minute.",
        HORN = "Causes up to 5 nearby Beefalo to follow the blower for the day.",
        PANFLUTE = "Puts nearby creatures to sleep.",
        TRAPTEETH = "After being planted on the ground, it will trigger when a creature walks near.\n\nIt needs to be reset after triggering. It can be picked up and moved.",
        TRAP = "Once set on the ground, it will trigger when an appropriately sized creature move nearby, capturing them.\n\nCollecting a captured trap will put the creature or loot in your inventory.\n\nTraps can be baited with appropriate food.",
        TREEGROWTHSOLUTION = "Grows trees up one stage. Can also restore 8 Growth Formula, 32 Compost and 8 Manure to Farm Soil.\n\nUsed on Wormwood will heal 2 Health and 1 Health a second for 32 seconds.",
        SEWINGTAPE = "Used to add 5 days of durability on an item that can be sewn. Can also plug a leak on a boat.",
        TURF = "Can be placed on dirt ground to change the type of ground.",
        VOIDCLOTHUMBRELLA = "While on the ground, it can be activated to create a barrier that protects survivors from rain and rain like effects.",
        WX78MODULE_MAXHEALTH = "Plugs into WX78's circuit board.\n\nRequires 1 socket and raises Maximum Health +50.",
        WX78MODULE_MAXSANITY1 = "Plugs into WX78's circuit board.\n\nRequires 1 socket and raises Maximum Sanity +40.",
        WX78MODULE_MAXSANITY = "Plugs into WX78's circuit board.\n\nRequires 2 sockets and raises Maximum Sanity +100.",
        WX78MODULE_MOVESPEED = "Plugs into WX78's circuit board.\n\nRequires 6 sockets and raises movment speed by 25%.",
        WX78MODULE_MOVESPEED2 = "Plugs into WX78's circuit board.\n\nRequires 2 sockets.\nThe first raises movement speed by 25%.\nThe second raises movement speed by 15%.\nThe third raises movement speed by 10%.\nSo the maxmimum speed boost can be 50%.",
        WX78MODULE_HEAT = "Plugs into WX78's circuit board.\n\nRequires 3 sockets and raises body temperature 20 degrees, increases spoil rate of inventory by 25% and increases drying rate by 10%. Will also warm nearby survivors.",
        WX78MODULE_NIGHTVISION = "Plugs into WX78's circuit board.\n\nRequires 4 sockets and lets the user see in the dark. Turns on at night and when entering the Caves.",
        WX78MODULE_COLD = "Plugs into WX78's circuit board.\n\nRequires 3 sockets and lowers body temperature 20 degrees and decreases spoil rate of inventory by 25%. Will also cool nearby survivors.\n\nIf WX78's wetness reaches 95%, it will drop to 0% and 2 Ice will be spawned.",
        WX78MODULE_TASER = "Plugs into WX78's circuit board.\n\nRequires 2 sockets and deals 20 electrical damage to WX78's attackers.\n\nThis module also makes WX78 immune to electrical damage.",
        WX78MODULE_LIGHT = "Plugs into WX78's circuit board.\n\nRequires 3 sockets and creates light.",
        WX78MODULE_MAXHUNGER = "Plugs into WX78's circuit board.\n\nRequires 2 sockets, increases Maximum Hunger by 100 points and reduces Hunger drain by 20%.",
        WX78MODULE_MAXHUNGER1 = "Plugs into WX78's circuit board.\n\nRequires 1 socket and increases Maximum Hunger by 40 points.",
        WX78MODULE_MUSIC = "Plugs into WX78's circuit board.\n\nRequires 3 sockets, raises Sanity of nearby survivors 5 points a minute and raises garden plant happiness one step.",
        WX78MODULE_BEE = "Plugs into WX78's circuit board.\n\nRequires 3 sockets, heals 5 Health every 30 seconds, gains 2 Sanity every minute and increases Maximum Sanity by 100 points.",
        WX78MODULE_MAXHEALTH2 = "Plugs into WX78's circuit board.\n\nRequires 2 sockets and increases Maximum Health by 150 points.",
        WAGSTAFF_TOOL = "An item used by a mysterious character to restrain static.",
        BATBAT = "Each attack drains 6.8 Health from living targets.\n\nIf the user is not at full health, it also drains 3.4 Sanity.",
        PADDLE = "Can Row in water to move a boat in a desired direction.",
        BOOMERANG = "You have to catch it once you throw it.",
        BRUSH = "Can be used on Beefalo to collect Beefalo Wool.\n\nIncreases Beefalo Obedience 40% and increases Beefalo domestication by 1.6% once per day.",
        BUGNET = "Catch small flying things and put them or their loot in your inventory.",
        THULECITEBUGNET = "Catch small flying things and put them or their loot in your inventory.",
        COMPASS = "Will reveal users location on the map to other survivors also holding a Compass.",
        CUTLESS = "Knocks items out of targets inventory.",
        WATERINGCAN = "Adds 25 points of wetness to Garden Soil per use.\n\nCan also put out fires and stop smouldering.",
        FENCEROTATOR = "Rotates rotatable structures like fences, signs and chairs.",
        HOE = "Use on Garden Soil to create dirt piles where survivors can plant seeds.",
        SADDLEHORN = "Removes saddles from a Beefalo without reducing saddle durability.",
        DUMBBELLRED = "When equipped Wolfgang can Lift to raise his Mightiness.\n\nWhen thrown it creates fire where it lands.",
        DUMBBELLBLUE = "When equipped Wolfgang can Lift to raise his Mightiness.\n\nWhen thrown it increases the coldness of creatures near where it lands.",
        DUMBBELLHEAT = "When equipped Wolfgang can Lift to raise his Mightiness.\n\nGains heat when near something hot, and cools near something cold.\n\nIt will warm or cool the holder depending on its temperature.",
        DUMBBELL = "When equipped Wolfgang can Lift to raise his Mightiness.",
        STAFFTORNADO = "Launches a tornado that moves around randomly damaging creatures and breaking structures.",
        NIGHTSTICK = "Creates light when held.\n\nDoes electrical damage which does more damage to wet targets.",
        SHIELDOFTERROR = "Can be repaired by feeding it food.",
        CHUM = "Attracts a school of fish when thrown into the ocean.",
        SLEEPBOMB = "When thrown, creates a cloud that will put creatures to sleep.",
        TORCH = "Creates a light when held.\n\nCan light targets on fire.",
        TRIDENT = "Can be Played to cause small geysers to shoot up from the ocean, doing damage to creatures and structures.",
        WATERBALLOON = "When thrown it puts out fires in a small area where it lands.\n\nIt will also cool targets 5 degrees and adds 20 wetness.",
        LIGHTER = "Can create light. Willow, Walter and Warly can use it to cook food.\n\nWill lose durability faster in the rain.",
        SPIDERWHISTLE = "Webber can use the whistle to wake up nearby spiders and spider dens.\n\nNearby spiders will stop attacking their targets and will also temporarily ignore food on the ground.",
        WALKINGSTICK = "Increases movement speed by 15% when held.",
        CANE = "Increases movement speed by 25% when held.",
        WOODCARVEDHAT = "Protects wearer from falling debris during earthquakes.",
        MINIFAN = "Cools the holder while they run.",
        FISHINGROD = "Catch fish in ponds.",
        OCEANFISHINGROD = "Catch fish in the ocean.\n\nUse bobbers and lures to increase your chances.",
        OCEANFISHINGLURERED = "Used with a Sea Fishing Rod.\n\nMost effective during the day time.",
        OCEANFISHINGLUREGREEN = "Used with a Sea Fishing Rod.\n\nMost effective during dusk.",
        OCEANFISHINGLUREBLUE = "Used with a Sea Fishing Rod.\n\nMost effective during the night.",
        OCEANFISHINGLUREHEAVY = "Used with a Sea Fishing Rod.\n\nAttracts only heavy fish of their species.",
        OCEANFISHINGLUREDROWSY = "Used with a Sea Fishing Rod.\n\nTires fish out faster.",
        OCEANFISHINGLURESNOW = "Used with a Sea Fishing Rod.\n\nOnly effective while it's snowing.",
        OCEANFISHINGLURERAIN = "Used with a Sea Fishing Rod.\n\nOnly effective while it's raining.",
        FLOAT = "Used with a Sea Fishing Rod.",
        BUNDLE = "Can be unwrapped to release items inside.",
        BUNDLEWRAP = "Can package up to 4 stacks of items into one item that can be unpacked later.",
        SPICE_GARLIC = "Can be added to Crock Pot food using a Portable Seasoning Station.\n\nEating a dish spiced with Garlic reduces the damage they take to their health by 33%.\n\nDuration 4 minutes.",
        SPICE_SUGAR = "Can be added to Crock Pot food using a Portable Seasoning Station.\n\nEating a dish spiced with Honey Crystals doubles their rate of Mining Chopping and Hammering.\n\nDuration 4 minutes.",
        SPICE_CHILI = "Can be added to Crock Pot food using a Portable Seasoning Station.\n\nEating a dish spiced with Chili Flakes adds 20% damage to their attacks.\n\nDuration 4 minutes.\n\nAlso raises temperature 15 degrees for 15 seconds.",
        SPICE_SALT = "Can be added to Crock Pot food using a Portable Seasoning Station.\n\nEating a dish spiced with Seasoning Salt grants 25% more healing for healing effects.\n\nDuration 4 minutes.",
        BLUEPRINT = "It teaches you how to build a specific thing.",
        WILLOWEMBER = "When a creature dies while on fire, they drop an etherial ember of some burnt essence of life.\n\nWhen Willow attunes with her lighter, eventually she can sense and collect Hot Embers with it.\n\nWillow can learn to use embers for a variety of Pyrokinetics.",

        -- things
        ATRIUMGATE = "A broken stone ring that has an empty socket at the base.",
        ATRIUMRUBBLE = "A crumbling object with writing that can be inspected.",
        ANIMALTRACK = "A footprint of an animal that was walking somewhere.",
        ARCHIVERESONATOR = "A mysterious device that burns arrows into the dirt.",
        TENTACLEPILLARHOLE = "A hole leading to a tunnel that leads somewhere else.",
        BOATCANNON = "Can be loaded with cannoballs.\n\nOnce loaded, it can be aimed to fire. The direction can be changed by standing next to it from different sides before aiming.",
        SACREDCHEST = "A container with 6 slots. Could be a 6 item combination lock, only Metheus knows.",
        TREASURECHEST = "A container with 9 slots.",
        MINOTAURCHEST = "A container with 12 slots.",
        DRAGONFLYCHEST = "A fireproof container with 12 slots.",
        DAYWALKERPILLAR = "Can be mined down to reveal a darker core made of harder material.",
        LUNARTHRALLPLANT = "Wraps itself around a growing plant blocking it from the survivors.",
        MASTUPGRADELAMP = "This item creates light for its duration.\n\nIt does not break when its duration is finished and can be refueled.",
        STAFFLIGHT = "Works like a campfire for its duration, creating light and heat and will ignite things nearby. It can also be used to cook food.",
		STAFFCOLDLIGHT = "Cools survivors and gives light for 2 days.",
        COLDFIRE = "Works like a campfire, but makes things colder instead of heating them.",
        MOONSTORMSTATIC = "An experiment being worked on by a mysterious hologram that requires the survivors help.",
        FARMPLOW = "Digs a tile of ground into farm soil that can be hoed to grow seeds into plants.",
        WATERTREEPILLAR = "This tree has a great canopy of leaves that shades the ground in an area bellow it and offers 35% protection from rain and cools survivor a small amount.",
        TREE = "Standing near a tree offers 35% protection from rain and cools survivor a small amount.",
        LOSTTOY = "Ghostly apparition of a spirit's lost toy.",
        STATUEGLOMMER = "A strange statue, reflecting the light of the moon during the day.",
        NEEDFERTILIZER = "Needs fertilization if transplanted.",
        HOTSPRING = "Hotsprings are like baths for some people.",
        EYETURRET = "A tower that shoots a ranged attack at hostile creatures and regenerates 12 Health a second.",
        MOON_ALTAR_ROCK = "An object trapped inside moon rock.",
        BOAT_BUMPER_KELP = "Absorbs collision damage of the boat it is mounted on. Can be repaired with Kelp.",
        BOAT_BUMPER_SHELL = "Absorbs collision damage of the boat it is mounted on. Can be repaired with Broken Shells.",
        OCEANTREE = "Standing near a tree offers 35% protection from rain and cools survivor a small amount.\n\nWith help, it can grow to gigantic size.",
        MASTUPGRADELIGHTNINGCONDUCTOR = "Lightning that would strike nearby will instead strike this, charging it.",
        ALTERGUARDIANCONTAINED = "A contraption used by mysterious hologram.",
        LAVAPOND = "Raises the heat of Survivors nearby and will ignite nearby objects on fire.",
        SCULPTURE = "An incomplete sculpture.",
        NIGHTMARELIGHT = "When these emit light they become scarier draining 10 Sanity a second, and when fully illuminated they drain 15 sanity a second.",
        SANITYROCK = "A strange object that reacts to the sanity of those around it.",
        OCEANTRAWLER = "A container with 4 slots that eventually fills with fish. Once full, over time there is a chance the fish will break the net and escape.\n\nCan be filled with bait for a better chance of catching fish.",
        PONDCAVE = "If filled with acid, this pond will crust over with Nitre.",
        PUMPKINLANTERN = "Creates a small amount of light while it lasts.",
        SHADOWRIFTPORTAL = "A one way door of shadow that grows over time and then expires to pop up somewhere else some time later.",
        LUNARRIFTPORTAL = "A one way door of moon energy that grows over time and then expires to pop up somewhere else some time later.",
        CRITTERDEN = "Survivors can craft a pet from here to follow them around.",
        MERMTHRONE = "A nearby Merm will take up residence here and if fed, will grow into a King of Merms.",
        LUNARRIFTCRYSTAL = "A particularly hard material. Tools without special qualities may bounce off sometimes.",
        GROTTOPOOL = "The Moon Crater dirt infused water will form Moon Glass crystals if the water is clear and the light is right.",
        MUSHROOMSPROUT = "Strange mushroom stalks that grant the Toadstool extra strength, toughness and speed.",
        SCIENCEPROTOTYPER = "Standing near this device will provide the survivor with new things they can craft.\n\nCrafting something new for the first time gives a boost of 15 Sanity.\n\nOnce an item is crafted, the survivor will know how to craft that item even away from the machine.",
        ANCHOR = "When the anchor hits the bottom of the water, it will cause drag on the boats speed usually stopping it. The deeper the water, the longer the anchor will take to hit the bottom, and longer it will be to wheel it back up.",
        ARCHIVESECURITYDESK = "When powered and a survivor walks nearby, this device will release a ball of energy that then begins roaming the Archive Maze.",
        CROCKPOT = "A 4 slot container that will receive ingredients for food.\n\nPlacing 4 items in the container will allow them to be cooked creating some kind of food depending on the items put in to begin with.",
        ARCHIVERUNESTATUE = "An old object with writing that can be inspected.",
        CRAFTINGSTATION = "Standing near this device will provide the survivor with new things they can craft.",
        BEEBOX = "If there are 6 or more flowers around a bee box, bees will produce honey inside the bee box.",
        BEEFALOGROOMER = "A survivor can hitch a bonded beefalo to this groomer, and then add or change the Beefalo's clothing.",
        BIRDCAGE = "A bird can be placed in this cage.\n\nMake sure to feed the bird.\n\nIf the bird is fed fruit or vegetables, the bird will pass out seeds from those crops.\n\nIf the bird is fed meats, it may lay an egg.",
        BOOKSTATION = "A 20 slot container for Books and papyrus.\n\nBooks inside restore 1 durability every 30 seconds, double if Wickerbottom is close by.\n\nAlso, the library works like an Alchemy Engine, providing nearby survivors with new things they can craft.",
        LUNARFORGE = "Standing near this device will provide the survivor with new things they can craft that are based on Pure Brilliance.",
        SHADOWFORGE = "Standing near this device will provide the survivor with new things they can craft that are based on Pure Horror.",
        PORTABLETENT = "Sleeping in the tent restores 1 Sanity and 2 health per second, but costs 1 Hunger per second.\n\nAs a Pinetree Pioneer, it costs Walter 1 Hunger every 2 seconds instead.\n\nAlso wetness is reduced 1 per second as well temperature is raised to 40 degrees, at 1 degree per second.",
        CARTOGRAPHYDESK = "Allows survivors to craft Map Scrolls to exchange their map information.\n\nUsing Blueprints, Sketches, Costume Patterns, Scrapbook Pages, Adverts or Recipe Cards on this will turn them into blank Papyrus.",
        MOONALTAR = "Standing near this device will provide the survivor with new things they can craft.",
        COMPOSTINGBIN = "Can receive up to 6 \"wet\" and \"dry\" items. When it has at least 2 items, it begins composting.\n\nThe more items it has the faster it will produce compost.\n\nIt works faster if it has a ballance of \"wet\" and \"dry\" items.",
        COMPOST = "Will add 24 Nutrients when used on Farm Soil.",
        MEATRACK = "Certain items can be put on the rack and begin drying. After drying for some time, the item will turn into a dried version of itself.",
        COLDFIREPIT = "Works like a Fire Pit, but makes things colder instead of heating them.",
        FIREPIT = "While fueled, it creates light and heat.\n\nIt can also cook food into their cooked versions.\n\nIs not removed when its fuel is consumed.",
        CAMPFIRE = "While fueled, it creates light and heat.\n\nIt can also cook food into their cooked versions.\n\nIs removed when its fuel is used up.",
        WATERPUMP = "When placed on a boat, it can be manually operated  to draw water from the ocean to spray on nearby fires and smoldering items.",
        TROPHYSCALEFISH = "Survivors can put a fish in the bowl and it will show its weight.\n\nOnce full, only heavier fish will go in the scale and will kick out the lighter fish.",
        ARCHIVEDISPENCER = "An ancient device that ejects strange relics.",
        SCARECROW = "Keeps crows away, so that Canaries will come instead.\n\nYou can also dress it in skins collected in your wardrobe.",
        HERMITHOUSE = "The house of a Crabby Hermit that looks like it could use a fix up.",
        CATCOONDEN = "The den of a Catcoon and the place they store items they have carried off.\n\nThose items can be picked up here, but the Catcoon won't like it.",
        ICEBOX = "A container with 9 slots that can hold food items.\n\nItems inside will expire half as fast.",
        FIRESUPPRESSOR = "Can be turned on and off. While fueled and on, if a fire appears within its range, it will fling a snowball at it to put it out.",
        LIGHTNINGROD = "Lightning that would strike nearby will instead strike this, charging it.",
        MOONDEVICE = "A complex contraption to contain a geyser of energy that has several stages of construction.",
        MADSCIENCELAB = "Standing near this device will provide the survivor with new Experiments they can craft.",
        MAGICIANCHEST = "A 12 slot container that is actually a singular storage location that all \"magic storage\" items access.",
        --TOPHAT_MAGICIAN = "A 12 slot container that is actually a singular storage location that all \nmagic storage\n items access.",
        SEWINGMANNEQUIN = "Survivors can place equip slot items on this mannequin, and then they can use it to quick swap those items with what they are currently equipped with.",
        WINTERSFEASTOVEN = "Standing near this device will provide the survivor with special crafting options of \"Winters Feast food\" they can start cooking at this oven.",
        MAST = "It can be quickly unfurled and furled with effort. When unfurled the sail increases the boats forward velocity by 2.5.\n\nEach mast placed is 30% less efficient than the last.\n\nThe Steering Wheel can be used to rotate the forward direction of the Mast.",
        RESURECTIONSTATUE = "Once constructed, a single survivor can attune themselves to it for the cost of 40 Health.\n\nAfter attuning, when the survivor becomes as ghost, they can use the special button on the screen to respawn at the Effigy's location and it is destroyed.",
        MIGHTYGYM = "A structure constructable by Wolfgang to increase his Might by lifting at the right timing.\n\nIt requires two heavy objects be placed on its platforms to function. The higher the quality of the heavy objects, the more Might Wolfgang will get with each lift.",
        MOONDIAL = "The level of water reflects the current and upcoming state of the moon, overflowing with water during a full moon.",
        MUSHROOMLIGHT = "A container with 4 slots that will accept \nlight\n objects like Lightbulbs. The more items it has, the larger a radius of light it will create.",
        MUSHROOMFARM = "Requires some kind of mushroom or spore planted on it to start growing new mushrooms.\n\nIt takes nearly 4 days for it to reach maximum yield of Mushrooms when harvested.\n\nAfter being harvested 4 times it must be fertilized with a Living Log.",
        BOATMAGNET = "This structure must first be paired with a Nautopilot Beacon.\n\nAfter it is paired, it will pull itself towards the beacon.\n\nIf on a boat, it will increase the velocity of the boat in its direction.",
        NIGHTLIGHT = "When fueled, it creates light and drains Sanity of survivors around it at a rate of 3 per minute in the day and 8 per minute at night.",
        SENTRYWARD = "This device is a marker for the minimap as well it will keep an area of the minimap around it updated live.",
        FOSSILSTALKER =  "The fossilized skeleton of a strange beast.\n\nPaleontology is hard and it is hard to put old bones back together. Not all of the finished products are correctly assembled.",
        PIGTORCH = "A structure that creates light when fueled.\n\nPig Guards nearby will keep it fueled.",
        WINCH = "When constructed on a boat, its claw can be lowered into the water to grab objects deep under the water. If it finds something to grab, it will reel it up to the boat.",
        PORTABLECOOKPOT = "A 4 slot container that will receive ingredients for food.\n\nPlacing 4 items in the container will allow them to be cooked creating some kind of food depending on the items put in to begin with.\n\nIt can be dismantled back into an inventory item.",
        PORTABLEBLENDER = "Standing near this device will provide the survivor with new Seasonings they can craft.",
        PORTABLESPICER = "A container with 2 slots. One for a prepared food dish and one for a Seasoning.\n\nIf filled with one of each, it will spice the food with the provided seasoning.",
        SCULPTINGTABLE = "When an item of Cut Stone, Marble or Moon Glass is placed on the table, a nearby survivor will be able to craft the material into a chosen sculpture.",
        TROPHYSCALEOVERSIZEDVEGGIES = "Survivors can put a vegetable in the basket. If it is an oversized vegetable, it will show its weight.\n\nOnce full, only heavier vegetables will go in the scale and will kick out the lighter one.",
        RAINOMETER = "Once constructed it will indicate the weather or very soon to be weather.",
        RUINS_CHAIR = "A chair. You can sit in it.",
        SALTBOX = "A container with 9 slots that will accept food ingredient items.\n\nIt quadruples the time before the food will spoil",
        SALTLICK = "A constructed Saltlick will attract nearby Beefalo and other herd like animals.\n\nThey will lick the saltlick, eventually depleting it.\n\nBeefalo who use the saltlick will pause their domestication decay.",
        DRAGONFLYFURNACE = "Provides a small amount of light and a large amount of heat like a campfire. It may also be used to destroy items.",
        SIESTAHUT = "Useable in the day.\n\nSurvivor recovers 2 Health per second and 1 Sanity per second but consumes 0.33 Hunger per second. It also reduces 1 Wetness per second and lowers temperature 1 degree per second down to 40 degrees.",
        HOMESIGN = "When placed, it allows the survivor to write a message that can be read by themselves or other survivors later.",
        SISTURN = "A 4 slot container that can hold petals.\n\nWhen full of petals it raises nearby survivors Sanity by 25 per minute.\n\nAs well, Abigail's health regenerates 4x faster.\n\nWhen the petals rot, they will drop out of the container onto the ground as rot.",
        SPIDERDEN = "Creates a patch of webbing on the ground near it that slows survivors and some creatures that walk on it.\n\nComes in several sizes and grows to fit its spider population.\n\nWebber may upgrade these with Silk.",
        STEERINGWHEEL = "When deployed on a boat, a survivor can use it to rotate the boats direction.",
        TACKLESTATION = "Standing near this device will provide the survivor with new Lures and Floats they can craft.",
        CARPENTRY_STATION = "Standing near this device will provide the survivor with new Furniture they can craft.",
        TENT = "A survivor can use the tent at Dusk or Night.\n\nSurvivor recovers 2 Health per second and 1 Sanity per second but consumes 0.33 Hunger per second. It also reduces 1 Wetness per second and increases temperature 1 degree per second up to 40 degrees.",
        TURFCRAFTINGSTATION = "Standing near this device will provide the survivor with new Turf they can craft.",
        TOWNPORTAL = "At the cost of 15 Sanity, a survivor can activate the device and then consume 40 Sanity per minute while they keep it active. A second survivor can use another Lazy Deserter or a Desert Stone to teleport to the active one. The teleport costs 50 Sanity.",
        WINTEROMETOR = "This device tells you the current temperature between 0 and 35 degrees.\n\nIt turns blue during the Winter.",
        DUSTMOTHDEN = "If it is encrusted with Thulecite it can be mined off.",
        FISHBOX = "When placed on a boat or docks it is a 20 slot container that will hold sea life. Fish in the container will slowly unspoil.",
        WARDROBE = "A survivor can add, remove and change their outfit with collected skins.",
        MASTMALBATROSS = "It can be quickly furled and unfurled with effort. When unfurled the sail increases the boats forward velocity by 4.\n\nEach mast placed is 30% less efficient than the last.\n\nThe Steering Wheel can be used to rotate the forward direction of the Mast.",
        WINONACATAPULT = "In order to operate it must be powered by a nearby Generator or G.E.M.erator.\n\nWhen powered, it will automatically attack hostile creatures in range.",
        WINONABATTERYHIGH = "Gems must be socketed in order to have power. Each gem socketed adds 1/3 of the total charge available.\n\nWhen fully charged it has enough power to operate one device for 6 days.",
        WINONABATTERYLOW = "When fully charged, it has enough power to operate one device for 1 day.",
        WINONASPOTLIGHT = "When powered, it will shine a spotlight on the nearest survivor.\n\nIf there are more than 1 spotlight and more than one survivor nearby, they will priortize having different targets.",
        TABLEWINTERSFEAST = "Only special Winter's Feast dishes can be placed on this table.\n\nWhen the \"food\" on this table is \"eaten\" it gives a Winter's Cheer buff to the survivor.\n\nThe buff heals the survivor 0.5 Health per second, 10 Sanity per minute and 75 Hunger per day as well as halting the regular hunger drain.\n\nThe buff's duration is based on how grand the feast is. More tables connected together, more survivors feasting together and  a varied number of dishes will increase the duration of the buff.",
        TELEBASE = "This device requires 3 purple gems to be active\n\nA survivor that uses a Telelocator Staff will teleport to the nearest active Telelocator Focus and consume the gems.",
        TOADSTOOLCAP = "It can be chopped. Go ahead and chop it.\n\nPlease chop it.",
        TUMBLEWEED = "These bounce around the desert and collect junk along the way.\n\nAll sorts of crazy junk.\n\nYou'd be surprised.",
        MONKEYISLANDPORTAL = "A rift like spout from somewhere else, Monkeys and other debris keep dropping out of it.",
        WALLS = "Can be repaired using the inventory wall items.\n\nCan be build up 4 levels.",
        WALRUSCAMP = "A hunter's camp designed for Winter use.",
        WORMHOLE = "Jumping into this hole costs 15 points of Sanity.\n\nWhere will it come out?",
        LUNARPLANTKIT = "Will restore durability of tools and weapons crafted with Brightshade Husks.",
        VOIDCLOTHKIT = "Will restore durability of tools and weapons crafted with Dark Tatters.",
        MOONROCKSEED = "Standing near this device will provide the survivor with new items they can craft.",
        VOIDCLITHSCYTHE = "This tool will Reap harvestables in an area around it, not just a single item.",
        ANTLIONSINKHOLE = "Survivors will be slowed trying to walk across these.\n\nSomething must be making the ground weaker.",
        BEARGERFUR_SACK = "A carryable container with 6 slots that can hold prepared food.\n\nThe food stored in it will be preserved for a long time.",
        DEERCLOPSEYEBALL_SENTRYWARD = "Makes the surrounding environment cool, if holding a Deerclops Eyeball.\n\nWildfires will not occur nearby, also preventing plant withering. It affects how quickly things dry out, including soil moisture, and how quickly they perish.\n\nCreates Mini Glaciers around itself over time.",
        ARCHIVESWITCH = "How many Survivors does it take to change a lightbulb?",
        ORCHESTRINA = "Found deep in the long-forgotten archives of an ancient civilization, this noteworthy device is as melodious as it is mysterious. Solving its riddle might just be the key to unlocking a wellspring of ancient knowledge.",
        MOONALTARLINK = "It feels like there's a storm coming...",
        MOONBASE = "\"'Neath full moon's light, ye place the key;\nA rod whose call the stars doth heed.\nBut be ye warned, 'fore prize be claimed,\nSurvive the horde, lest ye be maimed.\"",
        CHARLIE_STAGE_POST = "A gift graciously bestowed to you by the Queen of the Constant, to enrich your sad, futile little lives. She was even kind enough to prepare costumes and a script!",
        OASISLAKE = "With this prime waterfront real estate in an otherwise unforgiving desert, Survivors can build their summer homes and take a break from deadly heat, wildfires, and dehydration!",
        HERMITCRAB = "This cantankerous crustacean isn't the easiest to get along with, but with a bit of time and care, you might just discover that there's more to her underneath that hard outer shell.",
        PIGKING = "Ruling his village with a cloven hoof, this head of swine is known to be firm but fair in his dealings with outsiders.",
        MONKEYQUEEN = "This banana-obsessed monarch has a gift for lifting curses, and presiding over her motley crew of privateering primates.",
        RESURRECTIONSTONE = "Tired of getting dead? Leave your worries behind by finding a handy Touch Stone!",
        BEEQUEENHIVE = "This enormous and extremely pokable beehive is packed with sweet honey and other surprises.",
        MULTIPLAYERPORTAL = "Enter and re-enter the amazing Constant again and again through this perennial portal.",
        ARMORWAGPUNK = "\"Well, A Rather Beautifully Intelligent System.\" Uses a complicated assortment of cogs and circuitry for computing.\n\nOnce a target has been selected, as long as it stays in range, the W.A.R.B.I.S. begins calculating optimal performance to fight the target.\n\nThe armor improves the wearer's speed as it analyzes the target, ending at a 30% speed boost.\n\nWhen combined with the W.A.R.B.I.S. headgear, the two will sync up for a few moments sharing target information.",
        WAGPUNKHAT   = "\"Well, A Rather Beautifully Intelligent System.\" Uses a complicated assortment of cogs and circuitry for computing.\n\nOnce a target has been selected, as long as it stays in range, the W.A.R.B.I.S. begins calculating optimal performance to fight the target.\n\nThe head gear improves the wearer's damage as it analyzes the target, ending at a 20% damage increase.\n\nWhen combined with the W.A.R.B.I.S. armor, the two will sync up for a few moments sharing target information.\n\nWearing the W.A.R.B.I.S. Head Gear also provides the wearer with a Dramatically Updating Diagram (or D.U.D.) which provides information on which target is currently being analyzed and what level the W.A.R.B.I.S. has reached.",
        WAGSTAFF_MACHINERY = "Seems like someone was just working here. Whatever they were making, I guess they finished it.",
        WAGSTAFF_MUTATIONS_NOTE = "\n\"Day 56 - Lunar Mutations Study\"\n\n\"It seems as though these strange entities that emerged from the rifts are in search of living hosts... or perhaps once living.\"\n\n\"NOTE: The following creatures warrant immediate study as I suspect they may be the most viable as hosts:\"\n\n• Frog\n• Pengull\n• Varg\n• Koalefant\n• Deerclops\n\n\"Other possible Rift entity host candidates:\"\n\n• Grass Gekko\n• Hound\n• Bearger\n• Mosling\n",

        SPEAR_WATHGRITHR_LIGHTNING = "Does electrical damage which does more damage to wet targets.",
        SPEAR_WATHGRITHR_LIGHTNING_CHARGED = "Does electrical damage which does more damage to wet targets.\n\nIncreases movement speed by 20% when held.\n\nIt can only be equipped by Wigfrids who have the \"Elding Spear Enhancement II\" skill.",
        WATHGRITHR_SHIELD = "Can be used to block attacks. Successfully blocking an attack decreases the block cooldown.\n\nIt can only be equipped by Wigfrids who have the \"Battle Rönd\" skill.",
        BATTLESONG_CONTAINER = "A carryable container with 8 slots that can hold Battle Songs and Battle Stingers.",
        EMBERLIGHT = "Works like a campfire for its duration, creating light and heat and will ignite things nearby. It can also be used to cook food.",
        BOOTLEG = "Can be thrown into the sea to create a pair of connected Whirlportals. Boats sailing close to them will be brought to the other entrance.",
        OCEANWHIRLPORTAL = "An ocean portal that allows boats to travel long distances.",

        -- Rifts / Meta QoL

        HEALINGSALVE_ACID = "Heals 20 Health and makes the survivor immune to Acid Rain for half of a day. Pacifies Snurtles and Slurtles for the duration.",

        BEESWAX_SPRAY = "Freeze the stage of a plant. This will make it unproductive, but also not attractive to parasites.",
        STORAGE_ROBOT = "An automaton capable of collecting and organizing items into containers. Store an item in a container next to it and it will know what to do!",

        SCRAP_MONOCLEHAT = "Expands the survivor's vision range. Convenient during the day, uncomfortable at night.",

        JUNK_PILE_BIG = "A towering pile of junk. There might be something surprising hiding inside...",

        -- Meta 4 / Ocean QoL

        ANCIENTFRUIT_GEM = "Even the heart of stone can be cracked by a little warmth... or perhaps a lot.",
        ANCIENTTREE_SEED = "An exotic seed that is very demanding on its growing conditions. There's a time and place for everything...",
        BOAT_ANCIENT = "A reinforced boat with a built-in 16 slots container. They don't build them like they used to.",
        BOAT_BUMPER_CRABKING = "A rock-like bumper that doesn't take damage when bumping into land. Take that, land!",
        BOATPATCH_KELP = "A temporary solution for leaks. Sprung a leak? Use a kelp patch... then another... and another...",
        MOSQUITOMUSK = "Containing \"essence de moustique\" making any holder seem friendly to wild mosquitos.",
        MOSQUITOBOMB = "Packed so tight with wriggling friends that the explosive release of bugs inflicts damage to targets nearby.",
        MOSQUITOMERMSALVE = "A useful healing device but only for Merms, after all, the Mosquitos are mostly full of Merm blood to begin with.",

        MERM_ARMORY = "While stocked with Cut Grass and Logs, Merm Guards will grab a Swamp Brawler Helmet from it, reducing its stores.\n\nSwamp Brawler Helmets are a cheap way for a Merm to get 50% protection from damage for a short while.",
        MERM_ARMORY_UPGRADED = "While stocked with Cut Grass and Logs, Merm Guards will grab a Swamp Warrior Helmet from it, reducing its stores.\n\nSwamp Warrior Helmets are a better design over their Brawler cousin, providing 70% resistance from damage for a longer period of time.",
        MERM_TOOLSHED = "While stocked with twigs and rocks, regular Merms will grab a Shoddy Tool from it, reducing its stores.\n\nShoddy Tools will increase the amount of work a Merm does for a short time.\n\nWith a Shoddy Tool, follower Merms will help chop trees, mine rocks, dig in a garden and till soil.",
        MERM_TOOLSHED_UPGRADED = "While stocked with twigs and rocks, regular Merms will grab a Slightly Less Shoddy Tool from it, reducing its stores.\n\nSlightly Less Shoddy tools increase the amount of work a Merm does a little more than their lesser sibling, the Shoddy Tool.\n\nWith a Slightly Less Shoddy Tool, follower Merms will help chop trees, mine rocks, dig in a garden and till soil.",

        OFFERING_POT = "Speeds up the respawning of Merms in Craftsmerm Houses, Merm Flort-ifications and Leaky Shacks.\n\nCan be used to call nearby Merms to come eat the kelp and follow the Merm who summoned them.",
        OFFERING_POT_UPGRADED = "Speeds up the respawning of Merms in Craftsmerm Houses, Merm Flort-ifications and Leaky Shacks.\n\nCan be used to call nearby Merms to come eat the kelp and follow the Merm who summoned them.",

        -- Rifts 4

        ARMOR_CARROTLURE = "Bunnymen are drawn to its alluring scent, powerful enough to mask the musk of meats.",
        CARPENTRY_BLADE_MOONGLASS = "Allows a Sawhorse equipped with it to build new things.",
        CHEST_MIMIC_REVEALED = "A heartless monster. It craves the taste of loot, and flesh.",
        ITEMMIMIC_REVEALED = "An annoying little creep that just wants to be held by you. Stomp it out quickly, before it does more creeping.",
        GELBLOB_STORAGE = "The Icker completely stops the spoilage of food placed in it.",
        RABBITHAT = "Blend in with the rabbits so they no longer flee from you in terror.",
        RABBITKING_AGGRESSIVE = "This Wrathful Rabbit King will show no mercy.",
        RABBITKING_LUCKY = "Catch a Fortuitous Rabbit for your free reward. But be warned, the reward may turn to punishment when carrying meat.",
        RABBITKING_PASSIVE = "This Benevolent Rabbit King will barter for your belongings.",
        RABBITKINGHORN = "Calls forth a Portable Den.",
        RABBITKINGHORN_CHEST = "A storage for your items and other trinkets accessible from Portable Dens.",
        RABBITKINGMINION_BUNNYMAN = "The Rabbit King commands with a Royal decree, your presence be removed no matter your plea.",
        RABBITKINGSPEAR = "It wards off Bunnymen, but trades your own mind for power against them in more ways than one.",
        SADDLE_SHADOW = "Can be put onto a Beefalo if it's willing. Faster than a regular saddle.",
        SHADOW_BATTLEAXE = "It can take down both creatures and trees. You can upgrade its stats, life steal and hunger, by defeating giants.\n\nThe weapon has 3 levels, and each level requires 3 giant kills to progress.",
        SHADOW_BEEF_BELL = "Bind a Beefalo to the bell. A bound Beefalo will follow the holder, even into the caves and offline.\n\nYou can also use this bell to revive a bound Beefalo.",
        SHADOWHEART_INFUSED = "A working heart that used to have a new body.",
        SHADOWTHRALL_MOUTH = "It lurks in the shadows... You'll need to find a way to expose it before you can attack it.",
        VOIDCLOTH_BOOMERANG = "A ranged weapon that launches three projectiles, dealing more damage the farther they travel.\n\nEquipping a Void Cowl gives an additional projectile. The Gloomerang also increases movement speed by 10% when held.",
        WORM_BOSS = "The ancestor of the Depths Worm is dangerous to attack while it's in motion.",

        -- HallowedNights2024

        PUMPKINCARVER = "Can be used to carve specific shapes on Giant Pumpkins.",

		-- WintersFeast2024

		SNOWMAN = "Roll'em! Stack'em! Decorate them with a variety of items!",

        -- Meta 5

        BANDAGE_BUTTERFLYWINGS = "Heals 24 health.\n\nIf used by Walter and he has learned the Field Medic skill, it will heal an additional 12 health, also restoring 10 sanity.",
        WOBY_TREAT = "Restores three times as much hunger when eaten by Woby.",
        ELIXIR_CONTAINER = "A carryable container with 9 slots that can hold Elixirs.",
        GHOSTFLOWERHAT = "When equipped, allows Wendy to drink Elixirs herself.",
        -- GHOSTLYELIXERLUNAR = "TODO",
        -- GHOSTLYELIXERREVIVE = "TODO",
        -- GHOSTLYELIXERSHADOW = "TODO",
        GRAVEGUARD_GHOST = "Where they appear, Evil Flowers tend to grow nearby.",
        GRAVEURN = "It is used to move Headstones.",
        PORTABLEFIREPIT_ITEM = "A portable campfire that stays lit even when packed!",
		SLINGSHOT_BAND_MIMIC = "It greatly increases how far you can shoot and how fast your ammo travels. It sometimes saves ammo by launching a mimic version of it.",
		SLINGSHOT_BAND_PIGSKIN = "It moderately increases how far you can shoot and how fast your ammo travels.",
		SLINGSHOT_BAND_TENTACLE = "It greatly increases how far you can shoot and how fast your ammo travels. It can be possessed by a heartless monster...",
		SLINGSHOT_FRAME_BONE = "Adds a backup ammo slot to your Slingshot.",
		SLINGSHOT_FRAME_GEMS = "Adds a special ammo slot to your Slingshot that is used for a secondary, alternate Slingshot attack, that extends any magic effects of your ammo to an area of effect.",
		SLINGSHOT_FRAME_WAGPUNK = "Expands the ammo slot to unlimited stack size, and adds a secondary, alternate Slingshot attack, that can be charged by holding down to deal up to 200% damage.",
		SLINGSHOT_FRAME_WAGPUNK_0 = "Adds a secondary, alternate Slingshot attack, that can be charged by holding down to deal up to 200% damage.",
		SLINGSHOT_HANDLE_JELLY = "It greatly increases your firing rate and prevents your Slingshot from slipping out of your hands.",
		SLINGSHOT_HANDLE_SILK = "It moderately increases your firing rate, which will ramp up if you shoot continuously.",
		SLINGSHOT_HANDLE_STICKY = "It moderately increases your firing rate, and prevents your Slingshot from slipping out of your hands.",
		SLINGSHOT_HANDLE_VOIDCLOTH = "It greatly increases your firing rate, which will ramp up if you shoot continuously.",
        SLINGSHOTAMMO_CONTAINER = "A carryable container with 6 slots that can hold Slingshot Rounds.",
		SLINGSHOTAMMO_THULECITE = "It has a chance to spawn a Shadow Tentacle on impact, which deals damage to your target.",
		SLINGSHOTAMMO_SLOW = "It slows down your target for 30 seconds, stacking up to 3 times.",
		SLINGSHOTAMMO_POOP = "It causes some targets to lose interest in you.",
        SLINGSHOTAMMO_DREADSTONE = "It has a 50% chance to not break on impact.",
		SLINGSHOTAMMO_GELBLOB = "It attaches an Icker blob to your target for 60 seconds, greatly slowing it down.",
        SLINGSHOTAMMO_GUNPOWDER = "It has an increasing chance to trigger an explosion, dealing double damage in a large area.",
		SLINGSHOTAMMO_HONEY = "It slows down ground targets for 8 seconds.",
		SLINGSHOTAMMO_HORRORFUEL = "It applies the Swarming Horror debuff to creatures it hits, dealing 10 planar damage periodically. Up to 4 Swarming Horrors can be stacked on each target.",
		SLINGSHOTAMMO_LUNARPLANTHUSK = "It has a chance to spawn a Brightshade Vine on impact, which deals planar damage to your target.",
        SLINGSHOTAMMO_MOONGLASS = "It deals damage in a medium area around its target.",
		SLINGSHOTAMMO_PUREBRILLIANCE = "It applies a Pure Brilliance mark to creatures it hits, lasting 30 seconds. This mark can be triggered by planar attacks for an additional 5 planar damage per hit.",
		SLINGSHOTAMMO_SCRAPFEATHER = "It deals electrical damage, which does more damage to wet targets. It can also trigger hit stun more often than other projectiles.",
        SLINGSHOTAMMO_STINGER = "It deals damage in a small area around its target.",
        SLINGSHOTMODKIT = "Allows you to customize your Slingshot.",
        BALATRO_MACHINE = "Some character named Jimbo wants you to play a card game with him.\n\nTo start, you should choose one of three Jokers. Each has a different way to give you a little edge in the game.\n\nSecond, play Poker. You can choose cards to discard and replace with new cards. You can do that twice.\n\nThen your hand will be evaluated. You will get chips based on the value of your cards. You will get a multiplyer based on the quality of your hand. Your Chips times your Multiplier is your points. Get as many points as you can. Jimbo might give you something for your time.",
        DECK_OF_CARDS = "Play a game of cards, however you like. Hit it to shuffle, but be careful!",
        PLAYING_CARD = "A single card for playing games! Combine these together to make a deck.",

        -- Rifts 5
        WAGBOSS_ROBOT_LEG = "Although the W.A.R.B.O.T. material failed to fully contain the Celestial Scion, it may still prove useful in protecting the survivors.",
        WAGBOSS_MISSILE = "These heat-seeking missiles lock onto the warmest thing they can find... So make sure that isn't you!",
        HERMITCRAB_RELOCATION_KIT = "Help Pearl find a new home! It might be tricky to find the perfect spot, but remember - she loves being near the ocean.",
        WANDERINGTRADER = "He travels between a few Points of Interest, looking for survivors to trade with. He gets new stock every couple of days, so be sure to check back in regularly!",
        LUNAR_SEED = "They came from an enlightened crown - so return them to one, to bask in eternal enlightenment.",

        -- rifts5.1
        WAGSTAFF_MATERIALS_NOTE = "\n\"Day 89 - Material Study\"\n\n\"Thulecite appears sufficient to contain lunar entities. Structural integrity holds under moderate strain. Further testing advised.\"\n",
        WAGSTAFF_ENERGY_NOTE = "\n\"Day 195 - Energy\"\n\n\"Eureka. Lunar forms radiate boundless energy. Containable. Obedient, even? Control may be possible. Endless applications... if stability holds.\"\n",
        WAGSTAFF_CONTAINMENT_NOTE = "\n\"Day 226 - Containment Measures\"\n\n\"Area of containment necessary prior to experimentation. Consider implementing a kinetic and teleportational dampening field?\"\n",
        WAGSTAFF_THERMAL_NOTE = "\n\"Day 354 - Heat Signature Detection\"\n\n\"Preliminary thermal tracking functional. However, response irregularities suggest vulnerability to rudimentary interference - false positives observed with minimal thermal masking.\"\n",
        WAGSTAFF_ELECTRICITY_NOTE = "\n\"Day 418 - Electrifying!\"\n\n\"Interesting. Can redirect controlled electric discharge for practical (and offensive) applications. Truly remarkable potential. Note to self: don appropriate insulative layers next time. That last zap was... unexpectedly exhilarating.\"\n",

        WAGBOSS_ROBOT_CONSTRUCTIONSITE = "Build the W.A.R.B.O.T. using only the most authentic parts.",
        WAGBOSS_ROBOT_CONSTRUCTIONSITE_KIT = "There is only one place that this contraption can go so that the containment barrier can do its part in stabilizing the energies used.",
        WAGBOSS_ROBOT_CREATION_PARTS = "Parts cut according to the correct specifications for W.A.R.B.O.T. construction.",
        MOONSTORM_STATIC_CATCHER = "Now you're the catcher!\nFind the energy running loose in the storms and try to restrain it.",
        COOLANT = "Essence of insight... Fuel of power... ...Bubbling.",

        FENCE_ELECTRIC = "\"Transdermal Induction Neurological Galvanic Learning Experience\" Uses electrolunetic technology to deliver shocks to conductive entities.\n\nOnce toggled, the T.I.N.G.L.E. node will search for another nearby node to link to, establishing an electric field between the two.\n\nNo physical harm is done (mental harm is up for debate). Most subjects will flee away after the brief shock.\n\nThe tester is recommended to use insulative gear to avoid this special learning experience!",
        FENCE_ELECTRIC_ITEM = "\"Transdermal Induction Neurological Galvanic Learning Experience\" Uses electrolunetic technology to deliver shocks to conductive entities.\n\nOnce toggled, the T.I.N.G.L.E. node will search for another nearby node to link to, establishing an electric field between the two.\n\nNo physical harm is done (mental harm is up for debate). Most subjects will flee away after the brief shock.\n\nThe tester is recommended to use insulative gear to avoid this special learning experience!",

        -- Rifts 6 and Rifts6.1
        TREE_ROCK = "The vines uproot more than boulders, depending on where they are planted.",
        SHADOWTHRALL_CENTIPEDE_HEAD = "Dense and unyielding, it will take great effort to crack its shell.",
        CAVE_VENT_ROCK = "These vents can billow out more than mere heat.",
        CAVE_VENT_MITE = "The Fumarole's cycle begins with the Geothermite.",
        OCEANWHIRLBIGPORTAL = "Hypnotically swirling, ever-drawing, it swallows all caught within its eye.\nHighly destructive to boats and structures alike.",
        OCEANWHIRLBIGPORTALEXIT = "A heap of sludge. Best dig in!",
        VAULT_LOBBY_EXIT = "The longer you gaze, the stronger the urge to leap.",
        VAULT_TELEPORTER = "Flashy transportation. Keep your gaze on the floor if you feel dizzy or disoriented.",
        VAULT_ORB = "A focus of intent for the Sanctum Waymark, drawing together those beyond.",
        VAULT_RUNE = "Engraved markings, enduring through eternity. Perhaps decipherable.",
        VAULT_TORCH = "The flame is calming. If only it would stay lit.",
        ABYSSPILLAR_MINION = "They block your path. Are they following a pattern?",
        ABYSSPILLAR_TRIAL = "The urge to pull this lever is... unusually strong.",
        MASK_ANCIENT_HANDMAIDHAT = "Costume piece used in stage plays.\nShe did what was necessary in service of her Queen.",
        MASK_ANCIENT_ARCHITECTHAT = "Costume piece used in stage plays.\nIs it better to face the bitter truth or embrace sweet ignorance?",
        MASK_ANCIENT_MASONHAT = "Costume piece used in stage plays.\nBetrayal begets the darkest of curses.",
        PLAYBILL_THE_DOLL = "Charlie's version of events.",
        PLAYBILL_THE_VEIL = "Shady promotional material.",
        PLAYBILL_THE_VAULT = "A grim testimony from the past, and a foreshadowing of what awaits.",

        -- Halloween 2025
        MUTATEDBUZZARD_GESTALT = "Beasts of carrion that have come from barren deserts and rocky plains. Watch out for their loony mutagens.",

        -- Winter's Feast 2025
        HERMITCRAB_TEASHOP = "Pearl's very own tea shop to provide you with riveting teas.",
        HERMITCRABTEA_PETALS = "Soothe your mind with this lovingly brewed concoction from Pearl.",
        HERMITCRABTEA_PETALS_EVIL = "Sour your mind with this brewed concoction from Pearl.",
        HERMITCRABTEA_FOLIAGE = "Protect your mind against scary foes with this lovingly brewed concoction from Pearl.",
        HERMITCRABTEA_SUCCULENT_PICKED = "Cool yourself with this lovingly brewed concoction from Pearl.",
        HERMITCRABTEA_FIRENETTLES = "Warm yourself with this lovingly brewed concoction from Pearl.",
        HERMITCRABTEA_TILLWEED = "Tend to your wounds with this lovingly brewed concoction from Pearl.",
        HERMITCRABTEA_MOON_TREE_BLOSSOM = "Scare off shadows of the night with this lovingly brewed concoction from Pearl.",
        HERMITCRABTEA_FORGETMELOTS = "Soothe your mind like nothing else can, with this exception brewed concotion from Pearl.",

        HERMITCRAB_LIGHTPOST = "String up pearlescent lights. Connects to Tea Shops and Pearl's Place too!",
    },

    -- Full name: "{name} Scrapbook Page"
    SPECIAL_SCRAPBOOK_PAGES =
    {
        UNKNOWN = "Lost",
    },
}

STRINGS.TEMP_BETA_MSG =
{
	RIFTS5_BASIC = "Thanks for playing the beta!\nBoss final phase and rewards coming soon...",
	RIFTS5_BASIC_NEW = "Thanks for playing the beta!",
	RIFTS5_KILLTIME_FMT = "You defeated {name} in {time}s.",
	--
	RIFTS6_BASIC = "Thanks for playing the beta!\nThe room beyond this point is not yet available.",
}

--Don't include this in pot generation as this file is already translated.
if POT_GENERATION == false then
    require "strings_pretranslated"

	for i, song in pairs(STRINGS.SONGS) do
		for i, v in ipairs(song.lines) do
			v.duration = v.duration ~= nil and tonumber(v.duration) or 2.5
			v.noanim = true
		end
	end
end

----------------------------------------------------------------------------
-- Include the names and descriptions of the clothing and craftable skins.
----------------------------------------------------------------------------
require "skin_strings"